<?php

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array();
$specialtemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');

// ############################# LOG ACTION ###############################
log_admin_action();

define('BATCH_NUMBERS',100);

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'manage_commands';
}

if ($_REQUEST['do'] == "manage_commands")
{
	print_cp_header($vbphrase['mgc_cb_evo_commands_mngt']);

	?>
	<script type="text/javascript">
	function js_page_jump(i, sid)
	{
		var sel = fetch_object("commandsel" + i);
		var act = sel.options[sel.selectedIndex].value;
		if (act != '')
		{
			switch (act)
			{
				case 'command_disable': page = "mgc_cb_evo.php?do=command_enable&what=0&cid="; break;
				case 'command_enable': page = "mgc_cb_evo.php?do=command_enable&what=1&cid="; break;
				case 'command_ugp_perms': page = "mgc_cb_evo.php?do=command_manage_perms&cid="; break;
				default: return;
			}
			jumptopage = page + sid + "&s=<?php echo $vbulletin->session->vars['sessionhash']; ?>";
			window.location = jumptopage;
		}
		else
		{
			alert('<?php echo addslashes_js($vbphrase['invalid_action_specified']); ?>');
		}
	}
	</script>
	<?php

	/** Command list **/

	/* Retrieving of the commands */
	print_form_header('mgc_cb_evo', 'command_mngt');
	construct_hidden_code('commandid', '');

	print_table_header($vbphrase['mgc_cb_evo_commands_list'], 4);
	print_cells_row(array($vbphrase['mgc_cb_evo_command_identifier'], $vbphrase['description'], $vbphrase['controls']), 1);

	// used for <select> id attribute
	$i = 0;

	$getcommands = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "mgc_cb_evo_command");

	while ($command = $vbulletin->db->fetch_array($getcommands))
	{
		$options = array();

		$options['command_ugp_perms'] = $vbphrase['mgc_cb_evo_command_edit_permissions'];

		if ($command['active'])
		{
			$options['command_disable'] = $vbphrase['disable'];
			$title =  $command['identifier'];
		}
		else
		{
			$options['command_enable'] = $vbphrase['enable'];
			$title = "<strike>" . $command['identifier'] . "</strike>";
		}

		$i++;

		print_cells_row(array(
			$title,
			"<div align=\"center\">" . $vbphrase['mgc_cb_evo_command_desc_' . $command['identifier']] . "</div>",
			"<div align=\"$stylevar[right]\">
				<select name=\"s$command[cid]\" id=\"commandsel$i\" onchange=\"js_page_jump($i, '$command[cid]')\" class=\"bginput\">
					" . construct_select_options($options) . "
				</select>&nbsp;<input type=\"button\" class=\"button\" value=\"" . $vbphrase['go'] . "\" onclick=\"js_page_jump($i, '$command[cid]');\" />
			</div>"
		), false, '', -2);
	}

	print_table_footer();
}

if ($_REQUEST['do'] == "command_enable")
{
	$vbulletin->input->clean_array_gpc('r', array(
		'cid' 	=> TYPE_UINT,
		'what'	=> TYPE_UINT
	));

	define('CP_REDIRECT', 'mgc_cb_evo.php?do=manage_commands');

	/* Disabling of the command */
	if (!$vbulletin->GPC['what'])
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "mgc_cb_evo_command SET active='0' WHERE cid='" . $vbulletin->GPC['cid'] . "'");
		print_stop_message('mgc_cb_evo_command_successfully_disabled');
	}
	else
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "mgc_cb_evo_command SET active='1' WHERE cid='" . $vbulletin->GPC['cid'] . "'");
		print_stop_message('mgc_cb_evo_command_successfully_enabled');
	}
}

if ($_REQUEST['do'] == 'command_manage_perms')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'cid' 	=> TYPE_UINT
	));

	/* Check if the command exist and fetch it */
	$command = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "mgc_cb_evo_command WHERE cid='" . $vbulletin->GPC['cid'] . "'");

	print_cp_header($vbphrase['mgc_cb_evo_command_permissions']);

	print_form_header('mgc_cb_evo','command_do_manage_perms');
	construct_hidden_code('cid', $vbulletin->GPC['cid']);

	print_table_header(construct_phrase($vbphrase['mgc_cb_evo_permissions_command_x'],$command['identifier']));

	$aux_array = array();
	$aux_array['membergroupids'] = $command['usergroupids'];
	print_membergroup_row($vbphrase['mgc_cb_evo_command_usergroupids'], 'usergroupids', 2, $aux_array);
	print_input_row($vbphrase['mgc_cb_evo_command_userids'], 'userids', $command['userids'], true, 35, 1000);

	/** The end **/
	print_hidden_fields();
	print_submit_row();
}

if ($_POST['do'] == 'command_do_manage_perms')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'cid' 			=> TYPE_UINT,
		'usergroupids'	=> TYPE_ARRAY_UINT,
		'userids'		=> TYPE_STR
	));

	define('CP_REDIRECT', 'mgc_cb_evo.php?do=manage_commands');

	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "mgc_cb_evo_command
		SET
			usergroupids = '" . implode(',',$vbulletin->GPC['usergroupids']) . "',
			userids = '" . $vbulletin->db->escape_string($vbulletin->GPC['userids']) . "'
		WHERE cid='" . $vbulletin->GPC['cid'] . "'
	");

	print_stop_message('mgc_cb_evo_command_permissions_edited_successfully');
}

if ($_REQUEST['do'] == 'manage_channels')
{
	print_cp_header($vbphrase['mgc_cb_evo_channels_mngt']);

	?>
	<script type="text/javascript">
	function js_page_jump(i, chanid)
	{
		var sel = fetch_object("channelsel" + i);
		var act = sel.options[sel.selectedIndex].value;
		if (act != '')
		{
			switch (act)
			{
				case 'channel_disable': page = "mgc_cb_evo.php?do=channel_enable&what=0&chanid="; break;
				case 'channel_enable': page = "mgc_cb_evo.php?do=channel_enable&what=1&chanid="; break;
				case 'channel_edit': page = "mgc_cb_evo.php?do=channel_update&what=edit&chanid="; break;
				case 'channel_delete':
					if(confirm("<? echo $vbphrase['mgc_cb_evo_are_you_sure_to_delete']; ?>"))
						page = "mgc_cb_evo.php?do=channel_delete&chanid=";
					else
						return;
					break;
				default: return;
			}
			jumptopage = page + chanid + "&s=<?php echo $vbulletin->session->vars['sessionhash']; ?>";
			window.location = jumptopage;
		}
		else
		{
			alert('<?php echo addslashes_js($vbphrase['invalid_action_specified']); ?>');
		}
	}
	</script>
	<?php

	print_form_header('mgc_cb_evo', 'channel_order_save');
	construct_hidden_code('channelid', '');

	print_table_header($vbphrase['mgc_cb_evo_channels'], 6);
	print_cells_row(array($vbphrase['title'], $vbphrase['mgc_cb_evo_order'], $vbphrase['description'], $vbphrase['mgc_cb_evo_warn_user'], $vbphrase['controls']), 1);

	/* Retrieving of the channels */
	$getchannels = $vbulletin->db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "mgc_cb_evo_channel
		ORDER BY chanorder ASC
	");

	print_cells_row(array(
		$vbphrase['mgc_cb_evo_general_channel'],
		"<div align=\"center\">0</div>",
		"<div align=\"center\">" . $vbphrase['mgc_cb_evo_general_channel_desc'] . "</div>",
		$vbphrase['yes'],
		$vbphrase['default']
	), false, '', -2);

	while($channel = $vbulletin->db->fetch_array($getchannels))
	{
		$options = array('channel_edit' => $vbphrase['edit']);

		if ($channel['active'])
		{
			$options['channel_disable'] = $vbphrase['disable'];
			$title =  htmlspecialchars_uni($channel['title']);
		}
		else
		{
			$options['channel_enable'] = $vbphrase['enable'];
			$title = "<strike>" . htmlspecialchars_uni($channel['title']) . "</strike>";
		}

		$options['channel_delete'] = $vbphrase['delete'];

		$i++;

		print_cells_row(array(
			$title,
			"<div align='center'><input type='input' class='input' size='5' name='chan_order[" . $channel['chanid'] . "]' value='" . $channel['chanorder'] . "' /></div>",
			htmlspecialchars_uni($channel['description']),
			($channel['warnon'] ? $vbphrase['yes'] : $vbphrase['no']),
			"<div align=\"$stylevar[right]\">
				<select name=\"s$channel[chanid]\" id=\"channelsel$i\" onchange=\"js_page_jump($i, '$channel[chanid]')\" class=\"bginput\">
					" . construct_select_options($options) . "
				</select>&nbsp;<input type=\"button\" class=\"button\" value=\"" . $vbphrase['go'] . "\" onclick=\"js_page_jump($i, '$channel[chanid]');\" />
			</div>"
		), false, '', -2);
	}


	print_description_row('<div align="center"><input type="submit" value="' . $vbphrase['mgc_cb_evo_save'] . '" />&nbsp;&nbsp;<input type="button" onclick="window.location=\'mgc_cb_evo.php?do=channel_update&what=add&s=' . $vbulletin->session->vars['sessionhash'] . '\'" value="' . stripslashes($vbphrase['mgc_cb_evo_add_channel']) . '"></div>',false,6,'tfoot');

	print_table_footer();
}

if ($_REQUEST['do'] == 'channel_update')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'chanid' 	=> TYPE_UINT,
		'what'	=> TYPE_STR
	));

	if ($vbulletin->GPC['what'] == "add")
	{
		print_cp_header($vbphrase['mgc_cb_evo_add_channel']);
		$channel['chanorder'] = 1;
	}
	else
	{
		/* Check if the channel exist and fetch it */
		$channel = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "mgc_cb_evo_channel WHERE chanid='" . $vbulletin->GPC['chanid'] . "'");

		if (!$channel)
		{
			print_stop_message('mgc_cb_evo_nonexisting_channel');
		}

		print_cp_header($vbphrase['mgc_cb_evo_edit_channel']);
	}

	print_form_header('mgc_cb_evo','channel_do_update');
	construct_hidden_code('what', $vbulletin->GPC['what']);
	construct_hidden_code('chanid', $vbulletin->GPC['chanid']);

	print_table_header($vbphrase['mgc_cb_evo_channel_information']);

	print_input_row($vbphrase['title'], 'title', $channel['title'], true, 35, 50);
	print_input_row($vbphrase['description'], 'description', $channel['description'], true, 35, 250);
	print_input_row($vbphrase['mgc_cb_evo_channel_image_name'], 'img_name', $channel['img_name'], true, 35, 50);

	print_input_row($vbphrase['mgc_cb_evo_order'], 'chanorder', $channel['chanorder'], true, 35, 100);
	print_yes_no_row($vbphrase['mgc_cb_evo_channel_warnon_new_message'], 'warnon', $channel['warnon'], 0);
	print_yes_no_row($vbphrase['mgc_cb_evo_channel_activate'], 'activate', $channel['active'], 0);

	print_table_break();

	print_table_header($vbphrase['mgc_cb_evo_channel_command_info']);

 	$aux_array = array();

	if (!empty($channel['usergroupids']))
	{
		$aux_array['membergroupids'] = $channel['usergroupids'];
	}

	print_membergroup_row($vbphrase['mgc_cb_evo_channel_usergroupids'], 'usergroupids', 2, $aux_array);
	print_input_row($vbphrase['mgc_cb_evo_channel_userids'], 'userids', $channel['userids'], true, 35, 1000);

	/** The end **/
	print_hidden_fields();
	print_submit_row();
}

if ($_POST['do'] == 'channel_do_update')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'chanid' 		=> TYPE_UINT,
		'what'			=> TYPE_STR,
		'title'			=> TYPE_STR,
		'description'	=> TYPE_STR,
		'img_name'		=> TYPE_STR,
		'chanorder'		=> TYPE_UINT,
		'syntax'      	=> TYPE_STR,
		'warnon'		=> TYPE_UINT,
		'usergroupids' 	=> TYPE_ARRAY_UINT,
		'userids'      	=> TYPE_STR,
		'activate'		=> TYPE_UINT
	));

	/* In case of edit, let's check if the chan exists */
	if ($vbulletin->GPC['what'] == 'edit')
	{
		$channel = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "mgc_cb_evo_channel WHERE chanid='" . $vbulletin->GPC['chanid'] . "'");

		if (!$channel)
		{
			print_stop_message('mgc_cb_evo_nonexisting_channel');
		}
	}

	/* Some checks */
	if (empty($vbulletin->GPC['title']) || empty($vbulletin->GPC['img_name']))
	{
		print_stop_message('mgc_cb_evo_missing_title_or_img_name');
	}

	define('CP_REDIRECT', 'mgc_cb_evo.php?do=manage_channels');

	/* Ready to add in the database */
	if ($vbulletin->GPC['what'] == 'add')
	{
		$vbulletin->db->query_write("
			INSERT INTO " . TABLE_PREFIX . "mgc_cb_evo_channel
			SET
				title='" . $vbulletin->db->escape_string($vbulletin->GPC['title']) . "',
				description='" . $vbulletin->db->escape_string($vbulletin->GPC['description']) . "',
				chanorder='" . $vbulletin->GPC['chanorder'] . "',
				img_name='" . $vbulletin->db->escape_string($vbulletin->GPC['img_name']) . "',
				warnon='" . $vbulletin->GPC['warnon'] . "',
				usergroupids = '" . implode(',',$vbulletin->GPC['usergroupids']) . "',
				userids = '" . $vbulletin->db->escape_string($vbulletin->GPC['userids']) . "',
				active='" . $vbulletin->GPC['activate'] . "'
		");

		print_stop_message('mgc_cb_evo_channel_added_successfully');
	}
	else
	{
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "mgc_cb_evo_channel
			SET
				title='" . $vbulletin->db->escape_string($vbulletin->GPC['title']) . "',
				description='" . $vbulletin->db->escape_string($vbulletin->GPC['description']) . "',
				chanorder='" . $vbulletin->GPC['chanorder'] . "',
				img_name='" . $vbulletin->db->escape_string($vbulletin->GPC['img_name']) . "',
				warnon='" . $vbulletin->GPC['warnon'] . "',
				usergroupids = '" . implode(',',$vbulletin->GPC['usergroupids']) . "',
				userids = '" . $vbulletin->db->escape_string($vbulletin->GPC['userids']) . "',
				active='" . $vbulletin->GPC['activate'] . "'
			WHERE chanid='" . $vbulletin->GPC['chanid'] . "'
		");

		print_stop_message('mgc_cb_evo_channel_edited_successfully');
	}
}

if ($_POST['do'] == 'channel_order_save')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'chan_order' 		=> TYPE_ARRAY_UINT
	));

	foreach($vbulletin->GPC['chan_order'] AS $channel_id => $order)
	{
		if (empty($order))
		{
			$order = 1;
		}

		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "mgc_cb_evo_channel SET chanorder='$order' WHERE chanid='$channel_id'");
	}

	define('CP_REDIRECT', 'mgc_cb_evo.php?do=manage_channels');
	print_stop_message('mgc_cb_evo_channel_order_saved_successfully');
}

if ($_REQUEST['do'] == "channel_enable")
{
	$vbulletin->input->clean_array_gpc('r', array(
		'chanid' 	=> TYPE_UINT,
		'what'		=> TYPE_UINT
	));

	/* Check if the chahnel exist */
	$check_channel = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "mgc_cb_evo_channel WHERE chanid='" . $vbulletin->GPC['chanid'] . "'");

	if (!$vbulletin->db->num_rows($check_channel))
	{
		print_stop_message('mgc_cb_evo_nonexisting_channel');
	}

	define('CP_REDIRECT', 'mgc_cb_evo.php?do=manage_channels');

	/* Disabling of the channel */
	if (!$vbulletin->GPC['what'])
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "mgc_cb_evo_channel SET active='0' WHERE chanid='" . $vbulletin->GPC['chanid'] . "'");
		print_stop_message('mgc_cb_evo_channel_successfully_disabled');
	}
	else
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "mgc_cb_evo_channel SET active='1' WHERE chanid='" . $vbulletin->GPC['chanid'] . "'");
		print_stop_message('mgc_cb_evo_channel_successfully_enabled');
	}
}

if ($_REQUEST['do'] == "channel_delete")
{
	$vbulletin->input->clean_array_gpc('r', array(
		'chanid' 	=> TYPE_UINT
	));
	/* Check if the chahnel exist */
	$check_channel = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "mgc_cb_evo_channel WHERE chanid='" . $vbulletin->GPC['chanid'] . "'");

	if (!$vbulletin->db->num_rows($check_channel))
	{
		print_stop_message('mgc_cb_evo_nonexisting_channel');
	}

	define('CP_REDIRECT', 'mgc_cb_evo.php?do=manage_channels');

	/* Removing of the chats */
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "mgc_cb_evo_channel WHERE chanid='" . $vbulletin->GPC['chanid'] . "'");

	print_stop_message('mgc_cb_evo_channel_successfully_deleted');
}

if ($_REQUEST['do'] == "view_log")
{
	print_cp_header($vbphrase['mgc_cb_evo_view_log']);

	?>
	<script type="text/javascript">
	function confirm_delete(logid)
	{
		if(confirm("<? echo $vbphrase['mgc_cb_evo_are_you_sure_to_delete']; ?>"))
			page = "mgc_cb_evo.php?do=log_delete&logid=";
		else
			return;
		jumptopage = page + logid + "&s=<?php echo $vbulletin->session->vars['sessionhash']; ?>";
		window.location = jumptopage;
	}
	</script>
	<?php


	print_table_start();
	print_table_header($vbphrase['mgc_cb_evo_logs'], 4);
	print_cells_row(array($vbphrase['date'], $vbphrase['username'], $vbphrase['text'], $vbphrase['delete']), 1);

	/* Retrieving of the logs */
	$getlogs = $vbulletin->db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "mgc_cb_evo_log
		ORDER BY dateline DESC
	");

	while($log = $vbulletin->db->fetch_array($getlogs))
	{
		print_cells_row(array(
			vbdate($vbulletin->options['dateformat'], $log['dateline'],false,false) . " " . vbdate($vbulletin->options['timeformat'], $log['dateline'],false,false),
			"<div align='center'>" . htmlspecialchars_uni($log['username']) . "</div>",
			$log['ltext'],
			"<div align=\"$stylevar[right]\">
				<input type=\"button\" class=\"button\" value=\"" . $vbphrase['go'] . "\" onclick=\"confirm_delete('$log[logid]');\" />
			</div>"
		), false, '', -2);
	}

	print_table_footer();
}

if ($_REQUEST['do'] == "log_delete")
{
	$vbulletin->input->clean_array_gpc('r', array(
		'logid' 	=> TYPE_UINT
	));

	/* Check if the log exists */
	$check_log = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "mgc_cb_evo_log WHERE logid='" . $vbulletin->GPC['logid'] . "'");

	if (!$vbulletin->db->num_rows($check_log))
	{
		print_stop_message('mgc_cb_evo_nonexisting_log');
	}

	define('CP_REDIRECT', 'mgc_cb_evo.php?do=view_log');

	/* Removing of the chats */
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "mgc_cb_evo_log WHERE logid='" . $vbulletin->GPC['logid'] . "'");

	print_stop_message('mgc_cb_evo_log_successfully_deleted');
}

if ($_REQUEST['do'] == "importers")
{
	print_cp_header($vbphrase['mgc_cb_evo_import_from_other_software']);

	print_form_header('mgc_cb_evo','launch_import');

	print_table_header($vbphrase['mgc_cb_evo_import_from_other_software']);

	print_label_row($vbphrase['mgc_cb_evo_select_which_software']);

	print_yes_no_row($vbphrase['mgc_cb_evo_import_cchatbox'], 'cchatbox', 0, 0); // 1.5
	print_yes_no_row($vbphrase['mgc_cb_evo_import_cyb'], 'cyb', 0, 0); // 2.3
	print_yes_no_row($vbphrase['mgc_cb_evo_import_diondev'], 'diondev', 0, 0); // 1.0
	print_yes_no_row($vbphrase['mgc_cb_evo_import_dream'], 'dream', 0, 0); // 2.1.1
	print_yes_no_row($vbphrase['mgc_cb_evo_import_gsbos'], 'gsbos', 0, 0); // 1.0.5
	print_yes_no_row($vbphrase['mgc_cb_evo_import_inferno'], 'inferno', 0, 0); // 2.5.1 lite
	print_yes_no_row($vbphrase['mgc_cb_evo_import_vbshout'], 'vbshout', 0, 0); // 2.0
	print_yes_no_row($vbphrase['mgc_cb_evo_import_mgc'], 'mgc_chatbox', 0, 0); // 1.5

	/** The end **/
	print_hidden_fields();
	print_submit_row();
}

if ($_POST['do'] == "launch_import")
{
	$vbulletin->input->clean_array_gpc('p', array(
		'cchatbox' 		=> TYPE_UINT,
		'cyb' 			=> TYPE_UINT,
		'diondev' 		=> TYPE_UINT,
		'dream' 		=> TYPE_UINT,
		'gsbos' 		=> TYPE_UINT,
		'inferno' 		=> TYPE_UINT,
		'vbshout' 		=> TYPE_UINT,
		'mgc_chatbox' 	=> TYPE_UINT
	));

	/* No import to run => error */
	if ( ! ($vbulletin->GPC['cchatbox'] || $vbulletin->GPC['cyb'] || $vbulletin->GPC['diondev'] || $vbulletin->GPC['dream'] || $vbulletin->GPC['gsbos'] || $vbulletin->GPC['inferno'] || $vbulletin->GPC['vbshout'] || $vbulletin->GPC['mgc_chatbox']) )
	{
		print_stop_message('mgc_cb_evo_no_import_request');
	}

	$imports_to_run = array();

	/* Check if not trying to import from non installed chatboxes or empty chatbox */

	/* Cyb */
	if ($vbulletin->GPC['cyb'])
	{
		$check_cyb = $vbulletin->db->query_read("SHOW TABLES LIKE '" . TABLE_PREFIX . "cyb_chatbox'");

		/* Table exist ? */
		if ($vbulletin->db->num_rows($check_cyb))
		{
			$getnbchats = $vbulletin->db->query_first("SELECT COUNT(id) AS nbchats FROM " . TABLE_PREFIX . "cyb_chatbox");

			if ($getnbchats['nbchats'])
			{
				$imports_to_run[] = "cyb";
			}
		}
	}

	/* cChatbox */
	if ($vbulletin->GPC['cchatbox'])
	{
		$check_cchatbox = $vbulletin->db->query_read("SHOW TABLES LIKE '" . TABLE_PREFIX . "cchatbox_message'");

		/* Table exist ? */
		if ($vbulletin->db->num_rows($check_cchatbox))
		{
			$getnbchats = $vbulletin->db->query_first("SELECT COUNT(id) AS nbchats FROM " . TABLE_PREFIX . "cchatbox_message");

			if ($getnbchats['nbchats'])
			{
				$imports_to_run[] = "cchatbox";
			}
		}
	}

	/* Dream */
	if ($vbulletin->GPC['dream'])
	{
		$check_dream = $vbulletin->db->query_read("SHOW TABLES LIKE '" . TABLE_PREFIX . "chatbox'");

		/* Table exist ? */
		if ($vbulletin->db->num_rows($check_dream))
		{
			$getnbchats = $vbulletin->db->query_first("SELECT COUNT(shoutid) AS nbchats FROM " . TABLE_PREFIX . "chatbox");

			if ($getnbchats['nbchats'])
			{
				$imports_to_run[] = "dream";
			}
		}
	}

	/* Diondev */
	if ($vbulletin->GPC['diondev'])
	{
		$check_diondev = $vbulletin->db->query_read("SHOW TABLES LIKE '" . TABLE_PREFIX . "shoutbox'");

		/* Table exist ? */
		if ($vbulletin->db->num_rows($check_diondev))
		{
			$getnbchats = $vbulletin->db->query_first("SELECT COUNT(id) AS nbchats FROM " . TABLE_PREFIX . "shoutbox");

			if ($getnbchats['nbchats'])
			{
				$imports_to_run[] = "diondev";
			}
		}
	}

	/* Inferno */
	if ($vbulletin->GPC['inferno'])
	{
		$check_inferno = $vbulletin->db->query_read("SHOW TABLES LIKE '" . TABLE_PREFIX . "infernoshout'");

		/* Table exist ? */
		if ($vbulletin->db->num_rows($check_inferno))
		{
			$getnbchats = $vbulletin->db->query_first("SELECT COUNT(sid) AS nbchats FROM " . TABLE_PREFIX . "infernoshout");

			if ($getnbchats['nbchats'])
			{
				$imports_to_run[] = "inferno";
			}
		}
	}

    /* vBShout */
    if ($vbulletin->GPC['vbshout'])
    {
        $check_vbshout = $vbulletin->db->query_read("SHOW TABLES LIKE '" . TABLE_PREFIX . "shout'");

        /* Table exist ? */
        if ($vbulletin->db->num_rows($check_vbshout))
        {
            $getnbchats = $vbulletin->db->query_first("SELECT COUNT(sid) AS nbchats FROM " . TABLE_PREFIX . "shout");

            if ($getnbchats['nbchats'])
            {
                $imports_to_run[] = "vbshout";
            }
        }
    }

	/* MGC Chatbox */
	if ($vbulletin->GPC['mgc_chatbox'])
	{
		$check_mgc = $vbulletin->db->query_read("SHOW TABLES LIKE '" . TABLE_PREFIX . "mgc_chatbox'");

		/* Table exist ? */
		if ($vbulletin->db->num_rows($check_mgc))
		{
			$getnbchats = $vbulletin->db->query_first("SELECT COUNT(id) AS nbchats FROM " . TABLE_PREFIX . "mgc_chatbox");

			if ($getnbchats['nbchats'])
			{
				$imports_to_run[] = "mgc_chatbox";
			}
		}
	}

	/* GSBOS */
	if ($vbulletin->GPC['gsbos'])
	{
		$check_gsbos = $vbulletin->db->query_read("SHOW TABLES LIKE '" . TABLE_PREFIX . "gsbos'");

		/* Table exist ? */
		if ($vbulletin->db->num_rows($check_gsbos))
		{
			$getnbchats = $vbulletin->db->query_first("SELECT COUNT(gsbosid) AS nbchats FROM " . TABLE_PREFIX . "gsbos");

			if ($getnbchats['nbchats'])
			{
				$imports_to_run[] = "gsbos";
			}
		}
	}

	define('CP_REDIRECT', 'mgc_cb_evo.php?do=do_import&amp;which=' . urlencode(serialize($imports_to_run)));
	print_stop_message('mgc_cb_evo_launching_import');
}

if ($_REQUEST['do'] == 'do_import')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'which'  => TYPE_STR,
		'start'  => TYPE_UINT,
		'teamid' => TYPE_UINT
	));

	print_cp_header($vbphrase['mgc_cb_evo_import_from_other_software']);

	@set_time_limit(0);

	$imports_to_run = unserialize(urldecode($vbulletin->GPC['which']));

	$next_import = 0;

	switch($imports_to_run[0])
	{
		case "cyb":
			/* Get number of shouts in the cyb table */
			$getnbchats = $vbulletin->db->query_first("SELECT COUNT(id) AS nbchats FROM " . TABLE_PREFIX . "cyb_chatbox");

			/* Compute limitlower limitupper */
			$limitlower = $vbulletin->GPC['start'];
		   	$limitupper = $vbulletin->GPC['start'] + (BATCH_NUMBERS - 1);
		   	if ($limitupper >= $getnbchats['nbchats'])
		   	{
				$limitupper = $getnbchats['nbchats'];
				$next_import = 1;
		   	}

			/* Retrieves the chats */
			echo $vbphrase['mgc_cb_evo_cyb_importing_chats'] . '<br />';
			vbflush();

			$cyb_chat_sql = $vbulletin->db->query_read("SELECT * FROM ".TABLE_PREFIX."cyb_chatbox ORDER BY id ASC LIMIT $limitlower," . BATCH_NUMBERS);
			$cnt = 0;

			while ($cyb_chats = $vbulletin->db->fetch_array($cyb_chat_sql))
			{
				echo construct_phrase($vbphrase['mgc_cb_evo_importing_chat_x'], $cyb_chats['id']) . '...';
				vbflush();

				$cybcb_arc_coloropen			= '';
				$cybcb_arc_colorclose			= '';
				$cybcb_arc_boldopen				= '';
				$cybcb_arc_boldclose			= '';
				$cybcb_arc_italicopen			= '';
				$cybcb_arc_italicclose			= '';
				$cybcb_arc_underlineopen		= '';
				$cybcb_arc_underlineclose		= '';

				$cybcb_msg_arc['textprop']	= unserialize($cyb_chats['textprop']);

				if ($cybcb_msg_arc['textprop']['color'])
				{
					$cybcb_arc_coloropen		= '[color='.$cybcb_msg_arc['textprop']['color'].']';
					$cybcb_arc_colorclose		= '[/color]';
				}

				if ($cybcb_msg_arc['textprop']['bold'])
				{
					$cybcb_arc_boldopen			= '[b]';
					$cybcb_arc_boldclose		= '[/b]';
				}

				if ($cybcb_msg_arc['textprop']['italic'])
				{
					$cybcb_arc_italicopen		= '[i]';
					$cybcb_arc_italicclose		= '[/i]';
				}

				if ($cybcb_msg_arc['textprop']['underline'])
				{
					$cybcb_arc_underlineopen	= '[u]';
					$cybcb_arc_underlineclose	= '[/u]';
				}

				$cybcb_msg_arc_tow = $cyb_chats['message'];
				$cyb_chats_message = $cybcb_arc_coloropen . $cybcb_arc_boldopen . $cybcb_arc_italicopen . $cybcb_arc_underlineopen . $cybcb_msg_arc_tow . $cybcb_arc_underlineclose.$cybcb_arc_italicclose . $cybcb_arc_boldclose . $cybcb_arc_colorclose;


				$vbulletin->db->query_write("
					INSERT INTO ".TABLE_PREFIX."mgc_cb_evo_chat
					SET
						dateline='".$cyb_chats['dateline']."',
						fromuid='" . $cyb_chats['userid'] . "',
						touid='0',
						ctext='" . $vbulletin->db->escape_string($cyb_chats_message) . "',
						chanid='0',
						userip='" . $cyb_chats['userip'] . "',
						coidentifier='0'
				");

				echo " " . $vbphrase['mgc_cb_evo_ok'] . "<br />";
				vbflush();
			}
		break;
		case "cchatbox" :
			/* Get number of shouts in the cchatbox table */
			$getnbchats = $vbulletin->db->query_first("SELECT COUNT(id) AS nbchats FROM " . TABLE_PREFIX . "cchatbox_message");

			/* Compute limitlower limitupper */
			$limitlower = $vbulletin->GPC['start'];
		   	$limitupper = $vbulletin->GPC['start'] + (BATCH_NUMBERS - 1);
		   	if ($limitupper >= $getnbchats['nbchats'])
		   	{
				$limitupper = $getnbchats['nbchats'];
				$next_import = 1;
		   	}

			/* Retrieves the chats */
			echo $vbphrase['mgc_cb_evo_cchatbox_importing_chats'] . '<br />';
			vbflush();

			$cchatbox_chat_sql = $vbulletin->db->query_read("SELECT * FROM ".TABLE_PREFIX."cchatbox_message ORDER BY id ASC LIMIT $limitlower," . BATCH_NUMBERS);
			$cnt = 0;

			while ($cchatbox_chats = $vbulletin->db->fetch_array($cchatbox_chat_sql))
			{
				echo construct_phrase($vbphrase['mgc_cb_evo_importing_chat_x'], $cchatbox_chats['id']) . '...';
				vbflush();

				if ($cchatbox_chats['userid'] != -1)
				{
					$vbulletin->db->query_write("
						INSERT INTO ".TABLE_PREFIX."mgc_cb_evo_chat
						SET
							dateline='".$cchatbox_chats['time']."',
							fromuid='" . $cchatbox_chats['userid'] . "',
							touid='0',
							name='" . $vbulletin->db->escape_string($cchatbox_chats['username']) . "',
							ctext='" . $vbulletin->db->escape_string($cchatbox_chats['message']) . "',
							chanid='0',
							userip='',
							coidentifier='0'
					");

					echo " " . $vbphrase['mgc_cb_evo_ok'] . "<br />";
					vbflush();
				}
				else
				{
					echo " " . $vbphrase['mgc_cb_evo_skipped_bot'] . "<br />";
					vbflush();
				}
			}
		break;
		case "dream" :
			/* Get number of shouts in the cchatbox table */
			$getnbchats = $vbulletin->db->query_first("SELECT COUNT(shoutid) AS nbchats FROM " . TABLE_PREFIX . "chatbox");

			/* Compute limitlower limitupper */
			$limitlower = $vbulletin->GPC['start'];
		   	$limitupper = $vbulletin->GPC['start'] + (BATCH_NUMBERS - 1);
		   	if ($limitupper >= $getnbchats['nbchats'])
		   	{
				$limitupper = $getnbchats['nbchats'];
				$next_import = 1;
		   	}

			/* Retrieves the chats */
			echo $vbphrase['mgc_cb_evo_dream_importing_chats'] . '<br />';
			vbflush();

			$dream_chat_sql = $vbulletin->db->query_read("SELECT * FROM ".TABLE_PREFIX."chatbox ORDER BY shoutid ASC LIMIT $limitlower," . BATCH_NUMBERS);
			$cnt = 0;

			while ($dream_chats = $vbulletin->db->fetch_array($dream_chat_sql))
			{
				echo construct_phrase($vbphrase['mgc_cb_evo_importing_chat_x'], $dream_chats['shoutid']) . '...';
				vbflush();

				if (!empty($dream_chats['color']))
				{
					$dream_chats_message = "[color=" . $dream_chats['color'] . "]" . $dream_chats['shout'] . "[/color]";
				}
				else
				{
					$dream_chats_message = $dream_chats['shout'];
				}

				$vbulletin->db->query_write("
					INSERT INTO ".TABLE_PREFIX."mgc_cb_evo_chat
					SET
						dateline='".$dream_chats['dateline']."',
						fromuid='" . $dream_chats['userid'] . "',
						touid='0',
						name='" . $vbulletin->db->escape_string($dream_chats['username']) . "',
						ctext='" . $vbulletin->db->escape_string($dream_chats_message) . "',
						chanid='0',
						userip='" . $dream_chats['ipaddress'] . "',
						coidentifier='0'
				");

				echo " " . $vbphrase['mgc_cb_evo_ok'] . "<br />";
				vbflush();
			}
		break;
		case "diondev" :
			/* Get number of shouts in the cchatbox table */
			$getnbchats = $vbulletin->db->query_first("SELECT COUNT(id) AS nbchats FROM " . TABLE_PREFIX . "shoutbox");

			/* Compute limitlower limitupper */
			$limitlower = $vbulletin->GPC['start'];
		   	$limitupper = $vbulletin->GPC['start'] + (BATCH_NUMBERS - 1);
		   	if ($limitupper >= $getnbchats['nbchats'])
		   	{
				$limitupper = $getnbchats['nbchats'];
				$next_import = 1;
		   	}

			/* Retrieves the chats */
			echo $vbphrase['mgc_cb_evo_diondev_importing_chats'] . '<br />';
			vbflush();

			$diondev_chat_sql = $vbulletin->db->query_read("SELECT * FROM ".TABLE_PREFIX."shoutbox ORDER BY id ASC LIMIT $limitlower," . BATCH_NUMBERS);
			$cnt = 0;

			while ($diondev_chats = $vbulletin->db->fetch_array($diondev_chat_sql))
			{
				echo construct_phrase($vbphrase['mgc_cb_evo_importing_chat_x'], $diondev_chats['id']) . '...';
				vbflush();

				$vbulletin->db->query_write("
					INSERT INTO ".TABLE_PREFIX."mgc_cb_evo_chat
					SET
						dateline='".$diondev_chats['time']."',
						fromuid='" . $diondev_chats['userid'] . "',
						touid='0',
						name='" . $vbulletin->db->escape_string($diondev_chats['username']) . "',
						ctext='" . $vbulletin->db->escape_string($diondev_chats['message']) . "',
						chanid='0',
						userip='',
						coidentifier='0'
				");

				echo " " . $vbphrase['mgc_cb_evo_ok'] . "<br />";
				vbflush();
			}
		break;
		case "inferno" :
			/* Get number of shouts in the cchatbox table */
			$getnbchats = $vbulletin->db->query_first("SELECT COUNT(sid) AS nbchats FROM " . TABLE_PREFIX . "infernoshout");

			/* Compute limitlower limitupper */
			$limitlower = $vbulletin->GPC['start'];
		   	$limitupper = $vbulletin->GPC['start'] + (BATCH_NUMBERS - 1);
		   	if ($limitupper >= $getnbchats['nbchats'])
		   	{
				$limitupper = $getnbchats['nbchats'];
				$next_import = 1;
		   	}

			/* Retrieves the chats */
			echo $vbphrase['mgc_cb_evo_inferno_importing_chats'] . '<br />';
			vbflush();

			$inferno_chat_sql = $vbulletin->db->query_read("SELECT * FROM ".TABLE_PREFIX."infernoshout ORDER BY sid ASC LIMIT $limitlower," . BATCH_NUMBERS);
			$cnt = 0;

			while ($inferno_chats = $vbulletin->db->fetch_array($inferno_chat_sql))
			{
				echo construct_phrase($vbphrase['mgc_cb_evo_importing_chat_x'], $inferno_chats['sid']) . '...';
				vbflush();

				if ($inferno_chats['s_me'])
				{
					$inferno_coidentifier = 'me';
				}
				else
				{
					$inferno_coidentifier = '0';
				}

				$vbulletin->db->query_write("
					INSERT INTO ".TABLE_PREFIX."mgc_cb_evo_chat
					SET
						dateline='".$inferno_chats['s_time']."',
						fromuid='" . $inferno_chats['s_user'] . "',
						touid='0',
						ctext='" . $vbulletin->db->escape_string($inferno_chats['s_shout']) . "',
						chanid='0',
						userip='',
						coidentifier='" . $inferno_coidentifier . "'
				");

				echo " " . $vbphrase['mgc_cb_evo_ok'] . "<br />";
				vbflush();
			}
		break;
        case "vbshout":
            /* Get number of shouts in the vbshout table */
            $getnbchats = $vbulletin->db->query_first("SELECT COUNT(sid) AS nbchats FROM " . TABLE_PREFIX . "shout");

            /* Compute limitlower limitupper */
            $limitlower = $vbulletin->GPC['start'];
               $limitupper = $vbulletin->GPC['start'] + (BATCH_NUMBERS - 1);
               if ($limitupper >= $getnbchats['nbchats'])
               {
                $limitupper = $getnbchats['nbchats'];
                $next_import = 1;
               }

            /* Retrieves the chats */
            echo $vbphrase['mgc_cb_evo_vbshout_importing_chats'] . '<br />';
            vbflush();

            $vbshout_chat_sql = $vbulletin->db->query_read("SELECT * FROM ".TABLE_PREFIX."shout ORDER BY sid ASC LIMIT $limitlower," . BATCH_NUMBERS);
            $cnt = 0;

            while ($vbshout_chats = $vbulletin->db->fetch_array($vbshout_chat_sql))
            {
                echo construct_phrase($vbphrase['mgc_cb_evo_importing_chat_x'], $vbshout_chats['sid']) . '...';
                vbflush();

                $vbshout_arc_coloropen            = '';
                $vbshout_arc_colorclose            = '';
                $vbshout_arc_boldopen                = '';
                $vbshout_arc_boldclose            = '';
                $vbshout_arc_italicopen            = '';
                $vbshout_arc_italicclose            = '';
                $vbshout_arc_underlineopen        = '';
                $vbshout_arc_underlineclose        = '';

                $vbshout_msg_arc['s_data']    = unserialize($vbshout_chats['s_data']);

                if ($vbshout_msg_arc['s_data']['color'])
                {
                    $vbshout_arc_coloropen        = '[color='.$vbshout_msg_arc['s_data']['color'].']';
                    $vbshout_arc_colorclose        = '[/color]';
                }

                if ($vbshout_msg_arc['s_data']['bold'])
                {
                    $vbshout_arc_boldopen            = '[b]';
                    $vbshout_arc_boldclose        = '[/b]';
                }

                if ($vbshout_msg_arc['s_data']['italic'])
                {
                    $vbshout_arc_italicopen        = '[i]';
                    $vbshout_arc_italicclose        = '[/i]';
                }

                if ($vbshout_msg_arc['s_data']['underline'])
                {
                    $vbshout_arc_underlineopen    = '[u]';
                    $vbshout_arc_underlineclose    = '[/u]';
                }

                $vbshout_msg_arc_tow = $vbshout_chats['s_shout'];
                $vbshout_chats_message = $vbshout_arc_coloropen . $vbshout_arc_boldopen . $vbshout_arc_italicopen . $vbshout_arc_underlineopen . $vbshout_msg_arc_tow . $vbshout_arc_underlineclose.$vbshout_arc_italicclose . $vbshout_arc_boldclose . $vbshout_arc_colorclose;


                $vbulletin->db->query_write("
                    INSERT INTO ".TABLE_PREFIX."mgc_cb_evo_chat
                    SET
                        dateline='".$vbshout_chats['s_time']."',
                        fromuid='" . $vbshout_chats['s_by'] . "',
                        touid='0',
                        ctext='" . $vbulletin->db->escape_string($vbshout_chats_message) . "',
                        chanid='0',
                        userip='',
                        coidentifier='0'
                ");

                echo " " . $vbphrase['mgc_cb_evo_ok'] . "<br />";
                vbflush();
            }
        break;
		case "mgc_chatbox":
			/* If start abd team command active, create a new team channel */
			if (($vbulletin->GPC['start'] == 0) && $vbulletin->options['mgc_cb_fctteam'])
			{
				echo $vbphrase['mgc_cb_evo_creating_team_channel'] . '...';
				vbflush();

				$vbulletin->db->query_write("
					INSERT INTO " . TABLE_PREFIX . "mgc_cb_evo_channel SET title='Team channel',description='Created by MGC chatbox EVO importer',img_name='mgc_cb_evo_team',warnon='0',active='1',usergroupids='6'
				");

				$teamid = $vbulletin->db->insert_id();

				echo " " . $vbphrase['mgc_cb_evo_ok'] . "<br />";
				vbflush();
			}
			else
			{
				$teamid = $vbulletin->GPC['teamid'];
			}

			/* Get number of shouts in the cchatbox table */
			$getnbchats = $vbulletin->db->query_first("SELECT COUNT(id) AS nbchats FROM " . TABLE_PREFIX . "mgc_chatbox");

			/* Compute limitlower limitupper */
			$limitlower = $vbulletin->GPC['start'];
		   	$limitupper = $vbulletin->GPC['start'] + (BATCH_NUMBERS - 1);
		   	if ($limitupper >= $getnbchats['nbchats'])
		   	{
				$limitupper = $getnbchats['nbchats'];
				$next_import = 1;
		   	}

			/* Retrieves the chats */
			echo $vbphrase['mgc_cb_evo_mgc_chatbox_importing_chats'] . '<br />';
			vbflush();

			$mgc_chatbox_chat_sql = $vbulletin->db->query_read("SELECT * FROM ".TABLE_PREFIX."mgc_chatbox ORDER BY id ASC LIMIT $limitlower," . BATCH_NUMBERS);
			$cnt = 0;

			while ($mgc_chatbox_chats = $vbulletin->db->fetch_array($mgc_chatbox_chat_sql))
			{
				echo construct_phrase($vbphrase['mgc_cb_evo_importing_chat_x'], $mgc_chatbox_chats['id']) . '...';
				vbflush();

				$mgc_chatbox_coidentifier = '0';
				$mgc_chatbox_chanid = '0';
				$mgc_chatbox_chat = $mgc_chatbox_chats['chat'];

				/* If command me is active, check if not me chat */
				if ($vbulletin->options['mgc_cb_fctme'])
				{
					if(substr(strtolower($mgc_chatbox_chat),0,4) == "/me ")
					{
						$mgc_chatbox_coidentifier = 'me';
						$mgc_chatbox_chat = substr($mgc_chatbox_chat, 4);
					}
				}

				/* If command team is active, check if not team chat */
				if ($vbulletin->options['mgc_cb_fctteam'])
				{
					if(substr(strtolower($mgc_chatbox_chat),0,6) == "/team ")
					{
						$mgc_chatbox_chanid = $teamid;
						$mgc_chatbox_chat = substr($mgc_chatbox_chat, 6);
					}
				}

				/* If touserid => 0, add it as pm command */
				if ($mgc_chatbox_chats['touserid'])
				{
					$mgc_chatbox_coidentifier = 'pm';
					$mgc_chatbox_chat = substr($mgc_chatbox_chat, 4);
				}

				$vbulletin->db->query_write("
					INSERT INTO ".TABLE_PREFIX."mgc_cb_evo_chat
					SET
						dateline='".$mgc_chatbox_chats['date']."',
						fromuid='" . $mgc_chatbox_chats['userid'] . "',
						touid='" . $mgc_chatbox_chats['touserid'] . "',
						ctext='" . $vbulletin->db->escape_string($mgc_chatbox_chat) . "',
						chanid='" . $mgc_chatbox_chanid . "',
						userip='',
						coidentifier='" . $mgc_chatbox_coidentifier . "'
				");

				echo " " . $vbphrase['mgc_cb_evo_ok'] . "<br />";
				vbflush();
			}
		break;
		case "gsbos" :
			/* Get number of shouts in the cchatbox table */
			$getnbchats = $vbulletin->db->query_first("SELECT COUNT(gsbosid) AS nbchats FROM " . TABLE_PREFIX . "gsbos");

			/* Compute limitlower limitupper */
			$limitlower = $vbulletin->GPC['start'];
		   	$limitupper = $vbulletin->GPC['start'] + (BATCH_NUMBERS - 1);
		   	if ($limitupper >= $getnbchats['nbchats'])
		   	{
				$limitupper = $getnbchats['nbchats'];
				$next_import = 1;
		   	}

			/* Retrieves the chats */
			echo $vbphrase['mgc_cb_evo_gsbos_importing_chats'] . '<br />';
			vbflush();

			$gsbos_chat_sql = $vbulletin->db->query_read("SELECT * FROM ".TABLE_PREFIX."gsbos ORDER BY gsbosid ASC LIMIT $limitlower," . BATCH_NUMBERS);
			$cnt = 0;

			while ($gsbos_chats = $vbulletin->db->fetch_array($gsbos_chat_sql))
			{
				echo construct_phrase($vbphrase['mgc_cb_evo_importing_chat_x'], $gsbos_chats['gsbosid']) . '...';
				vbflush();

				$vbulletin->db->query_write("
					INSERT INTO ".TABLE_PREFIX."mgc_cb_evo_chat
					SET
						dateline='".$gsbos_chats['dateline']."',
						fromuid='" . $gsbos_chats['userid'] . "',
						touid='0',
						ctext='" . $vbulletin->db->escape_string($gsbos_chats['message']) . "',
						chanid='0',
						userip='',
						coidentifier='0'
				");

				echo " " . $vbphrase['mgc_cb_evo_ok'] . "<br />";
				vbflush();
			}
		break;
	}

	if ($next_import)
	{
		$start = 0;
		echo $vbphrase['mgc_cb_evo_finished'] . "<br />";
		vbflush();
		unset($imports_to_run[0]);
		if (sizeof($imports_to_run))
		{
			$imports_to_run = array_values($imports_to_run);
		}
	}
	else
	{
		$start = $limitupper + 1;
	}

	if (sizeof($imports_to_run))
	{
		define('CP_REDIRECT', 'mgc_cb_evo.php?do=do_import&amp;which=' . urlencode(serialize($imports_to_run)) . '&amp;start=' . $start . '&amp;teamid=' . $teamid);
		print_stop_message('mgc_cb_evo_next_import');
	}
	else
	{
		define('CP_REDIRECT', 'mgc_cb_evo.php?do=update_before_2.3.0');
		print_stop_message('mgc_cb_evo_import_successfull');
	}	
}

if ($_REQUEST['do'] == 'counters')
{
	print_cp_header($vbphrase['mgc_cb_evo_update_counters']);

	/* If count option not active => error */
	if (!$vbulletin->options['mgc_cb_evo_count_userchats'])
	{
		print_stop_message('mgc_cb_evo_must_activate_chatscount_option_first');
	}

	/* Information text before launch */
	print_form_header('mgc_cb_evo', 'updatecounters');
	print_table_header($vbphrase['mgc_cb_evo_update_counters'], 1, 0);
	print_description_row($vbphrase['mgc_cb_evo_recalculate_users_chat_count_info']);
	print_submit_row($vbphrase['mgc_cb_evo_update_chats_count']);
}

if ($_REQUEST['do'] == 'updatecounters')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'start'  => TYPE_UINT
	));

	$percycle = 10 * 86400;

	print_cp_header($vbphrase['mgc_cb_evo_update_counters']);

	/* Computation of start timestamp */
	if (empty($vbulletin->GPC['start']))
	{
		// Clear number of chats in the database
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET mgc_cb_evo_nbchats='0'");

		// First cycle
		$dateline 			= $vbulletin->db->query_first("SELECT MIN(dateline) AS start FROM " . TABLE_PREFIX . "mgc_cb_evo_chat WHERE iswarning='0'");
		$start_timestamp 	= mktime(0, 0, 0, date('n', $dateline['start']), date('j', $dateline['start']), date('Y', $dateline['start']));
	}
	else
	{
		$start_timestamp	= $vbulletin->GPC['start'];
	}

	/* Computation of the end timestamp */
	if (($start_timestamp + $percycle) >= TIMENOW)
	{
		$end_timestamp = TIMENOW;
		$stop		   = 1;
	}
	else
	{
		$end_timestamp = $start_timestamp + $percycle;
		$stop		   = 0;
	}

	/* Retrieval of chats during done during that time frame */
	$chats = $vbulletin->db->query_read("SELECT fromuid,COUNT(chatid) AS nbchats FROM " . TABLE_PREFIX . "mgc_cb_evo_chat WHERE dateline>='" . $start_timestamp . "' AND dateline<'" . $end_timestamp . "' GROUP BY fromuid");

	/* Chats to proceed ? */
	if ($vbulletin->db->num_rows($chats))
	{
		while($userchats = $vbulletin->db->fetch_array($chats))
		{
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET mgc_cb_evo_nbchats=mgc_cb_evo_nbchats+" . $userchats['nbchats'] . " WHERE userid='" . $userchats['fromuid'] . "'");
		}
	}

	if ($stop)
	{
		define('CP_REDIRECT', 'mgc_cb_evo.php?do=end_updatecounters');
	}
	else
	{
		define('CP_REDIRECT', 'mgc_cb_evo.php?do=updatecounters&start=' . $end_timestamp);
	}

	print_stop_message('mgc_cb_evo_updating_counters');
}

if ($_REQUEST['do'] == 'end_updatecounters')
{
	print_stop_message('mgc_cb_evo_counters_updated_successfully');
}

if ($_REQUEST['do'] == 'update_before_2.3.0')
{

	@set_time_limit(0);
	ignore_user_abort(1);

   $perpage 	= 500;
   $pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_UINT);
   $nextpage   = $pagenumber + 1;
   $timestart  = $vbulletin->input->clean_gpc('r', 'timestart', TYPE_UINT);
   $what 		= $vbulletin->input->clean_gpc('r', 'what', TYPE_STR);

	if (!$timestart)
	{
		$timestart = TIMENOW;
	}

   /* Count userids */
   if ($what == 'chat' || empty($what))
   {
	   $getnbusers = $vbulletin->db->query_first("
			SELECT COUNT(DISTINCT fromuid) AS nbusers
			FROM " . TABLE_PREFIX . "mgc_cb_evo_chat AS c
			WHERE dateline<'$timestart' AND touid='0'
			ORDER BY fromuid ASC
	  	");
	  	$what = 'chat';
	}
	else
	{
	   $getnbusers = $vbulletin->db->query_first("
			SELECT COUNT(DISTINCT touid) AS nbusers
			FROM " . TABLE_PREFIX . "mgc_cb_evo_chat AS c
			WHERE dateline<'$timestart' AND touid<>'0'
			ORDER BY touid ASC
	  	");
	  	$what = 'pm';
	}

   sanitize_pageresults($getnbusers['nbusers'], $pagenumber, $perpage, 100, 25);

   /* page min / page max */
   $stop = 0;
   $limitlower = ($pagenumber - 1) * $perpage + 1;
   $limitupper = $pagenumber * $perpage;
   if ($limitupper > $getnbusers['nbusers'])
   {
   	$stop = 1;
      $limitupper = $getnbusers['nbusers'];
      if ($limitlower > $getnbusers['nbusers'])
      {
         $limitlower = $getnbusers['nbusers'] - $perpage;
      }
   }
   if ($limitlower <= 0)
   {
      $limitlower = 1;
   }

	print_cp_header($vbphrase['mgc_cb_evo_update_before_230']);

	if ($what == 'chat')
	{
		echo '<p>' . $vbphrase['mgc_cb_evo_updating_chats'] . '</p>';
	}
	else
	{
		echo '<p>' . $vbphrase['mgc_cb_evo_updating_pmchats'] . '</p>';	
	}
	
	if (substr($vbulletin->options['templateversion'],0,3) != "3.6")
	{
   	$sql_add_fields = ",customavatar.height_thumb AS avheight_thumb, customavatar.width_thumb AS avwidth_thumb, customavatar.filedata_thumb";
	}	
	
	/* Retrieval of users */
	if ($what == 'chat')
	{
		$users = $vbulletin->db->query_read("
			SELECT
				u.username,u.userid,u.usergroupid,u.displaygroupid,
				avatar.avatarpath, NOT ISNULL(customavatar.userid) AS hascustomavatar, customavatar.dateline AS avatardateline,
				customavatar.width AS avwidth, customavatar.height AS avheight,u.avatarid,u.avatarrevision
				$sql_add_fields
			FROM " . TABLE_PREFIX . "mgc_cb_evo_chat AS c
			LEFT JOIN " . TABLE_PREFIX . "user AS u ON (c.fromuid=u.userid)
			LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON (avatar.avatarid = u.avatarid)
			LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON (customavatar.userid = u.userid)
			WHERE c.dateline<'$timestart' AND c.touid='0'
			GROUP BY c.fromuid
			ORDER BY c.fromuid ASC
			LIMIT " . ($limitlower - 1) . ", $perpage
		");
	}
	else
	{
		$users = $vbulletin->db->query_read("
			SELECT
				u.username,u.userid,u.usergroupid,u.displaygroupid,
				avatar.avatarpath, NOT ISNULL(customavatar.userid) AS hascustomavatar, customavatar.dateline AS avatardateline,
				customavatar.width AS avwidth, customavatar.height AS avheight,u.avatarid,u.avatarrevision
				$sql_add_fields
			FROM " . TABLE_PREFIX . "mgc_cb_evo_chat AS c
			LEFT JOIN " . TABLE_PREFIX . "user AS u ON (c.touid=u.userid)
			LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON (avatar.avatarid = u.avatarid)
			LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON (customavatar.userid = u.userid)
			WHERE c.dateline<'$timestart' AND c.touid<>'0'
			GROUP BY c.touid
			ORDER BY c.touid ASC
			LIMIT " . ($limitlower - 1) . ", $perpage
		");	
	}

	/* Users to proceed ? */
	if ($vbulletin->db->num_rows($users))
	{
		while($user = $vbulletin->db->fetch_array($users))
		{			
			$add_insert = '';

			if (!empty($user['avatarpath']))
			{
				$add_insert .= ",avatarpath='" . $vbulletin->db->escape_string($user['avatarpath']) . "'";
			}

			if (!empty($user['filedata_thumb']))
			{
				$add_insert .= ",filedata_thumb='" . $vbulletin->db->escape_string($user['filedata_thumb']) . "'";
			}

			if ($what == 'pm')
			{
				$vbulletin->db->query_write("
					UPDATE " . TABLE_PREFIX . "mgc_cb_evo_chat
					SET
						toname='" . $vbulletin->db->escape_string($user['username']) . "',
						todisplaygroupid='" . $user['displaygroupid'] . "',
						tousergroupid='" . $user['usergroupid'] . "',
						tohascustomavatar='" . $user['hascustomavatar'] . "',
						toavatardateline='" . $user['avatardateline'] . "',
						toavwidth='" . $user['avwidth'] . "',
						toavheight='" . $user['avheight'] . "',
						toavwidth_thumb='" . $user['avwidth_thumb'] . "',
						toavheight_thumb='" . $user['avheight_thumb'] . "',
						toavatarid='" . $user['avatarid'] . "',
						toavatarrevision='" . $user['avatarrevision'] . "'
						$add_insert
					WHERE touid='" . $user['userid'] . "'
				");
			}
			else
			{
				$vbulletin->db->query_write("
					UPDATE " . TABLE_PREFIX . "mgc_cb_evo_chat
					SET
						name='" . $vbulletin->db->escape_string($user['username']) . "',
						displaygroupid='" . $user['displaygroupid'] . "',
						usergroupid='" . $user['usergroupid'] . "',
						hascustomavatar='" . $user['hascustomavatar'] . "',
						avatardateline='" . $user['avatardateline'] . "',
						avwidth='" . $user['avwidth'] . "',
						avheight='" . $user['avheight'] . "',
						avwidth_thumb='" . $user['avwidth_thumb'] . "',
						avheight_thumb='" . $user['avheight_thumb'] . "',
						avatarid='" . $user['avatarid'] . "',
						avatarrevision='" . $user['avatarrevision'] . "'
						$add_insert
					WHERE fromuid='" . $user['userid'] . "'
				");
			}
			echo construct_phrase($vbphrase['mgc_cb_evo_processing_user_x'], $user['userid']) . "<br />\n";
			vbflush();
		}
	}

	if ($stop)
	{
		if ($what == 'pm')
		{
			define('CP_REDIRECT', 'mgc_cb_evo.php');
			print_stop_message('mgc_cb_evo_updated_successfully_to_230');
		}
		else
		{
			print_cp_redirect("mgc_cb_evo.php?do=update_before_2.3.0&" . $vbulletin->session->vars['sessionurl'] . "pagenumber=" . $nextpage . "&timestart=" . $timestart . "&what=pm",5);
			echo "<p><a href=\"mgc_cb_evo.php?do=update_before_2.3.0&amp;" . $vbulletin->session->vars['sessionurl'] . "pagenumber=" . $nextpage . "&amp;timestart=" . $timestart . "&amp;what=pm\">" . $vbphrase['mgc_cb_evo_click_here_to_continue_processing'] . "</a></p>";
		}
	}
	else
	{
		print_cp_redirect("mgc_cb_evo.php?do=update_before_2.3.0&" . $vbulletin->session->vars['sessionurl'] . "pagenumber=" . $nextpage . "&timestart=" . $timestart . "&what=" . $what,5);
		echo "<p><a href=\"mgc_cb_evo.php?do=update_before_2.3.0&amp;" . $vbulletin->session->vars['sessionurl'] . "pagenumber=" . $nextpage . "&amp;timestart=" . $timestart . "&amp;what=" . $what . "\">" . $vbphrase['mgc_cb_evo_click_here_to_continue_processing'] . "</a></p>";
	}
}

print_cp_footer();

?>