<?php

if (!class_exists('vB_DataManager'))
{
    exit;
}

class vB_DataManager_Mgccb_Chat extends vB_DataManager
{

    /* Datamanager variables */
    var $validfields = array
      (
       'chatid'     				=> array(TYPE_UINT, 	REQ_INCR, 	VF_METHOD,	'verify_nonzero'),
       'dateline' 				=> array(TYPE_UINT, 	REQ_YES),
       'chanid' 					=> array(TYPE_UINT, 	REQ_YES),
       'coidentifier'   		=> array(TYPE_STR, 	REQ_YES),
       'fromuid' 					=> array(TYPE_UINT, 	REQ_YES),
       'touid' 					=> array(TYPE_UINT, 	REQ_NO),
       'ctext' 					=> array(TYPE_STR, 	REQ_YES,	        			'VF_METHOD'),
       'userip'    				=> array(TYPE_STR,  	REQ_YES, 	VF_METHOD,	'verify_ipaddress'),   
       'name'   					=> array(TYPE_STR, 	REQ_NO),       
       'usergroupid'				=> array(TYPE_INT, 	REQ_YES),
       'displaygroupid'			=> array(TYPE_INT, 	REQ_YES),
       'hascustomavatar'		=> array(TYPE_INT, 	REQ_YES),
       'avatarpath'				=> array(TYPE_STR, 	REQ_YES),
       'avatardateline'			=> array(TYPE_INT, 	REQ_YES),
       'avwidth'					=> array(TYPE_INT, 	REQ_YES),
       'avheight'					=> array(TYPE_INT, 	REQ_NO),
       'avheight_thumb'			=> array(TYPE_INT, 	REQ_NO),
       'avwidth_thumb'			=> array(TYPE_INT, 	REQ_NO),
       'filedata_thumb'   		=> array(TYPE_STR, 	REQ_NO),
       'avatarid'					=> array(TYPE_INT, 	REQ_YES),
       'avatarrevision'			=> array(TYPE_INT, 	REQ_YES),
       'toname'   				=> array(TYPE_STR, 	REQ_NO),       
       'tousergroupid'			=> array(TYPE_INT, 	REQ_NO),
       'todisplaygroupid'		=> array(TYPE_INT, 	REQ_NO),
       'tohascustomavatar'		=> array(TYPE_INT, 	REQ_NO),
       'toavatarpath'			=> array(TYPE_STR, 	REQ_NO),
       'toavatardateline'		=> array(TYPE_INT, 	REQ_NO),
       'toavwidth'				=> array(TYPE_INT, 	REQ_NO),
       'toavheight'				=> array(TYPE_INT, 	REQ_NO),
       'toavheight_thumb'		=> array(TYPE_INT, 	REQ_NO),
       'toavwidth_thumb'		=> array(TYPE_INT, 	REQ_NO),
       'tofiledata_thumb'   	=> array(TYPE_STR, 	REQ_NO),
       'toavatarid'				=> array(TYPE_INT, 	REQ_NO),
       'toavatarrevision'		=> array(TYPE_INT, 	REQ_NO),
       );
    
    var $table = 'mgc_cb_evo_chat';

    var $mgc_cb_evo_chat = array();
    
    /* The raw chat */
    var $raw_chat = "";
    
    /* Commands permissions */
    var $user_commands = array();

    /* Action statuses */
    var $action = "";
    
    /* Variables for command management */
    var $parse_bbcode 		= 1;
    var $accept_userpref 	= 1;
    var $contain_command 	= 0;

    function vB_DataManager_Mgccb_Chat(&$registry, $errtype = ERRTYPE_STANDARD) {
      parent::vB_DataManager($registry, $errtype);
    }

    /* Commands retrieving from the database */
    function retrieve_command_permissions() {
        /* Constructing the usergroupids REGEXP */
        $sql_condition = "usergroupids REGEXP('^([0-9]+,)*" . $this->registry->
          userinfo['usergroupid'] . "(,[0-9]+)*$')";

        if (!empty($this->registry->userinfo['membergroupids'])) {
            $ugipds_array = explode(',', $this->registry->userinfo['membergroupids']);

            foreach ($ugipds_array as $index => $ugpid) {
                $sql_condition .= " OR usergroupids REGEXP('^([0-9]+,)*" . $ugpid .
                  "(,[0-9]+)*$')";
            }
        }

        $sql_condition .= " OR userids REGEXP('^([0-9]+,)*" . $this->registry->userinfo['userid'] . "(,[0-9]+)*$')";

        /* Retrieving the commands in the database */
        $getcommands = $this->registry->db->query_read("
			SELECT identifier
			FROM " . TABLE_PREFIX . "mgc_cb_evo_command
			WHERE active='1' AND ($sql_condition)
		");

        if ($this->registry->db->num_rows($getcommands)) {
            $count = 0;
            while ($command = $this->registry->db->fetch_array($getcommands)) {
                $this->user_commands[$count] =& $command['identifier'];
                $count++;
            }            
        }           
    }
    
    /* Raw chat registration ??? TBD ??? */
    function set_raw_chat(&$sent_chat) {
        $this->raw_chat = &trim($sent_chat);
    }

    /* Pre save chekings */
    function pre_save() {
        global $vbphrase;

        /* Check if the chat field was not empty ? */
        if (empty($this->raw_chat)) {
            $this->construct_popup($vbphrase['mgc_cb_evo_enter_chat']);
            return;
        }
        
        /* Check if only bbcodes */
        $temp = strip_bbcode($this->raw_chat);
        if (empty($temp)) {
            $this->construct_popup($vbphrase['mgc_cb_evo_enter_chat']);
            return;
        } 
        
        /* If a command is entered and user has access to commands */
        if ((substr($this->raw_chat,0,1) == "/") && sizeof($this->user_commands)) {            
            /*****************************/
            /** ME command               */
            /*****************************/
            if ($this->check_and_parse_command_identifier("me",2)) {    
                /* No message => error */
                if (empty($this->raw_chat)) {
                    $this->construct_popup($vbphrase['mgc_cb_evo_msg_missing']);
                    return;
                }
                
                $this->set("coidentifier","me");
                $this->parse_bbcode 	= 1;
                $this->accept_userpref 	= 0;
            }        
            /*****************************/
            /** Team command             */
            /*****************************/
            if ($this->check_and_parse_command_identifier("team",4)) {    
                /* No message => error */
                if (empty($this->raw_chat)) {
                    $this->construct_popup($vbphrase['mgc_cb_evo_msg_missing']);
                    return;
                }
                
                $this->set("coidentifier","team");
                $this->parse_bbcode 	= 1;
                $this->accept_userpref 	= 1;
            }
            /*****************************/
            /** Announcement command     */
            /*****************************/
            else if ($this->check_and_parse_command_identifier("announcement",12)) {
                require_once(DIR. '/includes/adminfunctions.php');
                
                if($this->raw_chat != 'remove') {	
                    $this->registry->db->query_write("
						UPDATE " . TABLE_PREFIX . "setting
						SET value='" . $this->registry->db->escape_string($this->raw_chat) . "'
						WHERE varname='mgc_cb_evo_announcement'
					");
                } else {
                    $this->registry->db->query_write("
						UPDATE " . TABLE_PREFIX . "setting
						SET value=''
						WHERE varname='mgc_cb_evo_announcement'
					");	
                }
                
                build_options();
                
                $this->action .= "mgc_cb_evo_force_page_refresh()";
                return;         	
            }
            /*****************************/
            /** Ban command              */
            /*****************************/
            else if ($this->check_and_parse_command_identifier("ban",3)) {                
                if ($this->raw_chat == "show") {
                    /* Show currently banned users */
                    $this->action = "mgc_cb_evo_cmd_ban_popup()";
                    return;
                } else if (substr($this->raw_chat,0,3) == "on ") {
                    /* Indefinitely ban user */
                    $ban_type = 1;
                    $this->raw_chat = substr($this->raw_chat,3);
                } else if (substr($this->raw_chat,0,4) == "off ") {
                    /* Unban user */
                    $ban_type = 0;
                    $this->raw_chat = substr($this->raw_chat,4);
                } else if (substr($this->raw_chat,0,2) == "h ") {
                    /* Ban user for a defined number of hours */
                    $ban_type 			= 2;
                    $ban_time_factor 	= 3600;
                    $this->raw_chat 	= trim(substr($this->raw_chat,2));
                } else if (substr($this->raw_chat,0,2) == "d ") {
                    /* Ban user for a defined number of days */
                    $ban_type 			= 2;
                    $ban_time_factor 	= 86400;
                    $this->raw_chat 	= trim(substr($this->raw_chat,2));
                } else {
                    /* Syntax error */
                    $this->construct_popup($vbphrase['mgc_cb_evo_syntax_error']);
                    return;  
                }
                
                /* If Time ban, get entered time */
                if ($ban_type == 2) {
                	  $getnextspace 	= strpos($this->raw_chat," ");
   	              $ban_time			= TIMENOW + (intval(substr($this->raw_chat,0,$getnextspace)) * $ban_time_factor);
      	           $this->raw_chat = substr($this->raw_chat,$getnextspace + 1);
      	       }
                
                /* Userid specified */
                if (substr($this->raw_chat,0,4) == "uid ") {
                    $userid = intval(trim(substr($this->raw_chat,4)));
                    
                    /* Let's check if the user exists */
                    $getuser = $this->registry->db->query_first("
								SELECT username,userid,mgc_cb_evo_banned
								FROM " . TABLE_PREFIX . "user
								WHERE userid='$userid'
						");
                } else if (substr($this->raw_chat,0,6) == "uname ") {
                    $username = $this->registry->db->escape_string(substr($this->raw_chat,6));
                    
                    /* Let's check if the user exists */
                    $getuser = $this->registry->db->query_first("
						SELECT username,userid,mgc_cb_evo_banned FROM " . TABLE_PREFIX . "user WHERE username='$username'
					");
                } else {
                    $this->construct_popup($vbphrase['mgc_cb_evo_syntax_error']);
                    return;  
                }
                
                /* User tries to ban himself */
                if ($getuser['userid'] == $this->registry->userinfo['userid']) {
					$this->construct_popup($vbphrase['mgc_cb_evo_cmd_ban_cant_ban_yourself']);
                    return;                  
                }
                
                /* User is not existing */
                if (!isset($getuser['userid'])) {
                    $this->construct_popup($vbphrase['mgc_cb_evo_cmd_ban_false_user']);
                    return;   
                }
                
                /* User is not a protected one */
                if (!empty($this->registry->options['mgc_cb_evo_cmd_ban_protected_users'])) {
                    if (in_array($getuser['userid'],explode(',',$this->registry->options['mgc_cb_evo_cmd_ban_protected_users']))) {
                        $this->construct_popup($vbphrase['mgc_cb_evo_cmd_ban_cant_ban_protected']);
                        return;  
                    }
                }
                
                /* When user tries to ban someone */
                if ($ban_type) {
                    /* User is already in banned list */
                    if ($getuser['mgc_cb_evo_banned']) {
                        $this->construct_popup($vbphrase['mgc_cb_evo_cmd_ban_already_banned']);
                        return;         
                    }
                    
                    /* Let's ban the user */
                    $this->registry->db->query_write("
								UPDATE " . TABLE_PREFIX . "user SET mgc_cb_evo_banned='1',mgc_cb_evo_bantime='" . (($ban_type == 2) ? $ban_time : 0) . "' WHERE userid='" . $getuser['userid'] . "'
						  ");
                    
                    $this->construct_popup($vbphrase['mgc_cb_evo_cmd_ban_banned_success']);
                    
                    if ($this->registry->options['mgc_cb_evo_cmd_ban_mponban']) {                     
                        $pmdm =& datamanager_init('PM', $this->registry, ERRTYPE_ARRAY); 
                        $pmdm->set('fromuserid', $this->registry->userinfo['userid']); 
                        $pmdm->set('fromusername', $this->registry->userinfo['username']); 
                        $pmdm->set('title', $this->registry->options['mgc_cb_evo_cmd_ban_mponban_title']);
                        $pmdm->overridequota = true;
                        
                        if ($ban_type == 1) {
                        	/* Unlimited ban */
                        	$text = str_replace('{1}',$getuser['username'],$this->registry->options['mgc_cb_evo_cmd_ban_mponban_text']);
                        } else {
                        	/* Limited ban */
                        	$endban_date = vbdate($this->registry->options['dateformat'], $ban_time, true);
									$endban_time = vbdate($this->registry->options['timeformat'], $ban_time);
									$text = str_replace('{1}',$getuser['username'],$this->registry->options['mgc_cb_evo_cmd_ban_mponband_text']);
									$text = str_replace('{2}',$endban_date . " " . $endban_time,$text);
                        }
                        $pmdm->set('message', $text);		
                        $pmdm->set_recipients($getuser['username'],$permissions); 
                        $pmdm->set('dateline', TIMENOW); 
                        $pmdm->save();      
                    }
                    
                    $this->log_action(construct_phrase($vbphrase['mgc_cb_evo_log_ban_x'],$getuser['username']));
                    
                    return;     
                } else {
                    /* User is banned */
                    if (!$getuser['mgc_cb_evo_banned']) {
                        $this->construct_popup($vbphrase['mgc_cb_evo_cmd_ban_not_banned']);
                        return;         
                    }
                    
                    /* Let's unban user */
                    $this->registry->db->query_write("
						UPDATE " . TABLE_PREFIX . "user SET mgc_cb_evo_banned='0',mgc_cb_evo_bantime='0' WHERE userid='" . $getuser['userid'] . "'
					");
                    
                    $this->construct_popup($vbphrase['mgc_cb_evo_cmd_ban_unbanned_success']);
                    
                    $this->log_action(construct_phrase($vbphrase['mgc_cb_evo_log_unban_x'],$getuser['username']));
                    
                    return;    
                }      	
            }
            /*****************************/
            /** Del command              */
            /*****************************/
            else if ($this->check_and_parse_command_identifier("del",3)) {      	
                /* Purge chatbox */
                if ($this->raw_chat == "all") {   
                    $this->registry->db->query_write("
								TRUNCATE TABLE " . TABLE_PREFIX . "mgc_cb_evo_chat
						  ");
                    
                    $this->registry->db->query_write("
								ALTER TABLE " . TABLE_PREFIX . "mgc_cb_evo_chat AUTO_INCREMENT = 0
							");
                    
                    $this->log_action($vbphrase['mgc_cb_evo_log_del_all']);
                }
                /* All chats removal from the channel */
                else if ($this->raw_chat == "chan") {
                    $this->registry->db->query_write("
						DELETE
						FROM " . TABLE_PREFIX . "mgc_cb_evo_chat
						WHERE chanid='" . $this->mgc_cb_evo_chat['chanid'] . "'
					");
                    
                    $this->log_action(construct_phrase($vbphrase['mgc_cb_evo_log_del_chan_x'],$this->mgc_cb_evo_chat['chanid']));				
                }
                /* Removal of a user chats thanks to his userid */
                else if(substr($this->raw_chat,0,4) == "uid ") {
                    $userid = intval(trim(substr($this->raw_chat,4)));
                    
                    /* Let's check if the user exists */
                    $getuser = $this->registry->db->query_first("
						SELECT userid,username FROM " . TABLE_PREFIX . "user WHERE userid='$userid'
					");
                    
                    if (!isset($getuser['userid']))
                      {
                          $this->construct_popup($vbphrase['mgc_cb_evo_cmd_del_false_user']);
                          return;
                      }
                    
                    $this->registry->db->query_write("
						DELETE FROM " . TABLE_PREFIX . "mgc_cb_evo_chat WHERE fromuid='$userid' OR touid='$userid'
					");
                    
                    $this->log_action(construct_phrase($vbphrase['mgc_cb_evo_log_del_user_x'],$getuser['username']));
                }
                /* Removal of a user chats thanks to his username */
                else if(substr($this->raw_chat,0,6) == "uname ") {
                    $username = trim(substr($this->raw_chat,6));
                    
                    /* Let's check if the user exists */
                    $getuser = $this->registry->db->query_first("
						SELECT userid,username FROM " . TABLE_PREFIX . "user WHERE username='" . $this->registry->db->escape_string($username) . "'
					");
                    
                    if (!isset($getuser['userid'])) {
                        $this->construct_popup($vbphrase['mgc_cb_evo_cmd_del_false_user']);
                        return;
                    }
                    
                    $this->registry->db->query_write("
						DELETE FROM " . TABLE_PREFIX . "mgc_cb_evo_chat WHERE fromuid='" . $getuser['userid'] . "' OR touid='" . $getuser['userid'] . "'
					");
                    
                    $this->log_action(construct_phrase($vbphrase['mgc_cb_evo_log_del_user_x'],$getuser['username']));					
                }
                /* Removal of the chats older than x days */
                else if (substr($this->raw_chat,0,5) == "days ") {
                    $days = intval(trim(substr($this->raw_chat,5)));
                    
                    if ($days <= 0) {
                        $this->construct_popup($vbphrase['mgc_cb_evo_syntax_error']);
                        return;        
                    }
                    
                    $dateline = mktime(0, 0, 0, date("m"), date("d"),   date("Y")) - ($days * 86400);
                    
                    $this->registry->db->query_write("
						DELETE FROM " . TABLE_PREFIX . "mgc_cb_evo_chat WHERE dateline <= '$dateline'
					");
                    
                    $this->log_action(construct_phrase($vbphrase['mgc_cb_evo_log_del_day_x'],$days));
                }
                /* Removal of a chat with its given chatid */
                else if (substr($this->raw_chat,0,7) == "chatid ") {
                    $chatid = intval(trim(substr($this->raw_chat,7)));
                    
                    /* Let's check if the chat exists */
                    $getchat = $this->registry->db->query_first("
						SELECT chatid,username,ctext
						FROM " . TABLE_PREFIX . "mgc_cb_evo_chat AS c
						LEFT JOIN " . TABLE_PREFIX . "user AS u ON (c.fromuid=u.userid)
						WHERE chatid='$chatid'
					");
                    
                    if (!isset($getchat['chatid'])) {
                        $this->construct_popup($vbphrase['mgc_cb_evo_cmd_del_false_chat']);
                        return;
                    }
                    
                    $this->registry->db->query_write("
						DELETE FROM " . TABLE_PREFIX . "mgc_cb_evo_chat WHERE chatid='$chatid'
					");
                    
                    $this->log_action(construct_phrase($vbphrase['mgc_cb_evo_log_del_chat_of_x_with_text_y'],$getchat['username'],$getchat['ctext']));
                }
                else {
                    $this->construct_popup($vbphrase['mgc_cb_evo_syntax_error']);
                    return;   
                }
                
                $this->construct_popup($vbphrase['mgc_cb_evo_cmd_del_success'],1);
                return;      	      	
            }
            /*****************************/
            /** Ignore command           */
            /*****************************/
            else if ($this->check_and_parse_command_identifier("ignore",6)) {        	
                /* Parsing of the user already ignored users */
                if (!empty($this->registry->userinfo['mgc_cb_evo_ignored'])) {
                    $ignored_users = explode(',',$this->registry->userinfo['mgc_cb_evo_ignored']);
                }
                else {
                    $ignored_users = array();
                }
                
                /* Show currently ignored users */
                if ($this->raw_chat == "show") {
                    $this->action = "mgc_cb_evo_cmd_ignore_popup()";
                    return;
                } else if (substr($this->raw_chat,0,3) == "on ") {
                    $ignore_type = 1;
                    $this->raw_chat = substr($this->raw_chat,3);
                } else if (substr($this->raw_chat,0,4) == "off ") {
                    $ignore_type = 0;
                    $this->raw_chat = substr($this->raw_chat,4);
                } else {
                    $this->construct_popup($vbphrase['mgc_cb_evo_syntax_error']);
                    return;  
                }
                
                /* Userid specified */
                if (substr($this->raw_chat,0,4) == "uid ") {
                    $userid = intval(trim(substr($this->raw_chat,4)));
                    
                    /* Let's check if the user exists */
                    $getuser = $this->registry->db->query_first("
						SELECT userid FROM " . TABLE_PREFIX . "user WHERE userid='$userid'
					");
                } else if (substr($this->raw_chat,0,6) == "uname ") {
                    $username = $this->registry->db->escape_string(substr($this->raw_chat,6));
                    
                    /* Let's check if the user exists */
                    $getuser = $this->registry->db->query_first("
						SELECT userid FROM " . TABLE_PREFIX . "user WHERE username='$username'
					");
                } else {
                    $this->construct_popup($vbphrase['mgc_cb_evo_syntax_error']);
                    return;  
                }
                
                /* User tries to ignore himself */
                if ($getuser['userid'] == $this->registry->userinfo['userid']) {
					$this->construct_popup($vbphrase['mgc_cb_evo_cmd_ignore_cant_ignore_yourself']);
                    return;                  
                }                
                
                /* User is not existing */
                if (!isset($getuser['userid'])) {
                    $this->construct_popup($vbphrase['mgc_cb_evo_cmd_ignore_false_user']);
                    return;   
                }
                
                
                /* User is not a protected one */
                if (!empty($this->registry->options['mgc_cb_evo_cmd_ignore_protected_users'])) {
                    if (in_array($getuser['userid'],explode(',',$this->registry->options['mgc_cb_evo_cmd_ignore_protected_users']))) {
                        $this->construct_popup($vbphrase['mgc_cb_evo_cmd_ignore_cant_ignore_protected']);
                        return;  
                    }
                }                
                
                /* When user tries to ignore someone */
                if ($ignore_type) {
                    /* User is already in ignored list */
                    if (in_array($getuser['userid'],$ignored_users)) {
                        $this->construct_popup($vbphrase['mgc_cb_evo_cmd_ignore_already_ignored']);
                        return;         
                    }
                    
                    /* Let's add the user to the ignored list */
                    $ignored_users[] = $getuser['userid'];
                    
                    $this->registry->db->query_write("
						UPDATE " . TABLE_PREFIX . "user SET mgc_cb_evo_ignored='" . implode(',',$ignored_users) . "' WHERE userid='" . $this->registry->userinfo['userid'] . "'
					");
                    
                    $this->construct_popup($vbphrase['mgc_cb_evo_cmd_ignore_ignored_success'],1);
                    return;     
                } else {
                    /* User is not in ignored list */
                    if (!in_array($getuser['userid'],$ignored_users)) {
                        $this->construct_popup($vbphrase['mgc_cb_evo_cmd_ignore_not_ignored']);
                        return;         
                    }
                    
                    /* Let's remove the user from the ignored list */
                    foreach ($ignored_users as $index => $userid) {
                        if ($userid == $getuser['userid']) {
                            unset($ignored_users["$index"]);
                        }
                    }
                    
                    $this->registry->db->query_write("
						UPDATE " . TABLE_PREFIX . "user SET mgc_cb_evo_ignored='" . implode(',',$ignored_users) . "' WHERE userid='" . $this->registry->userinfo['userid'] . "'
					");
                    
                    $this->construct_popup($vbphrase['mgc_cb_evo_cmd_ignore_unignored_success'],1);
                    return;    
                }      	
            }
            /*****************************/
            /** PM command               */
            /*****************************/
            else if ($this->check_and_parse_command_identifier("pm",2)) {         		
                /* PM With username */
                if (strtolower(substr($this->raw_chat,0,6)) == "uname ") {
                    /* Trim the command parameter identifier */
                    $this->raw_chat = trim(substr($this->raw_chat,6));
                    
                    /* Retrieving of the username */
                    $getfirstquote = strpos($cmd, "\"") + 1;
                    $without_fquote = substr($this->raw_chat,$getfirstquote);
                    $getsecondquote = strpos($without_fquote,"\"");
                    $username = $this->registry->db->escape_string(substr($without_fquote,0,$getsecondquote));
                                       
                    	/* Get userinfo (get useful side info for avatar) */
                    	if (substr($this->registry->options['templateversion'],0,3) != "3.6")
                    	{
                    		$sql_add_fields = ",customavatar.height_thumb AS avheight_thumb, customavatar.width_thumb AS avwidth_thumb, customavatar.filedata_thumb";
                    	}                    	
                    	$getuser = $this->registry->db->query_first("
								SELECT 
									u.userid,u.usergroupid,u.membergroupids,u.displaygroupid,u.username,
									avatar.avatarpath, NOT ISNULL(customavatar.userid) AS hascustomavatar, customavatar.dateline AS avatardateline, 
									customavatar.width AS avwidth, customavatar.height AS avheight,u.avatarid,u.avatarrevision									
									$sql_add_fields
								FROM " . TABLE_PREFIX . "user AS u
								LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON (avatar.avatarid = u.avatarid)
								LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON (customavatar.userid = u.userid)
								WHERE u.username='$username'
							");
                    
                    $this->raw_chat = substr($without_fquote,$getsecondquote + 1);
                }
                /* PM with userid */
                else if (strtolower(substr($this->raw_chat,0,4)) == "uid ") {
                    /* Trim the command parameter identifier */
                    $this->raw_chat = trim(substr($this->raw_chat,4));
                    
                    /* Retrieving of the userid */
                    $getnextspace = strpos($this->raw_chat," ");
                    $userid = intval(substr($this->raw_chat,0,$getnextspace));
                   	
                   	/* Get userinfo (get useful side info for avatar) */
                    	if (substr($this->registry->options['templateversion'],0,3) != "3.6")
                    	{
                    		$sql_add_fields = ",customavatar.height_thumb AS avheight_thumb, customavatar.width_thumb AS avwidth_thumb, customavatar.filedata_thumb";
                    	}                   	
                    	$getuser = $this->registry->db->query_first("
								SELECT u.userid,u.usergroupid,u.membergroupids,u.displaygroupid,u.username,
											avatar.avatarpath, NOT ISNULL(customavatar.userid) AS hascustomavatar, customavatar.dateline AS avatardateline, 
											customavatar.width AS avwidth, customavatar.height AS avheight,u.avatarid,u.avatarrevision									
											$sql_add_fields
								FROM " . TABLE_PREFIX . "user AS u
								LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON (avatar.avatarid = u.avatarid)
								LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON (customavatar.userid = u.userid)
								WHERE u.userid='$userid'
							");
                    
                    $this->raw_chat = substr($this->raw_chat,$getnextspace + 1);
                }
                /* Syntax error */
                else {
                   	 /* No user specified, PM is dedicated to last spoken user in the channel */
                    	if (substr($this->registry->options['templateversion'],0,3) != "3.6")
                    	{
                    		$sql_add_fields = ",customavatar.height_thumb AS avheight_thumb, customavatar.width_thumb AS avwidth_thumb, customavatar.filedata_thumb";
                    	}        
                    	     	 
                    	$getuser = $this->registry->db->query_first("
								SELECT u.userid,u.usergroupid,u.membergroupids,u.displaygroupid,u.username,
											avatar.avatarpath, NOT ISNULL(customavatar.userid) AS hascustomavatar, customavatar.dateline AS avatardateline, 
											customavatar.width AS avwidth, customavatar.height AS avheight,u.avatarid,u.avatarrevision						
											$sql_add_fields
								FROM " . TABLE_PREFIX . "mgc_cb_evo_chat AS c
								LEFT JOIN " . TABLE_PREFIX . "user AS u ON (u.userid=c.touid)
								LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON (avatar.avatarid = u.avatarid)
								LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON (customavatar.userid = u.userid)
								WHERE coidentifier='pm' AND touid!='" . $this->registry->userinfo['userid'] . "' AND fromuid='" . $this->registry->userinfo['userid'] . "' AND chanid='" . $this->mgc_cb_evo_chat['chanid'] . "'
								ORDER BY c.dateline DESC
								LIMIT 1
							");
                }
                
                if (isset($getuser['userid'])) {
                    
                    /* Get pm command permissions */
                    $getpmpermissions = $this->registry->db->query_first("
								SELECT usergroupids,userids
								FROM " . TABLE_PREFIX . "mgc_cb_evo_command
								WHERE identifier='pm'
						  ");
                    
                    /** It's time to check if the user has access to the command */
                    $authorized = 0;
                    
                    /* Usergroupids */
                    if (!empty($getpmpermissions['usergroupids'])) {
                        $ugipds_array = explode(',',$getpmpermissions['usergroupids']);
                        
                        if (in_array($getuser['usergroupid'],$ugipds_array)) {
                            $authorized = 1;
                        }
                        
                        if (!empty($getuser['membergroupids'])) {
                            $mgids_array = explode(',', $getuser['membergroupids']);
                            
                            foreach ($mgids_array as $index => $mgpid) {
                                if (in_array($mgpid,$ugipds_array)) {
                                    $authorized = 1;
                                }
                            }
                        }      
                    }
                    
                    /* Userids if not already authorized */
                    if (!$authorized && !empty($getpmpermissions['userids'])) {
                        $uids_array = explode(',',$getpmpermissions['userids']);
                        
                        if (in_array($getuser['userid'],$uids_array)) {
                            $authorized = 1;
                        }
                    }
                    
                    /* Receiver not authorized => error */
                    if (!$authorized) {
                        $this->construct_popup($vbphrase['mgc_cb_evo_pm_receiver_not_authorized']);
                        return;   	  
                    }
                    
                    $this->do_set('touid', $getuser['userid']);
                    $this->set("coidentifier","pm");
                } else {
                    $this->construct_popup($vbphrase['mgc_cb_evo_pm_false_user']);
                    return;     
                }  
            }   
            /*****************************/
            /** Slap command             */
            /*****************************/
            else if ($this->check_and_parse_command_identifier("slap",4)) {                 		
                /* Userid specified */
                if (substr($this->raw_chat,0,4) == "uid ") {
                    $userid = intval(trim(substr($this->raw_chat,4)));
                    
                    /* Let's check if the user exists */
                    $getuser = $this->registry->db->query_first("
						SELECT username FROM " . TABLE_PREFIX . "user WHERE userid='$userid'
					");
                } else if (substr($this->raw_chat,0,6) == "uname ") {
                    $username = $this->registry->db->escape_string(substr($this->raw_chat,6));
                    
                    /* Let's check if the user exists */
                    $getuser = $this->registry->db->query_first("
						SELECT username FROM " . TABLE_PREFIX . "user WHERE username='$username'
					");
                } else {
                    // Syntax error
                      $this->construct_popup($vbphrase['mgc_cb_evo_syntax_error']);
                }
                
                if (isset($getuser['username'])) {						      		
                    $this->set("coidentifier","slap");
                    $this->parse_bbcode 	= 1;
                    $this->accept_userpref 	= 0;
                    $this->raw_chat 		= $getuser['username'];
                } else {
                    $this->construct_popup($vbphrase['mgc_cb_evo_slap_false_user']);
                    return;     
                }  
                
            }  	
        }	 
        
        if ($this->parse_bbcode) {
            require_once (DIR . '/includes/class_bbcode.php');
            $parser = &new vB_BbCodeParser($this->registry, $this->construct_bbcode_tag_list(true));
            $parsed_chat = $parser->do_parse($this->raw_chat, false, $this->registry->options['mgc_cb_evo_smileys'], $this->registry->options['mgc_cb_evo_bbcode'], false, false, false);
            
            /* Maximum smileys allowed */
            if (substr_count($parsed_chat, "<img") > $this->registry->options['mgc_cb_evo_nbsmileys']) {
                /* Error */
                $this->construct_popup(construct_phrase($vbphrase['mgc_cb_evo_too_much_smileys'],
                                                        $this->registry->options['mgc_cb_evo_nbsmileys']));
                return;
            }
            
            /* If URL BBCODE is authorized, we need to parse the url in the chat */
            if ($this->registry->options['mgc_cb_evo_bbcode_url']) {
                require_once (DIR . '/includes/functions_newpost.php');
                $this->raw_chat = convert_url_to_bbcode($this->raw_chat);
            }
        }
        
        /* Add the user preferences to the raw chat if they are allowed in the command*/
        if ($this->accept_userpref) {
            $this->add_user_pref_to_raw_chat();
        }

        /* If no command => identifier at 0 */
        if (!$this->contain_command) {
            $this->set('coidentifier',0);
        }       
        
        $timenow = TIMENOW;
        $this->do_set('dateline', $timenow);
        $this->do_set('fromuid', $this->registry->userinfo['userid']);
        $this->do_set('ctext', $this->raw_chat);
               
			/* Get avatar info only if not anonymous */
			if ($this->registry->userinfo['usergroupid'] != 1)
			{			
				/* Get from user info */
				$userid = intval($this->registry->userinfo['userid']);
				if (substr($this->registry->options['templateversion'],0,3) != "3.6")
				{
					$sql_add_fields = ",customavatar.height_thumb AS avheight_thumb, customavatar.width_thumb AS avwidth_thumb, customavatar.filedata_thumb";
				}                 
				$getfromuser = $this->registry->db->query_first("
					SELECT 
						u.userid,u.usergroupid,u.membergroupids,u.displaygroupid,
						avatar.avatarpath, NOT ISNULL(customavatar.userid) AS hascustomavatar, customavatar.dateline AS avatardateline, 
						customavatar.width AS avwidth, customavatar.height AS avheight,u.avatarid,u.avatarrevision									
						$sql_add_fields
					FROM " . TABLE_PREFIX . "user AS u
					LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON (avatar.avatarid = u.avatarid)
					LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON (customavatar.userid = u.userid)
					WHERE u.userid='$userid'
				");        	
				
   		   $this->do_set('usergroupid', $getfromuser['usergroupid']);
	        	$this->do_set('displaygroupid', $getfromuser['displaygroupid']);				
				$this->do_set('hascustomavatar',$getfromuser['hascustomavatar']);
				$this->do_set('avatarpath',$getfromuser['avatarpath']);
				$this->do_set('avatardateline',$getfromuser['avatardateline']);
				$this->do_set('avwidth',$getfromuser['avwidth']);
				$this->do_set('avheight',$getfromuser['avheight']);
				$this->do_set('avwidth_thumb',$getfromuser['avwidth_thumb']);
				$this->do_set('avheight_thumb',$getfromuser['avheight_thumb']);
				$this->do_set('filedata_thumb',$getfromuser['filedata_thumb']);
				$this->do_set('avatarid',$getfromuser['avatarid']);
				$this->do_set('avatarrevision',$getfromuser['avatarrevision']);
				
				if ($this->mgc_cb_evo_chat['coidentifier'] == 'pm')
				{
					$this->do_set('toname', $getuser['username']);
					$this->do_set('tousergroupid', $getuser['usergroupid']);
					$this->do_set('todisplaygroupid', $getuser['displaygroupid']);				
					$this->do_set('tohascustomavatar',$getuser['hascustomavatar']);
					$this->do_set('toavatarpath',$getuser['avatarpath']);
					$this->do_set('toavatardateline',$getuser['avatardateline']);
					$this->do_set('toavwidth',$getuser['avwidth']);
					$this->do_set('toavheight',$getuser['avheight']);
					$this->do_set('toavwidth_thumb',$getuser['avwidth_thumb']);
					$this->do_set('toavheight_thumb',$getuser['avheight_thumb']);
					$this->do_set('tofiledata_thumb',$getuser['filedata_thumb']);
					$this->do_set('toavatarid',$getuser['avatarid']);
					$this->do_set('toavatarrevision',$getuser['avatarrevision']);				
				}
			}
			else
			{
   		   $this->set('usergroupid', 0);
	        	$this->set('displaygroupid', 0);		
				$this->set('hascustomavatar',0);
				$this->set('avatarpath','');
				$this->set('avatardateline',0);
				$this->set('avwidth',0);
				$this->set('avheight',0);
				$this->set('avwidth_thumb',0);
				$this->set('avheight_thumb',0);
				$this->set('filedata_thumb','');
				$this->set('avatarid',0);
				$this->set('avatarrevision',0);
			}        
    }

    function save() {
    	// Update user chat count if option is active
    	if ($this->registry->options['mgc_cb_evo_count_userchats']) 
    	{
    		$this->registry->db->query_write("UPDATE " . TABLE_PREFIX . "user SET mgc_cb_evo_nbchats=mgc_cb_evo_nbchats+1 WHERE userid='" . $this->registry->userinfo['userid'] . "'");
    	}  
    
    	// Insert the chat
        $this->db_insert(TABLE_PREFIX, 'mgc_cb_evo_chat', true);
    }

    /* Popup message for UI display construction */
    function construct_popup($error_msg,$dofullreload = 0) {
        /* Construct popup */
        $this->action = "mgc_cb_js_showpopup('" . addslashes_js($error_msg) . "','');";
        /* Check if full reload needed */
        if ($dofullreload) {
        		$this->action .= "exec_chatbox_clear(1);";
        }
    }

    /* Building of the allowed bbcode array for the parsing function */
    function construct_bbcode_tag_list($with_color) {
        $bbcode_list = array();

        if ($this->registry->options['mgc_cb_evo_bbcode']) {
            $bbcode_list['no_option']['b'] = array('html' => '<b>%1$s</b>', 'strip_empty' => true);

            $bbcode_list['no_option']['i'] = array('html' => '<i>%1$s</i>', 'strip_empty' => true);

            $bbcode_list['no_option']['u'] = array('html' => '<u>%1$s</u>', 'strip_empty' => true);

            if ($with_color) {
                $bbcode_list['option']['color'] = array('html' =>
                                                        '<font color="%2$s">%1$s</font>', 'option_regex' => '#^\#?\w+$#', 'strip_empty' => true);
            }

            $bbcode_list['option']['size'] = array('html' => '<font size="%2$s">%1$s</font>',
                                                   'option_regex' => '#^[0-9\+\-]+$#', 'strip_empty' => true);

            $bbcode_list['option']['font'] = array('html' => '<font face="%2$s">%1$s</font>',
                                                   'option_regex' => '#^[^["`\':]+$#', 'strip_empty' => true);
        }

        if ($this->registry->options['mgc_cb_evo_bbcode_url']) {
            $bbcode_list['no_option']['url'] = array('callback' => 'handle_bbcode_url',
                                                     'strip_empty' => true);

            $bbcode_list['option']['url'] = array('callback' => 'handle_bbcode_url',
                                                  'strip_empty' => true);

        }

        return $bbcode_list;
    }

    /* Verifies that the given option can be selected by a user (ie. active in the acp) */
    function is_userpref_active($userpref_name) {
        switch ($userpref_name) {
          case "font":
            return $this->registry->options['mgc_cb_evo_user_format_options'] & 1;
            break;
          case "size":
            return $this->registry->options['mgc_cb_evo_user_format_options'] & 2;
            break;
          case "color":
            return $this->registry->options['mgc_cb_evo_user_format_options'] & 4;
            break;
          case "b":
            return $this->registry->options['mgc_cb_evo_user_format_options'] & 8;
            break;
          case "i":
            return $this->registry->options['mgc_cb_evo_user_format_options'] & 16;
            break;
          case "u":
            return $this->registry->options['mgc_cb_evo_user_format_options'] & 32;
            break;
        }
    }

    /* Add the user preferences to the raw chat */
    function add_user_pref_to_raw_chat() {
        $endchat = '';

        if ($this->registry->userinfo['mgc_cb_evo_u'] && $this->is_userpref_active("u")) {
            $this->raw_chat = '[U]' . $this->raw_chat;
            $endchat = $endchat . '[/U]';
        }

        if ($this->registry->userinfo['mgc_cb_evo_i'] && $this->is_userpref_active("i")) {
            $this->raw_chat = '[I]' . $this->raw_chat;
            $endchat = $endchat . '[/I]';
        }

        if ($this->registry->userinfo['mgc_cb_evo_b'] && $this->is_userpref_active("b")) {
            $this->raw_chat = '[B]' . $this->raw_chat;
            $endchat = $endchat . '[/B]';
        }

        if ($this->registry->userinfo['mgc_cb_evo_size'] && $this->is_userpref_active("size")) {
            if ($this->registry->userinfo['mgc_cb_evo_size'] <= $this->registry->options['mgc_cb_evo_max_bbcode_size']) {
                $this->raw_chat = '[size=' . $this->registry->userinfo['mgc_cb_evo_size'] . ']' .
                  $this->raw_chat;
            } else {
                $this->raw_chat = '[size=' . $this->registry->options['mgc_cb_evo_max_bbcode_size'] .
                  ']' . $this->raw_chat;
            }
            $endchat = $endchat . '[/size]';
        }

        /* User has selected a color */
        if ($this->registry->userinfo['mgc_cb_evo_color'] && $this->is_userpref_active("color")) {
            $this->raw_chat = '[color=#' . $this->registry->userinfo['mgc_cb_evo_color'] .
              ']' . $this->raw_chat;
            $endchat = $endchat . '[/color]';
        }
        /* Applies usergroup color if different from 000000 */
        else if(!empty($this->registry->userinfo['mgc_cb_evo_default_color']) && $this->registry->userinfo['mgc_cb_evo_default_color'] != "000000") {
            $this->raw_chat = '[color=#' . $this->registry->userinfo['mgc_cb_evo_default_color'] .
              ']' . $this->raw_chat;
            $endchat = $endchat . '[/color]';         
        }

        if ($this->registry->userinfo['mgc_cb_evo_font'] && $this->is_userpref_active("font")) {
            $this->raw_chat = '[font=' . $this->registry->userinfo['mgc_cb_evo_font'] . ']' .
              $this->raw_chat;
            $endchat = $endchat . '[/font]';
        }

        $this->raw_chat .= $endchat;
    }
    
    /* Strip the command identifier from the chat */
    function check_and_parse_command_identifier($command_identifier,$command_size) {
        /* User hasn't access to that command */
        if (!in_array($command_identifier,$this->user_commands)) {
            return false;
        }
        
        /* Retrieves only the command identifier */
        $tempchat = strtolower($this->raw_chat);
        $tempchat = substr($tempchat,1,$command_size + 1);
        
        /* Command not found */
        if ($tempchat != $command_identifier . " ") {
            return false;
        }
        
        $this->contain_command = 1;
        
        /* Strip the command from the chat */
        $this->raw_chat = trim(substr($this->raw_chat, $command_size + 1));
        
        return true;
    }
    
    /* Log action into database if log action option is active*/
    function log_action($phrase)
      {
          if ($this->registry->options['mgc_cb_evo_log_action']) {
              $this->registry->db->query_write("
				INSERT INTO " . TABLE_PREFIX . "mgc_cb_evo_log
				SET dateline='" . TIMENOW . "',username='" . $this->registry->db->escape_string($this->registry->userinfo['username']) . "',
					ltext='" . $this->registry->db->escape_string($phrase) . "'
			");
          }
      }
}

?>