<?php

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'mgc_cb_evo_ajax');
define('LOCATION_BYPASS', 1);
define('NOPMPOPUP', 1);
define('CSRF_PROTECTION', true);

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array();

// get special data templates from the datastore
$specialtemplates = array('bbcodecache');

// pre-cache templates used by all actions
$globaltemplates = array(
                         'mgc_cb_evo_editor',
                         'mgc_cb_evo_chatbit',
                         'mgc_cb_evo_chatbit_menu',
                         'editor_jsoptions_font',
                         'editor_jsoptions_size'
                         );

// pre-cache templates used by specific actions
$actiontemplates = array();

$_POST['ajax'] = 1;

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/class_xml.php');
require_once (DIR . '/includes/functions_mgc_cb_evo.php');
require_once (DIR . '/includes/class_bbcode.php');

// Chatbox content refresh 
if ($_POST['do'] == 'ajax_refresh_chat') {
    // Chatbox status (open or closed) 
    $status 	= $vbulletin->input->clean_gpc('p', 'status', TYPE_STR);

    // Channel id 
    $channel_id = $vbulletin->input->clean_gpc('p', 'channel_id', TYPE_UINT);

    // Chatbox location : on a vbulletin page or in its own page (full mode) 
    $location 	= $vbulletin->input->clean_gpc('p', 'location', TYPE_STR);
    
    // First load 
    $first_load = $vbulletin->input->clean_gpc('p', 'first_load', TYPE_UINT);

    // Chatids array joined 
    $chatids  	= $vbulletin->input->clean_gpc('p', 'chatids', TYPE_STR);       
    
    // Special chatids array joined 
    $schatids 	= $vbulletin->input->clean_gpc('p', 'schatids', TYPE_STR); 
    
    // Normal chats handling 
    if (empty($chatids)) {
        $chatids_array 		= array();
        $skip_older_check 	= 1;
    } else {
        $chatids_array 	= split(',',$chatids);
        $skip_older_check 	= 0;
    }
    
    // Special chats handling in case of separation 
    if ($vbulletin->options['mgc_cb_evo_separate_special_chats'])
    {
		if (empty($schatids)) {
			$schatids_array 	= array();
			$skip_solder_check 	= 1;
		} else {
			$schatids_array 	= split(',',$schatids);
			$skip_solder_check 	= 0;
		}    
    }
    
    $chats = '';
    
    $xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
    $xml->add_group('chats');

    if (can_view_mgc_cb_evo()) {            
        // First load inactive mode => Update session table 
        if ($first_load && $vbulletin->options['mgc_cb_evo_inactive_mode'] && $vbulletin->options['mgc_cb_evo_whoisonline_active']) {
            $vbulletin->db->query_write("REPLACE INTO " . TABLE_PREFIX . "mgc_cb_evo_session SET userid='" . $vbulletin->userinfo['userid'] . "',dateline='" . TIMENOW . "'");
        }
        
        // Warning channels activated => lets refresh it 
        if ($vbulletin->options['mgc_cb_evo_channels_warning']) {
            if (empty($vbulletin->userinfo['mgc_cb_evo_channel_activities'])) {
                $channel_activities = array($channel_id => TIMENOW);
            } else {
                $channel_activities = unserialize($vbulletin->userinfo['mgc_cb_evo_channel_activities']);
                $channel_activities["$channel_id"] = TIMENOW;
            }
            $serialized_channel_activities = serialize($channel_activities);
            
            $vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET mgc_cb_evo_channel_activities='$serialized_channel_activities' WHERE userid='".  $vbulletin->userinfo['userid'] . "'");
        }

        //* Retrieving of the commands permissions and status *
        $getcommands = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "mgc_cb_evo_command");
        
        $ugipds_array = array($vbulletin->userinfo['usergroupid']);
        if (!empty($vbulletin->userinfo['membergroupids'])) {
            $ugipds_array = array_merge($ugipds_array,explode(',', $vbulletin->userinfo['membergroupids']));
        }	

        $identifier_array = array('\'0\'');
        
        while($command = $vbulletin->db->fetch_array($getcommands)) {
            if ($command['active']) {
                $hasaccess = 0;
                
                if (!empty($command['usergroupids'])) {
                    $command_ugpids_array = explode(',',$command['usergroupids']);
                    
                    foreach ($ugipds_array as $index => $ugpid) {
                        if (in_array($ugpid,$command_ugpids_array)) {
                            $hasaccess = 1;
                        }
                    }
                }
                
                if (!empty($command['userids'])) {
                    $command_uids_array = explode(',',$command['userids']);
                    
                    if (in_array($vbulletin->userinfo['userid'],$command_uids_array)) {
                        $hasaccess = 1;
                    }
                }
                
                if ($hasaccess) {
                    $identifier_array[] = "'" . $command['identifier'] . "'";
                    $commands_status["$command[identifier]"] = '1';								
                } else {
                    $commands_status["$command[identifier]"] = '0';		
                }
            } else {
                $commands_status["$command[identifier]"] = '0';		
            }
        }      
        
        unset($getcommands);

        //* Building the chats retrieving query *
        $left_join = "";
        
        // Not private chats where clause       
        $where_clause = "
							chanid='$channel_id' 
							AND coidentifier IN (" . implode(',',$identifier_array) . ") 
							AND (touid='0' OR fromuid='" . $vbulletin->userinfo['userid'] . "' 
							OR touid='" . $vbulletin->userinfo['userid'] . "')
							AND iswarning='0'
						";      

        // Ignore command where clause       
        if ($commands_status['ignore'] && !empty($vbulletin->userinfo['mgc_cb_evo_ignored'])) {
            $where_clause .= " AND fromuid NOT IN (" . $vbulletin->userinfo['mgc_cb_evo_ignored'] . ")";
            $where_clause .= " AND touid NOT IN (" . $vbulletin->userinfo['mgc_cb_evo_ignored'] . ")";
        }
        
        // Forumids in case of newthread or newpost warn active 
        if ($vbulletin->options['mgc_cb_evo_warn_newthread'] || $vbulletin->options['mgc_cb_evo_warn_newpost'])
        {
				$allowed_forumids = array_keys($vbulletin->forumcache);
				
				// get forum ids for all forums user is allowed to view
				foreach ($allowed_forumids AS $index => $forumid)
				{
					$fperms =& $vbulletin->userinfo['forumpermissions']["$forumid"];
					$forum =& $vbulletin->forumcache["$forumid"];
				
					if (!($fperms & $vbulletin->bf_ugp_forumpermissions['canview']) OR !verify_forum_password($forumid, $forum['password'], false))
					{
						unset($allowed_forumids["$index"]);
					}
				}
				$allowed_forumids = implode(',',$allowed_forumids);
        }        

        // Get notifications only when not in collapsed mode 
        $sql_where_clause_notifs 	= "";
        $sql_add_field_notifs 		= "";
        $sql_left_join_notifs 		= "";        
        if ($status != "closed")
        {
        	// If same query for chats and notifications : construct additional where clause 
        	if ($vbulletin->options['mgc_cb_evo_separate_chatsnotif_sql'] == 0)
        	{        
				// Newthread warning where clause 
				if ($vbulletin->options['mgc_cb_evo_warn_newthread'] && !empty($allowed_forumids))
				{
					$sql_where_clause_notifs .= " OR (iswarning='1' AND warningtype='thread' AND tpforumid IN($allowed_forumids))";
				}
		
				// Newpost warning where clause
				if ($vbulletin->options['mgc_cb_evo_warn_newpost'] && !empty($allowed_forumids))
				{
					$sql_where_clause_notifs .= " OR (iswarning='1' AND warningtype='post' AND tpforumid IN($allowed_forumids))";
				}
				
				($hook = vBulletinHook::fetch_hook('mgc_cb_evo_notifs_sql_together')) ? eval($hook) : false;
		
			}
			// Else : construct where clause for notifications query 
			else
			{
				// Newthread warning where clause 
				if ($vbulletin->options['mgc_cb_evo_warn_newthread'] && !empty($allowed_forumids))
				{
					$sql_where_clause_notifs .= "(iswarning='1' AND warningtype='thread' AND tpforumid IN($allowed_forumids))";
				}
		
				// Newpost warning where clause
				if ($vbulletin->options['mgc_cb_evo_warn_newpost'] && !empty($allowed_forumids))
				{
					if (!empty($sql_where_clause_notifs))
					{
						$sql_where_clause_notifs .= " OR (iswarning='1' AND warningtype='post' AND tpforumid IN($allowed_forumids))";
					}
					else
					{
						$sql_where_clause_notifs .= "(iswarning='1' AND warningtype='post' AND tpforumid IN($allowed_forumids))";					
					}
				}			
			
				($hook = vBulletinHook::fetch_hook('mgc_cb_evo_notifs_sql_separate')) ? eval($hook) : false;
			}
        }

        // LIMIT clause construction 
        if ($status == "closed") {
            $limit = $vbulletin->options['mgc_cb_evo_nbchats_closed'];
        } else if ($location == "full") {
            $limit = $vbulletin->options['mgc_cb_evo_nbchats_full'];
        } else {
            $limit = $vbulletin->options['mgc_cb_evo_nbchats_normal'];
        }      
	  	
	  	// Retrieving of the notifications is separated 
	  	if ($vbulletin->options['mgc_cb_evo_separate_chatsnotif_sql'] && $status != "closed" && !empty($sql_where_clause_notifs))
	  	{
			$chats = $vbulletin->db->query_read("
				(
				 SELECT c.*
				 $sql_add_field_notifs
				 FROM " . TABLE_PREFIX . "mgc_cb_evo_chat AS c
				 $sql_left_join_notifs
				 WHERE $where_clause
				 ORDER BY sticky DESC,c.dateline DESC
				 LIMIT $limit
				)
				UNION ALL
				(
				 SELECT c.*
				 $sql_add_field_notifs
				 FROM " . TABLE_PREFIX . "mgc_cb_evo_chat AS c
				 $sql_left_join_notifs
				 WHERE $sql_where_clause_notifs
				 ORDER BY sticky DESC,c.dateline DESC
				 LIMIT " . $vbulletin->options['mgc_cb_evo_nb_notifs'] . "		
				)
			");	  		
	  	}
	  	else
	  	{
			$chats = $vbulletin->db->query_read("
				 SELECT c.*
				 $sql_add_field_notifs
				 FROM " . TABLE_PREFIX . "mgc_cb_evo_chat AS c			
				 $sql_left_join_notifs
				 WHERE ($where_clause) $sql_where_clause_notifs
				 ORDER BY sticky DESC,c.dateline DESC
				 LIMIT $limit
			");	  	
	  	}

        // Tri des messages selon l'ordre d'affichage (ascendant ou descendant) 
        $nbchats = $vbulletin->db->num_rows($chats);     
        $new_chatids_array = array();
        $new_schatids_array = array();

        if ($nbchats) {
            $parsebbcode	 = $vbulletin->options['mgc_cb_evo_bbcode'] || $vbulletin->options['mgc_cb_evo_bbcode_url'] || $vbulletin->options['mgc_cb_evo_bbcode_img'];         
                       
            $mintime = 0;
            $cpt = $nbchats - 1;
            
            while ($chat = $vbulletin->db->fetch_array($chats)) {                                        
                // Chat was edited or first load ? 
                if ($chat['editdate'] == 0 || $first_load || !in_array($chat['chatid'],$chatids_array)) {      	
                    $hasbeenedited = 0;
                } else {
                    $editoffset = TIMENOW - $chat['editdate'];
                    
                    if ($editoffset < $permissions['mgc_cb_evo_refreshrate']) {
                        $hasbeenedited = 1;
                    } else {
                        $hasbeenedited = 0;
                    }
                }
                
                
                // In case of specialchats separated, manage code separately 
                if ($vbulletin->options['mgc_cb_evo_separate_special_chats'])
                {
                	// Management of the notification 
                	if ($chat['iswarning'])
                	{
	                	$new_schatids_array[] = $chat['chatid'];
	                	
						// Notification not already in the chatbox or has been edited 
						if (!in_array($chat['chatid'],$schatids_array) || $hasbeenedited) {                                       
							$chat_cols = fetch_chat_info($chat, $parsebbcode, $commands_status, $channel_id);                    
							$schatbits_array["$cpt"] = array('chatid' => $chat['chatid'],'chat_cols' => $chat_cols, 'edited' => $hasbeenedited, 'specialchat' => $chat['iswarning'], 'sticky' => 0, 'dateline' => $chat['dateline']);
						}
						
						// Register the oldest notification timeline currently in the chatbox 
						if (in_array($chat['chatid'],$schatids_array))
						{
							if (($smintime == 0) || ($chat['dateline'] < $smintime))
							{
								$smintime = $chat['dateline'];
							}
						}                        	
                	
                	}
                	// Management of the chats 
                	else
                	{
	                	$new_chatids_array[] = $chat['chatid'];
	                	
						// Chat not already in the chatbox or has been edited 
						if (!in_array($chat['chatid'],$chatids_array) || $hasbeenedited) {                                       
							$chat_cols = fetch_chat_info($chat, $parsebbcode, $commands_status, $channel_id);                    
							$chatbits_array["$cpt"] = array('chatid' => $chat['chatid'],'chat_cols' => $chat_cols, 'edited' => $hasbeenedited, 'specialchat' => $chat['iswarning'], 'sticky' => $chat['sticky'], 'dateline' => $chat['dateline']);
						}
						
						// Register the oldest chat (non stickied) timeline currently in the chatbox 
						if (in_array($chat['chatid'],$chatids_array))
						{
							if (($mintime == 0) || (($chat['dateline'] < $mintime) && !$chat['sticky']))
							{
								$mintime = $chat['dateline'];
							}
						}                        	
                	}                   
                }
                else
                {
					$new_chatids_array[] = $chat['chatid'];

					// Chat not already in the chatbox or has been edited 
					if (!in_array($chat['chatid'],$chatids_array) || $hasbeenedited) {                                       
						$chat_cols = fetch_chat_info($chat, $parsebbcode, $commands_status, $channel_id);                    
						$chatbits_array["$cpt"] = array('chatid' => $chat['chatid'],'chat_cols' => $chat_cols, 'edited' => $hasbeenedited, 'specialchat' => $chat['iswarning'], 'sticky' => $chat['sticky'], 'dateline' => $chat['dateline']);
					}
					
					// Register the oldest chat (non stickied) timeline currently in the chatbox 
					if (in_array($chat['chatid'],$chatids_array))
					{
						if (($mintime == 0) || (($chat['dateline'] < $mintime) && !$chat['sticky']))
						{
							$mintime = $chat['dateline'];
						}
					}                   
                }		         
                
                $cpt--;                
            }    
        }
        
        // Let's build the xml 
        if (sizeof($chatids_array)) {
            // Remove no more used chats if received array is not empty 
            foreach($chatids_array AS $index => $chatid) {
                if (!in_array($chatid,$new_chatids_array)) {
                    $xml->add_tag('chat','',array('type' => '3','chatid' => $chatid,'specialchat' => '0'));
                    unset($chatids_array["$chatid"]);
                }
            }
        }

        // Lowest chatid before update 
        if (sizeof($chatids_array))
        {
        	$current_lowestchatid = min($chatids_array);
		}
		else
		{
			$current_lowestchatid = 0;
		}

		if(is_array($chatbits_array)) {				
			uasort($chatbits_array,'array_compare_dateline');
						
			foreach($chatbits_array AS $index => $tab) {
				if ($tab['edited']) {
					$xml->add_tag(
						'chat',
						'',
						array(
							'type' 			=> '1',
							'chatid' 		=> $tab['chatid'],
							'sticky' 		=> $tab['sticky'],
							'oldchat'		=> '0',
							'specialchat'	=> $tab['specialchat'],
							'col_avatar'	=> $tab['chat_cols']['col_avatar'],
							'col_chat'		=> $tab['chat_cols']['col_chat'],
							'col_date'		=> $tab['chat_cols']['col_date'],
							'col_menu'		=> $tab['chat_cols']['col_menu'],
							'col_sticky'	=> $tab['chat_cols']['col_sticky'],
							'col_uname'		=> $tab['chat_cols']['col_uname']
						)
					);
				} else {
					// If chat is an older chat added due to other chat removal 
					if (!$skip_older_check && !in_array($tab['chatid'],$chatids_array) && ($tab['dateline'] < $mintime))
					{
						 $xml->add_tag(
							'chat',
							'',
							array(
								'type' 			=> '0',
								'chatid' 		=> $tab['chatid'],
								'sticky' 		=> $tab['sticky'],
								'oldchat'		=> '1',
								'specialchat'	=> $tab['specialchat'],
								'col_avatar'	=> $tab['chat_cols']['col_avatar'],
								'col_chat'		=> $tab['chat_cols']['col_chat'],
								'col_date'		=> $tab['chat_cols']['col_date'],
								'col_menu'		=> $tab['chat_cols']['col_menu'],
								'col_sticky'	=> $tab['chat_cols']['col_sticky'],
								'col_uname'		=> $tab['chat_cols']['col_uname']
							)
						);
					}
					else
					{
						 $xml->add_tag(
							'chat',
							'',
							array(
								'type' 			=> '0',
								'chatid' 		=> $tab['chatid'],
								'sticky' 		=> $tab['sticky'],
								'oldchat'		=> '0',
								'specialchat'	=> $tab['specialchat'],
								'col_avatar'	=> $tab['chat_cols']['col_avatar'],
								'col_chat'		=> $tab['chat_cols']['col_chat'],
								'col_date'		=> $tab['chat_cols']['col_date'],
								'col_menu'		=> $tab['chat_cols']['col_menu'],
								'col_sticky'	=> $tab['chat_cols']['col_sticky'],
								'col_uname'		=> $tab['chat_cols']['col_uname']
							)
						);					
					}                    
				}
			}
		}
        
        //* Notification separated from chats - Let's manage them *
        if ($vbulletin->options['mgc_cb_evo_separate_special_chats'])
        {
			if (sizeof($schatids_array)) {
				// Remove no more used notifications if received array is not empty 
				foreach($schatids_array AS $index => $chatid) {
					if (!in_array($chatid,$new_schatids_array)) {
						$xml->add_tag('chat','',array('type' => '3','chatid' => $chatid,'specialchat' => '1'));
						unset($schatids_array["$chatid"]);
					}
				}
			}        
			
			// Lowest notification chatid before update 
			if (sizeof($schatids_array))
			{
				$current_lowestschatid = min($schatids_array);
			}
			else
			{
				$current_lowestschatid = 0;
			}			
        }
      	
		if(is_array($schatbits_array)) {	
			uasort($schatbits_array,'array_compare_dateline');
						
			foreach($schatbits_array AS $index => $tab) {
				if ($tab['edited']) {
					$xml->add_tag(
						'chat',
						'',
						array(
							'type' 			=> '1',
							'chatid' 		=> $tab['chatid'],
							'sticky' 		=> $tab['sticky'],
							'oldchat'		=> '0',
							'specialchat'	=> $tab['specialchat'],
							'col_avatar'	=> $tab['chat_cols']['col_avatar'],
							'col_chat'		=> $tab['chat_cols']['col_chat'],
							'col_date'		=> $tab['chat_cols']['col_date'],
							'col_menu'		=> $tab['chat_cols']['col_menu'],
							'col_sticky'	=> $tab['chat_cols']['col_sticky'],
							'col_uname'		=> $tab['chat_cols']['col_uname']
						)
					);
				} else {
					// If chat is an older chat added due to other chat removal 
					if (!$skip_solder_check && !in_array($tab['chatid'],$schatids_array) && ($tab['dateline'] < $smintime))
					{
						 $xml->add_tag(
							'chat',
							'',
							array(
								'type' 			=> '0',
								'chatid' 		=> $tab['chatid'],
								'sticky' 		=> $tab['sticky'],
								'oldchat'		=> '1',
								'specialchat'	=> $tab['specialchat'],
								'col_avatar'	=> $tab['chat_cols']['col_avatar'],
								'col_chat'		=> $tab['chat_cols']['col_chat'],
								'col_date'		=> $tab['chat_cols']['col_date'],
								'col_menu'		=> $tab['chat_cols']['col_menu'],
								'col_sticky'	=> $tab['chat_cols']['col_sticky'],
								'col_uname'		=> $tab['chat_cols']['col_uname']
							)
						);
					}
					else
					{
						 $xml->add_tag(
							'chat',
							'',
							array(
								'type' 			=> '0',
								'chatid' 		=> $tab['chatid'],
								'sticky' 		=> $tab['sticky'],
								'oldchat'		=> '0',
								'specialchat'	=> $tab['specialchat'],
								'col_avatar'	=> $tab['chat_cols']['col_avatar'],
								'col_chat'		=> $tab['chat_cols']['col_chat'],
								'col_date'		=> $tab['chat_cols']['col_date'],
								'col_menu'		=> $tab['chat_cols']['col_menu'],
								'col_sticky'	=> $tab['chat_cols']['col_sticky'],
								'col_uname'		=> $tab['chat_cols']['col_uname']
							)
						);					
					}                    
				}
			}
		}		
        
        
    } else {
        $xml->add_tag('chat','',array('type' => '2'));
    }
    
    $xml->close_group();
    $xml->print_xml();
}

// Chatbox chat sending 
if ($_POST['do'] == 'ajax_chat') {
    $xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
    
    if (can_view_mgc_cb_evo() && can_use_mgc_cb_evo()) {
        if ($vbulletin->option['mgc_cb_evo_whoisonline_active']) {
            $vbulletin->db->query_write("REPLACE INTO " . TABLE_PREFIX . "mgc_cb_evo_session SET userid='" . $vbulletin->userinfo['userid'] . "',dateline='" . TIMENOW . "'");
        }      
        
        // Retrieval of the message 
        $chat         = $vbulletin->input->clean_gpc('p', 'chat', TYPE_NOCLEAN);
        $channel_id   = $vbulletin->input->clean_gpc('p', 'channel_id', TYPE_INT);
        $chat 		  = convert_urlencoded_unicode($chat);
        
        // Retrieval of editor conf 
        $b 		= $vbulletin->input->clean_gpc('p', 'b', TYPE_INT);
        $i 		= $vbulletin->input->clean_gpc('p', 'i', TYPE_INT);
        $u 		= $vbulletin->input->clean_gpc('p', 'u', TYPE_INT);
        $size 	= $vbulletin->input->clean_gpc('p', 'size', TYPE_INT);
        $font 	= $vbulletin->input->clean_gpc('p', 'font', TYPE_STR);
        $color	= $vbulletin->input->clean_gpc('p', 'color', TYPE_STR);
         
        if ($vbulletin->options['mgc_cb_evo_keep_user_format'])
        {
				$chatbox_params = array(
					  'mgc_cb_evo_font' => convert_urlencoded_unicode($font),
					  'mgc_cb_evo_size' => $size,
					  'mgc_cb_evo_color' => substr(convert_urlencoded_unicode($color),1),
					  'mgc_cb_evo_b' => $b,
					  'mgc_cb_evo_u' => $u,
					  'mgc_cb_evo_i' => $i,
					  'mgc_cb_evo_show' => $vbulletin->userinfo['mgc_cb_evo_show'],
					  'mgc_cb_evo_uchanid' => $vbulletin->userinfo['mgc_cb_evo_uchanid'],
					  'mgc_cb_evo_sound_disable' => $vbulletin->userinfo['mgc_cb_evo_sound_disable']
				 );
				 
				 $vbulletin->userinfo['mgc_cb_evo_params'] = serialize($chatbox_params);
				 
				 $serialize_cb_params = $vbulletin->db->escape_string($vbulletin->userinfo['mgc_cb_evo_params']);

				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET mgc_cb_evo_params='$serialize_cb_params' WHERE userid='" . $vbulletin->userinfo['userid'] . "'");
							
				mgc_cb_evo_unserialize_user_params();
        }
                 
        // Retrieval of the username for anonymous if needed (option active and usergroupid = 1) 
        if ($vbulletin->options['mgc_cb_evo_ask_anonymous_name'] && $vbulletin->userinfo['usergroupid'] == 1) {
        	$chat_name = convert_urlencoded_unicode($vbulletin->input->clean_gpc('p', 'chat_name', TYPE_NOHTML));
        }

        //** Message processing **
        $chat_datam = &datamanager_init('Mgccb_Chat', $vbulletin, ERRTYPE_ARRAY,'mgccbchat');

        if ($_SERVER['HTTP_X_FORWARD_FOR']) {
            $ip = $_SERVER['HTTP_X_FORWARD_FOR'];
        } else {
            $ip = $_SERVER['REMOTE_ADDR'];
        }      
        
        $chat_datam->do_set('chanid', $channel_id);
        $chat_datam->do_set('userip', $ip);
        
        // Set the username 
        if ($vbulletin->options['mgc_cb_evo_ask_anonymous_name'] && $vbulletin->userinfo['usergroupid'] == 1) {
			$chat_datam->do_set('name',$chat_name);
        }
        else
        {
			$chat_datam->do_set('name',$vbulletin->userinfo['username']);
        }
        
        $chat_datam->retrieve_command_permissions();        
        $chat_datam->set_raw_chat($chat);
      	
      	$chat_datam->pre_save();
        
        // The pre-save has returned an action (no chat), no need to go further 
        if (!empty($chat_datam->action)) {
            $xml->add_tag('sendchat_result', $chat_datam->action);
        } else {
        	// If user can do limited number of chats per day => checks if not reached 
			if ($permissions['mgc_cb_evo_max_chats_perday'])
			{
				$yesterday = TIMENOW - (24 * 60 * 60);				
				$getnbchats = $vbulletin->db->query_first("SELECT COUNT(chatid) AS nbchats FROM " . TABLE_PREFIX . "mgc_cb_evo_chat WHERE dateline>='" . $yesterday . "' AND fromuid='" . $vbulletin->userinfo['userid'] . "'");
				
				// Max number of chats reached => error 
				if ($getnbchats['nbchats'] >= $permissions['mgc_cb_evo_max_chats_perday'])
				{
					$getoldestchattoday = $vbulletin->db->query_first("SELECT dateline FROM " . TABLE_PREFIX . "mgc_cb_evo_chat WHERE dateline>='" . $yesterday . "' AND fromuid='" . $vbulletin->userinfo['userid'] . "' ORDER BY dateline ASC LIMIT 1");
					
					$nextchattime 	= 86400 - (TIMENOW - $getoldestchattoday['dateline']);					
					
					$hours 			= floor($nextchattime / 3600);
					$nextchattime 	= $nextchattime % 3600; 
					
					$minutes		= floor($nextchattime / 60);
					$seconds		= $nextchattime % 60; 					
					
					$error_msg = construct_phrase($vbphrase['mgc_cb_evo_too_much_chats_today'],$hours,$minutes,$seconds);
					
	            	$xml->add_tag('sendchat_result',"mgc_cb_evo_hideeditor(\"" . addslashes_js($vbulletin->options['mgc_cb_evo_msg_max_numberchatsperday_reached']) . "\"); mgc_cb_js_showpopup('" . addslashes_js($error_msg) . "','');");				
				}
				else
				{
					$chat_datam->save();
					
					// With this chat => max number of chats per day reached 
					if (($getnbchats['nbchats'] + 1) == $permissions['mgc_cb_evo_max_chats_perday'])
					{
						$getoldestchattoday = $vbulletin->db->query_first("SELECT dateline FROM " . TABLE_PREFIX . "mgc_cb_evo_chat WHERE dateline>='" . $yesterday . "' ORDER BY dateline ASC LIMIT 1");
						
						$nextchattime 	= 86400 - (TIMENOW - $getoldestchattoday['dateline']);						
						
						$hours 			= floor($nextchattime / 3600);
						$nextchattime 	= $nextchattime % 3600; 
						
						$minutes		= floor($nextchattime / 60);
						$seconds		= $nextchattime % 60; 					
						
						$error_msg = construct_phrase($vbphrase['mgc_cb_evo_too_much_chats_today'],$hours,$minutes,$seconds);
						
						$xml->add_tag('sendchat_result',"mgc_cb_evo_hideeditor(\"" . addslashes_js($vbulletin->options['mgc_cb_evo_msg_max_numberchatsperday_reached']) . "\"); mgc_cb_js_showpopup('" . addslashes_js($error_msg) . "',''); chatbox_refresh('forced');");										
	            	}
	            	else
	            	{
	            		$xml->add_tag('sendchat_result',"chatbox_refresh('forced')");	            	
	            	}
				}	
			}
			else
			{
				$chat_datam->save();
	            $xml->add_tag('sendchat_result',"chatbox_refresh('forced')");				
			}      
        }
    } else {
        $xml->add_tag('sendchat_result','mgc_cb_evo_force_page_refresh()');
    }
    
    $xml->print_xml();
}

// Chatbox chat editing retrieval 
if ($_POST['do'] == 'ajax_edit_getchat') {
    $xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
    
    if (can_view_mgc_cb_evo() && can_use_mgc_cb_evo()) {
        $chatid = $vbulletin->input->clean_gpc('p', 'chatid', TYPE_INT);
        
        // User can manage all chats 
        if (can_manage_mgc_cb_evo()) {
            $chat = $vbulletin->db->query_first("SELECT chatid,ctext FROM " . TABLE_PREFIX . "mgc_cb_evo_chat WHERE chatid='$chatid'");
            
            // Something retrieved ? 
            if ($chat) {
                $xml->add_tag('chat_content',$chat['ctext']);
            } else {
                $xml->add_tag('chat_content', '');
            }
        } else {
            if (can_manage_own_chats()) {
                // Let's check if user is the author 
                $chat = $vbulletin->db->query_first("SELECT chatid,ctext FROM " . TABLE_PREFIX . "mgc_cb_evo_chat WHERE chatid='$chatid' and fromuid='" . $vbulletin->userinfo['userid'] . "'");
                
                // Something retrieved ? 
                if ($chat) {
                    $xml->add_tag('chat_content',$chat['ctext']);
                } else {
                    $xml->add_tag('chat_content', '');
                }      
            }
        }
    } else {
        $xml->add_tag('chat_content', '');
    }
    
    $xml->print_xml();   
}

// Chatbox chat editing execution 
if ($_POST['do'] == 'ajax_save_edit') {
    $xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
    
    if (can_view_mgc_cb_evo() && can_use_mgc_cb_evo()) {
        $vbulletin->input->clean_array_gpc('p', array('chat' => TYPE_NOCLEAN, 'chatid' => TYPE_UINT));

        $vbulletin->GPC['chat'] = convert_urlencoded_unicode($vbulletin->GPC['chat']);

        // Forbidden actions 
        if ((empty($vbulletin->GPC['chat'])) || (trim($vbulletin->GPC['chat']) == "")) {
            $xml->add_tag('edit_result',"mgc_cb_js_showpopup('$vbphrase[mgc_cb_evo_edit_failed]'); chatbox_refresh('forced');");
        } else {
            // User can manage all chats 
            if (can_manage_mgc_cb_evo()) {
                $vbulletin->db->query_write("
					UPDATE " . TABLE_PREFIX . "mgc_cb_evo_chat
					SET ctext='" . $vbulletin->db->escape_string(trim($vbulletin->GPC['chat'])) . "',editdate='" . TIMENOW . "'
					WHERE chatid='" . $vbulletin->GPC['chatid'] . "'");
                
                $xml->add_tag('edit_result',"chatbox_refresh('forced');");
            } else {
                if (can_manage_own_chats()) {
                    // Let's check if user is the author 
                    $chat = $vbulletin->db->query_first("SELECT chatid,ctext FROM " . TABLE_PREFIX . "mgc_cb_evo_chat WHERE chatid='" . $vbulletin->GPC['chatid'] . "' and fromuid='" . $vbulletin->userinfo['userid'] . "'");
                    
                    if ($chat) {
                        $vbulletin->db->query_write("
                  	UPDATE " . TABLE_PREFIX . "mgc_cb_evo_chat
                  	SET ctext='" . $vbulletin->db->escape_string(trim($vbulletin->GPC['chat'])) . "',editdate='" . TIMENOW . "'
                  	WHERE chatid='" . $vbulletin->GPC['chatid'] . "'");
                        
                        $xml->add_tag('edit_result',"chatbox_refresh('forced');");
                    } else {
                        $xml->add_tag('edit_result',"mgc_cb_js_showpopup('$vbphrase[mgc_cb_evo_edit_forbidden]');");
                    }         
                } else {
                    $xml->add_tag('edit_result',"mgc_cb_js_showpopup('$vbphrase[mgc_cb_evo_edit_forbidden]');");
                }
            }
        }
    }
    
    $xml->print_xml();   
}

// Chatbox channel statuses retrieving 
if ($_POST['do'] == 'ajax_check_messages') {
    $xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
    
    if (can_view_mgc_cb_evo() && can_use_mgc_cb_evo()) {
        $channel_id = $vbulletin->input->clean_gpc('p', 'channel_id', TYPE_INT);
        
        
        // Constructing the REGEXP for the commands and channels 
        $sql_condition_co = "co.usergroupids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['usergroupid'] . "(,[0-9]+)*$')";
        $sql_condition_ch = "ch.usergroupids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['usergroupid'] . "(,[0-9]+)*$')";   
        
        if (!empty($vbulletin->userinfo['membergroupids'])) {
            $ugipds_array = explode(',', $vbulletin->userinfo['membergroupids']);
            
            foreach ($ugipds_array as $index => $ugpid) {
                $sql_condition_co .= " OR co.usergroupids REGEXP('^([0-9]+,)*" . $ugpid . "(,[0-9]+)*$')";
                $sql_condition_ch .= " OR ch.usergroupids REGEXP('^([0-9]+,)*" . $ugpid . "(,[0-9]+)*$')";         
            }
        }
        
        $sql_condition_co .= " OR co.userids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['userid'] . "(,[0-9]+)*$')";   
        $sql_condition_ch .= " OR ch.userids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['userid'] . "(,[0-9]+)*$')";
        
        $sql_condition_co = "(co.active='1' AND $sql_condition_co)";
        
        // Specific warning because general channel warning is not always on 
        if ($channel_id && $vbulletin->options['mgc_cb_evo_channels_warning_gen']) {		
            $sql_condition_ch = "((c.chanid='0') OR (ch.active='1' AND ($sql_condition_ch) AND ch.warnon='1'))";    
        } else {
            $sql_condition_ch = "(ch.active='1' AND ($sql_condition_ch) AND ch.warnon='1')";    
        }
        
        $getchannelslastmessage = $vbulletin->db->query_read("
			SELECT MAX(dateline) AS cdate,c.chanid
			FROM " . TABLE_PREFIX . "mgc_cb_evo_chat AS c
			LEFT JOIN " . TABLE_PREFIX . "mgc_cb_evo_command AS co ON ( c.coidentifier = co.identifier ) 
			LEFT JOIN " . TABLE_PREFIX . "mgc_cb_evo_channel AS ch ON ( c.chanid = ch.chanid )
			WHERE
				(
					(c.coidentifier='0' AND $sql_condition_ch)
					OR
					($sql_condition_co AND $sql_condition_ch)
				) 
				AND
				(
					fromuid<>'0' 
					AND
					(
						c.coidentifier<>'pm' 
						OR 
						(
							fromuid='" . $vbulletin->userinfo['userid'] . "'
							OR touid='" . $vbulletin->userinfo['userid'] . "'
						)
					)
				)  
			GROUP BY chanid
			ORDER BY dateline DESC
		"); 

        $channel_activities = unserialize($vbulletin->userinfo['mgc_cb_evo_channel_activities']);
        
        $xml->add_group('channels_statuses');

        if ($vbulletin->db->num_rows($getchannelslastmessage)) {   
            while ($channellastmessage = $vbulletin->db->fetch_array($getchannelslastmessage)) {                       
                if (empty($channellastmessage['chanid'])) {
                    $channellastmessage['chanid'] = 0;
                }
                
                if (array_key_exists($channellastmessage['chanid'],$channel_activities)) {
                    if ($channellastmessage['cdate'] > $channel_activities["$channellastmessage[chanid]"]) {
                        $xml->add_tag('status', 1, array('chanid' => $channellastmessage['chanid']));
                    } else {
                        $xml->add_tag('status', 0, array('chanid' => $channellastmessage['chanid']));
                    }
                } else {
                    $xml->add_tag('status', 1, array('chanid' => $channellastmessage['chanid']));
                }
            }
        } else {
            $xml->add_tag('status','none');
        }
        
        $xml->close_group();
    }
    
    $xml->print_xml();   
}

if ($_POST['do'] == 'ajax_get_online_users') {
    $xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
    
    if (can_view_mgc_cb_evo() && can_use_mgc_cb_evo()) {     
        // Inactive mode active and delay < session delay => inactive mode delay taken 
        if ($vbulletin->options['mgc_cb_evo_inactive_mode'] && $vbulletin->options['mgc_cb_evo_inactive_mode_delay'] < $vbulletin->options['mgc_cb_evo_whoisonline_delay']) {
            $dateline = TIMENOW - ($vbulletin->options['mgc_cb_evo_inactive_mode_delay'] * 60);
        } else {
            $dateline = TIMENOW - ($vbulletin->options['mgc_cb_evo_whoisonline_delay'] * 60);
        }
        
        $getusers = $vbulletin->db->query_read("
         SELECT DISTINCT u.username,u.displaygroupid,u.userid,s.userid AS suserid,u.usergroupid,
                        (u.options & " . $vbulletin->bf_misc_useroptions['invisible'] . ") AS invisible
         FROM " . TABLE_PREFIX . "mgc_cb_evo_session AS cbs
         LEFT JOIN " . TABLE_PREFIX . "user AS u ON (cbs.userid=u.userid)
         LEFT JOIN " . TABLE_PREFIX . "session AS s ON (cbs.userid=s.userid)
         WHERE cbs.dateline>='$dateline' AND cbs.userid!=0      
      ");
        
        if ($vbulletin->db->num_rows($getusers)) {
            $users_online['nb'] = 0;
            
            $first = 1;
            while ($user = $vbulletin->db->fetch_array($getusers)) {         
                if ($user['invisible']) {
                    if (($vbulletin->userinfo['permissions']['genericpermissions'] & $vbulletin->bf_ugp_genericpermissions['canseehidden']) OR $user['userid'] == $vbulletin->userinfo['userid']) {
                        if ($user['suserid']) {
                            $users_online['nb']++;
                            
                            if (!$first) {
                                $users_online['list'] .= ', ';
                            } else {
                                $first = 0;
                            }
                            
                            $users_online['list'] .= '<a href="member.php?' . $session['sessionurl'] . 'u=' . $user['userid'] . '">' . fetch_musername($user,'displaygroupid') . '</a>*';
                        }
                    }
                } else {
                    if ($user['suserid']) {
                        $users_online['nb']++;
                        
                        if (!$first) {
                            $users_online['list'] .= ', ';
                        } else {
                            $first = 0;
                        }
                        
                        $users_online['list'] .= '<a href="member.php?' . $session['sessionurl'] . 'u=' . $user['userid'] . '">' . fetch_musername($user,'displaygroupid') . '</a>';
                    }
                }                           
            }
            
            $xml->add_tag('online',$users_online['list'],array('nb' => $users_online['nb']));
        } else {
            $xml->add_tag('online',"",array('nb' => 0));
        }      
    }
    
    $xml->print_xml();   
}


// Chatbox chat stickying 
if ($_POST['do'] == 'ajax_sticky_chat') {
    $xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
    
    if (can_manage_mgc_cb_evo()) {
        $vbulletin->input->clean_array_gpc('p', array('status' => TYPE_UINT, 'chatid' => TYPE_UINT));
        
        // Let's sticky or unsticky chat 
        $vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "mgc_cb_evo_chat SET sticky='" . $vbulletin->GPC['status'] . "' WHERE chatid='" . $vbulletin->GPC['chatid'] . "'");
        
        if ($vbulletin->GPC['status']) {
            $xml->add_tag('stiky_result',"mgc_cb_js_showpopup('$vbphrase[mgc_cb_evo_chat_stickied]','mgc_cb_evo_force_page_refresh');");
        } else {
            $xml->add_tag('stiky_result',"mgc_cb_js_showpopup('$vbphrase[mgc_cb_evo_chat_unstickied]','mgc_cb_evo_force_page_refresh');");
        }
    }
    
    $xml->print_xml();   
}

?>