<?php
// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('NO_REGISTER_GLOBALS', 1);
define('THIS_SCRIPT', 'flashmenu');
define('CSRF_PROTECTION', true);

require_once('./global.php');

// ######### Flash Tags ############
if(empty($vbulletin->options['kr_flashmenu_scripts']))
{
      $condition = "(VB_AREA == 'Forum')";
}else{
      $scripts = explode(",", $vbulletin->options['kr_flashmenu_scripts']);
      $condition = in_array(THIS_SCRIPT, $scripts);
}
if($vbulletin->options['kr_flashmenu_enabled'] AND !empty($vbulletin->options['kr_flashmenu_links']) AND $condition)
{
      // Settings
      $opt['width'] = $vbulletin->options['kr_flashmenu_width'];
      $opt['height'] = $vbulletin->options['kr_flashmenu_height'];
      $opt['tcolor'] = $vbulletin->options['kr_flashmenu_tcolor'];
      $opt['tcolor2'] = $vbulletin->options['kr_flashmenu_tcolor2'];
      if(empty($opt['tcolor2']))
      {
            $opt['tcolor2'] = $vbulletin->options['kr_flashmenu_tcolor'];
      }
      $opt['bgcolor'] = $vbulletin->options['kr_flashmenu_bgcolor'];
      $opt['fontsize'] = $vbulletin->options['kr_flashmenu_fontsize'];
      $opt['speed'] = $vbulletin->options['kr_flashmenu_speed'];
      $opt['trans'] = $vbulletin->options['kr_flashmenu_transp'];
      function fetch_flashmenu()
      {
            global $vbulletin, $stylevar, $vbphrase, $opt;
            $links = explode("\r\n", $vbulletin->options['kr_flashmenu_links']);
            foreach($links AS $key => $val)
            {
                  $links['link'] = trim(substr($val, '', strrpos($val, '|')));
                  $links['desc'] = trim(substr($val, strrpos($val, '|') + 1));
                  if($stylevar['charset'] != 'UTF-8')
                  {
                        if(!$opt['charset'])
                        {
                              if(@function_exists('mb_convert_encoding'))
                              {
                                    $links['desc'] = mb_convert_encoding($links['desc'], 'UTF-8', $stylevar['charset']);
                              }else{
                                    $links['desc'] = iconv($stylevar['charset'], 'UTF-8', $links['desc']);
                              }
                              $links['link'] = unhtmlspecialchars($links['link']);
                        }else{
                              $links['link'] = urlencode(unhtmlspecialchars($links['link']));
                        }
                  }else{
                        $links['link'] = unhtmlspecialchars($links['link']);
                  }
                  $menulinks[] = array(
                         'desc' => $links['desc'],
                         'link' => $links['link']
                  );

            }
            $menu = array(
                  'tags' => $menulinks,
                  'count' => sizeof($menulinks)
            );
            if(empty($menu['tags']))
            {
                 return '';
            }

            $menu['links'] = '';
            foreach($menu['tags'] AS $thismenu)
            {
                  $menu['links'] .= "<a href=\"" . $thismenu['link'] . "\" rel=\"tag\" style=\"font-size:" . $opt['fontsize'] . "pt;\">";
                  if($stylevar['charset'] != 'UTF-8')
                  {
                        if($opt['charset'])
                        {
                              if(@function_exists('mb_convert_encoding'))
                              {
                                    $menu['links'] .= mb_convert_encoding($thismenu['desc'], 'UTF-8', $stylevar['charset']);
                              }else{
                                    $menu['links'] .= iconv($stylevar['charset'], 'UTF-8', $thismenu['desc']);
                              }
                        }else{
                              $menu['links'] .= $thismenu['desc'];
                        }
                  }else{
                        $menu['links'] .= $thismenu['desc'];
                  }
                  $menu['links'] .= "</a>";
            }
            return $menu['links'];
      }
      $show['flashmenu'] = ($vbulletin->userinfo['flashmenu'] OR !$vbulletin->userinfo['userid']);
      if($show['flashmenu'])
      {
            // Start Flash Content
            $links = fetch_flashmenu();

            $flashmenu = "<!-- SWFObject embed by Geoff Stearns geoff@deconcept.com http://blog.deconcept.com/swfobject/ -->\n";
            $flashmenu .= "<script type=\"text/javascript\" src=\"" . $vbulletin->options['bburl'] . "/clientscript/kr_scripts/swfobject.js\"></script>\n";
            $flashmenu .= "<div id=\"menucontent\"";
            if($vbulletin->options['kr_flashmenu_positiononoff'])// position:absolute + z-index + top:Npx etc...
            {
      	          $flashmenu .= " style=\"position:absolute;";
      	          $flashmenu .= !empty($vbulletin->options['kr_flashmenu_position_z_index']) ? " z-index:" . intval($vbulletin->options['kr_flashmenu_position_z_index']) . ";" : '';
      	          $flashmenu .= !empty($vbulletin->options['kr_flashmenu_position_top']) ? " top:" . intval($vbulletin->options['kr_flashmenu_position_top']) . "px;" : '';
      	          $flashmenu .= !empty($vbulletin->options['kr_flashmenu_position_left']) ? " left:" . intval($vbulletin->options['kr_flashmenu_position_left']) . "px;" : '';
                  $flashmenu .= !empty($vbulletin->options['kr_flashmenu_position_right']) ? " right:" . intval($vbulletin->options['kr_flashmenu_position_right']) . "px;" : '';
            }
            $flashmenu .= "\">\n";
            if($stylevar['charset'] == 'UTF-8')
            {
                  //Alternate content
                  $flashmenu .= "<p>\n";// style=\"display:none\"
                  $flashmenu .= urldecode($links);
                  $flashmenu .= "</p>\n";
            }
            $flashmenu .= "<p>" . $vbphrase['kr_flashmenu_flash_required'] . "</p>\n";
            $flashmenu .= "</div>\n";
            $flashmenu .= "<script type=\"text/javascript\">\n";
            $flashmenu .= "var rnumber = Math.floor(Math.random()*9999999);\n"; // force loading of movie to fix IE weirdness
            $flashmenu .= "var so = new SWFObject(\"" . $vbulletin->options['bburl'] . "/clientscript/kr_scripts/flashmenu.swf?r=\"+rnumber, \"tagcloudflash\", \"" . $opt['width'] . "\", \"" . $opt['height'] . "\", \"9\", \"#" . $opt['bgcolor'] . "\");\n";
            if($opt['trans'])
            {
                  $flashmenu .= "so.addParam(\"wmode\", \"transparent\");\n";
            }
            $flashmenu .= "so.addParam(\"allowScriptAccess\", \"always\");\n";
            $flashmenu .= "so.addVariable(\"tcolor\", \"0x" . $opt['tcolor'] . "\");\n";
            $flashmenu .= "so.addVariable(\"tcolor2\", \"0x" . $opt['tcolor2'] . "\");\n";
            $flashmenu .= "so.addVariable(\"tspeed\", \"" . $opt['speed'] . "\");\n";
            $flashmenu .= "so.addVariable(\"distr\", \"true\");\n";
            $flashmenu .= "so.addVariable(\"mode\", \"tags\");\n";
            $flashmenu .= "so.addVariable(\"tagcloud\", \"" . urlencode(unhtmlspecialchars("<tags>" . $links . "</tags>")) . "\");\n";
            $flashmenu .= "so.write(\"menucontent\");\n";
            $flashmenu .= "</script>\n";
            // Output Flash Content
      }
}
?>
