<?php
/*=======================================================================*\
|| ##################################################################### ||
|| # vBCredits 1.4 - `credits.php`									   # ||
|| # ------------------------------------------------------------------# ||
|| # Author: John Jakubowski "Darkwaltz4" {blackwaltz4@msn.com}		   # ||
|| # Copyright 2007-2008 PixelFX Studios Ltd. All Rights Reserved.	   # ||
|| # This file may not be redistributed in whole or significant part.  # ||
|| # -----------------vBulletin IS NOT FREE SOFTWARE!------------------# ||
|| #                Support: http://www.vbcredits.com/				   # ||
|| ##################################################################### ||
\*=======================================================================*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'credits');

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('credits_forum', 'reputation', 'subscription', 'user');

// get special data templates from the datastore
$specialtemplates = array();

// pre-cache templates used by all actions
$globaltemplates = array(
		'USERCP_SHELL',
		'usercp_nav_folderbit',
		'credits_postaddbit',
		'credits_postajax',
		'credits_postaddpage',
		'credits_pas_display',
		'credits_pasrow'
	);

// pre-cache templates used by specific actions
$actiontemplates = array(
		'manage' => array(
			'credits_manage',
			'credits_lottery',
			'credits_toprow'
		),
		'banking' => array(
			'credits_bank',
			'credits_deposit',
			'credits_loan',
			'credits_logrow'
		)
	);

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/functions_user.php');
require_once(DIR . '/includes/class_bbcode.php');

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

$userid = $vbulletin->input->clean_gpc('r', 'userid', TYPE_UINT);
$postid = $vbulletin->input->clean_gpc('r', 'postid', TYPE_UINT);
$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
$fromuser = fetch_userinfo($vbulletin->options['credits_pmid']);
cache_permissions($fromuser, false);

if (empty($vbulletin->userinfo['userid']) OR $vbulletin->bf_ugp['creditpermissions']['credit_locked'] & $creditperms['creditpermissions'])
{
	print_no_permission();
}
if (!$vbulletin->options['credits_enabled'])
{
	eval(standard_error(fetch_error('credits_disabled')));
}
if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'manage';
}

($hook = vBulletinHook::fetch_hook('credits_start')) ? eval($hook) : false;

if (!$foruminfo['credits_cantaward'] AND ($postid OR (in_array($_REQUEST['do'], array('award', 'addcredits')) AND $userid)))
{
	$vbulletin->input->clean_array_gpc('p', array(
		'ajax'		=> TYPE_BOOL,
		'dir'		=> TYPE_NOHTML,
		'amount'	=> TYPE_UNUM,
		'reason'	=> TYPE_NOHTML,
		'anonymous'	=> TYPE_BOOL
	));

	$log = array();
	$available = -1;
	$error = $awards = '';
	$show['negative'] = ($vbulletin->bf_ugp['creditpermissions']['credit_pasneg'] & $creditperms['creditpermissions']);
	
	($hook = vBulletinHook::fetch_hook('credits_award_start')) ? eval($hook) : false;

	if ($vbulletin->GPC['dir'] != 'neg')
	{
		$vbulletin->GPC['dir'] = 'pos';
	}
	if ($postid)
	{
		$type = 'post';
		$post = fetch_postinfo($postid);
		$userinfo = fetch_userinfo($post['userid']);
		$log = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "credits_transactions WHERE postid = " . intval($postid) . " AND fromuserid = " . $vbulletin->userinfo['userid']);

		if ($creditperms['credit_pasawthread'] > -1)
		{
			$history = $db->query_first("SELECT SUM(credits.amount) AS thread_amount FROM " . TABLE_PREFIX . "credits_transactions AS credits LEFT JOIN " . TABLE_PREFIX . "post AS post ON (credits.postid = post.postid) WHERE credits.action = 'post' AND credits.fromuserid = " . $vbulletin->userinfo['userid'] . " AND credits.timestamp >= " . (TIMENOW - $vbulletin->options['credits_donawtime']) . " AND post.threadid = " . $post['threadid']);
			$creditperms['credit_pasawthread'] -= $history['thread_amount'];

			if ($creditperms['credit_pasawthread'] < 0)
			{
				eval(standard_error(fetch_error('credits_toomuchthread')));
			}
			else if ($available < 0 OR $creditperms['credit_pasawthread'] < $available)
			{
				$available = $creditperms['credit_pasawthread'];
			}
		}
	}
	else
	{
		$type = 'award';
		$userinfo = fetch_userinfo($userid);
	}
	if (!$userinfo['credits_canearn'] OR $vbulletin->bf_ugp['creditpermissions']['credit_locked'] & $vbulletin->usergroupcache[$userinfo['usergroupid']]['creditpermissions'])
	{
		eval(standard_error(fetch_error('credits_baduser', $vbphrase['credits'])));
	}
	if ($userinfo['userid'] == $vbulletin->userinfo['userid'])
	{
		eval(standard_error(fetch_error('credits_addself')));
	}
	if ($creditperms['credit_pasawuser'] > -1 AND ($available < 0 OR $creditperms['credit_pasawuser'] < $available))
	{
		$available = $creditperms['credit_pasawuser'];
	}

	$history = $db->query_first("SELECT SUM(postid > 0) AS total_posts, COUNT(DISTINCT touserid) AS total_users FROM " . TABLE_PREFIX . "credits_transactions WHERE action IN ('award', 'post') AND fromuserid = " . $vbulletin->userinfo['userid'] . " AND timestamp >= " . (TIMENOW - $vbulletin->options['credits_donawtime']));

	if (($creditperms['credit_pastotpost'] > -1 AND $history['total_posts'] > $creditperms['credit_pastotpost']) OR ($creditperms['credit_pastotuser'] > -1 AND $history['total_users'] > $creditperms['credit_pastotuser']))
	{
		eval(standard_error(fetch_error('credits_toomuchusers')));
	}
	if ($vbulletin->options['credits_usecentral'] AND ($available < 0 OR $vbulletin->credits_central < $available))
	{
		$available = $vbulletin->credits_central;
	}
	if ($available > -1 AND !empty($log))
	{
		$available += $log['amount'];
	}
	if ($_REQUEST['do'] == 'addcredits')
	{
		$creditamount = ( $vbulletin->GPC['dir'] == 'pos' ? 1 : -1 ) * $vbulletin->GPC['amount'];

		if ($vbulletin->GPC['ajax'])
		{
			$vbulletin->GPC['reason'] = convert_urlencoded_unicode($vbulletin->GPC['reason']);
		}
		if ($creditamount < 0 AND !$show['negative'])
		{
			eval(standard_error(fetch_error('credits_cantnegative', $vbphrase['credits'])));
		}
		if ($available > -1 AND $creditamount > $available)
		{
			eval(standard_error(fetch_error('credits_exceedbound')));
		}
		if ($vbulletin->GPC['dir'] == 'neg' AND empty($vbulletin->GPC['reason']))
		{
			eval(standard_error(fetch_error('credits_addreason')));
		}
		if (!empty($log))
		{
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "credits_transactions WHERE transactionid = " . $log['transactionid']);
			$creditamount -= $log['amount'];
		}

		$notmoderated = !($vbulletin->bf_ugp['creditpermissions']['credit_modawards'] & $creditperms['creditpermissions']);
		$db->query_write("INSERT INTO " . TABLE_PREFIX . "credits_transactions (fromuserid, touserid, action, postid, anonymous, comment, amount, timestamp, completed) VALUES (" . $vbulletin->userinfo['userid'] . ", " . $userinfo['userid'] . ", '" . $type . "', " . $postid . ", " . $vbulletin->GPC['anonymous'] . ", '" . $db->escape_string(fetch_censored_text($vbulletin->GPC['reason'])) . "', " . (( $vbulletin->GPC['dir'] == 'pos' ? 1 : -1 ) * $vbulletin->GPC['amount']) . ", " . TIMENOW . ", " . intval($notmoderated) . ")");

		($hook = vBulletinHook::fetch_hook('credits_award_complete')) ? eval($hook) : false;

		if ($vbulletin->options['credits_usecentral'])
		{
			build_datastore('credits_central', $vbulletin->credits_central - $creditamount, false);
		}
		if ($notmoderated)
		{
			$db->query_write("UPDATE " . TABLE_PREFIX . "user SET credits = credits + $creditamount WHERE userid = " . $userinfo['userid']);

			/*if ($post['postid'])
			{
				$db->query_write("UPDATE " . TABLE_PREFIX . "thread SET awardedcredits = awardedcredits + $creditamount WHERE threadid = " . $post['threadid']);
			}*/
			if ($fromuser)
			{
				$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_SILENT);
				$pmdm->overridequota = true;
				$pmdm->set('fromuserid', $fromuser['userid']);
				$pmdm->set('fromusername', $fromuser['username']);
				$pmdm->set_info('receipt', false);
				$pmdm->set_info('savecopy', false);
				$pmdm->set('title', $vbphrase['credits_pm_post_subject']);
				$pmdm->set('message', construct_phrase($vbphrase['credits_pm_post_body'], $userinfo['username'], vb_number_format($creditamount, $vbulletin->options['credits_decimals']), $vbphrase['credits'], ( ($vbulletin->GPC['anonymous'] AND $vbulletin->bf_ugp['creditpermissions']['credit_cananon'] & $creditperms['creditpermissions'] AND !($vbulletin->bf_ugp['creditpermissions']['credit_cansee'] & $vbulletin->usergroupcache[$userinfo['usergroupid']]['creditpermissions'])) ? $vbphrase['anonymous'] : $vbulletin->userinfo['username'] ), fetch_censored_text(unhtmlspecialchars($vbulletin->GPC['reason'])), $vbphrase['transaction_log']));
				$pmdm->set_recipients($userinfo['username'], $fromuser['permissions']);
				$pmdm->set('dateline', TIMENOW);
				$pmdm->set('allowsmilie', true);
				$pmdm->save();
				unset($pmdm);
			}
		}
		if (!$vbulletin->GPC['ajax'])
		{
			$vbulletin->url = ( $postid ? 'showthread.php?' . $vbulletin->session->vars['sessionurl'] . "p=$postid#post$postid" : 'member.php?' . $vbulletin->session->vars['sessionurl'] . "u=$userid" );
			eval(print_standard_redirect('credits_addthanks'));
		}
		else
		{
			if ($vbulletin->options['credits_pas_public'])
			{
				$awardinfo = $db->query_read("SELECT award.*, award.fromuserid AS userid, user.* FROM " . TABLE_PREFIX . "credits_transactions AS award LEFT JOIN " . TABLE_PREFIX . "user AS user ON(award.fromuserid = user.userid) WHERE award.completed = 1 AND award.postid = " . $postinfo['postid']);

				if ($db->num_rows($awardinfo))
				{
					while ($award = $db->fetch_array($awardinfo))
					{
						$show['realname'] = (!$award['anonymous'] OR ($vbulletin->bf_ugp['creditpermissions']['credit_cansee'] & $creditperms['creditpermissions']) OR $award['fromuserid'] == $vbulletin->userinfo['userid']);

						$awardname = fetch_musername($award);
						$datestamp = vbdate($vbulletin->options['dateformat'], $award['timestamp'], true);
						$comment = ( !empty($award['comment']) ? $bbcode_parser->parse(fetch_censored_text(unhtmlspecialchars($award['comment']))) : $vbphrase['n_a'] );
						$amount = vb_number_format($award['amount'], $vbulletin->options['credits_decimals']);		

						eval('$awardbits .= "' . fetch_template('credits_pasrow') . '";');
					}

					eval('$awards = "' . fetch_template('credits_pas_display') . '";');
				}

				$db->free_result($awardinfo);
			}

			require_once(DIR . '/includes/class_xml.php');
			require_once(DIR . '/includes/functions_misc.php');
			$xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
			$xml->add_tag('credits', fetch_phrase('credits_addthanks', 'frontredirect', 'redirect_'), array(
				'cdtdisplay' => vb_number_format($userinfo['credits'] + $creditamount, $vbulletin->options['credits_decimals']),
				'userid'     => $userinfo['userid'], 'awards' => $awards
			));
			$xml->print_xml();
		}
	}
	if ($log['amount'] >= 0)
	{
		$gain = ' checked="checked"';
	}
	else
	{
		$lose = ' checked="checked"';
		$log['amount'] = abs($log['amount']);
	}

	$show['ajax'] = $vbulletin->GPC['ajax'];
	$amountavail = vb_number_format($available, $vbulletin->options['credits_decimals']);
	$show['anon'] = ($vbulletin->bf_ugp['creditpermissions']['credit_cananon'] & $creditperms['creditpermissions']);

	($hook = vBulletinHook::fetch_hook('credits_award_input')) ? eval($hook) : false;

	eval('$creditsbit = "' . fetch_template('credits_postaddbit') . '";');

	if ($vbulletin->GPC['ajax'])
	{
		eval('$credits = "' . fetch_template('credits_postajax') . '";');

		require_once(DIR . '/includes/class_xml.php');
		$xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
		$xml->add_tag('creditsbit', $credits);
		$xml->print_xml();
	}

	$navbits = array();
	$parentlist = array_reverse(explode(',', $foruminfo['parentlist']));
	foreach ($parentlist AS $forumID)
	{
		$forumTitle = $vbulletin->forumcache["$forumID"]['title'];
		$navbits['forumdisplay.php?' . $vbulletin->session->vars['sessionurl'] . "f=$forumID"] = $forumTitle;
	}
	$navbits['showthread.php?' . $vbulletin->session->vars['sessionurl'] . "p=$postid"] = $threadinfo['title'];
	$navbits[''] = construct_phrase($vbphrase['credits_threadaward'], $userinfo['username'], $vbphrase['credits']);
	$navbits = construct_navbits($navbits);

	eval('$navbar = "' . fetch_template('navbar') . '";');
	eval('print_output("' . fetch_template('credits_postaddpage') . '");');
}

if ($_REQUEST['do'] == 'donate')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'amount'	=> TYPE_UNUM,
		'recipient'	=> TYPE_NOHTML,
		'comment'	=> TYPE_NOHTML,
		'anonymous'	=> TYPE_BOOL
	));

	$amount = $transferred = $vbulletin->GPC['amount'];
	$donatefee = $vbulletin->GPC['amount'] * $vbulletin->options['credits_donatefee'];
	
	($hook = vBulletinHook::fetch_hook('credits_donate_start')) ? eval($hook) : false;

	if ($vbulletin->options['credits_feetype'] == 'pos')
	{
		$amount += $donatefee;
	}
	else
	{
		$transferred -= $donatefee;
	}
	if (!$vbulletin->options['credits_donateon'])
	{
		eval(standard_error(fetch_error('credits_nodonate')));
	}
	if (!$vbulletin->userinfo['credits_canspend'])
	{
		eval(standard_error(fetch_error('credits_nospend', $vbphrase['credits'])));
	}
	if (empty($amount))
	{
		eval(standard_error(fetch_error('invalid_x_specified', $vbphrase['credits_amount'])));
	}
	if ($amount > $vbulletin->userinfo['credits'])
	{
		eval(standard_error(fetch_error('credits_notenoughdonate')));
	}

	$duser = $db->query_first("SELECT userid, username, credits_canearn, usergroupid FROM " . TABLE_PREFIX . "user WHERE username = '" . $db->escape_string($vbulletin->GPC['recipient']) . "'");

	if (!empty($duser['userid']) AND $duser['userid'] != $vbulletin->userinfo['userid'])
	{
		if (!$duser['credits_canearn'] OR $vbulletin->bf_ugp['creditpermissions']['credit_locked'] & $vbulletin->usergroupcache[$duser['usergroupid']]['creditpermissions'])
		{
			eval(standard_error(fetch_error('credits_baduser', $vbphrase['credits'])));
		}
		if ($creditperms['credit_donmaxuser'] > -1)
		{
			$history = $db->query_first("SELECT SUM(amount) AS total FROM " . TABLE_PREFIX . "credits_transactions WHERE action = 'donate' AND fromuserid = " . $vbulletin->userinfo['userid'] . " AND touserid = " . $duser['userid'] . " AND timestamp >= " . (TIMENOW - $vbulletin->options['credits_donawtime']));

			if ($history['total'] > $creditperms['credit_donmaxuser'])
			{
				eval(standard_error(fetch_error('credits_toomuchdonate')));
			}
		}

		$notmoderated = !($vbulletin->bf_ugp['creditpermissions']['credit_moddonate'] & $creditperms['creditpermissions']);
		$db->query_write("UPDATE " . TABLE_PREFIX . "user SET credits = credits - $amount WHERE userid = " . $vbulletin->userinfo['userid']);
		$db->query_write("INSERT INTO " . TABLE_PREFIX . "credits_transactions (fromuserid, touserid, action, anonymous, comment, amount, timestamp, completed) VALUES (" . $vbulletin->userinfo['userid'] . ", " . $duser['userid'] . ", 'donate', " . $vbulletin->GPC['anonymous'] . ", '" . $db->escape_string(fetch_censored_text($vbulletin->GPC['comment'])) . "', " . $vbulletin->GPC['amount'] . ", " . TIMENOW . ", " . intval($notmoderated) . ")");

		($hook = vBulletinHook::fetch_hook('credits_donate_complete')) ? eval($hook) : false;

		if ($notmoderated)
		{
			$db->query_write("UPDATE " . TABLE_PREFIX . "user SET credits = credits + $transferred WHERE userid = " . $duser['userid']);
			build_datastore('credits_central', $vbulletin->credits_central + $donatefee, false);

			if ($fromuser)
			{
				$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_SILENT);
				$pmdm->overridequota = true;
				$pmdm->set('fromuserid', $fromuser['userid']);
				$pmdm->set('fromusername', $fromuser['username']);
				$pmdm->set_info('receipt', false);
				$pmdm->set_info('savecopy', false);
				$pmdm->set('title', construct_phrase($vbphrase['credits_pm_subject'], $vbphrase['credits']));
				$pmdm->set('message', construct_phrase($vbphrase['credits_pm_body'], $duser['username'], vb_number_format($transferred, $vbulletin->options['credits_decimals']), $vbphrase['credits'], ( ($vbulletin->GPC['anonymous'] AND $vbulletin->bf_ugp['creditpermissions']['credit_cananon'] & $creditperms['creditpermissions'] AND !($vbulletin->bf_ugp['creditpermissions']['credit_cansee'] & $vbulletin->usergroupcache[$duser['usergroupid']]['creditpermissions'])) ? $vbphrase['anonymous'] : $vbulletin->userinfo['username'] ), fetch_censored_text(unhtmlspecialchars($vbulletin->GPC['comment'])), $vbphrase['transaction_log']));
				$pmdm->set_recipients($duser['username'], $fromuser['permissions']);
				$pmdm->set('dateline', TIMENOW);
				$pmdm->set('allowsmilie', true);
				$pmdm->save();
				unset($pmdm);
			}
		}

		$vbulletin->url = 'credits.php?' . $vbulletin->session->vars['sessionurl'] . 'do=manage';
		eval(print_standard_redirect('credits_donatethanks'));
	}
	else
	{
		eval(standard_error(fetch_error('invalid_username_specified')));
	}
}

if ($_REQUEST['do'] == 'lottery')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'purchase'	=> TYPE_ARRAY_UINT,
		'tickets'	=> TYPE_ARRAY_UINT
	));

	$currentickets = $activetickets = 0;
	$lotteryid = array_pop(array_keys($vbulletin->GPC['purchase']));
	$tickets = $vbulletin->GPC['tickets'][$lotteryid];
	$lottery = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "credits_lottery WHERE lotteryid = $lotteryid");
	$actlotteries = $db->query_read("SELECT heldtickets, tickets FROM " . TABLE_PREFIX . "credits_lottery WHERE active = 1");

	while ($lot = $db->fetch_array($actlotteries))
	{
		$heldtickets = unserialize($lot['heldtickets']);
		$heldtickets = $heldtickets[$vbulletin->userinfo['userid']];
		$activetickets += ( $lot['tickets'] == 'raffle' ? $heldtickets : sizeof($heldtickets) );
	}

	$db->free_result($actlotteries);
	$heldtickets = unserialize($lottery['heldtickets']);

	($hook = vBulletinHook::fetch_hook('credits_lottery_start')) ? eval($hook) : false;

	foreach ($heldtickets AS $user => $ticks)
	{
		$currentickets += ( $lottery['tickets'] == 'raffle' ? $ticks : sizeof($ticks) );
	}
	if ($lottery['tickets'] == 'raffle' AND !$tickets)
	{
		eval(standard_error(fetch_error('invalid_x_specified', $vbphrase['credits_amount'])));
	}
	if (!$vbulletin->userinfo['credits_canearn'] OR !$vbulletin->userinfo['credits_canspend'] OR !$lottery['active'] OR in_array($vbulletin->userinfo['usergroupid'], unserialize($lottery['excluded'])))
	{
		eval(standard_error(fetch_error('credits_nolottery')));
	}
	if (($creditperms['credit_maxtickets'] > -1 AND ($activetickets + ( $lottery['tickets'] == 'raffle' ? $tickets : 1 )) > $creditperms['credit_maxtickets']) OR ($vbulletin->options['credits_lotterymax'] > -1 AND ($currentickets + ( $lottery['tickets'] == 'raffle' ? $tickets : 1 )) > $vbulletin->options['credits_lotterymax']))
	{
		eval(standard_error(fetch_error('credits_toomanytickets')));
	}

	$cost = (1 - $creditperms['credit_lotdiscount']) * $lottery['ticketcost'] * ( $lottery['tickets'] == 'raffle' ? $tickets : 1 );

	if ($cost > $vbulletin->userinfo['credits'])
	{
		eval(standard_error(fetch_error('credits_lottery_notenough', vb_number_format($cost, $vbulletin->options['credits_decimals']), $vbphrase['credits'], ( $lottery['tickets'] == 'raffle' ? $tickets : 1 ))));
	}
	if ($lottery['tickets'] == 'raffle')
	{
		$heldtickets[$vbulletin->userinfo['userid']] += $tickets;
	}
	else
	{
		if (!$tickets OR $tickets > $vbulletin->options['credits_lotteryrange'] OR !$vbulletin->options['credits_lotterypick'])
		{
			$tickets = vbrand(1, $vbulletin->options['credits_lotteryrange']);
		}

		$heldtickets[$vbulletin->userinfo['userid']][] = $tickets;
	}
	if ($lottery['wintype'] == 'raise')
	{
		$lottery['jackpot'] += $cost;
	}

	$db->query_write("UPDATE " . TABLE_PREFIX . "user SET credits = credits - $cost WHERE userid = " . $vbulletin->userinfo['userid']);
	$db->query_write("UPDATE " . TABLE_PREFIX . "credits_lottery SET jackpot = " . $lottery['jackpot'] . ", heldtickets = '" . $db->escape_string(serialize($heldtickets)) . "' WHERE lotteryid = $lotteryid");

	($hook = vBulletinHook::fetch_hook('credits_lottery_end')) ? eval($hook) : false;

	$vbulletin->url = 'credits.php?' . $vbulletin->session->vars['sessionurl'] . 'do=manage';
	eval(print_standard_redirect('credits_purchasethanks'));
}

if ($_REQUEST['do'] == 'manage')
{
	$showgroups = array();
	$show['donate'] = $show['anon'] = $show['lottery'] = $show['topx'] = false;

	($hook = vBulletinHook::fetch_hook('credits_panel_start')) ? eval($hook) : false;

	if ($vbulletin->options['credits_donateon'] AND $vbulletin->userinfo['credits_canspend'] AND $creditperms['credit_donmaxuser'] != 0)
	{
		$show['donate'] = true;
		$show['anon'] = ($vbulletin->bf_ugp['creditpermissions']['credit_cananon'] & $creditperms['creditpermissions']);
		$donatefee = vb_number_format(100 * $vbulletin->options['credits_donatefee'], $vbulletin->options['credits_percents']);

		if ($userid AND $vbulletin->userinfo['userid'] != $userid)
		{
			$username = $db->query_first("SELECT username FROM " . TABLE_PREFIX . "user WHERE userid = $userid");
		}
	}
	if ($creditperms['credit_maxtickets'] != 0 AND $vbulletin->userinfo['credits_canspend'])
	{
		$names = array();
		$shownlots = $actickets = 0;
		$lots = array(array(), array());
		$lotteries = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "credits_lottery WHERE drawtime > " . (TIMENOW - $vbulletin->options['credits_lotexpire']) . " ORDER BY drawtime ASC");

		while ($lottery = $db->fetch_array($lotteries))
		{
			$lottery['winner'] = unserialize($lottery['winner']);
			$lottery['excluded'] = unserialize($lottery['excluded']);
			$lottery['heldtickets'] = unserialize($lottery['heldtickets']);

			foreach ($lottery['winner'] AS $user)
			{
				$names[] = $user;
			}
			if (!in_array($vbulletin->userinfo['usergroupid'], $lottery['excluded']))
			{
				$shownlots++;
				$lots[$lottery['active']][] = $lottery;

				if ($lottery['active'])
				{
					$actickets += ( $lottery['tickets'] == 'raffle' ? $lottery['heldtickets'][$vbulletin->userinfo['userid']] : sizeof($lottery['heldtickets'][$vbulletin->userinfo['userid']]) );
				}
			}
		}
		if (sizeof($names))
		{
			$people = $db->query_read("SELECT userid, username FROM " . TABLE_PREFIX . "user WHERE userid IN (" . implode(', ', $names) . ")");

			while ($person = $db->fetch_array($people))
			{
				$winners[$person['userid']] = $person['username'];
			}

			$db->free_result($people);
		}
		if ($shownlots)
		{
			$show['lottery'] = true;
			$maxrange = vb_number_format($vbulletin->options['credits_lotteryrange'], 0);
			$maxtickets = ( $creditperms['credit_maxtickets'] > -1 ? vb_number_format($creditperms['credit_maxtickets'], 0) : $vbphrase['unlimited'] );	
			$wintax = vb_number_format(100 * $vbulletin->options['credits_lotterytax'], $vbulletin->options['credits_percents']);
			$lots[0] = array_reverse($lots[0]);
			$firstdone = intval($lots[0][0]['lotteryid']);
			$lots = array_merge($lots[1], $lots[0]);

			foreach ($lots AS $lottery)
			{
				$ticketcost = vb_number_format($lottery['ticketcost'] * (1 - $creditperms['credit_lotdiscount']), $vbulletin->options['credits_decimals']);
				$allowbuy = ($vbulletin->userinfo['credits_canearn'] AND $vbulletin->userinfo['credits_canspend'] AND $lottery['active'] AND ($creditperms['credit_maxtickets'] < 0 OR $actickets < $creditperms['credit_maxtickets']));
				$canpick = ($lottery['tickets'] == 'raffle' OR $vbulletin->options['credits_lotterypick']);
				$jackpot = vb_number_format($lottery['jackpot'], $vbulletin->options['credits_decimals']);
				$drawdate = vbdate($vbulletin->options['dateformat'], $lottery['drawtime']);
				$separate = ($lottery['lotteryid'] == $firstdone);
				$mytickets = $total_tickets = $odds = 0;
				$dispwins = array();

				foreach ((array) $lottery['heldtickets'] AS $user => $tickets)
				{
					$total_tickets += ( $lottery['tickets'] == 'raffle' ? $tickets : sizeof($tickets) );

					if ($vbulletin->userinfo['userid'] == $user)
					{
						$mytickets = ( $lottery['tickets'] == 'raffle' ? $tickets : sizeof($tickets) );
					}
				}
				if (!$lottery['active'])
				{
					foreach ((array) $lottery['winner'] AS $user)
					{
						if (!in_array($winners[$user], $dispwins))
						{
							$dispwins[] = $winners[$user];
						}
					}

					$winner_names = implode(', ', $dispwins);
				}
				else
				{
					$odds = vb_number_format(100 * ( $lottery['tickets'] == 'raffle' ? ( $total_tickets ? ($mytickets / $total_tickets) : 0 ) : sizeof(array_count_values((array) $lottery['heldtickets'][$vbulletin->userinfo['userid']])) / $vbulletin->options['credits_lotteryrange'] ), $vbulletin->options['credits_percents']);
				}
				if ($allowbuy)
				{
					$initialval = ( $lottery['tickets'] == 'raffle' ? 0 : vbrand(1, $vbulletin->options['credits_lotteryrange']) );
				}

				$mytickets = vb_number_format($mytickets, 0);
				$total_tickets = vb_number_format($total_tickets, 0);

				($hook = vBulletinHook::fetch_hook('credits_panel_lottery')) ? eval($hook) : false;

				eval('$lotterybits .= "' . fetch_template('credits_lottery') . '";');
			}
		}

		$db->free_result($lotteries);
	}
	foreach ($vbulletin->usergroupcache AS $ugid => $ugcache)
	{
		if (!($vbulletin->bf_ugp['creditpermissions']['credit_hidetop'] & $ugcache['creditpermissions']))
		{
			$showgroups[] = $ugid;
		}
	}
	if (!empty($showgroups) AND $vbulletin->options['credits_numrich'])
	{
		switch ($vbulletin->options['credits_display'])
		{
			case 'hand':
				$sqlsort = 'credits';
				break;
			case 'bank':
				$sqlsort = 'credits_saved';
				break;
			case 'both':
				$sqlsort = '(credits + credits_saved)';
				break;
		}

		$show['topx'] = true;
		$topusers = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "user WHERE usergroupid IN (" . implode(', ', $showgroups) . ") ORDER BY $sqlsort DESC LIMIT " . $vbulletin->options['credits_numrich']);

		while ($userinfo = $db->fetch_array($topusers))
		{
			cache_permissions($userinfo, false);
			fetch_musername($userinfo);
			$userinfo = array_merge($userinfo , convert_bits_to_array($userinfo['options'] , $vbulletin->bf_misc_useroptions), convert_bits_to_array($userinfo['adminoptions'] , $vbulletin->bf_misc_adminoptions));
			$userinfo['datejoined'] = vbdate($vbulletin->options['dateformat'], $userinfo['joindate'], true);
			$show['emaillink'] = ($userinfo['showemail'] AND $vbulletin->options['displayemails'] AND (!$vbulletin->options['secureemail'] OR ($vbulletin->options['secureemail'] AND $vbulletin->options['enableemail'])) AND $vbulletin->userinfo['permissions']['genericpermissions'] & $vbulletin->bf_ugp_genericpermissions['canemailmember']);
			$show['pmlink'] = ($vbulletin->options['enablepms'] AND $vbulletin->userinfo['permissions']['pmquota'] AND ($vbulletin->userinfo['permissions']['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel'] OR ($userinfo['receivepm'] AND $userinfo['permissions']['pmquota'] AND (!$userinfo['receivepmbuddies'] OR can_moderate() OR strpos(" $userinfo[buddylist] ", ' ' . $vbulletin->userinfo['userid'] . ' ') !== false))));
			$special = ($userinfo['userid'] == $vbulletin->userinfo['userid'] OR $vbulletin->bf_ugp['creditpermissions']['credit_special'] & $creditperms['creditpermissions']);
			$displayamount = ($vbulletin->options['credits_display'] != 'bank') * $userinfo['credits'] + ($vbulletin->options['credits_display'] != 'hand') * $userinfo['credits_saved'];
			$userinfo['credits'] = ( (!($vbulletin->bf_ugp['creditpermissions']['credit_locked'] & $creditperms['creditpermissions']) AND ((!($vbulletin->bf_ugp['creditpermissions']['credit_hidden'] & $vbulletin->usergroupcache[$userinfo['usergroupid']]['creditpermissions'])) OR $special) AND ($vbulletin->options['credits_public'] == 'all' OR ($vbulletin->options['credits_public'] == 'some' AND $special))) ? vb_number_format(( ($vbulletin->options['credits_neghandle'] != 'normal' AND $displayamount < 0) ? 0 : $displayamount ), $vbulletin->options['credits_decimals']) : $vbphrase['n_a'] );

			($hook = vBulletinHook::fetch_hook('credits_panel_rich')) ? eval($hook) : false;

			eval('$topentries .= "' . fetch_template('credits_toprow') . '";');
		}

		$db->free_result($topusers);
	}

	($hook = vBulletinHook::fetch_hook('credits_panel_end')) ? eval($hook) : false;

	$credit_title = $vbphrase['credits_donatelottery'];
	$credit_navbar = 'credits';
	$credit_template = 'credits_manage';
}

if ($_REQUEST['do'] == 'transfer')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'amount'	=> TYPE_UNUM,
		'type'		=> TYPE_NOHTML,
		'reason'	=> TYPE_NOHTML,
		'deposit'	=> TYPE_ARRAY_UINT
	));

	if ($vbulletin->userinfo['posts'] < $vbulletin->options['credits_bankposts'] OR $vbulletin->userinfo['reputation'] < $vbulletin->options['credits_bankrep'] OR floor((TIMENOW - $vbulletin->userinfo['joindate']) / 86400) < $vbulletin->options['credits_banktime'])
	{
		eval(standard_error(fetch_error('credits_notyetbank')));
	}
	if ($depositid = array_pop(array_keys($vbulletin->GPC['deposit'])))
	{
		$deposit = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "credits_bank WHERE bankid = " . $depositid);

		($hook = vBulletinHook::fetch_hook('credits_transfer_cancel')) ? eval($hook) : false;

		if ($deposit['type'] == 'save' AND $deposit['status'] < 2)
		{
			$bankfee = $deposit['amount'] * $vbulletin->options['credits_earlywithdraw'];
			$deposit['amount'] -= $bankfee;

			$db->query_write("UPDATE " . TABLE_PREFIX . "user SET credits = credits + " . $deposit['amount'] . " WHERE userid = " . $vbulletin->userinfo['userid']);
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "credits_bank WHERE bankid = " . $deposit['bankid']);

			if ($deposit['status'])
			{
				$db->query_write("INSERT INTO " . TABLE_PREFIX . "credits_transactions (fromuserid, touserid, action, comment, amount, timestamp, completed) VALUES (0, " . $vbulletin->userinfo['userid'] . ", 'save', '" . $db->escape_string($vbulletin->GPC['reason']) . "', " . $deposit['amount'] . ", " . TIMENOW . ", 1)");
			}
		}
	}
	else
	{
		$notmoderated = true;
		$amount = $transferred = $vbulletin->GPC['amount'];
		$bankfee = $vbulletin->GPC['amount'] * $vbulletin->options['credits_bankfee'];

		($hook = vBulletinHook::fetch_hook('credits_transfer_start')) ? eval($hook) : false;

		if ($vbulletin->options['credits_feetype'] == 'pos')
		{
			$amount += $bankfee;
		}
		else
		{
			$transferred -= $bankfee;
		}
		if (empty($amount))
		{
			eval(standard_error(fetch_error('invalid_x_specified', $vbphrase['credits_amount'])));
		}
		if ($vbulletin->GPC['type'] == 'saving')
		{
			if ($amount > $vbulletin->userinfo['credits'])
			{
				eval(standard_error(fetch_error('credits_transfersorry')));
			}

			$history = $db->query_first("SELECT SUM(amount) AS total FROM " . TABLE_PREFIX . "credits_bank WHERE userid = " . $vbulletin->userinfo['userid'] . " AND status < 2 AND type = 'save'");

			if ($creditperms['credit_maxsave'] > -1 AND ($history['total'] + $vbulletin->userinfo['credits_saved'] + $transferred) > $creditperms['credit_maxsave'])
			{
				eval(standard_error(fetch_error('credits_toomuchsave')));
			}

			$notmoderated = !($vbulletin->bf_ugp['creditpermissions']['credit_moddeposit'] & $creditperms['creditpermissions']);
			$db->query_write("UPDATE " . TABLE_PREFIX . "user SET credits = credits - $amount WHERE userid = " . $vbulletin->userinfo['userid']);
			$db->query_write("INSERT INTO " . TABLE_PREFIX . "credits_bank (userid, timestamp, status, type, amount, reason) VALUES (" . $vbulletin->userinfo['userid'] . ", " . TIMENOW . ", " . intval($notmoderated) . ", 'save', $transferred, '" . $db->escape_string($vbulletin->GPC['reason']) . "')");
		}
		else
		{
			if ($amount > $vbulletin->userinfo['credits_saved'])
			{
				eval(standard_error(fetch_error('credits_transfersorry')));
			}

			$db->query_write("UPDATE " . TABLE_PREFIX . "user SET credits = credits + $transferred, credits_saved = credits_saved - $amount WHERE userid = " . $vbulletin->userinfo['userid']);
		}
		if ($notmoderated)
		{
			$db->query_write("INSERT INTO " . TABLE_PREFIX . "credits_transactions (fromuserid, touserid, action, comment, amount, timestamp, completed) VALUES (" . ( $vbulletin->GPC['type'] == 'saving' ? $vbulletin->userinfo['userid'] : 0 ) . ", " . ( $vbulletin->GPC['type'] != 'saving' ? $vbulletin->userinfo['userid'] : 0 ) . ", 'save', '" . $db->escape_string($vbulletin->GPC['reason']) . "', $transferred, " . TIMENOW . ", 1)");
		}
	}

	build_datastore('credits_central', $vbulletin->credits_central + $bankfee, false);

	($hook = vBulletinHook::fetch_hook('credits_transfer_end')) ? eval($hook) : false;

	$vbulletin->url = 'credits.php?' . $vbulletin->session->vars['sessionurl'] . 'do=banking';
	eval(print_standard_redirect('credits_transferthanks'));
}

if ($_REQUEST['do'] == 'loans')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'loan'		=> TYPE_ARRAY_UINT,
		'recur'		=> TYPE_ARRAY_UINT,
		'amount'	=> TYPE_ARRAY_UNUM,
		'reason'	=> TYPE_NOHTML,
		'confirm'	=> TYPE_BOOL
	));

	if ($vbulletin->userinfo['posts'] < $vbulletin->options['credits_bankposts'] OR $vbulletin->userinfo['reputation'] < $vbulletin->options['credits_bankrep'] OR floor((TIMENOW - $vbulletin->userinfo['joindate']) / 86400) < $vbulletin->options['credits_banktime'])
	{
		eval(standard_error(fetch_error('credits_notyetbank')));
	}
	if ($loanid = array_pop(array_keys($vbulletin->GPC['loan'])))
	{
		$amount = $vbulletin->GPC['amount'][$loanid];
		$loan = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "credits_bank WHERE bankid = " . $loanid);

		($hook = vBulletinHook::fetch_hook('credits_loanpay_start')) ? eval($hook) : false;

		if ($loan['type'] == 'loan')
		{
			if ($loan['status'] == 1)
			{
				if ($amount > $loan['current'])
				{
					$amount = $loan['current'];
				}
				if (empty($amount))
				{
					eval(standard_error(fetch_error('invalid_x_specified', $vbphrase['credits_amount'])));
				}
				if ($amount > $vbulletin->userinfo['credits'])
				{
					eval(standard_error(fetch_error('credits_notenoughloan')));
				}

				$db->query_write("UPDATE " . TABLE_PREFIX . "user SET credits = credits - $amount WHERE userid = " . $vbulletin->userinfo['userid']);
				$db->query_write("UPDATE " . TABLE_PREFIX . "credits_bank SET current = current - $amount, recurdays = " . $vbulletin->GPC['recur'][$loanid] . ", recuramount = $amount, lastpay = " . TIMENOW . " WHERE bankid = " . $loan['bankid']);
				$db->query_write("INSERT INTO " . TABLE_PREFIX . "credits_transactions (fromuserid, touserid, action, comment, amount, timestamp, completed) VALUES (" . $vbulletin->userinfo['userid'] . ", 0, 'loan', '" . $db->escape_string($vbulletin->GPC['reason']) . "', $amount, " . TIMENOW . ", 1)");

				($hook = vBulletinHook::fetch_hook('credits_loanpay_end')) ? eval($hook) : false;

				$vbulletin->url = 'credits.php?' . $vbulletin->session->vars['sessionurl'] . 'do=banking';
				eval(print_standard_redirect('credits_loanpaythanks'));
			}
			else
			{
				eval(standard_error(fetch_error('credits_loanmod')));
			}
		}
	}
	else
	{
		if ($vbulletin->GPC['confirm'])
		{
			$history = $db->query_first("SELECT COUNT(*) AS total FROM " . TABLE_PREFIX . "credits_bank WHERE userid = " . $vbulletin->userinfo['userid'] . " AND status < 2 AND type = 'loan'");

			($hook = vBulletinHook::fetch_hook('credits_loanget_start')) ? eval($hook) : false;

			if ($creditperms['credit_totloan'] > -1 AND $history['total'] > $creditperms['credit_totloan'])
			{
				eval(standard_error(fetch_error('credits_nomoreloans')));
			}
			if ($vbulletin->GPC['amount'][0] < ($vbulletin->options['credits_minloan'] * $creditperms['credit_maxloan']) OR $vbulletin->GPC['amount'][0] > $creditperms['credit_maxloan'])
			{
				eval(standard_error(fetch_error('credits_noloan')));
			}

			$notmoderated = !($vbulletin->bf_ugp['creditpermissions']['credit_modloan'] & $creditperms['creditpermissions']);
			$db->query_write("INSERT INTO " . TABLE_PREFIX . "credits_bank (userid, timestamp, status, type, amount, prevamount, current, reason) VALUES (" . $vbulletin->userinfo['userid'] . ", " . TIMENOW . ", " . intval($notmoderated) . ", 'loan', " . $vbulletin->GPC['amount'][0] . ", " . $vbulletin->GPC['amount'][0] . ", " . $vbulletin->GPC['amount'][0] . ", '" . $db->escape_string($vbulletin->GPC['reason']) . "')");

			if ($notmoderated)
			{
				$db->query_write("UPDATE " . TABLE_PREFIX . "user SET credits = credits + " . $vbulletin->GPC['amount'][0] . " WHERE userid = " . $vbulletin->userinfo['userid']);
				$db->query_write("INSERT INTO " . TABLE_PREFIX . "credits_transactions (fromuserid, touserid, action, comment, amount, timestamp, completed) VALUES (0, " . $vbulletin->userinfo['userid'] . ", 'loan', '" . $db->escape_string($vbulletin->GPC['reason']) . "', " . $vbulletin->GPC['amount'][0] . ", " . TIMENOW . ", 1)");
			}

			($hook = vBulletinHook::fetch_hook('credits_loanget_end')) ? eval($hook) : false;

			$vbulletin->url = 'credits.php?' . $vbulletin->session->vars['sessionurl'] . 'do=banking';
			eval(print_standard_redirect('credits_loangetthanks'));
		}
		else
		{
			$_REQUEST['do'] = 'banking';
		}
	}
}

if ($_REQUEST['do'] == 'banking')
{
	/*$vbulletin->input->clean_array_gpc('p', array(
		'credits_statement'	=> TYPE_NOHTML,
		'credits_alert'		=> TYPE_NOHTML
	));

	$statement_array = array(
		'email_monthly' => $vbphrase['email_monthly'],
		'email_weekly' => $vbphrase['email_weekly'],
		'email_daily' => $vbphrase['email_daily'],
		'pm_monthly' => $vbphrase['pm_monthly'],
		'pm_weekly' => $vbphrase['pm_weekly'],
		'pm_daily' => $vbphrase['pm_daily'],
		'none' => $vbphrase['credits_nothing']
	);

	$alert_array = array(
		'alert_day' => $vbphrase['alert_day'],
		'alert_week' => $vbphrase['alert_week'],
		'email_day' => $vbphrase['email_day'],
		'email_week' => $vbphrase['email_week'],
		'pm_day' => $vbphrase['pm_day'],
		'pm_week' => $vbphrase['pm_week'],
		'none' => $vbphrase['credits_nothing']
	);*/

	$pendsaved = 0;
	$pendingbits = $loanbits = '';
	$logcache = $namecache = $readusers = array();
	$page = ( empty($_REQUEST['page']) ? 1 : $vbulletin->input->clean_gpc('r', 'page', TYPE_UINT) );

	($hook = vBulletinHook::fetch_hook('credits_bank_start')) ? eval($hook) : false;

	$userinfo = ( ($userid AND $vbulletin->userinfo['userid'] != $userid AND $vbulletin->bf_ugp['creditpermissions']['credit_canview'] & $creditperms['creditpermissions']) ? fetch_userinfo($userid) : $vbulletin->userinfo );	
	$creditperms = $vbulletin->usergroupcache[$userinfo['usergroupid']];
	$show['member_bank'] = ($userinfo['userid'] == $vbulletin->userinfo['userid'] AND $vbulletin->userinfo['posts'] >= $vbulletin->options['credits_bankposts'] AND $vbulletin->userinfo['reputation'] >= $vbulletin->options['credits_bankrep'] AND floor((TIMENOW - $vbulletin->userinfo['joindate']) / 86400) >= $vbulletin->options['credits_banktime']);

	/*if ($show['member_bank'] AND !empty($vbulletin->GPC['credits_statement']) AND !empty($vbulletin->GPC['credits_alert']))
	{
		$userinfo['credits_statement'] = $vbulletin->GPC['credits_statement'];
		$userinfo['credits_alert'] = $vbulletin->GPC['credits_alert'];
		$db->query_write("UPDATE " . TABLE_PREFIX . "user SET credits_statement = '" . $db->escape_string($userinfo['credits_statement']) . "', credits_alert = '" . $db->escape_string($userinfo['credits_alert']) . "' WHERE userid = " . $userinfo['userid']);
	}*/

	//require_once(DIR . '/includes/adminfunctions.php');
	//$statement_options = construct_select_options($statement_array, $userinfo['credits_statement']);
	//$alert_options = construct_select_options($alert_array, $userinfo['credits_alert']);

	$mincredits = vb_number_format($vbulletin->options['credits_minsave'], $vbulletin->options['credits_decimals']);
	$saveinterest = vb_number_format(100 * $creditperms['credit_saveint'], $vbulletin->options['credits_percents']);
	$transfee = vb_number_format(100 * $vbulletin->options['credits_bankfee'], $vbulletin->options['credits_percents']);
	$earlyfee = vb_number_format(100 * $vbulletin->options['credits_earlywithdraw'], $vbulletin->options['credits_percents']);
	$maxsave = ( $creditperms['credit_maxsave'] > -1 ? vb_number_format($creditperms['credit_maxsave'], $vbulletin->options['credits_decimals']) : $vbphrase['unlimited'] );
	$bankbits = array(construct_phrase($vbphrase['credits_bankbit'], $vbphrase['credits_checking'], vb_number_format($userinfo['credits'], $vbulletin->options['credits_decimals']), $vbphrase['credits']));
	$minamount = $vbulletin->options['credits_minloan'] * $creditperms['credit_maxloan'];
	$minloan = vb_number_format($minamount, $vbulletin->options['credits_decimals']);
	$maxloan = vb_number_format($creditperms['credit_maxloan'], $vbulletin->options['credits_decimals']);
	$minpaypercent = vb_number_format(100 * $vbulletin->options['credits_minpayment'], $vbulletin->options['credits_percents']);
	$loaninterest = vb_number_format(100 * $creditperms['credit_loanint'], $vbulletin->options['credits_percents']);
	$penalty = vb_number_format($vbulletin->options['credits_latefee'], $vbulletin->options['credits_decimals']);
	$nexttime = vbdate($vbulletin->options['dateformat'], $vbulletin->credits_interest + $vbulletin->options['credits_interestinterval'] * 86400);
	$bankstuff = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "credits_bank WHERE userid = " . $userinfo['userid'] . " AND type = 'save' AND status < 2 ORDER BY timestamp DESC");
	$loans = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "credits_bank WHERE userid = " . $userinfo['userid'] . " AND type = 'loan' AND status < 2 ORDER BY timestamp DESC");

	while ($bank = $db->fetch_array($bankstuff))
	{
		$pendsaved += $bank['amount'];
		$pendamount = vb_number_format($bank['amount'], $vbulletin->options['credits_decimals']);
		$penddate = vbdate($vbulletin->options['dateformat'], $bank['timestamp'], true);

		eval('$pendingbits .= "' . fetch_template('credits_deposit') . '";');
	}
	while ($loan = $db->fetch_array($loans))
	{
		$principal = vb_number_format($loan['current'], $vbulletin->options['credits_decimals']);
		$sincestart = vbdate($vbulletin->options['dateformat'], $loan['timestamp']);
		$recur = vb_number_format(( $loan['recurdays'] ? $loan['recuramount'] : 0 ), $vbulletin->options['credits_decimals']);
		$default = $vbulletin->options['credits_minloan'] * $loan['amount'];

		if ($loan['lastpay'] >= $vbulletin->credits_interest)
		{
			$default -= ($loan['prevamount'] - $loan['current']);

			if ($default < 0)
			{
				$default = 0;
			}
		}

		($hook = vBulletinHook::fetch_hook('credits_bank_loan')) ? eval($hook) : false;

		eval('$loanbits .= "' . fetch_template('credits_loan') . '";');
	}
	if ($creditperms['credit_maxsave'] != 0)
	{
		$bankbits[] = construct_phrase($vbphrase['credits_bankbit'], $vbphrase['credits_savings'], vb_number_format($userinfo['credits_saved'], $vbulletin->options['credits_decimals']), $vbphrase['credits']);
	}
	if ($creditperms['credit_totloan'] != 0)
	{
		$bankbits[] = construct_phrase($vbphrase['credits_bankbit'], $vbphrase['credits_rating'], vb_number_format($userinfo['credits_score'], 0), '');
	}

	$show['savings'] = ($creditperms['credit_maxsave'] < 0 OR ($userinfo['credits_saved'] + $pendsaved) < $creditperms['credit_maxsave']);
	$show['loans'] = ($creditperms['credit_totloan'] < 0 OR $db->num_rows($loans) < $creditperms['credit_totloan']);

	$db->free_result($loans);
	$db->free_result($bankstuff);
	$bankinfo = implode(' | ', $bankbits);
	$alllogs = $db->query_first("SELECT COUNT(*) AS total FROM " . TABLE_PREFIX . "credits_transactions WHERE completed = 1 AND (fromuserid = " . $userinfo['userid'] . " OR touserid = " . $userinfo['userid'] . ")");
	$logs = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "credits_transactions WHERE completed = 1 AND (fromuserid = " . $userinfo['userid'] . " OR touserid = " . $userinfo['userid'] . ") ORDER BY timestamp DESC LIMIT " . (($page - 1) * $vbulletin->options['credits_logpp']) . ", " . $vbulletin->options['credits_logpp']);

	while ($log = $db->fetch_array($logs))
	{
		if (!in_array($log['fromuserid'], $readusers))
		{
			$readusers[] = $log['fromuserid'];
		}
		if (!in_array($log['touserid'], $readusers))
		{
			$readusers[] = $log['touserid'];
		}

		$logcache[] = $log;
	}
	if (sizeof($readusers))
	{
		$users = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "user WHERE userid IN (" . implode(', ', $readusers) . ")");

		while ($user = $db->fetch_array($users))
		{
			$namecache[$user['userid']] = $user;
		}

		$db->free_result($users);
	}
	foreach ($logcache AS $log)
	{
		switch ($log['action'])
		{
			case 'donate':
				$action = $vbphrase['donation'];
				break;
			case 'post':
				$action = $vbphrase['posting'];
				break;
			case 'award':
				$action = $vbphrase['award'];
				break;
			case 'save':
				$action = $vbphrase['credits_savings'];
				break;
			case 'loan':
				$action = $vbphrase['credits_loan'];
				break;
			case 'drawing':
				$action = $vbphrase['drawing'];
				break;
		}
		if ($log['fromuserid'] == $userinfo['userid'])
		{
			$userid = $log['touserid'];

			switch ($log['action'])
			{
				case 'save':
					$secondary = $vbphrase['credits_deposit'];
					break;
				case 'loan':
					$secondary = $vbphrase['credits_payment'];
					break;
				default:
					$secondary = $vbphrase['given'];
			}
			if ($log['action'] == 'donate' AND $vbulletin->options['credits_feetype'] == 'pos')
			{
				$log['amount'] *= (1 + $vbulletin->options['credits_donatefee']);
			}
		}
		else
		{
			$userid = $log['fromuserid'];

			switch ($log['action'])
			{
				case 'save':
					$secondary = $vbphrase['credits_withdraw'];
					break;
				case 'loan':
					$secondary = $vbphrase['credits_granted'];
					break;
				case 'drawing':
					$secondary = $vbphrase['winnings'];
					break;
				default:
					$secondary = $vbphrase['received'];
			}
			if ($log['action'] == 'donate' AND $vbulletin->options['credits_feetype'] == 'neg')
			{
				$log['amount'] *= (1 - $vbulletin->options['credits_donatefee']);
			}
		}

		$show['realname'] = (!$log['anonymous'] OR ($vbulletin->bf_ugp['creditpermissions']['credit_cansee'] & $creditperms['creditpermissions']) OR $log['fromuserid'] == $vbulletin->userinfo['userid']);
		$logname = ( $userid ? fetch_musername($namecache[$userid]) : $vbphrase['forum'] );
		$datestamp = vbdate($vbulletin->options['dateformat'], $log['timestamp'], true);
		$comment = ( !empty($log['comment']) ? $bbcode_parser->parse(fetch_censored_text(unhtmlspecialchars($log['comment']))) : $vbphrase['n_a'] );
		$amount = vb_number_format($log['amount'], $vbulletin->options['credits_decimals']);
		
		($hook = vBulletinHook::fetch_hook('credits_logtype')) ? eval($hook) : false;

		eval('$logentries .= "' . fetch_template('credits_logrow') . '";');
	}

	($hook = vBulletinHook::fetch_hook('credits_bank_end')) ? eval($hook) : false;

	$db->free_result($logs);
	$pagenav = construct_page_nav($page, $vbulletin->options['credits_logpp'], $alllogs['total'], 'credits.php?' . $vbulletin->session->vars['sessionurl'] . 'do=banking&u=' . $userinfo['userid']);
	$credit_title = $vbphrase['credits_bankingloans'];
	$credit_navbar = $credit_template = 'credits_bank';
}

$navbits = array('usercp.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['user_control_panel']);
$navbits[''] = $credit_title;

($hook = vBulletinHook::fetch_hook('credits_end')) ? eval($hook) : false;

construct_usercp_nav($credit_navbar);
$navbits = construct_navbits($navbits);
eval('$navbar = "' . fetch_template('navbar') . '";');
eval('$HTML = "' . fetch_template($credit_template) . '";');
eval('print_output("' . fetch_template('USERCP_SHELL') . '");');
?>