<?php
/*=======================================================================*\
|| ##################################################################### ||
|| # vBCredits 1.4 - `credits_installer.php`						   # ||
|| # ------------------------------------------------------------------# ||
|| # Author: John Jakubowski "Darkwaltz4" {blackwaltz4@msn.com}		   # ||
|| # Copyright 2007-2008 PixelFX Studios Ltd. All Rights Reserved.	   # ||
|| # This file may not be redistributed in whole or significant part.  # ||
|| # -----------------vBulletin IS NOT FREE SOFTWARE!------------------# ||
|| #                Support: http://www.vbcredits.com/				   # ||
|| ##################################################################### ||
\*=======================================================================*/

if (!defined('VB_AREA'))
{
	exit;
}

function credits_check($conditional, $addstring) { global $colarray; if ($conditional) { $colarray[] = $addstring; } }

if ($doinstall)
{
	if (!file_exists(DIR . '/plugins/credits_plugins.php') OR !file_exists(DIR . '/includes/functions_credits.php') OR !file_exists(DIR . '/includes/xml/bitfield_credits.xml') OR !file_exists(DIR . '/includes/xml/cpnav_credits.xml'))
	{
		print_dots_stop();
		print_cp_message('Please upload all of the files that came with vBCredits before installing or upgrading!');
	}
	if (!method_exists(new vBulletinHook, 'fetch_hookusage'))
	{
		print_dots_stop();
		print_cp_message('Apply the Fix for Old vBulletins.txt for your installation of vBCredits to work on this version of vBulletin!');
	}
	if ($vbulletin->products['tms'])
	{
		require_once(DIR . '/includes/adminfunctions_templateedits.php');
		install_templateedits($info, $arr, $active);
	}
	if ($installed_version == '1.0')
	{
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "phrase WHERE varname = 'powered_by_vbulletin' AND product = 'credits' AND languageid = -1");
		$db->query_write("INSERT INTO " . TABLE_PREFIX . "phrase (languageid, varname, fieldname, text, product, username, dateline, version) VALUES (-1, 'powered_by_vbulletin', 'global', 'Powered by vBulletin&reg; Version {1}<br />Copyright &copy;2000 - {2}, Jelsoft Enterprises Ltd.', 'vbulletin', 'Kier', 1163500480, '3.6.4')");
	}

	$db->query_write("CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "credits_transactions` (
	  `transactionid` int(10) unsigned NOT NULL auto_increment,
	  `fromuserid` int(10) unsigned NOT NULL default '0',
	  `anonymous` tinyint(1) unsigned NOT NULL default '0',
	  `touserid` int(10) unsigned NOT NULL default '0',
	  `action` varchar(20) NOT NULL,
	  `postid` int(10) unsigned NOT NULL default '0',
	  `comment` varchar(255) NOT NULL,
	  `amount` double NOT NULL default '0',
	  `timestamp` int(10) unsigned NOT NULL default '0',
	  `completed` tinyint(1) unsigned NOT NULL default '1',
	  PRIMARY KEY  (`transactionid`)
	)");

	$db->query_write("CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "credits_bank` (
	  `bankid` int(10) unsigned NOT NULL auto_increment,
	  `userid` int(10) unsigned NOT NULL default '0',
	  `timestamp` int(10) unsigned NOT NULL default '0',
	  `status` tinyint(1) unsigned NOT NULL default '1',
	  `type` varchar(255) NOT NULL,
	  `amount` double unsigned NOT NULL default '0',
	  `current` double unsigned NOT NULL default '0',
	  `prevamount` double unsigned NOT NULL default '0',
	  `reason` varchar(255) NOT NULL,
	  `recurdays` int(10) unsigned NOT NULL default '0',
	  `recuramount` double unsigned NOT NULL default '0',
	  `lastpay` int(10) unsigned NOT NULL default '0',
	  PRIMARY KEY  (`bankid`)
	)");

	$db->query_write("CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "credits_lottery` (
	  `lotteryid` int(10) unsigned NOT NULL auto_increment,
	  `title` varchar(255) NOT NULL,
	  `winner` text NOT NULL,
	  `drawtime` int(10) unsigned NOT NULL default '0',
	  `recurdays` int(10) unsigned NOT NULL default '0',
	  `active` tinyint(1) unsigned NOT NULL default '1',
	  `tickets` varchar(255) NOT NULL default 'raffle',
	  `wintype` varchar(255) NOT NULL default 'raise',
	  `jackpot` double unsigned NOT NULL default '0',
	  `excluded` varchar(255) NOT NULL,
	  `ticketcost` double unsigned NOT NULL default '0',
	  `mintickets` int(10) unsigned NOT NULL default '1',
	  `heldtickets` text NOT NULL,
	  `winnerphp` text NOT NULL,
	  PRIMARY KEY  (`lotteryid`)
	)");

	$checkcols = $db->query_first("SHOW columns FROM " . TABLE_PREFIX . "credits_transactions LIKE 'completed'");

	if (empty($checkcols['Field']))
	{
		$db->query_write("ALTER TABLE `" . TABLE_PREFIX . "credits_transactions` ADD `completed` TINYINT( 1 ) UNSIGNED NOT NULL DEFAULT '1'");
	}

	$checkcols = $db->query_first("SHOW columns FROM " . TABLE_PREFIX . "thread LIKE 'awardedcredits'");

	if (empty($checkcols['Field']))
	{
		$db->query_write("ALTER TABLE `" . TABLE_PREFIX . "thread` ADD `awardedcredits` DOUBLE NOT NULL DEFAULT '0'");
	}

	$colarray = array();
	$checkcols = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "user LIMIT 1");
	credits_check(!array_key_exists('credits', $checkcols), "ADD `credits` DOUBLE NOT NULL DEFAULT '0'");
	credits_check(!array_key_exists('credits_numrefs', $checkcols), "ADD `credits_numrefs` INT( 10 ) UNSIGNED NOT NULL DEFAULT '0'");
	credits_check(!array_key_exists('credits_saved', $checkcols), "ADD `credits_saved` DOUBLE NOT NULL DEFAULT '0'");
	credits_check(!array_key_exists('credits_canspend', $checkcols), "ADD `credits_canspend` TINYINT( 1 ) UNSIGNED NOT NULL DEFAULT '1'");
	credits_check(!array_key_exists('credits_score', $checkcols), "ADD `credits_score` INT NOT NULL DEFAULT '0'");
	credits_check(!array_key_exists('credits_interest', $checkcols), "ADD `credits_interest` INT( 10 ) UNSIGNED NOT NULL DEFAULT '0'");
	credits_check(!array_key_exists('credits_statement', $checkcols), "ADD `credits_statement` VARCHAR( 255 ) NOT NULL DEFAULT 'none'");
	credits_check(!array_key_exists('credits_alert', $checkcols), "ADD `credits_alert` VARCHAR( 255 ) NOT NULL DEFAULT 'none'");

	if (!array_key_exists('credits_canearn', $checkcols))
	{
		$colarray[] = ( array_key_exists('credits_canget', $checkcols) ? "CHANGE `credits_canget`" : 'ADD' ) . " `credits_canearn` TINYINT( 1 ) UNSIGNED NOT NULL DEFAULT '1'";
	}
	if (sizeof($colarray))
	{
		$db->query_write("ALTER TABLE `" . TABLE_PREFIX . "user` " . implode(', ', $colarray));
	}

	$colarray = array();
	$checkcols = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "usergroup LIMIT 1");
	credits_check(array_key_exists('credit_canadd', $checkcols), "DROP `credit_canadd`");
	credits_check(array_key_exists('credit_cananon', $checkcols), "DROP `credit_cananon`");
	credits_check(array_key_exists('credit_canview', $checkcols), "DROP `credit_canview`");
	credits_check(array_key_exists('credit_cansee', $checkcols), "DROP `credit_cansee`");
	credits_check(array_key_exists('credit_unpost', $checkcols), "DROP `credit_unpost`");
	credits_check(array_key_exists('credit_unthread', $checkcols), "DROP `credit_unthread`");
	credits_check(array_key_exists('credit_repneg', $checkcols), "DROP `credit_repneg`");
	credits_check(!array_key_exists('credit_induction', $checkcols), "ADD `credit_induction` DOUBLE NOT NULL DEFAULT '100'");
	credits_check(!array_key_exists('credit_post', $checkcols), "ADD `credit_post` DOUBLE NOT NULL DEFAULT '5'");
	credits_check(!array_key_exists('credit_thread', $checkcols), "ADD `credit_thread` DOUBLE NOT NULL DEFAULT '10'");
	credits_check(!array_key_exists('credit_referral', $checkcols), "ADD `credit_referral` DOUBLE NOT NULL DEFAULT '100'");
	credits_check(!array_key_exists('credit_refbonus', $checkcols), "ADD `credit_refbonus` DOUBLE NOT NULL DEFAULT '0.05'");
	credits_check(!array_key_exists('credit_birthday', $checkcols), "ADD `credit_birthday` DOUBLE NOT NULL DEFAULT '100'");
	credits_check(!array_key_exists('credit_repgive', $checkcols), "ADD `credit_repgive` DOUBLE NOT NULL DEFAULT '0.1'");
	credits_check(!array_key_exists('credit_threadrate', $checkcols), "ADD `credit_threadrate` DOUBLE NOT NULL DEFAULT '1'");
	credits_check(!array_key_exists('credit_ownthreadpost', $checkcols), "ADD `credit_ownthreadpost` DOUBLE NOT NULL DEFAULT '3'");
	credits_check(!array_key_exists('credit_pollmake', $checkcols), "ADD `credit_pollmake` DOUBLE NOT NULL DEFAULT '5'");
	credits_check(!array_key_exists('credit_pollvote', $checkcols), "ADD `credit_pollvote` DOUBLE NOT NULL DEFAULT '1'");
	credits_check(!array_key_exists('creditpermissions', $checkcols), "ADD `creditpermissions` INT( 10 ) UNSIGNED NOT NULL DEFAULT '0'");
	credits_check(!array_key_exists('credit_addevent', $checkcols), "ADD `credit_addevent` DOUBLE NOT NULL DEFAULT '3'");
	credits_check(!array_key_exists('credit_addprofpic', $checkcols), "ADD `credit_addprofpic` DOUBLE NOT NULL DEFAULT '3'");
	credits_check(!array_key_exists('credit_attachment', $checkcols), "ADD `credit_attachment` DOUBLE NOT NULL DEFAULT '3'");
	credits_check(!array_key_exists('credit_sendpm', $checkcols), "ADD `credit_sendpm` DOUBLE NOT NULL DEFAULT '-2'");
	credits_check(!array_key_exists('credit_ownthreadview', $checkcols), "ADD `credit_ownthreadview` DOUBLE NOT NULL DEFAULT '0.05'");
	credits_check(!array_key_exists('credit_ownprofileview', $checkcols), "ADD `credit_ownprofileview` DOUBLE NOT NULL DEFAULT '0.05'");
	credits_check(!array_key_exists('credit_ownthreadrate', $checkcols), "ADD `credit_ownthreadrate` DOUBLE NOT NULL DEFAULT '1'");
	credits_check(!array_key_exists('credit_ownthreadreply', $checkcols), "ADD `credit_ownthreadreply` DOUBLE NOT NULL DEFAULT '2'");
	credits_check(!array_key_exists('credit_infraction', $checkcols), "ADD `credit_infraction` DOUBLE NOT NULL DEFAULT '-10'");
	credits_check(!array_key_exists('credit_donmaxuser', $checkcols), "ADD `credit_donmaxuser` DOUBLE NOT NULL DEFAULT '-1'");
	credits_check(!array_key_exists('credit_pastotpost', $checkcols), "ADD `credit_pastotpost` DOUBLE NOT NULL DEFAULT '0'");
	credits_check(!array_key_exists('credit_pastotuser', $checkcols), "ADD `credit_pastotuser` DOUBLE NOT NULL DEFAULT '0'");
	credits_check(!array_key_exists('credit_pasawuser', $checkcols), "ADD `credit_pasawuser` DOUBLE NOT NULL DEFAULT '0'");
	credits_check(!array_key_exists('credit_pasawthread', $checkcols), "ADD `credit_pasawthread` DOUBLE NOT NULL DEFAULT '0'");
	credits_check(!array_key_exists('credit_saveint', $checkcols), "ADD `credit_saveint` DOUBLE NOT NULL DEFAULT '0.035'");
	credits_check(!array_key_exists('credit_maxsave', $checkcols), "ADD `credit_maxsave` DOUBLE NOT NULL DEFAULT '10000'");
	credits_check(!array_key_exists('credit_loanint', $checkcols), "ADD `credit_loanint` DOUBLE NOT NULL DEFAULT '0.195'");
	credits_check(!array_key_exists('credit_maxloan', $checkcols), "ADD `credit_maxloan` DOUBLE UNSIGNED NOT NULL DEFAULT '1000'");
	credits_check(!array_key_exists('credit_totloan', $checkcols), "ADD `credit_totloan` DOUBLE NOT NULL DEFAULT '5'");
	credits_check(!array_key_exists('credit_maxtickets', $checkcols), "ADD `credit_maxtickets` DOUBLE NOT NULL DEFAULT '10'");
	credits_check(!array_key_exists('credit_lotdiscount', $checkcols), "ADD `credit_lotdiscount` DOUBLE NOT NULL DEFAULT '0'");
	credits_check(!array_key_exists('credit_profile', $checkcols), "ADD `credit_profile` DOUBLE NOT NULL DEFAULT '0'");
	credits_check(!array_key_exists('credit_goodgroup', $checkcols), "ADD `credit_goodgroup` INT( 10 ) UNSIGNED NOT NULL DEFAULT '0'");
	credits_check(!array_key_exists('credit_badgroup', $checkcols), "ADD `credit_badgroup` INT( 10 ) UNSIGNED NOT NULL DEFAULT '0'");
	credits_check(!array_key_exists('credit_midgroup', $checkcols), "ADD `credit_midgroup` INT( 10 ) UNSIGNED NOT NULL DEFAULT '0'");

	if (!array_key_exists('credit_active', $checkcols))
	{
		$colarray[] = ( array_key_exists('credit_login', $checkcols) ? "CHANGE `credit_login`" : 'ADD' ) . " `credit_active` DOUBLE NOT NULL DEFAULT '20'";
	}
	if (!array_key_exists('credit_postsize', $checkcols))
	{
		$colarray[] = ( array_key_exists('credit_perchar', $checkcols) ? "CHANGE `credit_perchar`" : 'ADD' ) . " `credit_postsize` DOUBLE NOT NULL DEFAULT '0.05'";
	}
	if (!array_key_exists('credit_paycheck', $checkcols))
	{
		$colarray[] = ( array_key_exists('credit_daily', $checkcols) ? "CHANGE `credit_daily`" : 'ADD' ) . " `credit_paycheck` DOUBLE NOT NULL DEFAULT '0'";
	}
	if (!array_key_exists('credit_reputation', $checkcols))
	{
		$colarray[] = ( array_key_exists('credit_reppos', $checkcols) ? "CHANGE `credit_reppos`" : 'ADD' ) . " `credit_reputation` DOUBLE NOT NULL DEFAULT '2'";
	}
	if (sizeof($colarray))
	{
		$db->query_write("ALTER TABLE `" . TABLE_PREFIX . "usergroup` " . implode(', ', $colarray));
	}

	$db->query_write("ALTER TABLE `" . TABLE_PREFIX . "usergroup`
		CHANGE `credit_referral` `credit_referral` DOUBLE NOT NULL DEFAULT '100',
		CHANGE `credit_paycheck` `credit_paycheck` DOUBLE NOT NULL DEFAULT '0',
		CHANGE `credit_induction` `credit_induction` DOUBLE NOT NULL DEFAULT '100',
		CHANGE `credit_post` `credit_post` DOUBLE NOT NULL DEFAULT '5',
		CHANGE `credit_thread` `credit_thread` DOUBLE NOT NULL DEFAULT '10',
		CHANGE `credit_active` `credit_active` DOUBLE NOT NULL DEFAULT '20',
		CHANGE `credit_postsize` `credit_postsize` DOUBLE NOT NULL DEFAULT '0.05',
		CHANGE `credit_refbonus` `credit_refbonus` DOUBLE NOT NULL DEFAULT '0.05',
		CHANGE `credit_birthday` `credit_birthday` DOUBLE NOT NULL DEFAULT '100',
		CHANGE `credit_repgive` `credit_repgive` DOUBLE NOT NULL DEFAULT '0.1',
		CHANGE `credit_threadrate` `credit_threadrate` DOUBLE NOT NULL DEFAULT '1',
		CHANGE `credit_ownthreadpost` `credit_ownthreadpost` DOUBLE NOT NULL DEFAULT '3',
		CHANGE `credit_pollmake` `credit_pollmake` DOUBLE NOT NULL DEFAULT '5',
		CHANGE `credit_pollvote` `credit_pollvote` DOUBLE NOT NULL DEFAULT '1'
	");

	$colarray = array();
	$db->query_write("ALTER TABLE `" . TABLE_PREFIX . "datastore` CHANGE `title` `title` CHAR( 50 ) NOT NULL");
	$db->query_write("ALTER TABLE `" . TABLE_PREFIX . "user` CHANGE `credits` `credits` DOUBLE NOT NULL DEFAULT '0'");
	$checkcols = $db->query_read("SELECT title FROM " . TABLE_PREFIX . "datastore WHERE title IN ('credits_forum_overrides', 'credits_central', 'credits_interest')");

	while ($check = $db->fetch_array($checkcols))
	{
		$colarray[$check['title']] = true;
	}
	if ($colarray['credits_forum_overrides'])
	{
		build_datastore('credits_forum_overrides', serialize(array()), 1);
	}
	if ($colarray['credits_central'])
	{
		build_datastore('credits_central', 0, false);
	}
	if ($colarray['credits_interest'])
	{
		build_datastore('credits_interest', TIMENOW, false);
	}

	$db->free_result($checkcols);
	define('DISABLE_PRODUCT_REDIRECT', true);
	define('CP_REDIRECT', 'index.php?loc=' . urlencode('options.php?do=options&dogroup=credits_global_settings'));
	unset($vbulletin->options['credits_donttouch']);
	unset($vbulletin->options['credits_public']);
	build_forum_permissions();
}
else
{
	if ($vbulletin->products['tms'])
	{
		require_once(DIR . '/includes/adminfunctions_templateedits.php');
		uninstall_templateedits($vbulletin->GPC['productid']);
	}

	$db->query_write("DROP TABLE IF EXISTS `" . TABLE_PREFIX . "credits_transactions`");
	$db->query_write("DROP TABLE IF EXISTS `" . TABLE_PREFIX . "credits_bank`");
	$db->query_write("DROP TABLE IF EXISTS `" . TABLE_PREFIX . "credits_lottery`");
	$checkcols = $db->query_first("SHOW columns FROM " . TABLE_PREFIX . "thread LIKE 'awardedcredits'");

	if (!empty($checkcols['Field']))
	{
		$db->query_write("ALTER TABLE `" . TABLE_PREFIX . "thread` DROP `awardedcredits`");
	}

	$colarray = array();
	$checkcols = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "user LIMIT 1");
	credits_check(array_key_exists('credits', $checkcols), "DROP `credits`");
	credits_check(array_key_exists('credits_numrefs', $checkcols), "DROP `credits_numrefs`");
	credits_check(array_key_exists('credits_saved', $checkcols), "DROP `credits_saved`");
	credits_check(array_key_exists('credits_canspend', $checkcols), "DROP `credits_canspend`");
	credits_check(array_key_exists('credits_score', $checkcols), "DROP `credits_score`");
	credits_check(array_key_exists('credits_interest', $checkcols), "DROP `credits_interest`");
	credits_check(array_key_exists('credits_statement', $checkcols), "DROP `credits_statement`");
	credits_check(array_key_exists('credits_alert', $checkcols), "DROP `credits_alert`");
	credits_check(array_key_exists('credits_canearn', $checkcols), "DROP `credits_canearn`");

	if (sizeof($colarray))
	{
		$db->query_write("ALTER TABLE `" . TABLE_PREFIX . "user` " . implode(', ', $colarray));
	}

	$colarray = array();
	$checkcols = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "usergroup LIMIT 1");
	credits_check(array_key_exists('credit_induction', $checkcols), "DROP `credit_induction`");
	credits_check(array_key_exists('credit_post', $checkcols), "DROP `credit_post`");
	credits_check(array_key_exists('credit_thread', $checkcols), "DROP `credit_thread`");
	credits_check(array_key_exists('credit_referral', $checkcols), "DROP `credit_referral`");
	credits_check(array_key_exists('credit_active', $checkcols), "DROP `credit_active`");
	credits_check(array_key_exists('credit_postsize', $checkcols), "DROP `credit_postsize`");
	credits_check(array_key_exists('credit_refbonus', $checkcols), "DROP `credit_refbonus`");
	credits_check(array_key_exists('credit_birthday', $checkcols), "DROP `credit_birthday`");
	credits_check(array_key_exists('credit_repgive', $checkcols), "DROP `credit_repgive`");
	credits_check(array_key_exists('credit_threadrate', $checkcols), "DROP `credit_threadrate`");
	credits_check(array_key_exists('credit_ownthreadpost', $checkcols), "DROP `credit_ownthreadpost`");
	credits_check(array_key_exists('credit_pollmake', $checkcols), "DROP `credit_pollmake`");
	credits_check(array_key_exists('credit_pollvote', $checkcols), "DROP `credit_pollvote`");
	credits_check(array_key_exists('creditpermissions', $checkcols), "DROP `creditpermissions`");
	credits_check(array_key_exists('credit_addevent', $checkcols), "DROP `credit_addevent`");
	credits_check(array_key_exists('credit_addprofpic', $checkcols), "DROP `credit_addprofpic`");
	credits_check(array_key_exists('credit_attachment', $checkcols), "DROP `credit_attachment`");
	credits_check(array_key_exists('credit_sendpm', $checkcols), "DROP `credit_sendpm`");
	credits_check(array_key_exists('credit_ownthreadview', $checkcols), "DROP `credit_ownthreadview`");
	credits_check(array_key_exists('credit_ownprofileview', $checkcols), "DROP `credit_ownprofileview`");
	credits_check(array_key_exists('credit_ownthreadrate', $checkcols), "DROP `credit_ownthreadrate`");
	credits_check(array_key_exists('credit_ownthreadreply', $checkcols), "DROP `credit_ownthreadreply`");
	credits_check(array_key_exists('credit_infraction', $checkcols), "DROP `credit_infraction`");
	credits_check(array_key_exists('credit_donmaxuser', $checkcols), "DROP `credit_donmaxuser`");
	credits_check(array_key_exists('credit_pastotpost', $checkcols), "DROP `credit_pastotpost`");
	credits_check(array_key_exists('credit_pastotuser', $checkcols), "DROP `credit_pastotuser`");
	credits_check(array_key_exists('credit_pasawuser', $checkcols), "DROP `credit_pasawuser`");
	credits_check(array_key_exists('credit_pasawthread', $checkcols), "DROP `credit_pasawthread`");
	credits_check(array_key_exists('credit_saveint', $checkcols), "DROP `credit_saveint`");
	credits_check(array_key_exists('credit_maxsave', $checkcols), "DROP `credit_maxsave`");
	credits_check(array_key_exists('credit_loanint', $checkcols), "DROP `credit_loanint`");
	credits_check(array_key_exists('credit_maxloan', $checkcols), "DROP `credit_maxloan`");
	credits_check(array_key_exists('credit_totloan', $checkcols), "DROP `credit_totloan`");
	credits_check(array_key_exists('credit_maxtickets', $checkcols), "DROP `credit_maxtickets`");
	credits_check(array_key_exists('credit_lotdiscount', $checkcols), "DROP `credit_lotdiscount`");
	credits_check(array_key_exists('credit_profile', $checkcols), "DROP `credit_profile`");
	credits_check(array_key_exists('credit_goodgroup', $checkcols), "DROP `credit_goodgroup`");
	credits_check(array_key_exists('credit_badgroup', $checkcols), "DROP `credit_badgroup`");
	credits_check(array_key_exists('credit_midgroup', $checkcols), "DROP `credit_midgroup`");
	credits_check(array_key_exists('credit_paycheck', $checkcols), "DROP `credit_paycheck`");
	credits_check(array_key_exists('credit_reputation', $checkcols), "DROP `credit_reputation`");

	if (sizeof($colarray))
	{
		$db->query_write("ALTER TABLE `" . TABLE_PREFIX . "usergroup` " . implode(', ', $colarray));
	}

	$db->query_write("DELETE FROM `" . TABLE_PREFIX . "datastore` WHERE `title` IN ('credits_forum_overrides', 'credits_central', 'credits_interest')");
}
?>