<?php
/* ########################## SCRIPT DESCRIPTION ##############################
## 
## This script will randomly select a photo from Photoplog and create a new
## thread in a specific forum with the photo and it's description. 
## 
## This script must be uploaded to the forums/includes/cron/ directory and is run 
## as a scheduled task in Vbulletin's Scheduled Tasks Manager. 
##
#############################################################################*/

/* ########################## CHANGELOG ##############################
## 
## Version 1.0.0 - 12/23/2007
## - First release
##
## Version 1.0.1 - 12/23/2007
## - Added Version Check URL
## - Added Product URL
##
## Version 1.0.2 - 12/24/2007
## - Added Lite & Pro Version Detected Automatically
##
#############################################################################*/
// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

if (!is_object($vbulletin->db)) { exit; }

$tc_potd_active = $vbulletin->options['tc_potd_active'];
$tc_potd_postthread = $vbulletin->options['tc_potd_postthread'];
$tc_potd_title = $vbulletin->options['tc_potd_title'];
$tc_potd_forumid = $vbulletin->options['tc_potd_forumid'];
$tc_potd_threadid = $vbulletin->options['tc_potd_threadid'];
$tc_potd_userid = $vbulletin->options['tc_potd_userid'];
$tc_potd_catid = $vbulletin->options['tc_potd_catid'];
$tc_potd_photoplog_url = $vbulletin->options['tc_potd_photoplog_url'];
$tc_potd_photoplog_imageurl = $vbulletin->options['tc_potd_photoplog_imageurl'];
$tc_potd_views = $vbulletin->options['tc_potd_views'];
$tc_potd_open = $vbulletin->options['tc_potd_open'];
if (is_file(DIR . '/includes/photoplog_prefix.php'))
{
	require_once(DIR . '/includes/photoplog_prefix.php');
}
else
{
	define('PHOTOPLOG_PREFIX', '');
}
if ($vbulletin->options['tc_potd_active'])
{

if ($tc_potd_catid == 0)
	{
	// select the random image from the photo gallery from all categories
		$result= $vbulletin->db->query_read("SELECT fileid, userid, username, title, description, filename, dateline
			FROM " . PHOTOPLOG_PREFIX . "photoplog_fileuploads 
			WHERE views > $tc_potd_views
			AND moderate = 0
			AND potd = 0
			ORDER BY RAND(NOW()) 
			LIMIT 1");
	} else {
	
	// select the random image from the photo gallery from specified categories
		$result= $vbulletin->db->query_read("SELECT fileid, userid, username, title, description, filename, dateline
			FROM " . PHOTOPLOG_PREFIX . "photoplog_fileuploads 
			WHERE catid IN ($tc_potd_catid)
			AND views > $tc_potd_views
			AND moderate = 0
			AND potd = 0
			ORDER BY RAND(NOW()) 
			LIMIT 1");
	}
while ($row= $vbulletin->db->fetch_array($result))     {

	$tc_potd_fileid = $row['fileid'];
	$tc_potd_imageuserid = $row['userid'];
	$tc_potd_username = $row['username'];
	$tc_potd_filename = $row['filename'];
	$tc_potd_imagetitle = $row['title'];	
	$tc_potd_description = $row['description'];
	$tc_potd_dateline = $row['dateline'];

	$arrChars = array();
	
}  	

if ($vbulletin->options['tc_potd_postasuser'])
{
	$tc_potd_postuser = $tc_potd_imageuserid;
} else {
	$tc_potd_postuser = $tc_potd_userid;
}	
// fetch userinfo
if (!$userinfo = fetch_userinfo($tc_potd_postuser))
{
    die("Invalid User!");
}

for ($i = 0; $i < strlen($tc_potd_imageuserid); $i++) 
{
	$arrChars[] = $tc_potd_imageuserid[$i]; 
}

foreach ($arrChars as $char)
{ 
	   
	$uid = $uid . $char ."/";
	   
}


// Put the Photoplog title at the end of the Thread/Post Title
$tc_potd_title .= " ". $tc_potd_imagetitle;

// Post Body
$desc = "
Submitted by: $tc_potd_username

[url=$tc_potd_photoplog_url/index.php?n=$tc_potd_fileid][IMG] $tc_potd_photoplog_imageurl$uid/large/$tc_potd_filename [/IMG][/url]

Description: $tc_potd_description

";

// init datamanager
$threaddm =& datamanager_init('Thread_FirstPost', $vbulletin, ERRTYPE_ARRAY, 'threadpost');

// set data
$foruminfo = fetch_foruminfo($tc_potd_forumid);
$threaddm->set_info('forum',$foruminfo);
$threaddm->set_info('user',$userinfo);
$threaddm->set('userid',$userinfo['userid']);
$threaddm->set('forumid',$tc_potd_forumid);
$threaddm->set('title',$tc_potd_title);
$threaddm->set('pagetext', $desc);
$threaddm->set('open', $tc_potd_open);
$threaddm->set('allowsmilie', 1);
$threaddm->set('visible', 1);

// error checks
$threaddm->pre_save();
if (!empty($threaddm->errors))
{
    echo ($threaddm->errors);
}
if (!$tc_potd_imageuserid)
{
	die("No Forum ID!");
} else {
	$vbulletin->db->query_write("UPDATE " . PHOTOPLOG_PREFIX . "photoplog_fileuploads SET potd = 1	WHERE fileid IN (".$tc_potd_fileid.")");
}
// save
$new_threadid = $threaddm->save();
unset($threaddm);

require_once('includes/functions_databuild.php');
build_thread_counters($new_threadid);
build_forum_counters($tc_potd_forumid); 
// log the cron
log_cron_action('', $nextitem, 1);
}
?>