<?php
/*============================================================================*\
|| ########################################################################## ||
|| # Copyright &copy;2009 eg.tiger                (Original  2005 Dream)   # ||
|| ########################################################################## ||
|| # read_pms.php - Allows Super Administrators to read a member's PMs      # ||
|| ########################################################################## ||
\*============================================================================*/

// ########################################################################
// ###################### USER ALTERABLE SETTINGS #########################
// ########################################################################

// change to set the minimum length a search term, set to 0 will disable the check
define('MIN_SEARCH_WORD_LENGTH', '4');

// name of this script - remember if you change the name of this file
// change 'read_pms' below to the new name. Also edit 'cpnav_rpm.xml'
// and change '<link>read_pms.php</link>' to reflect this change as well
define('THIS_SCRIPT', 'read_pms');


// ########################################################################
// ################# DO NOT ALTER ANYTHING BELOW HERE #####################
// ########################################################################

// ######################## SET PHP ENVIRONMENT ########################### 
error_reporting(E_ALL & ~E_NOTICE); 

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('NO_CP_COPYRIGHT', 1);
define('HACK_TITLE','\   ');  
define('VERSION', '3.8.007');

// #################### PRE-CACHE TEMPLATES AND DATA ###################### 
// get special phrase groups 
$phrasegroups = array('style'); 

// get special data templates from the datastore 
$specialtemplates = array('products'); 

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/adminfunctions_template.php');

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

// ########################## SUPERADMIN CHECK ############################
if (!in_array($vbulletin->userinfo['userid'], preg_split('#\s*,\s*#s', $vbulletin->config['SpecialUsers']['superadministrators'], -1, PREG_SPLIT_NO_EMPTY)) )
{
	rpm_print_stop_back("
		<center>You don't have permission to access this page.
		<br />You need to be a Super Administrator use this hack.
		<br /><a href = \"http://www.vbulletin.com/docs/html/main/what_is_superadmin\">What is a Super Administrator?</a></center>
	");
}

// ####################### DISPLAY CORRECT HEADER ##########################
switch ($_REQUEST['do'])
{
	case 'list':
		print_cp_header(HACK_TITLE . ' -  A \' ');
		break;

	case 'allusershavepms':
		print_cp_header(HACK_TITLE . ' -     ');
		break;

	case 'search':
		print_cp_header(HACK_TITLE . ' -   ');
		break;

	case 'latest':
		print_cp_header(HACK_TITLE . ' -  ');
		break;

	case 'read':
		print_cp_header(HACK_TITLE . ' -   ');
		break;

	default:
		print_cp_header(HACK_TITLE . '');
}

// ######################### DISPLAY MAIN PAGE ############################
if (empty($_REQUEST['do']))
{
	// display minimum search term length check message?
	if (MIN_SEARCH_WORD_LENGTH != 0)
	{
		$min_search_len =  '<br / >      ' . MIN_SEARCH_WORD_LENGTH .' .';
	}
	
	//    
	print_form_header(THIS_SCRIPT, 'list', 0, 1, 'listForm');
	print_table_header('  ');
	print_input_row('<b>   </b>', 'userid');
	print_submit_row(' ', 0);

	// read single PM
	print_form_header(THIS_SCRIPT, 'read', 0, 1, 'readForm');
	print_table_header('  ');
	print_input_row('<b>  </b><dfn>     </dfn>', 'pmtextid');
	print_submit_row(' ', 0);

	// get all users that PMs
	print_form_header(THIS_SCRIPT, 'allusershavepms', 0, 1, 'allusershavepmsForm');
	print_submit_row('      ', 0);

	// search for PMs using one or more search terms
	print_form_header(THIS_SCRIPT, 'search', 0, 1, 'searchForm');
	print_table_header('  ');
	print_textarea_row('<b> </b><dfn>      ' . $min_search_len . '</dfn>', 'search');
	print_radio_row('<b> </b>', 'match', array( 'exact' => ' ', 'all' => ' ', 'atleastone' => '  ' ), 'exact'); 
	print_submit_row(' ', 0);

	// get latest X PMs
	print_form_header(THIS_SCRIPT, 'latest', 0, 1, 'latestForm');
	print_table_header('  ');
	print_input_row('<b>  </b>', 'showlatest', '100');
	print_submit_row('   ', 0);
}

// ############################# READ PMs #################################
if ($_REQUEST['do'] == 'list')
{
	// if no userid or username entered
	if (empty($_REQUEST['userid']))
	{
		rpm_print_stop_back('       .');
	}
	
	// if it is a username
	if (!is_numeric($_REQUEST['userid']))
	{
		// check the username exists and assign it
		$userid = rpm_username_exists($_REQUEST['userid']);
		
		// if username does not exist
		if (empty($userid))
		{
			rpm_print_stop_back('User <b>' . $_REQUEST['userid'] . '</b> does not exist.' . $userid);
		}
	}
	else // if userid
	{
		// if userid does not exist
		if (!rpm_user_exists($_REQUEST['userid']))
		{
			rpm_print_stop_back('User ID: <b>' . $_REQUEST['userid'] . '</b> does not exist.');
		}
		
		// assign the userid
		$userid = $_REQUEST['userid'];
	}
	
	// get all PMs for the user
	$pms = rpm_get_pms($userid);
	
	// if there are no PMs
	if (empty($pms))
	{
		rpm_print_stop_back('User <b>' . $_REQUEST['userid'] . '</b> has no PMs to display.');
	}
	
	// get the username
	$name = rpm_get_name($userid);
	
	// seperate sent and recieved PMs
	$sent = array();
	$received = array();
	foreach ($pms AS $pm)
	{
		// seperate sent and recieved PMs (also takes into account user sending to self via to or bcc)
		if ($pm['folderid'] == -1)
		{
			$sent[] = $pm;
		}
		else
		{
			$received[] = $pm;
		}
	}
	
	// display list of sent PMs
	print_form_header('', '', 0, 1, 'sentpmlistForm');
	print_table_header(count($sent) . '   ' . $name . ' (  : ' . $userid . ')', 4);
	if (empty($sent))
	{
		print_description_row('<center>There are no sent PMs to view.</center>');
	}
	else
	{
		print_cells_row(array(' ', ' ', ' ', ''), 1);
		foreach ($sent AS $pm)
		{
			$date = vbdate($vbulletin->options['dateformat'], $pm['dateline'], true) . ' ' . vbdate($vbulletin->options['timeformat'], $pm['dateline']);
			$link = THIS_SCRIPT . '.php?do=read&pmtextid=' . $pm['pmtextid'];
			$row = array();
			$row[] = '<div class="smallfont">' . $pm['pmtextid'] . '</div>';
			$row[] = '<div class="smallfont"><span style="float:left">' . $pm['title'] . '</span></div>';
			$row[] = '<div class="smallfont">' . $date . '';
			$row[] = '<div class="smallfont">[<a href="' . $link . '">   </a>]</div>';
			print_cells_row($row);
		}
	}	
	print_table_footer(4, construct_button_code($vbphrase['go_back'], 'javascript:history.back(1)'));
	
	// display list of recieved PMs
	print_form_header('', '', 0, 1, 'receivedpmlistForm');
	print_table_header(count($received) . '   ' . $name . ' (  : ' . $userid . ')', 5);
	if (empty($received))
	{
		print_description_row('<center>   </center>');
	}
	else
	{
		print_cells_row(array(' ', ' ', '', ' ', ''), 1);
		foreach ($received AS $pm)
		{
			$date = vbdate($vbulletin->options['dateformat'], $pm['dateline'], true) . ' ' . vbdate($vbulletin->options['timeformat'], $pm['dateline']);
			$link = THIS_SCRIPT . '.php?do=read&pmtextid=' . $pm['pmtextid'];
			$row = array();
			$row[] = '<div class="smallfont">' . $pm['pmtextid'] . '</div>';
			$row[] = '<div class="smallfont"><span style="float:left">' . $pm['title'] . '</span></div>';
			$row[] = '<div class="smallfont">' . $pm['fromusername'] . '</div>';
			$row[] = '<div class="smallfont">' . $date . '';
			$row[] = '<div class="smallfont">[<a href="' . $link . '">   </a>]</div>';
			print_cells_row($row);
		}
	}
	print_table_footer(5, construct_button_code($vbphrase['go_back'], 'javascript:history.back(1)'));
}

// ####################### LIST ALL USERS WITH PMs ##########################
if ($_REQUEST['do'] == 'allusershavepms')
{
	// get array of PM counts
	$pmcounts = rpm_get_all_pm_users();

	print_form_header('', '', 0, 1, 'allusershavepmsForm');
	print_table_header(' ');

	// assign the counts
	$pmtotals = array();
	while ($currentpmcount = $db->fetch_array($pmcounts))
	{
		$pmtotals["$currentpmcount[total]"]++;
	}
	
	// construct & display the rows
	foreach ($pmtotals AS $pmtotal => $totalusers)
	{
		if ($totalusers != 1)
		{
			$usertext = ' ' . $totalusers .' ';
		}
		else
		{
			$usertext = ' ' . $totalusers .' ';
		}
		$link = THIS_SCRIPT . '.php?do=havepms&totalpms=' . $pmtotal;
		$row = '<span style="float:right">[<a href="' . $link . '">  </a>]</span>';
		$row .= $usertext . '  ' . $pmtotal . ' PMs' ;
		print_description_row($row);
	}
	print_table_footer(2, construct_button_code($vbphrase['go_back'], 'javascript:history.back(1)'));
}

// ####################### LIST USERS WITH X AMOUNT OF PMs ##########################
if ( $_REQUEST['do'] == 'havepms' )
{
	// grab list of users that have PMs
	$havepms = rpm_get_pm_users($_REQUEST['totalpms']);

	// if there are no PMs
	if (!$db->num_rows($havepms))
	{
		rpm_print_stop_back('There are no PMs.');
	}

	// show the list
	print_cp_header(HACK_TITLE . ' - List Users With ' . $_REQUEST['totalpms'] . ' PMs');
	print_form_header('', '', 0, 1, 'havepmsForm');
	print_table_header('List of users with ' . $_REQUEST['totalpms'] . ' PMs');
	while($pms = $db->fetch_array($havepms))
	{
		$link1 = THIS_SCRIPT . '.php?do=list&userid=' . $pms['userid'];
		$link2 = '../private.php?do=newpm&u=' . $pms['userid'];
		$link3 = 'user.php?do=edit&u=' . $pms['userid'];
		$row = '<span style="float:right">[<a href="' . $link1 . '">Show All PMs</a>] ';
		$row .= '[<a href="' . $link2 . '">Send PM to User</a>] ';
		$row .= '[<a href="' . $link3 . '">Edit User</a>]</span>';
		$row .= '<b>' . $pms['username'] . '</b>';
		print_description_row($row);
	}
	print_table_footer(2, construct_button_code($vbphrase['go_back'], 'javascript:history.back(1)'));
}

// ############################### SEARCH #################################
if ($_REQUEST['do'] == 'search')
{
	// if no search terms have been entered
	if (empty($_REQUEST['search']))
	{
		rpm_print_stop_back('                 ');
	}
	
	// assign and make search terms safe
	$search_for = $db->escape_string($_REQUEST['search']);
	
	// display minimum search term length check message?
	if (MIN_SEARCH_WORD_LENGTH != 0)
	{
		// see if any of the search terms is lower than the minimum length 
		$words = explode(" ", $search_for);
		foreach ($words AS $current)
		{
			if (strlen($current) < MIN_SEARCH_WORD_LENGTH)
			{
				rpm_print_stop_back('At least one of your search terms is less than ' . MIN_SEARCH_WORD_LENGTH .' characters long.');
			}
		}
	}
	
	// assign the type of match
	$match = $_REQUEST['match'];
	
	// conduct the search
	$pms = rpm_search_pms($search_for, $match);
	
	// format search words for display purposes
	switch ($match)
	{
		case 'exact':
			$search_words = $search_for;
			$search_wording = 'the exact text';
			break;

		case 'all':
			$search_words = str_replace(" ", " <i>and</i> ", $search_for);
			$search_wording = 'all of the words';
			break;

		case 'atleastone':
			$search_words = str_replace(" ", " <i>or</i> ", $search_for);
			$search_wording = 'at least one of the words';
			break;
	}

	// display list of PMs found
	print_form_header('', '', 0, 1, 'pmlistForm');
	print_table_header('Search Results for ' . $search_wording . ': ' . $search_words . '', 4);
	if (empty($pms))
	{
		print_description_row('<center>       .</center>');
	}
	else
	{
		print_cells_row(array(' ', ' ', ' ', ''), 1);
		foreach ($pms AS $pm)
		{
			$date = vbdate($vbulletin->options['dateformat'], $pm['dateline'], true) . ' ' . vbdate($vbulletin->options['timeformat'], $pm['dateline']);
			$link = THIS_SCRIPT . '.php?do=read&pmtextid=' . $pm['pmtextid'];
			$row = array();
			$row[] = '<div class="smallfont">' . $pm['pmtextid'] . '</div>';
			$row[] = '<div class="smallfont"><span style="float:left">' . $pm['title'] . '</span></div>';
			$row[] = '<div class="smallfont">' . $date . '';
			$row[] = '<div class="smallfont">[<a href="' . $link . '">   </a>]</div>';
			print_cells_row($row);
		}
	}
	print_table_footer(4, construct_button_code($vbphrase['go_back'], 'javascript:history.back(1)'));
}

// ########################### LATEST X PMs ###############################
if ($_REQUEST['do'] == 'latest')
{
	// if nothing entered or zero entered
	if (empty($_REQUEST['showlatest']))
	{
		rpm_print_stop_back('    0.');
	}

	// if non-numeric or negative number entered
	if (!is_numeric($_REQUEST['showlatest']) OR $_REQUEST['showlatest'] < 1)
	{
		rpm_print_stop_back('    0.');
	}
	
	// get the PM list
	$pms = rpm_get_latest_pms($_REQUEST['showlatest']);
	
	// if no PMs
	if (empty($pms))
	{
		rpm_print_stop_back('There are no PMs to view.');
	}
	
	// display PM list
	print_form_header('', '', 0, 1, 'pmlistForm');
	print_table_header('  ' . $_REQUEST['showlatest'] . '  ', 5);
	print_cells_row(array(' ', ' ', '', ' ', ''), 1);
	foreach ($pms AS $pm)
	{
		$date = vbdate($vbulletin->options['dateformat'], $pm['dateline'], true) . ' ' . vbdate($vbulletin->options['timeformat'], $pm['dateline']);
		$link = THIS_SCRIPT . '.php?do=read&pmtextid=' . $pm['pmtextid'];
		$row = array();
		$row[] = '<div class="smallfont">' . $pm['pmtextid'] . '</div>';
		$row[] = '<div class="smallfont"><span style="float:left">' . $pm['title'] . '</span></div>';
		$row[] = '<div class="smallfont">' . $pm['fromusername'] . '</div>';
		$row[] = '<div class="smallfont">' . $date . '';
		$row[] = '<div class="smallfont">[<a href="' . $link . '">   </a>]</div>';
		print_cells_row($row);
	}
	print_table_footer(5, construct_button_code($vbphrase['go_back'], 'javascript:history.back(1)'));
}

// ########################## READ SINGLE PM ##############################
if ($_REQUEST['do'] == 'read')
{
	// no pmtextid
	if (empty($_REQUEST['pmtextid']))
	{
		rpm_print_stop_back('       ');
	}
	
	// if pmtext is not a number or number < 1
	if (!is_numeric($_REQUEST['pmtextid']) OR $_REQUEST['pmtextid'] < 1)
	{
		rpm_print_stop_back('Pmtextid must be a positive number.');
	}
	
	// get the requested PM
	$pm = rpm_get_pm($_REQUEST['pmtextid']);
	
	// PM does not exist
	if (empty($pm))
	{
		rpm_print_stop_back('Pmtextid <b>' . $_REQUEST['pmtextid'] . '</b> does not exist.');
	}
	
	// get all userids for the users that still have the PM with pmtextid
	$userids = $db->query_first("
		SELECT DISTINCT userid
		FROM " . TABLE_PREFIX . "pm
		WHERE `pmtextid` = " . $_REQUEST['pmtextid'] . "
	");
	
	// If there are no userids then the PM does not exist (this handles the last X PMs)
	if (empty($userids))
	{
		rpm_print_stop_back('
			<center>Pmtextid <b>' . $_REQUEST['pmtextid'] . '</b> has been deleted and can not be recovered.
			<br />The non-existant entry will be automatically removed within the hour by the
			<br /><b>Hourly Cleanup #2</b> scheduled task.</center>
		');
	}
	
	// grab array of to and bcc users
	$toarray = array_values(unserialize($pm['touserarray']));

	// convert date to readable format
	$date = vbdate($vbulletin->options['dateformat'], $pm['dateline'], true) . ' ' . vbdate($vbulletin->options['timeformat'], $pm['dateline']);
	
	// show PM contents
	print_form_header('', '', 0, 1, 'pmlistForm');
	print_table_header('    : ' . $pm['pmtextid'],2);
	print_label_row('<b>:</b></b><dfn>        </dfn>', $pm['fromusername'] . ' (<a href = "usertools.php?do=pmfolderstats&u=' . $pm['fromuserid'] . '">  : ' . $pm['fromuserid'] . '</a>)');
	if (is_array($toarray[0]))
	{
		print_label_row('<b> </b><dfn>         </dfn>' , rpm_display_recipients_with_links($toarray[0]));
	}
	if (is_array($toarray[1]))
	{
		print_label_row('<b>BCC:</b></b><dfn>Link(s) goes to users pmstats.</dfn>' , rpm_display_recipients_with_links($toarray[1]));
	}
	print_label_row('<b> </b>', $pm['title']);
	print_label_row('<b> </b>', $date);
	
	// parse message
	require_once(DIR . '/includes/class_bbcode.php');
	initialise_template_system();
	$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
	$message = $bbcode_parser->parse($pm['message'], 'privatemessage', true);
	print_label_row('<b> </b>', '<div class="smallfont">' . $message . '</div>');

	print_table_footer(2, construct_button_code($vbphrase['go_back'], 'javascript:history.back(1)'));
}

rpm_print_footer();
print_cp_footer();

// ########################################################################
// ########################## END MAIN SCRIPT #############################
// ########################################################################

// ########################################################################
// ########################## eg.tiger FUNCTIONS ########################## 
// ########################################################################

// initialise the vBulletin template system in the AdminCP (not done by default)
// very simplified version of the "TEMPLATES & STYLES" section in global.php
function initialise_template_system()
{
	global $vbulletin;
	$styleid = $vbulletin->userinfo['styleid'];
	$styleid = intval($styleid);
	$style = $vbulletin->db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "style
		WHERE styleid = " . $styleid . "
		ORDER BY styleid " . iif($styleid > $vbulletin->options['styleid'], 'DESC', 'ASC') . "
		LIMIT 1
	");

	define('STYLEID', $style['styleid']);

	$globaltemplates = array();

	cache_templates($globaltemplates, $style['templatelist']);
}

// grab the counts of all users that have PMs
function rpm_get_all_pm_users()
{
	global $db;
	$totals = $db->query_read("
		SELECT COUNT(*) AS total
		FROM " . TABLE_PREFIX . "pm
		GROUP BY userid
		ORDER BY total DESC
	");
	return $totals;
}

// grab the users that have PMs with the supplied number of PMs
function rpm_get_pm_users($totalpms)
{
	global $db;
	$pms = $db->query_read("
		SELECT COUNT(*) AS total, pm.userid, user.username
		FROM " . TABLE_PREFIX . "pm AS pm
		INNER JOIN " . TABLE_PREFIX . "user AS user ON (pm.userid = user.userid)
		GROUP BY pm.userid
		HAVING total = " . $totalpms . "
		ORDER BY user.username DESC
	");
	return $pms;
}

// grab the userid from the username
function rpm_get_userid($username)
{
	global $db;
	$result = $db->query_first("
		SELECT userid
		FROM " . TABLE_PREFIX . "user
		WHERE LOWER(username) = LOWER('" . $db->escape_string($username) . "')
	");
	return $result['userid'];
}

// construct list of receipients with links
function rpm_display_recipients_with_links($array)
{
	// go through array of users and construct list of receipients
	foreach ($array as $value)
	{
		$username = rpm_get_userid(htmlspecialchars_uni($value));
		$display .= htmlspecialchars_uni($value);
		$display .= ' (<a href = "usertools.php?do=pmfolderstats&u=' . $username . '">  : ';
		$display .= $username;
		$display .= '</a>)';
		if (sizeof($array) > 1)
		{
			$display .= ',<br />';
		}
	}
	
	// remove the last ",<br />"	
	if (sizeof($array) > 1)
	{
		$display = substr($display, 0, -7);
	}
	
	// return the list of receipients
	return $display;
}

// ########################################################################
// ##### DREAM'S FUNCTIONS - I have altered a lot of these functions ###### 
// ########################################################################

// function "rpm_get_users_that_have_pms" has been removed from this version
// of the hack, as it is no longer needed, it is still in Dream's version

// get list of userids from a usertextid
function rpm_get_userids($pmtextid)
{
	global $db;
	$result = $db->query_read("
		SELECT userid 
		FROM " . TABLE_PREFIX . "pm
		WHERE pmtextid = " . $pmtextid . "
	");
	
	$userids = array();
	while($array = $db->fetch_array($result))
	{
		$userids[] = $array['userid'];
	}
	return $userids;
}

// search for PMs that match key search terms
// i have changed the queries from Dream's version of this hack
function rpm_search_pms($search_for, $match)
{
	global $db;
	if ($match == 'exact')
	{
		$sql = "SELECT DISTINCT pmtextid, title, dateline
			FROM " . TABLE_PREFIX . "pmtext 
			WHERE message LIKE '%" . $search_for . "%'
			ORDER BY dateline DESC";
	}
	elseif ($match == 'all')
	{
		$search = explode(' ', $search_for);
		$andmessage = implode("%' AND message LIKE '%", $search);
		$sql = "SELECT DISTINCT pmtextid, title, dateline 
			FROM " . TABLE_PREFIX . "pmtext
			WHERE message LIKE '%" . $andmessage . "%'
			ORDER BY dateline DESC";
	}
	else
	{
		$search = explode(' ', $search_for);
		$ormessage = implode("%' OR message LIKE '%", $search);
		$sql = "SELECT DISTINCT pmtextid, title, dateline 
			FROM " . TABLE_PREFIX . "pmtext
			WHERE message LIKE '%" . $ormessage . "%' 
			ORDER BY dateline DESC";
	}
	
	$result = $db->query_read($sql);
	$pms = array();
	while($array = $db->fetch_array($result))
	{
		$pms[] = $array;
	}
	return $pms;
}

// get a username from a userid
function rpm_get_name($userid)
{
	global $db;
	$result = $db->query_first("
		SELECT username
		FROM " . TABLE_PREFIX . "user
		WHERE userid = " . $userid . "
	");
	return $result['username'];
}

// get a PM from a pmtextid
// i have changed the queries from Dream's version of this hack
function rpm_get_pm($pmtextid)
{
	global $db;
	$get_pm = $db->query_first("
		SELECT pmtextid, fromuserid, fromusername, title, message, touserarray, dateline
		FROM " . TABLE_PREFIX . "pmtext
		WHERE pmtextid = " . $pmtextid . "
	");
	return $get_pm;
}

// check a user exists from the supplied userid
function rpm_user_exists($userid)
{
	global $db;
	$exists = $db->query_first("
		SELECT userid
		FROM " . TABLE_PREFIX . "user
		WHERE userid = " . $userid . "
	");
	if ($exists)
	{
		return true;
	}
	else
	{
		return false;
	}
}

// check a user exists from the supplied username
function rpm_username_exists($username)
{
	global $db;
	$exists = $db->query_first("
		SELECT userid
		FROM " . TABLE_PREFIX . "user
		WHERE LOWER(username) = LOWER('" . $db->escape_string($username) . "')
	");
	if ($exists)
	{
		return $exists['userid'];
	}
	else
	{
		return false;
	}
}

// get PMs for the supplied userid
// i have changed the queries from Dream's version of this hack
function rpm_get_pms($userid)
{
	global $db;
	$pmtextids = rpm_get_pmtextids($userid);
	if (empty($pmtextids))
	{
		return false;
	}
	else
	{
		$orpmtexid = implode(' OR pmtext.pmtextid = ', $pmtextids);
		$result = $db->query_read("
			SELECT 	pm.userid, pm.folderid, pmtext.pmtextid, pmtext.fromusername, pmtext.title, pmtext.dateline
			FROM " . TABLE_PREFIX . "pm AS pm
			INNER JOIN " . TABLE_PREFIX . "pmtext AS pmtext ON(pmtext.pmtextid = pm.pmtextid)
			WHERE pmtext.pmtextid = " . $orpmtexid . " 
			HAVING pm.userid = " . $userid . "
			ORDER BY pmtext.dateline DESC
		");
		$pms = array();
		while($array = $db->fetch_array($result))
		{
			$pms[] = $array;
		}
		return $pms;
	}
}

// get latest PMs, limited by supplied $limit_by
// i have changed the queries from Dream's version of this hack
function rpm_get_latest_pms($limit_by)
{
	global $db;
	$result = $db->query_read("
		SELECT pmtextid, fromusername, title, dateline
		FROM " . TABLE_PREFIX . "pmtext
		ORDER BY dateline DESC
		LIMIT 0, " . $limit_by . "
	");
	$pms = array();
	while($array = $db->fetch_array($result))
	{
		$pms[] = $array;
	}
	return $pms;
}

// get pmtextids from supplied userid
function rpm_get_pmtextids($userid)
{
	global $db;
	$result = $db->query_read("
		SELECT pmtextid
		FROM " . TABLE_PREFIX . "pm
		WHERE userid = " . $userid . "
	");
	$pmtextids = array();
	while($array = $db->fetch_array($result))
	{
		$pmtextids[] = $array['pmtextid'];
	}
	return $pmtextids;
}

// print supplied message
function rpm_print_stop_back($text = 'error')
{
	global $vbphrase;
	if (!defined('DONE_CPHEADER'))
	{
		print_cp_header($vbphrase['vbulletin_message']);
	}
	echo '<p>&nbsp;</p><p>&nbsp;</p>';
	print_form_header('', '', 0, 1, 'messageform', '65%');
	print_table_header($vbphrase['vbulletin_message']);
	print_description_row("<blockquote><br />$text<br /><br /></blockquote>");
	print_table_footer(2, construct_button_code($vbphrase['go_back'], 'javascript:history.back(1)'));
	rpm_print_footer();
	print_cp_footer();
}

// print footer branding
function rpm_print_footer()
{
	echo '<p align="center"><a href="http://www.gre7.com" target="_blank" class="copyright">' . HACK_TITLE . ' v'. VERSION . ', </a><a href="http://www.gre7.com" target="_blank" class="copyright">Copyright &copy;2009 eg.tiger</a></p>';
}

/*============================================================================*\
|| ########################################################################## ||
|| # Copyright &copy;2009 eg.tiger        (Original  2005 Dream)           # ||
|| ########################################################################## ||
\*============================================================================*/
?>