<?php if (!defined('VB_ENTRY')) die('Access denied.');
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 4.0.0 Alpha 5
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2000-2009 Jelsoft Enterprises Ltd. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

/**
 * CMS Content Route
 * Routing for displaying and managing CMS pages, nodes and content.
 *
 * @author vBulletin Development Team
 * @version $Revision: 31942 $
 * @since $Date: 2009-09-01 15:09:16 -0500 (Tue, 01 Sep 2009) $
 * @copyright Jelsoft Enterprises Ltd.
 */
class vBCms_Route_List extends vB_Route
{
	/*Properties====================================================================*/

	/**
	 * The segment scheme
	 *
	 * @see vB_Route::$_segment_scheme
	 *
	 * @var array mixed
	 */
	protected $_segment_scheme = array(
		'action'		=> array (
			'optional' 	=> true,
			'values'	=> array('list'),
			'default'	=>	'list'),
		'type'		=>	array (
					'default'	=>	'section'
		),
		'value'		=>	array (
				'default'	=>	'1'
		),
		'page'		=>	array (
					'default'	=>	'1'
			)
		);

	/**
	 * Action map.
	*/

	protected $params = array();

	/*Initialization================================================================*/

	/**
	 * The constructor.
	 *
	 * A base URL is required to prepend to compiled URL.  If a route path is not
	 * specified then the default route path is assumed.
	 *
	 * @param string $route_path				- The route path to compile
	 */
	public function __construct($route_path = false)
	{
		if (vB::$vbulletin->options['default_page'])
		{
			$this->_default_path = vB::$vbulletin->options['default_page'];
		}

		// Allow dynamic segment schemes
//		$this->buildSegmentScheme();

		$this->_segment_scheme['node'] = array (
			'optional' 	=> true,
			'values'	=> array('0', '1'),
			'default'	=>	0);
		// Set the route path
		$this->current_route = explode('/', $route_path);
		$this->node = '0';
	}


	/**
	 * Sets the value of a segment.
	 * We want to bypass the standard error checking, which is too restrictive
	 *
	 * @param string $segment					- The name of the segment
	 * @param mixed $value						- The value to set it to
	 */
	public function __set($segment, $value)
	{
		$this->params[$segment] = $value;
	}

	public function __get($segment)
	{
		// Check the segment is defined
		if (!isset($this->params[$segment]))
		{
			throw (new vB_Exception_Router('A route segment value was requested but the segment is undefined: \'' . $segment . '\''));
		}

		// Ensure the route is valid
		if (!$this->isValid())
		{
			throw (new vB_Exception_Router('A route segment value was requested but the route is invalid'));
		}

		return $this->params[$segment];
	}
	/*Response======================================================================*/

	/**
	 * Returns the response for the route.
	 *
	 * @return string							- The response
	 */
	public function getResponse()
	{
		$controller = new vbCms_Controller_List($this->current_route);
		return $controller->actionList();
	}

	/*URL===========================================================================*/

	/**
	 * Returns a representative URL of a route.
	 * Optional segments and parameters may be passed to set the route state.
	 *
	 * @param array mixed $segments				- Assoc array of segment => value
	 * @param array mixed $parameters			- Array of parameter values, in order
	 * @return string							- The URL representing the route
	 */
	public static function getURL(array $segments = null, array $parameters = null)
	{
		$route = new vBCms_Route_Content();
		return $route->getCurrentURL($segments, $parameters);
	}

	/*Segments======================================================================*/

	/**
	 * Builds dynamic segment schemes.
	 */
	protected function buildSegmentScheme()
	{
		$actions = vB_Router::getRouteActions(get_class($this));

		$this->_segment_scheme['node']['default'] = vB::$vbulletin->options['default_page'];
		$this->_segment_scheme['action']['values'] = $actions;
	}

	public function __toString()
	{
		// Ensure the route path is fresh
		return implode('/', $this->params);
	}
}

/*======================================================================*\
|| ####################################################################

|| # SVN: $Revision: 31942 $
|| ####################################################################
\*======================================================================*/