<?php if (!defined('VB_ENTRY')) die('Access denied.');

/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 4.0.0 Alpha 5
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2009 Jelsoft Enterprises Ltd. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

/**
 * @package vBulletin
 * @subpackage Search
 * @author Ed Brown, vBulletin Development Team
 * @version $Id: article.php 30550 2009-04-28 23:55:20Z ebrown $
 * @since $Date: 2009-04-28 16:55:20 -0700 (Tue, 28 Apr 2009) $
 * @copyright Jelsoft Enterprises Ltd.
 */

require_once (DIR . '/vb/search/result.php');
include_once DIR . '/packages/vbcms/item/content/article.php';
require_once (DIR . '/vb/search/indexcontroller/null.php');
/**
 * Result Implementation for CMS Article
 *
 * @see vB_Search_Result
 * @package vBulletin
 * @subpackage Search
 */
class vBCms_Search_Result_Article extends vB_Search_Result
{


	/**
	 * factory method to create a result object
	 *
	 * @param integer $id
	 * @return result object
	 */
	public static function create($id)
	{
		$contenttypeid = vb_Types::instance()->getContentTypeId('vBCms_Article');

		if ($rst = vB::$vbulletin->db->query_read("SELECT a.contentid as itemid,
		u.username, a.contentid, n.nodeid, u.userid, i.html_title, a.blogid, n.setpublish AS published,
		a.pagetext, i.title, i.description, n.publishdate, parent.title as parenttitle, i.viewcount,
		n.parentnode as parentid, a.threadid, a.postauthor, a.poststarter, a.blogpostid,
		a.postid, a.post_started, a.post_posted, thread.threadid AS comment_threadid , thread.title AS threadtitle, thread.replycount,
		thread.lastposterid, thread.lastposter, thread.dateline, thread.views, thread.lastpost
		FROM " . TABLE_PREFIX . "cms_article AS a
		LEFT JOIN " . TABLE_PREFIX . "cms_node AS n ON n.contentid = a.contentid
  		LEFT JOIN " . TABLE_PREFIX . "cms_nodeinfo AS i ON i.nodeid = n.nodeid
  		LEFT JOIN " . TABLE_PREFIX . "cms_nodeinfo AS parent ON parent.nodeid = n.parentnode
  		LEFT JOIN " . TABLE_PREFIX . "thread AS thread ON thread.threadid = i.associatedthreadid
  		LEFT JOIN " . TABLE_PREFIX . "user AS u ON u.userid = n.userid
		WHERE a.contentid = $id AND n.contenttypeid = " . $contenttypeid))
		{
			if ($search_result = vB::$vbulletin->db->fetch_array($rst))
			{
				//If unpublished we hide this.
				if (!($search_result['publishdate'] < TIMENOW))
				{
					continue;
				}
				$item = new vBCms_Search_Result_Article();
				$item->itemid = $search_result['itemid'];
				$item->contenttypeid = $contenttypeid;
				if ($rst1 = vB::$vbulletin->db->query_read("SELECT cat.categoryid, cat.category FROM " .
					TABLE_PREFIX . "cms_nodecategory nc INNER JOIN " .	TABLE_PREFIX .
					"cms_category cat ON nc.categoryid = cat.categoryid WHERE nc.nodeid = " .
					$search_result['nodeid']))
				{
					while($record = vB::$vbulletin->db->fetch_array($rst1))
					{
						$categories[$record['categoryid']] = $record;
					}
				}
				$search_result['categories'] = $categories;
				$item->record = $search_result;
				return $item;
			}
			return false;
		}
	}

	/**
	 * this will create an array of result objects from an array of ids()
	 *
	 * @param array of integer $ids
	 * @return array of objects
	 */
	public static function create_array($ids)
	{
		$contenttypeid = vb_Types::instance()->getContentTypeId('vBCms_Article');

		if ($rst = vB::$vbulletin->db->query_read("SELECT a.contentid as itemid,
		u.username, a.contentid, n.nodeid, u.userid, i.html_title, a.blogid, n.setpublish AS published,
		a.pagetext, i.title, i.description, n.publishdate, parent.title as parenttitle, i.viewcount,
		n.parentnode as parentid, a.threadid, a.postauthor, a.poststarter, a.blogpostid,
		a.postid, a.post_started, a.post_posted, thread.threadid AS comment_threadid , thread.title AS threadtitle, thread.replycount,
		thread.lastposterid, thread.lastposter, thread.dateline, thread.views, thread.lastpost
		FROM " . TABLE_PREFIX . "cms_article a
		LEFT JOIN " . TABLE_PREFIX . "cms_node n ON n.contentid = a.contentid
  		LEFT JOIN " . TABLE_PREFIX . "cms_nodeinfo i ON i.nodeid = n.nodeid
  		LEFT JOIN " . TABLE_PREFIX . "cms_nodeinfo AS parent ON parent.nodeid = n.parentnode
  		LEFT JOIN " . TABLE_PREFIX . "thread AS thread ON thread.threadid = i.associatedthreadid
  		LEFT JOIN " . TABLE_PREFIX . "user u ON u.userid = n.userid
		WHERE a.contentid IN (" . implode(', ', $ids) .
			") AND n.contenttypeid = " . $contenttypeid))
		{
			while ($search_result = vB::$vbulletin->db->fetch_array($rst))
			{

				//If unpublished we hide this.
				if (!($search_result['publishdate'] < TIMENOW))
				{
					continue;
				}
				$item = new vBCms_Search_Result_Article();
				$item->itemid = $search_result['itemid'];
				$item->contenttypeid = $contenttypeid;
				if ($rst1 = vB::$vbulletin->db->query_read("SELECT cat.categoryid, cat.category FROM " .
					TABLE_PREFIX . "cms_nodecategory nc INNER JOIN " .	TABLE_PREFIX .
					"cms_category cat ON nc.categoryid = cat.categoryid WHERE nc.nodeid = " .
					$search_result['nodeid']))
				{
					while($record = vB::$vbulletin->db->fetch_array($rst1))
					{
						$categories[$record['categoryid']] = $record;
					}
				}
				$search_result['categories'] = $categories;
				$item->record = $search_result;
				$items[$search_result['itemid']] = $item;
			}
			return $items;
		}
		return false;
	}

	/**
	 * protected constructor, to ensure use of create()
	 *
	 */
	protected function __construct()
	{}

	/**
	 * all result objects must tell their contenttypeid
	 *
	 * @return integer contenttypeid
	 */
	public function get_contenttype()
	{

		return isset($this->contenttypeid) ?
			$this->contenttypeid :
			vB_Types::instance()->getContentTypeID("vBCms_Article");
	}

	/**
	 * all result objects must tell whether they are searchable
	 *
	 * @param mixed $user: the id of the user requesting access
	 * @return bool true
	 */
	public function can_search($user)
	{
	//By definition, an article is always searchable, even
	// for a guest.
		return true;
	}

	public function get_record()
	{
		return $this->record;
	}

	/**
	 * function to return the rendered html for this result
	 *
	 * @param string $current_user
	 * @param object $criteria
	 * @return
	 */
	public function render($current_user, $criteria, $template_name = '')
	{
		global $vbulletin;
		global $show;
		include_once DIR . '/vb/search/searchtools.php';

		if (!strlen($template_name))
		{
			$template_name = 'vbcms_searchresult_article';
		}
		$template = vB_Template::create($template_name);

		$template->register('title', $this->record['title'] );
		$template->register('html_title', $this->record['html_title'] );
		$template->register('page_url',  $vbulletin->options['bburl']
			. '/content.php?content/'. $this->record['nodeid']);
		$template->register('username', $this->record['username']);
		$template->register('description', $this->record['description']);
		$template->register('parenttitle' , $this->record['parenttitle'] );
		$template->register('parentid' , $this->record['parentid'] );
		$template->register('threadid' , $this->record['threadid'] );
		$template->register('postauthor' , $this->record['postauthor'] );
		$template->register('poststarter' , $this->record['poststarter'] );
		$template->register('blogpostid' , $this->record['blogpostid'] );
		$template->register('parentnode' , $this->record['parentnode'] );
		$template->register('postid' , $this->record['postid'] );
		$template->register('post_started' , $this->record['post_started'] );
		$template->register('post_posted' , $this->record['post_posted'] );
		$template->register('pagetext',
			vB_Search_Searchtools::getSummary($this->record['pagetext'], 100));
		$template->register('publish_phrase', ($this->record['publishdate'] ?
			$vbphrase['page_published'] : $vbphrase['page_unpublished']) );
		$template->register('author_phrase', 'author');
		$template->register('published', ($this->record['publishdate'] ?
			true : false));
		$template->register('categories', $this->record['categories']);
		$template->register('article', $this->record);
		$template->register('dateline', date($vbulletin->options['dateformat']. ' '
			. $vbulletin->options['default_timeformat'], $this->record['publishdate']));
		$template->register('dateformat', $vbulletin->options['dateformat']);
		$template->register('timeformat', $vbulletin->options['default_timeformat']);
		$result = $template->render();
		return $result;
	}

	private $itemid;
	private $record;

}

/*======================================================================*\
|| ####################################################################

|| # SVN: $Revision: 30550 $
|| ####################################################################
\*======================================================================*/
