<?php if (!defined('VB_ENTRY')) die('Access denied.');
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 4.0.0 Alpha 5
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2009 Jelsoft Enterprises Ltd. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

/**
 * CMS Article View
 * Default view for rendering an article.
 *
 * @package vBulletin
 * @author vBulletin Development Team
 * @version $Revision: $
 * @since $Date: $
 * @copyright Jelsoft Enterprises Ltd.
 */
class vBCms_View_Article extends vB_View_Content
{
	/**
	 * Result id's of inner views for prenotification.
	 *
	 * @var array mixed
	 */
	protected $_cache_results = array('vbcms_article_css');



	/*Render========================================================================*/

	/**
	 * Prepares properties for rendering.
	 */
	protected function prepareProperties()
	{
		parent::prepareProperties();

		$this->title = htmlspecialchars_uni($this->title);
		$this->css = new vB_View('vbcms_article_css');
		$this->author_phrase = new vB_Phrase('vbcms', 'author');

		if ($this->pagelist AND sizeof($this->pagelist) > 1)
		{
			// create a route
			$route = new vBCms_Route_Content();
			$route->setSegments(array('node' => $this->node, 'action' => vB_Router::getUserAction('vBCms_Controller_Content', 'View')));

			$pagelist = $this->pagelist;
			$pagelist[1] = $this->title;
			$this->pagelist = $pagelist;

			$pages = array();
			foreach ($this->pagelist AS $pagenum => $title)
			{
				$route->setParameter(0, $pagenum);
				$title = $title ? $title : new vB_Phrase('vbcms', 'page_x', $pagenum);
				$pages[$pagenum] = array('url' => $route->getCurrentURL(null, array($pagenum)),
								'title' => htmlspecialchars_uni($title),
								'selected' => ($pagenum == $this->current_page) ? 1 : 0);
			}

			if ($this->current_page > 1)
			{
				$this->prev_page_url = $pages[$this->current_page - 1]['url'];
				$this->prev_page_phrase = new vB_Phrase('vbcms', 'previous');
			}

			if ($this->current_page < sizeof($pages))
			{
				$this->next_page_url = $pages[$this->current_page + 1]['url'];
				$this->next_page_phrase = new vB_Phrase('vbcms', 'next');
			}

			$this->pagelist = $pages;
		}
		else
		{
			$this->pagelist = false;
		}
	}
}

/*======================================================================*\
|| ####################################################################

|| # SVN: $Revision: 28709 $
|| ####################################################################
\*======================================================================*/