<?php if (!defined('VB_ENTRY')) die('Access denied.');
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 4.0.0 Alpha 5
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2000-2009 Jelsoft Enterprises Ltd. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

/**
 * vBCms Navbar
 * Builds the vBCms links for display in the navbar.
 *
 * @package vBulletin
 * @author vBulletin Development Team
 * @version $Revision: 31871 $
 * @since $Date: 2009-08-25 16:54:54 +0100 (Tue, 25 Aug 2009) $
 * @copyright Jelsoft Enterprises Ltd.
 */
class vBCms_NavBar
{
	/*Properties====================================================================*/

	/**
	 * The navbar link view
	 *
	 * @var vB_View
	 */
	public static $view;
	private static $cache_ttl = 10;
	
	/**
	 * A prefix for all cache references.
	 * 
	 * @var string
	 */
	public static $cache_prefix = 'vbcms_nav_';


	/*View==========================================================================*/

	/**
	 * Prepares the navbar view so that it can be fetched and rendered.
	 * Note: Forcing the cache to be ignored is useful if the subnav has just been 
	 * updated. 
	 *
	 * @param vBCms_Item_Content $node			- The current node
	 * @param bool $refresh						- Forces the cache to be ignored and the view to be rebuilt.
	 */
	public static function prepareNavBar($node, $refresh = false)
	{
		if ($refresh OR (isset($_REQUEST['nocache'])) OR !$links = vB_Cache::instance()->read($cache_key = self::getHash($node), true))
		{
			if (!sizeof($nodes = $node->getNavigationNodes()))
			{
				return;
			}

			$nodes = new vBCms_Collection_Content($nodes, vBCms_Item_Content::INFO_NODE);

			$route = new vBCms_Route_Content();

			$links = array();
			foreach ($nodes AS $node)
			{
				$route->node = $node->getUrlSegment();

				$links[$node->getNodeId()] = array(
					'title' => $node->getTitle(),
					'url' => $route->getCurrentUrl()
				);
			}
			
			vB_Cache::instance()->write($cache_key,
				$links, self::$cache_ttl, array(self::getCacheEventId($node->getNodeId())));

		}

		if (!self::$view OR $refresh)
		{
			self::$view = new vB_View('vbcms_navbar_link');
			self::$view->links = $links;
		}
	}


	/**
	 * Fetches the prepared nabar view.
	 *
	 * @return vB_View							- The navbar link view
	 */
	public static function renderView()
	{
		if (self::$view)
		{
			vB::$vbulletin->options['selectednavtab'] = 'vbcms';
			return self::$view->render();
		}
		else
		{
			return false;
		}
	}

	/********* Get a hash so we can cache the data
	 *
	 ********/
	protected static function getHash($node)
	{

		$context = new vB_Context(self::$cache_prefix, array($node->getSectionId(), vB::$vbulletin->userinfo['usergroupid'], vB::$vbulletin->userinfo['membergroupids']));
		return strval($context);

	}
	
	
	/**
	 * Fetches a consistent event id for a given node's navbar.
	 * 
	 * @param int $nodeid						- The nodeid being cached.
	 * @return string
	 */
	public static function getCacheEventId($nodeid)
	{
		return self::$cache_prefix . $nodeid;
	}
}


/*======================================================================*\
|| ####################################################################

|| # SVN: $Revision: 31871 $
|| ####################################################################
\*======================================================================*/