<?php if (!defined('VB_ENTRY')) die('Access denied.');

/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 4.0.0 Alpha 5
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2009 Jelsoft Enterprises Ltd. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/


require_once (DIR . '/vb/search/type.php');

/**
 * vBCms_Search_Type_Article
 *
 * @package
 * @author Ed Brown
 * @copyright Copyright (c) 2009
 * @version $Id: article.php 30550 2009-04-28 23:55:20Z ebrown $
 * @access public
 */
class vBCms_Search_Type_Article extends vB_Search_Type
{
	/**
	 * determine which records are viewable by this user.
	 *
	 * @param mixed $user : current user object
	 * @param array $ids : array of article contentids
	 * @param mixed $gids : not applicable here- group id's for those types which are groupable
	 * @return array of (viewable id's, rejected groups)
	 */
	public function fetch_validated_list($user, $ids, $gids)
	{

		$list = array();
		//anyone can see anything that is published
		$articles = vBCms_Search_Result_Article::create_array($ids);

		return array('list' => $articles, 'groups_rejected' => array());
	}

	/**
	 * set parameters before rendering
	 *
	 * @param object $user
	 * @param object $results
	 * @return
	 */
	public function prepare_render($user, $results)
	{
		$phrase = new vB_Legacy_Phrase();
		$phrase->add_phrase_groups(array('user', 'search'));

		foreach ($results AS $result)
		{
			$privs = array();
			//if we have a right for any item in the result set we have that right

			foreach ($privs AS $key => $priv)
			{
				$this->mod_rights[$key] = ($this->mod_rights[$key] OR (bool) $priv);
			}
		}
	}

	/**
	 * set any additional header text. We don't have any
	 *
	 * @return string
	 */
	public function additional_header_text()
	{
		return '';
	}

	/**
	 * get the display name for this type
	 *
	 * @return string
	 */
	public function get_display_name()
	{
		return vB_Types::instance()->getContentTypeTitle($this->get_contenttypeid());
	}

	/**
	 * This function composes the html to display the user interface for this
	 * search type
	 *
	 * @param mixed $prefs : the array of user preferences
	 * @param mixed $contenttypeid : the content type for which we are going to
	 *    search
	 * @param array registers : any additional elements to be registered. These are
	 * 	just passed to the template
	 * @param string $template_name : name of the template to use for display. We have
	 *		a default template.
	 * @param boolean $groupable : a flag to tell whether the interface should display
	 * 	grouping option(s).
	 * @return $html: complete html for the search elements
	 */
	public function listUi($prefs = null, $contenttypeid = null, $registers = null,
		$template_name = null)
	{
		global $vbulletin, $vbphrase;


		if (! isset($template_name))
		{
			$template_name = 'search_input_default';
		}

		if (! isset($contenttypeid))
		{
			$contenttypeid = vB_Types::instance()->getContentTypeID('vBCms_Article');
		}

		$template = vB_Template::create($template_name);
		$template->register('securitytoken', $vbulletin->userinfo['securitytoken']);
		$template->register('class', $this->get_display_name());
		$template->register('contenttypeid',$contenttypeid);

		$prefsettings = array(
			'select'=> array('searchdate', 'beforeafter', 'titleonly', 'sortby', 'sortorder'),
			'cb' => array('nocache', 'exactname'),
		 	'value' => array('query', 'searchuser'));
		$this->setPrefs($template, $prefs, $prefsettings);
		vB_Search_Searchtools::searchIntroRegisterHumanVerify($template);

		if (isset($registers) AND is_array($registers) )
		{
			foreach($registers as $key => $value)
			{
				$template->register($key, htmlspecialchars_uni($value));
			}
		}
		return $template->render();
	}

	/**
	 * method to create this object
	 *
	 * @param integer $id
	 * @return object
	 */
	public function create_item($id)
	{
		return vBCms_Search_Result_Article::create($id);
	}

	/**
	 * can this type be grouped?
	 *
	 * @return boolean
	 */
	public function can_group()
	{
		return false;
	}

	// ###################### Start group_by_default ######################
	/**
	 * is this type grouped by default?
	 *
	 * @return boolean
	 */
	public function group_by_default()
	{
		return false;
	}

	/**
	 * can this type be searched?
	 *
	 * @return boolean
	 */
	public function cansearch()
	{
		return true;
	}

	/**
	 * return any inline moderation options
	 *
	 * @return options array
	 *
	 * In general this doesn't get moderated.
	 */
	public function get_inlinemod_options()
	{
		global $vbphrase, $show;

		return array();
	}


	/**
	 * what type of inline moderation is available?
	 *
	 * @return
	 */
	public function get_inlinemod_type()
	{
		return '';
	}

	/**
	 * what inline moderation actions are available?
	 *
	 * @return
	 */
	public function get_inlinemod_action()
	{
		return '';
	}

/**
 * Each search type has some responsibilities, one of which is to tell
 * what are its defaults
 *
 * @return array
 */
	public function additional_pref_defaults()
	{
		return array(
			'query'         => '',
			'exactname'     => 0,
			'searchuser'     => '',
			'nocache'    => 0,
			'searchdate'    => 0,
			'titleonly'    => 0,
			'beforeafter'   => 'after',
			'sortby'   => 'title',
			'sortorder'   => 'descending');
	}

	protected $package = "vBCms";
	protected $class = "Article";
	protected $group_package = "vBCms";
	protected $group_class = "Article";
}

/*======================================================================*\
|| ####################################################################

|| # SVN: $Revision: 30550 $
|| ####################################################################
\*======================================================================*/