<?php if (!defined('VB_ENTRY')) die('Access denied.');
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 4.0.0 Alpha 5
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2009 Jelsoft Enterprises Ltd. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

/**
 * Test Widget Controller
 *
 * @package vBulletin
 * @author vBulletin Development Team
 * @version $Revision: 32078 $
 * @since $Date: 2009-09-16 15:39:09 -0500 (Wed, 16 Sep 2009) $
 * @copyright Jelsoft Enterprises Ltd.
 */
class vBCms_Widget_Rss extends vBCms_Widget
{
	/*Properties====================================================================*/

	/**
	 * A package identifier.
	 * This is used to resolve any related class names.
	 * It is also used by client code to resolve the class name of this widget.
	 *
	 * @var string
	 */
	protected $package = 'vBCms';

	/**
	 * A class identifier.
	 * This is used to resolve any related class names.
	 * It is also used by client code to resolve the class name of this widget.
	 *
	 * @var string
	 */
	protected $class = 'Rss';

	protected $cache_ttl = 5;


	/*Render========================================================================*/

	/**
	 * Returns the config view for the widget.
	 *
	 * @return vBCms_View_Widget				- The view result
	 */
	public function getConfigView()
	{
		$this->assertWidget();

		vB::$vbulletin->input->clean_array_gpc('r', array(
			'do'      => vB_Input::TYPE_STR,
			'url'    => vB_Input::TYPE_STR,
			'template_name'    => vB_Input::TYPE_STR
		));

		$view = new vB_View_AJAXHTML('cms_widget_config');
		$view->title = new vB_Phrase('vbcms', 'configuring_widget_x', $this->widget->getTitle());
		$config = $this->widget->getConfig();

		if ((vB::$vbulletin->GPC['do'] == 'config') AND $this->verifyPostId())
		{
			$config['url'] = str_replace('%u0025', '%' , vB::$vbulletin->GPC['url']);

			if (vB::$vbulletin->GPC_exists['template_name'])
			{
				$config['template_name'] = vB::$vbulletin->GPC['template_name'];
			}

			$widgetdm = $this->widget->getDM();

			$widgetdm->set('config', $config);

			if ($this->content)
			{
				$widgetdm->setConfigNode($this->content->getNodeId());
			}

			$widgetdm->save();

			if (!$widgetdm->hasErrors())
			{
				if ($this->content)
				{
					$segments = array('node' => $this->content->getNodeURLSegment(),
										'action' => vB_Router::getUserAction('vBCms_Controller_Content', 'EditPage'));
					$view->setUrl(vB_View_AJAXHTML::URL_FINISHED, vBCms_Route_Content::getURL($segments));
				}

				$view->setStatus(vB_View_AJAXHTML::STATUS_FINISHED, new vB_Phrase('vbcms', 'configuration_saved'));
			}
			else
			{
				if (vB::$vbulletin->debug)
				{
					$view->addErrors($widgetdm->getErrors());
				}

				// only send a message
				$view->setStatus(vB_View_AJAXHTML::STATUS_MESSAGE, new vB_Phrase('vbcms', 'configuration_failed'));
			}
		}
		else
		{
			// add the config content
			$configview = $this->createView('config');

			if (!isset($config['template_name']) OR ($config['template_name'] == '') )
			{
				$config['template_name'] = 'vbcms_widget_rss_page';
			}
			// add the config content
			$configview->template_name = $config['template_name'];
			$configview->url = $config['url'] ? htmlspecialchars_uni($config['url']) : $config['url'];

			// item id to ensure form is submitted to us
			$this->addPostId($configview);

			$view->setContent($configview);

			// send the view
			$view->setStatus(vB_View_AJAXHTML::STATUS_VIEW, new vB_Phrase('vbcms', 'configuring_widget'));
		}

		return $view;
	}


	/**
	 * Fetches the standard page view for a widget.
	 *
	 * @return vBCms_View_Widget				- The resolved view, or array of views
	 */
	public function getPageView()
	{
		global $vbphrase, $vbulletin;

		$this->assertWidget();

		require_once DIR . '/includes/class_rss_poster.php';
		$rss = new vB_RSS_Poster($vbulletin);

		// Create view
		$config = $this->widget->getConfig();
		if (!isset($config['template_name']) OR ($config['template_name'] == '') )
		{
			$config['template_name'] = 'vbcms_widget_rss_page';
		}

		// Create view
		$view = new vBCms_View_Widget($config['template_name']);
		$view->class = $this->widget->getClass();
		$view->title = $this->widget->getTitle();
		$view->description = $this->widget->getDescription();

		if (isset($_REQUEST['nocache']) OR !isset($_REQUEST['nocache']) AND !($view->detail = vB_Cache::instance()->read($this->getHash($this->widget->getId()), true)))
		{

			if ($rss->fetch_xml($config['url']) AND  $rss->parse_xml())
			{
				$view->rsstitle = $rss->xml_array['channel']['title'];
				$view->rssdescription = $rss->xml_array['channel']['description'];
				$view->rsslink = $rss->xml_array['channel']['link'];

				$details = array();

				if (count($rss->xml_array['channel']['item']))
				{
					foreach ($rss->xml_array['channel']['item'] as $feed)
					{
						$this_feed = array();

						if (isset($feed['link']) )
						{
							$this_feed['link'] = $feed['link'];
						}

						if (isset($feed['title']))
						{
							$this_feed['title'] = $feed['title'];
						}

						if (isset($feed['author']))
						{
							$this_feed['author'] = $feed['author'];
						}

						if (isset($feed['atom:summary']))
						{
							$this_feed['summary'] = $feed['atom:summary'];
						}
						else if (isset($feed['description']))
						{
							$this_feed['summary'] = $feed['description'];
						}
						else if (isset($feed['summary']))
						{
							$this_feed['summary'] = $feed['summary'];
						}
						$details[] = $this_feed;
					}
					$view->details = $details;
				}
				else if ($rss->xml_array['entry'])
				{
					foreach ($rss->xml_array['entry'] as $feed)
					{
						$this_feed = array();

						if (isset($feed['link']) )
						{
							$this_feed['link'] = $feed['link'][3]['href'];
						}

						if (isset($feed['title']))
						{
							$this_feed['title'] = $feed['title']['value'];
						}

						if (isset($feed['author']))
						{
							$this_feed['author'] = "<a href=\"" . $feed['author']['uri'] . "\">".
								 $feed['author']['name'] .">";
						}

						if (isset($feed['summary']))
						{
							$this_feed['summary'] = $feed['summary']['value'];
						}
						$details[] = $this_feed;
					}
					$view->details = $details;
				}

			}

			else
			{
				// only send a message
				$view->detail = $vbphrase['invalid_data'];
			}
			vB_Cache::instance()->write($this->getHash($this->widget->getId()),
				   $view->detail, $this->cache_ttl);
		}

		$view->widget_title = $this->widget->getTitle();

		return $view;
	}

}

/*======================================================================*\
|| ####################################################################

|| # SVN: $Revision: 32078 $
|| ####################################################################
\*======================================================================*/