<?php
/*=======================================================================*\
|| ##################################################################### ||
|| # vBCredits 1.4 - `credits_daily.php`							   # ||
|| # ------------------------------------------------------------------# ||
|| # Author: John Jakubowski "Darkwaltz4" {blackwaltz4@msn.com}		   # ||
|| # Copyright 2007-2008 PixelFX Studios Ltd. All Rights Reserved.	   # ||
|| # This file may not be redistributed in whole or significant part.  # ||
|| # -----------------vBulletin IS NOT FREE SOFTWARE!------------------# ||
|| #                Support: http://www.vbcredits.com/				   # ||
|| ##################################################################### ||
\*=======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);
if (!is_object($vbulletin->db))
{
	exit;
}

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

if ($vbulletin->options['credits_enabled'])
{
	$taxes = 0;
	$goodug = array(0);
	$cdtsql = $refsql = ' WHEN 0 THEN 0';
	$creditadd = $newlots = $newwins = $readd = $refadd = array();
	$fromuser = fetch_userinfo($vbulletin->options['credits_pmid']);
	$lotteries = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "credits_lottery WHERE active = 1 AND drawtime <= " . TIMENOW);
	$lastcron = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "cronlog WHERE varname = 'credits_time' ORDER BY dateline DESC LIMIT 1");
	cache_permissions($fromuser, false);

	if (!empty($lastcron['description']) AND $lastcron['description'] != 'Awarded Points Based on Registration Time')
	{
		$temp = explode('|', $lastcron['description']);
		$temp = array(explode(':', $temp[0]), explode(':', $temp[1]));
		$lastpay = $temp[0][1];
	}
	foreach ($vbulletin->usergroupcache AS $usergroupid => $ugcache)
	{
		if (!($vbulletin->bf_ugp['creditpermissions']['credit_locked'] & $ugcache['creditpermissions']))
		{
			$goodug[] = $usergroupid;
			$pcsql .= ' WHEN usergroupid = ' . $usergroupid . ' THEN (1 + IF (' . $vbulletin->options['credits_maxrefpoints'] . ' > -1 AND FLOOR(credits_numrefs / ' . $vbulletin->options['credits_refpoints'] . ') > ' . $vbulletin->options['credits_maxrefpoints'] . ', ' . $vbulletin->options['credits_maxrefpoints'] . ', FLOOR(credits_numrefs / ' . $vbulletin->options['credits_refpoints'] . ')) * ' . $ugcache['credit_refbonus'] . ') * (' . $ugcache['credit_paycheck'] . ' + ' . $ugcache['credit_active'] . ' * IF(' . $vbulletin->options['credits_active'] . ' >= ' . intval($lastpay) . ', 1, ' . (intval($vbulletin->options['credits_negations'] & 4) * $vbulletin->options['credits_return']) . '))';
		}
	}

	$birthdays = $vbulletin->db->query_read("SELECT userid, usergroupid, credits_numrefs FROM " . TABLE_PREFIX . "user WHERE birthday LIKE '" . date('m-d', TIMENOW) . "-%'");
	$newrefers = $vbulletin->db->query_read("SELECT user.userid, user.usergroupid, user.credits_numrefs, user.referrerid, user.reputation, user.posts, user.joindate, user.credits_canearn, ref.credits_numrefs AS refnumrefs, ref.usergroupid AS refugid, ref.credits_canearn AS canearnref FROM " . TABLE_PREFIX . "user AS user LEFT JOIN " . TABLE_PREFIX . "user AS ref ON (ref.userid = user.referrerid) WHERE (user.referrerid != 0 AND user.joindate > " . intval($lastcron['dateline']) . ")" . iif(!empty($temp[1][1]), ' OR user.userid IN (' . $temp[1][1] . ')'));

	while ($userinfo = $vbulletin->db->fetch_array($newrefers))
	{
		if ($userinfo['posts'] >= $vbulletin->options['credits_refposts'] AND $userinfo['reputation'] >= $vbulletin->options['credits_refrep'] AND floor((TIMENOW - $userinfo['joindate']) / 86400) >= $vbulletin->options['credits_reftime'])
		{
			if ($userinfo['credits_canearn'])
			{
				$usercreditperms = $vbulletin->usergroupcache[$userinfo['usergroupid']];
				$userrefpoints = floor($userinfo['credits_numrefs'] / $vbulletin->options['credits_refpoints']);
				$usercreditperms['creditbonus'] = (1 + ( ($vbulletin->options['credits_maxrefpoints'] > -1 AND $userrefpoints > $vbulletin->options['credits_maxrefpoints']) ? $vbulletin->options['credits_maxrefpoints'] : $userrefpoints ) * $usercreditperms['credit_refbonus']);
				$creditadd[$userinfo['userid']] += ($usercreditperms['creditbonus'] * $vbulletin->options['credits_referee']);
			}
			if ($userinfo['canearnref'])
			{
				$usercreditperms = $vbulletin->usergroupcache[$userinfo['refugid']];
				$userrefpoints = floor($userinfo['refnumrefs'] / $vbulletin->options['credits_refpoints']);
				$usercreditperms['creditbonus'] = (1 + ( ($vbulletin->options['credits_maxrefpoints'] > -1 AND $userrefpoints > $vbulletin->options['credits_maxrefpoints']) ? $vbulletin->options['credits_maxrefpoints'] : $userrefpoints ) * $usercreditperms['credit_refbonus']);
				$creditadd[$userinfo['referrerid']] += ($usercreditperms['creditbonus'] * $usercreditperms['credit_referral']);
			}

			$refadd[$userinfo['referrerid']]++;
		}
		else
		{
			$readd[] = $userinfo['userid'];
		}
	}
	while ($userinfo = $vbulletin->db->fetch_array($birthdays))
	{
		$usercreditperms = $vbulletin->usergroupcache[$userinfo['usergroupid']];
		$userrefpoints = floor($userinfo['credits_numrefs'] / $vbulletin->options['credits_refpoints']);
		$usercreditperms['creditbonus'] = (1 + ( ($vbulletin->options['credits_maxrefpoints'] > -1 AND $userrefpoints > $vbulletin->options['credits_maxrefpoints']) ? $vbulletin->options['credits_maxrefpoints'] : $userrefpoints ) * $usercreditperms['credit_refbonus']);
		$creditadd[$userinfo['userid']] += ($usercreditperms['creditbonus'] * $usercreditperms['credit_birthday']);
	}
	while ($lottery = $vbulletin->db->fetch_array($lotteries))
	{
		$winnerlist = '';
		$totaltickets = 0;
		$pickarray = $uniques = $unames = array();
		$heldtickets = unserialize($lottery['heldtickets']);

		foreach ($heldtickets AS $user => $tickets)
		{
			if ($lottery['tickets'] == 'raffle')
			{
				$totaltickets += $tickets;

				for ($x = 0; $x < $tickets; $x++)
				{
					$pickarray[] = array($user);
				}
			}
			else
			{
				$totaltickets += sizeof($tickets);

				foreach ($tickets AS $number)
				{
					$pickarray[$number][] = $user;
				}
			}
		}
		if ($totaltickets >= $lottery['mintickets'])
		{
			$winnumber = ( $lottery['tickets'] == 'raffle' ? array_rand($pickarray) : vbrand(1, $vbulletin->options['credits_lotteryrange']) );
			$winners = (array) $pickarray[$winnumber];

			if (sizeof($winners))
			{
				$taxamount = $vbulletin->options['credits_lotterytax'] * $lottery['jackpot'];
				$taxes += $taxamount;
				$eachwin = ($lottery['jackpot'] - $taxamount) / sizeof($winners);

				if ($lottery['wintype'] == 'raise')
				{
					$lottery['jackpot'] = 0;
				}
				foreach ($winners AS $user)
				{
					$creditadd[$user] += $eachwin;
					$uniques[$user] += $eachwin;
				}

				$usernames = $vbulletin->db->query_read("SELECT userid, username FROM " . TABLE_PREFIX . "user WHERE userid IN (" . implode(', ', $winners) . ")");

				while ($user = $vbulletin->db->fetch_array($usernames))
				{
					$unames[$user['userid']] = $user['username'];
				}
				foreach ($uniques AS $user => $amount)
				{
					eval($lottery['winnerphp']);

					if ($fromuser)
					{
						$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_SILENT);
						$pmdm->overridequota = true;
						$pmdm->set('fromuserid', $fromuser['userid']);
						$pmdm->set('fromusername', $fromuser['username']);
						$pmdm->set_info('receipt', false);
						$pmdm->set_info('savecopy', false);
						$pmdm->set('title', construct_phrase($vbphrase['credits_pm_lottery_subject'], $lottery['title']));
						$pmdm->set('message', construct_phrase($vbphrase['credits_pm_lottery_body'], $lottery['title'], vb_number_format($amount, $vbulletin->options['credits_decimals']), $vbphrase['credits']));
						$pmdm->set_recipients($unames[$user], $fromuser['permissions']);
						$pmdm->set('dateline', TIMENOW);
						$pmdm->set('allowsmilie', true);
						$pmdm->save();
						unset($pmdm);
					}

					$newwins[] = "($user, 'drawing', '" . $vbulletin->db->escape_string(construct_phrase($vbphrase['credits_drawing_windesc'], $lottery['title'], ( $lottery['tickets'] == 'raffle' ? $vbphrase['raffle'] : $vbphrase['credits_lotterynumber'] ), ( $lottery['tickets'] == 'raffle' ? '' : vb_number_format($winnumber, 0) ))) . "', $amount, " . TIMENOW . ")";
				}

				$vbulletin->db->free_result($usernames);
			}
			if ($lottery['recurdays'])
			{
				$newlots[] = "('" . $vbulletin->db->escape_string($lottery['title']) . "',
					'" . $vbulletin->db->escape_string(serialize(array())) . "',
					" . ($lottery['drawtime'] + $lottery['recurdays'] * 86400) . ",
					" . $lottery['recurdays'] . ", 1,
					'" . $vbulletin->db->escape_string($lottery['tickets']) . "',
					'" . $vbulletin->db->escape_string($lottery['wintype']) . "',
					" . $lottery['jackpot'] . ",
					'" . $vbulletin->db->escape_string($lottery['excluded']) . "',
					" . $lottery['ticketcost'] . ", " . $lottery['mintickets'] . ",
					'" . $vbulletin->db->escape_string(serialize(array())) . "',
					'" . $vbulletin->db->escape_string($lottery['winnerphp']) . "')";
			}

			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "credits_lottery SET active = 0, winner = '" . $vbulletin->db->escape_string(serialize($winners)) . "' WHERE lotteryid = " . $lottery['lotteryid']);
		}
		else
		{
			if ($vbulletin->options['credits_lotterymin'])
			{
				$lottery['drawtime'] += $vbulletin->options['credits_lotterymin'] * 86400;
			}
			else
			{
				$lottery['active'] = 0;
			}

			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "credits_lottery SET active = " . $lottery['active'] . ", drawtime = " . $lottery['drawtime'] . " WHERE lotteryid = " . $lottery['lotteryid']);
		}
	}
	if (sizeof($newlots))
	{
		$vbulletin->db->query_insert(TABLE_PREFIX . 'credits_lottery', '(title, winner, drawtime, recurdays, active, tickets, wintype, jackpot, excluded, ticketcost, mintickets, heldtickets, winnerphp)', $newlots);
	}
	if (sizeof($newwins))
	{
		$vbulletin->db->query_insert(TABLE_PREFIX . 'credits_transactions', '(touserid, action, comment, amount, timestamp)', $newwins);
	}
	foreach ($creditadd AS $userid => $amount)
	{
		$cdtsql .= ' WHEN userid = ' . $userid . ' THEN ' . $amount;
	}
	foreach ($refadd AS $userid => $numref)
	{
		$refsql .= ' WHEN userid = ' . $userid . ' THEN ' . $numref;
	}

	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET credits = credits + CASE$cdtsql ELSE 0 END, credits_numrefs = credits_numrefs + CASE$refsql ELSE 0 END WHERE credits_canearn = 1 AND usergroupid IN (" . implode(', ', $goodug) . ")");

	if (floor((TIMENOW - intval($lastpay)) / 86400) >= $vbulletin->options['credits_timedays'] AND !empty($pcsql))
	{
		$lastpay = TIMENOW;
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET credits = credits + CASE$pcsql ELSE 0 END WHERE credits_canearn = 1");
	}
	if ($taxes)
	{
		build_datastore('credits_central', $vbulletin->credits_central + $taxes, false);
	}
	if (floor((TIMENOW - intval($vbulletin->credits_interest)) / 86400) >= $vbulletin->options['credits_interestinterval'])
	{
		build_datastore('credits_interest', TIMENOW, false);
	}
	if ($vbulletin->options['credits_neghandle'] == 'correct')
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET credits = 0 WHERE credits < 0");
	}

	$vbulletin->db->free_result($newrefers);
	$vbulletin->db->free_result($birthdays);
	$vbulletin->db->free_result($lotteries);

	log_cron_action('Last Paycheck:' . intval($lastpay) . '|Check Referees:' . implode(', ', $readd), $nextitem, 1);
}
?>