/*=======================================================================*\
|| ##################################################################### ||
|| # vBCredits 1.4 - `credits_ajax_postadd.js`						   # ||
|| # ------------------------------------------------------------------# ||
|| # Author: John Jakubowski "Darkwaltz4" {blackwaltz4@msn.com}		   # ||
|| # Copyright 2007-2008 PixelFX Studios Ltd. All Rights Reserved.	   # ||
|| # This file may not be redistributed in whole or significant part.  # ||
|| # -----------------vBulletin IS NOT FREE SOFTWARE!------------------# ||
|| #                Support: http://www.vbcredits.com/				   # ||
|| ##################################################################### ||
\*=======================================================================*/

/**
* Register a post for ajax credits
*
* @param	string	Postid
*
* @return	vB_Credits_Object
*/
function vbcdt_register(postid)
{
	if (typeof vBcdt == 'object' && typeof postid != 'undefined')
	{
		return vBcdt.register(postid);
	}
}

// #############################################################################
// vB_Credits_Handler
// #############################################################################

/**
* vBCredits registry
*/
function vB_Credits_Handler()
{
	this.cdts = new Array();
	this.ajax = new Array();
};

// =============================================================================
// vB_Credits_Handler methods

/**
* Register a control object as a credits control
*
* @param	string	ID of the control object
*
* @return	vB_Credits_Object
*/
vB_Credits_Handler.prototype.register = function(postid)
{
	if (AJAX_Compatible && (typeof vb_disable_ajax == 'undefined' || vb_disable_ajax < 2))
	{
		this.cdts[postid] = new vB_Credits_Object(postid);
		if (obj = fetch_object('credits_' + postid))
		{
			obj.onclick = vB_Credits_Object.prototype.credits_click;
			return this.cdts[postid];
		}
	}
};

// #############################################################################
// initialize credits registry

vBcdt = new vB_Credits_Handler();

// #############################################################################
// vB_Credits_Object
// #############################################################################

/**
* vBCredits class constructor
*
* Manages a single credits and control object
* Initializes control object
*
* @param	string	postid
*/
function vB_Credits_Object(postid)
{
	this.postid = postid;
	this.divname = 'creditsmenu_' + postid + '_menu';
	this.divobj = null;
	this.postobj = fetch_object('post' + postid);

	this.vbmenuname = 'creditsmenu_' + postid;
	this.vbmenu = null;

	this.xml_sender_populate = null;
	this.xml_sender_submit = null;

	var me = this;

	/**
	* Populate OnReadyStateChange callback. Uses a closure to keep state.
	* Remember to use me instead of "this" inside this function!
	*/
	this.onreadystatechange_populate = function()
	{
		if (me.xml_sender_populate.handler.readyState == 4 && me.xml_sender_populate.handler.status == 200)
		{
			if (me.xml_sender_populate.handler.responseXML)
			{
				// check for error first
				var error = me.xml_sender_populate.fetch_data(fetch_tags(me.xml_sender_populate.handler.responseXML, 'error')[0]);
				if (error)
				{
					alert(error);
				}
				else
				{
					if (!me.divobj)
					{
						// Create new div to hold reputation menu html
						me.divobj = document.createElement('div');
						me.divobj.id = me.divname;
						me.divobj.style.display = 'none';
						me.divobj.onkeypress = vB_Credits_Object.prototype.repinput_onkeypress;
						me.postobj.parentNode.appendChild(me.divobj);

						me.vbmenu = vbmenu_register(me.vbmenuname, true);
						// Remove menu's mouseover event
						fetch_object(me.vbmenu.controlkey).onmouseover = '';
						fetch_object(me.vbmenu.controlkey).onclick = '';
					}

					me.divobj.innerHTML = me.xml_sender_populate.fetch_data(fetch_tags(me.xml_sender_populate.handler.responseXML, 'creditsbit')[0]);

					var inputs = fetch_tags(me.divobj, 'input');
					for (var i = 0; i < inputs.length; i++)
					{
						if (inputs[i].type == 'submit')
						{
							var sbutton = inputs[i];
							var button = document.createElement('input');
							button.type = 'button';
							button.className = sbutton.className;
							button.value = sbutton.value;
							button.onclick = vB_Credits_Object.prototype.submit_onclick;
							sbutton.parentNode.insertBefore(button, sbutton);
							sbutton.parentNode.removeChild(sbutton);
							button.name = sbutton.name;
							button.id = sbutton.name + '_' + me.postid
						}
					}

					me.vbmenu.show(fetch_object(me.vbmenuname));
				}
			}

			if (is_ie)
			{
				me.xml_sender_populate.handler.abort();
			}
		}
	}

	/**
	* Submit OnReadyStateChange callback. Uses a closure to keep state.
	* Remember to use me instead of "this" inside this function!
	*/
	this.onreadystatechange_submit = function()
	{
		if (me.xml_sender_submit.handler.readyState == 4 && me.xml_sender_submit.handler.status == 200)
		{
			if (me.xml_sender_submit.handler.responseXML)
			{
				// Register new menu item for this credits icon
				if (!me.vbmenu)
				{
					me.vbmenu = vbmenu_register(me.vbmenuname, true);
					// Remove menu's mouseover event
					fetch_object(me.vbmenu.controlkey).onmouseover = '';
					fetch_object(me.vbmenu.controlkey).onclick = '';
				}

				// check for error first
				var error = me.xml_sender_submit.fetch_data(fetch_tags(me.xml_sender_submit.handler.responseXML, 'error')[0]);
				if (error)
				{
					me.vbmenu.hide(fetch_object(me.vbmenuname));
					alert(error);
				}
				else
				{
					me.vbmenu.hide(fetch_object(me.vbmenuname));
					var cdtinfo =  fetch_tags(me.xml_sender_submit.handler.responseXML, 'credits')[0];
					var cdtdisplay = cdtinfo.getAttribute('cdtdisplay');
					var userid = cdtinfo.getAttribute('userid');

					var awards = cdtinfo.getAttribute('awards');

					var spans = fetch_tags(document, 'span');
					var postid = null;
					var match = null;

					for (var i = 0; i < spans.length; i++)
					{
						if (match = spans[i].id.match(/^cdt_(\d+)_(\d+)$/))
						{
							if (match[2] == userid)
							{
								spans[i].innerHTML = cdtdisplay;
							}
						}
					}
					
					fetch_object('award' + me.postid).innerHTML = awards;
					alert(me.xml_sender_submit.fetch_data(cdtinfo));
				}
			}

			if (is_ie)
			{
				me.xml_sender_submit.handler.abort();
			}
		}
	}
}

/**
* Handles click events on credits icon
*/
vB_Credits_Object.prototype.credits_click = function (e)
{
	e = e ? e : window.event;

	do_an_e(e);
	var postid = this.id.substr(this.id.lastIndexOf('_') + 1);
	var cdtobj = vBcdt.cdts[postid];

	// fetch and return credits html
	if (cdtobj.vbmenu == null)
	{
		cdtobj.populate();
	}
	else if (vBmenu.activemenu != cdtobj.vbmenuname)
	{
		cdtobj.vbmenu.show(fetch_object(cdtobj.vbmenuname));
	}
	else
	{
		cdtobj.vbmenu.hide();
	}

	return true;
}

/**
* Handles click events on credits submit button
*/

vB_Credits_Object.prototype.submit_onclick = function (e)
{
	e = e ? e : window.event;
	do_an_e(e);

	var postid = this.id.substr(this.id.lastIndexOf('_') + 1);
	var cdtobj = vBcdt.cdts[postid];
	cdtobj.submit();

	return false;
}

/**
*	Catches the keypress of the credits controls to keep them from submitting to inlineMod
*/
vB_Credits_Object.prototype.repinput_onkeypress = function (e)
{
	e = e ? e : window.event;

	switch (e.keyCode)
	{
		case 13:
		{
			vBcdt.cdts[this.id.split(/_/)[1]].submit();	
			return false;
		}
		default:
		{
			return true;
		}
	}
}

/**
* Queries for proper response to credits, response varies
*
*/
vB_Credits_Object.prototype.populate = function()
{
	this.xml_sender_populate = new vB_AJAX_Handler(true);
	this.xml_sender_populate.onreadystatechange(this.onreadystatechange_populate);
	this.xml_sender_populate.send('credits.php?p=' + this.postid, 'p=' + this.postid + '&ajax=1');
}

/**
* Submits credits
*
*/
vB_Credits_Object.prototype.submit = function()
{
	this.psuedoform = new vB_Hidden_Form('credits.php');
	this.psuedoform.add_variable('ajax', 1);
	this.psuedoform.add_variables_from_object(this.divobj);

	this.xml_sender_submit = new vB_AJAX_Handler(true);
	this.xml_sender_submit.onreadystatechange(this.onreadystatechange_submit)
	this.xml_sender_submit.send(
		'credits.php?do=addcredits&p=' + this.psuedoform.fetch_variable('p') + '&dir=' + this.psuedoform.fetch_variable('dir') + '&amount=' + this.psuedoform.fetch_variable('amount') + '&anonymous=' + this.psuedoform.fetch_variable('anonymous') + '&reason=' + PHP.urlencode(this.psuedoform.fetch_variable('reason')),
		this.psuedoform.build_query_string()
	);
}