<?php
// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'threadratinginfo');

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// pre-cache templates used by all actions
$globaltemplates = array(
	'THREADRATINGINFO', 
	'THREADRATINGINFO_WHOVOTED', 
	'THREADRATINGINFO_WHOVOTED_ENTRY', 
);

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');

// ############################ CONFIG VARS ##############################
$show_who_voted = $vbulletin->options['trateglobal'];

// use $vbulletin->GPC['name']
$vbulletin->input->clean_array_gpc('r', array(
	'threadid'         => TYPE_UINT,
	'mode'             => TYPE_STR,
));


// check for threadid
if (empty($vbulletin->GPC['threadid'])) {
	echo 'no threadid';
	exit;
}

// who voted list
if ($vbulletin->GPC['mode'] == 'whovoted' AND $show_who_voted) {
	// get ratings info from database
	$results = $db->query_read("SELECT tr.threadrateid, tr.threadid, tr.userid, tr.vote, u.username, u.usergroupid, u.displaygroupid FROM " . TABLE_PREFIX . "threadrate as tr
					LEFT JOIN " . TABLE_PREFIX . "user AS u ON (u.userid = tr.userid)
					WHERE tr.threadid = " . $vbulletin->GPC['threadid'] . "
					ORDER BY tr.vote DESC");
	$html_entries = '';
	while( $rating = $db->fetch_array( $results ) ) {
		$name = fetch_musername($rating);
		$html_user = "<a href=\"member.php?u=$rating[userid]\" target=\"blank\">$name</a>";
		$html_rating = "<img class=\"inlineimg\" src=\"$stylevar[imgdir_rating]/rating_$rating[vote].gif\" border=\"0\" /> ";
		eval('$html_entries .= "' . fetch_template('THREADRATINGINFO_WHOVOTED_ENTRY') . '";');
	}
	
	eval('print_output("' . fetch_template('THREADRATINGINFO_WHOVOTED') . '");');
	exit;
}



// get ratings info from database
$results = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "threadrate
				WHERE threadid = " . $vbulletin->GPC['threadid']);


// build reply
$totals = array(0, 0, 0, 0, 0, 0);
$percentage = array(0, 0, 0, 0, 0, 0);
$filled_percentage = array(0, 0, 0, 0, 0, 0);
$blank_percentage = array(0, 0, 0, 0, 0, 0);
$total = 0;
$average = 0;

while( $entry = $db->fetch_array( $results ) ) {
	$totals[$entry['vote']]++;
	$total++;
	$average += $entry['vote'];
}

$average = vb_number_format($average / $total, 2);

for ($i = 1; $i <= 5; $i++) {
	$percentage[$i] = floor(($totals[$i] / $total) * 100);
	$filled_percentage[$i] = floor((60 / 100) * $percentage[$i]);
	$blank_percentage[$i] = 60 - $filled_percentage[$i];
}

$whovoted1 = ''; $whovoted2 = '';
if ($show_who_voted) {
	$whovoted1 = '<a href="misc.php?do=whorate&threadid=' . $vbulletin->GPC['threadid'] . '">';
	$whovoted2 = '</a>';
}


// spit info
eval('print_output("' . fetch_template('THREADRATINGINFO') . '");');


?>