<?php

error_reporting(E_ALL & ~E_NOTICE);
define('THIS_SCRIPT', 'micromembers');

$phrasegroups = array(
	'posting',
	'postbit',
  'micromembers'
);

$specialtemplates = array();

$globaltemplates = array(
  	'micromembers_index',
  	'micromembers_letter',
  	'micromembers_users',
  	'micromembers_userbit',
    'micromembers_main',
    'micromembers_teambits',
    'micromembers_topposterbit',
    'micromembers_topposters',
    'micromembers_newuserbit',
    'micromembers_newusers',
    'im_aim',
    'im_icq',
    'im_msn',
    'im_skype',
    'im_yahoo',
    'im_send_aim',
    'im_send_icq',
    'im_send_msn',
    'im_send_skype',
    'im_send_yahoo',
    'im_message',
    'postbit_onlinestatus'
);

$actiontemplates = array();

require_once('./global.php');
require_once(DIR .'/includes/functions_user.php');
require_once(DIR .'/includes/functions_bigthree.php');

if(empty($_REQUEST['do']))
	$_REQUEST['do'] = 'main';

  $templatesets = array(
	//          userbit template              block template
	1 => array("micromembers_teambits", 				"micromembers_main"),
	2 => array("micromembers_topposterbit",		"micromembers_topposters"),
	3 => array("micromembers_newuserbit",			"micromembers_newusers")
  );

function printUsers($users, $title, $templateset, $totalposts = 0)
{
	global $db, $vbulletin, $vbphrase, $vboptions, $stylevar, $templatesets;
	$templates = $templatesets[$templateset];
	if($templateset != 3)
		$cellwidth = count($users) > 0 ? round((1/count($users))*100) : 100;
	else
		$cellwidth = 100;
	foreach($users as $user) {
    if($vbulletin->options['micromembers_type']== 1) {
      $avatarurl = fetch_avatar_url($user['userid']);
      if (!$avatarurl) {
    	  $teamavatar = 'micromembers/images/noavatar.gif';
      } else 	{
    	  $teamavatar = $vbulletin->options['bburl'] . '/' . $avatarurl[0];
      }
    } else {
			$teamavatar = '';
			$teamuserinfo = verify_id('user', $user['userid'], 1, 1, 47);
			$showprofilepic = ($vbulletin->options['profilepicenabled'] AND 
													$teamuserinfo['profilepic'] AND 
												 	($permissions['genericpermissions'] & 
												  	$vbulletin->bf_ugp_genericpermissions['canseeprofilepic'] OR 
												  	$vbulletin->userinfo['userid'] == $teamuserinfo['userid'])) ? true : false;
			if($vbulletin->options['usefileavatar'])	{
				$teamavatar = $vbulletin->options['profilepicurl'] . '/profilepic' . $teamuserinfo['userid'] . '_' . $teamuserinfo['profilepicrevision'] . '.gif';
			}	else {
				$teamavatar = 'image.php?' . $vbulletin->session->vars['sessionurl'] . 'u=' . $teamuserinfo['userid'] . "&amp;dateline=$teamuserinfo[profilepicdateline]&amp;type=profile";
			}
      if(empty($teamavatar) || !$showprofilepic) {
    	  $avatarurl = fetch_avatar_url($user['userid']);
        if(!$avatarurl) {
    	    $teamavatar = 'micromembers/images/nophoto.gif';
        } else {
    	    $teamavatar = $vbulletin->options['bburl'] . '/' . $avatarurl[0];
        }
      } 
    }
		$userinfo = verify_id('user', $user['userid'], 1, 1);
	  $userinfo['lastvisitdate'] = iif($vbulletin->options['micromembers_dateformat'] == 1, date('d/m/Y', $userinfo['lastvisit']), date('m/d/Y', $userinfo['lastvisit']));
    $userinfo['lastvisittime'] = vbdate($vbulletin->options['timeformat'], $userinfo['lastvisit']);
    $userinfo['joindate'] = iif($vbulletin->options['micromembers_dateformat'] == 1, date('d/m/Y', $userinfo['joindate']), date('m/d/Y', $userinfo['joindate']));
	  $useronline = fetch_online_status($userinfo, true);
    $userinfo['onlinestatuskey'] = $userinfo['onlinestatus'];
    $totalcount ++;
		$postpercents = 0;
		if($totalposts != 0)
			$postpercents = round(($user['postcount']/$totalposts) * 100);
    eval('$teambits .= "' . fetch_template($templates[0]) . '";');
  } 
  unset($teamarray);
	$plugin = 0;
  eval('$meetteams .= "' . fetch_template($templates[1]) . '";');
	return $meetteams;
}

function getMenu()
{
	global $db, $vbphrase;

	$usergroups_get = $db->query_read("
		SELECT ".TABLE_PREFIX."usergroup.usergroupid, ".TABLE_PREFIX."usergroup.title,
			COUNT(".TABLE_PREFIX."user.userid) AS membercount
		FROM ".TABLE_PREFIX."usergroup
		LEFT JOIN ".TABLE_PREFIX."user
			ON ".TABLE_PREFIX."user.usergroupid=".TABLE_PREFIX."usergroup.usergroupid
			OR FIND_IN_SET(".TABLE_PREFIX."usergroup.usergroupid, ".TABLE_PREFIX."user.membergroupids)
		WHERE ".TABLE_PREFIX."usergroup.ismicromembers=1
		GROUP BY ".TABLE_PREFIX."usergroup.usergroupid
		ORDER BY ".TABLE_PREFIX."usergroup.title
	");
	$menulinks = '';
	while($ugroup = $db->fetch_array($usergroups_get)) {
		if(!empty($menulinks))
			$menulinks .= '&nbsp;';
		$menulinks .= '<a href="memberindex.php?do=usergrouplisting&groupid='.$ugroup['usergroupid'].'"><b>'.$ugroup['title'].'</b></a> (<b>'.$ugroup['membercount'].'</b>)&nbsp;&nbsp;&nbsp;';
	}
	return $menulinks;
}

function getSearchUsergroups()
{
	global $db, $vbphrase;

	$usergroups_get = $db->query_read("
		SELECT ".TABLE_PREFIX."usergroup.usergroupid, ".TABLE_PREFIX."usergroup.title,
			COUNT(".TABLE_PREFIX."user.userid) AS membercount
		FROM ".TABLE_PREFIX."usergroup
		LEFT JOIN ".TABLE_PREFIX."user
			ON ".TABLE_PREFIX."user.usergroupid=".TABLE_PREFIX."usergroup.usergroupid
			OR FIND_IN_SET(".TABLE_PREFIX."usergroup.usergroupid, ".TABLE_PREFIX."user.membergroupids)
		WHERE ".TABLE_PREFIX."usergroup.ismicromembers=1
		GROUP BY ".TABLE_PREFIX."usergroup.usergroupid
		ORDER BY ".TABLE_PREFIX."usergroup.title
	");
	$options = '';
	while($ugroup = $db->fetch_array($usergroups_get))
		$options .= '<option value="'.$ugroup['usergroupid'].'">'.$ugroup['title'].'</option>';
	return $options;
}

if($_REQUEST['do'] == 'main') {

  // Build Usergroup Menu
	$menulinks = getMenu();

  // Get some variables
  $limit = $vbulletin->options['micromembers_count'];
  $admingroup = $vbulletin->options['micromembers_admins_group'];
  $admingroup2 = $vbulletin->options['micromembers_admins2_group'];
  
  // Build Admins Block
  if ($vbulletin->options[micromembers_admins] == '1') {
     $teammembers_get = $vbulletin->db->query_read(" 
     SELECT ".TABLE_PREFIX."user.userid, ".TABLE_PREFIX."user.username, ".TABLE_PREFIX."user.usertitle
     FROM ".TABLE_PREFIX."user
  	 JOIN ".TABLE_PREFIX."usergroup AS ugroup
			ON ugroup.usergroupid=".TABLE_PREFIX."user.usergroupid
		 LEFT JOIN ".TABLE_PREFIX."usergroup 
			ON (FIND_IN_SET(".TABLE_PREFIX."usergroup.usergroupid, ".TABLE_PREFIX."user.membergroupids))
 		 WHERE ugroup.usergroupid=$admingroup OR ".TABLE_PREFIX."usergroup.usergroupid=$admingroup
		 GROUP BY ".TABLE_PREFIX."user.userid
     ORDER BY RAND()
     LIMIT $limit
     "); 
	   $teammembers = array();
	   while($teammember = $db->fetch_array($teammembers_get))
		       $teammembers[] = $teammember;
	   $admins = printUsers($teammembers, $vbulletin->options['micromembers_admins_text'], 1);
  }

  // Build 2nd Block if user wants it
  if ($vbulletin->options[micromembers_admins2] == '1') {
     $teammembers2_get = $vbulletin->db->query_read(" 
     SELECT ".TABLE_PREFIX."user.userid, ".TABLE_PREFIX."user.username, ".TABLE_PREFIX."user.usertitle
     FROM ".TABLE_PREFIX."user
  	 JOIN ".TABLE_PREFIX."usergroup AS ugroup
			ON ugroup.usergroupid=".TABLE_PREFIX."user.usergroupid
		 LEFT JOIN ".TABLE_PREFIX."usergroup 
			ON (FIND_IN_SET(".TABLE_PREFIX."usergroup.usergroupid, ".TABLE_PREFIX."user.membergroupids))
 		 WHERE ugroup.usergroupid=$admingroup2 OR ".TABLE_PREFIX."usergroup.usergroupid=$admingroup2
		 GROUP BY ".TABLE_PREFIX."user.userid
     ORDER BY RAND()
     LIMIT $limit
     "); 
	   $teammembers2 = array();
	   while($teammember2 = $db->fetch_array($teammembers2_get))
		       $teammembers2[] = $teammember2;
	   $admins2 = printUsers($teammembers2, $vbulletin->options['micromembers_admins2_text'], 1);
  }

	// Featured Members
  if ($vbulletin->options[micromembers_featured] == '1') {
      $featured_get = $vbulletin->db->query_read(" 
      SELECT *
      FROM ".TABLE_PREFIX."user
  		WHERE micromembers_featured='1'
      ORDER BY RAND()
      LIMIT $limit
      "); 
    	$featuredmembers = array();
    	while($featured = $db->fetch_array($featured_get))
  		$featuredmembers[] = $featured;
    	$featuredusers = printUsers($featuredmembers, $vbulletin->options['micromembers_featured_text'], 1);
  }

  // Top Pated
  if ($vbulletin->options[micromembers_rating] == '1') {
	    $topusers_get = $db->query_read("
  		SELECT ".TABLE_PREFIX."user.userid, username, usertitle,
			AVG(".TABLE_PREFIX."micromembers_ratings.rating) AS rating
  		FROM ".TABLE_PREFIX."user
  		JOIN ".TABLE_PREFIX."micromembers_ratings
			ON ".TABLE_PREFIX."micromembers_ratings.rateduserid=".TABLE_PREFIX."user.userid
  		GROUP BY ".TABLE_PREFIX."user.userid
  		ORDER BY rating DESC
  		LIMIT $limit
    	");
    	$toprated = array();
    	while($topuser = $db->fetch_array($topusers_get)) {
  		$topuser['rating'] = intval(round($topuser['rating'])); 
  		$toprated[] = $topuser;
	    }
    	$toprated = printUsers($toprated, $vbulletin->options['micromembers_toprated_text'], 3);
  }

  // Just Joined us
  if ($vbulletin->options[micromembers_newest] == '1') {
	    $newusers_get = $db->query_read("
                  		SELECT userid, username, usertitle 
                  		FROM ".TABLE_PREFIX."user 
                  		WHERE usergroupid=2 OR FIND_IN_SET(2, membergroupids)
                  		ORDER BY joindate DESC 
                  		LIMIT $limit");
    	$users = array();
    	while($newuser = $db->fetch_array($newusers_get))
  		$users[] = $newuser;
    	$newusers = printUsers($users, $vbulletin->options['micromembers_newest_text'], 3);
    	unset($users);
  }

  // Week's Top Posters
  if ($vbulletin->options[micromembers_week] == '1') {
	  $timelimit = time() - 7 * 24 * 60 * 60;
      $mostactiveweek_get = $db->query_read("
	  SELECT COUNT(post.dateline) AS postcount, post.userid,
	  user.userid, user.username, user.lastpostid, user.posts, user.usergroupid
	  FROM " . TABLE_PREFIX . "post AS post
        JOIN " . TABLE_PREFIX . "user AS user ON (post.userid = user.userid)
      WHERE user.posts != '0' AND user.usergroupid=2 AND post.dateline>$timelimit
      GROUP BY post.userid
      ORDER BY postcount DESC
  	  LIMIT $limit
	  ");
      $users = array();
      while($user = $db->fetch_array($mostactiveweek_get))
      {
  	      	$users[] = $user;
    	    $totalposts = $db->query_first("SELECT COUNT(postid) AS postcount FROM ".TABLE_PREFIX."post WHERE dateline>$timelimit");
    	    $mostactiveusersweek = printUsers($users, $vbulletin->options['micromembers_week_text'], 2, $totalposts['postcount']);
    	    unset($users);
      }
  }
  // Month's Top Posters
  if ($vbulletin->options[micromembers_month] == '1') {
	    $timelimit = time() - 30 * 24 * 60 * 60;
    	$mostactivemonth_get = $db->query_read("
  		SELECT ".TABLE_PREFIX."user.userid, ".TABLE_PREFIX."user.username, ".TABLE_PREFIX."user.usertitle,
			COUNT(".TABLE_PREFIX."post.postid) AS postcount
  		FROM ".TABLE_PREFIX."user 
  		LEFT JOIN ".TABLE_PREFIX."post
 			ON ".TABLE_PREFIX."post.userid=".TABLE_PREFIX."user.userid
 		  AND dateline>$timelimit
  		WHERE usergroupid=2
  		GROUP BY ".TABLE_PREFIX."user.userid
  		ORDER BY postcount DESC 
  		LIMIT $limit");
    	$users = array();
    	while($user = $db->fetch_array($mostactivemonth_get))
  		$users[] = $user;
    	$totalposts = $db->query_first("SELECT COUNT(postid) AS postcount FROM ".TABLE_PREFIX."post WHERE dateline>$timelimit");
    	$mostactiveusersmonth = printUsers($users, $vbulletin->options['micromembers_month_text'], 2, $totalposts['postcount']);
    	unset($users);
  }

  // Overall Top Posters
  if ($vbulletin->options[micromembers_overall] == '1') {
	    $mostactive_get = $db->query_read("
  		SELECT userid, username, usertitle, posts AS postcount
  		FROM ".TABLE_PREFIX."user 
  		WHERE usergroupid=2
  		ORDER BY posts DESC 
  		LIMIT $limit");
    	$users = array();
    	while($user = $db->fetch_array($mostactive_get))
  		$users[] = $user;
    	$totalposts = $db->query_first("SELECT COUNT(postid) AS postcount FROM ".TABLE_PREFIX."post");
    	$mostactiveusers = printUsers($users, $vbulletin->options['micromembers_overall_text'], 2, $totalposts['postcount']);
    	unset($users);
  }

	$usergroupoptions = getSearchUsergroups();
  $navbits = construct_navbits(array("memberindex.php?" . $vbulletin->session->vars['sessionurl'] . ""=> $vbulletin->options['micromembers_navbar_text']));
  eval('$navbar = "' . fetch_template('navbar') . '";');
  eval('print_output("' . fetch_template('micromembers_index') . '");');
}


if($_REQUEST['do'] == 'usergrouplisting') {
  $groupid = $vbulletin->input->clean_gpc('r', 'groupid', TYPE_UINT);
	$group = $db->query_first("SELECT usergroupid, title FROM ".TABLE_PREFIX."usergroup WHERE usergroupid=$groupid");
	if(!$group)
		print_no_permission();

	if($_REQUEST['action'] == 'rateuser') {
	  $rateduserid = $vbulletin->input->clean_gpc('r', 'userid', TYPE_UINT);
	  $vote = $vbulletin->input->clean_gpc('r', 'vote', TYPE_UINT);
		$userid = $vbulletin->userinfo['userid'];
		$rating = $db->query_first("SELECT rating FROM ".TABLE_PREFIX."micromembers_ratings WHERE userid=$userid AND rateduserid=$rateduserid");
		if($rating || $vote < 1 || $vote > 5)
			print_no_permission();
		$db->query_write("INSERT INTO ".TABLE_PREFIX."micromembers_ratings (userid, rateduserid, rating)
			                VALUES ($userid, $rateduserid, $vote)");
	}

  $pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_UINT);
  $letter = $db->escape_string($vbulletin->input->clean_gpc('r', 'ltr', TYPE_NOHTML));
	$where = '';
	if($letter == '#')
		$letter = '';
	if(!empty($letter))
		$where = "AND ".TABLE_PREFIX."user.username LIKE '$letter%' ";
	  $cols = $vbulletin->options['micromembers_usercols'];
  	$cellwidth = round((1/$cols)*100);
  	$rows = $vbulletin->options['micromembers_userrows'];
    $recperpage = $cols * $rows;
    $totalrecords = $db->query_first("
    SELECT COUNT(*) AS totalrecords
		FROM ".TABLE_PREFIX."user
		WHERE (".TABLE_PREFIX."user.usergroupid=$groupid
			OR FIND_IN_SET($groupid, ".TABLE_PREFIX."user.membergroupids)) $where
  	");
    sanitize_pageresults($totalrecords['totalrecords'], $pagenumber, $recperpage, $recperpage, $recperpage);
    $limitlower = ($pagenumber - 1) * $recperpage + 1;
    $limitupper = $pagenumber * $recperpage;
    if($limitupper > $totalrecords['totalrecords']) {
       $limitupper = $totalrecords['totalrecords'];
    if($limitlower > $totalrecords['totalrecords'])
       $limitlower = $totalrecords['totalrecords'] - $recperpage;
    }
    if($limitlower <= 0) {
       $limitlower = 1;
    }
  	$users_get = $db->query_read("
		SELECT ".TABLE_PREFIX."user.userid, username, usertitle,
			AVG(".TABLE_PREFIX."micromembers_ratings.rating) AS rating
		FROM ".TABLE_PREFIX."user
		LEFT JOIN ".TABLE_PREFIX."micromembers_ratings
			ON ".TABLE_PREFIX."micromembers_ratings.rateduserid=".TABLE_PREFIX."user.userid
		WHERE (".TABLE_PREFIX."user.usergroupid=$groupid
			OR FIND_IN_SET($groupid, ".TABLE_PREFIX."user.membergroupids)) $where
			GROUP BY ".TABLE_PREFIX."user.userid
		ORDER BY ".TABLE_PREFIX."user.username
		LIMIT " . ($limitlower - 1) . ", $recperpage
  	");
  	$pagenav = construct_page_nav($pagenumber, $recperpage, $totalrecords['totalrecords'], "memberindex.php?" . $vbulletin->session->vars['sessionurl'] . "do=usergrouplisting&groupid=$groupid&ltr=$letter");
  	$userbits = "";
  	$idx = 0;
  	$cnt = 0;
  	$cols = $vbulletin->options['micromembers_usercols'];
  	while($user = $db->fetch_array($users_get)) {
      		$user['rating'] = intval(round($user['rating']));
		if($idx == 0)
     	 $userbits .= '<tr>';
    if($vbulletin->options['micromembers_type']== 1) {
       $avatarurl = fetch_avatar_url($user['userid']);
       if (!$avatarurl) {
      	  $teamavatar = 'micromembers/images/noavatar.gif';
       } else 	{
      	  $teamavatar = $vbulletin->options['bburl'] . '/' . $avatarurl[0];
       }
    } else {
			$teamavatar = '';
			$teamuserinfo = verify_id('user', $user['userid'], 1, 1, 47);
			$showprofilepic = ($vbulletin->options['profilepicenabled'] AND 
													$teamuserinfo['profilepic'] AND 
												 	($permissions['genericpermissions'] & 
												  	$vbulletin->bf_ugp_genericpermissions['canseeprofilepic'] OR 
												  	$vbulletin->userinfo['userid'] == $teamuserinfo['userid'])) ? true : false;
			if($vbulletin->options['usefileavatar'])	{
				$teamavatar = $vbulletin->options['profilepicurl'] . '/profilepic' . $teamuserinfo['userid'] . '_' . $teamuserinfo['profilepicrevision'] . '.gif';
			}	else {
				$teamavatar = 'image.php?' . $vbulletin->session->vars['sessionurl'] . 'u=' . $teamuserinfo['userid'] . "&amp;dateline=".$teamuserinfo['profilepicdateline']."&amp;type=profile";
			}
      if(empty($teamavatar) || !$showprofilepic) {
    	  $avatarurl = fetch_avatar_url($user['userid']);
        if(!$avatarurl) {
    	    $teamavatar = 'micromembers/images/nophoto.gif';
        } else {
    	    $teamavatar = $vbulletin->options['bburl'] . '/' . $avatarurl[0];
        }
      } 
    }
		$userinfo = verify_id('user', $user['userid'], 1, 1);
	  $userinfo['lastvisitdate'] = iif($vbulletin->options['micromembers_dateformat'] == 1, date('d/m/Y', $userinfo['lastvisit']), date('m/d/Y', $userinfo['lastvisit']));
    $userinfo['lastvisittime'] = vbdate($vbulletin->options['timeformat'], $userinfo['lastvisit']);
    $userinfo['joindate'] = iif($vbulletin->options['micromembers_dateformat'] == 1, date('d/m/Y', $userinfo['joindate']), date('m/d/Y', $userinfo['joindate']));
	  $useronline = fetch_online_status($userinfo, true);
    $userinfo['onlinestatuskey'] = $userinfo['onlinestatus'];
		$showrating = 1;
		$myuserid = $vbulletin->userinfo['userid'];
		$rating = $db->query_first("SELECT rating FROM ".TABLE_PREFIX."micromembers_ratings WHERE userid=$myuserid AND rateduserid=".$user['userid']);
		$alreadyrated = $rating ? true : false;
		$returnaddress = urlencode($_SERVER["QUERY_STRING"]);
		eval('$userbits .= "' . fetch_template('micromembers_userbit') . '";');
		$idx++;
		if($idx == $cols) {
			$userbits .= '</tr>';
			$idx = 0;
		}
		$cnt++;
	}
	if($cnt > 0 && $idx != $cols) {
		for($i = $idx; $i<$cols; $i++)
			$userbits .= '<td width="'.$cellwidth.'%">&nbsp;</td>';
		$userbits .= '</tr>';
	}
	eval('$users = "' . fetch_template('micromembers_users') . '";');
  $limit = $vbulletin->options['micromembers_count'];
	$topusers_get = $db->query_read("
		SELECT ".TABLE_PREFIX."user.userid, username, usertitle,
			AVG(".TABLE_PREFIX."micromembers_ratings.rating) AS rating
		FROM ".TABLE_PREFIX."user
		JOIN ".TABLE_PREFIX."micromembers_ratings
			ON ".TABLE_PREFIX."micromembers_ratings.rateduserid=".TABLE_PREFIX."user.userid
		WHERE ".TABLE_PREFIX."user.usergroupid=$groupid
			OR FIND_IN_SET($groupid, ".TABLE_PREFIX."user.membergroupids) 
		GROUP BY ".TABLE_PREFIX."user.userid
		ORDER BY rating DESC
		LIMIT $limit
	");
	$topusers = array();
	while($topuser = $db->fetch_array($topusers_get)) {
		$topuser['rating'] = intval(round($topuser['rating'])); 
		$topusers[] = $topuser;
	}
	$topusers = printUsers($topusers, "Top members", 1);
	$currentletter = '#';
	$linkletter = urlencode('#');
	$show['selectedletter'] = $selectedletter == '#' ? true : false;
	eval('$letterbits = "' . fetch_template('micromembers_letter') . '";');
	for ($i=65; $i < 91; $i++) {
		$currentletter = chr($i);
		$linkletter =& $currentletter;
		$show['selectedletter'] = $selectedletter == $currentletter ? true : false;
		eval('$letterbits .= "' . fetch_template('micromembers_letter') . '";');
	}
	$menulinks = getMenu();
	$usergroupoptions = getSearchUsergroups();
	$navbits = construct_navbits(array("memberindex.php?" . $vbulletin->session->vars['sessionurl'] . ""=> $vbulletin->options['micromembers_navbar_text'],
		"" => $group['title']));
	eval('$navbar = "' . fetch_template('navbar') . '";');
	eval('print_output("' . fetch_template('micromembers_index') . '");');
}

function getBirthday($age)
{
	$btime = time() - 60*60*24*365*$age;
	return date('Y-m-d', $btime);
}

function getTime($date, $plus = 0)
{
	list($year, $month, $day) = split('-', $date);
	if($plus) $day++;
	return(mktime(0, 0, 0, $month, $day, $year));
}

if($_REQUEST['do'] == 'search') {
  $usergroup = $vbulletin->input->clean_gpc('r', 'usergroup', TYPE_UINT);
  $order1 = $vbulletin->input->clean_gpc('r', 'order1', TYPE_UINT);
  $order2 = $vbulletin->input->clean_gpc('r', 'order2', TYPE_UINT);
  $username = $db->escape_string($vbulletin->input->clean_gpc('r', 'username', TYPE_STR));
  $location = $db->escape_string($vbulletin->input->clean_gpc('r', 'location', TYPE_STR));
	$age1 = $vbulletin->input->clean_gpc('r', 'age1', TYPE_UINT);
	$age2 = $vbulletin->input->clean_gpc('r', 'age2', TYPE_UINT);
	$joindate1 = $vbulletin->input->clean_gpc('r', 'joindate1', TYPE_STR);
	$joindate2 = $vbulletin->input->clean_gpc('r', 'joindate2', TYPE_STR);
	$posts1 = $vbulletin->input->clean_gpc('r', 'posts1', TYPE_UINT);
	$posts2 = $vbulletin->input->clean_gpc('r', 'posts2', TYPE_UINT);
	$lastpost1 = $vbulletin->input->clean_gpc('r', 'lastpost1', TYPE_STR);
	$lastpost2 = $vbulletin->input->clean_gpc('r', 'lastpost2', TYPE_STR);
	$points1 = $vbulletin->input->clean_gpc('r', 'points1', TYPE_UINT);
	$points2 = $vbulletin->input->clean_gpc('r', 'points2', TYPE_UINT);
	if($vbulletin->options['micromembers_vbcredits'] == 1) {
		$credits1 = $vbulletin->input->clean_gpc('r', 'credits1', TYPE_UINT);
		$credits2 = $vbulletin->input->clean_gpc('r', 'credits2', TYPE_UINT);
	}
	$reputation1 = $vbulletin->input->clean_gpc('r', 'reputation1', TYPE_UINT);
	$reputation2 = $vbulletin->input->clean_gpc('r', 'reputation2', TYPE_UINT);
	$infractions1 = $vbulletin->input->clean_gpc('r', 'infractions1', TYPE_UINT);
	$infractions2 = $vbulletin->input->clean_gpc('r', 'infractions2', TYPE_UINT);
	$icq = $vbulletin->input->clean_gpc('r', 'icq', TYPE_UINT);
	$aim = $vbulletin->input->clean_gpc('r', 'aim', TYPE_UINT);
	$msn = $vbulletin->input->clean_gpc('r', 'msn', TYPE_UINT);
	$yahoo = $vbulletin->input->clean_gpc('r', 'yahoo', TYPE_UINT);
	$skype = $vbulletin->input->clean_gpc('r', 'skype', TYPE_UINT);
	if($usergroup == 0) {
		$where = "WHERE (ugroup.ismicromembers=1 OR ".TABLE_PREFIX."usergroup.ismicromembers=1) ";
		$join =  "JOIN ".TABLE_PREFIX."usergroup AS ugroup
								ON ugroup.usergroupid=".TABLE_PREFIX."user.usergroupid
							LEFT JOIN ".TABLE_PREFIX."usergroup 
								ON (FIND_IN_SET(".TABLE_PREFIX."usergroup.usergroupid, ".TABLE_PREFIX."user.membergroupids)) ";
	} else {
		$where = "WHERE (".TABLE_PREFIX."user.usergroupid=$usergroup OR FIND_IN_SET($usergroup, ".TABLE_PREFIX."user.membergroupids)) ";
		$join = '';
	}
	if(!empty($username))
		$where .= "AND ".TABLE_PREFIX."user.username LIKE '%$username%' ";
	if($age1 != 0)
		$where .= "AND ".TABLE_PREFIX."user.birthday_search<='".getBirthday($age1)."' ";
	if($age2 != 0)
		$where .= "AND ".TABLE_PREFIX."user.birthday_search>='".getBirthday($age2)."' ";
	if($age1 != 0 || $age2 != 0)
		$where .= "AND ".TABLE_PREFIX."user.birthday_search<>'0000-00-00' ";
	if($joindate1 != 0)
		$where .= "AND ".TABLE_PREFIX."user.joindate>=".getTime($joindate1)." ";
	if($joindate2 != 0)
		$where .= "AND ".TABLE_PREFIX."user.joindate<=".getTime($joindate2, 1)." ";
	if($posts1)
		$where .= "AND ".TABLE_PREFIX."user.posts>=$posts1 ";
	if($posts2)
		$where .= "AND ".TABLE_PREFIX."user.posts<=$posts2 ";
	if($lastpost1 != 0)
		$where .= "AND ".TABLE_PREFIX."user.lastpost>=".getTime($lastpost1)." ";
	if($lastpost2 != 0)
		$where .= "AND ".TABLE_PREFIX."user.lastpost<=".getTime($lastpost2, 1)." ";
	if($lastpost1 != 0 || $lastpost2 != 0)
		$where .= "AND ".TABLE_PREFIX."user.lastpost<>0 ";
	if($points1)
		$where .= "AND ".TABLE_PREFIX."user.ipoints>=$points1 ";
	if($points2)
		$where .= "AND ".TABLE_PREFIX."user.ipoints<=$points2 ";
	if($vbulletin->options['micromembers_vbcredits'] == 1) {
		if($credits1)
			$where .= "AND ".TABLE_PREFIX."user.credits>=$credits1 ";
		if($credits2)
			$where .= "AND ".TABLE_PREFIX."user.credits<=$credits2 ";
	}		
	if($reputation1)
		$where .= "AND ".TABLE_PREFIX."user.reputation>=$reputation1 ";
	if($reputation2)
		$where .= "AND ".TABLE_PREFIX."user.reputation<=$raputation2 ";
	if($infractions1)
		$where .= "AND ".TABLE_PREFIX."user.infractions>=$infractions1 ";
	if($infractions2)
		$where .= "AND ".TABLE_PREFIX."user.infractions<=$infractions2 ";
	if(!empty($location))
		$where .= "AND ".TABLE_PREFIX."userfield.field2 LIKE '%$location%' ";
	if($icq != 0)
		$where .= "AND ".TABLE_PREFIX."user.icq<>'' ";
	if($msn != 0)
		$where .= "AND ".TABLE_PREFIX."user.msn<>'' ";
	if($aim != 0)
		$where .= "AND ".TABLE_PREFIX."user.aim<>'' ";
	if($yahoo != 0)
		$where .= "AND ".TABLE_PREFIX."user.yahoo<>'' ";
	if($skype != 0)
		$where .= "AND ".TABLE_PREFIX."user.skype<>'' ";
	$where .= "GROUP BY ".TABLE_PREFIX."user.userid ";
	$order = "ORDER BY ";
	switch($order1) {
		case 1: $order .= "username "; break;
		case 2: $order .= "joindate "; break;
		case 3: $order .= "posts "; break;
		case 4: $order .= "lastvisit "; break;
		case 5: $order .= "rating "; break;
		default: $order .= "username ";
	}
	$order .= iif($order2 == 1, "ASC ", "DESC ");
  $pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_UINT);
	$cols = $vbulletin->options['micromembers_usercols'];
	$cellwidth = round((1/$cols)*100);
	$rows = $vbulletin->options['micromembers_userrows'];
  $recperpage = $cols * $rows;
  $total = $db->query_read("
    SELECT ".TABLE_PREFIX."user.userid
		FROM ".TABLE_PREFIX."user
		LEFT JOIN ".TABLE_PREFIX."userfield
			ON ".TABLE_PREFIX."userfield.userid=".TABLE_PREFIX."user.userid
		$join
		$where
	"); 
	$totalrecords['totalrecords'] = $db->num_rows($total);
  sanitize_pageresults($totalrecords['totalrecords'], $pagenumber, $recperpage, $recperpage, $recperpage);
  $limitlower = ($pagenumber - 1) * $recperpage + 1;
  $limitupper = $pagenumber * $recperpage;
  if($limitupper > $totalrecords['totalrecords']) {
    $limitupper = $totalrecords['totalrecords'];
    if($limitlower > $totalrecords['totalrecords'])
      $limitlower = $totalrecords['totalrecords'] - $recperpage;
  }
  if($limitlower <= 0) {
     $limitlower = 1;
  } 
	$users_get = $db->query_read("
		SELECT ".TABLE_PREFIX."user.userid, ".TABLE_PREFIX."user.username, ".TABLE_PREFIX."user.usertitle,
			AVG(".TABLE_PREFIX."micromembers_ratings.rating) AS rating
		FROM ".TABLE_PREFIX."user
		LEFT JOIN ".TABLE_PREFIX."userfield
			ON ".TABLE_PREFIX."userfield.userid=".TABLE_PREFIX."user.userid
		LEFT JOIN ".TABLE_PREFIX."micromembers_ratings
			ON ".TABLE_PREFIX."micromembers_ratings.rateduserid=".TABLE_PREFIX."user.userid
		$join
		$where
		$order
		LIMIT " . ($limitlower - 1) . ", $recperpage
	");
	$url = "do=search&usergroup=$usergroup&order1=$order1&order2=$order2&username=$username&age1=$age1&age2=$age2&joindate1=$joindate1&joindate2=$joindate2&posts1=$posts1&posts2=$posts2&lastpost1=$lastpost1&lastpost2=$lastpost2&points1=$points1&points2=$points2&credits1=$credits1&credits2=$credits2&reputation1=$reputation1&reputation2=$reputation2&infractions1=$infractions1&infractions2=$infractions2&location=$location&icq=$icq&aim=$aim&msn=$msn&yahoo=$yahoo&skype=$skype";
	$pagenav = construct_page_nav($pagenumber, $recperpage, $totalrecords['totalrecords'], "memberindex.php?" . $vbulletin->session->vars['sessionurl'] . $url);
	$userbits = "";
	$idx = 0;
	$cnt = 0;
	$cols = $vbulletin->options['micromembers_usercols'];
	while($user = $db->fetch_array($users_get)) {
		if($idx == 0)
			$userbits .= '<tr>';
    if($vbulletin->options['micromembers_type']== 1) {
      $avatarurl = fetch_avatar_url($user['userid']);
      if (!$avatarurl) {
    	  $teamavatar = 'micromembers/images/noavatar.gif';
      } else 	{
    	  $teamavatar = $vbulletin->options['bburl'] . '/' . $avatarurl[0];
      }
    } else {
			$teamavatar = '';
			$teamuserinfo = verify_id('user', $user['userid'], 1, 1, 47);
			$showprofilepic = ($vbulletin->options['profilepicenabled'] AND 
													$teamuserinfo['profilepic'] AND 
												 	($permissions['genericpermissions'] & 
												  	$vbulletin->bf_ugp_genericpermissions['canseeprofilepic'] OR 
												  	$vbulletin->userinfo['userid'] == $teamuserinfo['userid'])) ? true : false;
			if($vbulletin->options['usefileavatar'])	{
				$teamavatar = $vbulletin->options['profilepicurl'] . '/profilepic' . $teamuserinfo['userid'] . '_' . $teamuserinfo['profilepicrevision'] . '.gif';
			}	else {
				$teamavatar = 'image.php?' . $vbulletin->session->vars['sessionurl'] . 'u=' . $teamuserinfo['userid'] . "&amp;dateline=".$teamuserinfo['profilepicdateline']."&amp;type=profile";
			}
      if(empty($teamavatar) || !$showprofilepic) {
    	  $avatarurl = fetch_avatar_url($user['userid']);
        if(!$avatarurl) {
    	    $teamavatar = 'micromembers/images/nophoto.gif';
        } else {
    	    $teamavatar = $vbulletin->options['bburl'] . '/' . $avatarurl[0];
        }
      } 
    }
		$userinfo = verify_id('user', $user['userid'], 1, 1);
	  $userinfo['lastvisitdate'] = vbdate($vbulletin->options['dateformat'], $userinfo['lastvisit'], true);
    $userinfo['lastvisittime'] = vbdate($vbulletin->options['timeformat'], $userinfo['lastvisit']);
    $userinfo['joindate'] = iif($vbulletin->options['micromembers_dateformat'] == 1, date('d/m/Y', $userinfo['joindate']), date('m/d/Y', $userinfo['joindate']));
	  $useronline = fetch_online_status($userinfo, true);
    $userinfo['onlinestatuskey'] = $userinfo['onlinestatus'];
		$returnaddress = urlencode("$url&page=$pagenumber");
		eval('$userbits .= "' . fetch_template('micromembers_userbit') . '";');
		$idx++;
		if($idx == $cols) {
			$userbits .= '</tr>';
			$idx = 0;
		}
		$cnt++;
	}
	if($cnt > 0 && $idx != $cols) {
		for($i = $idx; $i<$cols; $i++)
			$userbits .= '<td width="'.$cellwidth.'%">&nbsp;</td>';
		$userbits .= '</tr>';
	}
	eval('$users = "' . fetch_template('micromembers_users') . '";');
	$menulinks = getMenu();
	$usergroupoptions = getSearchUsergroups();
	$navbits = construct_navbits(array("memberindex.php?" . $vbulletin->session->vars['sessionurl'] . ""=> $vbulletin->options['micromembers_navbar_text'],
		"" => "Search Results"));
	eval('$navbar = "' . fetch_template('navbar') . '";');
	eval('print_output("' . fetch_template('micromembers_index') . '");');
}

if($_REQUEST['do'] == 'setfeatured') {
	if(!($permissions['micromembers'] & $vbulletin->bf_ugp['micromembers']['canmod']))
		print_no_permission();
  $memberid = $vbulletin->input->clean_gpc('r', 'memberid', TYPE_UINT);
	$db->query_write("UPDATE ".TABLE_PREFIX."user SET micromembers_featured=1 WHERE userid=$memberid");
  $returnaddress = urldecode($vbulletin->input->clean_gpc('r', 'return', TYPE_STR));
	$vbulletin->url = "memberindex.php?$returnaddress";
	standard_redirect();
}

if($_REQUEST['do'] == 'removefeatured') {
	if(!($permissions['micromembers'] & $vbulletin->bf_ugp['micromembers']['canmod']))
		print_no_permission();
  $memberid = $vbulletin->input->clean_gpc('r', 'memberid', TYPE_UINT);
	$db->query_write("UPDATE ".TABLE_PREFIX."user SET micromembers_featured=0 WHERE userid=$memberid");
  $returnaddress = urldecode($vbulletin->input->clean_gpc('r', 'return', TYPE_STR));
	$vbulletin->url = "memberindex.php?$returnaddress";
	standard_redirect();
}
?>
