<?php

/*===========================================================================================*\
|| ######################################################################################### ||
|| #                                                                                       # ||
|| # MySmilies vB 3.8.003 (for vBulletin v3.8.0 Gold and higher)                           # ||
|| #                                                                                       # ||
|| # Copyright (c) 2007 - 2009:                                                            # ||
|| # 	v3.8.x by: Eric Sizemore   (http://www.vbulletin.org/forum/member.php?u=142777)    # ||
|| # 	v3.7.x by: Mosh Shigdar    (http://www.vbulletin.org/forum/member.php?u=62814)     # ||
|| # 	v3.6.x by: Rigel Kentaurus (CemZoo.com)                                            # ||
|| #                                                                                       # ||
|| # For distribution in vBulletin.org only.                                               # ||
|| #                                                                                       # ||
|| # Info for hackers / developers:                                                        # ||
|| # 	You may modify, improve, upgrade, redistribute this hack, include it in another    # ||
|| # 	hack or yours or translate it provided you do it free of charge and you distribute # ||
|| # 	it in www.vbulletin.org at least, there is no need to pm asking for permission.    # ||
|| # 	Some portions of the code are (c) Jelsoft Enterprises Ltd.                         # ||
|| #                                                                                       # ||
|| ######################################################################################### ||
\*===========================================================================================*/

require_once('./includes/class_upload.php');
require_once('./includes/class_dm.php');
require_once('./includes/class_dm_userpic.php');

#########################################################################################
/**
* This class implements the logic for uploading a custom smilie, 
* the data for this image will be stored in the table "mysmiliesvb"
*/
class vB_Upload_MySmiliesVbImage extends vB_Upload_Userpic
{
	/**
	* The id of the user that we are inserting the image for.
	*
	* @var integer
	*/
	var $userid = -1;

	/**
	* The text for the smilie
	*
	* @var string
	*/
	var $smilietext;

	/**
	* The text for the smilie
	*
	* @var string
	*/
	var $smilietext_parsed;

	/**
	* Upload was a success, save it
	*/
	function save_upload()
	{
		$this->data->set('userid', $this->userid);
		$this->data->set('smilietext', $this->smilietext);
		$this->data->set('smilietext_parsed', $this->smilietext_parsed);
		$this->data->set('filename', $this->upload['filename']);
		$this->data->set('width', $this->imginfo[0]);
		$this->data->set('height', $this->imginfo[1]);
		$this->data->setr('filedata', $this->upload['filestuff']);
		$this->data->set('dateline', TIMENOW);

		if (!($result = $this->data->save()))
		{
			if (empty($this->data->errors[0]) OR !($this->registry->userinfo['permissions']['adminpermissions'] & $this->registry->bf_ugp_adminpermissions['cancontrolpanel']))
			{
				$this->set_error('upload_file_failed');
			}
			else
			{
				$this->error =& $this->data->errors[0];
			}
		}
		unset($this->upload);
		return $result;
	}
}

#########################################################################################
/*
* A custom DataManager for uploading smilies
*/
class vB_DataManager_MySmiliesVbImage extends vB_DataManager
{
	/**
	* Array of recognized and required fields for smilie inserts
	*
	* @var array
	*/
	var $validfields = array(
		'userid'            => array(TYPE_UINT,   REQ_YES),
		'smilietext'        => array(TYPE_STR,    REQ_YES),		
		'smilietext_parsed' => array(TYPE_STR,    REQ_YES),
		'dateline'          => array(TYPE_UINT,   REQ_YES),
		'filename'          => array(TYPE_STR,    REQ_YES),
		'filesize'          => array(TYPE_UINT,   REQ_YES),
		'width'             => array(TYPE_UINT,   REQ_NO),
		'height'            => array(TYPE_UINT,   REQ_NO),
		'filedata'          => array(TYPE_BINARY, REQ_NO, VF_METHOD)
	);

	/**
	* The main table this class deals with
	*
	* @var string
	*/
	var $table = 'mysmiliesvb';

	/**
	* Set the filehash/filesize of the file
	*
	* @param  integer  Maximum posts per page
	* @return boolean
	*/
	function verify_filedata(&$filedata)
	{
		if (strlen($filedata) > 0)
		{
			$this->set('filesize', strlen($filedata));
		}
		return true;
	}

	/**
	* Check if the image should be inserted or updated
	*
	* @param  boolean
	* @return mixed
	*/
	function pre_save($doquery = true)
	{
		if ($this->presave_called !== NULL)
		{
			return $this->presave_called;
		}

		if ($file =& $this->fetch_field('filedata'))
		{
			$this->setr_info('filedata', $file);
			$this->do_unset('filedata');
			$this->set('filesize', strlen($this->info['filedata']));

			if (!is_writable($this->registry->options['mysmiliesvb_option_filepath']))
			{
				$this->error('upload_invalid_imagepath');
				return false;
			}
		}

		// we don't check for a condition, updates are not really viable
		$return_value = true;
		$this->presave_called = $return_value;
		return $return_value;
	}

	/**
	* Fetch the path for later saving the image
	*
	* @param  void
	* @return string
	*/
	function fetch_path()
	{
		$filepath = $this->registry->options['mysmiliesvb_option_filepath'];
		$path = "$filepath/mysmilie_" . $this->dbobject->insert_id() . '.gif';
		return $path;
	}

	/**
	* Called after updating the table
	*
	* @param  boolean
	* @return boolean
	*/
	function post_save_each($doquery = true)
	{
		// We were given an image so write out a new image.
		if (!empty($this->info['filedata']))
		{
			if ($filenum = @fopen($this->fetch_path(), 'wb'))
			{
				@fwrite($filenum, $this->info['filedata']);
				@fclose($filenum);
				return true;
			}
			else
			{
				$this->error('upload_invalid_imagepath');
				return false;
			}
		}
		else
		{
			return true;
		}
	}
}

?>