<?php 
/*
 * ----------------------------------------------
 * Lazarus Guestbook
 * by Stewart Souter
 * URL: www.carbonize.co.uk 
 * Based on Advanced Guestbook 2.3.x (PHP/MySQL)
 * Copyright (c)2001 Chi Kien Uong
 * URL: http://www.proxy2.de
 * Last Modified: Sat, 31 October 2009 15:28:04 GMT
 * ----------------------------------------------
 */

class guestbook_vars extends gbook_sql
{

  var $VARS;
  var $LANG;
  var $table = array();
  var $SMILIES;
  var $template;
  var $badwords = '';

  function guestbook_vars($path = '')
  {
    global $GB_TBL;
    $this->table =& $GB_TBL;
    $this->gbook_sql();
    $this->connect();
    $this->template = new gb_template($path);
  }
  
// Retrieve our settings from the database  

  function getVars()
  {
    global $_COOKIE, $laz_build;
    $this->VARS = $this->fetch_array($this->query('SELECT * FROM '.LAZ_TABLE_PREFIX.'_config'));
    $this->free_result($this->result);
    if (isset($_COOKIE['lang']) && !empty($_COOKIE['lang']))
    {
      $this->template->set_lang($_COOKIE['lang']);
    }
    else
    {
      $this->template->set_lang($this->VARS['lang']);
    }
    $this->LANG = $this->template->get_content();
    if ($this->VARS['laz_version'] != $laz_build)
    {
      die ("<div style=\"border: 2px solid #D00; width: 400px; height: 80px; font-size: 12px; color: #000; padding: 2px;\"><h3 style=\"font-size: 20px; margin: 0 0 5px 0; padding: 0;\">You need to update your database!</h3>Visit <a href=\"".$this->VARS['base_url']."/install.php\">install.php</a> and do a smart update.<br />Database Version: ".$this->VARS['laz_version']."<br />Lazarus Version: ".$laz_build."</div>");
    }
    define('EXTERNAL_CSS', $this->VARS['external_css']);
    return $this->VARS;
  }

// This function converts a string into the relevant ascii HTML entities.

  function html_encode($string)
  {
    $ret_string = '';
    $len = strlen( $string );
    for ($x = 0; $x < $len; $x++) 
    {
      $enctype = rand(1, 3);
      switch ($enctype) 
      {
        case 1:
          $ret_string .= '&#'.ord($string[$x]).';';
          break;
        case 2:
          $ret_string .= '&#x'.dechex(ord($string[$x])).';';
          break;
        case 3:
          $ret_string .= $string[$x];
          break;
        default:
          $ret_string .= $string[$x];
          break;
      }
    } 
    return $ret_string;
  } 
  
// If they are previewing their entry we need to undo the HTMLspecialchars function

  function undo_htmlspecialchars($string)
  {
    $html = array (
    '&amp;'  => '&',
    '&quot;' => '"',
    '&lt;'  => '<',
    '&gt;'  => '>'
    );
    $string = strtr($string, $html);
    return ($string);
  } 
  
// Lets turn our smiley codes into img tags

  function emotion($message)
  {
    global $GB_PG;
    if (!isset($this->SMILIES))
    {
      $this->query('SELECT * FROM '.LAZ_TABLE_PREFIX.'_smilies');
      while ($this->fetch_array($this->result))
      {
        $this->SMILIES[$this->record['s_code']] = '<img src="'.$GB_PG['base_url'].'/img/smilies/'.$this->record['s_filename'].'" width="'.$this->record['width'].'" height="'.$this->record['height'].'" alt="'.$this->record['s_emotion'].'" title="'.$this->record['s_emotion'].'" align="bottom" />';
      }
    }
    if (isset($this->SMILIES))
    {
      for(reset($this->SMILIES); $key = key($this->SMILIES); next($this->SMILIES))
      {
        $message = str_replace("$key",$this->SMILIES[$key],$message);
      }
    }
    return $message;
  }
  
//
// Generate the smileys box content to be used on the forms.
//    
    
   function generate_smilies()
   {
      global $GB_PG;
      $ourSmileys = '';
      $smileyq = $this->query('SELECT * FROM '.LAZ_TABLE_PREFIX.'_smilies ORDER BY id ASC');
      while ($thesmiley = $this->fetch_array($smileyq))
      {
         $ourSmileys .= " <a href=\"javascript:emoticon('".$thesmiley['s_code']."')\"><img src=\"".$GB_PG['base_url']."/img/smilies/".$thesmiley['s_filename']."\" alt=\"".$thesmiley['s_code']."\" title=\"".$thesmiley['s_emotion']."\" border=\"0\" style=\"margin: 3px;\" /></a> ";
      }
      return $ourSmileys;
   }  
  
// Lets turn our timestamp into a legible date  

  function DateFormat($timestamp, $gb_time = 0)
  {
    $timestamp += $this->VARS['offset']*3600;
    list($wday,$mday,$month,$year,$hour,$minutes,$hour12,$ampm) = split("( )",date("w j n Y H i h A",$timestamp));
    if ($this->VARS['tformat'] == 'AMPM')
    {
      $newtime = " $hour12:$minutes $ampm";
    }
    else
    {
      $newtime = " $hour:$minutes";
    }
    // How to do our Today, Yesterday or Date
    $time_now = time() + ($this->VARS['offset']*3600);
    $date_today = date('j/n/Y', $time_now);
    if (($date_today == $mday.'/'.$month.'/'.$year) && ($this->VARS['smarttime'] == 1) && ($gb_time == 0))
    {
      $how_long = $time_now - $timestamp;
      if ($how_long < 60)
      {
        return str_replace('%T', $how_long, $this->template->TIMES['seconds']);
      }
      elseif ($how_long < 3600)
      {
        return str_replace('%T', intval($how_long / 60), $this->template->TIMES['minutes']);
      }
      else
      {
        return str_replace('%T', $newtime, $this->template->TIMES['today']); //$newtime.' '.$this->template->WEEKDAY[7];
      }
    }
    elseif (($date_today == ($mday + 1).'/'.$month.'/'.$year) && ($this->VARS['smarttime'] == 1) && ($gb_time == 0))
    {
      return str_replace('%T', $newtime, $this->template->TIMES['yesterday']); //return $newtime.' '.$this->template->WEEKDAY[8];
    }
    else
    {    
      if ($this->VARS['dformat'] == 'ISO')
      {
        $newdate = " $year-$month-$mday";
      }
      elseif ($this->VARS['dformat'] == 'USx')
      {
        $newdate = " $month-$mday-$year";
      }
      elseif ($this->VARS['dformat'] == 'US')
      {
        $month -= 1;
        $newdate = $this->template->WEEKDAY[$wday].", ".$this->template->MONTHS[$month]." $mday, $year";
      }
      elseif ($this->VARS['dformat'] == 'Euro')
      {
        $month -= 1;
        $newdate = $this->template->WEEKDAY[$wday].", $mday ".$this->template->MONTHS[$month]." $year";
      }
      else
      {
        $newdate = "$mday.$month.$year";
      }
      return $newdate.$newtime;
    }    
    // return ($newdate=$newdate.$newtime);
  }
  
// Convert any AGcode in the entry into the correct HTML  
  
  function AGCode($string)
  {
    $string = ' '.$string;
    if ($this->VARS['allow_urlagcode'] == 1)
    {
      // This bit will automatically make any urls clickable
      // It is taken from phpBB. Thanks guys.
      $string = preg_replace("#(^|[\n ])((http|https|ftp)+?://[\w\#$%&~/.\-;:=,?@\[\]+]*)#is", "$1[url]$2[/url]", $string);
      $string = preg_replace("#(^|[\n ])((www|ftp)\.[\w\#$%&~/.\-;:=,?@\[\]+]*)#is", "$1[url]$2[/url]", $string);    
    }
    // No point doing these checks if there is no AGcode
    if (!(strpos($string, '[') && strpos($string, ']')))
    {
      $string = substr($string, 1);
      return $string;
    }
    if ($this->VARS['allow_flashagcode'] == 1)
    {
      while (preg_match('!\[flash\]((http|https|ftp)://[^[]+)\[/flash\]!i', $string, $flash_url))
      {
        if (isset($flash_url[1]))
        {
          $isYouTube = false;
          if (preg_match('!http://[a-z]*\.*youtube.com/(.+?)v=([a-z0-9_-]+)!i', $flash_url[1]))
          {
            $isYouTube = true;
            if($this->VARS['always_flash'] == 1)
            {
              $flashURL = preg_replace("!http://[a-z]*\.*youtube.com/(.+?)v=([a-z0-9_-]+)(.*)!i", "http://www.youtube.com/swf/l.swf?video_id=$2", $flash_url[1]);
            }
            else
            {
              $flashURL = preg_replace("!http://[a-z]*\.*youtube.com/(.+?)v=([a-z0-9_-]+)(.*)!i", "http://www.youtube.com/v/$2", $flash_url[1]);
            }
          }
          else
          {
            $flashURL = $flash_url[1];
          }
          if ($isYouTube)
          {        
            $imagesize = @getimagesize($flashURL);
            if (is_array($imagesize) && ($imagesize[2] == 4 || $imagesize[2] == 13))
            {
              $imgsize = $this->check_image_size($imagesize[0], $imagesize[1]);
              if($this->VARS['always_flash'] == 1)
              {
                $flashURL = preg_replace("!http://[a-z]*\.*youtube.com/(.+?)v=([a-z0-9_-]+)(.*?)!i", "http://www.youtube.com/v/$2", $flash_url[1]);
              }
              $string = preg_replace('!\[flash\]'.preg_quote($flash_url[1]).'\[/flash\]!i',"<object type=\"application/x-shockwave-flash\" data=\"".$flashURL."\" $imgsize[2]><param name=\"movie\" value=\"".$flashURL."\"><param name=\"wmode\" value=\"opaque\"><p>You need <a href=\"http://www.adobe.com/go/getflashplayer\" target=\"_blank\">Flash</a> to view this object</p></object>",$string);
            }
            else
            {
              $isYouTube = false;
              $flashURL = $flash_url[1];
            }
          }
          if (!$isYouTube)
          {
            $imagesize = @getimagesize($flashURL); 
            if (is_array($imagesize)) 
            {              
              if($imagesize[2] == 4 || $imagesize[2] == 13)
              {
                $imgsize = $this->check_image_size($imagesize[0], $imagesize[1]);
                $string = preg_replace('!\[flash\]'.preg_quote($flashURL).'\[/flash\]!i',"<object type=\"application/x-shockwave-flash\" data=\"".$flashURL."\" $imgsize[2]><param name=\"movie\" value=\"".$flashURL."\"><param name=\"wmode\" value=\"opaque\"><p>You need <a href=\"http://www.adobe.com/go/getflashplayer\" target=\"_blank\">Flash</a> to view this object</p></object>",$string);
              }
              else
              {
                $string = preg_replace('!\[flash\]'.preg_quote($flashURL).'\[/flash\]!i',"[img]".$flashURL."[/img]",$string);  
              }
            }
            else
            {
              $string = preg_replace('!\[flash\]'.preg_quote($flashURL).'\[/flash\]!i',"[url]".$flashURL."[/url]",$string);
            }
          }
        }
      }
    }    
    if ($this->VARS['allow_imgagcode'] == 1)
    {
      while (preg_match('!\[img\]((http|https|ftp)://[^[]+)\[/img\]!i', $string, $img_url))
      {
        if (isset($img_url[1]) && ($this->VARS['agcode_img_width'] || $this->VARS['agcode_img_height']))
        {
          $imagesize = @getimagesize($img_url[1]);
          if (is_array($imagesize))
          {
            $imgsize = $this->check_image_size($imagesize[0], $imagesize[1]);
            $string = preg_replace('!\[img\]'.preg_quote($img_url[1]).'\[/img\]!i',"<a href=\"".$img_url[1]."\" target=\"_blank\"><img src=\"".$img_url[1]."\" border=\"0\" alt=\"\" $imgsize[2] /></a>",$string);
          }
          else
          {
            $string = preg_replace('!\[img\]'.preg_quote($img_url[1]).'\[/img\]!i',"<a href=\"".$img_url[1]."\" target=\"_blank\"><img src=\"".$img_url[1]."\" border=\"0\" alt=\"\" /></a>",$string);
          }
        }
        else
        {
          $string = preg_replace('!\[img\]'.preg_quote($img_url[1]).'\[/img\]!i',"<a href=\"".$img_url[1]."\" target=\"_blank\"><img src=\"".$img_url[1]."\" border=\"0\" alt=\"\" /></a>",$string);
        }
      }
    }
    $agcode_search = array(
                '/\[b\](.+?)\[\/b\]/is',                                
                '/\[i\](.+?)\[\/i\]/is',                                
                '/\[u\](.+?)\[\/u\]/is',                       
                );
    
    $agcode_replace = array(
                '<strong>$1</strong>',
                '<em>$1</em>',
                '<u>$1</u>',
                );
                
    if ($this->VARS['allow_emailagcode'] == 1)
    {
      $agcode_search[] = '/\[email\]([a-z0-9\-_\.\+]+@[a-z0-9\-]+\.[a-z0-9\-\.]+?)\[\/email\]/ies';
      $agcode_replace[] = "'<a href=\"'.\$this->html_encode('mailto:$1').'\">'.\$this->html_encode('$1').'</a>'";
    }
    if ($this->VARS['allow_urlagcode'] == 1)
    {
      $string = eregi_replace("\\[url\\]www\\.", "[url]http://www.", $string);
      $agcode_search[] = "/\[url\]((http|https|ftp|mailto):\/\/([a-z0-9\.\-@:]+)[a-z0-9;\/\?:@=\&\$\-_\.\+!*'\(\),\#%~]*?)\[\/url\]/is";
      $agcode_replace[] = '[<a href="$1" target="_blank" rel="nofollow" title="$1">$3</a>]';
      $agcode_search[] = "/\[url=((http|https|ftp|mailto):\/\/[a-z0-9;\/\?:@=\&\$\-_\.\+!*'\(\),~%#]+?)\](.+?)\[\/url\]/is";
      $agcode_replace[] = '<a href="$1" target="_blank" title="$1" rel="nofollow">$3</a>';
    }    
    $string = substr($string, 1);
    $string = preg_replace ($agcode_search, $agcode_replace, $string);
    return $string;
  }
  
// Generate a mildly encrypted timestamp

  function generate_timehash($timehash = '') 
  {
    global $GB_DB;
    $hashkey = md5($GB_DB['dbName'].$GB_DB['user']);
    if ($timehash != '')
    {
      return (($timehash / ord($hashkey[7])) + ord($hashkey[13])) - ord($hashkey[24]);
    }
    else
    {
      return (((time() + ord($hashkey[24])) - ord($hashkey[13])) * ord($hashkey[7]));
    }
  }  

// Code to allow certain HTML tags
   
  function allowed_html($string)
  {
    $allowed_tags = split(',', $this->VARS['allowed_tags']);
    for ($i = 0; $i <= (count($allowed_tags) - 1); $i++)
    {
      $allowed_tags[$i] = trim($allowed_tags[$i]);
      $string = preg_replace("!&lt;$allowed_tags[$i]&gt;([^\\[]*?)&lt;/$allowed_tags[$i]&gt;!","<$allowed_tags[$i]>$1</$allowed_tags[$i]>", $string);
    }
    return $string;
  }

// Remove spaces from the ends of the strings and any double spaces from the middle

  function FormatString($strg)
  {
    $strg = trim($strg);
    $strg = ereg_replace("[ ]+", " ", $strg);
    return $strg;
  }

// Make sure there are no stupidly long or short words

  function CheckWordLength($strg)
  {
    $word_array = split ("[ |\n]",$strg);
    for ($i=0;$i<sizeof($word_array);$i++)
    {
      if ((ereg("^\\[(url|img|email|flash)\\].+\\]",$word_array[$i])) || (eregi("^(http://)|(https://)|(ftp://)|(www\\.)", $word_array[$i])))
      {
        if (strlen($word_array[$i]) > 150)
        {
          return false;
        }
      }
      elseif (strlen($word_array[$i]) > $this->VARS['max_word_len'])
      {
        return false;
      }
    }
    return true;
  }

// Have we banned the ip they are posting from?

  function isBannedIp($ip)
  {
    $this->query('SELECT * from '.LAZ_TABLE_PREFIX.'_ban');
    if (!$this->result)
    {
      return false;
    }
    while ($row = $this->fetch_array($this->result))
    { 
      if ((strpos($ip, $row['ban_ip'])) === 0)
      {
        return true;
      }
    }
    return false;
  }
  
// Lets count how many urls they have put in their post. Have to convert them to AGcode first.  

  function urlCounter($str)
  {
    $str = ' '.$str;
    $str = preg_replace("#(^|[\n ])((http|https|ftp)://[\w\#$%&~/.\-;:=,?@\[\]+]*)#is", "$1[url]$2[/url]", $str);
    $str = preg_replace("#(^|[\n ])((www|ftp)\.[\w\#$%&~/.\-;:=,?@\[\]+]*)#is", "$1[url]$2[/url]", $str);
    $str = eregi_replace("\\[url\\]www\\.", "[url]http://www.", $str);
    $urlCount = preg_match_all("/\[url\]((http|https|ftp):\/\/([a-z0-9\.\-@:]+)[a-z0-9;\/\?:@=\&\$\-_\.\+!*'\(\),\#%~]*?)\[\/url\]/is",$str,$blah);
    $urlCount += preg_match_all("/\[url=((http|https|ftp):\/\/[a-z0-9;\/\?:@=\&\$\-_\.\+!*'\(\),~%#]+?)\](.+?)\[\/url\]/is",$str,$blah);
    
    return $urlCount;
  }  

// Have they posted within the last x seconds? 

  function FloodCheck($ip)
  {
    $the_time = time()-$this->VARS['flood_timeout'];
    $this->query("DELETE FROM ".LAZ_TABLE_PREFIX."_ip WHERE (timestamp < $the_time)");
    $this->query("SELECT * FROM ".LAZ_TABLE_PREFIX."_ip WHERE (guest_ip = '$ip')");
    $this->fetch_array($this->result);
    return ($this->record) ? true : false;
  }

// Convert any naughty words in their post

  function CensorBadWords($strg)
  {
    $replace = '#@*%!';
    if (empty($this->badwords))
    {
      $this->query('SELECT word FROM '.LAZ_TABLE_PREFIX.'_words WHERE type=1');
      while ($row = $this->fetch_array($this->result))
      {
        if ($this->VARS['use_regex'] == 0)
        {
          $this->badwords[] = preg_quote($row['word'], '/');
        }
        else
        {
          $this->badwords[] = $row;
        } 
      }
    }
    else
    {
      foreach ($this->badwords as $badword) 
      {
        $strg = preg_replace('^'.$badword.'^i', $replace, $strg);
      }
    }
    return $strg;
  }
  
// Check their post for naughty words so we can block them  
  
  function BlockBadWords($strg,$type = 2)
  {
    $this->query('SELECT word FROM '.LAZ_TABLE_PREFIX.'_words WHERE type=' . $type);
    if ($this->VARS['use_regex'] == 0)
    {
      while ($row = $this->fetch_array($this->result))
      {
        $row['word'] = preg_quote($row['word'], '/');
        if (preg_match('^'.$row['word'].'^i', $strg))
        {
          return true;
        }
      }
    }
    else
    {
      while ($row = $this->fetch_array($this->result))
      {
        if (preg_match('^'.$row['word'].'^i', $strg))
        {
          return true;
        }
      }
    }
    return false;
  }

// Something is wrong so lets report it

  function gb_error($ERROR)
  {
    global $GB_PG;
    $LANG =& $this->LANG;
    $VARS =& $this->VARS;
    $EMAILJS = '';
    $error_html = '';
    //eval("\$error_html = \"".$this->template->get_template('header')."\";");
    eval("\$error_html .= \"".$this->template->get_template('error')."\";");
    //eval("\$error_html .= \"".$this->template->get_template('footer')."\";");
    return $error_html;
  }

// Lets show a nice picture of what browser they posted with

  function browser_detect($useragent)
  {
    $browsers = array('opera', 'flock', 'firefox', 'chrome', 'iphone', 'safari', 'konqueror', 'netscape', 'aol', 'camino', 'chimera', 'crazy', 'galeon', 'k-meleon', 'maxthon', 'slimbrowser', 'amaya', 'avantbrowser', 'msie', 'gecko', 'mozilla');
    for ($i=0;$i<sizeof($browsers);$i++)
    {
      if (eregi($browsers[$i], $useragent))
      {
        $theirbrowser = $browsers[$i];
        $theirbrowser = ($theirbrowser == 'mozilla') ? 'ns' : $theirbrowser;
        $theirbrowser = ($theirbrowser == 'gecko') ? 'mozilla' : $theirbrowser;
        break;
      }
    }
    $theirbrowser = (!isset($theirbrowser)) ? 'question' : $theirbrowser;
    return $theirbrowser;
  }
  
// Is their email address in the valid format  
// Code from http://www.linuxjournal.com/article/9585
  
  function check_emailaddress($email)
  {
    $isValid = true;
    $atIndex = strrpos($email, '@');
    if (is_bool($atIndex) && !$atIndex)
    {
      $isValid = false;
    }
    else
    {
      $domain = substr($email, $atIndex+1);
      $local = substr($email, 0, $atIndex);
      $localLen = strlen($local);
      $domainLen = strlen($domain);
      if ($localLen < 1 || $localLen > 64)
      {
         // local part length exceeded
         $isValid = false;
      }
      elseif ($domainLen < 1 || $domainLen > 255)
      {
         // domain part length exceeded
         $isValid = false;
      }
      elseif ($local[0] == '.' || $local[$localLen-1] == '.')
      {
         // local part starts or ends with '.'
         $isValid = false;
      }
      elseif (preg_match('/\\.\\./', $local))
      {
         // local part has two consecutive dots
         $isValid = false;
      }
      elseif (!preg_match('/^[A-Za-z0-9\\-\\.]+$/', $domain))
      {
         // character not valid in domain part
         $isValid = false;
      }
      elseif (preg_match('/\\.\\./', $domain))
      {
         // domain part has two consecutive dots
         $isValid = false;
      }
      elseif(!preg_match('/^(\\\\.|[A-Za-z0-9!#%&`_=\\/$\'*+?^{}|~.-])+$/', str_replace("\\\\","",$local)))
      {
         // character not valid in local part unless 
         // local part is quoted
         if (!preg_match('/^"(\\\\"|[^"])+"$/',
             str_replace("\\\\","",$local)))
         {
            $isValid = false;
         }
      }
    }
    return $isValid;
  }
  
// Create or AGCode/Smiley button bar

  function create_buttons($LANG_CODES)
  {
    $display_tags = '<div style="margin: 0;padding: 0;clear: right;"><div id="agcode" style="display:none;margin: 0;padding: 0;">';
    if ($this->VARS['agcode'] == 1)
    {
      $display_tags .= '
      <button type="button" onclick="agCode(\'b\'); return false;" style="width:34px;font-weight:bold;padding:2px 0;margin:0;" /><img src="'.$this->VARS['base_url'].'/img/agcode/bold.gif" alt="B" /></button>
      <button type="button" onclick="agCode(\'i\'); return false;" style="width:34px;font-style:italic;padding:2px 0;margin:0;" /><img src="'.$this->VARS['base_url'].'/img/agcode/italic.gif" alt="I" /></button>
      <button type="button" onclick="agCode(\'u\'); return false;" style="width:34px;text-decoration:underline;padding:2px 0;margin:0;" /><img src="'.$this->VARS['base_url'].'/img/agcode/underline.gif" alt="U" /></button>
      ';
      if ($this->VARS['allow_emailagcode'] == 1)
      {
        $display_tags .= '<button type="button" onclick="agCode(\'email\'); return false;" style="width:34px;padding:2px 0;margin:0;"><img src="'.$this->VARS['base_url'].'/img/agcode/email.gif" alt="" /></button>
        ';
      }      
      if ($this->VARS['allow_imgagcode'] == 1)
      {
        $display_tags .= '<button type="button" onclick="agCode(\'img\'); return false;" style="width:34px;padding:2px 0;margin:0;"><img src="'.$this->VARS['base_url'].'/img/agcode/img.gif" alt="" /></button>
        ';
      }
      if ($this->VARS['allow_urlagcode'] == 1)
      {
        $display_tags .= '<button type="button" onclick="agCode(\'url\'); return false;" style="width:34px;padding:2px 0;margin:0;" /><img src="'.$this->VARS['base_url'].'/img/agcode/url.gif" alt="" /></button>
        ';
      }
      if ($this->VARS['allow_flashagcode'] == 1)
      {
        $display_tags .= '<button type="button" onclick="agCode(\'flash\'); return false;" style="width:34px;padding:2px 0;margin:0;" /><img src="'.$this->VARS['base_url'].'/img/agcode/flash.gif" alt="" /></button>
        ';
      }
    }
    if ($this->VARS['smilies'] == 1)
    {
      $display_tags .= '<button type="button" onclick="smileyBox(\'block\'); return false;" style="width:34px;padding:2px 0;margin:0;" /><img src="'.$this->VARS['base_url'].'/img/smilies/a1.gif" height="18" width="18" alt="" border="0" /></button>
      ';
    }     
    $display_tags .= '</div>';
    if ($this->VARS['smilies'] == 1)
    {
     $display_tags .= '<a href="'.$LANG_CODES.'?show=smilies" target="_blank" style="margin:0;padding:0;" id="show_smileys"><button type="button" style="width:34px;padding:2px 0;margin:0;" /><img src="'.$this->VARS['base_url'].'/img/smilies/a1.gif" id="showSmileys" height="18" width="18" alt="" border="0" /></button></a>
     ';
    }
    $display_tags .= '</div>';
    $display_tags .= "
    <script type=\"text/javascript\">
    <!--
      if (document.getElementById) {
        document.getElementById('agcode').style.display = 'block';";
    if ($this->VARS['smilies'] == 1)
    {
      $display_tags .= "\n  document.getElementById('show_smileys').style.display = 'none';";
    }
    $display_tags .= "
     }
     else if (document.all) {
       document.all['agcode'].style.display = 'block';";
    if ($this->VARS['smilies'] == 1)
    {
      $display_tags .= "\n  document.all['show_smileys'].style.display = 'none';";
    }
    $display_tags .= "
     }
     else if (document.layers)   {
       document.layers['agcode'].style.display = 'block';";
    if ($this->VARS['smilies'] == 1)
    {
      $display_tags .= "  document.layers['show_smileys'].style.display = 'none';";
    }
    $display_tags .= "
     }
    // -->
    </script>";
    return $display_tags;
  }  

// Work out the captcha code and compare it with what the submitted
  
  function captcha_test($thecode, $hash)
  {
    global $GB_DB;
    $realcode = md5($GB_DB['user']) . md5($hash);
    $realcode = md5($realcode);
    $realcode = $realcode[0] . $realcode[7] . $realcode[14] . $realcode[21] . $realcode[28];
    // Just an array for turning numbers into letters
    $captchanum = array(0 => 'V', 1 => 'H', 2 => 'K', 3 => 'M', 4 => 'P', 5 => 'S', 6 => 'T', 7 => 'W', 8 => 'X', 9 => 'Z');
    for($i = 0; $i <= 4; $i++)
    {
      $realcode[$i] = (is_numeric($realcode[$i])) ? $captchanum[$realcode[$i]] : $realcode[$i];
    }
    if (strtolower($realcode) == strtolower($thecode))
    {
      return true;
    }
    return false;
  }
  
// Check the size of their image funnily enough  
  
  function check_image_size($img_width, $img_height)
  {
    $max_width = $this->VARS['agcode_img_width'];
    $max_height = $this->VARS['agcode_img_height'];
    if ($img_width>$max_width && ($max_width > 0)) {
      $tag_height = ($max_width/$img_width)*$img_height;
      $tag_width = $max_width;
      if ($tag_height>$max_height) {
         $tag_width = ($max_height/$tag_height)*$tag_width;
         $tag_height = $max_height;
      }
    } elseif ($img_height>$max_height && ($max_height > 0)) {
      $tag_width = ($max_height/$img_height)*$img_width;
      $tag_height = $max_height;
      if ($tag_width>$max_width) {
        $tag_height = ($max_width/$tag_width)*$tag_height;
        $tag_width = $this->max_width;
      }
    } else {
      $tag_width = $img_width;
      $tag_height = $img_height;
    }
    $tag_width = round($tag_width);
    $tag_height = round($tag_height);
    return array(
      "$tag_width",
      "$tag_height",
      "width=\"$tag_width\" height=\"$tag_height\""
    );  
  }
  
// My wonderful email function to send as both plain text and HTML. Also attachs any picture they uploaded  
  
  function send_email($emailto, $emailsubject, $emailmessage, $emailheaders, $emailfrom = '', $imagedata = array('mime' => '', 'name' => '', 'data' => ''))
  {
    // Just to convert flash objects back to AGCode since email clients don't like them
    while(preg_match('!<object\b[^>]*>(.*?)value\=\"(.*?)\"(.*?)</object>!i', $emailmessage, $flash_url))
    {
      $emailmessage = preg_replace('!<object\b[^>]*>(.*?)value\=\"(.*?)\"(.*?)</object>!i', "[flash]<a href=\"$2\" target=\"_blank\">$2</a>[/flash]", $emailmessage);
    }
    // End of Flash AGCode reverse
    $emailboundary = md5(time()); // Just something random for the boundary
    $emailboundary = '----=Email_Boundary_'.$emailboundary; // Full boundary
    if(!empty($imagedata['mime']) && !empty($imagedata['name']) && !empty($imagedata['data']))
    {
      $emailheaders .= "\nX-Mailer: Lazarus Guestbook\nMIME-Version: 1.0\nContent-type: multipart/mixed;\n   boundary=\"".$emailboundary."\"";
      $emailbody = "\n\nThis is a multi-part message in MIME format.\nIf you are reading this then consider updating your email program.\n\n--".$emailboundary."\nContent-type: multipart/alternative;\n   boundary=\"".$emailboundary."Laz\"\n\n".
      '--'.$emailboundary."Laz\nContent-type: text/plain; charset=".$this->VARS['charset']."; format=flowed\nContent-Transfer-Encoding: 7bit\nContent-Disposition: inline\n\n".
      $this->undo_htmlspecialchars(strip_tags($emailmessage)).
      "\n\n--".$emailboundary."Laz\nContent-type: text/html; charset=".$this->VARS['charset']."\nContent-Transfer-Encoding: 7bit\nContent-Disposition: inline\n\n".
      "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n<html>\n<body>\n".
      $emailmessage.
      "\n</body>\n</html>\n\n--".$emailboundary.
      "Laz--\n\n--".$emailboundary."\nContent-type: ".$imagedata['mime']."; name=\"".$imagedata['name']."\"\n".
      "Content-Transfer-Encoding: base64\nContent-Disposition: attachment; filename=\"".$imagedata['name']."\"\n\n".$imagedata['data'].
      "--".$emailboundary."--\n";;      
    }
    else
    {
      $emailheaders .= "\nX-Mailer: Lazarus Guestbook\nMIME-Version: 1.0\nContent-type: multipart/alternative;\n   boundary=\"".$emailboundary."\"";
      $emailbody = "\n\nThis is a multi-part message in MIME format.\nIf you are reading this then consider updating your email program.\n\n".
      '--'.$emailboundary."\nContent-type: text/plain; charset=\"".$this->VARS['charset']."\"\nContent-Transfer-Encoding: 7bit\n\n".
      $this->undo_htmlspecialchars(strip_tags($emailmessage)).
      "\n\n--".$emailboundary."\nContent-type: text/html; charset=\"".$this->VARS['charset']."\"\nContent-Transfer-Encoding: 7bit\n\n".
      "<html>\n<body>\n".
      $emailmessage.
      "\n</body>\n</html>\n\n--".$emailboundary.'--';
    }
    if (ini_get('safe_mode'))
    {
      @mail($emailto, $emailsubject, $emailbody, $emailheaders);
    }
    else
    {
      @mail($emailto, $emailsubject, $emailbody, $emailheaders, '-f'.$emailfrom);
    }
    return;
  }
  
  // Just a function to put headers in correct case
  function fix_case($header)
  {
    $header = str_replace('HTTP_', '', $header);
    $header = strtolower(str_replace('_', ' ', $header));
    $header = str_replace(' ', '-', ucwords($header));
    return $header;
  }
  
  // Ok this is the function to create an array of the headers
  function fetch_headers()
  {
    if (!is_callable('getallheaders')) 
    {
      $headers = array();
      foreach ($_SERVER as $h => $v)
      {
        if(strpos($h, 'HTTP_') === 0)
        {
          $headers[$this->fix_case($h)] = $v;
        }
      }
    } 
    else 
    {
      $headers = getallheaders();
    }
    return $headers;
  }
  
  // Just a function to check what headers have been sent
  // Called by 1 = entry form, 2 = comment form, 3 = captcha, 4 = nothing
  function check_headers($called_by = 4)
  {
    $headers = $this->fetch_headers();
    
    // Browsers always send Accept
    if(!array_key_exists('Accept', $headers) || array_key_exists('Proxy-Connection', $headers) || array_key_exists('Range', $headers))
    {
      return 1;
    }
    
    // Do we have a useragent?
    if(array_key_exists('User-Agent', $headers))
    {
      // If user agent claims to be IE do some IE only tests.
      //if(preg_match('/msie/i', $headers['User-Agent']))
      if(strpos(strtolower($headers['User-Agent']), 'msie') !== false)
      {
        if(preg_match('/(Windows ME)|(Windows XP)|(Windows 2000)|(Win32)/i', $headers['User-Agent']))
        {
          return 2;
        }
      }
      
      // Check for some known bad useragents
      if(($headers['User-Agent'] === 'Mozilla/5.0') || (strpos($headers['User-Agent'], 'Java/') === 0) || (strpos($headers['User-Agent'], 'libwww-perl') === 0))
      {
        return 3;
      }
    }
    
    // The browser should post using the form type we set
    if(($called_by < 3) && !empty($headers['Content-Type']))
    {
      if((strpos(strtolower($headers['Content-Type']), 'multipart/form-data;')) !== 0)
      {
        return 4;
      }
    }
    return 0;
  }

}
?>