<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
define('CVS_REVISION', '$RCSfile$ - $Revision: 29067 $');
define('NOZIP', 1);

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('thread', 'threadmanage', 'prefix');
$specialtemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/functions_databuild.php');
require_once(DIR . '/includes/adminfunctions_prefix.php');

@set_time_limit(0);

// ######################## CHECK ADMIN PERMISSIONS #######################
if (!can_administer('canadminthreads'))
{
	print_cp_no_permission();
}

$vbulletin->input->clean_array_gpc('r', array(
	'forumid' => TYPE_INT,
	'pollid'  => TYPE_INT,
));

// ############################# LOG ACTION ###############################
log_admin_action(iif(!empty($vbulletin->GPC['forumid']), "forum id = " . $vbulletin->GPC['forumid'], iif(!empty($vbulletin->GPC['pollid']), "poll id = " . $vbulletin->GPC['pollid'])));

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################
if ($_POST['do'] != 'approve' and $_POST['do'] != 'disapprove')
{
	print_cp_header($vbphrase['autotaggerfromcontentandtitle_propositions']);
}

// ########################################################################

if ($_POST['do'] == 'approve' OR $_POST['do'] == 'disapprove' OR $_REQUEST['do'] == 'tags')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'pagenumber' => TYPE_UINT,
		'sort'       => TYPE_NOHTML
	));
	
  if ($_POST['do'] == 'approve' OR $_POST['do'] == 'disapprove')
	{
		$vbulletin->input->clean_array_gpc('p', array(
			'tag'               => TYPE_ARRAY_KEYS_INT
		));

		$vbulletin->input->clean_array_gpc('c', array(
			'vbulletin_inlinetag' => TYPE_STR,
		));

		$taglist = $vbulletin->GPC['tag'];

		if (!empty($vbulletin->GPC['vbulletin_inlinetag']))
		{
			$cookielist = explode('-', $vbulletin->GPC['vbulletin_inlinetag']);
			$cookielist = $vbulletin->input->clean($cookielist, TYPE_ARRAY_UINT);

			$taglist = array_unique(array_merge($taglist, $cookielist));
		}
	}
}

// ########################################################################
if ($_REQUEST['do'] == 'tags')
{
	if ($vbulletin->GPC['pagenumber'] < 1)
	{
		$vbulletin->GPC['pagenumber'] = 1;
	}

	$column_count = 2;
	$max_per_column = 15;

	$perpage = $column_count * $max_per_column;
	$start = ($vbulletin->GPC['pagenumber'] - 1) * $perpage;

	list($tag_count) = $db->query_first("SELECT COUNT(*) AS total FROM " . TABLE_PREFIX . "tag_proposition where status=0", DBARRAY_NUM);

	if ($start >= $tag_count)
	{
		$start = max(0, $tag_count - $perpage);
	}

	$tags = $db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "tag_proposition WHERE status = 0
		ORDER BY " . ($vbulletin->GPC['sort'] == 'dateline' ? 'dateline DESC' : 'tagtext') . "
		LIMIT $start, $perpage
	");

	print_form_header('propositions_autotaggerfromcontentandtitle', '', false, true, 'tagsform');
	print_table_header($vbphrase['autotaggerfromcontentandtitle_propositions'], 3);
	if ($db->num_rows($tags))
	{
		$columns = array();
		$counter = 0;

		// build page navigation
		$total_pages = ceil($tag_count / $perpage);
		if ($total_pages > 1)
		{
			$pagenav = '<strong>' . $vbphrase['go_to_page'] . '</strong>';
			for ($thispage = 1; $thispage <= $total_pages; $thispage++)
			{
				if ($thispage == $vbulletin->GPC['pagenumber'])
				{
					$pagenav .= " <strong>[$thispage]</strong> ";
				}
				else
				{
					$pagenav .= " <a href=\"propositions_autotaggerfromcontentandtitle.php?$session[sessionurl]do=tags&amp;page=$thispage\" class=\"normal\">$thispage</a> ";
				}
			}

		}
		else
		{
			$pagenav = '';
		}

		if ($vbulletin->GPC['sort'] == 'dateline')
		{
			$sort_link = '<a href="propositions_autotaggerfromcontentandtitle.php?do=tags">' . $vbphrase['display_alphabetically'] . '</a>';
		}
		else
		{
			$sort_link = '<a href="propositions_autotaggerfromcontentandtitle.php?do=tags&amp;sort=dateline">' . $vbphrase['display_newest'] . '</a>';
		}

		print_description_row(
			"<div style=\"float: $stylevar[left]\">$sort_link</div>$pagenav",
			false, 3, 'thead', 'right'
		);
		print_description_row(
			"<div style=\"float: $stylevar[left]\">".$vbphrase['autotaggerfromcontentandtitle_propositions_description']."</div>",false, 3, 'thead'
		);
		// build columns
		while ($tag = $db->fetch_array($tags))
		{
			$columnid = floor($counter++ / $max_per_column);
			$columns["$columnid"][] = '<div id="tag' . $tag['tagid'] . '" class="alt1" style="float:' . $stylevar[left] . ';clear:' . $stylevar[left] . '"><label for="taglist_' . $tag['tagid'] . '"><input type="checkbox" name="tag[' . $tag['tagid'] . ']" id="taglist_' . $tag['tagid'] . '" value="1" tabindex="1" /> ' . $tag['tagtext'] . '</label></div>';
		}

		// make column values printable
		$cells = array();
		for ($i = 0; $i < $column_count; $i++)
		{
			if ($columns["$i"])
			{
				$cells[] = implode("<br />\n", $columns["$i"]);
			}
			else
			{
				$cells[] = '&nbsp;';
			}
		}

		print_column_style_code(array(
			'width: 50%',
			'width: 50%'
		));
		print_cells_row($cells, false, false, -3);

		?>
		<tr>
			<td colspan="<?php echo $column_count; ?>" align="center" class="tfoot">
				<select id="select_tags" name="do">
					<option value="disapprove" id="select_disapprove"><?php echo $vbphrase[autotaggerfromcontentandtitle_propositions_disapprove]; ?></option>
					<option value="approve" id="select_approve"><?php echo $vbphrase[autotaggerfromcontentandtitle_propositions_approve]; ?></option>
				</select>

				<input type="hidden" name="page" value="<?php echo $vbulletin->GPC['pagenumber']; ?>" />
				<input type="hidden" name="sort" value="<?php echo $vbulletin->GPC['sort']; ?>" />
				<input type="submit" value="<?php echo $vbphrase[save]; ?>" id="tag_inlinego" class="button" />
			</td>
		</tr>
		</table>
		</form>
		<?php
	}
	else {
		print_description_row($vbphrase['autotaggerfromcontentandtitle_propositions_none'], false, 3, '', 'center');
		print_table_footer();
	}

	construct_hidden_code('page', $vbulletin->GPC['pagenumber']);
	construct_hidden_code('sort', $vbulletin->GPC['sort']);
}

// ########################################################################

if ($_POST['do'] == 'disapprove') {

	setcookie('vbulletin_inlinetag', '', TIMENOW - 3600, '/');

	print_cp_header($vbphrase['autotaggerfromcontentandtitle_propositions']);
	
	if (sizeof($taglist)) {
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "tag_proposition set status = 1 WHERE tagid IN (" . implode(',', $taglist) . ")
		");
	}

	define('CP_REDIRECT', 'propositions_autotaggerfromcontentandtitle.php?do=tags&page=' . $vbulletin->GPC['pagenumber'] . '&sort=' . $vbulletin->GPC['sort']);
	print_stop_message('tags_edited_successfully');
}

// ########################################################################

if ($_POST['do'] == 'approve') {

	setcookie('vbulletin_inlinetag', '', TIMENOW - 3600, '/');

	print_cp_header($vbphrase['autotaggerfromcontentandtitle_propositions']);
	
	if (sizeof($taglist)) {
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "tag_proposition set status = 2 WHERE tagid IN (" . implode(',', $taglist) . ")
		");
		
    $propositions = $db->query_read("
			SELECT tagtext
			FROM " . TABLE_PREFIX . "tag_proposition
			WHERE tagid IN (" . implode(',', $taglist) . ")
		");
		
    $toAddTagsSQL = array();
		while ($proposition = $vbulletin->db->fetch_array($propositions)) {
      $toAddTagsSQL[] = "('". $proposition['tagtext'] ."', " . TIMENOW . ")";
		}

    $vbulletin->db->query_write("INSERT IGNORE INTO " . TABLE_PREFIX . "tag (tagtext,dateline) VALUES " . implode(',', $toAddTagsSQL));
	}

	define('CP_REDIRECT', 'propositions_autotaggerfromcontentandtitle.php?do=tags&page=' . $vbulletin->GPC['pagenumber'] . '&sort=' . $vbulletin->GPC['sort']);
	print_stop_message('tags_edited_successfully');
}

// ########################################################################

print_cp_footer();

?>