<?php
error_reporting(E_ALL & ~E_NOTICE);

define('THIS_SCRIPT', 'classifieds');
$phrasegroups = array(
	'posting',
	'postbit',
  'classifieds'
);
$specialtemplates = array(
	'smiliecache',
	'bbcodecache',
	'ranks'
);
$globaltemplates = array(
	'bbcode_code',
	'bbcode_html',
	'bbcode_php',
	'bbcode_quote',
  'editor_toolbar_on'
);
$actiontemplates = array();

define('CDIR', getcwd());
require_once(CDIR . '/includes/init.php');
if(!isset($_REQUEST["styleid"]) || empty($_REQUEST["styleid"])) {
	$styleid = $vbulletin->options["classifieds_styleid"];
	
  $catid = $vbulletin->input->clean_gpc('r', 'catid', TYPE_UINT);
	if($catid != 0) { 
		$cat = $db->query_first("SELECT styleid FROM ".TABLE_PREFIX."classifieds_categories WHERE id=$catid");
		if($cat["styleid"] != -1 && !empty($cat["styleid"]))
			$styleid = $cat["styleid"];
	} else {
	  $adid = $vbulletin->input->clean_gpc('r', 'adid', TYPE_UINT);
		if($adid != 0) {
			$ad = $db->query_first("SELECT categoryid FROM ".TABLE_PREFIX."classifieds_ads WHERE id=$adid");
			if($ad) {
				$cat = $db->query_first("SELECT styleid FROM ".TABLE_PREFIX."classifieds_categories WHERE id=".$ad["categoryid"]);
				if($cat["styleid"] != -1 && !empty($cat["styleid"]))
					$styleid = $cat["styleid"];
			}
		}
	}

	$vbulletin->userinfo['styleid'] = $styleid;
}

require_once('./global.php');
require_once(DIR . '/classifieds/includes/functions.php');
require_once(DIR . '/includes/functions_editor.php');
require_once(DIR . '/includes/functions_wysiwyg.php');
require_once(DIR . '/includes/functions_user.php');
require_once(DIR . '/includes/class_bbcode.php');
require_once(DIR . '/includes/class_image.php');
if(@fopen('classifieds/includes/ClassifiedsBF.php', 'r')==FALSE) {
  $copyright = "<p><div align=\"center\" class=\"smallfont\"><a target=\"_blank\" href=\"http://www.sawa24.com\"><b>Classifieds</b></a> Translated by: <a target=\"_blank\" href=\"http://www.sawa24.com\"><b>Sawa 24 Team</b></a></p></div>";
  $footer = "$copyright $footer";
}

if(!($permissions['classifieds'] & $vbulletin->bf_ugp['classifieds']['canuse']))
  print_no_permission();

$userid = $vbulletin->userinfo['userid'];
$featuredcount = intval($vbulletin->options["classifieds_featuredadscount"]);


$categorieslisting = '';

if(empty($_REQUEST['do']))
	$_REQUEST['do'] = 'main';

if($_REQUEST['do'] == 'main') {
  $navbits = construct_navbits(array("classifieds.php?" . $vbulletin->session->vars['sessionurl'] => $vbulletin->options["classifieds_navbar"]));
  $leftsidebar = getLeftSidebar(0, 0); 
  eval('$navbar = "' . fetch_template('navbar') . '";'); 
  $content = '';
	$featured = getFeaturedAds(0, 0);
	$rightsidebar = getRightSidebar(0, 0);
	$categorieslisting = getCategoriesBlock(0);

  eval('print_output("' . fetch_template('classifieds_main') . '");');
}

if($_REQUEST['do'] == 'category') {
  $catid = $vbulletin->input->clean_gpc('r', 'catid', TYPE_UINT);
	$cat = $db->query_first("SELECT id, name FROM ".TABLE_PREFIX."classifieds_categories WHERE id=$catid");

  $navbits = construct_navbits(array("classifieds.php?" . $vbulletin->session->vars['sessionurl'] => $vbulletin->options["classifieds_navbar"], "" => $cat["name"]));
  $leftsidebar = getLeftSidebar($catid, 0); 
  eval('$navbar = "' . fetch_template('navbar') . '";'); 
  $content = getAdBlock($catid, 0);
	$featured = getFeaturedAds($catid, 0);
	$rightsidebar = getRightSidebar($catid, 0);
	$categorieslisting = getCategoriesBlock($catid);

  eval('print_output("' . fetch_template('classifieds_main') . '");');
}

if($_REQUEST['do'] == 'subcategory') {
  $catid = $vbulletin->input->clean_gpc('r', 'catid', TYPE_UINT);
	$cat = $db->query_first("SELECT id, name FROM ".TABLE_PREFIX."classifieds_categories WHERE id=$catid");
  $subcatid = $vbulletin->input->clean_gpc('r', 'subcatid', TYPE_UINT);
	$subcat = $db->query_first("SELECT id, name FROM ".TABLE_PREFIX."classifieds_subcategories WHERE id=$subcatid");

	$title = sanitize_title($cat["name"]);
  $navbits = construct_navbits(array("classifieds.php?" . $vbulletin->session->vars['sessionurl'] => $vbulletin->options["classifieds_navbar"],
		"classifieds.php?do=category&catid=".$cat["id"]."&title=$title" => $cat["name"], "" => $subcat["name"]));
  $leftsidebar = getLeftSidebar($catid, $subcatid); 
  eval('$navbar = "' . fetch_template('navbar') . '";'); 
  $content = getAdBlock($catid, $subcatid);
	$featured = getFeaturedAds($catid, $subcatid);
	$rightsidebar = getRightSidebar($catid, $subcatid);

  eval('print_output("' . fetch_template('classifieds_main') . '");');
}

if($_REQUEST['do'] == 'userforsale') {
  $uid = $vbulletin->input->clean_gpc('r', 'userid', TYPE_UINT);
	$user = $db->query_first("SELECT username FROM ".TABLE_PREFIX."user WHERE userid=$uid");
	if(!$user)
		print_no_permission();
		
  $navbits = construct_navbits(array("classifieds.php?" . $vbulletin->session->vars['sessionurl'] => $vbulletin->options["classifieds_navbar"],
		"" => $user["username"]));
  $leftsidebar = getLeftSidebar(0, 0); 
  eval('$navbar = "' . fetch_template('navbar') . '";'); 
  $content = getAdBlock(0, 0, $uid);
	$rightsidebar = getRightSidebar(0, 0);

  eval('print_output("' . fetch_template('classifieds_main') . '");');
}

if($_REQUEST['do'] == 'editad') {
  $adid = $vbulletin->input->clean_gpc('r', 'adid', TYPE_UINT);
  $catid = $vbulletin->input->clean_gpc('r', 'catid', TYPE_UINT);
  $subcatid = $vbulletin->input->clean_gpc('r', 'subcatid', TYPE_UINT);
  $return = $vbulletin->input->clean_gpc('r', 'return', TYPE_STR);
  $canmod = $permissions['classifieds'] & $vbulletin->bf_ugp['classifieds']['canmod'];
	$canmoveads = $vbulletin->options['classifieds_moderatorcanmoveads'];
	$userscanmoveads = $vbulletin->options['classifieds_everybodycanmoveads'];

  if($adid == 0) {
	  if(!($permissions['classifieds'] & $vbulletin->bf_ugp['classifieds']['canadd']))
      print_no_permission();

		if($catid == 0) {
			$firstcat = $db->query_first("SELECT id FROM ".TABLE_PREFIX."classifieds_categories ORDER BY displayorder LIMIT 1");
			if($firstcat)
				$catid = $firstcat["id"];
		}

    $ad["id"] = 0;
    $ad["categoryid"] = $catid;
		$ad["subcategoryid"] = $subcatid;
    $ad["title"] = "";
    $ad["description"] = "";
    $ad["photoname"] = "";
    $ad["paypalemail"] = "";
    $ad["price"] = "";
    $ad["hidden"] = 0;
    $ad["private"] = 0;
		$ad["active"] = 0;
		$ad['publishdate'] = time();
		$ad['expirationdate'] = 0;
		$ad["currency"] = $vbulletin->options["classifieds_currency"];
  } else {
	  if(!($permissions['classifieds'] & $vbulletin->bf_ugp['classifieds']['canedit']))
			print_no_permission();
			
		if($canmod)
    	$ad = $db->query_first("SELECT * FROM ".TABLE_PREFIX."classifieds_ads WHERE id=$adid");
		else
    	$ad = $db->query_first("SELECT * FROM ".TABLE_PREFIX."classifieds_ads WHERE id=$adid AND userid=$userid");
		
    if(!$ad)
      print_no_permission();
  }

  $navbits = construct_navbits(array("classifieds.php?" . $vbulletin->session->vars['sessionurl'] => $vbulletin->options["classifieds_navbar"],
		"" => $vbphrase["classifieds_editad"]));
  $leftsidebar = '';
  eval('$navbar = "' . fetch_template('navbar') . '";'); 
	$rightsidebar = "";

	$jscode = dependentcombojs(true, $vbphrase["classifieds_none"]);
  $categories = getCategoriesOptions($ad["categoryid"], false);
	$subcategories = getSubcategoriesOptions($ad["categoryid"], $ad["subcategoryid"], true);
	$pictures = getAdPictures($ad["id"]);
  $pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_UINT);
	$extrafields = renderExtraFields($ad["categoryid"], $ad["subcategoryid"], $ad["id"]);
	$currency = $ad["currency"];
	$allowtitlechange = $vbulletin->options["classifieds_titlechange"];

	$firstdayofweek = $vbulletin->options["classifieds_firstdayofweek"];
	$dateformat = $vbulletin->options["classifieds_inputdateformat"];
	if($ad['publishdate'] == 0) {
		$ad['publishdate'] = '';
		$ad['publishhour'] = 0;
		$ad['publishminute'] = 0;
	} else
		list($ad['publishdate'], $ad['publishhour'], $ad['publishminute']) = expandDate($ad['publishdate']);
	$publishhour = getNumbers(0, 23, $ad['publishhour']);
	$publishminute = getNumbers(0, 59, $ad['publishminute']);
	if($ad['expirationdate'] == 0) {
		$ad['expirationdate'] = '';
		$ad['expirationhour'] = 0;
		$ad['expirationminute'] = 0;
	} else
		list($ad['expirationdate'], $ad['expirationhour'], $ad['expirationminute']) = expandDate($ad['expirationdate']);
	$expirationhour = getNumbers(0, 23, $ad['expirationhour']);
	$expirationminute = getNumbers(0, 59, $ad['expirationminute']);

	if(empty($vbulletin->bbcodecache)) $vbulletin->bbcodecache = array();
	$show['wysiwyg'] = ($vbulletin->options['allow_bbcode'] ? is_wysiwyg_compatible() : 0);
	$istyles_js = construct_editor_styles_js();
	$show['qr_require_click'] = 0;
	$editorid = construct_edit_toolbar($ad["description"], 0, '', 1, 1, false, 'fe');
	$messagearea = "
		<script type=\"text/javascript\">
		<!--
			var require_click = false;
			var threaded_mode = 1;
			var is_last_page = false;
		// -->
		</script>
		$messagearea
	";

	eval('$content = "' . fetch_template('classifieds_editad') . '";');
	eval('print_output("' . fetch_template('classifieds_main') . '");');
}

if($_REQUEST['do'] == 'savead') {
  $adid = $vbulletin->input->clean_gpc('r', 'adid', TYPE_UINT);
  $return = $vbulletin->input->clean_gpc('r', 'return', TYPE_STR);
  $canmod = $permissions['classifieds'] & $vbulletin->bf_ugp['classifieds']['canmod'];
	$canmoveads = $vbulletin->options['classifieds_moderatorcanmoveads'];
	$userscanmoveads = $vbulletin->options['classifieds_everybodycanmoveads'];

  if($adid == 0) {
	  if(!($permissions['classifieds'] & $vbulletin->bf_ugp['classifieds']['canadd']))
      print_no_permission();
  } else {
	  if(!($permissions['classifieds'] & $vbulletin->bf_ugp['classifieds']['canedit'] || $canmod))
			print_no_permission();
			
		if($canmod)
    	$ad = $db->query_first("SELECT * FROM ".TABLE_PREFIX."classifieds_ads WHERE id=$adid");
		else
    	$ad = $db->query_first("SELECT * FROM ".TABLE_PREFIX."classifieds_ads WHERE id=$adid AND userid=$userid");
    if(!$ad)
      print_no_permission();
  }

	$vbulletin->input->clean_array_gpc('p', array(
		'wysiwyg'     => TYPE_BOOL,
		'message'			=> TYPE_STR,
		'catid'				=> TYPE_UINT,
		'subcatid'		=> TYPE_UINT,
		'title'				=> TYPE_STR,
		'paypalemail' => TYPE_STR,
		'price'				=> TYPE_STR,
		'currency'		=> TYPE_UINT,
		'hidden'			=> TYPE_UINT,
		'publishdate' => TYPE_STR,
		'publishhour' => TYPE_UINT,
		'publishminute' => TYPE_UINT,
		'expirationdate' => TYPE_STR,
		'expirationhour' => TYPE_UINT,
		'expirationminute' => TYPE_UINT,
		'titlephoto' => TYPE_UINT
	));
  if($vbulletin->GPC['wysiwyg']) {
		$description = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message']);
  } else {
  	$description = $vbulletin->GPC['message'];
  }
	$description = $db->escape_string($description);
	if(strlen($description) > $vbulletin->options['classifieds_maxcharsperad']) {
		$description = substr($description, 0, $vbulletin->options['classifieds_maxcharsperad']);
	}
	$catid = $vbulletin->GPC['catid'];
	$subcatid = $vbulletin->GPC['subcatid'];
	$title = $db->escape_string($vbulletin->GPC['title']);
  if(empty($title))
    $title = 'Untitled';
  $paypalemail = $db->escape_string($vbulletin->GPC['paypalemail']);
  $price = $db->escape_string($vbulletin->GPC['price']);
  $currency = $vbulletin->GPC['currency'] == 0 ? $vbulletin->options["classifieds_currency"] : $vbulletin->GPC['currency'];
	$hidden = $vbulletin->GPC['hidden'];
	$titlephoto = $vbulletin->GPC['titlephoto'];
	
	$nums = explode('/', $vbulletin->GPC['publishdate']);
	if(count($nums) == 3)
		if($vbulletin->options["classifieds_inputdateformat"] == 1)
			$publishdate = mktime($vbulletin->GPC['publishhour'], $vbulletin->GPC['publishminute'], 0, intval($nums[1]), intval($nums[0]), intval($nums[2]));
		else
			$publishdate = mktime($vbulletin->GPC['publishhour'], $vbulletin->GPC['publishminute'], 0, intval($nums[0]), intval($nums[1]), intval($nums[2]));
	else
		$publishdate = 0;
	$nums = explode('/', $vbulletin->GPC['expirationdate']);
	if(count($nums) == 3)
		if($vbulletin->options["classifieds_inputdateformat"] == 1)
			$expirationdate = mktime($vbulletin->GPC['expirationhour'], $vbulletin->GPC['expirationminute'], 0, intval($nums[1]), intval($nums[0]), intval($nums[2]));
		else
			$expirationdate = mktime($vbulletin->GPC['expirationhour'], $vbulletin->GPC['expirationminute'], 0, intval($nums[0]), intval($nums[1]), intval($nums[2]));
	else
		$expirationdate = 0;
	$expdays = getExpirationDays($catid, $subcatid);
	if($expdays != 0) {
		$exp = $publishdate + 60*60*24*$expdays; 
		if($expirationdate > $exp || $expirationdate == 0)
			$expirationdate = $exp;
	}

  if($adid != 0) {
		$newad = false;
		$ad = $db->query_first("SELECT active, userid FROM ".TABLE_PREFIX."classifieds_ads WHERE id=$adid");
		$catset = '';
		if($ad["active"] == 0 || ($canmod && $canmoveads) || $userscanmoveads)
			$catset = ", categoryid=$catid, subcategoryid=$subcatid";
		$allowtitlechange = $vbulletin->options["classifieds_titlechange"];
		$titleset = '';
		if($allowtitlechange || $ad["active"] == 0)
			$titleset = ", title='$title'";
    $db->query_write("UPDATE ".TABLE_PREFIX."classifieds_ads SET description='$description', paypalemail='$paypalemail',
										 price='$price', currency=$currency, hidden=$hidden, publishdate=$publishdate,
										 expirationdate=$expirationdate $catset $titleset
                     WHERE id=$adid");
  } else {
		$newad = true;
		if($subcatid != 0)
			$adprice = $db->query_first("SELECT adprice FROM ".TABLE_PREFIX."classifieds_subcategories WHERE id=$subcatid");
		else
			$adprice = $db->query_first("SELECT adprice FROM ".TABLE_PREFIX."classifieds_categories WHERE id=$catid");
		$active = 0;
		if($adprice["adprice"] == 0 || empty($adprice["adprice"])) {
			if(intval($vbulletin->options["classifieds_approvefree"]) == 1)
				$approved = 0;
			else
				$approved = 1;
			$active = $userscanmoveads == 1 ? 1 : 0;
		} else {
			if(intval($vbulletin->options["classifieds_approvepaid"]) == 1)
				$approved = 0;
			else
				$approved = 1;
		}
		
		$maxfeatured = $permissions['maxfeaturedads'];
		$cnt = $db->query_first("SELECT COUNT(id) AS cnt FROM ".TABLE_PREFIX."classifieds_ads WHERE userid=$userid AND featured=1");
		$featured = 0; 
		if($cnt["cnt"] < $maxfeatured && $maxfeatured > 0)
			$featured = 1;
		if($cnt["cnt"] >= $maxfeatured && $maxfeatured > 0) { 
			$last = $db->query_first("SELECT id FROM ".TABLE_PREFIX."classifieds_ads WHERE userid=$userid AND featured=1 ORDER BY id ASC");
			if($last) {
				$db->query_write("UPDATE ".TABLE_PREFIX."classifieds_ads SET featured=0 WHERE id=".$last["id"]);
				$featured = 1;
			}
		}

		$maxbold = $permissions['maxboldads'];
		$cnt = $db->query_first("SELECT COUNT(id) AS cnt FROM ".TABLE_PREFIX."classifieds_ads WHERE userid=$userid AND bold=1");
		$bold = 0; 
		if($cnt["cnt"] < $maxbold && $maxbold > 0)
			$bold = 1;
		if($cnt["cnt"] >= $maxbold && $maxbold > 0) { 
			$last = $db->query_first("SELECT id FROM ".TABLE_PREFIX."classifieds_ads WHERE userid=$userid AND bold=1 ORDER BY id ASC");
			if($last) {
				$db->query_write("UPDATE ".TABLE_PREFIX."classifieds_ads SET bold=0 WHERE id=".$last["id"]);
				$bold = 1;
			}
		}

		$now = time();
    $db->query_write("INSERT INTO ".TABLE_PREFIX."classifieds_ads (id, categoryid, subcategoryid, userid,
                     title, description, paypalemail, price, active, currency, hidden, approved, activateddate,
										 featured, editor, bold, publishdate, expirationdate) VALUES (NULL, $catid, $subcatid, $userid, 
											'$title', '$description', '$paypalemail', '$price', $active, $currency, $hidden, $approved, $now, 
											$featured, 0, $bold, $publishdate, $expirationdate)");
		$adid = $db->insert_id();
  }

	$fields = $_REQUEST["field"];
	$savedfields = array();
	if(!empty($fields)) {
		foreach($fields as $key => $value) {
			list($type, $fieldid) = split('_', $key);
			saveField(intval($fieldid), $value, $adid);
			$savedfields[] = $fieldid;
		}
	}
	$where = "WHERE categoryid=$catid ";
	if(!($subcatid == 0 || $subcatid == -1))
		$where .= "AND subcategoryid=$subcatid ";
	else
		$where .= "AND subcategoryid=0 ";
	$fields = $db->query_read("
		SELECT ".TABLE_PREFIX."classifieds_fields.id
		FROM ".TABLE_PREFIX."classifieds_fieldgroup_category
		JOIN ".TABLE_PREFIX."classifieds_field_group
			ON ".TABLE_PREFIX."classifieds_field_group.groupid=".TABLE_PREFIX."classifieds_fieldgroup_category.groupid
		JOIN ".TABLE_PREFIX."classifieds_fields
			ON ".TABLE_PREFIX."classifieds_fields.id=".TABLE_PREFIX."classifieds_field_group.fieldid
		$where
	");
	while($field = $db->fetch_array($fields)) {
		if(!in_array($field["id"], $savedfields))
			$db->query_write("DELETE FROM ".TABLE_PREFIX."classifieds_fieldvalues WHERE adid=$adid AND fieldid=".$field["id"]);
	}


	$maxphotos = $permissions['maxphotosads'];
	$cnt = $db->query_first("
		SELECT COUNT(".TABLE_PREFIX."classifieds_photos.id) AS cnt
		FROM ".TABLE_PREFIX."classifieds_photos
		JOIN ".TABLE_PREFIX."classifieds_ads
			ON ".TABLE_PREFIX."classifieds_ads.id=".TABLE_PREFIX."classifieds_photos.adid
		WHERE userid=$userid");
	$upload = 0; 
	if($cnt["cnt"] < $maxphotos && $maxphotos > 0)
		$upload = 1;
	
  $filename = "";
	$notuploaded = 0;
  if(!empty($_FILES["photo"]["name"]) && $_FILES["photo"]["error"] == UPLOAD_ERR_OK) {
		if($upload)
    	$filename = processUploadedPhoto($_FILES["photo"]["tmp_name"], $_FILES["photo"]["name"], '',
                                     $vbulletin->options["classifieds_picwidth"], $vbulletin->options["classifieds_picheight"],
                                     $vbulletin->options["classifieds_thumbwidth"], $vbulletin->options["classifieds_thumbheight"]);
		else
			$notuploaded = 1;
  }
	if(!empty($filename)) {
		$db->query_write("INSERT INTO ".TABLE_PREFIX."classifieds_photos (id, adid, photoname) VALUES (NULL, $adid, '$filename')");
	}

	$delete = $_POST["delete"];
	if(!empty($delete)) {
		foreach(array_keys($delete) as $key) {
			$db->query_write("DELETE FROM ".TABLE_PREFIX."classifieds_photos WHERE adid=$adid AND id=".intval($key));
		}
	}
	
	if($titlephoto != 0) {
		$db->query_write("UPDATE ".TABLE_PREFIX."classifieds_photos SET istitlephoto=0 WHERE adid=$adid");
		$db->query_write("UPDATE ".TABLE_PREFIX."classifieds_photos SET istitlephoto=1 WHERE adid=$adid AND id=$titlephoto");
	}
	  
  $pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_UINT);
	if($return == 'ad')
		$vbulletin->url = "classifieds.php?do=showad&adid=$adid";
	else
  	$vbulletin->url = "classifieds.php?do=myads&page=$pagenumber&notuploaded=$notuploaded";
  standard_redirect();
}

if($_REQUEST['do'] == 'deletead') {
  if(!($permissions['classifieds'] & $vbulletin->bf_ugp['classifieds']['candelete']))
		print_no_permissions();

  $canmod = $permissions['classifieds'] & $vbulletin->bf_ugp['classifieds']['canmod'];
  $adid = $vbulletin->input->clean_gpc('r', 'adid', TYPE_UINT);
	if($canmod)
		$db->query_write("DELETE FROM ".TABLE_PREFIX."classifieds_ads WHERE id=$adid");
	else
		$db->query_write("DELETE FROM ".TABLE_PREFIX."classifieds_ads WHERE userid=$userid AND id=$adid");

  $vbulletin->url = "classifieds.php?do=myads&page=".$_REQUEST['pagenumber'];
  standard_redirect();
}

if($_REQUEST['do'] == 'myads') {
  $pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_UINT);
  $notuploaded = $vbulletin->input->clean_gpc('r', 'notuploaded', TYPE_UINT);
  $recperpage = 10;
  $canmod = $permissions['classifieds'] & $vbulletin->bf_ugp['classifieds']['canmod'];

  $totalrecords = $db->query_first("
    SELECT COUNT(*) AS totalrecords
    FROM ".TABLE_PREFIX."classifieds_ads
		WHERE userid=$userid
	");
  
  sanitize_pageresults($totalrecords['totalrecords'], $pagenumber, $recperpage, $recperpage, $recperpage);
  $limitlower = ($pagenumber - 1) * $recperpage + 1;
  $limitupper = $pagenumber * $recperpage;
  if($limitupper > $totalrecords['totalrecords']) {
    $limitupper = $totalrecords['totalrecords'];
    if($limitlower > $totalrecords['totalrecords'])
      $limitlower = $totalrecords['totalrecords'] - $recperpage;
  }
  if($limitlower <= 0) {
     $limitlower = 1;
  }

	$ads = $db->query_read("
		SELECT ".TABLE_PREFIX."classifieds_ads.*, ".TABLE_PREFIX."classifieds_categories.name AS catname,
			".TABLE_PREFIX."classifieds_subcategories.name AS subcatname
		FROM ".TABLE_PREFIX."classifieds_ads
		JOIN ".TABLE_PREFIX."classifieds_categories
			ON ".TABLE_PREFIX."classifieds_categories.id=".TABLE_PREFIX."classifieds_ads.categoryid
		LEFT JOIN ".TABLE_PREFIX."classifieds_subcategories
			ON ".TABLE_PREFIX."classifieds_subcategories.id=".TABLE_PREFIX."classifieds_ads.subcategoryid
		WHERE userid=$userid
		ORDER BY active DESC, ".TABLE_PREFIX."classifieds_ads.id DESC
		LIMIT " . ($limitlower - 1) . ", $recperpage
	");
  $pagenav = construct_page_nav($pagenumber, $recperpage, $totalrecords['totalrecords'], "classifieds.php?" . $vbulletin->session->vars['sessionurl'] . "do=myads");
	$classifieds = '';
	while($ad = $db->fetch_array($ads)) {
		$photo = $db->query_first("SELECT photoname FROM ".TABLE_PREFIX."classifieds_photos WHERE adid=".$ad["id"]." AND istitlephoto=1");
		if(!$photo)
			$photo = $db->query_first("SELECT photoname FROM ".TABLE_PREFIX."classifieds_photos WHERE adid=".$ad["id"]);
		if($photo)
			$ad["photoname"] = $photo["photoname"];
		else
			$ad["photoname"] = '';
		$ad["description"] = parseBbCode($ad["description"], $vbulletin->options["classifieds_maxchars"]);
		$ad["currency"] = getCurrency($ad["currency"]);
		if($ad["subcategoryid"] != 0)
			$price = $db->query_first("SELECT adprice FROM ".TABLE_PREFIX."classifieds_subcategories WHERE id=".$ad["subcategoryid"]);
		else
			$price = $db->query_first("SELECT adprice FROM ".TABLE_PREFIX."classifieds_categories WHERE id=".$ad["categoryid"]);
		$price = $price["adprice"]; 
		$title = sanitize_title($ad["title"]);
		eval('$classifieds .= "' . fetch_template('classifieds_myad') . '";');
	}

  $navbits = construct_navbits(array("classifieds.php?" . $vbulletin->session->vars['sessionurl'] => $vbulletin->options["classifieds_navbar"],
		"" => $vbphrase["classifieds_myclassifieds"]));
  $leftsidebar = getLeftSidebar(0, 0); 
  eval('$navbar = "' . fetch_template('navbar') . '";'); 
	$rightsidebar = "";
	
	eval('$content = "' . fetch_template('classifieds_myads') . '";');
	eval('print_output("' . fetch_template('classifieds_main') . '");');
}

if($_REQUEST['do'] == 'showad') {
  $adid = $vbulletin->input->clean_gpc('r', 'adid', TYPE_UINT);
	$canmod = ($permissions['classifieds'] & $vbulletin->bf_ugp['classifieds']['canmod']);

	$now = time();
	$where = "AND ((active=1 AND hidden=0 AND approved=1 AND publishdate<=$now AND (expirationdate=0 OR expirationdate>$now)) OR (".TABLE_PREFIX."classifieds_ads.userid=$userid))";
	if($permissions['classifieds'] & $vbulletin->bf_ugp['classifieds']['canmod'])
		$where = '';

	$ad = $db->query_first("
		SELECT ".TABLE_PREFIX."classifieds_ads.*, ".TABLE_PREFIX."classifieds_categories.name AS catname,
			".TABLE_PREFIX."classifieds_subcategories.name AS subcatname, ".TABLE_PREFIX."user.username
		FROM ".TABLE_PREFIX."classifieds_ads
		JOIN ".TABLE_PREFIX."classifieds_categories
			ON ".TABLE_PREFIX."classifieds_categories.id=".TABLE_PREFIX."classifieds_ads.categoryid
		LEFT JOIN ".TABLE_PREFIX."classifieds_subcategories
			ON ".TABLE_PREFIX."classifieds_subcategories.id=".TABLE_PREFIX."classifieds_ads.subcategoryid
		JOIN ".TABLE_PREFIX."user
			ON ".TABLE_PREFIX."user.userid=".TABLE_PREFIX."classifieds_ads.userid
		WHERE ".TABLE_PREFIX."classifieds_ads.id=$adid $where
	");
	if(!$ad)
		print_no_permission();

	$visits = $db->query_first("SELECT SUM(count) AS cnt FROM ".TABLE_PREFIX."classifieds_visits WHERE id=$adid GROUP BY id");
	$ad["viewcount"] = $visits["cnt"];
	if(empty($ad["viewcount"]))
		$ad["viewcount"] = 0;

	recordVisit($userid, $adid);

	$photo = $db->query_first("SELECT id, photoname FROM ".TABLE_PREFIX."classifieds_photos WHERE adid=".$ad["id"]." AND istitlephoto=1");
	if(!$photo)
		$photo = $db->query_first("SELECT id, photoname FROM ".TABLE_PREFIX."classifieds_photos WHERE adid=".$ad["id"]);
	if($photo) {
		$ad["photoname"] = $photo["photoname"];
  } else {
		$ad["photoname"] = '';
	}
	$ad["description"] = parseBbCode($ad["description"]);
	$ad["currency"] = getCurrency($ad["currency"]);
	
	$pictures = '';
	$pics = $db->query_read("SELECT photoname FROM ".TABLE_PREFIX."classifieds_photos WHERE adid=".$ad["id"]);
	$cols = $vbulletin->options["classifieds_gallery_columns"];
	$count = 0;
	$col = 0;
	$pictures = '<table>';
	while($pic = $db->fetch_array($pics)) {
		if($col == 0)
			$pictures .= '<tr>';
			
		$pictures .= '<td><a href="classifieds/photos/'.$pic["photoname"].'" rel="thumbnail" title="">
											<img border="0" src="classifieds/photos/thumbs/'.$pic["photoname"].'" /></a></td>';
		
		$col++;
		if($col == $cols) {
			$pictures .= '</tr>';
			$col = 0;
		}
		$count++;
	}
	if($col > 0 && $count > 0)
		$pictures .= '</tr>';
	$pictures .= '</table>';
	
	$bookmarked = false;
	$bad = $db->query_first("SELECT id FROM ".TABLE_PREFIX."classifieds_bookmarks WHERE adid=$adid AND userid=$userid");
	if($bad)
		$bookmarked = true;

  $navbits = construct_navbits(array("classifieds.php?" . $vbulletin->session->vars['sessionurl'] => $vbulletin->options["classifieds_navbar"],
		"" => $ad["title"]));
  $leftsidebar = getLeftSidebar(0, 0); 
  eval('$navbar = "' . fetch_template('navbar') . '";'); 
	$rightsidebar = getRightSidebar(0, 0);
	$extrafields = showExtraFields($ad); 
	$print = 0;
	$username = sanitize_title($ad["username"]);
	$title = sanitize_title($ad["title"]);
	
	eval('$content = "' . fetch_template('classifieds_showad') . '";');
	eval('print_output("' . fetch_template('classifieds_main') . '");');
}

if($_REQUEST['do'] == 'viewreviews') {
  $uid = $vbulletin->input->clean_gpc('r', 'userid', TYPE_UINT);
	$user = $db->query_first("SELECT * FROM ".TABLE_PREFIX."user WHERE userid=$uid");
	if(!$user)
		print_no_permission();
		
	$revs = $db->query_read("
		SELECT ".TABLE_PREFIX."classifieds_reviews.*, ".TABLE_PREFIX."user.username
		FROM ".TABLE_PREFIX."classifieds_reviews
		JOIN ".TABLE_PREFIX."user
			ON ".TABLE_PREFIX."user.userid=".TABLE_PREFIX."classifieds_reviews.reviewerid
		WHERE ".TABLE_PREFIX."classifieds_reviews.userid=$uid
	");
	$reviews = '';
	while($review = $db->fetch_array($revs)) {
		$rating = getRatingImg($review["rating"]);
		eval('$reviews .= "' . fetch_template('classifieds_review') . '";');
	}
	
  $navbits = construct_navbits(array("classifieds.php?" . $vbulletin->session->vars['sessionurl'] => $vbulletin->options["classifieds_navbar"],
		"" => $vbphrase["classifieds_userreviews"], "" => $user["username"]));
  $leftsidebar = getLeftSidebar(0, 0); 
  eval('$navbar = "' . fetch_template('navbar') . '";'); 
	$rightsidebar = getRightSidebar(0, 0);
	
	if($userid != $uid) {
		$mytrans = $db->query_first("
			SELECT ".TABLE_PREFIX."classifieds_payments.id
			FROM ".TABLE_PREFIX."classifieds_payments
			JOIN ".TABLE_PREFIX."classifieds_ads
				ON ".TABLE_PREFIX."classifieds_ads.id=".TABLE_PREFIX."classifieds_payments.adid
			WHERE ".TABLE_PREFIX."classifieds_payments.userid=$userid AND ".TABLE_PREFIX."classifieds_ads.userid=$uid
		");
	}

	eval('$content = "' . fetch_template('classifieds_reviews') . '";');
	eval('print_output("' . fetch_template('classifieds_main') . '");');
}

if($_REQUEST['do'] == 'newreview') {
  $uid = $vbulletin->input->clean_gpc('r', 'userid', TYPE_UINT);
	$user = $db->query_first("SELECT * FROM ".TABLE_PREFIX."user WHERE userid=$uid");
	if(!$user)
		print_no_permission();

	if($userid != $uid) {
		$mytrans = $db->query_first("
			SELECT ".TABLE_PREFIX."classifieds_payments.id
			FROM ".TABLE_PREFIX."classifieds_payments
			JOIN ".TABLE_PREFIX."classifieds_ads
				ON ".TABLE_PREFIX."classifieds_ads.id=".TABLE_PREFIX."classifieds_payments.adid
			WHERE ".TABLE_PREFIX."classifieds_payments.userid=$userid AND ".TABLE_PREFIX."classifieds_ads.userid=$uid
		");
		if(!$mytrans)
			print_no_permission();
	} else
		print_no_permission();

  $navbits = construct_navbits(array("classifieds.php?" . $vbulletin->session->vars['sessionurl'] => $vbulletin->options["classifieds_navbar"],
		"" => $vbphrase["classifieds_newreview"], "" => $user["username"]));
  $leftsidebar = getLeftSidebar(0, 0); 
  eval('$navbar = "' . fetch_template('navbar') . '";'); 
	$rightsidebar = getRightSidebar(0, 0);

	eval('$content = "' . fetch_template('classifieds_newreview') . '";');
	eval('print_output("' . fetch_template('classifieds_main') . '");');
}

if($_REQUEST['do'] == 'savereview') {
  $uid = $vbulletin->input->clean_gpc('r', 'userid', TYPE_UINT);

	if($userid != $uid) {
		$mytrans = $db->query_first("
			SELECT ".TABLE_PREFIX."classifieds_payments.id
			FROM ".TABLE_PREFIX."classifieds_payments
			JOIN ".TABLE_PREFIX."classifieds_ads
				ON ".TABLE_PREFIX."classifieds_ads.id=".TABLE_PREFIX."classifieds_payments.adid
			WHERE ".TABLE_PREFIX."classifieds_payments.userid=$userid AND ".TABLE_PREFIX."classifieds_ads.userid=$uid
		");
		if(!$mytrans)
			print_no_permission();
	} else
		print_no_permission();

  $opinion = $vbulletin->input->clean_gpc('r', 'opinion', TYPE_STR);
	$opinion = $db->escape_string($opinion);
  $rating = $vbulletin->input->clean_gpc('r', 'rating', TYPE_UINT);
	$db->query_write("INSERT INTO ".TABLE_PREFIX."classifieds_reviews (id, userid, reviewerid, text, rating)
		VALUES (NULL, $uid, $userid, '$opinion', $rating)");

  $vbulletin->url = "classifieds.php?do=viewreviews&userid=$uid";
  standard_redirect();
}

if($_REQUEST['do'] == 'payad') {
  $adid = $vbulletin->input->clean_gpc('r', 'adid', TYPE_UINT);

	$ad = $db->query_first("SELECT categoryid, subcategoryid, title FROM ".TABLE_PREFIX."classifieds_ads WHERE id=$adid");
	if(!$ad)
		print_no_permission();
	if($ad["subcategoryid"] != 0)
		$price = $db->query_first("SELECT adprice FROM ".TABLE_PREFIX."classifieds_subcategories WHERE id=".$ad["subcategoryid"]);
	else
		$price = $db->query_first("SELECT adprice FROM ".TABLE_PREFIX."classifieds_categories WHERE id=".$ad["categoryid"]);
	$price = $price["adprice"]; 
  $testingmode = $vbulletin->options["classifieds_paypaltesting"];
  $paypalemailaddress = $vbulletin->options["classifieds_paypalemail"];
	$currency = getCurrency();
  $transid = md5(rand());

	$db->query_write("INSERT INTO ".TABLE_PREFIX."classifieds_adpayments (id, adid, transid, paid) VALUES
		(NULL, $adid, '$transid', 0)");
	
  $vbulletin->url = paymentUrlPayPal($vbphrase["classifieds_classified"].$ad["title"], 1, $price, 0, 0, 0, $currency,
          $paypalemailaddress, $transid, $vbulletin->options['bburl'] . "/classifieds.php?do=myads", true,
          $testingmode, 'ad'); 
  standard_redirect();
}

if($_REQUEST['do'] == 'buy') {
  $adid = $vbulletin->input->clean_gpc('r', 'adid', TYPE_UINT);
	$now = time();
  $ad = $db->query_first("
    SELECT * FROM ".TABLE_PREFIX."classifieds_ads
    WHERE ".TABLE_PREFIX."classifieds_ads.id=$adid AND active=1 AND hidden=0 AND approved=1
			AND publishdate<=$now AND (expirationdate=0 OR expirationdate>$now)");
  if(!$ad)
    print_no_permission();
	if($userid == 0)
    eval(standard_error(fetch_error('classifieds_registertobuy', $ext)));

  if(intval($_REQUEST["empty"]) == 1) {
    $count = $_REQUEST["count"];
    $email = $_REQUEST["email"];
    $name = $_REQUEST["name"];
    $address1 = $_REQUEST["address1"];
    $address2 = $_REQUEST["address2"];
    $city = $_REQUEST["city"];
    $state = $_REQUEST["state"];
    $zip = $_REQUEST["zip"];
    $country = $_REQUEST["country"];
    $message = $_REQUEST["message"];
    $empty = 1;
  } else {
    $empty = 0;
    $count = 1;
    $email = $userid = $vbulletin->userinfo['email'];

	  $addressid = $vbulletin->input->clean_gpc('c', COOKIE_PREFIX."classifiedsaddress", TYPE_STR);
		$addressid = $db->escape_string($addressid);
    $address = $db->query_first("SELECT * FROM ".TABLE_PREFIX."classifieds_addresses WHERE id='$addressid'");
    if($address) {
      $email = $address["email"];
      $name = $address["name"];
      $address1 = $address["address1"];
      $address2 = $address["address2"];
      $city = $address["city"];
      $state = $address["state"];
      $zip = $address["zip"];
      $country = $address["country"];
    }
  }
	
	$title = sanitize_title($ad["title"]);
  $navbits = construct_navbits(array("classifieds.php?" . $vbulletin->session->vars['sessionurl'] => $vbulletin->options["classifieds_navbar"],
		"classifieds.php?do=showad&adid=$adid&title=$title" => $ad["title"], "" => $vbphrase["classifieds_buyitem"]));
  $leftsidebar = getLeftSidebar(0, 0); 
  eval('$navbar = "' . fetch_template('navbar') . '";'); 
	$rightsidebar = getRightSidebar(0, 0);
  
  ob_start();
  include('classifieds/includes/countries.inc.php');
  $countryoptions = ob_get_contents();
  ob_end_clean();

  eval('$content = "' . fetch_template('classifieds_buyitem') . '";');
  eval('print_output("' . fetch_template('classifieds_main') . '");');
}

if($_REQUEST['do'] == 'pay') {
  $adid = $vbulletin->input->clean_gpc('r', 'adid', TYPE_UINT);
	$now = time();
  $ad = $db->query_first("
    SELECT * FROM ".TABLE_PREFIX."classifieds_ads
    WHERE ".TABLE_PREFIX."classifieds_ads.id=$adid AND active=1 AND hidden=0 AND approved=1
			AND publishdate<=$now AND (expirationdate=0 OR expirationdate>$now)");
  if(!$ad)
    print_no_permission();
	if($userid == 0)
    eval(standard_error(fetch_error('classifieds_registertobuy', $ext)));

  $count = 1;
	$vbulletin->input->clean_array_gpc('p', array(
		'email' 	    => TYPE_STR,
		'name'				=> TYPE_STR,
		'address1'		=> TYPE_STR,
		'address2'		=> TYPE_STR,
		'city'				=> TYPE_STR,
		'state'				=> TYPE_STR,
		'zip'					=> TYPE_STR,
		'country'			=> TYPE_STR,
		'message'			=> TYPE_STR
	));
  $email = $db->escape_string($vbulletin->GPC['email']);
  $name = $db->escape_string($vbulletin->GPC['name']);
  $address1 = $db->escape_string($vbulletin->GPC['address1']);
  $address2 = $db->escape_string($vbulletin->GPC['address2']);
  $city = $db->escape_string($vbulletin->GPC['city']);
  $state = $db->escape_string($vbulletin->GPC['state']);
  $zip = $db->escape_string($vbulletin->GPC['zip']);
  $country = $db->escape_string($vbulletin->GPC['country']);
  $message = $db->escape_string($vbulletin->GPC['message']);
  
  if($count < 1 || empty($name) || empty($address1) || empty($address1) ||
     empty($city) || empty($state) || empty($zip) || empty($country) || empty($email)) {
    $vbulletin->url = "classifieds.php?do=buy&adid=$adid&empty=1&count=$count&".
      "email=".urlencode($_REQUEST["email"])."&name=".urlencode($_REQUEST["name"]).
      "&address1=".urlencode($_REQUEST["address1"]).
      "&address2=".urlencode($_REQUEST["address2"])."&city=".urlencode($_REQUEST["city"]).
      "&state=".urlencode($_REQUEST["state"])."&zip=".urlencode($_REQUEST["zip"]).
      "&country=".urlencode($_REQUEST["country"])."&message=".urlencode($_REQUEST["message"]);
    standard_redirect();
  }
  
  $addressid = $vbulletin->input->clean_gpc('c', COOKIE_PREFIX."classifiedsaddress", TYPE_STR);
	$addressid = $db->escape_string($addressid);
  if(empty($addressid)) {
    $ip = split('.', $_SERVER['REMOTE_ADDR']);
    $addressid = md5(rand() + time() + intval($ip[0]) + intval($ip[1])*10 + intval($ip[2])*100 + intval($ip[3])*1000);
    vbsetcookie("classifiedsaddress", $addressid);
  }
  $address = $db->query_first("SELECT * FROM ".TABLE_PREFIX."classifieds_addresses WHERE id='$addressid'");
  if(!$address) {
    $db->query_write("INSERT INTO ".TABLE_PREFIX."classifieds_addresses (id, email, name, address1, address2, city, state,
                     zip, country) VALUES ('$addressid', '$email', '$name', '$address1', '$address2', '$city', '$state',
                     '$zip', '$country')");
  } else {
    $db->query_write("UPDATE ".TABLE_PREFIX."classifieds_addresses SET email='$email', name='$name', address1='$address1',
                     address2='$address2', city='$city', state='$state', zip='$zip', country='$country'
                     WHERE id='$addressid'");
  }
  
  $transid = md5(rand());
  $now = time();
  $db->query_write("INSERT INTO ".TABLE_PREFIX."classifieds_payments (id, adid, userid, transid, paid, addressid,
                   count, message, closed, date, email, name, address1, address2, city, state, zip, country)
                   VALUES (NULL, $adid, $userid, '$transid', 0, '$addressid', $count, '$message', 0, $now,
                   '$email', '$name', '$address1', '$address2', '$city', '$state', '$zip', '$country')");

  $amount = $ad["price"];
  $business = $ad["paypalemail"];
  $testingmode = $vbulletin->options["classifieds_paypaltesting"];
	$currency = getCurrency($ad["currency"]);

  $vbulletin->url = paymentUrlPayPal($ad["title"], 1, $amount, 0, 0, 0, $currency,
          $business, $transid, $vbulletin->options['bburl'] . "/classifieds.php?do=orders", true,
          $testingmode, 'buy'); 
  standard_redirect();
}

if($_REQUEST['do'] == 'orders') {
  $pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_UINT);
  $recperpage = 10;

  $totalrecords = $db->query_first("
    SELECT COUNT(*) AS totalrecords
    FROM ".TABLE_PREFIX."classifieds_payments
		WHERE ".TABLE_PREFIX."classifieds_payments.userid=$userid AND paid>0
	");

  sanitize_pageresults($totalrecords['totalrecords'], $pagenumber, $recperpage, $recperpage, $recperpage);
  $limitlower = ($pagenumber - 1) * $recperpage + 1;
  $limitupper = $pagenumber * $recperpage;
  if($limitupper > $totalrecords['totalrecords']) {
    $limitupper = $totalrecords['totalrecords'];
    if($limitlower > $totalrecords['totalrecords'])
      $limitlower = $totalrecords['totalrecords'] - $recperpage;
  }
  if($limitlower <= 0) {
     $limitlower = 1;
  }

	$ads = $db->query_read("
		SELECT ".TABLE_PREFIX."classifieds_ads.*, ".TABLE_PREFIX."classifieds_payments.closed,
			".TABLE_PREFIX."user.username, ".TABLE_PREFIX."user.userid AS sellerid
		FROM ".TABLE_PREFIX."classifieds_payments
		JOIN ".TABLE_PREFIX."classifieds_ads
			ON ".TABLE_PREFIX."classifieds_ads.id=".TABLE_PREFIX."classifieds_payments.adid
		JOIN ".TABLE_PREFIX."user
			ON ".TABLE_PREFIX."user.userid=".TABLE_PREFIX."classifieds_ads.userid
		WHERE ".TABLE_PREFIX."classifieds_payments.userid=$userid AND paid>0
		ORDER BY closed, ".TABLE_PREFIX."classifieds_ads.id DESC
		LIMIT " . ($limitlower - 1) . ", $recperpage
	"); 
  $pagenav = construct_page_nav($pagenumber, $recperpage, $totalrecords['totalrecords'], "classifieds.php?" . $vbulletin->session->vars['sessionurl'] . "do=orders");
	$classifieds = '';
	while($ad = $db->fetch_array($ads)) {
		$photo = $db->query_first("SELECT photoname FROM ".TABLE_PREFIX."classifieds_photos WHERE adid=".$ad["id"]." AND istitlephoto=1");
		if(!$photo)
			$photo = $db->query_first("SELECT photoname FROM ".TABLE_PREFIX."classifieds_photos WHERE adid=".$ad["id"]);
		if($photo)
			$ad["photoname"] = $photo["photoname"];
		else
			$ad["photoname"] = '';
		$ad["description"] = parseBbCode($ad["description"], $vbulletin->options["classifieds_maxchars"]);
		$ad["currency"] = getCurrency($ad["currency"]);
		$username = sanitize_title($ad["username"]);
		$title = sanitize_title($ad["title"]);
		eval('$classifieds .= "' . fetch_template('classifieds_myorder') . '";');
	}

  $navbits = construct_navbits(array("classifieds.php?" . $vbulletin->session->vars['sessionurl'] => $vbulletin->options["classifieds_navbar"],
		"" => $vbphrase["classifieds_myorders"]));
  $leftsidebar = getLeftSidebar(0, 0); 
  eval('$navbar = "' . fetch_template('navbar') . '";'); 
	$rightsidebar = "";
	
	eval('$content = "' . fetch_template('classifieds_myorders') . '";');
	eval('print_output("' . fetch_template('classifieds_main') . '");');
}

if($_REQUEST['do'] == 'sales') {
  $pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_UINT);
  $recperpage = 10;

  $totalrecords = $db->query_first("
    SELECT COUNT(*) AS totalrecords
    FROM ".TABLE_PREFIX."classifieds_payments
		JOIN ".TABLE_PREFIX."classifieds_ads
			ON ".TABLE_PREFIX."classifieds_ads.id=".TABLE_PREFIX."classifieds_payments.adid
		WHERE ".TABLE_PREFIX."classifieds_ads.userid=$userid AND paid>0
	");
  sanitize_pageresults($totalrecords['totalrecords'], $pagenumber, $recperpage, $recperpage, $recperpage);
  $limitlower = ($pagenumber - 1) * $recperpage + 1;
  $limitupper = $pagenumber * $recperpage;
  if($limitupper > $totalrecords['totalrecords']) {
    $limitupper = $totalrecords['totalrecords'];
    if($limitlower > $totalrecords['totalrecords'])
      $limitlower = $totalrecords['totalrecords'] - $recperpage;
  }
  if($limitlower <= 0) {
     $limitlower = 1;
  }

	$ads = $db->query_read("
		SELECT ".TABLE_PREFIX."classifieds_ads.*, ".TABLE_PREFIX."classifieds_payments.*, ".TABLE_PREFIX."classifieds_payments.id AS orderid,
			".TABLE_PREFIX."user.username, ".TABLE_PREFIX."user.userid AS buyerid,".TABLE_PREFIX."classifieds_ads.id AS id
		FROM ".TABLE_PREFIX."classifieds_payments
		JOIN ".TABLE_PREFIX."classifieds_ads
			ON ".TABLE_PREFIX."classifieds_ads.id=".TABLE_PREFIX."classifieds_payments.adid
		JOIN ".TABLE_PREFIX."user
			ON ".TABLE_PREFIX."user.userid=".TABLE_PREFIX."classifieds_payments.userid
		WHERE ".TABLE_PREFIX."classifieds_ads.userid=$userid AND paid>0
		ORDER BY closed
		LIMIT " . ($limitlower - 1) . ", $recperpage
	"); 
  $pagenav = construct_page_nav($pagenumber, $recperpage, $totalrecords['totalrecords'], "classifieds.php?" . $vbulletin->session->vars['sessionurl'] . "do=orders");
	$classifieds = '';
	while($ad = $db->fetch_array($ads)) {
		$photo = $db->query_first("SELECT photoname FROM ".TABLE_PREFIX."classifieds_photos WHERE adid=".$ad["id"]." AND istitlephoto=1");
		if(!$photo)
			$photo = $db->query_first("SELECT photoname FROM ".TABLE_PREFIX."classifieds_photos WHERE adid=".$ad["id"]);
		if($photo)
			$ad["photoname"] = $photo["photoname"];
		else
			$ad["photoname"] = '';
		$ad["date"] = vbcdate($ad["date"]);
		$ad["description"] = parseBbCode($ad["description"], $vbulletin->options["classifieds_maxchars"]);
		$ad["currency"] = getCurrency($ad["currency"]);
		$title = sanitize_title($ad["title"]);
		eval('$classifieds .= "' . fetch_template('classifieds_mysale') . '";');
	}

  $navbits = construct_navbits(array("classifieds.php?" . $vbulletin->session->vars['sessionurl'] => $vbulletin->options["classifieds_navbar"],
		"" => $vbphrase["classifieds_mysales"]));
  $leftsidebar = getLeftSidebar(0, 0); 
  eval('$navbar = "' . fetch_template('navbar') . '";'); 
	$rightsidebar = "";
	
	eval('$content = "' . fetch_template('classifieds_mysales') . '";');
	eval('print_output("' . fetch_template('classifieds_main') . '");');
}

if($_REQUEST['do'] == 'closeorder') {
  $orderid = $vbulletin->input->clean_gpc('r', 'orderid', TYPE_UINT);
	$order = $db->query_first("
		SELECT ".TABLE_PREFIX."classifieds_payments.id
		FROM ".TABLE_PREFIX."classifieds_payments
		JOIN ".TABLE_PREFIX."classifieds_ads
			ON ".TABLE_PREFIX."classifieds_ads.id=".TABLE_PREFIX."classifieds_payments.adid
		WHERE ".TABLE_PREFIX."classifieds_ads.userid=$userid
	");
	if(!$order)
		print_no_permission();
		
	$db->query_write("UPDATE ".TABLE_PREFIX."classifieds_payments SET closed=1 WHERE id=$orderid");
	
  $vbulletin->url = "classifieds.php?do=sales";
  standard_redirect();
}

if($_REQUEST['do'] == 'activate') {
  $adid = $vbulletin->input->clean_gpc('r', 'adid', TYPE_UINT);
	$ad = $db->query_first("SELECT id, categoryid, subcategoryid, approved, userid FROM ".TABLE_PREFIX."classifieds_ads WHERE userid=$userid");
	if(!$ad)
		print_no_permission();

	if($ad['subcategoryid'] != 0)
		$adprice = $db->query_first("SELECT adprice FROM ".TABLE_PREFIX."classifieds_subcategories WHERE id=".$ad['subcategoryid']);
	else
		$adprice = $db->query_first("SELECT adprice FROM ".TABLE_PREFIX."classifieds_categories WHERE id=".$ad['categoryid']);
  $canmod = $permissions['classifieds'] & $vbulletin->bf_ugp['classifieds']['canmod'];
	if(!($adprice["adprice"] == 0 || empty($adprice["adprice"]) || $canmod))
		print_no_permission();
	
	$now = time();
	$db->query_write("UPDATE ".TABLE_PREFIX."classifieds_ads SET active=1, activateddate=$now WHERE id=$adid");
	
	if($ad && $ad['approved']) {
		list($points, $credits) = getPointsAndCredits($ad['categoryid'], $ad['subcategoryid']);
		$db->query_write("UPDATE ".TABLE_PREFIX."user SET ipoints=ipoints+($points) WHERE userid=".$ad['userid']);
		if($credits != 0)
			$db->query_write("UPDATE ".TABLE_PREFIX."user SET credits=credits+($points) WHERE userid=".$ad['userid']);
	}
	
  $page = $_REQUEST['pagenumber'];
  $vbulletin->url = "classifieds.php?do=myads&page=$pagenumber";
  standard_redirect();
}

if($_REQUEST['do'] == 'renderfields') {
  $adid = $vbulletin->input->clean_gpc('r', 'adid', TYPE_UINT);
  $catid = $vbulletin->input->clean_gpc('r', 'catid', TYPE_UINT);
  $subcatid = $vbulletin->input->clean_gpc('r', 'subcatid', TYPE_UINT);

	echo '<table cellpadding="0" cellspacing="0" border="0" width="100%" class="fieldset">';
	echo renderExtraFields($catid, $subcatid, $adid);
	echo '</table>';
}

if($_REQUEST['do'] == 'approve') {
	if(!($permissions['classifieds'] & $vbulletin->bf_ugp['classifieds']['canmod']))
		print_no_permission();

  $pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_UINT);
  $recperpage = 10;

  $totalrecords = $db->query_first("
    SELECT COUNT(*) AS totalrecords
    FROM ".TABLE_PREFIX."classifieds_ads
		WHERE active=1 AND approved=0
	");
  
  sanitize_pageresults($totalrecords['totalrecords'], $pagenumber, $recperpage, $recperpage, $recperpage);
  $limitlower = ($pagenumber - 1) * $recperpage + 1;
  $limitupper = $pagenumber * $recperpage;
  if($limitupper > $totalrecords['totalrecords']) {
    $limitupper = $totalrecords['totalrecords'];
    if($limitlower > $totalrecords['totalrecords'])
      $limitlower = $totalrecords['totalrecords'] - $recperpage;
  }
  if($limitlower <= 0) {
     $limitlower = 1;
  }

	$ads = $db->query_read("
		SELECT ".TABLE_PREFIX."classifieds_ads.*, ".TABLE_PREFIX."classifieds_categories.name AS catname,
			".TABLE_PREFIX."classifieds_subcategories.name AS subcatname
		FROM ".TABLE_PREFIX."classifieds_ads
		JOIN ".TABLE_PREFIX."classifieds_categories
			ON ".TABLE_PREFIX."classifieds_categories.id=".TABLE_PREFIX."classifieds_ads.categoryid
		LEFT JOIN ".TABLE_PREFIX."classifieds_subcategories
			ON ".TABLE_PREFIX."classifieds_subcategories.id=".TABLE_PREFIX."classifieds_ads.subcategoryid
		WHERE active=1 AND approved=0
		ORDER BY ".TABLE_PREFIX."classifieds_ads.id
		LIMIT " . ($limitlower - 1) . ", $recperpage
	");
  $pagenav = construct_page_nav($pagenumber, $recperpage, $totalrecords['totalrecords'], "classifieds.php?" . $vbulletin->session->vars['sessionurl'] . "do=approve");
	$classifieds = '';
	while($ad = $db->fetch_array($ads)) {
		$photo = $db->query_first("SELECT photoname FROM ".TABLE_PREFIX."classifieds_photos WHERE adid=".$ad["id"]." AND istitlephoto=1");
		if(!$photo)
			$photo = $db->query_first("SELECT photoname FROM ".TABLE_PREFIX."classifieds_photos WHERE adid=".$ad["id"]);
		if($photo)
			$ad["photoname"] = $photo["photoname"];
		else
			$ad["photoname"] = '';
		$ad["description"] = parseBbCode($ad["description"], $vbulletin->options["classifieds_maxchars"]);
		$ad["currency"] = getCurrency($ad["currency"]);
		if($ad["subcategoryid"] != 0)
			$price = $db->query_first("SELECT adprice FROM ".TABLE_PREFIX."classifieds_subcategories WHERE id=".$ad["subcategoryid"]);
		else
			$price = $db->query_first("SELECT adprice FROM ".TABLE_PREFIX."classifieds_categories WHERE id=".$ad["categoryid"]);
		$price = $price["adprice"]; 
		$title = sanitize_title($ad["title"]);
		eval('$classifieds .= "' . fetch_template('classifieds_approvead') . '";');
	}

  $navbits = construct_navbits(array("classifieds.php?" . $vbulletin->session->vars['sessionurl'] => $vbulletin->options["classifieds_navbar"],
		"" => $vbphrase["classifieds_approveclassifieds"]));
  $leftsidebar = getLeftSidebar(0, 0); 
  eval('$navbar = "' . fetch_template('navbar') . '";'); 
	$rightsidebar = "";
	
	eval('$content = "' . fetch_template('classifieds_approveads') . '";');
	eval('print_output("' . fetch_template('classifieds_main') . '");');
}

if($_REQUEST['do'] == 'approvead') {
	if(!($permissions['classifieds'] & $vbulletin->bf_ugp['classifieds']['canmod']))
		print_no_permission();

  $adid = $vbulletin->input->clean_gpc('r', 'adid', TYPE_UINT);
	$db->query_write("UPDATE ".TABLE_PREFIX."classifieds_ads SET approved=1 WHERE id=$adid");

	$ad = $db->query_first("SELECT categoryid, subcategoryid, active, userid FROM ".TABLE_PREFIX."classifieds_ads WHERE id=$adid");
	if($ad && $ad['active']) {
		list($points, $credits) = getPointsAndCredits($ad['categoryid'], $ad['subcategoryid']);
		$db->query_write("UPDATE ".TABLE_PREFIX."user SET ipoints=ipoints+($points) WHERE userid=".$ad['userid']);
		if($credits != 0)
			$db->query_write("UPDATE ".TABLE_PREFIX."user SET credits=credits+($points) WHERE userid=".$ad['userid']);
	}

  $vbulletin->url = "classifieds.php?do=approve&page=".$_REQUEST['pagenumber'];
  standard_redirect();
}

if($_REQUEST['do'] == 'search') {
  $pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_UINT);

	$recperpage = intval($vbulletin->options["classifieds_adscount"]);
	$boldcolor = $vbulletin->options["classifieds_boldcolor"];

  $catid = $vbulletin->input->clean_gpc('r', 'catid', TYPE_UINT);
  $username = $vbulletin->input->clean_gpc('r', 'username', TYPE_STR);
	$username = $db->escape_string($username);
  $keywords = $vbulletin->input->clean_gpc('r', 'keywords', TYPE_STR);
	$keywords = $db->escape_string($keywords);

	$now = time();
	$where = "WHERE active=1 AND approved=1 AND hidden=0 AND publishdate<=$now AND (expirationdate=0 OR expirationdate>$now) ";
	if($catid != 0)
		$where .= "AND ".TABLE_PREFIX."classifieds_ads.categoryid=$catid ";
	if(!empty($username))
		$where .= "AND username LIKE '%$nick%' ";
	if(!empty($keywords))
		$where .= "AND MATCH(title, description) AGAINST ('+$keywords' IN BOOLEAN MODE) ";

  $totalrecords = $db->query_first("
    SELECT COUNT(*) AS totalrecords
    FROM ".TABLE_PREFIX."classifieds_ads
		JOIN ".TABLE_PREFIX."user
			ON ".TABLE_PREFIX."user.userid=".TABLE_PREFIX."classifieds_ads.userid
		$where
	");
  
  sanitize_pageresults($totalrecords['totalrecords'], $pagenumber, $recperpage, $recperpage, $recperpage);
  $limitlower = ($pagenumber - 1) * $recperpage + 1;
  $limitupper = $pagenumber * $recperpage;
  if($limitupper > $totalrecords['totalrecords']) {
    $limitupper = $totalrecords['totalrecords'];
    if($limitlower > $totalrecords['totalrecords'])
      $limitlower = $totalrecords['totalrecords'] - $recperpage;
  }
  if($limitlower <= 0) {
     $limitlower = 1;
  }

	$ads = $db->query_read("
		SELECT ".TABLE_PREFIX."classifieds_ads.*, ".TABLE_PREFIX."classifieds_categories.name AS catname,
			".TABLE_PREFIX."classifieds_subcategories.name AS subcatname, ".TABLE_PREFIX."user.username AS username
		FROM ".TABLE_PREFIX."classifieds_ads
		JOIN ".TABLE_PREFIX."classifieds_categories
			ON ".TABLE_PREFIX."classifieds_categories.id=".TABLE_PREFIX."classifieds_ads.categoryid
		LEFT JOIN ".TABLE_PREFIX."classifieds_subcategories
			ON ".TABLE_PREFIX."classifieds_subcategories.id=".TABLE_PREFIX."classifieds_ads.subcategoryid
		JOIN ".TABLE_PREFIX."user
			ON ".TABLE_PREFIX."user.userid=".TABLE_PREFIX."classifieds_ads.userid
		$where
		ORDER BY ".TABLE_PREFIX."classifieds_ads.id
		LIMIT " . ($limitlower - 1) . ", $recperpage
	");
  $pagenav = construct_page_nav($pagenumber, $recperpage, $totalrecords['totalrecords'], "classifieds.php?" . $vbulletin->session->vars['sessionurl'] . "do=search");
	$classifieds = '';
	while($ad = $db->fetch_array($ads)) {
		$adid = $ad["id"];
		$photo = $db->query_first("SELECT photoname FROM ".TABLE_PREFIX."classifieds_photos WHERE adid=$adid AND istitlephoto=1");
		if(!$photo)
			$photo = $db->query_first("SELECT photoname FROM ".TABLE_PREFIX."classifieds_photos WHERE adid=$adid");
		if($photo)
			$ad["photoname"] = $photo["photoname"];
		else
			$ad["photoname"] = '';
		$ad["description"] = parseBbCode($ad["description"], $vbulletin->options["classifieds_maxchars"]);
		$ad["currency"] = getCurrency($ad["currency"]);
		$visits = $db->query_first("SELECT SUM(count) AS cnt FROM ".TABLE_PREFIX."classifieds_visits WHERE id=$adid GROUP BY id");
		$ad["viewcount"] = $visits["cnt"];
		if(empty($ad["viewcount"]))
			$ad["viewcount"] = 0;
		$title = sanitize_title($ad["title"]);
		eval('$classifieds .= "' . fetch_template('classifieds_ad') . '";');
	}
	eval('$content = "' . fetch_template('classifieds_adslist') . '";');

  $navbits = construct_navbits(array("classifieds.php?" . $vbulletin->session->vars['sessionurl'] => $vbulletin->options["classifieds_navbar"],
		"" => $vbphrase["classifieds_searchresults"]));
  $leftsidebar = getLeftSidebar(0, 0); 
  eval('$navbar = "' . fetch_template('navbar') . '";'); 
	$rightsidebar = getRightSidebar(0, 0);
	
  eval('print_output("' . fetch_template('classifieds_main') . '");');
}

if($_REQUEST['do'] == 'rss') {
  $catid = $vbulletin->input->clean_gpc('r', 'catid', TYPE_UINT);
  $subcatid = $vbulletin->input->clean_gpc('r', 'subcatid', TYPE_UINT);

	$now = time();
	$where = " AND publishdate<=$now AND (expirationdate=0 OR expirationdate>$now) ";
	if($catid != 0)
		$where = " AND ".TABLE_PREFIX."classifieds_ads.categoryid=$catid ";
	if($subcatid != 0)
		$where .= " AND ".TABLE_PREFIX."classifieds_ads.subcategoryid=$subcatid ";

	$sitename = $vbulletin->options["bbtitle"].' - '.$vbphrase["classifieds"];
	$vburl = removeSlash($vbulletin->options["bburl"]);
	$siteurl = "$vburl/classifieds.php";
	$generator = "http://www.madebymary.com/";
	$language = "en";

	$last = $db->query_first("
		SELECT publishdate 
		FROM ".TABLE_PREFIX."classifieds_ads
		WHERE active=1 AND approved=1 AND hidden=0 $where
	  ORDER BY publishdate DESC, activateddate DESC
	  LIMIT 1");
	$pubdate = date('r', $last["publishdate"]);

	$ads = $db->query_read("
		SELECT ".TABLE_PREFIX."classifieds_ads.*, ".TABLE_PREFIX."classifieds_categories.name AS catname,
			".TABLE_PREFIX."classifieds_subcategories.name AS subcatname, ".TABLE_PREFIX."user.username AS username
		FROM ".TABLE_PREFIX."classifieds_ads
		JOIN ".TABLE_PREFIX."classifieds_categories
			ON ".TABLE_PREFIX."classifieds_categories.id=".TABLE_PREFIX."classifieds_ads.categoryid
		LEFT JOIN ".TABLE_PREFIX."classifieds_subcategories
			ON ".TABLE_PREFIX."classifieds_subcategories.id=".TABLE_PREFIX."classifieds_ads.subcategoryid
		JOIN ".TABLE_PREFIX."user
			ON ".TABLE_PREFIX."user.userid=".TABLE_PREFIX."classifieds_ads.userid
		WHERE active=1 AND approved=1 AND hidden=0 $where
		ORDER BY ".TABLE_PREFIX."classifieds_ads.publishdate DESC, ".TABLE_PREFIX."classifieds_ads.activateddate DESC
		LIMIT 10
	");

	header('Content-Type: text/xml; charset='.$stylevar["charset"]);
	echo '<?xml version="1.0" encoding="'.$stylevar["charset"].'"?>'."\n";
	?>
	<rss version="2.0" 
		xmlns:content="http://purl.org/rss/1.0/modules/content/"
		xmlns:dc="http://purl.org/dc/elements/1.1/"
		>
	<channel>
		<title><?php echo $sitename; ?></title>
		<link><?php echo $siteurl; ?></link>
		<description></description>
		<pubDate><?php echo $pubdate; ?></pubDate>
		<generator><?php echo $generator; ?></generator>
		<language><?php echo $language; ?></language>

	  <?php while($ad = $db->fetch_array($ads)) { ?>
	   	<item>
	  		<title><?php echo $ad["title"]; ?></title>
	  		<link><?php echo $vburl."/classifieds.php?do=showad&amp;adid=".$ad["id"]."&amp;title=".sanitize_title($ad["title"]); ?></link>
	  		<pubDate><?php echo date('r', $ad["publishdate"]); ?></pubDate>
	  		<dc:creator><?php echo $ad["username"]; ?></dc:creator>
	  		<guid isPermaLink="true"><?php echo $vburl."/classifieds.php?do=showad&amp;adid=".$ad["id"]."&amp;title=".sanitize_title($ad["title"]); ?></guid>
	  		<description><![CDATA[<?php echo parseBbCode($ad["description"]);?>]]></description>
	  	</item>
	  <?php } ?>
		</channel>
	</rss>
<?php 
}

if($_REQUEST['do'] == 'report') {
  $adid = $vbulletin->input->clean_gpc('r', 'adid', TYPE_UINT);

	$ad = $db->query_first("SELECT id, title FROM ".TABLE_PREFIX."classifieds_ads WHERE id=$adid");
	if(!$ad)
		print_no_permission();

	$title = sanitize_title($ad["title"]);
  $navbits = construct_navbits(array("classifieds.php?" . $vbulletin->session->vars['sessionurl'] => $vbulletin->options["classifieds_navbar"],
		"classifieds.php?do=showad&adid=$adid&title=$title" => $ad["title"], "" => $vbphrase["classifieds_report"]));
  $leftsidebar = getLeftSidebar(0, 0); 
  eval('$navbar = "' . fetch_template('navbar') . '";'); 
	$rightsidebar = getRightSidebar(0, 0);
	
	eval('$content = "' . fetch_template('classifieds_reportad') . '";');
	eval('print_output("' . fetch_template('classifieds_main') . '");');
}

if($_REQUEST['do'] == 'savereport') {
  $adid = $vbulletin->input->clean_gpc('r', 'adid', TYPE_UINT);
  $reason = $vbulletin->input->clean_gpc('r', 'reason', TYPE_STR);
	$reason = $db->escape_string($reason);

	$db->query_write("INSERT INTO ".TABLE_PREFIX."classifieds_reports (id, adid, reason, status) VALUES
		(NULL, $adid, '$reason', 1)");
	
  $vbulletin->url="classifieds.php?do=showad&adid=$adid&title=".$_REQUEST["title"];
  eval(print_standard_redirect('classifieds_ad_reported', true, true));
}

if($_REQUEST['do'] == 'email') {
  $adid = $vbulletin->input->clean_gpc('r', 'adid', TYPE_UINT);

	$ad = $db->query_first("SELECT id, title FROM ".TABLE_PREFIX."classifieds_ads WHERE id=$adid");
	if(!$ad || $userid == 0)
		print_no_permission();

	$title = sanitize_title($ad["title"]);
  $navbits = construct_navbits(array("classifieds.php?" . $vbulletin->session->vars['sessionurl'] => $vbulletin->options["classifieds_navbar"],
		"classifieds.php?do=showad&adid=$adid&title=$title" => $ad["title"], "" => $vbphrase["classifieds_email"]));
  $leftsidebar = getLeftSidebar(0, 0); 
  eval('$navbar = "' . fetch_template('navbar') . '";'); 
	$rightsidebar = getRightSidebar(0, 0);
	
  $fromname = $vbulletin->userinfo['username'];
  $fromemail = $vbulletin->userinfo['email'];
	$link = removeSlash($vbulletin->options["bburl"])."/classifieds.php?do=showad&adid=".$ad["id"];
	
	eval('$content = "' . fetch_template('classifieds_emailad') . '";');
	eval('print_output("' . fetch_template('classifieds_main') . '");');
}

if($_REQUEST['do'] == 'sendemail') {
	if($userid == 0)
		print_no_permission();
		
  $adid = $vbulletin->input->clean_gpc('r', 'adid', TYPE_UINT);

  $msg_fromname = $_POST['fromname'];
  $msg_fromemail = $_POST['fromemail'];
  $msg_toname = $_POST['toname'];
  $msg_toemail = $_POST['toemail'];
  $msg_message = $_POST['mytext'];
  if (is_valid_email($msg_fromemail)) {
    vbmail($toemail = $msg_toemail, $subject = $msg_fromname, $message = $msg_message, $notsubscription = true, $from = $msg_fromemail, $uheaders = '', $username = $msg_fromname);
    $vbulletin->url="classifieds.php?do=showad&adid=$adid&title=".$_REQUEST["title"];
    eval(print_standard_redirect('classifieds_email_sent', true, true));
  } else {
    $vbulletin->url="classifieds.php?do=showad&adid=$adid&title=".$_REQUEST["title"];
    eval(print_standard_redirect('classifieds_email_error', true, true));
  }
}

if($_REQUEST['do'] == 'print') {
  $adid = $vbulletin->input->clean_gpc('r', 'adid', TYPE_UINT);

	$now = time();
	$where = "AND ((active=1 AND hidden=0 AND approved=1 AND publishdate<=$now AND (expirationdate=0 OR expirationdate>$now)) OR (".TABLE_PREFIX."classifieds_ads.userid=$userid))";
	$ad = $db->query_first("
		SELECT ".TABLE_PREFIX."classifieds_ads.*, ".TABLE_PREFIX."classifieds_categories.name AS catname,
			".TABLE_PREFIX."classifieds_subcategories.name AS subcatname, ".TABLE_PREFIX."user.username
		FROM ".TABLE_PREFIX."classifieds_ads
		JOIN ".TABLE_PREFIX."classifieds_categories
			ON ".TABLE_PREFIX."classifieds_categories.id=".TABLE_PREFIX."classifieds_ads.categoryid
		LEFT JOIN ".TABLE_PREFIX."classifieds_subcategories
			ON ".TABLE_PREFIX."classifieds_subcategories.id=".TABLE_PREFIX."classifieds_ads.subcategoryid
		JOIN ".TABLE_PREFIX."user
			ON ".TABLE_PREFIX."user.userid=".TABLE_PREFIX."classifieds_ads.userid
		WHERE ".TABLE_PREFIX."classifieds_ads.id=$adid $where
	");
	if(!$ad)
		print_no_permission();

	$visits = $db->query_first("SELECT SUM(count) AS cnt FROM ".TABLE_PREFIX."classifieds_visits WHERE id=$adid GROUP BY id");
	$ad["viewcount"] = $visits["cnt"];
	if(empty($ad["viewcount"]))
		$ad["viewcount"] = 0;

	$photo = $db->query_first("SELECT id, photoname FROM ".TABLE_PREFIX."classifieds_photos WHERE adid=".$ad["id"]." AND istitlephoto=1");
	if(!$photo)
		$photo = $db->query_first("SELECT id, photoname FROM ".TABLE_PREFIX."classifieds_photos WHERE adid=".$ad["id"]);
	if($photo) {
		$ad["photoname"] = $photo["photoname"];
  } else {
		$ad["photoname"] = '';
	}
	$ad["description"] = parseBbCode($ad["description"]);
	$ad["currency"] = getCurrency($ad["currency"]);
	
	$pictures = '';
	$pics = $db->query_read("SELECT photoname FROM ".TABLE_PREFIX."classifieds_photos WHERE adid=".$ad["id"]);
	while($pic = $db->fetch_array($pics)) {
		$pictures .= '<img src="classifieds/photos/'.$pic["photoname"].'" />&nbsp;';
	}

  $navbits = "";
  $leftsidebar = "";
	$navbar = "";
	$rightsidebar = "";
	$extrafields = showExtraFields($ad["categoryid"], $ad["subcategoryid"], $ad["id"]);
	$header = "";
	$footer = '<script type="text/javascript">window.print();</script>';
	$print = 1;
	
	eval('$content = "' . fetch_template('classifieds_showad') . '";');
	eval('print_output("' . fetch_template('classifieds_main') . '");');
}

if($_REQUEST['do'] == 'bookmarks') {
  $pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_UINT);
  $recperpage = 10;

	$now = time();
  $totalrecords = $db->query_first("
    SELECT COUNT(*) AS totalrecords
    FROM ".TABLE_PREFIX."classifieds_bookmarks
		JOIN ".TABLE_PREFIX."classifieds_ads
			ON ".TABLE_PREFIX."classifieds_ads.id=".TABLE_PREFIX."classifieds_bookmarks.adid
		WHERE active=1 AND approved=1 AND hidden=0 AND ".TABLE_PREFIX."classifieds_bookmarks.userid=$userid
			AND publishdate<=$now AND (expirationdate=0 OR expirationdate>$now) 
	");
  
  sanitize_pageresults($totalrecords['totalrecords'], $pagenumber, $recperpage, $recperpage, $recperpage);
  $limitlower = ($pagenumber - 1) * $recperpage + 1;
  $limitupper = $pagenumber * $recperpage;
  if($limitupper > $totalrecords['totalrecords']) {
    $limitupper = $totalrecords['totalrecords'];
    if($limitlower > $totalrecords['totalrecords'])
      $limitlower = $totalrecords['totalrecords'] - $recperpage;
  }
  if($limitlower <= 0) {
     $limitlower = 1;
  }

	$ads = $db->query_read("
		SELECT ".TABLE_PREFIX."classifieds_ads.*, ".TABLE_PREFIX."classifieds_categories.name AS catname,
			".TABLE_PREFIX."classifieds_subcategories.name AS subcatname, ".TABLE_PREFIX."classifieds_bookmarks.id AS bookmarkid
		FROM ".TABLE_PREFIX."classifieds_bookmarks
		JOIN ".TABLE_PREFIX."classifieds_ads
			ON ".TABLE_PREFIX."classifieds_ads.id=".TABLE_PREFIX."classifieds_bookmarks.adid
		JOIN ".TABLE_PREFIX."classifieds_categories
			ON ".TABLE_PREFIX."classifieds_categories.id=".TABLE_PREFIX."classifieds_ads.categoryid
		LEFT JOIN ".TABLE_PREFIX."classifieds_subcategories
			ON ".TABLE_PREFIX."classifieds_subcategories.id=".TABLE_PREFIX."classifieds_ads.subcategoryid
		WHERE active=1 AND approved=1 AND hidden=0 AND ".TABLE_PREFIX."classifieds_bookmarks.userid=$userid
			AND publishdate<=$now AND (expirationdate=0 OR expirationdate>$now) 
		ORDER BY ".TABLE_PREFIX."classifieds_bookmarks.id DESC
		LIMIT " . ($limitlower - 1) . ", $recperpage
	");
  $pagenav = construct_page_nav($pagenumber, $recperpage, $totalrecords['totalrecords'], "classifieds.php?" . $vbulletin->session->vars['sessionurl'] . "do=approve");
	$classifieds = '';
	while($ad = $db->fetch_array($ads)) {
		$photo = $db->query_first("SELECT photoname FROM ".TABLE_PREFIX."classifieds_photos WHERE adid=".$ad["id"]." AND istitlephoto=1");
		if(!$photo)
			$photo = $db->query_first("SELECT photoname FROM ".TABLE_PREFIX."classifieds_photos WHERE adid=".$ad["id"]);
		if($photo)
			$ad["photoname"] = $photo["photoname"];
		else
			$ad["photoname"] = '';
		$ad["description"] = parseBbCode($ad["description"], $vbulletin->options["classifieds_maxchars"]);
		$ad["currency"] = getCurrency($ad["currency"]);
		if($ad["subcategoryid"] != 0)
			$price = $db->query_first("SELECT adprice FROM ".TABLE_PREFIX."classifieds_subcategories WHERE id=".$ad["subcategoryid"]);
		else
			$price = $db->query_first("SELECT adprice FROM ".TABLE_PREFIX."classifieds_categories WHERE id=".$ad["categoryid"]);
		$price = $price["adprice"]; 
		$title = sanitize_title($ad["title"]);
		eval('$classifieds .= "' . fetch_template('classifieds_bookmarksad') . '";');
	}

  $navbits = construct_navbits(array("classifieds.php?" . $vbulletin->session->vars['sessionurl'] => $vbulletin->options["classifieds_navbar"],
		"" => $vbphrase["classifieds_mybookmarks"]));
  $leftsidebar = getLeftSidebar(0, 0); 
  eval('$navbar = "' . fetch_template('navbar') . '";'); 
	$rightsidebar = "";
	
	eval('$content = "' . fetch_template('classifieds_bookmarks') . '";');
	eval('print_output("' . fetch_template('classifieds_main') . '");');
}

if($_REQUEST['do'] == 'savebookmark') {
  $adid = $vbulletin->input->clean_gpc('r', 'adid', TYPE_UINT);

	$ad = $db->query_first("SELECT id FROM ".TABLE_PREFIX."classifieds_bookmarks WHERE adid=$adid AND userid=$userid");
	if(!$ad)
		$db->query_write("INSERT INTO ".TABLE_PREFIX."classifieds_bookmarks (id, adid, userid) VALUES
			(NULL, $adid, $userid)");
	
  $vbulletin->url="classifieds.php?do=bookmarks";
	standard_redirect();
}

if($_REQUEST['do'] == 'deletebookmark') {
  $id = $vbulletin->input->clean_gpc('r', 'id', TYPE_UINT);

	$bm = $db->query_first("SELECT id FROM ".TABLE_PREFIX."classifieds_bookmarks WHERE id=$id AND userid=$userid");
	if($bm)
		$db->query_write("DELETE FROM ".TABLE_PREFIX."classifieds_bookmarks WHERE id=$id");
	
  $vbulletin->url="classifieds.php?do=bookmarks";
	standard_redirect();
}

if($_REQUEST['do'] == 'seteditchoice') {
	if(!($permissions['classifieds'] & $vbulletin->bf_ugp['classifieds']['canmod']))
		print_no_permission();

  $adid = $vbulletin->input->clean_gpc('r', 'adid', TYPE_UINT);
	
	$db->query_write("UPDATE ".TABLE_PREFIX."classifieds_ads SET editor=1 WHERE id=$adid");
	
	$vbulletin->url = "classifieds.php?do=showad&adid=$adid&title=".$_REQUEST['title'];
	standard_redirect();
}

if($_REQUEST['do'] == 'setfeatured') {
	if(!($permissions['classifieds'] & $vbulletin->bf_ugp['classifieds']['canmod']))
		print_no_permission();

  $adid = $vbulletin->input->clean_gpc('r', 'adid', TYPE_UINT);
	
	$db->query_write("UPDATE ".TABLE_PREFIX."classifieds_ads SET featured=1 WHERE id=$adid");
	
	$vbulletin->url = "classifieds.php?do=showad&adid=$adid&title=".$_REQUEST['title'];
	standard_redirect();
}

if($_REQUEST['do'] == 'setbold') {
	if(!($permissions['classifieds'] & $vbulletin->bf_ugp['classifieds']['canmod']))
		print_no_permission();

  $adid = $vbulletin->input->clean_gpc('r', 'adid', TYPE_UINT);
	
	$db->query_write("UPDATE ".TABLE_PREFIX."classifieds_ads SET bold=1 WHERE id=$adid");
	
	$vbulletin->url = "classifieds.php?do=showad&adid=$adid&title=".$_REQUEST['title'];
	standard_redirect();
}

if($_REQUEST['do'] == 'removeeditchoice') {
	if(!($permissions['classifieds'] & $vbulletin->bf_ugp['classifieds']['canmod']))
		print_no_permission();

  $adid = $vbulletin->input->clean_gpc('r', 'adid', TYPE_UINT);
	
	$db->query_write("UPDATE ".TABLE_PREFIX."classifieds_ads SET editor=0 WHERE id=$adid");
	
	$vbulletin->url = "classifieds.php?do=showad&adid=$adid&title=".$_REQUEST['title'];
	standard_redirect();
}

if($_REQUEST['do'] == 'removefeatured') {
	if(!($permissions['classifieds'] & $vbulletin->bf_ugp['classifieds']['canmod']))
		print_no_permission();

  $adid = $vbulletin->input->clean_gpc('r', 'adid', TYPE_UINT);
	
	$db->query_write("UPDATE ".TABLE_PREFIX."classifieds_ads SET featured=0 WHERE id=$adid");
	
	$vbulletin->url = "classifieds.php?do=showad&adid=$adid&title=".$_REQUEST['title'];
	standard_redirect();
}

if($_REQUEST['do'] == 'removebold') {
	if(!($permissions['classifieds'] & $vbulletin->bf_ugp['classifieds']['canmod']))
		print_no_permission();

  $adid = $vbulletin->input->clean_gpc('r', 'adid', TYPE_UINT);
	
	$db->query_write("UPDATE ".TABLE_PREFIX."classifieds_ads SET bold=0 WHERE id=$adid");
	
	$vbulletin->url = "classifieds.php?do=showad&adid=$adid&title=".$_REQUEST['title'];
	standard_redirect();
}

if($_REQUEST['do'] == 'hidead') {
  $adid = $vbulletin->input->clean_gpc('r', 'adid', TYPE_UINT);
	$ad = $db->query_first("SELECT userid FROM ".TABLE_PREFIX."classifieds_ads WHERE id=$adid");
	if(!$ad)
		print_no_permission();
	if($ad['userid'] != $vbulletin->userinfo['userid'])
		print_no_permission();
	
	$db->query_write("UPDATE ".TABLE_PREFIX."classifieds_ads SET hidden=1 WHERE id=$adid");
	
	$vbulletin->url = "classifieds.php?do=myads";
	standard_redirect();
}

if($_REQUEST['do'] == 'unhidead') {
  $adid = $vbulletin->input->clean_gpc('r', 'adid', TYPE_UINT);
	$ad = $db->query_first("SELECT userid FROM ".TABLE_PREFIX."classifieds_ads WHERE id=$adid");
	if(!$ad)
		print_no_permission();
	if($ad['userid'] != $vbulletin->userinfo['userid'])
		print_no_permission();

	$db->query_write("UPDATE ".TABLE_PREFIX."classifieds_ads SET hidden=0 WHERE id=$adid");
	
	$vbulletin->url = "classifieds.php?do=myads";
	standard_redirect();
}

?>
