<?php



function getLeftSidebar($catid, $subcatid)

{

	global $db, $vbphrase;

	

	if($catid != 0)

		$cat = $db->query_first("SELECT id, name FROM ".TABLE_PREFIX."classifieds_categories WHERE id=$catid");

	if($subcatid != 0)

		$subcat = $db->query_first("SELECT id, name FROM ".TABLE_PREFIX."classifieds_subcategories WHERE id=$subcatid");

	

	$now = time();

	if($subcatid != 0) {

		$name = $subcat["name"];

		$title = sanitize_title($cat["name"]);

		$backlink = array("name" => $cat["name"], "link" => "classifieds.php?do=category&catid=".$cat["id"]."&title=$title");

		$links = array();

	} else if($catid != 0) {

		$name = $cat["name"];

		$backlink = array("name" => $vbphrase["classifieds_mainpage"], "link" => "classifieds.php");

		$links = array();

		$subcats = $db->query_read("

			SELECT ".TABLE_PREFIX."classifieds_subcategories.id, name, COUNT(".TABLE_PREFIX."classifieds_ads.id) AS cnt

			FROM ".TABLE_PREFIX."classifieds_subcategories

			LEFT JOIN ".TABLE_PREFIX."classifieds_ads

				ON ".TABLE_PREFIX."classifieds_ads.subcategoryid=".TABLE_PREFIX."classifieds_subcategories.id

				AND active=1 AND hidden=0 AND approved=1

				AND publishdate<=$now AND (expirationdate=0 OR expirationdate>$now) 

			WHERE ".TABLE_PREFIX."classifieds_subcategories.categoryid=$catid

			GROUP BY ".TABLE_PREFIX."classifieds_subcategories.id

			ORDER BY displayorder");

		while($sc = $db->fetch_array($subcats)) {

			$title = sanitize_title($sc["name"]);

			$links[] = array("name" => $sc["name"], "link" => "classifieds.php?do=subcategory&catid=$catid&subcatid=".$sc["id"]."&title=$title", "count" => '('.$sc["cnt"].')', "rss" => "classifieds.php?do=rss&catid=$catid&subcatid=".$sc["id"]);

		}

	} else {

		$name = $vbphrase["classifieds_categories"];

		$backlink = array();

		$links = array();

		$cats = $db->query_read("

			SELECT ".TABLE_PREFIX."classifieds_categories.id, name, COUNT(".TABLE_PREFIX."classifieds_ads.id) AS cnt

			FROM ".TABLE_PREFIX."classifieds_categories

			LEFT JOIN ".TABLE_PREFIX."classifieds_ads

				ON ".TABLE_PREFIX."classifieds_ads.categoryid=".TABLE_PREFIX."classifieds_categories.id

				AND active=1 AND hidden=0 AND approved=1

				AND publishdate<=$now AND (expirationdate=0 OR expirationdate>$now) 

			GROUP BY ".TABLE_PREFIX."classifieds_categories.id

			ORDER BY displayorder");

		while($c = $db->fetch_array($cats)) {

			$title = sanitize_title($c["name"]);

			$links[] = array("name" => $c["name"], "link" => "classifieds.php?do=category&catid=".$c["id"]."&title=$title", "count" => '('.$c["cnt"].')', "rss" => "classifieds.php?do=rss&catid=".$c["id"]);

		}

	}

	

	return getLinksBlock($name, $links, $backlink).getMemberMenu($catid, $subcatid).getSearchBlock().getTopSellers();

}



function getSearchBlock()

{

	global $db, $vbphrase;



	$categories_get = $db->query_read("SELECT id, name FROM ".TABLE_PREFIX."classifieds_categories ORDER BY displayorder");

	$categories = '';

	while($cat = $db->fetch_array($categories_get))

		$categories .= '<option value="'.$cat["id"].'">'.$cat["name"].'</option>';



  eval('$searchblock = "' . fetch_template('classifieds_searchblock') . '";');



	return ''.$searchblock;

}



function getMemberMenu($catid, $subcatid)

{

	global $db, $userid, $permissions, $vbulletin, $vbphrase;

	

	if($userid == 0)

		return '';

		

	$links = array(array("name" => $vbphrase["classifieds_addclassified"], "link" => "classifieds.php?do=editad&catid=$catid&subcatid=$subcatid"),

								 array("name" => $vbphrase["classifieds_myclassifieds"], "link" => "classifieds.php?do=myads"),

								 array("name" => $vbphrase["classifieds_mybookmarks"], "link" => "classifieds.php?do=bookmarks"),

								 array("name" => $vbphrase["classifieds_mysales"], "link" => "classifieds.php?do=sales"),

								 array("name" => $vbphrase["classifieds_myorders"], "link" => "classifieds.php?do=orders"));

	if($permissions['classifieds'] & $vbulletin->bf_ugp['classifieds']['canmod'])

		$links[] = array("name" => $vbphrase["classifieds_approveclassifieds"], "link" => "classifieds.php?do=approve");

	

	return ''.getLinksBlock($vbphrase["classifieds_membermenu"], $links, array());

}



function getLinksBlock($name, $links, $backlink)

{

	global $db, $vbphrase;

	

	$linkshtml = '';

	foreach($links as $link) {

		if(!empty($link["rss"]))

			$linkshtml .= '<a target="_blank" href="'.$link["rss"].'"><img border="0" src="classifieds/images/rss.gif" width="27" height="15" /></a>&nbsp;';

		$linkshtml .= '<a href="'.$link["link"].'">'.$link["name"].'</a>'.iif(!empty($link["count"]), " ".$link["count"]).'<br />';

	}

	if(!empty($linkshtml) && !empty($backlink)) {

		$linkshtml .= '<br />';

	}

	if(!empty($backlink)) {

		$linkshtml .= '<a href="'.$backlink["link"].'">'.$backlink["name"].'</a>';

	}



  eval('$catsmenu = "' . fetch_template('classifieds_linkslist') . '";');



	return $catsmenu;

}



function getTopSellers()

{

	global $db, $vbulletin, $vbphrase;

	

	$now = time();

	$count = intval($vbulletin->options["classifieds_topsellerscount"]);

	$sellers = $db->query_read("

		SELECT AVG(".TABLE_PREFIX."classifieds_reviews.rating) AS rating,

			".TABLE_PREFIX."user.*

		FROM ".TABLE_PREFIX."classifieds_reviews

		JOIN ".TABLE_PREFIX."classifieds_ads

			ON ".TABLE_PREFIX."classifieds_ads.userid=".TABLE_PREFIX."classifieds_reviews.userid

			AND ".TABLE_PREFIX."classifieds_ads.active=1 AND ".TABLE_PREFIX."classifieds_ads.hidden=0

			AND ".TABLE_PREFIX."classifieds_ads.approved=1

			AND publishdate<=$now AND (expirationdate=0 OR expirationdate>$now) 

		JOIN ".TABLE_PREFIX."user

			ON ".TABLE_PREFIX."user.userid=".TABLE_PREFIX."classifieds_ads.userid

		GROUP BY ".TABLE_PREFIX."classifieds_reviews.userid

		ORDER BY rating

		LIMIT $count

	");

	$topsellers = '';

	$now = time();

	while($seller = $db->fetch_array($sellers)) { 

    $avatar = fetch_avatar_url($seller["userid"]);

    if($avatar)

      $avatar[0] = $vbulletin->options['bburl'].'/'.$avatar[0];

		$rating = getRatingImg($seller["rating"]);

		$reviews = $db->query_first("SELECT COUNT(id) AS cnt FROM ".TABLE_PREFIX."classifieds_reviews WHERE userid=".$seller["userid"]);

		$seller["cnt"] = $reviews["cnt"];

		$forsale = $db->query_first("SELECT COUNT(id) AS cnt FROM ".TABLE_PREFIX."classifieds_ads WHERE userid=".$seller["userid"]." AND active=1 AND hidden=0 AND approved=1

			AND publishdate<=$now AND (expirationdate=0 OR expirationdate>$now)");

		$seller["forsale"] = $forsale["cnt"];

		

		eval('$topsellers .= "' . fetch_template('classifieds_seller') . '";');

	}

	

	if($db->num_rows($sellers) == 0)

		return '';

		

	eval('$html .= "' . fetch_template('classifieds_sellersblock') . '";');

	

	return ''.$html;

}



function getFeaturedAds($catid, $subcatid)

{

	global $db, $vbulletin, $vboptions, $vbphrase;

	

	$boldcolor = $vbulletin->options["classifieds_boldcolor"];

	

	$now = time();

	$where = "WHERE active=1 AND hidden=0 AND approved=1 AND publishdate<=$now AND (expirationdate=0 OR expirationdate>$now) ";

	if($catid != 0)

		$where .= "AND ".TABLE_PREFIX."classifieds_ads.categoryid=$catid ";

	if($subcatid != 0)

		$where .= "AND ".TABLE_PREFIX."classifieds_ads.subcategoryid=$subcatid ";

	$newcount = intval($vbulletin->options["classifieds_featuredadscount"]);

	$ads = $db->query_read("

		SELECT ".TABLE_PREFIX."classifieds_ads.*, ".TABLE_PREFIX."classifieds_categories.name AS catname,

			".TABLE_PREFIX."classifieds_subcategories.name AS subcatname, ".TABLE_PREFIX."user.username

		FROM ".TABLE_PREFIX."classifieds_ads

		JOIN ".TABLE_PREFIX."classifieds_categories

			ON ".TABLE_PREFIX."classifieds_categories.id=".TABLE_PREFIX."classifieds_ads.categoryid

		LEFT JOIN ".TABLE_PREFIX."classifieds_subcategories

			ON ".TABLE_PREFIX."classifieds_subcategories.id=".TABLE_PREFIX."classifieds_ads.subcategoryid

		JOIN ".TABLE_PREFIX."user

			ON ".TABLE_PREFIX."user.userid=".TABLE_PREFIX."classifieds_ads.userid

		$where AND featured=1

		ORDER BY RAND()

		LIMIT $newcount

	");

	$classifieds = '';

	while($ad = $db->fetch_array($ads)) {

		$adid = $ad["id"];

		$photo = $db->query_first("SELECT photoname FROM ".TABLE_PREFIX."classifieds_photos WHERE adid=$adid AND istitlephoto=1");

		if(!$photo)

			$photo = $db->query_first("SELECT photoname FROM ".TABLE_PREFIX."classifieds_photos WHERE adid=$adid");

		if($photo)

			$ad["photoname"] = $photo["photoname"];

		else

			$ad["photoname"] = '';

		$ad["description"] = parseBbCode($ad["description"], $vbulletin->options["classifieds_maxchars"]);

		$ad["currency"] = getCurrency($ad["currency"]);

		$visits = $db->query_first("SELECT SUM(count) AS cnt FROM ".TABLE_PREFIX."classifieds_visits WHERE id=$adid GROUP BY id");

		$ad["viewcount"] = $visits["cnt"];

		if(empty($ad["viewcount"]))

			$ad["viewcount"] = 0;

		$title = sanitize_title($ad["title"]);

		eval('$classifieds .= "' . fetch_template('classifieds_featuredad') . '";');

	}

		

	return $classifieds;

}



function getRightSidebar($catid, $subcatid)

{

	global $db, $vbulletin, $vboptions, $vbphrase;



	$boldcolor = $vbulletin->options["classifieds_boldcolor"];

	$sidebar = '';

	

	$now = time();

	$where = "WHERE active=1 AND hidden=0 AND approved=1 AND publishdate<=$now AND (expirationdate=0 OR expirationdate>$now) ";

	if($catid != 0)

		$where .= "AND ".TABLE_PREFIX."classifieds_ads.categoryid=$catid ";

	if($subcatid != 0)

		$where .= "AND ".TABLE_PREFIX."classifieds_ads.subcategoryid=$subcatid ";

	$newcount = intval($vbulletin->options["classifieds_editoradscount"]);

	$ads = $db->query_read("

		SELECT ".TABLE_PREFIX."classifieds_ads.*, ".TABLE_PREFIX."classifieds_categories.name AS catname,

			".TABLE_PREFIX."classifieds_subcategories.name AS subcatname, ".TABLE_PREFIX."user.username

		FROM ".TABLE_PREFIX."classifieds_ads

		JOIN ".TABLE_PREFIX."classifieds_categories

			ON ".TABLE_PREFIX."classifieds_categories.id=".TABLE_PREFIX."classifieds_ads.categoryid

		LEFT JOIN ".TABLE_PREFIX."classifieds_subcategories

			ON ".TABLE_PREFIX."classifieds_subcategories.id=".TABLE_PREFIX."classifieds_ads.subcategoryid

		JOIN ".TABLE_PREFIX."user

			ON ".TABLE_PREFIX."user.userid=".TABLE_PREFIX."classifieds_ads.userid

		$where AND editor=1

		ORDER BY RAND()

		LIMIT $newcount

	");

	$classifieds = '';

	while($ad = $db->fetch_array($ads)) {

		$adid = $ad["id"];

		$photo = $db->query_first("SELECT photoname FROM ".TABLE_PREFIX."classifieds_photos WHERE adid=$adid AND istitlephoto=1");

		if(!$photo)

			$photo = $db->query_first("SELECT photoname FROM ".TABLE_PREFIX."classifieds_photos WHERE adid=$adid");

		if($photo)

			$ad["photoname"] = $photo["photoname"];

		else

			$ad["photoname"] = '';

		$ad["description"] = parseBbCode($ad["description"], $vbulletin->options["classifieds_maxchars"]);

		$ad["currency"] = getCurrency($ad["currency"]);

		$visits = $db->query_first("SELECT SUM(count) AS cnt FROM ".TABLE_PREFIX."classifieds_visits WHERE id=$adid GROUP BY id");

		$ad["viewcount"] = $visits["cnt"];

		if(empty($ad["viewcount"]))

			$ad["viewcount"] = 0;

		$title = sanitize_title($ad["title"]);

		eval('$classifieds .= "' . fetch_template('classifieds_adthumb') . '";');

	}

	$name = $vbphrase["classifieds_editorschoice"];

	if($db->num_rows($ads) != 0)

		eval('$sidebar .= "' . fetch_template('classifieds_adsblock') . '";');



	$sidebar .= '';

	$topcount = intval($vbulletin->options["classifieds_topadscount"]);

	$ads = $db->query_read("

		SELECT ".TABLE_PREFIX."classifieds_ads.*, ".TABLE_PREFIX."classifieds_categories.name AS catname,

			".TABLE_PREFIX."classifieds_subcategories.name AS subcatname, ".TABLE_PREFIX."user.username,

			SUM(".TABLE_PREFIX."classifieds_visits.count) AS cnt

		FROM ".TABLE_PREFIX."classifieds_ads

		JOIN ".TABLE_PREFIX."classifieds_categories

			ON ".TABLE_PREFIX."classifieds_categories.id=".TABLE_PREFIX."classifieds_ads.categoryid

		LEFT JOIN ".TABLE_PREFIX."classifieds_subcategories

			ON ".TABLE_PREFIX."classifieds_subcategories.id=".TABLE_PREFIX."classifieds_ads.subcategoryid

		LEFT JOIN ".TABLE_PREFIX."classifieds_visits

			ON ".TABLE_PREFIX."classifieds_visits.id=".TABLE_PREFIX."classifieds_ads.id

		JOIN ".TABLE_PREFIX."user

			ON ".TABLE_PREFIX."user.userid=".TABLE_PREFIX."classifieds_ads.userid

		$where

		GROUP BY ".TABLE_PREFIX."classifieds_visits.id

		ORDER BY cnt DESC

		LIMIT $topcount

	");

	$classifieds = '';

	while($ad = $db->fetch_array($ads)) {

		$adid = $ad["id"];

		$photo = $db->query_first("SELECT photoname FROM ".TABLE_PREFIX."classifieds_photos WHERE adid=$adid AND istitlephoto=1");

		if(!$photo)

			$photo = $db->query_first("SELECT photoname FROM ".TABLE_PREFIX."classifieds_photos WHERE adid=$adid");

		if($photo)

			$ad["photoname"] = $photo["photoname"];

		else

			$ad["photoname"] = '';

		$ad["description"] = parseBbCode($ad["description"], $vbulletin->options["classifieds_maxchars"]);

		$ad["currency"] = getCurrency($ad["currency"]);

		$ad["viewcount"] = $ad["cnt"];

		if(empty($ad["viewcount"]))

			$ad["viewcount"] = 0;

		$title = sanitize_title($ad["title"]);

		eval('$classifieds .= "' . fetch_template('classifieds_adthumb') . '";');

	}

	$name = $vbphrase["classifieds_topads"];

	if($db->num_rows($ads) != 0)

		eval('$sidebar .= "' . fetch_template('classifieds_adsblock') . '";');

	

	return $sidebar;

}



function getAdBlock($catid, $subcatid, $uid = 0)

{

	global $db, $vbulletin, $vboptions, $vbphrase;

	

	$now = time();

	$where = "WHERE active=1 AND hidden=0 AND approved=1 AND publishdate<=$now AND (expirationdate=0 OR expirationdate>$now) ";

	if($catid != 0)

		$where .= "AND ".TABLE_PREFIX."classifieds_ads.categoryid=$catid ";

	if($subcatid != 0)

		$where .= "AND ".TABLE_PREFIX."classifieds_ads.subcategoryid=$subcatid ";

	if($uid != 0)

		$where .= "AND ".TABLE_PREFIX."classifieds_ads.userid=$uid ";

		

  $pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_UINT);

	$recperpage = intval($vbulletin->options["classifieds_adscount"]);

	$boldcolor = $vbulletin->options["classifieds_boldcolor"];



  $totalrecords = $db->query_first("

    SELECT COUNT(*) AS totalrecords

    FROM ".TABLE_PREFIX."classifieds_ads

		$where

	");

  

  sanitize_pageresults($totalrecords['totalrecords'], $pagenumber, $recperpage, $recperpage, $recperpage);

  $limitlower = ($pagenumber - 1) * $recperpage + 1;

  $limitupper = $pagenumber * $recperpage;

  if($limitupper > $totalrecords['totalrecords']) {

    $limitupper = $totalrecords['totalrecords'];

    if($limitlower > $totalrecords['totalrecords'])

      $limitlower = $totalrecords['totalrecords'] - $recperpage;

  }

  if($limitlower <= 0) {

     $limitlower = 1;

  }



	$ads = $db->query_read("

		SELECT ".TABLE_PREFIX."classifieds_ads.*, ".TABLE_PREFIX."classifieds_categories.name AS catname,

			".TABLE_PREFIX."classifieds_subcategories.name AS subcatname, ".TABLE_PREFIX."user.username

		FROM ".TABLE_PREFIX."classifieds_ads

		JOIN ".TABLE_PREFIX."classifieds_categories

			ON ".TABLE_PREFIX."classifieds_categories.id=".TABLE_PREFIX."classifieds_ads.categoryid

		LEFT JOIN ".TABLE_PREFIX."classifieds_subcategories

			ON ".TABLE_PREFIX."classifieds_subcategories.id=".TABLE_PREFIX."classifieds_ads.subcategoryid

		JOIN ".TABLE_PREFIX."user

			ON ".TABLE_PREFIX."user.userid=".TABLE_PREFIX."classifieds_ads.userid

		$where

		ORDER BY ".TABLE_PREFIX."classifieds_ads.publishdate DESC, ".TABLE_PREFIX."classifieds_ads.activateddate DESC

		LIMIT " . ($limitlower - 1) . ", $recperpage

	");



	$classifieds = '';

	while($ad = $db->fetch_array($ads)) {

		$adid = $ad["id"];

		$photo = $db->query_first("SELECT photoname FROM ".TABLE_PREFIX."classifieds_photos WHERE adid=$adid AND istitlephoto=1");

		if(!$photo)

			$photo = $db->query_first("SELECT photoname FROM ".TABLE_PREFIX."classifieds_photos WHERE adid=$adid");

		if($photo)

			$ad["photoname"] = $photo["photoname"];

		else

			$ad["photoname"] = '';

		$ad["description"] = parseBbCode($ad["description"], $vbulletin->options["classifieds_maxchars"]);

		$ad["currency"] = getCurrency($ad["currency"]);

		$visits = $db->query_first("SELECT SUM(count) AS cnt FROM ".TABLE_PREFIX."classifieds_visits WHERE id=$adid GROUP BY id");

		$ad["viewcount"] = $visits["cnt"];

		if(empty($ad["viewcount"]))

			$ad["viewcount"] = 0;

		$title = sanitize_title($ad["title"]);

		eval('$classifieds .= "' . fetch_template('classifieds_ad') . '";');

	} 



	if($uid == 0)

  	$pagenav = construct_page_nav($pagenumber, $recperpage, $totalrecords['totalrecords'], "classifieds.php?" . $vbulletin->session->vars['sessionurl'] . "do=".$_REQUEST["do"]."&catid=$catid&subcatid=$subcatid");

	else

  	$pagenav = construct_page_nav($pagenumber, $recperpage, $totalrecords['totalrecords'], "classifieds.php?" . $vbulletin->session->vars['sessionurl'] . "do=".$_REQUEST["do"]."&userid=$uid&title=".$_REQUEST['title']);



	eval('$classifieds = "' . fetch_template('classifieds_adslist') . '";');



	return $classifieds;

}



function getCategoriesBlock($catid)

{

	global $db, $vbulletin, $vbphrase;

	

	if($catid == 0) {

		$categories = $db->query_read("SELECT id, name FROM ".TABLE_PREFIX."classifieds_categories ORDER BY displayorder");

		$condfield = "categoryid";

		$do = "category";

		$whatid = "catid";

	} else {

		$categories = $db->query_read("SELECT id, name FROM ".TABLE_PREFIX."classifieds_subcategories WHERE categoryid=$catid ORDER BY displayorder");

		$condfield = "subcategoryid";

		$do = "subcategory";

		$whatid = "catid=$catid&subcatid";

	}

	

	$columns = intval($vbulletin->options["classifieds_catlistingcolumns"]);

	$adsnumber = intval($vbulletin->options["classifieds_catlistingadspercategory"]);;

	

	$html = '';

	$count = 0;

	$col = 0;

	$now = time();

	if($db->num_rows($categories) != 0) {

		$html = '<table width="100%">';

		while($cat = $db->fetch_array($categories)) {

			if($col == 0)

				$html .= '<tr>';

			

			$title = sanitize_title($cat["name"]);

			$adslisting = '';

			$ads = $db->query_read("

				SELECT id, title 

				FROM ".TABLE_PREFIX."classifieds_ads

				WHERE $condfield=".$cat["id"]." AND active=1 AND hidden=0 AND approved=1

					AND publishdate<=$now AND (expirationdate=0 OR expirationdate>$now) 

				ORDER BY publishdate DESC, activateddate DESC LIMIT $adsnumber");

			while($ad = $db->fetch_array($ads)) {

				$adtitle = sanitize_title($ad["title"]);

				eval('$adslisting .= "' . fetch_template('classifieds_categorieslistingadline') . '";');

			}

			if($db->num_rows($ads) == 0)

				$adslisting = '<tr><td><div align="center" class="smallfont">'.$vbphrase["classifieds_no_ads_in_category"].

					"<a href=\"classifieds.php?do=editad&$whatid=".$cat['id']."\">".$vbphrase["classifieds_post_your_now"]."</a>".'</div>';

			eval('$html .= "' . fetch_template('classifieds_categorieslistingblock') . '";');

			

			$col++;

			if($col == $columns) {

				$html .= '</tr>';

				$col = 0;

			}

			$count++;

		}

		if($col != 0 && $count > 0)

			$html .= '</tr>';

		$html .= '</table>';

	}

	

	return $html;

}



function dependentcombojs($first = false, $firstname = '')

{

	global $db, $vbphrase;

	

	$jscode = '

	function catChanged(box)

	{

		var first = box.options[box.selectedIndex].value;

		var second = document.getElementById("subcategory");



		for(m = second.options.length - 1; m >= 0; m--)

			second.options[m] = null;

		second.options.length = 0;



		if(typeof subcategories[first] != "undefined") {

			var offset = 0;

			if(typeof subcategories[first][0] == "undefined")

				offset = 1;

			for(i = offset; i < subcategories[first].length; i++) {

				second.options[i - offset] = new Option(subcategories[first][i][1], subcategories[first][i][2]);

			}

		} else

			i = 0;



	  if(second.options.length == 0)

	   	second.options[i] = new Option("'.$firstname.'", 0);

	

		subCatChanged();

	}



  function subCatChanged()

  {

		var adid = document.forms["ad"].adid.value;

    var catid = document.forms["ad"].catid.options[document.forms["ad"].catid.selectedIndex].value;

    var subcatid = document.forms["ad"].subcatid.options[document.forms["ad"].subcatid.selectedIndex].value;



		jQuery.get("classifieds.php?do=renderfields&adid=" + adid + "&catid=" + catid + "&subcatid=" + subcatid, {},

			function (fields) {document.getElementById("extrafields").innerHTML=fields;});

  }

	';



	$cats_get = $db->query_read("SELECT id, allowposting FROM ".TABLE_PREFIX."classifieds_categories");

	$cats = array();

	while($cat = $db->fetch_array($cats_get))

		$cats[$cat['id']] = $cat['allowposting'];



	$categories = $db->query_read("SELECT id, name, categoryid FROM ".TABLE_PREFIX."classifieds_subcategories ORDER BY displayorder");

	$options = array();

	while($row = $db->fetch_array($categories)) {

		$options[$row['categoryid']][] = $row;

	}



  $jscode .= "var subcategories = new Array(".count($options).");\n";

	foreach($options as $optgroup) {

		$cnt = count($optgroup) + 1;

		$id = $optgroup[0]['categoryid'];

		$jscode .= "subcategories[$id] = new Array($cnt);\n";

		if($first && $cats[$id])

			$jscode .= "subcategories[$id][0] = new Array(0, '$firstname', '0');\n";



		$n = 1;

		foreach($optgroup as $option) {

			$jscode .= "subcategories[$id][$n] = new Array(".$option['id'].", '".$option['name']."', '".$option['id']."');\n";

			$n++;

		}

	}

	

	return $jscode;

}



function getCategoriesOptions($selected, $all)

{

  global $db, $vbphrase, $vbphrase;

  

  $categories = '';

  if($all) {

    if($selected == 0)

      $sel = "selected";

    else

      $sel = "";

      

    $categories .= '<option value="-1" '.$sel.'>'.$vboption["classifieds_all"].'</option>'."\n";

  }



  $cats = $db->query_read("SELECT id, name FROM ".TABLE_PREFIX."classifieds_categories ORDER BY displayorder");

  while($cat = $db->fetch_array($cats)) {

    if($cat["id"] == $selected)

      $sel = "selected";

    else

      $sel = "";

  

    $categories .= '<option value="'.$cat["id"].'" '.$sel.' >'.$cat["name"].'</option>'."\n";

  }

  

  return $categories;

}



function getSubcategoriesOptions($catid, $selected, $none)

{

	global $db, $vbphrase;



	if($none)

		$subcats = '<option value="0">'.$vbphrase["classifieds_none"].'</option>';

	if($catid == 0) {

		$cat = $db->query_first("SELECT id, name FROM ".TABLE_PREFIX."classifieds_categories ORDER BY displayorder");

		$catid = $cat["id"];

	}

	$subcategories = $db->query_read("SELECT id, name FROM ".TABLE_PREFIX."classifieds_subcategories

		WHERE categoryid=$catid ORDER BY displayorder");

	while($subcat = $db->fetch_array($subcategories)) {

		$sel = $selected == $subcat["id"] ? 'selected' : '';

		$subcats .= '<option value="'.$subcat["id"].'" '.$sel.' >'.$subcat["name"].'</option>';

	}

	

	return $subcats;

}



function fileExtension($filename)

{

    $path_info = pathinfo($filename);

    return $path_info['extension'];

}



function fileName($filename)

{

    $path_info = pathinfo($filename);

    return $path_info['basename'];

}



function processUploadedPhoto($tmpfilename, $name, $existingfilename,

                              $maxwidth = 0, $maxheigth = 0,

                              $maxthumbwidth = 0, $maxthumbheigth = 0

                              )

{

  global $db, $vbulletin;



  $image = &vB_Image::fetch_library($vbulletin);

  $imageinfo = $image->fetch_image_info($tmpfilename);

  if(!$imageinfo)

    return "";



  if(!empty($existingfilename)) {

    @unlink(DIR . '/classifieds/photos/' . $existingfilename);

    @unlink(DIR . '/classifieds/photos/thumbs/' . $existingfilename);

  }



  $filename = md5(time() + rand()).'.'.fileExtension($name);

  if($imageinfo[0] > $maxwidth || $imageinfo[1] > $maxheight) {

    if($image->is_valid_resize_type($imageinfo[2])) { 

      move_uploaded_file($tmpfilename, DIR . '/classifieds/photos/tmp/' . $filename);

      $resized = $image->fetch_thumbnail($filename, DIR . '/classifieds/photos/tmp/' . $filename, $maxwidth, $maxheight);

      @$file = fopen(DIR . '/classifieds/photos/' . $filename, 'w');

      @fwrite($file, $resized["filedata"]);

      @fclose($file);

      @unlink(DIR . '/classifieds/photos/tmp/' . $filename);

    } else

      return "";

  } else {

    move_uploaded_file($tmpfilename, DIR . '/classifieds/photos/' . $filename);

  }



  if($imageinfo[0] > $maxthumbwidth || $imageinfo[1] > $maxthumbheight) {

  	$thumb = $image->fetch_thumbnail($filename, DIR . '/classifieds/photos/' . $filename, $maxthumbwidth, $maxthumbheight);

  	@$file = fopen(DIR . '/classifieds/photos/thumbs/' . $filename, 'w');

  	@fwrite($file, $thumb["filedata"]);

  	@fclose($file);

	} else {

  	@$file = fopen(DIR . '/classifieds/photos/thumbs/' . $filename, 'w');

  	@fwrite($file, $image["filedata"]);

  	@fclose($file);

	}



  return $filename;

}



function getAdPictures($adid)

{

	global $db, $vbphrase;

	

	$pictures = $db->query_read("SELECT id, photoname, istitlephoto FROM ".TABLE_PREFIX."classifieds_photos WHERE adid=$adid");

	if($db->num_rows($pictures) > 0) {

		$html = '<table width="100%">';

		$idx = 0;

		while($picture = $db->fetch_array($pictures)) {

			if($idx == 0)

				$html .= '<tr>';

			

			$html .= '<td><img src="classifieds/photos/thumbs/'.$picture["photoname"].'" /><br />';

			$html .= '<input type="radio" name="titlephoto" value="'.$picture["id"].'" '.($picture['istitlephoto'] == 1 ? 'checked="checked"' : '').' />&nbsp;'.$vbphrase["classifieds_istitlephoto"].'<br />';

			$html .= '<input type="checkbox" name="delete['.$picture["id"].']" value="'.$picture["id"].'" />&nbsp;'.$vbphrase["classifieds_delete"].'</td>';

		

			$idx++;

			if($idx == 3) {

				$html .= '</tr>';

				$idx = 0;

			}

		}

		if($idx != 0)

			$html .= '</tr>';

		$html .= '</table>';

	} else

		$html = '&nbsp;';

	

	return $html;

}



function parseBbCode($bbcode, $limit = 0)

{

  global $vbulletin;



  require_once(DIR . '/includes/class_bbcode.php');

	$parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());

	$text = $parser->do_parse($bbcode);

	if($limit != 0) {

		if(strlen($text) > $limit)

			$text = substr($text, 0, $limit).' ...';

	}



  return $text;

}



function recordVisit($userid, $id)

{

  global $db;



  if($userid == 0)

    $userid = $_SERVER['REMOTE_ADDR'];



  $lasttime = time() - 60*15;

  $access = $db->query_first("SELECT id FROM ".TABLE_PREFIX."classifieds_visits

    WHERE id=$id AND visitorid='$userid' AND time>$lasttime");

  if(!$access) {

    $now = time();

    $access = $db->query_first("SELECT id FROM ".TABLE_PREFIX."classifieds_visits

      WHERE id=$id AND visitorid='$userid'");

    if($access) {

      $db->query_write("UPDATE ".TABLE_PREFIX."classifieds_visits SET count=count+1, time=$now

                       WHERE id=$id AND visitorid='$userid'");

    } else {

      $db->query_write("INSERT INTO ".TABLE_PREFIX."classifieds_visits (visitid, id, visitorid, count, time)

                     VALUES (NULL, $id, '$userid', 1, $now)");

    }

  }

}



function getRatingImg($rating)

{

  if(empty($rating))

    $rating = 0;

  else

    $rating = doubleval($rating);



  $full = floor($rating);

  $half = round($rating-$full);

  for($i = 0; $i < 5; $i++) {

    if($i < $full)

      $img .= '<img src="classifieds/images/rating_full.gif" />';

    else if($i < $full + $half)

      $img .= '<img src="classifieds/images/rating_half.gif" />';

    else

      $img .= '<img src="classifieds/images/rating_empty.gif" />';



    if($i != 4)

      $img .= '<img src="classifieds/images/rating_spacer.gif" />';

  }



  return $img;

}



function paymentUrlPayPal($item, $quantity, $amount, $tax, $handling, 

                     $shipping, $currency, $business, $transid, $return, $finish, $testing, $what)

{

  global $vbulletin;

  

  if($testing)

    $ipn = "https://www.sandbox.paypal.com/cgi-bin/webscr";

  else

    $ipn = "https://www.paypal.com/cgi-bin/webscr";



  $url = $ipn . "?cmd=_xclick&business=".urlencode($business)."&item_name=".urlencode($item)."&amount=$amount".

                 "&handling=$handling&shipping=$shipping&tax=$tax&quantity=$quantity".

                 "&currency_code=$currency&return=".urlencode($return).

                 "&custom=$transid";

  if($finish)

    $url .= "&notify_url=".urlencode($vbulletin->options["bburl"] . "/classifieds/paypalgateway.php?do=$what");

                 

  return $url;  

}



function getCurrency($currency = -1)

{

	global $vbulletin, $vbphrase;

	

	if($currency == -1)

		$currency = $vbulletin->options["classifieds_currency"];

	switch($currency) {

    case 1: return "AUD";

    case 2: return "CAD";

    case 3: return "CHF";

    case 4: return "DKK";

    case 5: return "EUR";

    case 6: return "GBP";

    case 7:	return "HKD";

    case 8:	return "JPY";

    case 9: return "NOK";

    case 10: return "NZD";

    case 11: return "SEK";

    case 12: return "USD";

	}

}



function vbcdate($date)

{

  global $vbulletin;



  return date($vbulletin->options["classifieds_dateformat"], $date);

}



function renderGroup($html, $groupid)

{

	global $db, $vbphrase;



	$group = $db->query_first("SELECT name FROM ".TABLE_PREFIX."classifieds_fieldgroups WHERE id=$groupid");

	eval('$grouphtml = "' . fetch_template('classifieds_fieldgroup') . '";');

	

	return $grouphtml;

}



function renderExtraFields($catid, $subcatid, $adid)

{

	global $db, $vbphrase;

	

	$where = "WHERE categoryid=$catid ";

	if(!($subcatid == 0 || $subcatid == -1))

		$where .= "AND subcategoryid=$subcatid ";

	else

		$where .= "AND subcategoryid=0 ";

		

	$fields = $db->query_read("

		SELECT ".TABLE_PREFIX."classifieds_fields.*, ".TABLE_PREFIX."classifieds_fieldvalues.id AS valueid,

			".TABLE_PREFIX."classifieds_fieldvalues.intvalue, ".TABLE_PREFIX."classifieds_fieldvalues.textvalue,

			 ".TABLE_PREFIX."classifieds_field_group.groupid

		FROM ".TABLE_PREFIX."classifieds_fieldgroup_category

		JOIN ".TABLE_PREFIX."classifieds_field_group

			ON ".TABLE_PREFIX."classifieds_field_group.groupid=".TABLE_PREFIX."classifieds_fieldgroup_category.groupid

		JOIN ".TABLE_PREFIX."classifieds_fields

			ON ".TABLE_PREFIX."classifieds_fields.id=".TABLE_PREFIX."classifieds_field_group.fieldid

		JOIN ".TABLE_PREFIX."classifieds_fieldgroups

			ON ".TABLE_PREFIX."classifieds_fieldgroups.id=".TABLE_PREFIX."classifieds_fieldgroup_category.groupid

		LEFT JOIN ".TABLE_PREFIX."classifieds_fieldvalues

			ON ".TABLE_PREFIX."classifieds_fieldvalues.fieldid=".TABLE_PREFIX."classifieds_fields.id

			AND ".TABLE_PREFIX."classifieds_fieldvalues.adid=$adid

		$where

		ORDER BY ".TABLE_PREFIX."classifieds_fieldgroups.displayorder, ".TABLE_PREFIX."classifieds_fields.displayorder

	");

	$html = '';

	$grouphtml = '';

	$groupid = 0;

	while($field = $db->fetch_array($fields)) {

		if($groupid == 0)

			$groupid = $field["groupid"];

		if($field["groupid"] != $groupid) {

			$html .= renderGroup($grouphtml, $groupid);

			$groupid = $field["groupid"];

			$grouphtml = '';

		}

		

		switch($field["type"]) {

			case 1: $grouphtml .= renderTextField($field); break;

			case 2: $grouphtml .= renderRadioField($field); break;

			case 3: $grouphtml .= renderCheckboxField($field); break;

			case 4: $grouphtml .= renderLongTextField($field); break;

			case 5: $grouphtml .= renderDropDownField($field); break;

			case 6: $grouphtml .= renderMultiselectField($field); break;

		}

	}

	if($groupid != 0)

		$html .= renderGroup($grouphtml, $groupid);



	return $html;

}



function renderTextField($field)

{

	global $vbphrase;

	

	eval('$html = "' . fetch_template('classifieds_fieldtext') . '";');

	return $html;

}



function getFieldOptions($fieldid)

{

	global $db, $vbphrase;

	

	$options = array();

	$options_get = $db->query_read("SELECT * FROM ".TABLE_PREFIX."classifieds_field_option WHERE fieldid=$fieldid ORDER BY displayorder");

	while($option = $db->fetch_array($options_get)) 

		$options[$option["id"]] = $option["name"];

		

	return $options;

}



function renderRadioField($field)

{

	global $vbphrase;

	

	$options = getFieldOptions($field["id"]);

	$html = '';

	$first = true;

	foreach($options as $optionid => $optionname) {

		$checked = $field["intvalue"] == $optionid ? 'checked' : ''; 

		if(empty($field["intvalue"]) && $first) {

			$checked = 'checked';

			$first = false;

		}

		$html .= (empty($html) ? '' : '<br />').'<input type="radio" name="field[radio_'.$field["id"].']" value="'.$optionid.'" '.$checked.' />&nbsp;'.$optionname;

	}

	eval('$html = "' . fetch_template('classifieds_fieldradio') . '";');

	

	return $html;

}



function renderCheckboxField($field)

{

	global $vbphrase;

	

	$options = getFieldOptions($field["id"]);

	$html = '';

	$selectedoptions = split(',', $field["textvalue"]);

	foreach($options as $optionid => $optionname) {

		$checked = in_array($optionid, $selectedoptions) ? 'checked' : '';

		$html .= (empty($html) ? '' : '<br />').'<input type="checkbox" name="field[check_'.$field["id"].'][]" value="'.$optionid.'" '.$checked.' />&nbsp;'.$optionname;

	}

	eval('$html = "' . fetch_template('classifieds_fieldcheckbox') . '";');

	

	return $html;

}



function renderLongTextField($field)

{

	global $db, $vbphrase;



	if(!empty($field["valueid"]))

		$text = $db->query_first("SELECT text FROM ".TABLE_PREFIX."classifieds_fieldtexts WHERE fieldvalueid=".$field["valueid"]);

	else

		$text["text"] = '';

	$field["textvalue"] = $text["text"];

	eval('$html = "' . fetch_template('classifieds_fieldlongtext') . '";');

	return $html;

}



function renderDropDownField($field)

{

	global $vbphrase;

	

	$options = getFieldOptions($field["id"]);

	$html = '';

	foreach($options as $optionid => $optionname) {

		$selected = $field["intvalue"] == $optionid ? 'selected' : ''; 

		if(empty($field["intvalue"]) && $first) {

			$selected = 'selected';

			$first = false;

		}

		$html .= '<option value="'.$optionid.'" '.$selected.' />'.$optionname.'</option>';

	}

	eval('$html = "' . fetch_template('classifieds_fielddropdown') . '";');

	

	return $html;	

}



function renderMultiselectField($field)

{

	global $vbphrase;

	

	$options = getFieldOptions($field["id"]);

	$html = '';

	$selectedoptions = split(',', $field["textvalue"]);

	foreach($options as $optionid => $optionname) {

		$selected = in_array($optionid, $selectedoptions) ? 'selected' : '';

		$html .= '<option value="'.$optionid.'" '.$selected.' />'.$optionname.'</option>';

	}

	eval('$html = "' . fetch_template('classifieds_fieldmultiselect') . '";');

	

	return $html;	

}



function saveField($fieldid, $value, $adid)

{

	global $db;

	

	$field = $db->query_first("SELECT type FROM ".TABLE_PREFIX."classifieds_fields WHERE id=$fieldid");

	switch($field["type"]) {

		case 1: saveTextField($fieldid, $value, $adid); break;

		case 2: saveIntegerField($fieldid, $value, $adid); break;

		case 3: saveMultichoiceField($fieldid, $value, $adid); break;

		case 4: saveLongTextField($fieldid, $value, $adid); break;

		case 5: saveIntegerField($fieldid, $value, $adid); break;

		case 6: saveMultichoiceField($fieldid, $value, $adid); break;

	}

}



function hasFieldValue($fieldid, $adid)

{

	global $db;

	

	$value = $db->query_first("SELECT id FROM ".TABLE_PREFIX."classifieds_fieldvalues WHERE fieldid=$fieldid AND adid=$adid");

	if($value)

		return true;

		

	return false;

}



function saveTextField($fieldid, $value, $adid)

{

	global $db;

	

	$value = $db->escape_string($value);

	if(hasFieldValue($fieldid, $adid))

		$db->query_write("UPDATE ".TABLE_PREFIX."classifieds_fieldvalues SET textvalue='$value' WHERE fieldid=$fieldid AND adid=$adid");

	else

		$db->query_write("INSERT INTO ".TABLE_PREFIX."classifieds_fieldvalues (id, fieldid, adid, intvalue, textvalue)

			VALUES (NULL, $fieldid, $adid, 0, '$value')");

}



function saveIntegerField($fieldid, $value, $adid)

{

	global $db;

	

	$value = intval($value);

	if(hasFieldValue($fieldid, $adid))

		$db->query_write("UPDATE ".TABLE_PREFIX."classifieds_fieldvalues SET intvalue=$value WHERE fieldid=$fieldid AND adid=$adid");

	else

		$db->query_write("INSERT INTO ".TABLE_PREFIX."classifieds_fieldvalues (id, fieldid, adid, intvalue, textvalue)

			VALUES (NULL, $fieldid, $adid, $value, '$value')");

}



function saveMultichoiceField($fieldid, $value, $adid)

{

	global $db;

	

	$opts = array();

	foreach($value as $val)

		$opts[] = intval($val);

		

	$options = implode(',', $opts);

	if(hasFieldValue($fieldid, $adid))

		$db->query_write("UPDATE ".TABLE_PREFIX."classifieds_fieldvalues SET textvalue='$options' WHERE fieldid=$fieldid AND adid=$adid");

	else

		$db->query_write("INSERT INTO ".TABLE_PREFIX."classifieds_fieldvalues (id, fieldid, adid, intvalue, textvalue)

			VALUES (NULL, $fieldid, $adid, 0, '$options')");

}



function saveLongTextField($fieldid, $value, $adid)

{

	global $db;

	

	$value = $db->escape_string($value);

	if(hasFieldValue($fieldid, $adid)) {

		$fieldvalue = $db->query_first("SELECT id FROM ".TABLE_PREFIX."classifieds_fieldvalues WHERE fieldid=$fieldid AND adid=$adid");

		$db->query_write("UPDATE ".TABLE_PREFIX."classifieds_fieldtexts SET text='$value' WHERE fieldvalueid=".$fieldvalue["id"]);

	} else {

		$db->query_write("INSERT INTO ".TABLE_PREFIX."classifieds_fieldvalues (id, fieldid, adid, intvalue, textvalue)

			VALUES (NULL, $fieldid, $adid, 0, '')");

		$fieldvalueid = $db->insert_id();

		$db->query_write("INSERT INTO ".TABLE_PREFIX."classifieds_fieldtexts (fieldvalueid, text) VALUES ($fieldvalueid, '$value')");

	}

}



function showExtraFields($ad)

{

	global $db, $vbphrase;

	

	$where = "WHERE categoryid=".$ad["categoryid"];

	if(!$ad["subcategoryid"] == 0)

		$where .= " AND subcategoryid=".$ad["subcategoryid"];

	else

		$where .= " AND subcategoryid=0 ";

		

	$fields = $db->query_read("

		SELECT ".TABLE_PREFIX."classifieds_fields.*, ".TABLE_PREFIX."classifieds_fieldvalues.id AS valueid,

			".TABLE_PREFIX."classifieds_fieldvalues.intvalue, ".TABLE_PREFIX."classifieds_fieldvalues.textvalue,

			 ".TABLE_PREFIX."classifieds_field_group.groupid

		FROM ".TABLE_PREFIX."classifieds_fieldgroup_category

		JOIN ".TABLE_PREFIX."classifieds_field_group

			ON ".TABLE_PREFIX."classifieds_field_group.groupid=".TABLE_PREFIX."classifieds_fieldgroup_category.groupid

		JOIN ".TABLE_PREFIX."classifieds_fields

			ON ".TABLE_PREFIX."classifieds_fields.id=".TABLE_PREFIX."classifieds_field_group.fieldid

		JOIN ".TABLE_PREFIX."classifieds_fieldgroups

			ON ".TABLE_PREFIX."classifieds_fieldgroups.id=".TABLE_PREFIX."classifieds_fieldgroup_category.groupid

		LEFT JOIN ".TABLE_PREFIX."classifieds_fieldvalues

			ON ".TABLE_PREFIX."classifieds_fieldvalues.fieldid=".TABLE_PREFIX."classifieds_fields.id

			AND ".TABLE_PREFIX."classifieds_fieldvalues.adid=${ad['id']}

		$where

		ORDER BY ".TABLE_PREFIX."classifieds_fieldgroups.displayorder, ".TABLE_PREFIX."classifieds_fields.displayorder

	");

	$html = '';

	$grouphtml = '';

	$groupid = 0;

	while($field = $db->fetch_array($fields)) {

		if($groupid == 0)

			$groupid = $field["groupid"];

		if($field["groupid"] != $groupid) {

			$html .= showGroup($grouphtml, $groupid);

			$groupid = $field["groupid"];

			$grouphtml = '';

		}

		

		switch($field["type"]) {

			case 1: $grouphtml .= showTextField($field); break;

			case 2: $grouphtml .= showChoiceField($field); break;

			case 3: $grouphtml .= showMultiChoiceField($field); break;

			case 4: $grouphtml .= showLongTextField($field); break;

			case 5: $grouphtml .= showChoiceField($field); break;

			case 6: $grouphtml .= showMultiChoiceField($field); break;

		}

	}

	if($groupid != 0)

		$html .= showGroup($grouphtml, $groupid);



	return $html;

}



function showGroup($html, $groupid)

{

	global $db, $vbphrase;



	$group = $db->query_first("SELECT name FROM ".TABLE_PREFIX."classifieds_fieldgroups WHERE id=$groupid");

	eval('$grouphtml = "' . fetch_template('classifieds_showfieldgroup') . '";');

	

	return $grouphtml;

}



function showTextField($field)

{

	global $vbphrase;

	

	eval('$html = "' . fetch_template('classifieds_showfieldtext') . '";');

	return $html;

}



function showChoiceField($field)

{

	global $db, $vbphrase;



	if(empty($field["intvalue"])) $field["intvalue"] = -1;

	$option = $db->query_first("SELECT name FROM ".TABLE_PREFIX."classifieds_field_option WHERE id=".$field["intvalue"]);

	$field["textvalue"] = $option["name"];

	eval('$html = "' . fetch_template('classifieds_showfieldtext') . '";');

	

	return $html;	

}



function showMultiChoiceField($field)

{

	global $vbphrase;

	

	$options = getFieldOptions($field["id"]);

	$html = '';

	$selectedoptions = split(',', $field["textvalue"]);

	$selected = array();

	foreach($options as $optionid => $optionname) {

		if(in_array($optionid, $selectedoptions))

			$selected[] = $optionname;

	}

	$field["textvalue"] = implode(', ', $selected);

	eval('$html = "' . fetch_template('classifieds_showfieldtext') . '";');

	

	return $html;	

}



function showLongTextField($field)

{

	global $db, $vbphrase;



	if(!empty($field["valueid"]))

		$text = $db->query_first("SELECT text FROM ".TABLE_PREFIX."classifieds_fieldtexts WHERE fieldvalueid=".$field["valueid"]);

	else

		$text["text"] = '';

	$field["textvalue"] = $text["text"];

	eval('$html = "' . fetch_template('classifieds_showfieldtext') . '";');

	

	return $html;

}



function removeSlash($text)

{ 

  if(strrpos($text, "/") == strlen($text) -1)

    return substr($text, 0, strlen($text) - 1);

  

  return $text;

}



function sanitize_title($title) {



	$title = strip_tags($title);

	// Preserve escaped octets.

	$title = preg_replace('|%([a-fA-F0-9][a-fA-F0-9])|', '---$1---', $title);

	// Remove percent signs that are not part of an octet.

	$title = str_replace('%', '', $title);

	// Restore octets.

	$title = preg_replace('|---([a-fA-F0-9][a-fA-F0-9])---|', '%$1', $title);



	$title = remove_accents($title);

	if (seems_utf8($title)) {

		if (function_exists('mb_strtolower')) {

			$title = mb_strtolower($title, 'UTF-8');

		}

		$title = utf8_uri_encode($title);

	}



	$title = strtolower($title);

  $title = preg_replace('/&.+?;/', '', $title); // kill entities

	$title = preg_replace('/[^%a-z0-9 _-]/', '', $title);

	$title = preg_replace('/\s+/', '-', $title);

	$title = preg_replace('|-+|', '-', $title);

	$title = trim($title, '-');



	return $title;

}



function remove_accents($string) {

	if (seems_utf8($string)) {

		$chars = array(

		// Decompositions for Latin-1 Supplement

		chr(195).chr(128) => 'A', chr(195).chr(129) => 'A',

		chr(195).chr(130) => 'A', chr(195).chr(131) => 'A',

		chr(195).chr(132) => 'A', chr(195).chr(133) => 'A',

		chr(195).chr(135) => 'C', chr(195).chr(136) => 'E',

		chr(195).chr(137) => 'E', chr(195).chr(138) => 'E',

		chr(195).chr(139) => 'E', chr(195).chr(140) => 'I',

		chr(195).chr(141) => 'I', chr(195).chr(142) => 'I',

		chr(195).chr(143) => 'I', chr(195).chr(145) => 'N',

		chr(195).chr(146) => 'O', chr(195).chr(147) => 'O',

		chr(195).chr(148) => 'O', chr(195).chr(149) => 'O',

		chr(195).chr(150) => 'O', chr(195).chr(153) => 'U',

		chr(195).chr(154) => 'U', chr(195).chr(155) => 'U',

		chr(195).chr(156) => 'U', chr(195).chr(157) => 'Y',

		chr(195).chr(159) => 's', chr(195).chr(160) => 'a',

		chr(195).chr(161) => 'a', chr(195).chr(162) => 'a',

		chr(195).chr(163) => 'a', chr(195).chr(164) => 'a',

		chr(195).chr(165) => 'a', chr(195).chr(167) => 'c',

		chr(195).chr(168) => 'e', chr(195).chr(169) => 'e',

		chr(195).chr(170) => 'e', chr(195).chr(171) => 'e',

		chr(195).chr(172) => 'i', chr(195).chr(173) => 'i',

		chr(195).chr(174) => 'i', chr(195).chr(175) => 'i',

		chr(195).chr(177) => 'n', chr(195).chr(178) => 'o',

		chr(195).chr(179) => 'o', chr(195).chr(180) => 'o',

		chr(195).chr(181) => 'o', chr(195).chr(182) => 'o',

		chr(195).chr(182) => 'o', chr(195).chr(185) => 'u',

		chr(195).chr(186) => 'u', chr(195).chr(187) => 'u',

		chr(195).chr(188) => 'u', chr(195).chr(189) => 'y',

		chr(195).chr(191) => 'y',

		// Decompositions for Latin Extended-A

		chr(196).chr(128) => 'A', chr(196).chr(129) => 'a',

		chr(196).chr(130) => 'A', chr(196).chr(131) => 'a',

		chr(196).chr(132) => 'A', chr(196).chr(133) => 'a',

		chr(196).chr(134) => 'C', chr(196).chr(135) => 'c',

		chr(196).chr(136) => 'C', chr(196).chr(137) => 'c',

		chr(196).chr(138) => 'C', chr(196).chr(139) => 'c',

		chr(196).chr(140) => 'C', chr(196).chr(141) => 'c',

		chr(196).chr(142) => 'D', chr(196).chr(143) => 'd',

		chr(196).chr(144) => 'D', chr(196).chr(145) => 'd',

		chr(196).chr(146) => 'E', chr(196).chr(147) => 'e',

		chr(196).chr(148) => 'E', chr(196).chr(149) => 'e',

		chr(196).chr(150) => 'E', chr(196).chr(151) => 'e',

		chr(196).chr(152) => 'E', chr(196).chr(153) => 'e',

		chr(196).chr(154) => 'E', chr(196).chr(155) => 'e',

		chr(196).chr(156) => 'G', chr(196).chr(157) => 'g',

		chr(196).chr(158) => 'G', chr(196).chr(159) => 'g',

		chr(196).chr(160) => 'G', chr(196).chr(161) => 'g',

		chr(196).chr(162) => 'G', chr(196).chr(163) => 'g',

		chr(196).chr(164) => 'H', chr(196).chr(165) => 'h',

		chr(196).chr(166) => 'H', chr(196).chr(167) => 'h',

		chr(196).chr(168) => 'I', chr(196).chr(169) => 'i',

		chr(196).chr(170) => 'I', chr(196).chr(171) => 'i',

		chr(196).chr(172) => 'I', chr(196).chr(173) => 'i',

		chr(196).chr(174) => 'I', chr(196).chr(175) => 'i',

		chr(196).chr(176) => 'I', chr(196).chr(177) => 'i',

		chr(196).chr(178) => 'IJ',chr(196).chr(179) => 'ij',

		chr(196).chr(180) => 'J', chr(196).chr(181) => 'j',

		chr(196).chr(182) => 'K', chr(196).chr(183) => 'k',

		chr(196).chr(184) => 'k', chr(196).chr(185) => 'L',

		chr(196).chr(186) => 'l', chr(196).chr(187) => 'L',

		chr(196).chr(188) => 'l', chr(196).chr(189) => 'L',

		chr(196).chr(190) => 'l', chr(196).chr(191) => 'L',

		chr(197).chr(128) => 'l', chr(197).chr(129) => 'L',

		chr(197).chr(130) => 'l', chr(197).chr(131) => 'N',

		chr(197).chr(132) => 'n', chr(197).chr(133) => 'N',

		chr(197).chr(134) => 'n', chr(197).chr(135) => 'N',

		chr(197).chr(136) => 'n', chr(197).chr(137) => 'N',

		chr(197).chr(138) => 'n', chr(197).chr(139) => 'N',

		chr(197).chr(140) => 'O', chr(197).chr(141) => 'o',

		chr(197).chr(142) => 'O', chr(197).chr(143) => 'o',

		chr(197).chr(144) => 'O', chr(197).chr(145) => 'o',

		chr(197).chr(146) => 'OE',chr(197).chr(147) => 'oe',

		chr(197).chr(148) => 'R',chr(197).chr(149) => 'r',

		chr(197).chr(150) => 'R',chr(197).chr(151) => 'r',

		chr(197).chr(152) => 'R',chr(197).chr(153) => 'r',

		chr(197).chr(154) => 'S',chr(197).chr(155) => 's',

		chr(197).chr(156) => 'S',chr(197).chr(157) => 's',

		chr(197).chr(158) => 'S',chr(197).chr(159) => 's',

		chr(197).chr(160) => 'S', chr(197).chr(161) => 's',

		chr(197).chr(162) => 'T', chr(197).chr(163) => 't',

		chr(197).chr(164) => 'T', chr(197).chr(165) => 't',

		chr(197).chr(166) => 'T', chr(197).chr(167) => 't',

		chr(197).chr(168) => 'U', chr(197).chr(169) => 'u',

		chr(197).chr(170) => 'U', chr(197).chr(171) => 'u',

		chr(197).chr(172) => 'U', chr(197).chr(173) => 'u',

		chr(197).chr(174) => 'U', chr(197).chr(175) => 'u',

		chr(197).chr(176) => 'U', chr(197).chr(177) => 'u',

		chr(197).chr(178) => 'U', chr(197).chr(179) => 'u',

		chr(197).chr(180) => 'W', chr(197).chr(181) => 'w',

		chr(197).chr(182) => 'Y', chr(197).chr(183) => 'y',

		chr(197).chr(184) => 'Y', chr(197).chr(185) => 'Z',

		chr(197).chr(186) => 'z', chr(197).chr(187) => 'Z',

		chr(197).chr(188) => 'z', chr(197).chr(189) => 'Z',

		chr(197).chr(190) => 'z', chr(197).chr(191) => 's',

		// Euro Sign

		chr(226).chr(130).chr(172) => 'E');

		

		$string = strtr($string, $chars);

	} else {

		// Assume ISO-8859-1 if not UTF-8

		$chars['in'] = chr(128).chr(131).chr(138).chr(142).chr(154).chr(158)

			.chr(159).chr(162).chr(165).chr(181).chr(192).chr(193).chr(194)

			.chr(195).chr(196).chr(197).chr(199).chr(200).chr(201).chr(202)

			.chr(203).chr(204).chr(205).chr(206).chr(207).chr(209).chr(210)

			.chr(211).chr(212).chr(213).chr(214).chr(216).chr(217).chr(218)

			.chr(219).chr(220).chr(221).chr(224).chr(225).chr(226).chr(227)

			.chr(228).chr(229).chr(231).chr(232).chr(233).chr(234).chr(235)

			.chr(236).chr(237).chr(238).chr(239).chr(241).chr(242).chr(243)

			.chr(244).chr(245).chr(246).chr(248).chr(249).chr(250).chr(251)

			.chr(252).chr(253).chr(255);



		$chars['out'] = "EfSZszYcYuAAAAAACEEEEIIIINOOOOOOUUUUYaaaaaaceeeeiiiinoooooouuuuyy";



		$string = strtr($string, $chars['in'], $chars['out']);

		$double_chars['in'] = array(chr(140), chr(156), chr(198), chr(208), chr(222), chr(223), chr(230), chr(240), chr(254));

		$double_chars['out'] = array('OE', 'oe', 'AE', 'DH', 'TH', 'ss', 'ae', 'dh', 'th');

		$string = str_replace($double_chars['in'], $double_chars['out'], $string);

	}



	return $string;

}



function seems_utf8($Str) { # by bmorel at ssi dot fr

	for ($i=0; $i<strlen($Str); $i++) {

		if (ord($Str[$i]) < 0x80) continue; # 0bbbbbbb

		elseif ((ord($Str[$i]) & 0xE0) == 0xC0) $n=1; # 110bbbbb

		elseif ((ord($Str[$i]) & 0xF0) == 0xE0) $n=2; # 1110bbbb

		elseif ((ord($Str[$i]) & 0xF8) == 0xF0) $n=3; # 11110bbb

		elseif ((ord($Str[$i]) & 0xFC) == 0xF8) $n=4; # 111110bb

		elseif ((ord($Str[$i]) & 0xFE) == 0xFC) $n=5; # 1111110b

		else return false; # Does not match any model

		for ($j=0; $j<$n; $j++) { # n bytes matching 10bbbbbb follow ?

			if ((++$i == strlen($Str)) || ((ord($Str[$i]) & 0xC0) != 0x80))

			return false;

		}

	}



	return true;

}



function utf8_uri_encode( $utf8_string ) {

  $unicode = '';        

  $values = array();

  $num_octets = 1;

        

  for ($i = 0; $i < strlen( $utf8_string ); $i++ ) {

    $value = ord( $utf8_string[ $i ] );

    if ( $value < 128 ) {

      $unicode .= chr($value);

    } else {

      if ( count( $values ) == 0 ) $num_octets = ( $value < 224 ) ? 2 : 3;

      $values[] = $value;

      if ( count( $values ) == $num_octets ) {

      	if ($num_octets == 3) {

      	  $unicode .= '%' . dechex($values[0]) . '%' . dechex($values[1]) . '%' . dechex($values[2]);

      	} else {

      	  $unicode .= '%' . dechex($values[0]) . '%' . dechex($values[1]);

      	}



        $values = array();

        $num_octets = 1;

      }

    }

  }



  return $unicode;    

}



function expandDate($d)

{

	global $vbulletin;



	if($vbulletin->options["classifieds_inputdateformat"] == 1)

		$date = date('d/m/Y', $d);

	else

		$date = date('m/d/Y', $d);

	$hour = intval(date('G', $d));

	$min = intval(date('i', $d));

	

	return array($date, $hour, $min);

}



function getNumbers($start, $end, $selected)

{

	$options = '';

	for($i = $start; $i <= $end; $i++) {

		$sel = $i == $selected ? 'selected="selected"' : '';

		$options .= '<option value="'.$i.'" '.$sel.' >'.$i.'</option>';

	}

	

	return $options;

}



function getPointsAndCredits($categoryid, $subcategoryid)

{

	global $db;

	

 	if($subcategoryid != 0) {

		$value = $db->query_first("SELECT points, credits FROM ".TABLE_PREFIX."classifieds_subcategories WHERE id=$subcategoryid");

	} else {

		$value = $db->query_first("SELECT points, credits FROM ".TABLE_PREFIX."classifieds_categories WHERE id=$categoryid");

	}

	

	return array($value['points'], $value['credits']);

}



function getExpirationDays($catid, $subcatid)

{

	global $db;



	if($subcategoryid != 0)

		$value = $db->query_first("SELECT expirationdays FROM ".TABLE_PREFIX."classifieds_subcategories WHERE id=$subcatid");

	else

		$value = $db->query_first("SELECT expirationdays FROM ".TABLE_PREFIX."classifieds_categories WHERE id=$catid");

	

	return $value['expirationdays'];

}



?>
