<?php
if ($_REQUEST['do'] == 'editprofile')
{
	// Temporarily unregister this, we need to hook it
	$page_templater->unregister('customfields');
	
	// Create the edit username template
	$templater = vB_Template::create('dbtech_username_change_editusername');
	
	// Defaults
	$show['dbtech_changeusername'] 			= true;	// Can we change username?
	
	// Detect when the last edit was made (if at all)
	if ($lastedit = $db->query_first("
		SELECT changeid, change_time
		FROM " . TABLE_PREFIX . "userchangelog
		WHERE userid = " . $db->sql_prepare($vbulletin->userinfo['userid']) . "
			AND adminid = " . $db->sql_prepare($vbulletin->userinfo['userid']) . "
		ORDER BY changeid DESC
		LIMIT 1
	"))
	{
		// Register the last change time
		$templater->register('dbtech_lastchange', vbdate($vbulletin->options['dateformat'], $lastedit['change_time'], true));
	}
	else
	{
		// Might not be needed, but for bug prevention in the log if() below
		$lastedit['change_time'] = 0;
	}
	
	if (
		!($vbulletin->userinfo['permissions']['usernamechangepermissions'] & $vbulletin->bf_ugp_usernamechangepermissions['canchangeown']) OR
		($vbulletin->userinfo['permissions']['dbtech_username_changedelay'] AND $lastedit['change_time'] >= (TIMENOW - ($vbulletin->userinfo['permissions']['dbtech_username_changedelay'] * 86400)))
	)
	{
		// Don't show editusername
		$show['dbtech_changeusername'] = false;
		
		// Include reason
		$templater->register('dbtech_changeusername_reason', (
			!($vbulletin->userinfo['permissions']['usernamechangepermissions'] & $vbulletin->bf_ugp_usernamechangepermissions['canchangeown']) ?
			$vbphrase['dbtech_change_username_nopermission'] : 
			$vbphrase['dbtech_change_username_cooldown']
		));
	}
	
	// Finally render the template
	$customfields['required'] .= $templater->render();
	
	// Re-register this
	$page_templater->register('customfields', $customfields);
}
?>