<?php

// ++=========================================================================++
// || DTO Garage v1.1.3 - 1
// || Copyright  2008-2009 Drive Thru Online, Inc. All Rights Reserved.
// || This file may not be redistributed in whole or significant part, or
// || used on web site without licensing of the enclosed code,
// || and software features.
// || http://www.drivethruonline.com | info@drivethruonline.com
// || Downloaded 12:29, Wed Oct 7th 2009
// || 224278701_409535961079
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);

if (!@include 'functions_dto_garage_plus.php') {
	include 'functions_dto_garage.php';
}

static $DTO_garage_postbit_cache = array();

function DTO_garage_fetchFromCache($userID, $use_username_in_link, $usepostid, $onclick_launch_window)
{
    global $DTO_garage_postbit_cache;
    $key = $userID . ($use_username_in_link ? '_T' : '_F') . ($usepostid ? '_T' : '_F') . ($onclick_launch_window ? '_T' : '_F');
    return $DTO_garage_postbit_cache[$key];
}

function DTO_garage_putInCache($userID, $use_username_in_link, $usepostid, $onclick_launch_window, $content)
{
    global $DTO_garage_postbit_cache;
    $key = $userID . ($use_username_in_link ? '_T' : '_F') . ($usepostid ? '_T' : '_F') . ($onclick_launch_window ? '_T' : '_F');
    $DTO_garage_postbit_cache[$key] = $content;
}
  
function generate_garage_popup_menu($userinfo, $use_username_in_link = false, $usepostid = false, $onclick_launch_window=true) 
{	
// Function generate_garage_popup_menu
//  This function builds the pop-up menu to be used in various end-user facing interfaces.  
//    The resulting pop-up will display:
//      Username's Garage
//        thumbnail of vehicle 1 (if available) vehicle name or year make model of vehicle
//        thumbnail of vehicle 2 (if available) vehicle name or year make model of vehicle
//        etc
//  $userinfo - the userinfo of the owner of the garage you wish to build the popup for
//  $use_username_in_link - in the link that is shown include the owner's username
//  $onclick_launch_window - true (default)/false denoting whether, on clicking a link in the pop-up, that a new window should be created or the current one reused for display
//  Returns: complete content of needed pop-up if there were one or more vehicles in garage that are marked as being visible to other members
//           if no content NULL is returned	
	
    global $vbulletin, $db, $vbphrase, $post;
    $userID = $userinfo['userid'];
    $cacheHit = DTO_garage_fetchFromCache($userID, $use_username_in_link, $usepostid, $onclick_launch_window);
    if(!$cacheHit)
    {	
        // Determine if there is one or more visible vehicles in this user's garage
        $vehicles = $db->query_read("SELECT * FROM " . 
		            TABLE_PREFIX . "DTO_garage_vehicle WHERE userid = ". $userID . " AND display='1'");  

        $num_vehicles = $db->num_rows($vehicles);
        if($num_vehicles > 0) 
        {  	
            // Build the pop-up menu showing vehicle name (if named).  If not named use year, make, model for name. 
            $content = "";
            $popupbits = "";

            while($vehicle = $db->fetch_Array($vehicles))
            {
                $usethumb = false;
                $thumbname = NULL;
    
                // See if there is a main image for the car...if so, include it in the pop-up menu
                $image = $db->query_first("SELECT * from " .
    		                            TABLE_PREFIX . "DTO_garage_image WHERE vehicle_id = ". $vehicle['vehicle_id'] ." AND showinsections='main'");  
    
                if($image['image_id']!=0)
                { // Got a main image...use the thumb in the popup
                  	$usethumb = true;
                    $thumbname = $vbulletin->options['bburl']. "/" .$vbulletin->options['dto_garage_imagedir']. "/" .$image['userid']. "/" .$image['image_id']. "t.jpg";
                }
    
                if($vehicle['name'] != "")
                    $vehicle_name = $vehicle['name'];
                else
                    $vehicle_name = $vehicle['year']. " " .$vehicle['make']. " " .$vehicle['model'];
      
                $vehicle_id = $vehicle['vehicle_id'];
                eval('$popupbits .= "' . fetch_template('dto_garage_popup_menubit') . '";');
            }	
            
            DTO_garage_putInCache($userID, $use_username_in_link, $usepostid, $onclick_launch_window, $popupbits);
            $cacheHit = $popupbits;
        }
        else
        {
            //put a space in the cache to prevent reevaluation of the empty case
            DTO_garage_putInCache($userID, $use_username_in_link, $usepostid, $onclick_launch_window, ' ');    
            $cacheHit = ' ';
        } 	
    }

    if($cacheHit == ' ')
        return NULL;
    else
    {
        $popupbits = $cacheHit;
        eval('$content = "' . fetch_template('dto_garage_popup_menu') . '";');
        return $content;
    }
}

function generate_garage_user_profile($userinfo, $use_username_in_legend = true, $onclick_launch_window=true) {
	
// Function generate_garage_popup_menu
//  This function builds the user profile display of user garage entries if there are visible entries in this user's garage
//    The resulting display:
//        thumbnail of vehicle 1 (if available) vehicle name or year make model of vehicle
//        thumbnail of vehicle 2 (if available) vehicle name or year make model of vehicle
//        etc
//  $userinfo - the userinfo of the owner of the garage you wish to build the popup for
//  $use_username_in_legend - whether or not, in the resulting fieldset display if the username is shown in the legend, if false don't display fieldset surround
//  $onclick_launch_window - true (default)/false denoting whether, on clicking a link in the pop-up, that a new window should be created or the current one reused for display
//  Returns: complete content of display if there were one or more vehicles in garage that are marked as being visible to other members
//           if no content NULL is returned	
	
  global $vbulletin, $db, $vbphrase;

  // Make sure that this user has garage permissions before checking for garages entries...if not just return
  if(!garagePerms($userinfo))
    return null;
    
   // Determine if there is one or more visible vehicles in this user's garage
  $vehicles = $db->query_read("SELECT * FROM " . 
		TABLE_PREFIX . "DTO_garage_vehicle WHERE userid = ". $userinfo['userid'] . " AND display='1'");  

  $num_vehicles = $db->num_rows($vehicles);

  if($num_vehicles > 0) {
  	
    // Build the display showing vehicle name (if named).  If not named use year, make, model for name. 
    $content = "";
    $popupbits = "";

    while ($vehicle = $db->fetch_Array($vehicles)){

      $usethumb = false;
      $thumbname = NULL;

      // See if there is a main image for the car...if so, include it in the pop-up menu
      $image = $db->query_first("SELECT * from " .
		TABLE_PREFIX . "DTO_garage_image WHERE vehicle_id = ". $vehicle['vehicle_id'] ." AND showinsections='main'");  

      if($image['image_id']!=0){ // Got a main image...use the thumb in the popup
      	$usethumb = true;
        $thumbname = $vbulletin->options['bburl']. "/" .$vbulletin->options['dto_garage_imagedir']. "/" .$image['userid']. "/" .$image['image_id']. "t.jpg";
      }

      if($vehicle['name'] != "")
        $vehicle_name = $vehicle['name'];
      else
        $vehicle_name = $vehicle['year']. " " .$vehicle['make']. " " .$vehicle['model'];
  
      $vehicle_id = $vehicle['vehicle_id'];
      
      eval('$profilebits .= "' . fetch_template('dto_garage_profile_bit') . '";');
    }		

    eval('$content .= "' . fetch_template('dto_garage_profile') . '";');
    	
    return $content;
 
  } 
  else {
  	return null;  // No vehicles found that could be display in menu
  }
}

//  garage_index
//  Function to build paged index page
//      $perpage - how many desired results to show per page
//      $pagenumer - which page of results to display
//      &$pagenav - returned page navigation UI to use in master search results template
//      &$searchRows - returned search results content page to use in master search results template
function garage_index($perpage, $pagenumber, &$pagenav, &$indexRows) 
{
    global $db, $vbulletin;
    
	// Build query types for paged index function
	$count_query = "SELECT count(vehicle_id) as garageCount FROM " . TABLE_PREFIX . "DTO_garage_vehicle WHERE display=1";   
	
	$index_query = "SELECT g.vehicle_id, g.userid, u.username, g.name, g.year, g.make, g.model, g.time_modified, unix_timestamp(g.time_added) as time_added
	FROM " . TABLE_PREFIX . "DTO_garage_vehicle as g, ". TABLE_PREFIX . "user as u WHERE g.userid=u.userid AND display=1 ORDER BY time_added DESC";
        
	$info = $db->query_first($count_query);
	
	// Make sure all variables are good to use
	sanitize_pageresults($info['garageCount'], $pagenumber, $perpage, 100, 30);    

	// Default lower and upper limit variables
	$limitlower = ($pagenumber - 1) * $perpage + 1;
	$limitupper = $pagenumber * $perpage;
	if ($limitupper > $info['garageCount'])
	{
	    // Too many for upper limit
	    $limitupper = $info['garageCount'];
	    if ($limitlower > $info['garageCount'])
	    {
	        // Too many for lower limit
	        $limitlower = $info['garageCount'] - $perpage;
	    }
	}
	if ($limitlower <= 0)
	{
	    // Can't have negative or null lower limit
	    $limitlower = 1;
	}   
	
    $sql = $index_query. " LIMIT " . ($limitlower - 1) . ", $perpage";
    
  	$garages = $db->query_read($sql);

   	$pagenav = construct_page_nav($pagenumber, $perpage, $info['garageCount'], 'dto_garage.php?' . $vbulletin->session->vars['sessionurl'] . 'do=index');
      
  	$indexRowCells = "";
  	$indexRows = "";
  	$numInRow = 0;	
  		    	
  	// Output the page results
  	while ($garage = $db->fetch_Array($garages)) 
  	{  		 		
    	$vehicle_id = $garage['vehicle_id'];
    	$userid = $garage['userid'];
    	$line1 = unhtmlspecialchars($garage['username']);
    	$name = htmlspecialchars_uni($garage['name']); 
    	if(empty($name)) {
    	  $line2 = $garage['year']. " ".  htmlspecialchars_uni($garage['make']). " ". htmlspecialchars_uni($garage['model']);
    	}
    	else 
    	   $line2 = $name;
    	
    	// Get the main image for this garage
    	$sql = "SELECT image_id FROM ". TABLE_PREFIX . "DTO_garage_image WHERE vehicle_id = $vehicle_id AND userid = $userid AND showinsections='main'";
    	$garageImage = $db->query_first($sql);
    	
    	if($garageImage['image_id']) 
    	{ // Got an image so display it	  	
		  $thumbname = $vbulletin->options['bburl']. "/" .$vbulletin->options['dto_garage_imagedir']. "/" .$userid. "/" .$garageImage['image_id']. "t.jpg";
    	}
    	else 
    	{	
    	  $thumbname = $vbulletin->options['bburl']. "/images/dto_garage/images/no_image.jpg";	
    	}
    	
    	if($numInRow < 5) 
    	{
	      	eval('$indexRowCells .= "' . fetch_template('dto_garage_index_row_bits') . '";');  // Keep writing to current row
	      	$numInRow++;
    	}
	    else 
	    {
	      	eval('$indexRows .= "' . fetch_template('dto_garage_index_row') . '";');           // Write the entire row 
	      	eval('$indexRowCells = "' . fetch_template('dto_garage_index_row_bits') . '";');   // Start a new row	
	    	$numInRow = 1;	      	      	
	    }	    
  	}
  	
  	// Output any final cells that were left without being a complete row
  	if($numInRow)
	  eval('$indexRows .= "' . fetch_template('dto_garage_index_row') . '";');   // Write the entire row 
	  
	return true;    
}
?>
