<?php

// ++=========================================================================++
// || DTO Garage v1.1.3 - 1
// || Copyright  2008-2009 Drive Thru Online, Inc. All Rights Reserved.
// || This file may not be redistributed in whole or significant part, or
// || used on web site without licensing of the enclosed code,
// || and software features.
// || http://www.drivethruonline.com | info@drivethruonline.com
// || Downloaded 12:29, Wed Oct 7th 2009
// || 224278701_409535961079
// ++ ========================================================================++

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('NO_REGISTER_GLOBALS', 1);
define('THIS_SCRIPT', 'dto_garage_help');

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array();

// get special data templates from the datastore
$specialtemplates = array();

// pre-cache templates used by all actions
$globaltemplates = array(
    'dto_garage_help'  
);

// pre-cache templates used by specific actions
$actiontemplates = array();

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once('includes/adminfunctions.php');

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

   $userinfo = &$vbulletin->userinfo;
   
   // Determine the usergroup for the viewer
   //    If usergroup is Administrator and/or has "Can Admin Garages" provide them with access to admin docs for this version
     //    If the viewer is a member of any other group (not a banned group) show end user documentation.
   // Query Help Server to get proper version of help for the given product, version, and type of user
     
   // Get the list of products installed
   $products = fetch_product_list(true, false);
   
   // Determine the version of Clubs
   if($products['dto_garage']['version']) {
   	   	$prodname = $products['dto_garage']['productid'];	
   	   	$prodtitle = $products['dto_garage']['title'];
   		$version = $products['dto_garage']['version'];  
   }
   else {
		eval(standard_error(fetch_error('nogaragehelpversion')));			
   }

   $dto_page_title = $prodtitle. " Help";   
   
   $usertype = "none";
   
   // Determine the level of usergroup
   if (can_administer())
     	$usertype = "admin";
   else if(!is_member_of($vbulletin->userinfo, 8))	// Make sure that user isn't in the banned group
		$usertype = "user";	
    
    if($usertype != "none") {
    	// Do a URL request to the help server passing product varname, version, and usertype  	
    	$url = "http://help.drivethruonline.com/dto_help_director.php?p=$prodname&v=$version&u=$usertype";
	 	$help_url = @parse_url($url);
		if (!$help_url)
		{
		    eval(standard_error(fetch_error('invalid_garage_help_url')));				
		}
	
		if (!$help_url['port'])
		{
			$help_url['port'] = 80;
		}
		if (!$help_url['path'])
		{
			$help_url['path'] = '/';
		}
	
		$fp = @fsockopen($help_url['host'], ($help_url['port'] ? $help_url['port'] : 80), $errno, $errstr, 10);
		if (!$fp)
		{
			eval(standard_error(fetch_error('garage_help_connect_failed')));	
		}
	
		$send_headers = "POST $help_url[path] HTTP/1.0\r\n";
		$send_headers .= "Host: $help_url[host]\r\n";
		$send_headers .= "User-Agent: DTO Club Help\r\n";
		if ($help_url['query'])
		{
			$send_headers .= "Content-Type: application/x-www-form-urlencoded\r\n";
			$send_headers .= "Content-Length: " . strlen($help_url['query']) . "\r\n";
		}
		$send_headers .= "\r\n";
	
		fwrite($fp, $send_headers . $help_url['query']);
	
		$full_result = '';
		while (!feof($fp))
		{
			$result = fgets($fp, 1024);
			$full_result .= $result;
		}
	
		fclose($fp);
	
		preg_match('#^(.*)\r\n\r\n(.*)$#sU', $full_result, $matches);
		$headers = trim($matches[1]);
		$body = trim($matches[2]);	
		
		$error = null;	
		
		// See if any errors were returned
		if (preg_match('#<dto_error>(.+)</dto_error>#iU', $body, $matches))
		{
			$error = $matches[1];
		}
		else {
			if (preg_match('#<help productid="' . preg_quote($prodname, '#') . '">(.+)</help>#iU', $body, $matches))
			{
				$helptarget = $matches[1];
			}
			else if (preg_match('#<help>(.+)</help>#iU', $body, $matches))
			{
				$helptarget = $matches[1];
			}
			else
			{
	    	    eval(standard_error(fetch_error('nogaragehelpfounderror')));			
			}
		}    	
    }
    else { // User has no access to help
    	eval(standard_error(fetch_error('nogaragehelp')));
    }
    
   $navbits = array();   
   $navbits[''] = $dto_page_title;
   $navbits = construct_navbits($navbits);   
   
   eval('$navbar = "' . fetch_template('navbar') . '";');   
   eval('print_output("' . fetch_template('dto_garage_help') . '");');  

?>
