<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

$giftid = $vbulletin->input->clean_gpc('r', 'giftid', TYPE_UINT);
$gift = ($giftid ? $vbshop->cache['gift']["$giftid"] : false);

$categorys = array();
foreach ($vbshop->cache['category'] as $categoryid => $category)
{
	// Add the phrased category name to the array
	$categorys["$categoryid"] = $category['title'];
}

if (!count($categorys))
{
	// Missing categories
	print_stop_message('dbtech_vbshop_missing_x',
		$vbphrase['dbtech_vbshop_category'],
		$vbulletin->session->vars['sessionurl'],
		'modifycategory'
	);
}

if (!is_array($gift))
{
	// Non-existing gift
	$giftid = 0;
}

if ($giftid)
{
	// Edit
	print_cp_header(strip_tags(construct_phrase($vbphrase['dbtech_vbshop_editing_x_y'], $vbphrase['dbtech_vbshop_gift'], $gift['title'])));
	print_form_header('vbshop', 'updategift');
	construct_hidden_code('giftid', $giftid);
	print_table_header(construct_phrase($vbphrase['dbtech_vbshop_editing_x_y'], $vbphrase['dbtech_vbshop_gift'], $gift['title']));
}
else
{
	// Add
	print_cp_header($vbphrase['dbtech_vbshop_add_new_gift']);
	print_form_header('vbshop', 'updategift');	
	print_table_header($vbphrase['dbtech_vbshop_add_new_gift']);
	$userids = array();	
}

$gifticons = array('' => $vbphrase['none']);
if ($handle = opendir('dbtech/vbshop/images/gifts'))
{
	while (false !== ($file = readdir($handle)))
	{
		if ($file != '.' AND $file != '..' AND $file != 'index.html' AND $file != 'shop')
		{
			// Store the icon
			$gifticons["gifts/$file"] = $file;
		}
    }
    closedir($handle);
}

// Sort the array as a string
asort($gifticons, SORT_STRING);

$shopicons = array('' => $vbphrase['none']);
if ($handle = opendir('dbtech/vbshop/images/gifts/shop'))
{
	while (false !== ($file = readdir($handle)))
	{
		if ($file != '.' AND $file != '..' AND $file != 'index.html')
		{
			// Store the icon
			$shopicons["gifts/shop/$file"] = $file;
		}
    }
    closedir($handle);
}

// Sort the array as a string
asort($shopicons, SORT_STRING);

print_input_row($vbphrase['title'], 							'title', 					$gift['title']);
print_select_row($vbphrase['dbtech_vbshop_category'], 			'categoryid', 	$categorys, $gift['categoryid']);
print_textarea_row($vbphrase['description'], 					'description', 				$gift['description']);
print_input_row($vbphrase['display_order'], 					'displayorder', 			(isset($gift['displayorder']) ? $gift['displayorder'] : 10));
print_select_row($vbphrase['dbtech_vbshop_gift_icon'], 			'icon',			$gifticons,	$gift['icon']);
print_select_row($vbphrase['dbtech_vbshop_shop_icon'], 			'shopicon',		$shopicons,	$gift['shopicon']);
print_input_row($vbphrase['dbtech_vbshop_gift_price'], 			'price', 					(isset($gift['price']) ? $gift['price'] : 0));

print_submit_row(($giftid ? $vbphrase['save'] : $vbphrase['dbtech_vbshop_add_new_gift']));
print_cp_footer();


/*=======================================================================*\
|| ##################################################################### ||
|| # Created: 17:29, Sat Dec 27th 2008                                 # ||
|| # SVN: $RCSfile: gift.php,v $ - $Revision: $WCREV$ $
|| ##################################################################### ||
\*=======================================================================*/
?>