<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

if (!$vbulletin->userinfo['userid'] || !$vbulletin->options['dbtech_vbshop_steal_enabled'])
{
	// No permission to steal
	print_no_permission();
}

$vbulletin->input->clean_array_gpc('p', array(
	'from' => TYPE_STR,
));

// Stealing from
if (!$from = $db->query_first("
	SELECT userid, username, dbtech_vbshop_purchase, dbtech_vbshop_bank, dbtech_vbshop_immunity
	FROM " . TABLE_PREFIX . "user
	WHERE username = " . $db->sql_prepare(htmlspecialchars_uni($vbulletin->GPC['from']))
))
{
	eval(standard_error(fetch_error('invalid_user_specified')));
}

// Any buffs?
if (is_array($vbulletin->userinfo['dbtech_vbshop_purchase']))
{
	foreach ($vbulletin->userinfo['dbtech_vbshop_purchase'] as $purchaseid => $purchase)
	{
		if ($purchase['userid'] == $vbulletin->userinfo['userid'] && $vbshop->cache[$purchase['feature']][$purchase['featureid']]['itemtype'] == 'stealmore')
		{
			$value = unserialize($vbshop->cache[$purchase['feature']][$purchase['featureid']]['code']);

			$vbulletin->options['dbtech_vbshop_steal_amount'] += doubleval($value['value']);

			if ($vbulletin->options['dbtech_vbshop_steal_amount'] > 100)
			{
				$vbulletin->options['dbtech_vbshop_steal_amount'] = 100;
			}
		}
		else if ($purchase['userid'] == $vbulletin->userinfo['userid'] && $vbshop->cache[$purchase['feature']][$purchase['featureid']]['itemtype'] == 'stealchance')
		{
			$value = unserialize($vbshop->cache[$purchase['feature']][$purchase['featureid']]['code']);

			$vbulletin->options['dbtech_vbshop_steal_chance'] += doubleval($value['value']);

			if ($vbulletin->options['dbtech_vbshop_steal_chance'] > 100)
			{
				$vbulletin->options['dbtech_vbshop_steal_chance'] = 100;
			}
		}
	}
}

// Chance of stealing
$chance = doubleval($vbulletin->options['dbtech_vbshop_steal_chance']);

// % Stolen
$steal = doubleval($vbulletin->options['dbtech_vbshop_steal_amount']);

// % Lose
$lose = doubleval($vbulletin->options['dbtech_vbshop_steal_lose']);

// Bank Protection
$bank = doubleval($vbulletin->options['dbtech_vbshop_bank_protection']);

// Is the user immune?
require_once(DIR . '/includes/adminfunctions.php');
require_once(DIR . '/includes/adminfunctions_options.php');
$bitfielddefs =& fetch_bitfield_definitions('nocache|dbtech_vbshop_immunity');
foreach ($bitfielddefs AS $key => $val)
{
	if ($key == 'dbtech_vbshop_theft' AND ($from['dbtech_vbshop_immunity'] & $val))
	{
		// Woups, immune
		eval(standard_error(fetch_error('dbtech_vbshop_error_x', $vbphrase['dbtech_vbshop_recipient_immune'])));
	}
}

if (rand(1, 100) <= $chance)
{
	// Success
	$from_money = $vbulletin->db->query_first("select {$vbulletin->options[dbtech_vbshop_pointsfield]} from " . TABLE_PREFIX . "{$vbulletin->options[dbtech_vbshop_pointstable]} WHERE userid = " . $from['userid']);
	$from_money = $from_money[$vbulletin->options['dbtech_vbshop_pointsfield']];
	$bank_gain = 0;
	$wallet_gain = 0;

	// Anything from the bank?
	if ($from['dbtech_vbshop_bank'] > $bank)
	{
		$bank_gain = round(doubleval((($from['dbtech_vbshop_bank'] - $bank) / 100) * $steal), 2);
	}

	// Anything from the wallet?
	if ($from_money > 0)
	{
		$wallet_gain = round(doubleval((($from_money) / 100) * $steal), 2);
	}

	$total_gain = $wallet_gain + $bank_gain;

	// Update ze moneys!
	if ($bank_gain > 0)
	{
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "user
			SET dbtech_vbshop_bank = dbtech_vbshop_bank - $bank_gain
			WHERE userid = " . $from['userid'] . "
		");
	}

	if ($wallet_gain > 0)
	{
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "{$vbulletin->options[dbtech_vbshop_pointstable]}
			SET {$vbulletin->options[dbtech_vbshop_pointsfield]} = {$vbulletin->options[dbtech_vbshop_pointsfield]} - $wallet_gain
			WHERE userid = " . $from['userid'] . "
		");
	}

	if ($total_gain > 0)
	{
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "{$vbulletin->options[dbtech_vbshop_pointstable]}
			SET {$vbulletin->options[dbtech_vbshop_pointsfield]} = {$vbulletin->options[dbtech_vbshop_pointsfield]} + $total_gain
			WHERE userid = " . $vbulletin->userinfo['userid'] . "
		");
	}

	$pm_title = construct_phrase($vbphrase['dbtech_vbshop_steal_success_from_x'], $vbulletin->userinfo['username']);
	$pm_message = construct_phrase($vbphrase['dbtech_vbshop_steal_success_from_x_message'], $vbulletin->userinfo['username'], $bank_gain, $wallet_gain, $vbulletin->options['dbtech_vbshop_pointsname']);
	$report = construct_phrase($vbphrase['dbtech_vbshop_steal_success_report'], $bank_gain, $wallet_gain, $vbulletin->options['dbtech_vbshop_pointsname']);
}
else
{
	// Fail
	if ($userpoints > 0)
	{
		$bank_lose = round(doubleval(($vbulletin->userinfo['dbtech_vbshop_bank'] / 100) * $lose), 2);
		$lose = round(doubleval(($userpoints / 100) * $lose), 2);
	
		if ($lose > 0)
		{
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "{$vbulletin->options[dbtech_vbshop_pointstable]}
				SET {$vbulletin->options[dbtech_vbshop_pointsfield]} = {$vbulletin->options[dbtech_vbshop_pointsfield]} - $lose
				WHERE userid = " . $vbulletin->userinfo['userid'] . "
			");
		}

		if ($bank_lose > 0)
		{
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "user
				SET dbtech_vbshop_bank = dbtech_vbshop_bank - $bank_lose
				WHERE userid = " . $vbulletin->userinfo['userid'] . "
			");
		}
	}
	
	$total_lose = $lose + $bank_lose;	

	$pm_title = construct_phrase($vbphrase['dbtech_vbshop_steal_fail_from_x'], $vbulletin->userinfo['username']);
	$pm_message = construct_phrase($vbphrase['dbtech_vbshop_steal_fail_from_x_message'], $vbulletin->userinfo['username']);
	$report = construct_phrase($vbphrase['dbtech_vbshop_steal_fail_report'], $total_lose, $vbulletin->options['dbtech_vbshop_pointsname']);
}

$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
$pmdm->set_info('is_automated', true); // implies overridequota
$pmdm->set('fromuserid', $vbulletin->userinfo['userid']);
$pmdm->set('fromusername', $vbulletin->userinfo['username']);
$pmdm->setr('title', $pm_title);
$pmdm->set_recipients($vbulletin->GPC['from'], $vbulletin->userinfo['permissions'], 'cc');
$pmdm->setr('message', $pm_message);
$pmdm->set('dateline', TIMENOW);
$pmdm->set('allowsmilie', 0);

if (!$pmdm->pre_save())
{
	$errstr = '<ol>';
	foreach ($pmdm->errors as $errormsg)
	{
		$errstr .= "<li>$errormsg</li>";
	}
	$errstr .= '</ol>';
	eval(standard_error(fetch_error('dbtech_vbshop_error_x', $errstr)));
}
else
{
	if ($vbulletin->options['dbtech_vbshop_enablepm_steal'])
	{
		// Only send the PM if we rly need to
		$pmdm->save();
	}
	
	// Add to the navbits
	$navbits[''] = $pagetitle = $vbphrase['dbtech_vbshop_steal'];
	
	// draw cp nav bar
	$vbshop->construct_nav('steal');

	$templater = vB_Template::create('dbtech_vbshop_steal_report');
		$templater->register('pagetitle', 	$pagetitle);
		$templater->register('report', 		$report);
	$HTML = $templater->render();
}

/*======================================================================*\
|| #################################################################### ||
|| # Created: 22:38, Sun Sep 7th 2008								  # ||
|| # SVN: $Rev$									 					  # ||
|| #################################################################### ||
\*======================================================================*/
?>