<?php
/**
* Profile Block for Activity
*
* @package vBActivity
*/
class vB_ProfileBlock_vBShop extends vB_ProfileBlock
{
	/**
	* The name of the template to be used for the block
	*
	* @var string
	*/
	var $template_name = 'dbtech_vbshop_memberinfo_block';

	var $nowrap = true;

	/**
	* Variables to automatically prepare
	*
	* @var array
	*/
	var $auto_prepare = array();

	/**
	* Whether to return an empty wrapper if there is no content in the blocks
	*
	* @return bool
	*/
	function confirm_empty_wrap()
	{
		return false;
	}

	/**
	* Whether or not the block is enabled
	*
	* @return bool
	*/
	function block_is_enabled($id)
	{
		return (
			$this->registry->options['dbtech_vbshop_active'] /*AND
			!$this->profile->userinfo['dbtech_vbshop_excluded'] AND
			!($this->profile->userinfo['permissions']['dbtech_vbshoppermissions'] & $this->registry->bf_ugp_dbtech_vbshoppermissions['isexcluded'])*/
		? true : false);
	}

	/**
	* Prepare any data needed for the output
	*
	* @param	string	The id of the block
	* @param	array	Options specific to the block
	*/
	function prepare_output($id = '', $options = array())
	{
		global $show, $vbphrase, $vbshop, $template_hook, $vbulletin;
		
		if (intval($this->registry->versionnumber) == 3)
		{
			$this->nowrap = false;
		}
		
		
		/*
		if ($this->registry->options['dbtech_vbshop_enable_stats'])
		{
			// We're showing stats
			$show['stats_block'] = true;
			
			$this->block_data['level'] = $userinfo['activitylevel'];
			$this->block_data['tonextlevel'] = $userinfo['tonextlevel'];
			$this->block_data['tnlphrase'] = construct_phrase($vbphrase['dbtech_vbshop_tnl_data'], $userinfo['levelpercent']);
			$this->block_data['userinfo'] = $userinfo;
		}
		*/
		
		// Ensure our purchases cache is up to specs
		$vbshop->verify_purchases($this->profile->userinfo);
		
		// Build a better mouse trap
		$features 	= array();
		$lookup 	= array();
		foreach ((array)$this->profile->userinfo['dbtech_vbshop_purchase'] as $purchaseid => $purchase)
		{
			if (!is_array($vbshop->cache["$purchase[feature]"]["$purchase[featureid]"]))
			{
				// Rebuild the cache automatically
				$vbshop->build_cache("dbtech_vbshop_{$purchase[feature]}");
				continue;
			}
			
			if ($purchase['userid'] != $this->profile->userinfo['userid'])
			{
				// We're not displaying stuff not intended for us
				continue;
			}
			
			// Cache the results
			$features["$purchase[feature]"]["$purchaseid"] = $purchase;
			
			if ($purchase['feature'] == 'gift' AND $purchase['buyer'] != $this->profile->userinfo['userid'])
			{
				// Lookup username
				$lookup["$purchase[buyer]"] = '';
			}
		}
		
		if (!empty($lookup))
		{
			// Grab people who bought this for us
			$users_q = $this->registry->db->query_read_slave("
				SELECT userid, username
				FROM " . TABLE_PREFIX . "user
				WHERE userid IN(" . implode(',', array_keys($lookup)) . ")
			");
			while ($users_r = $this->registry->db->fetch_array($users_q))
			{
				// Store username
				$lookup["$users_r[userid]"] = $users_r['username'];
			}
			$this->registry->db->free_result($users_q);
			unset($users_r);
		}
		
		foreach (array('gift') AS $feature)
		{
			//if (!$this->registry->options["dbtech_vbshop_enable_{$feature}s"])
			//{
				// We're not displaying
				//continue;
			//}
			
			// We're showing achievements
			$show["{$feature}_block"] = true;
			
			// Ensure this is an array
			$features["$feature"] = (!is_array($features["$feature"]) ? array() : $features["$feature"]);
			
			// Emulate order by dateline desc
			krsort($features["$feature"], SORT_NUMERIC);
			
			// Init some important vars
			$bits = '';
			foreach ($features["$feature"] as $purchaseid => $purchase)
			{
				// Shorthand featureinfo
				$featureinfo = $vbshop->cache["$feature"]["$purchase[featureid]"];
				
				if ($purchase['buyer'] == $this->profile->userinfo['userid'])
				{
					$phrase = construct_phrase(
						$vbphrase['dbtech_vbshop_gift_purchased_x'],
						vbdate($this->registry->options['dateformat'], $purchase['dateline']) . ' ' . vbdate($this->registry->options['timeformat'], $purchase['dateline']),
						$this->profile->userinfo['username']
					);					
				}
				else
				{
					$phrase = construct_phrase(
						$vbphrase['dbtech_vbshop_gift_received_x_from_y'],
						vbdate($this->registry->options['dateformat'], $purchase['dateline']) . ' ' . vbdate($this->registry->options['timeformat'], $purchase['dateline']),
						$lookup["$purchase[buyer]"]
					);					
				}
				
				$templater = vB_Template::create('dbtech_vbshop_memberinfo_purchasebit');
					$templater->register('feature', $featureinfo);
					$templater->register('phrase', $phrase);
				$bits .= $templater->render();
			}
			
			$this->block_data["{$feature}s"] 		= $bits;
			$this->block_data["{$feature}count"] 	= vb_number_format(count($features["$feature"]));
		}
		
		/*
		($hook = vBulletinHook::fetch_hook('dbtech_vbshop_block')) ? eval($hook) : false;
		
		if ($this->registry->options['dbtech_vbshop_enable_stats'])
		{
			$show['points_block'] = true;
			
			// Shorthand
			$userid =& $this->profile->userinfo['userid'];
			
			// Start the list of SQL subqueries
			$SQL = array();
			
			foreach ($vbshop->cache['type'] as $typeid => $type)
			{
				if (!$type['active'] OR !($type['display'] & 1))
				{
					// This type wasn't even active
					continue;
				}
				
				// Set column name
				$SQL["$type[typename]"] = $type['typename'];
			}
			
			if ($SQL)
			{
				$results = $this->registry->db->query_first_slave("
					SELECT
						" . implode(',', $SQL) . "
					FROM " . TABLE_PREFIX . "dbtech_vbshop_points
					WHERE userid = " . $userid . "
				");
			}
			
			$pointbits = '';
			foreach ($SQL as $key => $value)
			{
				$templater = vB_Template::create('dbtech_vbshop_memberinfo_pointsbit');
					$templater->register('phrase', $vbphrase["dbtech_vbshop_condition_per{$key}"]);
					$templater->register('points', doubleval($results["$key"]));
				$pointbits .= $templater->render();
			}
			$this->block_data['points'] = $pointbits;
		}
		*/
	}
}
?>