<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

$gifts_by_category 	= array();
foreach ((array)$vbshop->cache['gift'] as $giftid => $gift)
{
	// Index by categoryid
	$gifts_by_category["$gift[categoryid]"]["$giftid"] = $gift;
}

print_cp_header($vbphrase['dbtech_vbshop_gift_management']);

// Table header
$headings = array();
$headings[] = $vbphrase['title'];
$headings[] = $vbphrase['dbtech_vbshop_shop_icon'];
$headings[] = $vbphrase['description'];
$headings[] = $vbphrase['display_order'];
$headings[] = $vbphrase['dbtech_vbshop_gift_price'];
$headings[] = $vbphrase['edit_permissions'];

// Hook goes here

$headings[] = $vbphrase['edit'];
$headings[] = $vbphrase['delete'];

if (count($gifts_by_category))
{
	print_form_header('vbshop', 'dogiftorder');	
	print_table_header($vbphrase['dbtech_vbshop_gift_management'], count($headings));
	print_description_row($vbphrase['dbtech_vbshop_gift_management_descr'], false, count($headings));	
	
	foreach ($gifts_by_category as $categoryid => $gifts)
	{
		print_description_row($vbshop->cache['category']["$categoryid"]['title'], false, count($headings), 'optiontitle');
		print_description_row($vbshop->cache['category']["$categoryid"]['description'], false, count($headings));	
		print_cells_row($headings, 0, 'thead');
		
		foreach ($gifts as $giftid => $gift)
		{
			// Table data
			$cell = array();
			$cell[] = ($gift['icon'] ? '<img src="../dbtech/vbshop/images/' . $gift['icon'] . '" alt="' . $gift['title'] . '" /> ' : '') . $gift['title'];
			$cell[] = ($gift['shopicon'] ? '<img src="../dbtech/vbshop/images/' . $gift['shopicon'] . '" alt="' . $gift['title'] . '" /> ' : 'N/A');
			$cell[] = $gift['description'];
			$cell[] = "<input type=\"text\" class=\"bginput\" name=\"order[$giftid]\" value=\"$gift[displayorder]\" tabindex=\"1\" size=\"3\" title=\"" . $vbphrase['edit_display_order'] . "\" />";
			$cell[] = vb_number_format($gift['price'], 2);
			$cell[] = construct_link_code($vbphrase['edit_permissions'], 'vbshop.php?' . $vbulletin->session->vars['sessionurl'] . 'do=giftpermissions&amp;giftid=' . $giftid);

			// Hook goes here
			
			$cell[] = construct_link_code($vbphrase['edit'], 'vbshop.php?' . $vbulletin->session->vars['sessionurl'] . 'do=modifygift&amp;giftid=' . $giftid);
			$cell[] = construct_link_code($vbphrase['delete'], 'vbshop.php?' . $vbulletin->session->vars['sessionurl'] . 'do=deletegift&amp;giftid=' . $giftid);
			
			// Print the data
			print_cells_row($cell, 0, 0, -5, 'middle', 0, 1);
		}
	}
	
	print_submit_row($vbphrase['save_display_order'], false, count($headings), false, "<input type=\"button\" id=\"addnew\" class=\"button\" value=\"" . str_pad($vbphrase['dbtech_vbshop_add_new_gift'], 8, ' ', STR_PAD_BOTH) . "\" tabindex=\"1\" onclick=\"window.location = 'vbshop.php?do=modifygift'\" />");	
}
else
{
	print_form_header('vbshop', 'modifygift');	
	print_table_header($vbphrase['dbtech_vbshop_gift_management'], count($headings));
	print_description_row($vbphrase['dbtech_vbshop_no_gifts'], false, count($headings));
	print_submit_row($vbphrase['dbtech_vbshop_add_new_gift'], false, count($headings));	
}

print_cp_footer();

/*=======================================================================*\
|| ##################################################################### ||
|| # Created: 17:29, Sat Dec 27th 2008                                 # ||
|| # SVN: $RCSfile: gift.php,v $ - $Revision: $WCREV$ $
|| ##################################################################### ||
\*=======================================================================*/
?>