<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

$columns = array(
	'categoryid' 	=> TYPE_UINT,
	'title' 		=> TYPE_STR,
	'description' 	=> TYPE_STR,
	'icon' 			=> TYPE_STR,
	'shopicon' 		=> TYPE_STR,
	'displayorder' 	=> TYPE_UINT,
	'price' 		=> TYPE_NUM,
);

// Grab stuff
$vbulletin->input->clean_array_gpc('p', $columns);
$giftid = $vbulletin->input->clean_gpc('p', 'giftid', TYPE_UINT);

$values = array();
foreach ($columns as $columnname => $type)
{
	// Store the values
	$values["$columnname"] = (is_array($vbulletin->GPC["$columnname"]) ? trim(serialize($vbulletin->GPC["$columnname"])) : $vbulletin->GPC["$columnname"]);
}

// Init this
$condition = '';

if ($giftid)
{
	if (!$existing = $vbshop->cache['gift']["$giftid"])
	{
		// Editing ID doesn't exist
		print_stop_message('dbtech_vbshop_invalid_x', $vbphrase['dbtech_vbshop_gift'], $giftid);
	}
	
	if ($existing = $db->query_first("
		SELECT `title`
		FROM `" . TABLE_PREFIX . "dbtech_vbshop_gift`
		WHERE `title` = " . $db->sql_prepare($values['title']) . "
			AND `giftid` != " . $db->sql_prepare($giftid) . "
		LIMIT 1
	"))
	{
		// Whoopsie, exists
		print_stop_message('dbtech_vbshop_x_already_exists_y', $vbphrase['dbtech_vbshop_gift'], $existing['title']);
	}
	
	// Set condition
	$condition = "WHERE giftid=" . $giftid;
		
	// Set redirect phrase
	$phrase = $vbphrase['dbtech_vbshop_edited'];	
}
else
{
	if ($existing = $db->query_first("
		SELECT `title`
		FROM `" . TABLE_PREFIX . "dbtech_vbshop_gift`
		WHERE `title` = " . $db->sql_prepare($values['title']) . "
		LIMIT 1
	"))
	{
		// Whoopsie, exists
		print_stop_message('dbtech_vbshop_x_already_exists_y', $vbphrase['dbtech_vbshop_gift'], $existing['title']);
	}
	
	// Set redirect phrase
	$phrase = $vbphrase['dbtech_vbshop_added'];
}

// Update the database
$db->query_write(fetch_query_sql($values, 'dbtech_vbshop_gift', $condition));	

// Rebuild the cache
$vbshop->build_cache('dbtech_vbshop_gift', 'LEFT JOIN ' . TABLE_PREFIX . 'dbtech_vbshop_category AS category ON (category.categoryid = dbtech_vbshop_gift.categoryid)
	ORDER BY category.displayorder, dbtech_vbshop_gift.displayorder ASC
');

define('CP_REDIRECT', 'vbshop.php?do=gift');
print_stop_message('dbtech_vbshop_x_y', $vbphrase['dbtech_vbshop_gift'], $phrase);

/*=======================================================================*\
|| ##################################################################### ||
|| # Created: 17:29, Sat Dec 27th 2008                                 # ||
|| # SVN: $RCSfile: .php,v $ - $Revision: $WCREV$ $
|| ##################################################################### ||
\*=======================================================================*/
?>