<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

$itemid = $vbulletin->input->clean_gpc('r', 'itemid', TYPE_UINT);
$item = ($itemid ? $vbshop->cache['item']["$itemid"] : false);

$categorys = array();
foreach ($vbshop->cache['category'] as $categoryid => $category)
{
	// Add the phrased category name to the array
	$categorys["$categoryid"] = $category['title'];
}

if (!count($categorys))
{
	// Missing categories
	print_stop_message('dbtech_vbshop_missing_x',
		$vbphrase['dbtech_vbshop_category'],
		$vbulletin->session->vars['sessionurl'],
		'modifycategory'
	);
}

if (!is_array($item))
{
	// Non-existing item
	$itemid = 0;
}


$shopicons = array('' => $vbphrase['none']);
if ($handle = opendir('dbtech/vbshop/images/items/shop'))
{
	while (false !== ($file = readdir($handle)))
	{
		if ($file != '.' AND $file != '..' AND $file != 'index.html')
		{
			// Store the icon
			$shopicons["items/shop/$file"] = $file;
		}
    }
    closedir($handle);
}

// Sort the array as a string
asort($shopicons, SORT_STRING);

if ($itemid)
{
	// Edit
	print_cp_header(strip_tags(construct_phrase($vbphrase['dbtech_vbshop_editing_x_y'], $vbphrase['dbtech_vbshop_item'], $item['title'])));
	print_form_header('vbshop', 'updateitem');
	construct_hidden_code('itemid', $itemid);
	print_table_header(construct_phrase($vbphrase['dbtech_vbshop_editing_x_y'], $vbphrase['dbtech_vbshop_item'], $item['title']));
	$itemtype = $item['itemtype'];
	$code = @unserialize($item['code']);
}
else
{
	// Add
	print_cp_header($vbphrase['dbtech_vbshop_add_new_item']);
	print_form_header('vbshop', 'updateitem');	
	print_table_header($vbphrase['dbtech_vbshop_add_new_item']);
	
	$itemtype = $vbulletin->input->clean_gpc('r', 'itemtype', TYPE_STR);
	if (!$itemtype)
	{
		print_stop_message('dbtech_vbshop_missing_x',
			$vbphrase['dbtech_vbshop_itemtype'],
			$vbulletin->session->vars['sessionurl'],
			'item'
		);
	}
	$item = array('itemtype' => $itemtype);
}

// Load the item info
$itemobj = $vbshop->init_item($item);

print_label_row($vbphrase['dbtech_vbshop_item_type'], $itemtype);
construct_hidden_code('itemtype', $itemtype);
print_input_row($vbphrase['title'], 							'title', 					$item['title']);
print_select_row($vbphrase['dbtech_vbshop_category'], 			'categoryid', 	$categorys, $item['categoryid']);
print_textarea_row($vbphrase['description'], 					'description', 				$item['description']);
print_input_row($vbphrase['display_order'], 					'displayorder', 			(isset($item['displayorder']) ? $item['displayorder'] : 10));
print_select_row($vbphrase['dbtech_vbshop_shop_icon'], 			'shopicon',		$shopicons,	$item['shopicon']);
print_input_row($vbphrase['dbtech_vbshop_item_price'], 			'price', 					(isset($item['price']) ? $item['price'] : 0));
if (VBSHOP_PRO)
{
	print_yes_no_row($vbphrase['dbtech_vbshop_item_giftable'], 	'giftable', $item['giftable']);
	print_yes_no_row($vbphrase['dbtech_vbshop_pm_on_gift'], 	'giftpm', 	$item['giftpm']);
}

if (method_exists($itemobj, 'print_admin_form'))
{
	// Item info
	print_description_row($vbphrase['dbtech_vbshop_item_type_fields'], false, 2, 'optiontitle');
	$itemobj->print_admin_form($code);
}

print_submit_row(($itemid ? $vbphrase['save'] : $vbphrase['dbtech_vbshop_add_new_item']));
print_cp_footer();


/*=======================================================================*\
|| ##################################################################### ||
|| # Created: 17:29, Sat Dec 27th 2008                                 # ||
|| # SVN: $RCSfile: item.php,v $ - $Revision: $WCREV$ $
|| ##################################################################### ||
\*=======================================================================*/
?>