<?php
class vBShop_Item_Core
{
	/**
	* The vBulletin registry
	*
	* @protected	vBulletin
	*/	
	protected $registry = NULL;
	
	/**
	* The vBShop registry
	*
	* @protected	vBShop
	*/	
	protected $vbshop = NULL;
	
	/**
	* The configuration array
	*
	* @protected	array
	*/	
	public $config = array();
	
	
	/**
	* The constructor
	*
	* @param	vBulletin	vBulletin registry
	* @param	vBShop		vBShop registry
	* @param	array		Item info
	*/	
	public function __construct(&$registry, $vbshop, &$item)
	{
		$this->registry =& $registry;
		$this->vbshop =& $vbshop;
		$this->config =& $item;
		
		// Grab the code array
		$this->config['code'] = @unserialize($this->config['code']);
		
		if (!is_array($this->config['code']))
		{
			// Ensure this is an array
			$this->config['code'] = array();
		}
		
		// Grab the code array
		$this->config['permissions'] = @unserialize($this->config['permissions']);
		
		if (!is_array($this->config['permissions']))
		{
			// Ensure this is an array
			$this->config['permissions'] = array();
		}
		
		// Set shop type
		$this->config['shoptype'] = ($this->config['itemtype'] == 'gift' ? $this->config['itemtype'] : 'item');
		
		// Set purchase template
		$this->config['purchasetemplate'] = 'dbtech_vbshop_purchase';
	}
	
	/**
	* Function to call before every action
	*/	
	public function action()
	{
		if (!$this->config['active'])
		{
			// This type is inactive
			//return false;
		}
		
		// We made it!
		return true;
	}
	
	/**
	* Form to purchase an item
	*/	
	public function render()
	{
		global $vbphrase;
		
		// Begin the purchase template
		$templater = vB_Template::create($this->config['purchasetemplate']);
			$templater->register('item', $this->config);
			$templater->register('price', vb_number_format(round($this->config['price'], 2)) . ' ' . $this->registry->options['dbtech_vbshop_pointsname']);
			$templater->register('pagetitle', construct_phrase($vbphrase['dbtech_vbshop_purchasing_x'], $this->config['title']));
			$templater->register('itemid', ($this->config['itemtype'] == 'gift' ? $this->config['giftid'] : $this->config['itemid']));
			$templater->register('type', $this->config['shoptype']);
		return $templater->render();
	}
	
	/**
	* Purchasing an item
	*
	* @param	array		User info
	* @param	array		Recipient user info
	*/	
	public function purchase(&$buyer, $recipient = array())
	{
		if (!$buyer['userid'])
		{
			// We not doin dis
			return false;
		}
		
		// Grab userpoints
		$userpoints = $buyer["{$this->registry->options[dbtech_vbshop_pointsfield]}"];
		
		if ($userpoints < $this->config['price'])
		{
			// Not enough points
			return false;
		}
		
		if (!$this->check_permissions($buyer))
		{
			// Check permissions failed
			return false;
		}
		
		
		if (empty($recipient))
		{
			// Recipient is the same as the user
			$recipient = $buyer;
		}
		
		// Run pre-purchase checks that other actions may need to override
		$this->pre_purchase($buyer, $recipient);
		
		if ($buyer['userid'] != $recipient['userid'])
		{
			// Send a PM about the gift
			$this->send_pm($buyer, $recipient);
		}
		
		if ($this->config['price'] > 0)
		{
			// We're done with the error checking
			$this->registry->db->query_write("
				UPDATE " . TABLE_PREFIX . $this->registry->options['dbtech_vbshop_pointstable'] . "
				SET " . $this->registry->options['dbtech_vbshop_pointsfield'] . " = " . $this->registry->options['dbtech_vbshop_pointsfield'] . " - " . doubleval($this->config['price']) . "
				WHERE userid = " . intval($buyer['userid'])
			);
		}
		
		// Insert the purchase
		$this->vbshop->insert_purchase($this->config['shoptype'], $this->config['itemid'], $buyer, $recipient);
		
		// And we're done.
		return true;
	}
	
	/**
	* Adds a purchase
	*
	* @param	array	The user who made this purchase
	* @param	array	The user who's receiving the item
	*/	
	public function send_pm($sender, $recipient)
	{
		if (!$this->config['giftpm'])
		{
			// We're not sending a PM
			return;
		}
		
		global $vbphrase;
		
		// Who's the PM to
		$pmto = (!$recipient['username'] ? fetch_userinfo($recipient['userid']) : $recipient);
		
		// Send pm
		$pmdm =& datamanager_init('PM', $this->registry, ERRTYPE_ARRAY);
		$pmdm->set_info('is_automated', true); // implies overridequota
		$pmdm->set('fromuserid', $this->registry->userinfo['userid']);
		$pmdm->set('fromusername', $this->registry->userinfo['username']);
		$pmdm->setr('title', construct_phrase($vbphrase['dbtech_vbshop_new_gift_from_x'], $this->registry->userinfo['username']));
		$pmdm->set_recipients($pmto['username'], $this->registry->userinfo['permissions'], 'cc');
		$pmdm->setr('message', construct_phrase($vbphrase['dbtech_vbshop_new_gift_from_x_body'], $this->registry->userinfo['username'], $this->config['title'], $this->config['description']));
		$pmdm->set('dateline', TIMENOW);
		$pmdm->set('allowsmilie', 0);
		
		if (!$pmdm->pre_save())
		{
			$errstr = '<ol>';
			foreach ($pmdm->errors as $errormsg)
			{
				$errstr .= "<li>$errormsg</li>";
			}
			$errstr .= '</ol>';
			eval(standard_error(fetch_error('dbtech_vbshop_error_x', $errstr)));
		}
		else
		{
			$pmdm->save();
		}		
	}
	
	/**
	* Check if we have permissions to buy an item
	*
	* @param	array		User info
	*/	
	public function check_permissions(&$user)
	{
		// Wrapper
		return $this->vbshop->check_permissions($user, $this->config['permissions']);
	}
	
	/**
	* Load item info
	*/	
	public function load_item_info() {}
	
	/**
	* Purchasing an item
	*
	* @param	array		User info
	* @param	array		Recipient user info
	*/	
	protected function pre_purchase(&$buyer, &$recipient) {}
}
?>