<?php
class vBShop_Item_immunity extends vBShop_Item_Core
{	
	/**
	* The constructor
	*
	* @param	vBulletin	vBulletin registry
	* @param	vBShop		vBShop registry
	* @param	array		Item info
	*/	
	public function __construct(&$registry, $vbshop, &$item)
	{
		parent::__construct($registry, $vbshop, $item);
	}
	
	/**
	* Load item info
	*/	
	public function load_item_info()
	{
		return array(
			'name' 					=> 'Immunity',
			'description' 			=> 'Immunity from various actions affecting user accounts.',
			'icon' 					=> '',
			'price' 				=> 10
		);
	}
	
	/**
	* Function to call before every action
	*/	
	public function action()
	{
		if (!parent::action())
		{
			// This type is inactive
			return false;
		}
		
		// We made it!
		return true;
	}
	
	/**
	* Prints out an AdminCP form
	*/	
	public function print_admin_form($code)
	{
		global $vbphrase;
		
		// Finally print the select
		$this->vbshop->print_bitfield_row($vbphrase['dbtech_vbshop_immunity'], 'code[value]', 'nocache|dbtech_vbshop_immunity', $code['value']);
	}
	
	/**
	* Purchasing an item
	*
	* @param	array		User info
	* @param	array		Recipient user info
	*/	
	protected function pre_purchase(&$buyer, &$recipient)
	{
		// Ensure we have the necessary files
		require_once(DIR . '/includes/adminfunctions.php');
		require_once(DIR . '/includes/adminfunctions_options.php');
		
		$update = false;
		$bitfielddefs =& fetch_bitfield_definitions('nocache|dbtech_vbshop_immunity');
		foreach ($bitfielddefs AS $key => $val)
		{
			if (($this->config['code']['value'] & $val) AND !($recipient['dbtech_vbshop_immunity'] & $val))
			{
				// Add this bit
				$recipient['dbtech_vbshop_immunity'] += $val;
				$update = true;
			}
		}
		
		if ($update)
		{
			// Update the immunity
			$this->registry->db->query_write("
				UPDATE " . TABLE_PREFIX . "user
				SET dbtech_vbshop_immunity = " . intval($recipient['dbtech_vbshop_immunity']) . "
				WHERE userid = " . intval($recipient['userid'])
			);
		}
		
		
		// Loop through every possible immunity and check if that's included in this item
		// Then update the db as needed
	}	
}
?>