<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #############################################################################
// cache functionality class

/**
* Class that handles checking every permission possible, and provides a shorthand.
*
* @package	Framework
* @version	$ $Rev$ $
* @date		$ $Date$ $
*/
class DBTech_Framework_Permissions
{
	/**
	* The prefix for the mod we are working with
	*
	* @protected	string
	*/	
	protected $prefix 	= 'dbtech_';
	
	/**
	* The vBulletin registry object
	*
	* @private	vB_Registry
	*/	
	private $registry 		= NULL;
	
	/**
	* Array of permissions to be returned
	*
	* @public	array
	*/	
	public $permissions 	= array();
	
	
	
	/**
	* Constructor. Captures the argument from the constructing function
	* and passes it along to the initialiser.
	*
	* @return	void		Nothing
	*/
	public function __construct()
	{
		// Tarp the argument array
		$args = func_get_arg(0);
		
		// Get rid of the class name, we don't need their kind around here
		unset($args[0]);
		
		// Now initialise everything
		call_user_func_array(array($this, 'init'), $args);
	}
	
	/**
	* Initialises 
	*
	* @param	vB_Registry	Registry object
	* @param	array		The bitfield group
	*
	* @return	void		Nothing
	*/
	private function init($registry, $bitfieldgroup)
	{
		// Check if the vBulletin Registry is an object
		if (!is_object($registry))
		{
			// Something went wrong here I think
			trigger_error("DBTech_Framework_Permissions::Registry object is not an object", E_USER_ERROR);
		}
		
		// Override bitfieldgroup variable
		$bitfieldgroup = $this->prefix . $bitfieldgroup;
		
		if (!is_array($registry->bf_ugp["$bitfieldgroup"]))
		{
			// Something went wrong here I think
			trigger_error("DBTech_Framework_Permissions::Registry::bf_ugp[$bitfieldgroup] is not an array", E_USER_ERROR);
		}
		
		// Set registry
		$this->registry =& $registry;
		
		if (!$registry->userinfo['permissions'])
		{
			// For some reason, this is missing
			cache_permissions($registry->userinfo);
		}
		
		foreach ($registry->bf_ugp["$bitfieldgroup"] as $permname => $bit)
		{
			// Set the permission
			$this->permissions["$permname"] = ($registry->userinfo['permissions']["$bitfieldgroup"] & $bit ? 1 : 0);
		}
	}
}