<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #############################################################################
define('VBSHOP_VERSION', '1.2.0');
define('VBSHOP_VERSIONNUMBER', 120);

// #############################################################################
// vbshop functionality class

/**
* Handles everything to do with vbshop.
*
* @package	vBShop
* @version	$ $Rev$ $
* @date		$ $Date$ $
*/
class DBTech_Framework_Vbshop
{
	/**
	* The vBulletin registry object
	*
	* @private	vB_Registry
	*/	
	private $registry 		= NULL;
	
	
	/**
	* Constructor. Captures the argument from the constructing function
	* and passes it along to the initialiser.
	*/
	public function __construct()
	{
		// Tarp the argument array
		$args = func_get_arg(0);
		
		// Get rid of the class name, we don't need their kind around here
		unset($args[0]);
		
		// Now initialise everything
		call_user_func_array(array($this, 'init'), $args);
	}

	/**
	* Initialises the Activity and ensures we have
	* all the classes we need
	*
	* @param	vB_Registry	Registry object
	* @param	array		List of all classes we need
	*/
	private function init($registry, $classes)
	{
		// Check if the vBulletin Registry is an object
		if (!is_object($registry))
		{
			// Something went wrong here I think
			trigger_error("DBTech_Framework_Vbshop::Registry object is not an object", E_USER_ERROR);
		}
		
		foreach ($classes as $classname => $classobj)
		{
			// Check if the Cache is an object
			if (!is_object($classobj))
			{
				// Something went wrong here I think
				trigger_error("DBTech_Framework_Vbshop::" . ucfirst($classname) . " object is not an object", E_USER_ERROR);
			}
			
			$newclassname = $classname . 'class';
			$this->$newclassname = $classobj;
		}
		
		// Set registry
		$this->registry =& $registry;
		
		// Set permissions shorthand
		$this->permissions =& $classes['permissions']->permissions;
		
		// What permissions to override
		$override = array(
			'canviewshop',
		);
		
		foreach ($override as $permname)
		{
			// Override various permissions
			$this->permissions["$permname"] = ($this->permissions['ismanager'] ? 1 : $this->permissions["$permname"]);
		}
	}
	
	/**
	* Builds the cache in case the datastore has been cleaned out.
	*
	* @param	string	Database table we are working with
	* @param	string	(Optional) Any additional clauses to the query
	*/
	public function build_cache($dbtype, $clauses = '')
	{
		return $this->cacheclass->build_cache($dbtype, $clauses);
	}
	
	/**
	* Filters the specified array down to what we want
	*
	* @param	array	Array to filter
	* @param	string	What the ID Field is
	* @param	mixed	What we are looking for
	*/
	public function filter($array, $idfield, $idval)
	{
		return $this->filterclass->filter($array, $idfield, $idval);
	}
	
	/**
	* Ensures the purchases cache is enabled and working
	*
	* @param	array	The user whose cache we're ensuring
	* @param	boolean	(Optional) Do run cache update query?
	* @param	boolean	(Optional) Do attempt to unserialize?
	*/
	public function verify_purchases(&$userinfo, $updatecache = true, $unserialize = true)
	{
		if (!$userinfo['userid'])
		{
			// This isn't a valid user
			$userinfo['dbtech_vbshop_purchase'] = array();
			return false;
		}
		
		if (!isset($userinfo['dbtech_vbshop_purchase']))
		{
			// Add purchases to the userinfo array
			$extrauserinfo = fetch_userinfo($userinfo['userid'], 1);
			$userinfo['dbtech_vbshop_purchase'] = $extrauserinfo['dbtech_vbshop_purchase'];
		}
		
		if ($userinfo['dbtech_vbshop_purchase'] === NULL)
		{
			// Rebuild the purchases cache for this user
			$this->build_purchases($userinfo);
		}
		else
		{
			if ($unserialize AND !is_array($userinfo['dbtech_vbshop_purchase']))
			{
				// Attempt to unserialize
				$userinfo['dbtech_vbshop_purchase'] = @unserialize($userinfo['dbtech_vbshop_purchase']);
			}
			
			if (!is_array($userinfo['dbtech_vbshop_purchase']))
			{
				// User had no purchases
				$userinfo['dbtech_vbshop_purchase'] = array();
			}
		}
	}
	
	/**
	* Rebuilds the purchases cache
	*
	* @param	array	The user whose cache we're ensuring
	*/	
	public function build_purchases(&$userinfo)
	{
		if (!$userinfo['userid'])
		{
			// This isn't a valid user
			return false;
		}
		
		// Has no purchases cache generated
		$userinfo['dbtech_vbshop_purchase'] = array();
		
		// Insert the purchase				OR buyer = " . $userinfo['userid'] . "
		$purchases_q = $this->registry->db->query_read_slave("
			SELECT * FROM " . TABLE_PREFIX . "dbtech_vbshop_purchase
			WHERE userid = " . $userinfo['userid'] . "
				OR buyer = " . $userinfo['userid'] . "
			ORDER BY dateline DESC
		");
		while ($purchases_r = $this->registry->db->fetch_array($purchases_q))
		{
			// Set the cache
			$userinfo['dbtech_vbshop_purchase']["$purchases_r[purchaseid]"] = $purchases_r;
		}
		$this->registry->db->free_result($purchases_q);
		unset($purchases_r);				
		
		// Update the database
		$this->registry->db->query_write("
			UPDATE " . TABLE_PREFIX . "user
			SET dbtech_vbshop_purchase = '" . $this->registry->db->escape_string(trim(serialize($userinfo['dbtech_vbshop_purchase']))) . "'
			WHERE userid = " . $userinfo['userid'] . "
		");
	}
	
	/**
	* Adds a purchase
	*
	* @param	string	The type of purchase we made
	* @param	integer	The ID of the purchase we made
	* @param	array	The user who made this purchase
	* @param	array	The user who's receiving the item
	*/	
	public function insert_purchase($feature, $featureid, &$recipient, &$buyer)
	{
		// Grant the purchase to the user
		$this->registry->db->query_write("
			INSERT INTO " . TABLE_PREFIX . "dbtech_vbshop_purchase
				(userid, buyer, feature, featureid, dateline)
			VALUES (
				" . $buyer['userid'] . ",
				" . $recipient['userid'] . ",
				'$feature',
				$featureid,
				" . TIMENOW . "
			)
		");
		
		// Grant the purchase to the user
		$this->registry->db->query_write("
			UPDATE " . TABLE_PREFIX . "dbtech_vbshop_{$feature}
			SET purchases = purchases + 1
			WHERE {$feature}id = $featureid
		");
		$this->build_cache("dbtech_vbshop_{$feature}", "LEFT JOIN " . TABLE_PREFIX . "dbtech_vbshop_category AS category ON (category.categoryid = dbtech_vbshop_{$feature}.categoryid)
			ORDER BY category.displayorder, dbtech_vbshop_{$feature}.displayorder ASC
		");
		
		// Fetch the purchase id
		//$purchaseid = $this->registry->db->insert_id();
		
		// Rebuild the cache
		$this->build_purchases($buyer);
		
		if ($buyer['userid'] != $recipient['userid'])
		{
			// Also build buyer's cache
			$this->build_purchases($recipient);
		}
	}
	
	/**
	* Initialises an item class.
	*
	* @param	array	Item info
	*/
	public function init_item($item)
	{
		if (!class_exists('vBShop_Item_Core'))
		{
			// Include the needed class
			require_once(DIR . '/dbtech/vbshop/includes/class_items_core.php');
		}
		
		// Ensure item type is gift
		$item['itemtype'] = ($item['itemtype'] ? $item['itemtype'] : 'gift');
		
		$classname = 'vBShop_Item_' . $item['itemtype'];
		if (!class_exists($classname))
		{
			// Include the needed class
			require_once(DIR . '/dbtech/vbshop/items/' . $item['itemtype'] . '.php');
		}
		
		// Return the object
		return new $classname($this->registry, $this, $item);
		
		
		/*
		if ($this->items["$item[itemid]"])
		{
			// We don't need to init this
			return;
		}
		
		if (!$item['active'])
		{
			// We don't want to init this
			$this->items["$item[itemname]"] = new vBShop_Item_Core($this->registry, $this, $item);
			return;
		}
		
		// Init the type
		$this->items["$item[itemid]"] = new $classname($this->registry, $this, $item);
		*/
	}
	
	/**
	 * Quick Method of building the CPNav Template
	 *
	 * @param	string	The selected item in the CPNav
	 */	
	public function construct_nav($selectedcell = 'main')
	{
		global $navclass, $vbphrase;
		global $vbulletin, $show, $template_hook;
	
		$cells = array(
			'main',
	
			'achievements',
			'promotions',
			'trophies',
			'medals',
			'activity',
	
			'ranking',
			'leaderboards',
	
			'allachievements',
			'alltrophies',
			'allawards',
			'contests',
			'activitystats',
		);
	
		//($hook = vBulletinHook::fetch_hook('usercp_nav_start')) ? eval($hook) : false;
		
		// set the class for each cell/group
		$navclass = array();
		foreach ($cells AS $cellname)
		{
			$navclass["$cellname"] = (intval($this->registry->versionnumber) == 3 ? 'alt2' : 'inactive');
		}
		$navclass["$selectedcell"] = (intval($this->registry->versionnumber) == 3 ? 'alt1' : 'active');
		
		//($hook = vBulletinHook::fetch_hook('usercp_nav_complete')) ? eval($hook) : false;
	}
	
	/**
	 * Constructs a bitfield row
	 *
	 * @param	string	The label text
	 * @param	string	The name of the row for the form
	 * @param	string	What bitfields we are using
	 * @param	integer	The value of the setting
	 */	
	public function print_bitfield_row($text, $name, $bitfield, $value)
	{
		global $vbulletin, $vbphrase;
	
		require_once(DIR . '/includes/adminfunctions.php');
		require_once(DIR . '/includes/adminfunctions_options.php');
		
		// make sure all rows use the alt1 class
		$bgcounter--;
	
		$value = intval($value);
		$HTML = '';
		$bitfielddefs =& fetch_bitfield_definitions($bitfield);

		if ($bitfielddefs === NULL)
		{
			print_label_row($text, construct_phrase("<strong>$vbphrase[settings_bitfield_error]</strong>", implode(',', vB_Bitfield_Builder::fetch_errors())), '', 'top', $name, 40);
		}
		else
		{
			#$HTML .= "<fieldset><legend>$vbphrase[yes] / $vbphrase[no]</legend>";
			$HTML .= "<div id=\"ctrl_{$name}\" class=\"smallfont\">\r\n";
			$HTML .= "<input type=\"hidden\" name=\"{$name}[0]\" value=\"0\" />\r\n";
			foreach ($bitfielddefs AS $key => $val)
			{
				$val = intval($val);
				$HTML .= "<table style=\"width:175px; float:left\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr valign=\"top\">
				<td><input type=\"checkbox\" name=\"{$name}[$val]\" id=\"{$name}_$key\" value=\"$val\"" . (($value & $val) ? ' checked="checked"' : '') . " /></td>
				<td width=\"100%\" style=\"padding-top:4px\"><label for=\"{$name}_$key\" class=\"smallfont\">" . fetch_phrase_from_key($key) . "</label></td>\r\n</tr></table>\r\n";
			}

			$HTML .= "</div>\r\n";
			#$HTML .= "</fieldset>";
			print_label_row($text, $HTML, '', 'top', $name, 40);
		}		
	}
	
	/**
	* Check if we have permissions to perform an action
	*
	* @param	array		User info
	* @param	array		Permissions info
	*/		
	public function check_permissions(&$user, $permissions)
	{
		if (!$user['usergroupid'] OR !isset($user['membergroupids']))
		{
			// Ensure we have this
			$user = fetch_userinfo($user['userid']);
		}
		
		if (!is_array($user['permissions']))
		{
			// Ensure we have the perms
			cache_permissions($user);
		}
		
		if ($user['membergroupids'])
		{
			$ugs = explode(',', $user['membergroupids']);
			$ugs[] = $user['usergroupid'];
		}
		else
		{
			$ugs = array($user['usergroupid']);
		}
		
		//$this->registry->usergroupcache
		foreach ($ugs as $usergroupid)
		{
			$value = $permissions["$usergroupid"];
			$value = (isset($value) ? $value : -1);
			
			switch ($value)
			{
				case 1:
					// Allow
					return true;
					break;
				
				case -1:
					// Usergroup Default		
					if (!($user['permissions']['dbtech_vbshoppermissions'] & 4))
					{
						// Allow by default
						return true;
					}
					break;
			}
		}
		
		// We didn't make it
		return false;
	}
	
}

/*======================================================================*\
|| ####################################################################
|| # Created: 16:52, Sat Dec 26th 2009
|| # SVN: $ $Rev$ $ - $ $Date$ $
|| ####################################################################
\*======================================================================*/
