<?php
//
//   CF Image Hosting Script v1.3.8
//   -------------------------------
//
//   Author:    codefuture.co.uk
//   Version:   1.3.8
//   Date:      14-Aug-10
//
//   download the latest version from - http://codefuture.co.uk/projects/imagehost1.3/
//
//   Copyright (c) 2010 codefuture.co.uk
//   This file is part of the CF Image Hosting Script.
//
//   CF Image Hosting Script is free software: you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation, either version 3 of the License, or
//   (at your option) any later version.
//
//   CF Image Hosting Script is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//   You should have received a copy of the GNU General Public License
//   along with CF Image Hosting Script.  If not, see http://www.gnu.org/licenses/.
//
////////////////////////////////////////////////////////////////////////////////////

	include_once('inc/config.php');

	if($settings['SET_HIDE_CONTACT']){
		header('Location: index.php');
		exit();
	}


$error = FALSE;
$CONTACT_FORM_SENT = FALSE;

if ($_SERVER['REQUEST_METHOD'] == 'POST') {

	$name    = input($_POST['name']);
	$email   = input($_POST['email']);
	$comment = input($_POST['comment']);
	$captcha = input($_POST['captcha']);

	if(empty($name)){
		$error_name = $LANGUAGE_PACK["site_contact_name_err_blank"];
		$error 		= TRUE;
	}

	if(empty($email)){
		$error_email = $LANGUAGE_PACK["site_contact_email_err_blank"];
		$error		 = TRUE;
	}elseif(!eregi('^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,4})$', $email) ||
			preg_match("/(%0A|%0D|\n+|\r+)(content-type:|to:|cc:|bcc:)/i", $email) ||
			preg_match("/(%0A|%0D|\n+|\r+)/i", $email)){
		$error_email = $LANGUAGE_PACK["site_contact_email_err_invalid"];
		$error		 = TRUE;
	}

	if(empty($comment)){
		$error_comment	= $LANGUAGE_PACK["site_contact_comment_err_blank"];
		$error			= TRUE;
	}

// check_captcha() Error Messages
	define('ERROR_MESSAGE_CAPTCHA'				, $LANGUAGE_PACK["site_contact_captcha_err_blank"]);
	define('ERROR_MESSAGE_CAPTCHA_INVALID'		, $LANGUAGE_PACK["site_contact_captcha_err_invalid"]);
	define('ERROR_MESSAGE_CAPTCHA_TIMED_OUT'	, '');//not used
	define('ERROR_MESSAGE_CAPTCHA_COOKIE'		, $LANGUAGE_PACK["site_contact_captcha_err_cookie"]);

	include_once('lib/captcha.class.php');
	check_captcha($_POST['captcha'],false);
	if(isset($error_captcha)){$error = TRUE;}

	if(!$error) {

		if(strtoupper(substr(PHP_OS, 0, 3) == 'WIN')) $ent = "\r\n";
		elseif(strtoupper(substr(PHP_OS, 0, 3) == 'MAC')) $ent = "\r";
		else $ent = "\n";

		$comment  = ' Name: '.$name.$ent.' E-mail: '.$email.$ent.' Comment: '.$ent.$comment;
		$boundary = '----=_NextPart_' . md5(rand());
		$headers  = 'From: ' . $name . '<' . $email . '>' . $ent;
		$headers .= 'X-Mailer: PHP/' . phpversion() . $ent;
		$headers .= 'MIME-Version: 1.0' . $ent;
		$headers .= 'Content-Type: multipart/mixed; boundary="' . $boundary . '"' . $ent . $ent;
		$message  = '--' . $boundary . $ent;
		$message .= 'Content-Type: text/plain; charset="utf-8"' . $ent;
		$message .= 'Content-Transfer-Encoding: base64' . $ent . $ent;
		$message .= chunk_split(base64_encode($comment));

		ini_set('sendmail_from', $email);
		mail($settings['SET_CONTACT'], 'Email from contact form on '.$settings['SET_TITLE'], strip_tags(html_entity_decode($message)), $headers);
		$CONTACT_FORM_SENT = TRUE;
	}
}

	$CONTACT_CAPTCHA_IMG	= '<img src="lib/captcha.class.php?img&amp;'.time().'&amp;'.($settings['SET_THEME']=='dark'?'&amp;bg':'').'" alt="captcha" />';
	$CONTACT_ERROR_NAME		= !empty($error_name)	? '<span class="error_message">'.$error_name.'</span>'   : '';
	$CONTACT_ERROR_EMAIL	= !empty($error_email)	? '<span class="error_message">'.$error_email.'</span>'  : '';
	$CONTACT_ERROR_COMMENT	= !empty($error_comment)? '<span class="error_message">'.$error_comment.'</span>': '';
	$CONTACT_ERROR_CAPTCHA	= !empty($error_captcha)? '<span class="error_message">'.$error_captcha.'</span>': '';
	$CONTACT_NAME			= !empty($error)? $name   : '';
	$CONTACT_EMAIL			= !empty($error)? $email  : '';
	$CONTACT_COMMENT		= !empty($error)? $comment: '';
	$CONTACT_THANKS_NAME	= isset($name)  ? $name   : '';


	$menu = 'contact';
	$page_title = ' - Contact Page';
	include_once('header.php');


	if($CONTACT_FORM_SENT){
?>
					<p class="teaser"><?=sprintf($LANGUAGE_PACK["site_contact_thank_you"],$CONTACT_THANKS_NAME);?></p>
<? }else{ ?>

					<p class="teaser"><?=$LANGUAGE_PACK["site_contact_des"];?></p>
					<div id="form">
						<form method="post" action="contact.php">
							<?=$CONTACT_ERROR_NAME;?>
							<div class="code_box">
								<label for="name"><?=$LANGUAGE_PACK["site_contact_form_name"];?></label>
								<input name="name" type="text" id="name" class="text_input" size="24" value="<?=$CONTACT_NAME;?>" />
							</div>
							<?=$CONTACT_ERROR_EMAIL;?>
							<div class="code_box">
								<label for="email"><?=$LANGUAGE_PACK["site_contact_form_email"];?></label>
								<input name="email" type="text" id="email" class="text_input" size="24" value="<?=$CONTACT_EMAIL;?>" /><br/>
							</div>
							<?=$CONTACT_ERROR_COMMENT;?>
							<div class="code_box contact">
								<label for="comment"><?=$LANGUAGE_PACK["site_contact_form_comment"];?></label>
								<textarea name="comment" id="comment" rows="8" cols="5" class="text_input long"><?=$CONTACT_COMMENT;?></textarea>
							</div>
							<?=$CONTACT_ERROR_CAPTCHA;?>
							<div class="code_box">
								<label for="captcha"><?=$LANGUAGE_PACK["site_contact_form_captcha"];?></label>
								<input name="captcha" type="text" id="captcha" size="24" class="text_input" />
							</div>
							<div class="button_cen"><?=$CONTACT_CAPTCHA_IMG;?></div>
							<input type="submit" class="button  button_cen" value="<?=$LANGUAGE_PACK["site_contact_form_send"];?>" />
						</form>
					</div>
<?
	}
	include_once('footer.php');

// MAKE PAGE END
////////////////////////////////////////////////////////////////////////////////////
?>