<?
//
//   CF Image Hosting Script v1.3.8
//   -------------------------------
//
//   Author:    codefuture.co.uk
//   Version:   1.3.8
//   Date:      14-Aug-10
//
//   download the latest version from - http://codefuture.co.uk/projects/imagehost1.3/
//
//   Copyright (c) 2010 codefuture.co.uk
//   This file is part of the CF Image Hosting Script.
//
//   CF Image Hosting Script is free software: you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation, either version 3 of the License, or
//   (at your option) any later version.
//
//   CF Image Hosting Script is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//   You should have received a copy of the GNU General Public License
//   along with CF Image Hosting Script.  If not, see http://www.gnu.org/licenses/.
//
////////////////////////////////////////////////////////////////////////////////////

class array_db{

// holds the loaded DB
	private $db;
	private $db_address;
	var $temp;

	/**
	 * array_db(load db file/array)
	 *
	 * @param address/array $db_load
	 */
	public function array_db($db_load=null){
		if(!is_array($db_load) && strlen($db_load) > 0){
			$this->db_address = $db_load;
			$this->db = $this->load_db();
			$this->db_count = count($this->db);
		}elseif(is_array($db_load)){
			$this->db_address = null;
			$this->db = $db_load;
			$this->db_count = count($this->db);
		}else{
			$this->db_address = null;
			$this->db = array();
			$this->db_count = 0;
		}
	}

	/**
	 * SET DB (repace DB with new db)
	 *
	 * @param array $new_db
	 */
	public function set_db($new_db){
		if(is_array($new_db))
			$this->db = $new_db;
	}

	/**
	 * fetch DB
	 *
	 * @return array
	 */
	public function fetch_all(){
		return $this->db;
	}

	/**
	 * DB COUNT
	 *
	 * @param key to look in ($key)
	 * @param value to look for ($value)
	 *
	 * @return string
	 */
	public function db_count($key=null,$value=null){
		$count_items = 0;
		if($key!=null && $value!=null){
			foreach ($this->db as $k => $v){
				if (array_key_exists($key,$v) && $v[$key] == $value){
					//echo $v[$key].' == '.$value;
					$count_items++;
				}
			}
		}else
			$count_items = count($this->db);
		return $count_items;
	}

	/**
	 * DB not empty
	 *
	 * @return boolean
	 */
	public function db_not_empty(){
		if (empty($this->db))
			return false;
		return true;
	}

	/**
	 * save_db_now
	 *
	 * @param address $address(if no address then save to the address where it was loaded from)
	 * 
	 * @return boolean
	 */
	public function save_db_now($address = null){
		if ($address == null)
			return $this->save_db();
		else
			return $this->save_db($address);
		
	}

	/**
	 * order db by
	 *
	 * @param name $field
	 * @param string $order (abc|123)(cba|321)
	 */
	public function order_by($field, $order = 123) {
		if ($order == 'abc' || $order == 123)$order = '$a,$b';
		if ($order == 'cba' || $order == 321)$order = '$b,$a';
		$code = "return strnatcmp(\$a['$field'], \$b['$field']);";
		@usort($this->db, create_function($order, $code));
	}

	/**
	 * fetch key value
	 *
	 * @param name $key
	 * @return value(string)
	 */
	public function fetch_key_value($key){
		if(array_key_exists($key,$this->db))
			return $this->db[$key];
	}

	/**
	 * key_exists
	 *
	 * @param name $key
	 * 
	 * @return boolean
	 */
	public function key_exists($key){
		if(array_key_exists($key,$this->db))
			return true;
		return false;
	}

	/**
	 * item_exists
	 *
	 * @param name $field_key
	 * @param string $value_key
	 * @return boolean
	 */
	public function item_exists($field_key,$value_key){
		$row_key = $this->fetch_key($field_key,$value_key);
		if(!empty($row_key) || $row_key === 0)
			return true;
		return false;
	}

	/**
	 * fetch row
	 *
	 * @param name $field_key
	 * @param string $value_key
	 * @return array
	 */
	public function fetch_row($field_key,$value_key){
		$row_key = $this->fetch_key($field_key,$value_key);
		if(!empty($row_key) || $row_key === 0){
			return $this->db[$row_key];
		}
	}

	/**
	 * fetch a array of value
	 *
	 * @param name $field_key
	 * @param string $value_key
	 * @param array $return_value
	 * @return array
	 */
	public function fetch_value_array($field_key,$value_key,$return_value){
		$row_key = $this->fetch_key($field_key,$value_key);
		if(!empty($row_key) || $row_key === 0){
			foreach ($return_value as $key){
				$return[$key]=$this->db[$row_key][$key];
			}
		}
	}

	/**
	 * fetch value
	 *
	 * @param name $field_key
	 * @param string $value_key
	 * @param name $return_value
	 * @return string
	 */
	public function fetch_value($field_key,$value_key,$return_value){
		$row_key = $this->fetch_key($field_key,$value_key);
		if((!empty($row_key) || $row_key === 0) && array_key_exists($return_value,$this->db[$row_key]))
			return $this->db[$row_key][$return_value];
	}

	/**
	 * set_value (where $field_key == $value_key SET $set_key to $set_value)
	 *
	 * @param name $field_key
	 * @param string $value_key
	 * @param name $set_key
	 * @param string $set_value
	 */
	public function set_value($field_key,$value_key,$set_key,$set_value){
		$row_key = $this->fetch_key($field_key,$value_key);
		if(!empty($row_key) || $row_key === 0)
			$this->db[$row_key][$set_key] = $set_value;
	}

	/**
	 * Remove Row (where $field_key == $value_key)
	 *
	 * @param name $field_key
	 * @param string $value_key
	 * 
	 * @return boolean
	 */
	public function remove_row($field_key,$value_key,$rows=null){
		if ($rows == null){
			$row_key = $this->fetch_key($field_key,$value_key);
			if(!empty($row_key) || $row_key === 0){
				unset($this->db[$row_key]);
				return true;
			}
		}else{
			foreach ($this->db as $k => $v){
				if (array_key_exists($field_key,$v) && $v[$field_key] == $value_key){
					unset($this->db[$k]);
				}
			}
		}
	}

	/**
	 * Add Row
	 * @param array $row
	 * @return boolean
	 */
	public function add_row($row){
		if (!empty($row)){
			$this->db[] = $row;
			return true;
		}
	}

	/**
	 * replace row
	 * @param array $row
	 * @param string $key
	 * @return boolean
	 */
	public function replace_row($row,$key,$value_key=null){
		if ($value_key != null) 
			$row_key = $this->fetch_key($key,$value_key);
		if(!empty($row_key) || $row_key === 0)
			$key = $row_key;
		if (!empty($row) && $key!==''){
			$this->db[$key] = $row;
			return true;
		}
	}

	/**
	 * save DB file if exists else return empty array
	 *
	 * @param address $fileaddress default db address
	 * @return boolean
	 */
	private function save_db($fileaddress = null){
		if($fileaddress==null)$fileaddress = $this->db_address;
		$fp = fopen($fileaddress, 'w+') or die('I could not open $fileaddress.');
		fwrite($fp, serialize($this->db));
		fclose($fp);
		return true;
	}

	/**
	 * db_search
	 * @param array() $search(
	 * @param array() $key_in(key to look in - can be empty to search all keys)
	 * @return array()
	 */
	public function db_search($search,$key_in=null){
		$found_inx = array();
		$split_search = split ( " ",$search );

		foreach ($this->db as $k => $v) {
			foreach ($split_search as $key => $val) {
				if( $val!='' && strlen ( $val ) > 0 ){
					if ($this->array_search_bit($val,$this->db[$k],($key_in==null?'':$key_in)))
						if(!in_array($k,$found_inx)){
							$found_inx[] = $k;
							$found_img[] = $this->db[$k];
						}
				}
			}
		}
		return isset($found_img)?$found_img: array();
	}

	/**
	 * Load DB file if exists else return empty array
	 *
	 * @param address $fileaddress default db address
	 * @return array()
	 */
	private function load_db($fileaddress = null){
		if($fileaddress==null)$fileaddress = $this->db_address;
		if (file_exists($fileaddress ))
			$filearray = unserialize(file_get_contents($fileaddress)); 
		else
			$filearray = array();
		return $filearray;
	}

	/**
	 * fetch row key
	 *
	 * @param name $field_key
	 * @param string $value_key
	 * @return string
	 */
	private function fetch_key($field_key,$value_key){
		if ($field_key ==null || $value_key ==null)return;;
		if (!is_array($this->db))return;
		foreach ($this->db as $k => $v){
			if (array_key_exists($field_key,$v) && $v[$field_key] == $value_key){
				return $k;
			}
		}
	}


	/**
	 * array_search_bit
	 *
	 * @param string $search
	 * @param array $db
	 * @param array $searchIn (array of keys to search in can be empty to search all keys)
	 * @return boolean
	 */
	private function array_search_bit($search, $db, $searchIn=array()){
		foreach ($db as $k => $v){
			if (in_array(strtolower($k), $searchIn) || empty($searchIn)){
				if (strpos(strtolower($v), strtolower($search)) !== FALSE){
					return true;
				}
			}
		}
		return false;
	}
}



?>