<?
//
//   CF Image Hosting Script v1.3.8
//   -------------------------------
//
//   Author:    codefuture.co.uk
//   Version:   1.3.8
//   Date:      14-Aug-10
//
//   download the latest version from - http://codefuture.co.uk/projects/imagehost1.3/
//
//   Copyright (c) 2010 codefuture.co.uk
//   This file is part of the CF Image Hosting Script.
//
//   CF Image Hosting Script is free software: you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation, either version 3 of the License, or
//   (at your option) any later version.
//
//   CF Image Hosting Script is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//   You should have received a copy of the GNU General Public License
//   along with CF Image Hosting Script.  If not, see http://www.gnu.org/licenses/.
//
////////////////////////////////////////////////////////////////////////////////////

	include_once('inc/config.php');

	$act = isset($_GET['act']) ? input($_GET['act']):'';

// LOGOUT
	if ($act == 'logout'){
		session_unset();
		session_destroy();
		$Suc['logged_out'] = $LANGUAGE_PACK["admin_logged_out_suc"];
	}

// LOGIN
	if(isset($_POST['enter']) && isset($_POST['passWord']) && isset($_POST['userName']) ){
		if(md5(md5(input($_POST['passWord'])).$settings['SET_SALTING']) == $settings['SET_PASSWORD'] &&
			input($_POST['userName']) == $settings['SET_USERNAME']){
			$_SESSION['loggedin'] = true;
			$_SESSION['set_name'] = md5($settings['SET_USERNAME'].$settings['SET_SALTING']);
		}else{
			$Err['login']= $LANGUAGE_PACK["admin_login_err"];
		}
	}

	$pagination_ex_var_li = '';
	$pagination_ex_var_ob = '';
	$reset_password = false;

////////////////////////////////////////////////////////////////////////////////////
// FORGOT YOUR PASSWORD - SEND LINK
	if (isset($_GET['forgot'])){

	// Always set content-type when sending HTML email
		$headers = "MIME-Version: 1.0" . "\r\n";
		$headers .= "Content-type:text/html;charset=iso-8859-1" . "\r\n";
	// More headers
		$headers .= 'From: '.$settings['SET_CONTACT']."\r\n";
		$subject = $settings['SET_TITLE'].' - '.$LANGUAGE_PACK["admin_forgot_password_email_subject"];

		$find = array( '{reset_url}', '{user_name}');
		$reset_id = md5(time().$settings['SET_SALTING']);
		$replace = array(
						'reset_url' => '<a href="'.$settings['SET_SITEURL'].'/admin.php?reset='.$reset_id.'">'.$settings['SET_SITEURL'].'/admin.php?reset='.$reset_id.'</a>',
						'user_name' => $settings['SET_USERNAME']
						);

		$msg = str_replace($find, $replace, $LANGUAGE_PACK["admin_forgot_password_email_body"]);

		@mail($settings['SET_CONTACT'],$subject,$msg,$headers);

		if(savefile(array('id'=>$reset_id,'date'=>time()),$DIR_DATA.'rs.cf')){
			$Suc['forgot_password'] = $LANGUAGE_PACK["admin_forgot_password_suc"];
		}
	}

// FORGOT YOUR PASSWORD - RESET LINK CHECK
	if (isset($_GET['reset'])){
		if(file_exists($DIR_DATA.'rs.cf')){
			$reset_db = new array_db($DIR_DATA.'rs.cf');
			$reset_db_all = $reset_db->fetch_all();
			if ($reset_db_all['id'] == input($_GET['reset']) &&	($reset_db_all['date']+3600) > time()){
				$reset_password = true;
			}else{
				$Err['forgot_password'] = $LANGUAGE_PACK["admin_forgot_password_err"];
			}
		}else{
			$Err['forgot_password'] = $LANGUAGE_PACK["admin_forgot_password_err"];
		}
	}

// FORGOT YOUR PASSWORD - NEW PASSWORD
	if(isset($_POST['action']) && $_POST['action'] == 'reset'){
	//Password
		if(!empty($_POST['newPassword']) && !empty($_POST['newConfirm'])){
			if (input($_POST['newPassword']) == input($_POST['newConfirm'])){
				$settings['SET_PASSWORD'] = md5(md5(input($_POST['newPassword'])).$settings['SET_SALTING']);
				$setting_db->set_db($settings);
				if($setting_db->save_db_now()){
					$Suc['password_update'] = $LANGUAGE_PACK["admin_set_suc_update"];
				}else{
					$Err['password_update'] = $LANGUAGE_PACK["admin_set_err_saveing_settings"];
					$reset_password = true;
				}
			}else{
				$Err['password_update'] = $LANGUAGE_PACK["admin_set_err_password_wrong"];
				$reset_password = true;
			}
		}else{
			$Err['password_update'] = $LANGUAGE_PACK["admin_set_err_password_both"];
			$reset_password = true;
		}
	}

// END FORGOT YOUR PASSWORD
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
// LOGIN CHECK

if (checklogin()) {

	$db = new array_db($ADD_DB_IMG);
	if($db->db_not_empty()){

////////////////////////////////////////////////////////////////////////////////////
// DELETE IMAGE

	if ($act == "remove" && input($_GET['d']) != ''){

		$img_del_code	= input($_GET['d']);
		$img_del_id		= $db->fetch_value('deleteid',$img_del_code,'id');
		if (!empty($img_del_id)){
		// Remove Image
			if(@unlink(get_image_address($img_del_id,'',$db_img)))
				$Suc['delete_image'] = $LANGUAGE_PACK["admin_delete_image_suc"];
			else
				$Err['delete_image'] = $LANGUAGE_PACK["admin_delete_image_err"];

		// Remove small thumb
			if(@unlink(get_thumb_address($img_del_id)))
				$Suc['delete_small_thumb'] = $LANGUAGE_PACK["admin_delete_small_thumb_suc"];
			else
				$Err['delete_small_thumb'] = $LANGUAGE_PACK["admin_delete_small_thumb_err"];

		// Remove thumb
			if(@unlink(get_thumb_mid_address($img_del_id)))
				$Suc['delete_thumb'] = $LANGUAGE_PACK["admin_delete_thumb_suc"];
			else
				$Err['delete_thumb'] = $LANGUAGE_PACK["admin_delete_thumb_err"];

			if ($db->remove_row('id',$img_del_id)){
				if($db -> save_db_now())
					$Suc['delete_image_db'] = $LANGUAGE_PACK["admin_delete_image_db_suc"];
				else
					$Err['delete_image_db'] = $LANGUAGE_PACK["admin_delete_image_db_err"];
			}else
				$Err['delete_image_db'] = $LANGUAGE_PACK["admin_delete_image_db_err"];
		}else
			$Err['delete_no_image'] = $LANGUAGE_PACK["admin_delete_no_image_err"];
	}

// DELETE IMAGE END
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
// BANDWIDTH RESET PAGE
	if ($act == "reset" && input($_GET['id']) != ''){
		if(bandwidth_reset(input($_GET['id'])))
			$Suc['bandwidth_reset'] = $LANGUAGE_PACK["admin_bandwidth_reset_suc"];
		else
			$Err['bandwidth_reset'] = $LANGUAGE_PACK["admin_bandwidth_reset_err"];
	}

// BANDWIDTH RESET END
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
// EDIT IMAGE TITLE/PRIVATE

	if ($act == "edit" && input($_GET['id']) != ''){
		$edit_img_id = input($_GET['id']);

		if(isset($_POST['update'])){
			$db->set_value('id',$edit_img_id,'alt',input($_POST['setAlt']));
			$db->set_value('id',$edit_img_id,'private',(input($_POST['setPrivate']) == 1? TRUE:FALSE));
			if($db->save_db_now())
				$Suc['edit_image'] = $LANGUAGE_PACK["admin_image_edit_suc"];
		}

		$edit_image = $db->fetch_row('id',$edit_img_id);

	}

//  EDIT IMAGE TITLE/PRIVATE END
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
// ADMIN HOME

	if( $act != 'set' && $act != 'ban' && $act != 'edit'){
////////////////////////////////////////////////////////////////////////////////////
// REPORT (ADMIN HOME)

	$report_list = null;

	if($settings['SET_ALLOW_REPORT']){
		$db_report = new array_db($ADD_DB_REPORT);

		if ($act == "remove" && isset($img_del_id)){
			 if ($db_report->item_exists('id',$img_del_id)){
				if($db_report->remove_row('id',$img_del_id) && $db_report->save_db_now())
					$Suc['image_report_remove'] = $LANGUAGE_PACK["admin_image_report_remove_suc"];
				else
					$Err['image_report_remove'] = $LANGUAGE_PACK["admin_image_report_remove_err"];
			}
		}

		if ($act == "report" && input($_GET['id']) != ''){
			if($db_report->remove_row('id',input($_GET['id'])) && $db_report->save_db_now())
				$Suc['image_report_remove'] = $LANGUAGE_PACK["admin_image_report_remove_suc"];
			else
				$Err['image_report_remove'] = $LANGUAGE_PACK["admin_image_report_remove_err"];
		}

		if($db_report->db_not_empty()){
			$full_report = $db_report ->fetch_all();
			foreach ($full_report as $k => $v){
				$odd_class		= empty($odd_class) ? ' class="odd"' : '';
				$img_alt		= $db->fetch_value('id',$v['id'],'alt');
				$img_name		= $db->fetch_value('id',$v['id'],'name');
				$img_r_count	= $v['count'];
				$img_deleteid	= $db->fetch_value('id',$v['id'],'deleteid');
				$img_url		= get_image_address($v['id'],'');
				$img_thumb_url	= get_thumb_address($v['id']);
				$report_list .= '<tr'.$odd_class.'>
								<td>
								<a href="admin.php?act=report&id='.$v['id'].'" title=""><img src="img/tick_circle.png" height="16" width="16" border="0" alt="'.$LANGUAGE_PACK["admin_image_report_alt_remove"].'" class="tooltip" /></a>
								<a href="admin.php?act=remove&d='.$img_deleteid.'" title="" onclick="return doconfirm(\''.sprintf($LANGUAGE_PACK["admin_image_report_delete"],$v['id']).'\');"><img src="img/delete.png" height="16" width="16" border="0" alt="'.$LANGUAGE_PACK["admin_image_report_alt_delete"].'" class="tooltip" /></a>
								<a href="admin.php?act=ban&id='.$v['id'].'" title=""><img src="img/noentry.png" height="16" width="16" border="0" alt="'.$LANGUAGE_PACK["admin_image_report_alt_ban"].'" class="tooltip" /></a>
								</td>
								<td class="textleft">'.date('d M y',$v['date']).'</td>
								<td><a href="'.$img_url.'" target="_blank" title="'.$img_alt.'" img_src="'.$img_thumb_url.'" class="imglink img_tooltip">'.$img_name.'</a></td>
								<td>'.$img_r_count.'</td></tr>';
			}
		}
	}

// REPORT END
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
// IMAGE LIST (ADMIN HOME)

	// number of items on page
		$item_on_page = (isset($_GET['list']) ? input($_GET['list']):20);

	// order list by
		$order_by = (isset($_GET['orderBy']) ? input($_GET['orderBy']):'added');

		$pagination_ex_var_li = (isset($_GET['list']) ? '&list='.input($_GET['list']):'');
		$pagination_ex_var_ob = (isset($_GET['orderBy']) ? '&orderBy='.input($_GET['orderBy']):'');

	// what page are we on
		$page_number = (isset($_GET['p']) ? input($_GET['p'])-1:0);// 0=1st

	// workout start - stop
		$img_star_on = $page_number*$item_on_page;
		$img_end_on = (($img_star_on+$item_on_page)>$db->db_count() ? $db->db_count() : $img_star_on+$item_on_page);

	// page pagination
		$pagination = pagination($page_number,$item_on_page,$db->db_count(),'admin.php',$pagination_ex_var_li.$pagination_ex_var_ob);

	//load img counter DB
		$db_counter = new array_db($ADD_DB_COUNT);

	//var for totals
		$total_bw			= 0;
		$total_image_size	= 0;
		$most_bw_image		= 0;
		$most_bw_image_id	= null;

	// make output array
		$db_img = $db->fetch_all();

		foreach ($db_img as $k => $v){
			$v_c = $db_counter -> fetch_row('id',$v['id']);
			$db_img[$k]['lastviewed']	= (!isset($v_c['date']) 		? round(((time() - $v['added']) / 86400),2):round(((time() - $v_c['date']) / 86400),2));
			$db_img[$k]['counter']		= (!isset($v_c['image'])		? 0:$v_c['image']);
			$db_img[$k]['thumb_mid']	= (!isset($v_c['thumb_mid'])	? 0:$v_c['thumb_mid']);
			$db_img[$k]['thumb']		= (!isset($v_c['thumb'])		? 0:$v_c['thumb']);
			$db_img[$k]['gallery']		= (!isset($v_c['gallery'])		? 0:$v_c['gallery']);
			$db_img[$k]['bandwidth']	= (!isset($v_c['bandwidth'])	? 0:$v_c['bandwidth']);
			$added_new = 1;
		//totals
			$total_bw			= $total_bw + $db_img[$k]['bandwidth'];
			$total_image_size	= $total_image_size + $v['size'];

			if($most_bw_image < $db_img[$k]['bandwidth']){
				$most_bw_image		= $db_img[$k]['bandwidth'];
				$most_bw_image_id	= $v['id'];
			}
		}
		$most_bw_image_address	= get_image_address($most_bw_image_id,'');
		$most_bw_thumb_url		= get_thumb_mid_address($most_bw_image_id);
		$most_bw_image_alt		= $db->fetch_value('id',$most_bw_image_id,'alt');

		$db->set_db($db_img);
		$db->order_by($order_by,321);

	//make image list
		$list_item = '';
		for ($i = $img_star_on; $i < $img_end_on; $i++) {

			$db_img 	= $db->fetch_key_value($i);
			$li_added	= date('d M y',$db_img['added']);
			$li_img_url	= get_image_address($db_img['id'],'');
			$thumb_url	= get_thumb_address($db_img['id']);
			$li_bw		= format_size($db_img['bandwidth']);
			$bw_over	= ($settings['SET_MAX_BANDWIDTH'] !=0 &&
						  ($settings['SET_MAX_BANDWIDTH']*1048576) < $db_img['bandwidth']?
							' style="background-color:red;color:#000"':'');

			$list_item .='
<tr'.($li_odd = empty($li_odd) ? ' class="odd"' : '').'>
	<td>
		<a href="admin.php?act=remove&d='.$db_img['deleteid'].'" title="" onclick="return doconfirm(\''.sprintf($LANGUAGE_PACK["admin_image_report_delete"],$v['id']).'\');"><img src="img/delete.png" height="16" width="16" border="0" alt="'.$LANGUAGE_PACK["admin_image_report_alt_delete"].'" class="tooltip" /></a>
		<a href="admin.php?act=ban&id='.$db_img['id'].'" title=""><img src="img/noentry.png" height="16" width="16" border="0" alt="'.$LANGUAGE_PACK["admin_image_report_alt_ban"].'" class="tooltip" /></a>
		<a href="admin.php?act=reset&id='.$db_img['id'].'" title=""><img src="img/reset.png" height="16" width="16" border="0" alt="'.$LANGUAGE_PACK["admin_image_reset_bandwidth"].'" class="tooltip" /></a>
		<a href="admin.php?act=edit&id='.$db_img['id'].'" title=""><img src="img/edit.png" height="16" width="16" border="0" alt="'.$LANGUAGE_PACK["admin_image_edit_alt"].'" class="tooltip" /></a>
		
		
	</td>
	<td>'.$li_added.'</td>
	<td><a href="'.$li_img_url.'" target="_blank" title="'.$db_img['alt'].'" img_src="'.$thumb_url.'" class="imglink img_tooltip">'.$db_img['alt'].'</a></td>
	<td>'.$db_img['lastviewed'].'</td>
	<td>'.$db_img['gallery'].'</td>
	<td>'.$db_img['thumb'].'</td>
	<td>'.$db_img['thumb_mid'].'</td>
	<td>'.$db_img['counter'].'</td>
	<td'.$bw_over.'>'.$li_bw.'</td>
	<td>'.(array_key_exists('private',$db_img) && $db_img['private']?'Yes':'No').'</td>
</tr>';

		}

// MAIN ADMIN PAGE END
///////////////////////////////////////////////////////////////////////////////////////

}// end if not settings page

	}//end img db count (no images in db)
	else{
		$db_img_count			= 0;
		$total_image_size		= 0;
		$total_bw 				= 0;
		$most_bw_image 			= 0;
		$most_bw_image_address 	= '';
		$most_bw_image_alt		= '';
		$most_bw_image_id		= 0;
		$list_item				= '';
		$pagination				= '';
	}

// END ADMIN HOME
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
//BAN USER FROM UPLOADING

	if($act=='ban' && isset($_POST['changesettings'])) {
		$ban_ip = input($_POST['banIP']);
		$ban_description = input($_POST['banDes']);
		if ($ban_ip != ''){
			$db_ban = new array_db($ADD_DB_BAN);
			$db_ban->add_row(array('ip'=>$ban_ip,'des'=>$ban_description,'date'=>time()));
			if ($db_ban->save_db_now()) $Suc = sprintf($LANGUAGE_PACK["admin_ban_user_suc"],$ban_ip);
			else $Err['ban_user'] = $LANGUAGE_PACK["admin_ban_user_err_save_db"];
		}else $Err['ban_user'] = $LANGUAGE_PACK["admin_ban_user_err_no_ip"];
	}

	if($act=='ban'){
		$db_ban = new array_db($ADD_DB_BAN);
	//unban
		$ip_to_unban = isset($_GET['ip']) ? input($_GET['ip']):'';
		if ($ip_to_unban != ''){
			if ($db_ban->remove_row('ip',$ip_to_unban) && $db_ban->save_db_now())
				$Suc['ban_user'] = sprintf($LANGUAGE_PACK["admin_ban_user_suc_unbanned"],$ip_to_unban);
		}
	// find ip from image ID
		$id_to_ban = isset($_GET['id']) ? input($_GET['id']):'';
		if ($id_to_ban != ''){
			$BAN_IP = $db->fetch_value('id',$id_to_ban,'ip');
		}
	// List Banned IP
		$banned_list='';
		$full_ban_db = $db_ban ->fetch_all();
		foreach ($full_ban_db as $k => $v){
			$odd_class = empty($odd_class) ? ' class="odd"' : '';
			$banned_list .= '<tr'.$odd_class.'>
							<td class="textleft"><a href="admin.php?act=ban&ip='.$v['ip'].'" title=""><img class="tooltip" src="img/delete.png" height="16" width="16" border="0" alt="'.$LANGUAGE_PACK["admin_ban_user_alt_unban"].'"/></a></td>
							<td class="textleft">'.date('d M y',$v['date']).'</td>
							<td class="textleft">'.$v['ip'].'</td><td class="textleft">'.$v['des'].'</td></tr>';
		}
	}

//BAN USER FROM UPLOADING END
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
//SAVE NEW SETTINGS

	if($act=='set' && isset($_POST['changesettings'])) {

	//Password
		if(!empty($_POST['oldPassword']) && !empty($_POST['newPassword']) && !empty($_POST['newConfirm'])){
			if (input($_POST['newPassword']) == input($_POST['newConfirm'])){
				if (md5(md5(input($_POST['oldPassword'])).$settings['SET_SALTING']) == $settings['SET_PASSWORD']){
					$settings['SET_PASSWORD'] = md5(md5(input($_POST['newPassword'])).$settings['SET_SALTING']);
				}else{
					$Err['password_wrong'] = $LANGUAGE_PACK["admin_set_err_password_wrong"];
				}
			}else{
				$Err['password_wrong'] = $LANGUAGE_PACK["admin_set_err_password_wrong"];
			}
		}else if(!empty($_POST['oldPassword']) || !empty($_POST['newPassword']) || !empty($_POST['newConfirm'])){
			$Err['password_wrong'] = $LANGUAGE_PACK["admin_set_err_password_both"];
		}

	//UserName
		if (!empty($_POST['setUserName'])){
			$settings['SET_USERNAME'] = input($_POST['setUserName']);
		}else{
			$Err['err_username'] = $LANGUAGE_PACK["admin_set_err_username"];
		}

	//email
		if(eregi('^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,4})$', input($_POST['setEmail']))){
			$settings['SET_CONTACT'] = input($_POST['setEmail']);
		}else{
			$Err['email_invalid'] = $LANGUAGE_PACK["admin_set_err_email_invalid"];
		}

	// Script Url
		$scriptUrl = input($_POST['setScriptUrl']);
		if(substr($scriptUrl, -1) == "/") $scriptUrl = substr($scriptUrl, 0, -1);
		if (!empty($scriptUrl)){
			$settings['SET_SITEURL'] = $scriptUrl;
		}else{
			$Err['err_script_url']= $LANGUAGE_PACK["admin_set_err_script_url"];
		}

		$settings['SET_WATERMARK']			= input($_POST['setWaterMark']) == 1? TRUE:FALSE;
		$settings['SET_WATERMARK_TEXT']		= input($_POST['setWatermarkText']);
		$settings['SET_WATERMARK_PLACED']	= input($_POST['setWatermarkPlaced']) == 1? TRUE:FALSE;;

		$settings['SET_ADMIN_MENU']			= input($_POST['setAdminMenu']) == 1? TRUE:FALSE;
		$settings['SET_MOD_REWRITE']		= input($_POST['setModRewrite']) == 1? TRUE:FALSE;
		$settings['SET_HIDE_SEARCH']		= input($_POST['setHideSearch']) == 1? TRUE:FALSE;
		$settings['SET_AUTO_DELETED']		= input($_POST['setAutoDeleted']) == 1? TRUE:FALSE;
		$settings['SET_HIDE_CONTACT']		= input($_POST['setHideContact']) == 1? TRUE:FALSE;
		$settings['SET_HIDE_TOS']			= input($_POST['setHideTos']) == 1? TRUE:FALSE;
		$settings['SET_HIDE_GALLERY']		= input($_POST['setHideGallery']) == 1? TRUE:FALSE;
		$settings['SET_EMAIL_REPORT']		= input($_POST['setEmailReport']) == 1? TRUE:FALSE;
		$settings['SET_ALLOW_REPORT']		= input($_POST['setAllowReport']) == 1? TRUE:FALSE;
		$settings['SET_REMOVE_REPORT']		= input($_POST['setRemoveReport']) == 1? TRUE:FALSE;
		$settings['SET_MAX_BANDWIDTH']		= (int)empty($_POST['setMaxBandwidth'])?0:$_POST['setMaxBandwidth'];
		$settings['SET_TITLE']				= input($_POST['setTitle']);
		$settings['SET_SLOGAN']				= input($_POST['setSlogan']);
		$settings['SET_COPYRIGHT']			= input($_POST['setCopyright']);
		$settings['SET_MAXSIZE'] 			= (int)input($_POST['setMaxSize']);
		$settings['SET_IMG_ON_PAGE']		= (int)input($_POST['setImgOnPage']);
		$settings['SET_MAX_UPLOAD']			= (int)input($_POST['setMaxUpload']);
		$settings['SET_THEME'] 				= input($_POST['setTheme']);
		$settings['SET_GOOGLE_ANALYTICS']	= input($_POST['setAnalytics']);
		$settings['SET_GOOGLE_ADS']			= input($_POST['setGoogleAds']);
		$settings['SET_BANDWIDTH_RESET']	= input($_POST['setBandwidthReset']);
		$settings['SET_AUTO_DELETED_TIME']	= (int)input($_POST['setAutoDeletedTime']);
		$settings['SET_AUTO_DELETED_JUMP']	= input($_POST['setAutoDeletedJump']);
		$settings['SET_SHORT_URL_ON']		= input($_POST['setShortUrl']) == 1? TRUE:FALSE;
		$settings['SET_PRIVATE_IMG_ON']		= input($_POST['setPrivateImg']) == 1? TRUE:FALSE;
		$settings['SET_DIS_UPLOAD']			= input($_POST['setDisUpload']) == 1? TRUE:FALSE;
		$settings['SET_PANEL_OPEN']			= input($_POST['setPanelOpen']) == 1? TRUE:FALSE;
		$settings['SET_LANGUAGE']			= input($_POST['setLanguage']);
		$settings['SET_IMAGE_DETAILS']		= input($_POST['setImageDetails']) == 1? TRUE:FALSE;

		$settings['SET_SHORT_URL_API']		= input($_POST['setSUrlApi']);
		$settings['SET_SHORT_URL_API_URL']	= input($_POST['setSUrlApiUrl']);
		$settings['SET_SHORT_URL_PASS']		= input($_POST['setSUrlApiPass']);
		$settings['SET_SHORT_URL_USER']		= input($_POST['setSUrlApiUesr']);

	// make array for saving
		if (empty($Err)){
			$setting_db->set_db($settings);
			if($setting_db->save_db_now()){
				$Suc['saveing_settings'] = $LANGUAGE_PACK["admin_set_suc_update"];
			}else
				$Err['saveing_settings'] = $LANGUAGE_PACK["admin_set_err_saveing_settings"];
		}
	}

//SAVE NEW SETTINGS END
////////////////////////////////////////////////////////////////////////////////////

}

// END LOGGED IN
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
// stop page from being cached
	// Date in the past
		header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
	// Always modified
		header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
	// HTTP/1.1
		header("Cache-Control: no-store, no-cache, must-revalidate");
		header("Cache-Control: post-check=0, pre-check=0", false);
	// HTTP/1.0
		header("Pragma: no-cache"); 
// stop page from being cached
/////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////
// MAKE PAGE

// page on
	$menu = ($act == 'set' ? 'set':($act == 'ban' ? 'ban':'admin'));
/////////////////////////////////////////////////////////////////////////////////////
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<title><?=$settings['SET_TITLE'];?> CF IMAGE HOSTING</title>
<meta name="Description" content="Free CF Image Hosting" />
<meta name="Keywords" content="Free Image Hosting" />
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<link rel="alternate" type="application/rss+xml" title="<?=$settings['SET_TITLE'];?> Feed" href="feed.php" />
<meta name="Distribution" content="Global" />
<meta name="Robots" content="index,follow" />
<link rel="stylesheet" href="css/admin.css" type="text/css" />

<script type="text/javascript" src="http://code.jquery.com/jquery-1.4.2.min.js"></script>
<script type="text/javascript" src="lightbox/jquery.lightbox-0.5.js"></script>
<link rel="stylesheet" type="text/css" href="lightbox/jquery.lightbox-0.5.css" media="screen" />
<script type= "text/javascript">
/*<![CDATA[*/
function doconfirm(message) {
	if (confirm(message)){
		return true;
	}else{
		return false;
	}
}
$(function() {$('a.imglink').lightBox({overlayOpacity: 0.6});});
this.tooltip = function(){
	$(".tooltip").hover(function(e){
		var offset = $(this).offset();
		this.t = (this.tagName ==='TH'?
					this.abbr:
					(this.tagName ==='A'?
						this.title:
						(this.tagName ==='IMG'?
							this.alt:
							this.ref
						)
					)
				);
		if (this.tagName ==='A') this.title = "";
		if (this.tagName ==='IMG') this.alt = "";
		$("body").append("<div id='tooltip'>"+ this.t +"</div>");
		var itemHeight = $(this).height()/2;
		var itemWidth = $(this).width()/2;
		$("#tooltip")
			.css("top","-99999px")
			.css("left","-99999px")
			.css("display", "block");
		var xOffset = offset.top - $("#tooltip").height()-itemHeight;
		var yOffset = offset.left + itemWidth - ($("#tooltip").width()/2);
		$("#tooltip")
			.css("display", "none")
			.css("top",(xOffset) + "px")
			.css("left",(yOffset) + "px")
			.fadeIn("fast");
	},
	function(){
		$("#tooltip").remove();
		if (this.tagName ==='A') this.title = this.t;
		if (this.tagName ==='IMG') this.alt = this.t;
	});
};

function pimg(){
	this.xOffset = 5;
	this.yOffset = 50;
	$("a.img_tooltip").hover(function (e){
		this.img_title = this.title;
		this.title = "";
		var img_src = $(this).attr('img_src');
		var desc = (this.img_title != "") ? "<h3>" + this.img_title + "</h3>" : "";
		var image = (img_src) ? img_src : this.src;
		$("body").append("<div id='img_tooltip'><img src='" + image + "' alt='Image preview' />" + desc + "</div>");
		$("#img_tooltip").css("top", (e.pageY - xOffset) + "px").css("left", (e.pageX + yOffset) + "px");
		$("#img_tooltip").fadeIn(700);
	}, function (){
		this.title = this.img_title;
		$("#img_tooltip").remove();
	});
};

$(document).ready(function (){
// Image tooltip
	pimg();
// settings panel
	var lastOpen = '';
	$(".flip").click(function(){
		if(lastOpen != $(this)){
			$(lastOpen).next('.panel').animate({"height": "toggle", "opacity": "toggle"}, "slow");
			$(this).next('.panel').animate({"height": "toggle", "opacity": "toggle"}, "slow");
			lastOpen = $(this);
		}
	});
// tooltip start
	tooltip();
// ShortUrl
	$("#setShortUrl").change(function () {
		$("#setShortUrl option:selected").each(function (){
			if($(this).attr("value") == "1"){
				$("#surl_op").animate({"height": "toggle", "opacity": "toggle"}, "slow");
			}else{
				$("#surl_op").animate({"height": "toggle", "opacity": "toggle"}, "slow");
			}
		});
	}).change();
	$("#setSUrlApi").change(function () {
		$("#setSUrlApi option:selected").each(function (){
			if($(this).attr("value") == "b54" || $(this).attr("value") == "tinyurl" ||	$(this).attr("value") == "isgd"){
				$("#url_pass").animate({"height": "hide", "opacity": "hide"}, "slow");
				$("#url_user").animate({"height": "hide", "opacity": "hide"}, "slow");
			}else{
				$("#url_user").animate({"height": "show", "opacity": "show"}, "slow");
				$("#url_pass").animate({"height": "show", "opacity": "show"}, "slow");
			}
			if($(this).attr("value") == "yourls"){
				$("#url_api").animate({"height": "show", "opacity": "show"}, "slow");
			}else{
				$("#url_api").animate({"height": "hide", "opacity": "hide"}, "slow");
			}
		});
	}).change();
});

$(function () {
		var tabContainers = $('div.tabs > div');
		tabContainers.hide().filter(':first').animate({"opacity": "toggle"}, "slow");
		
		$('div.tabs ul.tabNavigation a').click(function () {
				tabContainers.hide();
				tabContainers.filter(this.hash).animate({"opacity": "toggle"}, "slow");
				$('div.tabs ul.tabNavigation a').removeClass('current');
				$(this).addClass('current');
				return false;
		}).filter(':first').click();
});

/*]]>*/
</script>

</head>
<body>
<? if(checklogin()){?>
<div id="admin_bar">
<div class="title"><a href="admin.php" title="Admin">Admin Menu</a></div>
<ul class="nav">
	<li><a href="admin.php?act=logout" title="<?=$LANGUAGE_PACK["admin_menu_logout"];?>"><?=$LANGUAGE_PACK["admin_menu_logout"];?></a></li>
	<li><a <?=($menu=="set" ? ' class="current" ':'');?> href="admin.php?act=set" title="<?=$LANGUAGE_PACK["admin_menu_settings"];?>"><?=$LANGUAGE_PACK["admin_menu_settings"];?></a></li>
	<li><a <?=($menu=="ban" ? ' class="current" ':'');?> href="admin.php?act=ban" title="<?=$LANGUAGE_PACK["admin_menu_banned"];?>"><?=$LANGUAGE_PACK["admin_menu_banned"];?></a></li>
<? if($settings['SET_ADMIN_MENU']){?>
	<li><a <?=($menu=="admin" ? ' class="current"':'');?> href="admin.php" title="<?=$LANGUAGE_PACK["admin_menu_home"];?>"><?=$LANGUAGE_PACK["admin_menu_home"];?></a></li>
<?}?>
</ul>
</div>
<?}?>
<div id="wrap">
	<div id="header" class="clear">
		<div id="logo">
			<h1><a href="index.php" title="Home"><?=$settings['SET_TITLE'];?></a></h1>
			<h2><?=$settings['SET_SLOGAN'];?></h2>
		</div>
	<?if(!$settings['SET_HIDE_SEARCH']){?>
		<div id="search">
			<form method="get" action="search.php">
			<input type="text" size="28" name="search" class="text_input" value="<?=$LANGUAGE_PACK["site_search_text"];?>" onfocus="if(this.value=='<?=$LANGUAGE_PACK["site_search_text"];?>')value=''" onblur="if(this.value=='')value='<?=$LANGUAGE_PACK["site_search_text"];?>';" ><input type="submit" value="<?=$LANGUAGE_PACK["site_search_button"];?>" class="button">
			</form>
		</div>
	<?}?>
		<div id="nav">
			<ul id="main-nav">
				<li><a <?=($menu=="" ? ' class="current" ':'');?> href="./" title="<?=$LANGUAGE_PACK["site_menu_home"];?>"><?=$LANGUAGE_PACK["site_menu_home"];?></a></li>
			<? if(!$settings['SET_HIDE_GALLERY']){?>
				<li><a <?=($menu=="gallery" ? ' class="current" ':'');?> href="gallery.php" title="<?=$LANGUAGE_PACK["site_menu_gallery"];?>"><?=$LANGUAGE_PACK["site_menu_gallery"];?></a></li>
			<?}?>
			<? if(!$settings['SET_HIDE_TOS']){?>
				<li><a <?=($menu=="tos" ? ' class="current" ':'');?> href="tos.php" title="<?=$LANGUAGE_PACK["site_menu_tos"];?>"><?=$LANGUAGE_PACK["site_menu_tos"];?></a></li>
			<?}?>
			<? if(!$settings['SET_HIDE_CONTACT']){?>
				<li><a <?=($menu=="contact" ? ' class="current" ':'');?> href="contact.php" title="<?=$LANGUAGE_PACK["site_menu_contact"];?>"><?=$LANGUAGE_PACK["site_menu_contact"];?></a></li>
			<?}?>
			<? if(!$settings['SET_ADMIN_MENU']){?>
				<li><a <?=($menu=="admin" ? ' class="current"':'');?> href="admin.php" title="<?=$LANGUAGE_PACK["site_menu_home"];?>"><?=$LANGUAGE_PACK["site_menu_admin"];?></a></li>
			<?}?>
			</ul>
		</div>
	<div class="clear"></div>
	</div>
	<div id="content">

<?
/////////////////////////////////////////////////////////////////////////////////////////////
	success_note($Suc);
	error_note($Err);

	$report_list = isset($report_list)?$report_list:null;

//login?
if (checklogin()) {

	if ($act == "edit"){
?>		<h2 class="title"><?=$LANGUAGE_PACK["admin_image_edit_title"];?></h2>
		<div class="img_box"><img src="<?=get_thumb_mid_address($edit_image['id']);?>" title="<?=$edit_image['alt'];?>" /></div>
		<form method="POST" action="admin.php?act=edit&id=<?=$edit_img_id;?>" class="box">
				<div class="code_box"><label><?=$LANGUAGE_PACK["admin_image_edit_des_title"];?> : </label><input class="text_input" type="text" name="setAlt" value="<?=$edit_image['alt'];?>" size="20" /></div>
				<div class="code_box"><label><?=$LANGUAGE_PACK["admin_image_edit_pp_title"];?> :</label>
					<select name="setPrivate" class="text_input">
						<option value="0" <?=(!$edit_image['private'] ? 'selected="selected"':'');?>><?=$LANGUAGE_PACK["admin_image_edit_public"];?></option>
						<option value="1" <?=($edit_image['private'] ? 'selected="selected"':'');?>><?=$LANGUAGE_PACK["admin_image_edit_private"];?></option>
					</select></div>
				<input class="button button_cen" onclick="" type="submit" value="<?=$LANGUAGE_PACK["admin_image_edit_button"];?>" name="update">
		</form>
<?
	}

// admin page
	if(	$act != 'set' &&
		$act != 'ban' &&
		$act != 'edit'){
		
?>
			<div class="top_img">
				<h2><?=$LANGUAGE_PACK["admin_home_top_image"];?></h2>
				<img src="<?=$most_bw_thumb_url;?>" alt="<?=$most_bw_image_alt;?>"/><br/>
				<b>ID :</b> <a href="<?=$most_bw_image_address;?>" target="_blank" title="<?=$most_bw_image_alt;?>" class="imglink"><?=$most_bw_image_id;?></a><br/>
				<b><?=$LANGUAGE_PACK["admin_home_imglist_image_name"];?> :</b> <?=$most_bw_image_alt;?><br/>
				<b><?=$LANGUAGE_PACK["admin_home_total_bandwidth"];?> :</b> <?=format_size($most_bw_image);?><br/>
			</div>
			<table class="table_small">
				<thead>
					<tr>
						<th class="tooltip" scope="col" abbr="<?=$LANGUAGE_PACK["admin_home_tooltip_total_images"];?>"><?=$LANGUAGE_PACK["admin_home_total_images"];?></th>
						<th class="tooltip" scope="col" abbr="<?=$LANGUAGE_PACK["admin_home_private_images"];?>"><?=$LANGUAGE_PACK["admin_home_private_images"];?></th>
						<th class="tooltip" scope="col" abbr="<?=$LANGUAGE_PACK["admin_home_tooltip_filespace_used"];?>"><?=$LANGUAGE_PACK["admin_home_filespace_used"];?></th>
						<th class="tooltip" scope="col" abbr="<?=$LANGUAGE_PACK["admin_home_tooltip_total_bandwidth"];?>"><?=$LANGUAGE_PACK["admin_home_total_bandwidth"];?></th>
					</tr>
				</thead>
				<tbody>
					<tr class="odd">
						<td><?=$db->db_count();?></td>
						<td><?=$db->db_count('private',1);?></td>
						<td><?=format_size($total_image_size);?></td>
						<td><?=format_size($total_bw);?></td>
					</tr>
				</tbody>
			</table>
<?if($settings['SET_ALLOW_REPORT'] && $report_list!=null){?>
			<table class="table_small">
				<thead>
					<tr>
						<th>&nbsp;</th>
						<th class="tooltip" scope="col" abbr="<?=$LANGUAGE_PACK["admin_home_tooltip_date_reported"];?>"><?=$LANGUAGE_PACK["admin_home_date_reported"];?></th>
						<th class="tooltip" scope="col" abbr="<?=$LANGUAGE_PACK["admin_home_tooltip_image_name"];?>"><?=$LANGUAGE_PACK["admin_home_image_name"];?></th>
						<th class="tooltip" scope="col" abbr="<?=$LANGUAGE_PACK["admin_home_tooltip_reported"];?>"><?=$LANGUAGE_PACK["admin_home_reported"];?></th>
					</tr>
				</thead>
				<tbody>
					<?=$report_list;?>
				</tbody>
			</table>
<?}else{?>
			<br/><br/>
<?}?>
			<div class="table_top">
				<div class="col">
					<select name="onPage" size="1" class="text_input" onChange="if(value) window.location.href = this.value;">
						<option selected><?=$LANGUAGE_PACK["admin_home_number_to_list"];?></option>
						<option value="admin.php?list=20<?=$pagination_ex_var_ob;?>">20</option>
						<option value="admin.php?list=40<?=$pagination_ex_var_ob;?>">40</option>
						<option value="admin.php?list=80<?=$pagination_ex_var_ob;?>">80</option>
						<option value="admin.php?list=100<?=$pagination_ex_var_ob;?>">100</option>
						<option value="admin.php?list=999999<?=$pagination_ex_var_ob;?>"><?=$LANGUAGE_PACK["admin_home_number_to_list_all"];?></option>
					</select>
				</div>
				<div class="col">
					<select name="orderBy" size="1" class="text_input" onChange="if(value) window.location.href = this.value;">
						<option selected><?=$LANGUAGE_PACK["admin_home_order_list"];?></option>
						<option <?=($order_by=="added" ? '':'');?> value="admin.php?orderBy=added<?=$pagination_ex_var_li;?>"><?=$LANGUAGE_PACK["admin_home_order_list_date_added"];?></option>
						<option <?=($order_by=="lastviewed" ? 'selected="selected"':'');?> value="admin.php?orderBy=lastviewed<?=$pagination_ex_var_li;?>"><?=$LANGUAGE_PACK["admin_home_order_list_last_viewed"];?></option>
						<option <?=($order_by=="counter" ? 'selected="selected"':'');?> value="admin.php?orderBy=counter<?=$pagination_ex_var_li;?>"><?=$LANGUAGE_PACK["admin_home_order_list_viewed"];?></option>
						<option <?=($order_by=="bandwidth" ? 'selected="selected"':'');?> value="admin.php?orderBy=bandwidth<?=$pagination_ex_var_li;?>"><?=$LANGUAGE_PACK["admin_home_order_list_bandwidth_used"];?></option>
						<option <?=($order_by=="gallery" ? 'selected="selected"':'');?> value="admin.php?orderBy=gallery<?=$pagination_ex_var_li;?>"><?=$LANGUAGE_PACK["admin_home_order_list_gallery_clicked"];?></option>
					</select>
				</div>
				<div class="clear"></div>
			</div>
			<table>
				<thead>
				<tr class="odd">
					<th>&nbsp;</th>
					<th class="tooltip" scope="col" abbr="<?=$LANGUAGE_PACK["admin_home_imglist_tt_image_added"];?>"><?=$LANGUAGE_PACK["admin_home_imglist_image_added"];?></th>
					<th class="tooltip" scope="col" abbr="<?=$LANGUAGE_PACK["admin_home_imglist_tt_image_name"];?>"><?=$LANGUAGE_PACK["admin_home_imglist_image_name"];?></th>
					<th class="tooltip" scope="col" abbr="<?=$LANGUAGE_PACK["admin_home_imglist_tt_last_viewed"];?>"><?=$LANGUAGE_PACK["admin_home_imglist_last_viewed"];?></th>
					<th class="tooltip" scope="col" abbr="<?=$LANGUAGE_PACK["admin_home_imglist_tt_gallery_clicks"];?>"><?=$LANGUAGE_PACK["admin_home_imglist_gallery_clicks"];?></th>
					<th class="tooltip" scope="col" abbr="<?=$LANGUAGE_PACK["admin_home_imglist_tt_small_thumb"];?>"><?=$LANGUAGE_PACK["admin_home_imglist_small_thumb"];?></th>
					<th class="tooltip" scope="col" abbr="<?=$LANGUAGE_PACK["admin_home_imglist_tt_thumb"];?>"><?=$LANGUAGE_PACK["admin_home_imglist_thumb"];?></th>
					<th class="tooltip" scope="col" abbr="<?=$LANGUAGE_PACK["admin_home_imglist_tt_original_image"];?>"><?=$LANGUAGE_PACK["admin_home_imglist_original_image"];?></th>
					<th class="tooltip" scope="col" abbr="<?=$LANGUAGE_PACK["admin_home_imglist_tt_bandwidth_used"];?>"><?=$LANGUAGE_PACK["admin_home_imglist_bandwidth_used"];?></th>
					<th class="tooltip" scope="col" abbr="<?=$LANGUAGE_PACK["admin_home_imglist_tt_private"];?>"><?=$LANGUAGE_PACK["admin_home_imglist_private"];?></th>
				</tr>
				</thead>
				<tbody>
					<?=$list_item;?>
				</tbody>
			</table>
			<?=$pagination;?>
			<br/>
<?
	}

// banned page
	if($act == 'ban'){
?>
		<form method="POST" action="admin.php?act=ban" class="ban">
				<h3><?=$LANGUAGE_PACK["admin_ban_form_title"];?></h3>
				<div class="code_box <?=(isset($ERR_PI)?$ERR_PI:'');?>"><label><?=$LANGUAGE_PACK["admin_ban_form_ip"];?> : </label><input class="text_input" type="text" name="banIP" value="<?=(isset($BAN_IP)?$BAN_IP:'');?>" size="20" /></div>
				<div class="code_box"><label><?=$LANGUAGE_PACK["admin_ban_form_reason"];?> : </label><input class="text_input" type="text" name="banDes" value="" size="20" /></div>
				<input class="button button_cen" onclick="" type="submit" value="<?=$LANGUAGE_PACK["admin_ban_form_button"];?>" name="changesettings">
		</form>
		<table class="ban">
			<thead>
			<tr class="odd">
				<th>&nbsp;</th>
				<th class="tooltip" scope="col" abbr="<?=$LANGUAGE_PACK["admin_ban_list_tt_date_banned"];?>"><?=$LANGUAGE_PACK["admin_ban_list_date_banned"];?></th>
				<th class="tooltip" scope="col" abbr="<?=$LANGUAGE_PACK["admin_ban_list_tt_ip"];?>"><?=$LANGUAGE_PACK["admin_ban_list_ip"];?></th>
				<th class="tooltip" scope="col" abbr="<?=$LANGUAGE_PACK["admin_ban_list_tt_reason"];?>"><?=$LANGUAGE_PACK["admin_ban_list_reason"];?></th>
			</tr>
			</thead>
			<tbody>
				<?=(isset($banned_list)?$banned_list:'');?>
			</tbody>
		</table>
<?
	}

// settings page
	if($act == "set"){
?>
			<form method="POST" action="admin.php?act=set">
			<div class="tabs">
				<ul class="tabNavigation">
					<li><a href="#setAdmin"><?=$LANGUAGE_PACK["admin_set_title_admin_setting"];?></a></li>
					<li><a href="#setSite"><?=$LANGUAGE_PACK["admin_set_title_site_setting"];?></a></li>
					<li><a href="#setPage"><?=$LANGUAGE_PACK["admin_set_title_hide_page"];?></a></li>
					<li><a href="#setDeleted"><?=$LANGUAGE_PACK["admin_set_title_auto_deleted"];?></a></li>
					<li><a href="#setUpload"><?=$LANGUAGE_PACK["admin_set_title_upload_setting"];?></a></li>
					<li><a href="#setWatermark"><?=$LANGUAGE_PACK["admin_set_watermark_title"];?></a></li>
					<li><a href="#setShoetUrl"><?=$LANGUAGE_PACK["admin_set_title_url_shortener"];?></a></li>
					<li><a href="#setGoogle"><?=$LANGUAGE_PACK["admin_set_title_google_setting"];?></a></li>
				</ul>
				
				<!--<?=$LANGUAGE_PACK["admin_set_title_admin_setting"];?>-->
				<div id="setAdmin" class="panel">
					<h2><?=$LANGUAGE_PACK["admin_set_title_admin_setting"];?></h2>
					<div class="code_box <?=(isset($ERR_PASS)?$ERR_PASS:'');?>"><label><?=$LANGUAGE_PACK["admin_set_old_password"];?> :</label><input class="text_input" type="password" name="oldPassword" value="" size="20" /></div><br/>
					<div class="code_box <?=(isset($ERR_PASS)?$ERR_PASS:'');?>"><label><?=$LANGUAGE_PACK["admin_set_new_password"];?> :</label><input class="text_input" type="password" name="newPassword" value="" size="20" /></div>
					<div class="code_box <?=(isset($ERR_PASS)?$ERR_PASS:'');?>"><label><?=$LANGUAGE_PACK["admin_set_confirm_new_password"];?> :</label><input class="text_input" type="password" name="newConfirm" value="" size="20" /></div><br/><br/>
					<div class="code_box <?=(isset($ERR_UN)?$ERR_UN:'');?>"><label><?=$LANGUAGE_PACK["admin_set_admin_username"];?> :</label><input class="text_input" type="text" name="setUserName" value="<?=$settings['SET_USERNAME'];?>" size="20" /></div>
					<div class="code_box <?=(isset($ERR_EM)?$ERR_EM:'');?>"><label><?=$LANGUAGE_PACK["admin_set_email_address"];?> :</label><input type="text" name="setEmail" value="<?=$settings['SET_CONTACT'];?>" size="40" class="text_input long"/></div>
					<input class="button button_cen" onclick="" type="submit" value="<?=$LANGUAGE_PACK["admin_set_save_button"];?>" name="changesettings[]">
				</div>

				<!--<?=$LANGUAGE_PACK["admin_set_title_site_setting"];?>-->
				<div id="setSite" class="panel">
					<h2><?=$LANGUAGE_PACK["admin_set_title_site_setting"];?></h2>
					<div class="code_box <?=(isset($ERR_URL)?$ERR_URL:'')?>"><label><?=$LANGUAGE_PACK["admin_set_script_url"];?> :</label><input type="text" name="setScriptUrl" value="<?=$settings['SET_SITEURL'];?>" size="40" class="text_input long"/></div>
					<div class="code_box"><label><?=$LANGUAGE_PACK["admin_set_site_title"];?> :</label><input type="text" name="setTitle" value="<?=$settings['SET_TITLE'];?>" size="40" class="text_input long"/></div>
					<div class="code_box"><label><?=$LANGUAGE_PACK["admin_set_site_slogan"];?> :</label><input type="text" name="setSlogan" value="<?=$settings['SET_SLOGAN'];?>" size="40" class="text_input long"/></div>
					<div class="code_box"><label><?=$LANGUAGE_PACK["admin_set_footer_copyright"];?> :</label><input type="text" name="setCopyright" value="<?=$settings['SET_COPYRIGHT'];?>" size="40" class="text_input long"/></div>
					<div class="code_box"><label><?=$LANGUAGE_PACK["admin_set_site_theme"];?> :</label>
					<select name="setTheme" class="text_input">
						<option value="light" <?=($settings['SET_THEME']=="light" ? 'selected="selected"':'');?>>Light</option>
						<option value="dark" <?=($settings['SET_THEME']=="dark" ? 'selected="selected"':'');?>>Dark</option>
						<option value="sky" <?=($settings['SET_THEME']=="sky" ? 'selected="selected"':'');?>>sky</option>
						<option value="or" <?=($settings['SET_THEME']=="or" ? 'selected="selected"':'');?>>Original</option>
					</select></div>
					<div class="code_box"><label><?=$LANGUAGE_PACK["admin_set_images_per_gallery_page"];?> :</label>
					<select name="setImgOnPage" class="text_input">
						<option value="4" <?=($settings['SET_IMG_ON_PAGE']=="4" ? 'selected="selected"':'');?>>4</option>
						<option value="8" <?=($settings['SET_IMG_ON_PAGE']=="8" ? 'selected="selected"':'');?>>8</option>
						<option value="12" <?=($settings['SET_IMG_ON_PAGE']=="12" ? 'selected="selected"':'');?>>12</option>
						<option value="16" <?=($settings['SET_IMG_ON_PAGE']=="16" ? 'selected="selected"':'');?>>16</option>
						<option value="20" <?=($settings['SET_IMG_ON_PAGE']=="20" ? 'selected="selected"':'');?>>20</option>
						<option value="24" <?=($settings['SET_IMG_ON_PAGE']=="24" ? 'selected="selected"':'');?>>24</option>
					</select></div>
					<div class="code_box"><label><?=$LANGUAGE_PACK["admin_set_mod_rewrite"];?> :</label>
					<select name="setModRewrite" class="text_input">
						<option value="0" <?=(!$settings['SET_MOD_REWRITE'] ? 'selected="selected"':'');?>><?=$LANGUAGE_PACK["admin_set_option_off"];?></option>
						<option value="1" <?=($settings['SET_MOD_REWRITE'] ? 'selected="selected"':'');?>><?=$LANGUAGE_PACK["admin_set_option_on"];?></option>
					</select></div>

					<div class="code_box"><label><?=$LANGUAGE_PACK["admin_set_link_panel_open"];?> :</label>
					<select name="setPanelOpen" class="text_input">
						<option value="0" <?=(!$settings['SET_PANEL_OPEN'] ? 'selected="selected"':'');?>><?=$LANGUAGE_PACK["admin_set_option_off"];?></option>
						<option value="1" <?=($settings['SET_PANEL_OPEN'] ? 'selected="selected"':'');?>><?=$LANGUAGE_PACK["admin_set_option_on"];?></option>
					</select></div>

					<div class="code_box"><label><?=$LANGUAGE_PACK["admin_set_show_image_details"];?> :</label>
					<select name="setImageDetails" class="text_input">
						<option value="0" <?=(!$settings['SET_IMAGE_DETAILS'] ? 'selected="selected"':'');?>><?=$LANGUAGE_PACK["admin_set_option_no"];?></option>
						<option value="1" <?=($settings['SET_IMAGE_DETAILS'] ? 'selected="selected"':'');?>><?=$LANGUAGE_PACK["admin_set_option_yes"];?></option>
					</select></div>
				
					<div class="code_box"><label><?=$LANGUAGE_PACK["admin_set_report_allow"];?> :</label>
					<select name="setAllowReport" class="text_input">
						<option value="0" <?=(!$settings['SET_ALLOW_REPORT'] ? 'selected="selected"':'');?>><?=$LANGUAGE_PACK["admin_set_option_off"];?></option>
						<option value="1" <?=($settings['SET_ALLOW_REPORT'] ? 'selected="selected"':'');?>><?=$LANGUAGE_PACK["admin_set_option_on"];?></option>
					</select></div>
					<div class="code_box"><label><?=$LANGUAGE_PACK["admin_set_report_remove_images"];?> :</label>
					<select name="setRemoveReport" class="text_input">
						<option value="0" <?=(!$settings['SET_REMOVE_REPORT'] ? 'selected="selected"':'');?>><?=$LANGUAGE_PACK["admin_set_option_off"];?></option>
						<option value="1" <?=($settings['SET_REMOVE_REPORT'] ? 'selected="selected"':'');?>><?=$LANGUAGE_PACK["admin_set_option_on"];?></option>
					</select></div>
					<div class="code_box"><label><?=$LANGUAGE_PACK["admin_set_report_Send_email"];?> :</label>
					<select name="setEmailReport" class="text_input">
						<option value="0" <?=(!$settings['SET_EMAIL_REPORT'] ? 'selected="selected"':'');?>><?=$LANGUAGE_PACK["admin_set_option_off"];?></option>
						<option value="1" <?=($settings['SET_EMAIL_REPORT'] ? 'selected="selected"':'');?>><?=$LANGUAGE_PACK["admin_set_option_on"];?></option>
					</select></div>
					<div class="code_box"><label><?=$LANGUAGE_PACK["admin_set_language"];?> :</label>
					<select name="setLanguage" class="text_input">
					<?php
						$dirname = "languages/";
						$dir_list = opendir($dirname);

						while(false != ($file = readdir($dir_list))){
							if(($file != ".") && ($file != "..")){
								$lang_name = explode(".", $file);
								if (end($lang_name) == 'php') 
									echo '<option value="'.$file.'" '.($settings['SET_LANGUAGE']==$file?'selected="selected"':'').'>'.$lang_name[0].'</option>';
							}
						}
					?>
					</select></div>
					<input class="button button_cen" onclick="" type="submit" value="<?=$LANGUAGE_PACK["admin_set_save_button"];?>" name="changesettings[]">
				</div>

				<!--<?=$LANGUAGE_PACK["admin_set_title_hide_page"];?>-->
				<div id="setPage" class="panel">
					<h2><?=$LANGUAGE_PACK["admin_set_title_hide_page"];?></h2>
					<div class="code_box"><label><?=$LANGUAGE_PACK["admin_set_hide_gallery"];?> :</label>
					<select name="setHideGallery" class="text_input">
						<option value="0" <?=(!$settings['SET_HIDE_GALLERY'] ? 'selected="selected"':'');?>><?=$LANGUAGE_PACK["admin_set_option_no"];?></option>
						<option value="1" <?=($settings['SET_HIDE_GALLERY'] ? 'selected="selected"':'');?>><?=$LANGUAGE_PACK["admin_set_option_yes"];?></option>
					</select></div>
					<div class="code_box"><label><?=$LANGUAGE_PACK["admin_set_hide_contact"];?> :</label>
					<select name="setHideContact" class="text_input">
						<option value="0" <?=(!$settings['SET_HIDE_CONTACT'] ? 'selected="selected"':'');?>><?=$LANGUAGE_PACK["admin_set_option_no"];?></option>
						<option value="1" <?=($settings['SET_HIDE_CONTACT'] ? 'selected="selected"':'');?>><?=$LANGUAGE_PACK["admin_set_option_yes"];?></option>
					</select></div>
					<div class="code_box"><label><?=$LANGUAGE_PACK["admin_set_hide_tos"];?> :</label>
					<select name="setHideTos" class="text_input">
						<option value="0" <?=(!$settings['SET_HIDE_TOS'] ? 'selected="selected"':'');?>><?=$LANGUAGE_PACK["admin_set_option_no"];?></option>
						<option value="1" <?=($settings['SET_HIDE_TOS'] ? 'selected="selected"':'');?>><?=$LANGUAGE_PACK["admin_set_option_yes"];?></option>
					</select></div>
					<div class="code_box"><label><?=$LANGUAGE_PACK["admin_set_hide_search"];?> :</label>
					<select name="setHideSearch" class="text_input">
						<option value="0" <?=(!$settings['SET_HIDE_SEARCH'] ? 'selected="selected"':'');?>><?=$LANGUAGE_PACK["admin_set_option_no"];?></option>
						<option value="1" <?=($settings['SET_HIDE_SEARCH'] ? 'selected="selected"':'');?>><?=$LANGUAGE_PACK["admin_set_option_yes"];?></option>
					</select></div>
					<div class="code_box"><label><?=$LANGUAGE_PACK["admin_set_hide_admin_link"];?> :</label>
					<select name="setAdminMenu" class="text_input">
						<option value="0" <?=(!$settings['SET_ADMIN_MENU'] ? 'selected="selected"':'');?>><?=$LANGUAGE_PACK["admin_set_option_no"];?></option>
						<option value="1" <?=($settings['SET_ADMIN_MENU'] ? 'selected="selected"':'');?>><?=$LANGUAGE_PACK["admin_set_option_yes"];?></option>
					</select></div>
					<input class="button button_cen" onclick="" type="submit" value="<?=$LANGUAGE_PACK["admin_set_save_button"];?>" name="changesettings[]">
				</div>

				<!--<?=$LANGUAGE_PACK["admin_set_title_auto_deleted"];?>-->
				<div id="setDeleted" class="panel">
					<h2><?=$LANGUAGE_PACK["admin_set_title_auto_deleted"];?></h2>
					<p class="teaser"><?=$LANGUAGE_PACK["admin_set_des_auto_deleted"];?></p>
					<div class="code_box"><label><?=$LANGUAGE_PACK["admin_set_auto_deleted"];?> :</label>
					<select name="setAutoDeleted" class="text_input">
						<option value="0" <?=(!$settings['SET_AUTO_DELETED'] ? 'selected="selected"':'');?>><?=$LANGUAGE_PACK["admin_set_option_off"];?></option>
						<option value="1" <?=($settings['SET_AUTO_DELETED'] ? 'selected="selected"':'');?>><?=$LANGUAGE_PACK["admin_set_option_on"];?></option>
					</select></div>
					<div class="code_box"><label><?=$LANGUAGE_PACK["admin_set_auto_deleted_for"];?> :</label>
					<select name="setAutoDeletedTime" class="text_input">
						<option value="120" <?=($settings['SET_AUTO_DELETED_TIME'] == 120 ? 'selected="selected"':'');?>>120 <?=$LANGUAGE_PACK["admin_set_auto_deleted_days"];?></option>
						<option value="90" <?=($settings['SET_AUTO_DELETED_TIME'] == 90 ? 'selected="selected"':'');?>>90 <?=$LANGUAGE_PACK["admin_set_auto_deleted_days"];?></option>
						<option value="60" <?=($settings['SET_AUTO_DELETED_TIME'] == 60 ? 'selected="selected"':'');?>>60 <?=$LANGUAGE_PACK["admin_set_auto_deleted_days"];?></option>
						<option value="30" <?=($settings['SET_AUTO_DELETED_TIME'] == 30 ? 'selected="selected"':'');?>>30 <?=$LANGUAGE_PACK["admin_set_auto_deleted_days"];?></option>
					</select></div>
					<div class="code_box"><label><?=$LANGUAGE_PACK["admin_set_run_auto_deleted"];?> :</label>
					<select name="setAutoDeletedJump" class="text_input">
						<option value="m" <?=($settings['SET_AUTO_DELETED_JUMP'] == 'm' ? 'selected="selected"':'');?>><?=$LANGUAGE_PACK["admin_set_run_auto_deleted_Month"];?></option>
						<option value="W" <?=($settings['SET_AUTO_DELETED_JUMP'] == 'W' ? 'selected="selected"':'');?>><?=$LANGUAGE_PACK["admin_set_run_auto_deleted_week"];?></option>
						<option value="z" <?=($settings['SET_AUTO_DELETED_JUMP'] == 'z' ? 'selected="selected"':'');?>><?=$LANGUAGE_PACK["admin_set_run_auto_deleted_day"];?></option>
					</select></div>
					<input class="button button_cen" onclick="" type="submit" value="<?=$LANGUAGE_PACK["admin_set_save_button"];?>" name="changesettings[]">
				</div>

				<!--<?=$LANGUAGE_PACK["admin_set_title_upload_setting"];?>-->
				<div id="setUpload" class="panel">
					<h2><?=$LANGUAGE_PACK["admin_set_title_upload_setting"];?></h2>
					<div class="code_box"><label><?=$LANGUAGE_PACK["admin_set_disable_upload"];?> :</label>
					<select name="setDisUpload" class="text_input">
						<option value="0" <?=(!$settings['SET_DIS_UPLOAD'] ? 'selected="selected"':'');?>><?=$LANGUAGE_PACK["admin_set_option_yes"];?></option>
						<option value="1" <?=($settings['SET_DIS_UPLOAD'] ? 'selected="selected"':'');?>><?=$LANGUAGE_PACK["admin_set_option_no"];?></option>
					</select></div>
					<p class="teaser"><?=$LANGUAGE_PACK["admin_set_image_max_bandwidth_des"];?></p>
					<div class="code_box"><label><?=$LANGUAGE_PACK["admin_set_image_max_bandwidth"];?> :</label><input type="text" name="setMaxBandwidth" value="<?=$settings['SET_MAX_BANDWIDTH'];?>" size="8" class="text_input"/></div>
					<div class="code_box"><label><?=$LANGUAGE_PACK["admin_set_auto_reset_bandwidth"];?> :</label>
					<select name="setBandwidthReset" class="text_input">
						<option value="m" <?=($settings['SET_BANDWIDTH_RESET']=='m' ? 'selected="selected"':'');?>><?=$LANGUAGE_PACK["admin_set_run_auto_deleted_Month"];?></option>
						<option value="W" <?=($settings['SET_BANDWIDTH_RESET']=='W' ? 'selected="selected"':'');?>><?=$LANGUAGE_PACK["admin_set_run_auto_deleted_week"];?></option>
					</select></div>
					<div class="code_box"><label><?=$LANGUAGE_PACK["admin_set_multiple_upload_max"];?> :</label>
					<select name="setMaxUpload" class="text_input">
						<option value="0" <?=($settings['SET_MAX_UPLOAD']==0 ? 'selected="selected"':'');?>>none</option>
						<option value="5" <?=($settings['SET_MAX_UPLOAD']==5 ? 'selected="selected"':'');?>>5</option>
						<option value="10" <?=($settings['SET_MAXSIZE']==10 ? 'selected="selected"':'');?>>10</option>
					</select>
					</div>
					<div class="code_box"><label><?=$LANGUAGE_PACK["admin_set_max_upload_file_size"];?> :</label>
					<select name="setMaxSize" class="text_input">
						<option value="256000" <?=($settings['SET_MAXSIZE']=="256000" ? 'selected="selected"':'');?>>250 kb</option>
						<option value="512000" <?=($settings['SET_MAXSIZE']=="512000" ? 'selected="selected"':'');?>>500 kb</option>
						<option value="1048576" <?=($settings['SET_MAXSIZE']=="1048576" ? 'selected="selected"':'');?>>1 mb</option>
						<option value="2097152" <?=($settings['SET_MAXSIZE']=="2097152" ? 'selected="selected"':'');?>>2 mb</option>
						<option value="5242880" <?=($settings['SET_MAXSIZE']=="5242880" ? 'selected="selected"':'');?>>5 mb</option>
						<option value="10485760" <?=($settings['SET_MAXSIZE']=="10485760" ? 'selected="selected"':'');?>>10 mb</option>
					</select>
					</div>
					<div class="code_box"><label><?=$LANGUAGE_PACK["admin_set_private_image_upload"];?> :</label>
					<select name="setPrivateImg" class="text_input">
						<option value="0" <?=(!$settings['SET_PRIVATE_IMG_ON'] ? 'selected="selected"':'');?>><?=$LANGUAGE_PACK["admin_set_option_off"];?></option>
						<option value="1" <?=($settings['SET_PRIVATE_IMG_ON'] ? 'selected="selected"':'');?>><?=$LANGUAGE_PACK["admin_set_option_on"];?></option>
					</select></div>
					<input class="button button_cen" onclick="" type="submit" value="<?=$LANGUAGE_PACK["admin_set_save_button"];?>" name="changesettings[]">
				</div>

				<!--<?=$LANGUAGE_PACK["admin_set_watermark_title"];?>-->
				<div id="setWatermark" class="panel">
					<h2><?=$LANGUAGE_PACK["admin_set_watermark_title"];?></h2>
					<p class="teaser"><?=$LANGUAGE_PACK["admin_set_watermark_des"];?></p>
					<div class="code_box"><label><?=$LANGUAGE_PACK["admin_set_watermark_title"];?> :</label>
					<select name="setWaterMark" class="text_input">
						<option value="0" <?=(!$settings['SET_WATERMARK'] ? 'selected="selected"':'');?>><?=$LANGUAGE_PACK["admin_set_option_off"];?></option>
						<option value="1" <?=($settings['SET_WATERMARK'] ? 'selected="selected"':'');?>><?=$LANGUAGE_PACK["admin_set_option_on"];?></option>
					</select></div>
					<div class="code_box"><label><?=$LANGUAGE_PACK["admin_set_watermark_text"];?> :</label><input type="text" name="setWatermarkText" value="<?=$settings['SET_WATERMARK_TEXT'];?>" size="40" class="text_input medium-input"/></div>
					<div class="code_box"><label><?=$LANGUAGE_PACK["admin_set_watermark_position"];?> :</label>
					<select name="setWatermarkPlaced" class="text_input">
						<option value="0" <?=(!$settings['SET_WATERMARK_PLACED'] ? 'selected="selected"':'');?>><?=$LANGUAGE_PACK["admin_set_watermark_top"];?></option>
						<option value="1" <?=($settings['SET_WATERMARK_PLACED'] ? 'selected="selected"':'');?>><?=$LANGUAGE_PACK["admin_set_watermark_bottom"];?></option>
					</select></div>
					<input class="button button_cen" type="submit" value="<?=$LANGUAGE_PACK["admin_set_save_button"];?>" name="changesettings[]">
				</div>

				<!--<?=$LANGUAGE_PACK["admin_set_title_url_shortener"];?>-->
				<div id="setShoetUrl" class="panel">
					<h2><?=$LANGUAGE_PACK["admin_set_title_url_shortener"];?></h2>
					<div class="code_box"><label><?=$LANGUAGE_PACK["admin_set_url_shortener"];?> :</label>
					<select name="setShortUrl" id='setShortUrl' class="text_input">
						<option value="0" <?=(!$settings['SET_SHORT_URL_ON'] ? 'selected="selected"':'');?>><?=$LANGUAGE_PACK["admin_set_option_off"];?></option>
						<option value="1" <?=($settings['SET_SHORT_URL_ON'] ? 'selected="selected"':'');?>><?=$LANGUAGE_PACK["admin_set_option_on"];?></option>
					</select></div>
					<div id="surl_op">
						<div id="url_list" class="code_box"><label><?=$LANGUAGE_PACK["admin_set_url_short_service"];?> :</label>
						<select name="setSUrlApi" id="setSUrlApi" class="text_input">
							<option value="b54"		<?=($settings['SET_SHORT_URL_API'] == 'b54'		? 'selected="selected"':'');?>>B54.in</option>
							<option value="yourls"	<?=($settings['SET_SHORT_URL_API'] == 'yourls'	? 'selected="selected"':'');?>>yourls</option>
							<option value="bitly"	<?=($settings['SET_SHORT_URL_API'] == 'bitly'	? 'selected="selected"':'');?>>bit.ly</option>
							<option value="tinyurl" <?=($settings['SET_SHORT_URL_API'] == 'tinyurl'	? 'selected="selected"':'');?>>tinyurl.com</option>
							<option value="isgd"	<?=($settings['SET_SHORT_URL_API'] == 'isgd'	? 'selected="selected"':'');?>>is.gd</option>
						</select></div>

						<div id="url_api" class="code_box"><label><?=$LANGUAGE_PACK["admin_set_url_short_api_url"];?> :</label>
							<input type="text" name="setSUrlApiUrl" value="<?=$settings['SET_SHORT_URL_API_URL'];?>" size="8" class="text_input"/></div>
						<div id="url_user" class="code_box"><label><?=$LANGUAGE_PACK["admin_set_url_short_api_username"];?> :</label>
							<input type="text" name="setSUrlApiUesr" value="<?=$settings['SET_SHORT_URL_USER'];?>" size="8" class="text_input"/></div>
						<div id="url_pass" class="code_box"><label><?=$LANGUAGE_PACK["admin_set_url_short_api_password"];?> :</label>
							<input type="text" name="setSUrlApiPass" value="<?=$settings['SET_SHORT_URL_PASS'];?>" size="8" class="text_input"/></div>
					</div>
					<input class="button button_cen" onclick="" type="submit" value="<?=$LANGUAGE_PACK["admin_set_save_button"];?>" name="changesettings[]">
				</div>

				<!--<?=$LANGUAGE_PACK["admin_set_title_google_setting"];?>-->
				<div id="setGoogle" class="panel">
					<h2><?=$LANGUAGE_PACK["admin_set_title_google_setting"];?></h2>
					<p class="teaser"><?=$LANGUAGE_PACK["admin_set_google_setting_des"];?></p>
					<div class="code_box"><label><?=$LANGUAGE_PACK["admin_set_google_analytics_code"];?> :</label><input type="text" name="setAnalytics" value="<?=$settings['SET_GOOGLE_ANALYTICS'];?>" size="40" class="text_input medium-input"/></div>
					<div class="code_box"><label><?=$LANGUAGE_PACK["admin_set_google_adsense_code"];?> :</label><input type="text" name="setGoogleAds" value="<?=$settings['SET_GOOGLE_ADS'];?>" size="40" class="text_input medium-input"/></div>
					<input class="button button_cen" type="submit" value="<?=$LANGUAGE_PACK["admin_set_save_button"];?>" name="changesettings[]">
				</div>
			</div>
			</form>
<?
	} // end set

}else{// NOT LOGGED IN PAGES
	if (!$reset_password){// LOGIN PAGE
?>

	<form id="login-form" action="admin.php" method="POST">
			<div class="code_box"><label for="UserName"><?=$LANGUAGE_PACK["admin_login_username"];?></label><input type="text" id="userName" name="userName" class="text_input"/></div>
			<div class="code_box"><label for="password"><?=$LANGUAGE_PACK["admin_login_password"];?></label><input type="password" id="passWord" name="passWord" class="text_input"/></div>
			<a href="admin.php?forgot" title="<?=$LANGUAGE_PACK["admin_forgot_password_login_link"];?>" rel="nofollow" class="button_cen"><?=$LANGUAGE_PACK["admin_forgot_password_login_link"];?></a><br/>
			<input type="submit" class="button button_cen" name="enter" value="<?=$LANGUAGE_PACK["admin_login_button"];?>"/><br/>
			<input type="hidden" name="action" value="login" style="display: none;">
	</form>

<?
	}// END LOGIN
	else
	{// RESET PASSWORD
?>
		<h2 class="title"><?=$LANGUAGE_PACK["admin_forgot_password_title"];?></h2>
		<p><?=$LANGUAGE_PACK["admin_forgot_password_paragraph"];?></p>
		<form id="reset-form" action="admin.php" method="POST">
			<div class="code_box"><label><?=$LANGUAGE_PACK["admin_set_new_password"];?> :</label><input class="text_input" type="password" name="newPassword" value="" size="20" /></div>
			<div class="code_box"><label><?=$LANGUAGE_PACK["admin_set_confirm_new_password"];?> :</label><input class="text_input" type="password" name="newConfirm" value="" size="20" /></div><br/>
			<input type="submit" class="button button_cen" name="enter" value="<?=$LANGUAGE_PACK["admin_set_save_button"];?>"/><br/>
			<input type="hidden" name="action" value="reset" style="display: none;">
	</form>
<?
	}// END RESET PASSWORD
} // END NOT LOGGED IN PAGES
?>
		<div class="clear"></div>
	</div>
	<div id="footer">
		<p><?=$settings['SET_COPYRIGHT'];?>
		<div class="sp"></div>
		<p>Powered By <a href="http://codefuture.co.uk/projects/imagehost/" title="Free PHP Image Hosting Script">CF Image Hosting script</a> | Design By <a href="http://codefuture.co.uk" title="codefuture.co.uk - online webmaster tools,code Generators">Codefuture.co.uk</a></p>
	</div>
</div>
</body>
</html>
<?
// MAKE PAGE END
////////////////////////////////////////////////////////////////////////////////////
?>