<?
//
//   CF Image Hosting Script v1.3.8
//   -------------------------------
//
//   Author:    codefuture.co.uk
//   Version:   1.3.8
//   Date:      14-Aug-10
//
//   download the latest version from - http://codefuture.co.uk/projects/imagehost1.3/
//
//   Copyright (c) 2010 codefuture.co.uk
//   This file is part of the CF Image Hosting Script.
//
//   CF Image Hosting Script is free software: you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation, either version 3 of the License, or
//   (at your option) any later version.
//
//   CF Image Hosting Script is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//   You should have received a copy of the GNU General Public License
//   along with CF Image Hosting Script.  If not, see http://www.gnu.org/licenses/.
//
////////////////////////////////////////////////////////////////////////////////////

// stop the nav to install.php
	if (basename($_SERVER['PHP_SELF']) == 'install.php'){
		header('Location: index.php');
		exit();
	}

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<title>CF Image Hosting Installer</title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<link rel="stylesheet" href="css/admin.css" type="text/css" />
</head>
<body>
<div id="wrap">
	<div id="header" class="clear"><div id="logo"><h1>CF Image Hosting Installer</h1></div><div class="clear"></div></div>
	<div id="content">
<?
	$SET_VERSION ='1.3.8';

	$Err_found	= false;
	$path		= dirname( __FILE__ ).'/';

	if(rmkdir($path.$DIR_UPLOAD,FALSE)){
		rmkdir($path.$DIR_IMAGE);
		rmkdir($path.$DIR_THUMB_MID);
		rmkdir($path.$DIR_THUMB);
		if(rmkdir($path.$DIR_DATA,FALSE)){

			if(!isset($settings['SET_VERSION']) || $settings['SET_VERSION']< 1.3){
				if (file_exists($ADD_DB_COUNT))
					@unlink($ADD_DB_COUNT);

				save_file($ADD_DB_COUNT);

				if (file_exists($ADD_DB_BAN))
					save_file($ADD_DB_BAN);

				$self = $_SERVER['PHP_SELF'];
				$script_url = 'http://'.$_SERVER['HTTP_HOST'].mb_substr($self,0,-mb_strlen(strrchr($self,"/")));
				if(substr($script_url, -1) == "/") $script_url = substr($script_url, 0, -1);

				$salting = md5(time().rand(0,14));
			}

			$mod_rewrite = is_mod_rewrite_enabled((isset($script_url)?$script_url:$settings['SET_SITEURL']));

			$content = array(
							'SET_PASSWORD'			=>(isset($settings['SET_PASSWORD'])?$settings['SET_PASSWORD']:md5(md5('password').$salting)),
							'SET_USERNAME'			=>(isset($settings['SET_USERNAME'])?$settings['SET_USERNAME']:'admin'),
							'SET_CONTACT'			=>(isset($settings['SET_CONTACT'])?$settings['SET_CONTACT']:'your@email.com'),
							'SET_SITEURL'			=>(isset($settings['SET_SITEURL'])?$settings['SET_SITEURL']:$script_url),
							'SET_TITLE'				=>(isset($settings['SET_TITLE'])?$settings['SET_TITLE']:'CF Image Host'),
							'SET_SLOGAN'			=>(isset($settings['SET_SLOGAN'])?$settings['SET_SLOGAN']:'Free CF Image Host'),
							'SET_MAXSIZE'			=>(isset($settings['SET_MAXSIZE'])?$settings['SET_MAXSIZE']:'1048576'),
							'SET_IMG_ON_PAGE'		=>(isset($settings['SET_IMG_ON_PAGE'])?$settings['SET_IMG_ON_PAGE']:8),
							'SET_COPYRIGHT'			=>(isset($settings['SET_COPYRIGHT'])?$settings['SET_COPYRIGHT']:'Copyright &copy; - All Rights Reserved.'),
							'SET_THEME'				=>(isset($settings['SET_THEME'])?$settings['SET_THEME']:'original'),
							'SET_SALTING'			=>(isset($settings['SET_SALTING'])?$settings['SET_SALTING']:$salting),
							'SET_MOD_REWRITE'		=>(isset($settings['SET_MOD_REWRITE'])?$settings['SET_MOD_REWRITE']:$mod_rewrite),
							'SET_ADMIN_MENU'		=>(isset($settings['SET_ADMIN_MENU'])?$settings['SET_ADMIN_MENU']:FALSE),
							//1.2
							'SET_MAX_BANDWIDTH'		=>(isset($settings['SET_MAX_BANDWIDTH'])?$settings['SET_MAX_BANDWIDTH']:1024),
							'SET_VERSION'			=>$SET_VERSION,
							'SET_GOOGLE_ANALYTICS'	=>(isset($settings['SET_GOOGLE_ANALYTICS'])?$settings['SET_GOOGLE_ANALYTICS']:''),
							'SET_BANDWIDTH_RESET'	=>(isset($settings['SET_BANDWIDTH_RESET'])?$settings['SET_BANDWIDTH_RESET']:'m'),
							'SET_MAX_UPLOAD'		=>(isset($settings['SET_MAX_UPLOAD'])?$settings['SET_MAX_UPLOAD']:5),
							'SET_HIDE_SEARCH'		=>(isset($settings['SET_HIDE_SEARCH'])?$settings['SET_HIDE_SEARCH']:FALSE),
							'SET_GOOGLE_ADS'		=>(isset($settings['SET_GOOGLE_ADS'])?$settings['SET_GOOGLE_ADS']:''),
							'SET_AUTO_DELETED'		=>(isset($settings['SET_AUTO_DELETED'])?$settings['SET_AUTO_DELETED']:FALSE),
							'SET_AUTO_DELETED_TIME'	=>(isset($settings['SET_AUTO_DELETED_TIME'])?$settings['SET_AUTO_DELETED_TIME']:'60'),
							'SET_AUTO_DELETED_JUMP'	=>(isset($settings['SET_AUTO_DELETED_JUMP'])?$settings['SET_AUTO_DELETED_JUMP']:'m'),
							'SET_HIDE_CONTACT'		=>(isset($settings['SET_HIDE_CONTACT'])?$settings['SET_HIDE_CONTACT']:FALSE),
							'SET_HIDE_TOS'			=>(isset($settings['SET_HIDE_TOS'])?$settings['SET_HIDE_TOS']:FALSE),
							'SET_HIDE_GALLERY'		=>(isset($settings['SET_HIDE_GALLERY'])?$settings['SET_HIDE_GALLERY']:FALSE),
							//new 1.3
							'SET_EMAIL_REPORT'		=>(isset($settings['SET_EMAIL_REPORT'])?$settings['SET_EMAIL_REPORT']:FALSE),
							'SET_ALLOW_REPORT'		=>(isset($settings['SET_ALLOW_REPORT'])?$settings['SET_ALLOW_REPORT']:TRUE),
							'SET_REMOVE_REPORT'		=>(isset($settings['SET_REMOVE_REPORT'])?$settings['SET_REMOVE_REPORT']:FALSE),
							'SET_SHORT_URL_ON'		=>(isset($settings['SET_SHORT_URL_ON'])?$settings['SET_SHORT_URL_ON']:FALSE),
							'SET_PRIVATE_IMG_ON'	=>(isset($settings['SET_PRIVATE_IMG_ON'])?$settings['SET_PRIVATE_IMG_ON']:TRUE),
							'SET_DIS_UPLOAD'		=>(isset($settings['SET_DIS_UPLOAD'])?$settings['SET_DIS_UPLOAD']:TRUE),
							'SET_PANEL_OPEN'		=>(isset($settings['SET_PANEL_OPEN'])?$settings['SET_PANEL_OPEN']:FALSE),
							//1.3.7
							'SET_IMAGE_DETAILS'		=>(isset($settings['SET_IMAGE_DETAILS'])?$settings['SET_IMAGE_DETAILS']:TRUE),
							'SET_SHORT_URL_API'		=>(isset($settings['SET_SHORT_URL_API'])?$settings['SET_SHORT_URL_API']:'b54'),
							'SET_SHORT_URL_API_URL'	=>(isset($settings['SET_SHORT_URL_API_URL'])?$settings['SET_SHORT_URL_API_URL']:''),
							'SET_SHORT_URL_PASS'	=>(isset($settings['SET_SHORT_URL_PASS'])?$settings['SET_SHORT_URL_PASS']:''),
							'SET_SHORT_URL_USER'	=>(isset($settings['SET_SHORT_URL_USER'])?$settings['SET_SHORT_URL_USER']:''),
							//1.3.8
							'SET_WATERMARK'			=>(isset($settings['SET_WATERMARK'	])?$settings['SET_WATERMARK'	]:FALSE),
							'SET_WATERMARK_TEXT'	=>(isset($settings['SET_WATERMARK_TEXT'])?$settings['SET_WATERMARK_TEXT']:''),
							'SET_WATERMARK_PLACED'	=>(isset($settings['SET_WATERMARK_PLACED'])?$settings['SET_WATERMARK_PLACED']:FALSE),
						);
			$setting_db->set_db($content);
			if(!$setting_db->save_db_now()){
				error_note(array('Error Making \''.$ADD_DB_SET.'\' file!<br/>'));
				$Err_found = true;
			}

		// update image db
			if (file_exists($ADD_DB_IMG)){
				$db = new array_db($ADD_DB_IMG);
				if($db->db_not_empty()){
					$img_db = $db->fetch_all();
					foreach ($img_db as $k => $v){
					// updating from below v1.2
						if(!isset($img_db[$k]['thumbsize'])){
							$THUMB_ADDRESS = $DIR_THUMB.$v['id'].'.png';
							$THUMB_MID_ADDRESS =  $DIR_THUMB_MID.$v['id'].'.png';
							$img_db[$k]['thumbsize'] = @filesize($THUMB_MID_ADDRESS);
							$img_db[$k]['sthumbsize']= @filesize($THUMB_ADDRESS);
						}
					//updating from below v1.3
						if(!isset($img_db[$k]['shorturl'])){
							$img_db[$k]['shorturl'] = null;
						}
					}
					$db->set_db($img_db);
					$db->save_db_now();
				}
			}

		}//data folder

	}else{// erroy making upload folder
		$Err_found = true;
	}

	if(!$Err_found)success_note(array('Install/update!<br/> please delete <b>install.php</b> file from your server.'));

?>
		<div class="clear"></div>
	</div>
	<div id="footer">
		<div class="sp"></div>
		<p>Powered By <a href="http://codefuture.co.uk/projects/imagehost/">CF Image Hosting script <?=$SET_VERSION;?></a> | Design By <a href="http://codefuture.co.uk">Codefuture</a></p>
	</div>
</div>
<?

	exit();
function file_nw($path){
	error_note(array('File Exists but Not writable<br />
		Please make sure PHP scripts can write to the <b>'.$path.'</b> file.
		On Linux servers CHMOD this file to 666 (rw-rw-rw-).<br/>Then reload this page.'));
}

function file_nc($path){
	error_note(array('Can not create a File<br />
		Please make a file named <b>'.basename($path).'</b> in <b>'.$path.'</b> .
		and please make sure that PHP scripts can write to the file.
		On Linux servers CHMOD this file to 666 (rw-rw-rw-).<br/>Then reload this page.'));
}

function folder_nw($path){
	error_note(array('Folder Exists but Not writable<br />
		Please make sure PHP scripts can write to the <b>'.$path.'</b> folder.
		On Linux servers CHMOD this file to 777 (rwxrwxrwx).<br/>Then reload this page.'));
}
function folder_nc($path){
	error_note(array('Can not create a folder.<br />
        Please make sure a folder called <b>'.$path.'</b> exists on your server
        and that PHP scripts have permission to write to it.
        On Linux servers CHMOD this folder to 777 (rwxrwxrwx).<br/>Then reload this page.'));
}

function make_mod($url){
	global $Err_found,$path;

	$mod_rewrite =	'<IfModule mod_rewrite.c>
# Tell PHP that the mod_rewrite module is ENABLED.
	SetEnv HTTP_MOD_REWRITE On
	Options +FollowSymLinks
	RewriteEngine on
	RewriteRule test-(.*)\.htm$ '.$url.'inc/tesmodrewite.php?q=test_$1
	RewriteRule pm-(.*)\.(jpg|png|gif|html)$ '.$url.'index.php?pm=$1
	RewriteRule pt-(.*)\.(jpg|png|gif|html)$ '.$url.'index.php?pt=$1
	RewriteRule dt-(.*)\.(jpg|png|gif)$ '.$url.'index.php?dt=$1
	RewriteRule dm-(.*)\.(jpg|png|gif)$ '.$url.'index.php?dm=$1
	RewriteRule di-(.*)\.(jpg|jpeg|png|gif|bmp)$ '.$url.'index.php?di=$1
	RewriteRule page(.*)\.html$ '.$url.'gallery.php?p=$1
</IfModule>';

	$filename = $path.'/.htaccess';
	if (is_writable($filename)||!file_exists($filename)) {
		if (!$handle = @fopen($filename, 'w+')){
			file_nw($filename);
			$Err_found = true;
			return true;
		}
		if (fwrite($handle, $mod_rewrite) === FALSE){
			file_nw($filename);
			$Err_found = true;
			return true;
		}
		fclose($handle);
		return false;
	} else {
		file_nw($filename);
		$Err_found = true;
		return true;
	}
}



function is_mod_rewrite_enabled($path) {
/*
	if (@$_SERVER['HTTP_MOD_REWRITE'] == 'On')
		return true;
*/
	$content = @file_get_contents($path.'/test-mod_rewrite.htm');
	if ( substr($content,0,29) == 'Current URL: test_mod_rewrite'){
		make_mod('');
		return true;
	}else{
		$content = @file_get_contents($path.'/test2-mod_rewrite.htm');
		if ( substr($content,0,29) == 'Current URL: test_mod_rewrite'){
			make_mod('/');
			return true;
		}else{
			return false;
		}
	}
}

function save_file($fileaddress){
	global $Err_found;
	if(file_exists($fileaddress)){
		if( @file_perms($fileaddress) != 666 &&
			@file_perms($fileaddress) != 664 &&
			@file_perms($fileaddress) != 644){
			file_nw($fileaddress);
		}else{
			return true;
		}
	}
	if(!$fp = @fopen($fileaddress, 'w+')){
		file_nc($fileaddress);
		$Err_found = true;
		return false;
	}
	if (fwrite($fp, serialize(array())) === false) {
		file_nw($fileaddress);
		$Err_found = true;
		return false;
	}
	fclose($fp);
	return true;
}

function rmkdir($folder,$writable = true) {
	global $Err_found;
	if(@is_dir($folder)){
		if (@file_perms($folder) != 755 &&
			@file_perms($folder) != 775 &&
			@file_perms($folder) != 777 &&
			$writable){
			@folder_nw($folder);
			$Err_found = true;
			return false;
		}
		return true;
	}
	folder_nc($folder);
	$Err_found = true;
	return false;
}

function file_perms($file){
	if(!file_exists($file)) return false;
	$perms = fileperms($file);
	return substr(decoct($perms), -3);
}


?>