<?php
//
//   CF Image Hosting Script v1.3.8
//   -------------------------------
//
//   Author:    codefuture.co.uk
//   Version:   1.3.8
//   Date:      14-Aug-10
//
//   download the latest version from - http://codefuture.co.uk/projects/imagehost1.3/
//
//   Copyright (c) 2010 codefuture.co.uk
//   This file is part of the CF Image Hosting Script.
//
//   CF Image Hosting Script is free software: you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation, either version 3 of the License, or
//   (at your option) any later version.
//
//   CF Image Hosting Script is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//   You should have received a copy of the GNU General Public License
//   along with CF Image Hosting Script.  If not, see http://www.gnu.org/licenses/.
//
////////////////////////////////////////////////////////////////////////////////////

	include_once('inc/config.php');

	if(!$settings['SET_DIS_UPLOAD'] && !checklogin()){
		header('Location: index.php');
		exit();
	}

////////////////////////////////////////////////////////////////////////////////////
// UPLOAD CODE START

// see if user is banned
	$db_ban = new array_db($ADD_DB_BAN);
	$BANNED_USER = false;
	if ($db_ban->item_exists('ip',$_SERVER['REMOTE_ADDR'])){
		$Err['upload_ban'] = $LANGUAGE_PACK["site_upload_banned"];
		$BANNED_USER = true;
	}

// Download images from remote server to temp folder
	if(isset($_POST['imgUrl']) && input($_POST['imgUrl']) != ''){
		$fp = @fopen($_POST['imgUrl'], 'r');
		if($fp){
		// connection was made to server at domain example.com
			fclose($fp);
			$_FILES = handle_url($_POST['imgUrl'],$DIR_TEMP);
		}else{
			$Err['remote_server'] = 'That file does not exist.';
		}
	}

	if(	$_SERVER['REQUEST_METHOD'] == 'POST' &&
		$_FILES['file']['name'][0] !='' && 
		!$BANNED_USER){

		include("lib/resize.class.php");
		$img_posted ='';

		for($i=0; $i < count($_FILES['file']['name']);$i++){

			$file_name		= $_FILES['file']['name'][$i];
			$file_tmp_name	= $_FILES['file']['tmp_name'][$i];
			$file_size		= $_FILES['file']['size'][$i];
			$file_type		= strtolower($_FILES['file']['type'][$i]);
			$get_img 		= @getimagesize($file_tmp_name);
			$path_info		= pathinfo($file_name);
			$err_get_img	= false;

		//min size(pixels)
			if ($get_img[0] < $IMG_MIN_SIZE ||
				$get_img[1] < $IMG_MIN_SIZE ){
				$err_get_img = true;
				$Err['image_size'] = sprintf($LANGUAGE_PACK["site_upload_to_small"],$IMG_MIN_SIZE.'x'.$IMG_MIN_SIZE).'<br/>';
			}

		// max size(pixels)
			if ($get_img[0] > $IMG_MAX_SIZE ||
				$get_img[1] > $IMG_MAX_SIZE ){
				$err_get_img = true;
				$Err['image_size'] = sprintf($LANGUAGE_PACK["site_upload_to_big"],$IMG_MAX_SIZE.'x'.$IMG_MAX_SIZE).'<br/>';
			}

		//Check file size (kb)
			if($file_size >= $settings['SET_MAXSIZE']) {
				$err_get_img = true;
				$Err['image_size_kb'] = sprintf($LANGUAGE_PACK["site_upload_size_accepted"],format_size($settings['SET_MAXSIZE'])).'<br/>';
			}

		//check file type
			if (!isset($path_info['extension']) ||
				!(in_array(strtolower($path_info['extension']), $accepted)) ||
				!(in_array($file_type, $acceptedtyp))){
				$err_get_img = true;
				$Err['image_type'] = sprintf($LANGUAGE_PACK["site_upload_types_accepted"],$types).'<br/>'; // bebug file type strtolower($_FILES["file"]["type"])
			}

			if(!$err_get_img) {
		
			//new random name
				$newname = rand(0,16).time().rand(0,16);

			//random delete ID
				$delete_id = md5(rand(0,7).rand(0,7).time().rand(0,14));

			//Image address
				$IMG_NAME = $newname.'.'.strtolower($path_info['extension']);
				$IMG_ADDRESS = $DIR_IMAGE.$IMG_NAME;

			//Thumb address
				$THUMB_NAME = $newname.'.'.$THUMB_SAVE_EXT;
				$THUMB_ADDRESS = $DIR_THUMB.$THUMB_NAME;
				$THUMB_MID_ADDRESS = $DIR_THUMB_MID.$THUMB_NAME;

			//Move image
				$IMG_MOVED = false;
			//move image from remote server
				if(isset($_POST['imgUrl']) && input($_POST['imgUrl']) != ''){
					@copy($file_tmp_name,$IMG_ADDRESS);
					@unlink($file_tmp_name);
					$IMG_MOVED = true;
				}
			//move uploaded image
				elseif (move_uploaded_file($file_tmp_name,$IMG_ADDRESS)){
					@unlink($file_tmp_name);
					$IMG_MOVED = true;
				}

			//Attempt to move the uploaded file to the upload folder
				if ($IMG_MOVED) {

				// thumb
					$resizeObj = new resize($IMG_ADDRESS);
				// make thumb
					$resizeObj -> resizeImage($THUMB_MID_MAX_WIDTH, $THUMB_MID_MAX_HEIGHT, $THUMB_MID_OPTION);
					$resizeObj -> imageSaveQuality($THUMB_MID_QUALITY);
					$resizeObj -> saveImage($THUMB_MID_ADDRESS);
				// make small thumb
					$resizeObj -> resizeImage($THUMB_MAX_WIDTH, $THUMB_MAX_HEIGHT, $THUMB_OPTION);
					$resizeObj -> imageSaveQuality($THUMB_QUALITY);
					$resizeObj -> saveImage($THUMB_ADDRESS, $THUMB_QUALITY);

					if(file_exists($THUMB_ADDRESS) && file_exists($THUMB_MID_ADDRESS)){

						// alt text
						$alt = empty($_POST["alt"][$i]) ? $path_info['filename']:removeSymbols(input($_POST["alt"][$i]));

						if (isset($_POST['shorturl']) && $_POST['shorturl'] == 1 && $settings['SET_SHORT_URL_ON']){
							$shorturl = shorturl_url('http://'.$_SERVER['HTTP_HOST'].preg_replace('/\/([^\/]+?)$/', '/', $_SERVER['PHP_SELF']).'?di='.$newname);
						}else{
							$shorturl = null;
						}

					// save image info to db
						$NEW_IMG_ITEM = array(	'id'		=> $newname,
												'name'		=> $file_name,
												'alt'		=> $alt,
												'added'		=> time(),
												'ext'		=> strtolower($path_info['extension']),
												'ip'		=> $_SERVER['REMOTE_ADDR'],
												'size'		=> $file_size,
												'deleteid'	=> $delete_id,
												'thumbsize' => @filesize($THUMB_MID_ADDRESS),
												'sthumbsize'=> @filesize($THUMB_ADDRESS),
												'private'	=> (isset($_POST['private'])?1:0),
												'shorturl'	=> $shorturl,
												'dimensions_x' =>$get_img[0],
												'dimensions_y' =>$get_img[1],
												);

						$db = new array_db($ADD_DB_IMG);
						if($db->add_row($NEW_IMG_ITEM) && $db->save_db_now()){

								// Page var
									$linkurl		= get_thumb_address($newname,"pt");
									$thumb_url		= get_thumb_address($newname,"dt");
									$thumb_mid_link	= get_thumb_mid_address($newname,"pm");
									$thumb_mid_url	= get_thumb_mid_address($newname,"dm");
									$imgurl			= 'http://'.$_SERVER['HTTP_HOST'].preg_replace('/\/([^\/]+?)$/', '/', $_SERVER['PHP_SELF']).'?di='.$newname;
									$bookmarking	= bookmarking(($shorturl !=null?$shorturl:$thumb_mid_link),$alt);
									$open_panel		= ($settings['SET_PANEL_OPEN'] ? ' open':'');

								// Page output
									$img_posted .= '<div class="img_ad_box">';
								// AdSense
									if($settings['SET_GOOGLE_ADS'] !=''){
										$img_posted .= '<div class="thumb_Ad">'.$thumb_AdSense.'</div>';
									}
									$img_posted .= '<div class="img_box'.($settings['SET_GOOGLE_ADS'] !=''?' left':'').'"><a href="'.$imgurl.'" title="'.$alt.'" ><img src="'.$thumb_mid_url.'" alt="'.$alt.'" /><br/><span>'.$alt.'</span></a></div>
											<div style="clear: both;"></div>
										</div>';
								// Image Links
									$img_posted .= '
										<div class="flip">'.$LANGUAGE_PACK["site_index_hide_link"].'</div>
										<div class="panel'.$open_panel.'">
										<div class="code_box"><label id="toplabel">'.$LANGUAGE_PACK["site_index_social_networks"].':</label>'.$bookmarking.'</div>';
									if ($shorturl != null && !empty($shorturl)){
										$img_posted 	.= '
										<div class="code_box"><label for="shorturl">'.$LANGUAGE_PACK["site_index_short_url_link"].':</label> <input type="text" id="codehtml" value="'.$shorturl.'" onclick="javascript:this.focus();this.select();" readonly="true" class="text_input long" /></div>';
									}
									$img_posted 	.= '
									<h3>'.$LANGUAGE_PACK["site_index_small_thumbnail_link"].'</h3>
											<div class="code_box"><label for="codelbb">'.$LANGUAGE_PACK["site_index_bbcode"].':</label> <input type="text" id="codelbb" value="[URL='.$linkurl.'][IMG]'.$thumb_url.'[/IMG][/URL]" onclick="javascript:this.focus();this.select();" readonly="true" class="text_input long" /></div>
											<div class="code_box"><label for="codehtml"><a href="'.$linkurl.'" title="'.$alt.'" >'.$LANGUAGE_PACK["site_index_html_code"].'</a>:</label> <input type="text" id="codehtml" value=\'&lt;a href="'.$linkurl.'" title="'.$alt.'" &gt;&lt;img src="'.$thumb_url.'" alt="'.$alt.'" /&gt;&lt/a&gt;\' onclick="javascript:this.focus();this.select();" readonly="true" class="text_input long" /></div>
										<h3>'.$LANGUAGE_PACK["site_index_thumbnail_link"].'</h3>
											<div class="code_box"><label for="codelbb">'.$LANGUAGE_PACK["site_index_bbcode"].':</label> <input type="text" id="codelbb" value="[URL='.$thumb_mid_link.'][IMG]'.$thumb_mid_url.'[/IMG][/URL]" onclick="javascript:this.focus();this.select();" readonly="true" class="text_input long" /></div>
											<div class="code_box"><label for="codehtml"><a href="'.$thumb_mid_link.'" title="'.$alt.'" >'.$LANGUAGE_PACK["site_index_html_code"].'</a>:</label> <input type="text" id="codehtml" value=\'&lt;a href="'.$thumb_mid_link.'" title="'.$alt.'" &gt;&lt;img src="'.$thumb_mid_url.'" alt="'.$alt.'" /&gt;&lt/a&gt;\' onclick="javascript:this.focus();this.select();" readonly="true" class="text_input long" /></div>
										<h3>'.$LANGUAGE_PACK["site_index_image_link"].'</h3>
											<div class="code_box"><label for="codebb">'.$LANGUAGE_PACK["site_index_bbcode"].':</label> <input type="text" id="codebb" value="[IMG]'.$imgurl.'[/IMG]" onclick="javascript:this.focus();this.select();" readonly="true" class="text_input long" /></div>
											<div class="code_box"><label for="codedirect">'.$LANGUAGE_PACK["site_index_direct_link"].':</label> <input type="text" id="codedirect" value="'.$imgurl.'" onclick="javascript:this.focus();this.select();" readonly="true" class="text_input long" /></div>
										<h3>Delete Image</h3>
											<div class="code_box"><label for="deletecode">'.$LANGUAGE_PACK["site_index_delete_url"].':</label> <input type="text" id="deletecode" value="'.$settings['SET_SITEURL'].'?d='.$delete_id.'" onclick="javascript:this.focus();this.select();" readonly="true" class="text_input long" /></div>
											<p class="teaser">'.$LANGUAGE_PACK["site_index_delete_url_des"].'</p>
									</div>';

// Errors ---------------------------------------------------
						}else //Saving DB
							$Err['imagedb'] = $LANGUAGE_PACK["site_index_delete_image_err_db"];
					}else{
						@unlink($IMG_ADDRESS);
						@unlink($THUMB_ADDRESS);
						@unlink($THUMB_MID_ADDRESS);
						$Err['upload_error'] = $LANGUAGE_PACK["site_upload_err"];
					}
				}else // move the uploaded file
					$Err['upload_error'] = $LANGUAGE_PACK["site_upload_err"];
			}//name
		}//for
	}

// UPLOAD CODE END
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
// MAKE PAGE

	$menu='';
	include_once('header.php');
	error_note($Err);
	echo (isset($img_posted)? $img_posted:error_note($LANGUAGE_PACK["site_upload_err_no_image"]));
	include_once('footer.php');

// MAKE PAGE END
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
// functions


// Upload Logic
	function handle_url($url,$save_dir) {

		$upload_img  = @getImageSize($url);
		$_FILES = Array (
						'file' => Array (
										'name' => Array ( basename($url)),
										'type' => Array ( $upload_img['mime'] ),
										'tmp_name' => Array ( $save_dir.rand(0,7).time().rand(0,7).'.'.strtolower(substr($url, -3)) ),
										'error' => Array ( 0 ),
										'size' => Array ( get_remote_file_size($url) )
										)
						);

		if(save_image($url, $_FILES['file']['tmp_name'][0])){
			return $_FILES;
		}
	}

	function get_remote_file_size($url){
		$parsed = parse_url($url);
		$host = $parsed["host"];
		$fp = @fsockopen($host, 80, $errno, $errstr, 20);
		if(!$fp){
			return false;
		}else {
			@fputs($fp, "HEAD $url HTTP/1.1\r\n");
			@fputs($fp, "HOST: $host\r\n");
			@fputs($fp, "Connection: close\r\n\r\n");
			$headers = "";
			while(!@feof($fp))$headers .= @fgets ($fp, 128);
		}
		@fclose ($fp);
		$return = false;
		$arr_headers = explode("\n", $headers);
		foreach($arr_headers as $header) {
			// follow redirect
			$s = 'Location: ';
			if(substr(strtolower ($header), 0, strlen($s)) == strtolower($s)) {
				$url = trim(substr($header, strlen($s)));
				return get_remote_file_size($url);
			}
			// parse for content length
			$s = "Content-Length: ";
			if(substr(strtolower ($header), 0, strlen($s)) == strtolower($s)) {
				$return = trim(substr($header, strlen($s)));
				break;
			}
		}
		return $return;
	}

//Download images from remote server
	function save_image($inPath,$outPath){ 
		$in	= fopen($inPath, "rb");
		$out= fopen($outPath, "wb");
		while($chunk = fread($in,8192)){
			fwrite($out, $chunk, 8192);
		}
		fclose($in);
		fclose($out);
		return((bool) file_exists($outPath));
	}

?>