<?php
//
//   CF Image Hosting Script v1.3.8
//   -------------------------------
//
//   Author:    codefuture.co.uk
//   Version:   1.3.8
//   Date:      14-Aug-10
//
//   download the latest version from - http://codefuture.co.uk/projects/imagehost1.3/
//
//   Copyright (c) 2010 codefuture.co.uk
//   This file is part of the CF Image Hosting Script.
//
//   CF Image Hosting Script is free software: you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation, either version 3 of the License, or
//   (at your option) any later version.
//
//   CF Image Hosting Script is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//   You should have received a copy of the GNU General Public License
//   along with CF Image Hosting Script.  If not, see http://www.gnu.org/licenses/.
//
////////////////////////////////////////////////////////////////////////////////////

	include_once('inc/config.php');

	$db = new array_db($ADD_DB_IMG);

////////////////////////////////////////////////////////////////////////////////////
// DELETE IMAGE

	if (isset($_GET['d'])){
		$img_del_code = removeSymbols(input($_GET['d']));
		$img_del_id = $db->fetch_value('deleteid',$img_del_code,'id');
		if (!empty($img_del_id)){
		// Remove Image
			if(@unlink(get_image_address($img_del_id,'')))
				$Suc['delete_image'] = $LANGUAGE_PACK["site_index_delete_image_suc"];
		// Remove small thumb
			@unlink(get_thumb_address($img_del_id));
		// Remove thumb
			@unlink(get_thumb_mid_address($img_del_id));
		// Remove link from array
			if ($db->remove_row('id',$img_del_id)){
				if(!$db -> save_db_now()) $Err['delete_image'] = $LANGUAGE_PACK["site_index_delete_image_err_db"];
			}else
				$Err['delete_image'] = $LANGUAGE_PACK["site_index_delete_image_err_db"];
		}else
			$Err['delete_image'] = $LANGUAGE_PACK["site_index_delete_image_err_not_found"];
	}

// DELETE IMAGE END
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
// IMAGE LINK
	function notfound(){
		header('Content-type: image/png');
		readfile('img/notfound.png');
		exit();
	}

	if (isset($_GET['di'])){
		$img_id = removeSymbols(end(explode('/',input($_GET['di']))));
		if ($db->item_exists('id',$img_id)){
			not_max_bandwidth($img_id);
			$img_address = get_image_address($img_id,'');
			$pathinfo = pathinfo($img_address);
			if(!hotlink()){
				header('Content-type: image/'.strtolower($pathinfo['extension']));
				readfile($img_address);
			}else{
				if($settings['SET_WATERMARK']){
					watermarkImage($img_address,$settings['SET_WATERMARK_TEXT'],$settings['SET_WATERMARK_PLACED']);
				}else{
					header('Content-type: image/'.strtolower($pathinfo['extension']));
					readfile($img_address);
				}
				countSave($img_id,1);
			}
			exit();
		}else
			notfound();
	}


// IMAGE LINK END
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
// SMALL THUMB LINK

	if (isset($_GET['dt'])){
		$img_id = removeSymbols(end(explode('/',input($_GET['dt']))));
		if ($db->item_exists('id',$img_id)){
			not_max_bandwidth($img_id);
			$img_address = get_thumb_address($img_id);
			if(!hotlink()){
				header('Content-type: image/'.$THUMB_SAVE_EXT);
				readfile($img_address);
			}else{
				if($settings['SET_WATERMARK']){
					watermarkImage($img_address,$settings['SET_WATERMARK_TEXT'],$settings['SET_WATERMARK_PLACED']);
				}else{
					header('Content-type: image/'.$THUMB_SAVE_EXT);
					readfile($img_address);
				}
				countSave($img_id,3);
			}
			exit();
		}else
			notfound();
	}

// SMALL THUMBS LINK END
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
// THUMB LINK

	if (isset($_GET['dm'])){
		$img_id = removeSymbols(end(explode('/',input($_GET['dm']))));
		if ($db->item_exists('id',$img_id)){
			not_max_bandwidth($img_id);
			$img_address = get_thumb_mid_address($img_id);
			if(!hotlink()){
				header('Content-type: image/'.$THUMB_MID_SAVE_EXT);
				readfile($img_address);
			}else{
				if($settings['SET_WATERMARK']){
					watermarkImage($img_address,$settings['SET_WATERMARK_TEXT'],$settings['SET_WATERMARK_PLACED']);
				}else{
					header('Content-type: image/'.$THUMB_MID_SAVE_EXT);
					readfile($img_address);
				}
				countSave($img_id,2);
			}
			exit();
		}else
			notfound();
	}

// THUMBS LINK END
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
// THUMB PAGE

	if (isset($_GET['pt'])||isset($_GET['pm'])){
		$img_id = removeSymbols(end(explode('/',input(isset($_GET['pt'])? $_GET['pt']:$_GET['pm']))));
	//see if image exists
		if ($db->item_exists('id',$img_id)){//(get_thumb_address($IMG_ID) && get_thumb_mid_address($IMG_ID) &&	get_image_address($IMG_ID,'',$db_img)){
			countSave($img_id,4);
			// Page output
				$thumb_link		= get_thumb_address($img_id,"pt");
				$thumb_url		= get_thumb_address($img_id,"dt");
				$thumb_mid_link	= get_thumb_mid_address($img_id,"pm");
				$thumb_mid_url	= get_thumb_mid_address($img_id,"dm");
				$imgurl			= get_image_address($img_id,'di');
				$alt			= $db->fetch_value('id',$img_id,'alt');
				$shorturl		= $db->fetch_value('id',$img_id,'shorturl');
				$bookmarking	= bookmarking(($shorturl ==null?$thumb_mid_link:$shorturl),$alt);
				$thumb_show		= isset($_GET['pt'])? $thumb_url:$thumb_mid_url;
				$open_panel		= ($settings['SET_PANEL_OPEN'] ? ' open':'');

				if(	$db->fetch_value('id',$img_id,'dimensions_x')!='' &&
					$db->fetch_value('id',$img_id,'dimensions_y')!=''){
					$get_dimensions = array($db->fetch_value('id',$img_id,'dimensions_x'),$db->fetch_value('id',$img_id,'dimensions_y'));
				}else{
					$get_dimensions = @getimagesize($imgurl);
				}

				$img_posted = '<div class="img_ad_box">';
			// AdSense
				if($settings['SET_GOOGLE_ADS'] !=''){
					$img_posted .= '<div class="thumb_Ad">'.$thumb_AdSense.'</div>';
				}
				$img_posted .= '<div class="img_box'.($settings['SET_GOOGLE_ADS'] !=''?' left':'').'"><a href="'.$imgurl.'" title="'.$alt.'" ><img src="'.$thumb_show.'" alt="'.$alt.'" /><br/><span>'.$alt.'</span></a></div>
						<div style="clear: both;"></div>
					</div>';

			// Image Links
				$img_posted .= '
					<div class="flip">'.$LANGUAGE_PACK["site_index_hide_link"].'</div>
					<div class="panel'.$open_panel.'">
						<div class="code_box"><label id="toplabel">'.$LANGUAGE_PACK["site_index_social_networks"].':</label>'.$bookmarking.'</div>';

			// Short URL
				if ($shorturl != null && !empty($shorturl)){
					$img_posted .= '<div class="code_box"><label for="shorturl">'.$LANGUAGE_PACK["site_index_short_url_link"].':</label> <input type="text" id="codehtml" value="'.$shorturl.'" onclick="javascript:this.focus();this.select();" readonly="true" class="text_input long" /></div>';
				}

			// Image Links
				$img_posted .= '
						<h3>'.$LANGUAGE_PACK["site_index_small_thumbnail_link"].'</h3>
							<div class="code_box"><label for="codelbb">'.$LANGUAGE_PACK["site_index_bbcode"].':</label> <input type="text" id="codelbb" value="[URL='.$thumb_link.'][IMG]'.$thumb_url.'[/IMG][/URL]" onclick="javascript:this.focus();this.select();" readonly="true" class="text_input long" /></div>
							<div class="code_box"><label for="codehtml"><a href="'.$thumb_link.'" title="'.$alt.'" >'.$LANGUAGE_PACK["site_index_html_code"].'</a> :</label> <input type="text" id="codehtml" value=\'&lt;a href="'.$thumb_link.'" title="'.$alt.'" &gt;&lt;img src="'.$thumb_url.'" alt="'.$alt.'" /&gt;&lt/a&gt;\' onclick="javascript:this.focus();this.select();" readonly="true" class="text_input long" /></div>
						<h3>'.$LANGUAGE_PACK["site_index_thumbnail_link"].'</h3>
							<div class="code_box"><label for="codelbb">'.$LANGUAGE_PACK["site_index_bbcode"].':</label> <input type="text" id="codelbb" value="[URL='.$thumb_mid_link.'][IMG]'.$thumb_mid_url.'[/IMG][/URL]" onclick="javascript:this.focus();this.select();" readonly="true" class="text_input long" /></div>
							<div class="code_box"><label for="codehtml"><a href="'.$thumb_mid_link.'" title="'.$alt.'" >'.$LANGUAGE_PACK["site_index_html_code"].'</a> :</label> <input type="text" id="codehtml" value=\'&lt;a href="'.$thumb_mid_link.'" title="'.$alt.'" &gt;&lt;img src="'.$thumb_mid_url.'" alt="'.$alt.'" /&gt;&lt/a&gt;\' onclick="javascript:this.focus();this.select();" readonly="true" class="text_input long" /></div>
						<h3>'.$LANGUAGE_PACK["site_index_image_link"].'</h3>
						<div class="code_box"><label for="codebb">'.$LANGUAGE_PACK["site_index_bbcode"].':</label> <input type="text" id="codebb" value="[IMG]'.$imgurl.'[/IMG]" onclick="javascript:this.focus();this.select();" readonly="true" class="text_input long" /></div>
						<div class="code_box"><label for="codedirect">'.$LANGUAGE_PACK["site_index_direct_link"].'</label> <input type="text" id="codedirect" value="'.$imgurl.'" onclick="javascript:this.focus();this.select();" readonly="true" class="text_input long" /></div>
					</div>';

			// Image Details
				if($settings['SET_IMAGE_DETAILS']){
					$img_posted .= '
						<div class="flip">'.$LANGUAGE_PACK["site_thumb_image_details"].'</div>
						<div class="panel'.$open_panel.'">
							<div class="code_box"><label>'.$LANGUAGE_PACK["site_thumb_image_size"].' :</label> <div class="bookmarking">'.format_size($db->fetch_value('id',$img_id,'size')).'</div></div>
							<div class="code_box"><label>'.$LANGUAGE_PACK["site_thumb_image_dimensions"].' :</label> <div class="bookmarking">'.$get_dimensions[0].'x'.$get_dimensions[1].'</div></div>
							<div class="code_box"><label>'.$LANGUAGE_PACK["site_thumb_uploaded_on"].' :</label> <div class="bookmarking">'.gmdate('l jS \of F Y h:i:s A',$db->fetch_value('id',$img_id,'added')).'</div></div>';
							$exif = @exif_read_data($imgurl, 0, true);
						if($exif != ''){
							foreach ($exif as $key => $section) {
									$img_posted .= '<h3>'.$key.'</h3>';
								foreach ($section as $name => $val) {
									$img_posted .= '<div class="code_box"><label>'.$name.' :</label> <div class="bookmarking">'.$val.'</div></div>';
								}
							}
						}
					$img_posted .= '
						</div>
						<br/>';
				}// End Image Details

		}else
			$Err['thumbs_page'] = $LANGUAGE_PACK["site_index_thumbs_page_err"];
	}


// THUMBS PAGE END
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
// MAKE PAGE

	$menu='';
	$page_title = isset($img_posted) ? ' - '.$alt:' - '.$settings['SET_SLOGAN'];
	include_once('header.php');
	success_note($Suc);
	error_note($Err);

	if (isset($img_posted)){

//////////////////////////////////
//Thumbnail page

		echo $img_posted;

//////////////////////////////////

	}else{

//////////////////////////////////
//home page (upload)
	$Inactive_Files ='';
	if($settings['SET_AUTO_DELETED']){
		$Inactive_Files = sprintf($LANGUAGE_PACK["site_index_auto_deleted"],$settings['SET_AUTO_DELETED_TIME']).'<br />';
	}

	$Hot_Linking_limit = '';
	if($settings['SET_MAX_BANDWIDTH'] !=0){
		$Hot_Linking_limit = '<b>'.$LANGUAGE_PACK["site_index_max_bandwidth"].':</b> '.(format_size(1048576*$settings['SET_MAX_BANDWIDTH'])).' '.$LANGUAGE_PACK["site_index_max_bandwidth_per"].($settings['SET_AUTO_DELETED_JUMP'] == 'm' ? $LANGUAGE_PACK["site_index_max_bandwidth_per_month"]:$LANGUAGE_PACK["site_index_max_bandwidth_per_week"]).'<br />';
	}

	$Max_Upload = '';
	if($settings['SET_MAX_UPLOAD'] !=0){
		$Max_Upload = '<div class="Upload_Multiple"><span>'.$LANGUAGE_PACK["site_index_max_upload"].' </span><a href="#" class="add_another_file_input"><img src="./img/add.png" title="'.$LANGUAGE_PACK["site_index_max_upload"].'" alt="'.$LANGUAGE_PACK["site_index_max_upload"].'" /></a><small>('.$LANGUAGE_PACK["site_index_max_upload_max"].' '.$settings['SET_MAX_UPLOAD'].')</small><br/><br/></div>';
	}

	$Hide_Tos = '';
	if(!$settings['SET_HIDE_TOS']){
		$Hide_Tos = '<p>'.sprintf($LANGUAGE_PACK["site_index_tos_des"],'<a href="tos.php" title="'.$LANGUAGE_PACK["site_menu_tos"].'">'.$LANGUAGE_PACK["site_menu_tos"].'</a>').'</p>';
	}

	$private_img='';
	if($settings['SET_PRIVATE_IMG_ON']){
		$private_img ='<input name="private" value="1" type="checkbox" /> '.$LANGUAGE_PACK["site_index_private_img"].'<br/>';
	}

	$short_url='';
	if($settings['SET_SHORT_URL_ON']){
		$short_url ='<input name="shorturl" value="1" type="checkbox" /> '.$LANGUAGE_PACK["site_index_short_url"].' '.$settings['SET_SHORT_URL_API'].'<br/>';
	}
?>
		<div class="contentBox">
		<?if($settings['SET_DIS_UPLOAD']||checklogin()){?>
			<form enctype="multipart/form-data" action="upload.php" method="post" class="upform<? if($settings['SET_GOOGLE_ADS'] !=''){?> left<?}?>" name="upload" id="upload">
				<p class="teaser"><?=$LANGUAGE_PACK["site_index_des"];?></p>
				<p class="teaser">
					<?=$Inactive_Files;?>
					<?=$Hot_Linking_limit;?>
					<b><?=$LANGUAGE_PACK["site_index_Image_Formats"];?>:</b> <?=$types;?><br />
					<b><?=$LANGUAGE_PACK["site_index_maximum_filesize"];?>:</b> <?=format_size($settings['SET_MAXSIZE']);?>
				</p>
				<div class="upload_op">
					<a id="linklocal" class="linklocal show" title="<?=$LANGUAGE_PACK["site_index_local_image_upload_title"];?>"><?=$LANGUAGE_PACK["site_index_local_image_upload"];?></a>
					<a id="linkremote" class="linkremote" title="<?=$LANGUAGE_PACK["site_index_Remote_image_copy_title"];?>"><?=$LANGUAGE_PACK["site_index_Remote_image_copy"];?></a>
				</div>
				<div class="loading">
					<label><?=$LANGUAGE_PACK["site_index_uploading_image"];?></label>
					<img src="img/loading.gif" alt="Uploading Image" />
				</div>
				<div class="input file">
					<div class="upload_form">
						<div id="remote_panel" class="file_url" style="display: none;">
							<label for="imgUrl"><?=$LANGUAGE_PACK["site_index_Remote_image"];?></label>
							<input type="text" name="imgUrl" id="imgUrl"  class="text_input long" />
						</div>
						<div id="local_panel" class="file_upload">
							<label for="file"><?=$LANGUAGE_PACK["site_index_upload_image"];?>: </label>
							<div class="file_input_div"><input type="text" id="fileName" name="fileName[]"  class="text_input long" readonly="readonly" />
								<input type="button" value="<?=$LANGUAGE_PACK["site_index_upload_browse_button"];?>" name="Search files" class="file_input_button" />
								<input type="file" name="file[]" id="file" class="file_input_hidden" onchange="javascript: copyfileName()" />
							</div>
						</div>
					</div>
					<label for="alt" class="des"><?=$LANGUAGE_PACK["site_index_upload_description"];?></label>
					<input type="text" name="alt[]" id="alt" class="text_input long_des" />
				</div>
				<?=$Max_Upload;?>
			<? if($settings['SET_PRIVATE_IMG_ON'] || $settings['SET_SHORT_URL_ON']){?>
				<div class="preferences">
				<?=$private_img;?>
				<?=$short_url;?>
				</div>
			<?}?>
				<input name="submit" type="submit" value="<?=$LANGUAGE_PACK["site_index_upload_button"];?>" class="button" onclick="return fileExt()" />
				<?=$Hide_Tos?>
			</form>
			<? if($settings['SET_GOOGLE_ADS'] !=''){?>
			<div class="ad_index"><?=$index_AdSense;?></div>
			<div class="ad_index"><?=$index_AdSense;?></div>
			<?}?>
		<?}else{//dis upload?>
			<p class="teaser"><b><?=$LANGUAGE_PACK["site_index_upload_disable"];?></b></p>
		<?}?>
		</div>
<?
	} //end
	include_once('footer.php');

// MAKE PAGE END
////////////////////////////////////////////////////////////////////////////////////
?>