<?php

//  Author:    Jarrod Oberto
//  Version:   1.0
//  Date:      17-Jan-10
//  Purpose:   Resizes and saves image
//  Requires : Requires PHP5, GD library.
//  Usage Example:
//                     include("classes/resize_class.php");
//                     $resizeObj = new resize('images/cars/large/input.jpg');
//                     $resizeObj -> stretchSmallImages(TRUE);
//                     $resizeObj -> keepImageTransparency(FALSE);
//                     $resizeObj -> resizeImage(150, 100, 0);
//                     $resizeObj -> imageSaveQuality(75);
//                     $resizeObj -> saveImage('images/cars/large/output.jpg');
//
//  updated: 28 March 2010 by codefuture
//    Added - ImageCreateFromBMP ( Now you can make thumbnail from BMP )
//    Added - Image Transparency support for thumbnail being saved in PNG or GIF (true by default)
//    Added - stretch:
//              By default if the source image is already smaller than the thumbnail
//              size it will not be stretched to the max size.
//              If you specify TRUE for stretch it will be stretched
//
//
//
//   CF Image Hosting Script v1.3.8
//   -------------------------------
//
//   Author:    codefuture.co.uk
//   Version:   1.3.8
//   Date:      14-Aug-10
//
//   download the latest version from - http://codefuture.co.uk/projects/imagehost/
//
////////////////////////////////////////////////////////////////////////////////////
		Class resize{

			// *** Class variables
			private $image;
			private $width;
			private $height;
			private $imageResized;
			private $stretch = FALSE;
			private $transparency = TRUE;
			private $imageQuality = "100";

			public function stretchSmallImages($var){ $this->stretch = $var;}
			public function keepImageTransparency($var){ $this->transparency = $var;}
			public function imageSaveQuality($var){ $this->imageQuality = $var;}

			function __construct($fileName)
			{
				// *** Open up the file
				$this->image = $this->openImage($fileName);

				// *** Get width and height
				$this->width  = @imagesx($this->image);
				$this->height = @imagesy($this->image);
			}

			## --------------------------------------------------------

			private function openImage($file)
			{
				// *** Get extension
				$extension = strtolower(strrchr($file, '.'));
				$size = @getimagesize($file);

				switch($extension)
				{
					case '.jpg':
					case '.jpeg':
						$img = @imagecreatefromjpeg($file);
						break;
					case '.gif':
						$img = @imagecreatefromgif($file);
						break;
					case '.png':
						$img = @imagecreatefrompng($file);
						break;
					case '.bmp':
						$img = @imagecreatefrombmp($file);
						break;
					default:
						$img = false;
						break;
				}
				return $img;
			}

			## --------------------------------------------------------

			public function resizeImage($newWidth, $newHeight, $option="auto")
			{
				// *** Get optimal width and height - based on $option
				$optionArray = $this->getDimensions($newWidth, $newHeight, $option);

				$optimalWidth  = $optionArray['optimalWidth'];
				$optimalHeight = $optionArray['optimalHeight'];


				// *** Resample - create image canvas of x, y size
				$this->imageResized = @imagecreatetruecolor($optimalWidth, $optimalHeight);
				if($this->transparency) $this->setTransparency();
				@imagecopyresampled($this->imageResized, $this->image, 0, 0, 0, 0, $optimalWidth, $optimalHeight, $this->width, $this->height);


				// *** if option is 'crop', then crop too
				if ($option == 'crop') {
					$this->crop($optimalWidth, $optimalHeight, $newWidth, $newHeight);
				}
			}

			## --------------------------------------------------------
			
			private function getDimensions($newWidth, $newHeight, $option)
			{

				if ($newHeight > $this->height && $newWidth > $this->width && !$this->stretch)
				//already smaller than the thumbnail
				{
					$optimalWidth = $this->width;
					$optimalHeight= $this->height;
				}
				else{
					switch ($option)
					{
						case 'exact':
							$optimalWidth = $newWidth;
							$optimalHeight= $newHeight;
							break;
						case 'portrait':
							$optimalWidth = $this->getSizeByFixedHeight($newHeight);
							$optimalHeight= $newHeight;
							break;
						case 'landscape':
							$optimalWidth = $newWidth;
							$optimalHeight= $this->getSizeByFixedWidth($newWidth);
							break;
						case 'auto':
							$optionArray = $this->getSizeByAuto($newWidth, $newHeight);
							$optimalWidth = $optionArray['optimalWidth'];
							$optimalHeight = $optionArray['optimalHeight'];
							break;
						case 'crop':
							$optionArray = $this->getOptimalCrop($newWidth, $newHeight);
							$optimalWidth = $optionArray['optimalWidth'];
							$optimalHeight = $optionArray['optimalHeight'];
							break;
					}
				}
				return array('optimalWidth' => $optimalWidth, 'optimalHeight' => $optimalHeight);
			}

			## --------------------------------------------------------

			private function getSizeByFixedHeight($newHeight)
			{
				$ratio = $this->width / $this->height;
				$newWidth = $newHeight * $ratio;
				return $newWidth;
			}

			private function getSizeByFixedWidth($newWidth)
			{
				$ratio = $this->height / $this->width;
				$newHeight = $newWidth * $ratio;
				return $newHeight;
			}

			private function getSizeByAuto($newWidth, $newHeight)
			{
				if ($this->height < $this->width)
				// *** Image to be resized is wider (landscape)
				{
					$optimalWidth = $newWidth;
					$optimalHeight= $this->getSizeByFixedWidth($newWidth);
				}
				elseif ($this->height > $this->width)
				// *** Image to be resized is taller (portrait)
				{
					$optimalWidth = $this->getSizeByFixedHeight($newHeight);
					$optimalHeight= $newHeight;
				}
				else
				// *** Image to be resizerd is a square
				{
					if ($newHeight < $newWidth) {
						$optimalWidth = $newWidth;
						$optimalHeight= $this->getSizeByFixedWidth($newWidth);
					} else if ($newHeight > $newWidth) {
						$optimalWidth = $this->getSizeByFixedHeight($newHeight);
						$optimalHeight= $newHeight;
					} else {
						// *** Sqaure being resized to a square
						$optimalWidth = $newWidth;
						$optimalHeight= $newHeight;
					}
				}

				return array('optimalWidth' => $optimalWidth, 'optimalHeight' => $optimalHeight);
			}

			## --------------------------------------------------------

			private function getOptimalCrop($newWidth, $newHeight)
			{

				$heightRatio = $this->height / $newHeight;
				$widthRatio  = $this->width /  $newWidth;

				if ($heightRatio < $widthRatio) {
					$optimalRatio = $heightRatio;
				} else {
					$optimalRatio = $widthRatio;
				}

				$optimalHeight = $this->height / $optimalRatio;
				$optimalWidth  = $this->width  / $optimalRatio;

				return array('optimalWidth' => $optimalWidth, 'optimalHeight' => $optimalHeight);
			}

			## --------------------------------------------------------

			private function crop($optimalWidth, $optimalHeight, $newWidth, $newHeight)
			{
				// *** Find center - this will be used for the crop
				$cropStartX = ( $optimalWidth / 2) - ( $newWidth /2 );
				$cropStartY = ( $optimalHeight/ 2) - ( $newHeight/2 );

				$crop = $this->imageResized;
				//imagedestroy($this->imageResized);

				// *** Now crop from center to exact requested size
				$this->imageResized = imagecreatetruecolor($newWidth , $newHeight);
				imagecopyresampled($this->imageResized, $crop , 0, 0, $cropStartX, $cropStartY, $newWidth, $newHeight , $newWidth, $newHeight);
			}

			## --------------------------------------------------------

			private function setTransparency()
			{
				$transparencyIndex = @imagecolortransparent($this->image);
				$transparencyColor = @imagecolorsforindex($this->image, $transparencyIndex);  

				if ($transparencyIndex >= 0 && !empty($transparencyColor)) {
					$transparencyIndex = imagecolorallocate($this->imageResized, $transparencyColor['red'], $transparencyColor['green'], $transparencyColor['blue']);
					imagefill($this->imageResized, 0, 0, $transparencyIndex);
					imagecolortransparent($this->imageResized, $transparencyIndex);
				}
			} 

			## --------------------------------------------------------

			public function saveImage($savePath)
			{
				// *** Get extension
				$extension = strrchr($savePath, '.');
				$extension = strtolower($extension);


				switch($extension)
				{
					case '.jpg':
					case '.jpeg':
						if (imagetypes() & IMG_JPG) {
							@imagejpeg($this->imageResized, $savePath, $this->imageQuality);
						}
						break;

					case '.gif':
						if (imagetypes() & IMG_GIF) {
							@imagegif($this->imageResized, $savePath);
						}
						break;

					case '.png':
						// *** Scale quality from 0-100 to 0-9
						$scaleQuality = round(($this->imageQuality/100) * 9);

						// *** Invert quality setting as 0 is best, not 9
						$invertScaleQuality = 9 - $scaleQuality;

						if (imagetypes() & IMG_PNG) {
							@imagepng($this->imageResized, $savePath, $invertScaleQuality);
						}
						break;

					// ... etc

					default:
						// *** No extension - No save.
						break;
				}

				@imagedestroy($this->imageResized);
			}


			## --------------------------------------------------------

		}

/*********************************************/
/* Fonction: ImageCreateFromBMP              */
/* Author:   DHKold                          */
/* Contact:  admin@dhkold.com                */
/* Date:     The 15th of June 2005           */
/* Version:  2.0B                            */
/*********************************************/

function ImageCreateFromBMP($filename){
//Ouverture du fichier en mode binaire
	if (! $f1 = fopen($filename,"rb")) return FALSE;

//1 : Chargement des ent?tes FICHIER
	$FILE = unpack("vfile_type/Vfile_size/Vreserved/Vbitmap_offset", fread($f1,14));
	if ($FILE['file_type'] != 19778) return FALSE;

//2 : Chargement des ent?tes BMP
	$BMP = unpack('Vheader_size/Vwidth/Vheight/vplanes/vbits_per_pixel'.
		 '/Vcompression/Vsize_bitmap/Vhoriz_resolution'.
		 '/Vvert_resolution/Vcolors_used/Vcolors_important', fread($f1,40));
	$BMP['colors'] = pow(2,$BMP['bits_per_pixel']);
	if ($BMP['size_bitmap'] == 0) $BMP['size_bitmap'] = $FILE['file_size'] - $FILE['bitmap_offset'];
	$BMP['bytes_per_pixel'] = $BMP['bits_per_pixel']/8;
	$BMP['bytes_per_pixel2'] = ceil($BMP['bytes_per_pixel']);
	$BMP['decal'] = ($BMP['width']*$BMP['bytes_per_pixel']/4);
	$BMP['decal'] -= floor($BMP['width']*$BMP['bytes_per_pixel']/4);
	$BMP['decal'] = 4-(4*$BMP['decal']);
	if ($BMP['decal'] == 4) $BMP['decal'] = 0;

//3 : Chargement des couleurs de la palette
	$PALETTE = array();
	if ($BMP['colors'] < 16777216){
		$PALETTE = unpack('V'.$BMP['colors'], fread($f1,$BMP['colors']*4));
	}

//4 : Cr?ation de l'image
	$IMG = fread($f1,$BMP['size_bitmap']);
	$VIDE = chr(0);

	$res = imagecreatetruecolor($BMP['width'],$BMP['height']);
	$P = 0;
	$Y = $BMP['height']-1;
	while ($Y >= 0) {
		$X=0;
		while ($X < $BMP['width']){
			if ($BMP['bits_per_pixel'] == 24)
				$COLOR = unpack("V",substr($IMG,$P,3).$VIDE);
			elseif ($BMP['bits_per_pixel'] == 16){ 
				$COLOR = unpack("n",substr($IMG,$P,2));
				$COLOR[1] = $PALETTE[$COLOR[1]+1];
			}elseif ($BMP['bits_per_pixel'] == 8){ 
				$COLOR = unpack("n",$VIDE.substr($IMG,$P,1));
				$COLOR[1] = $PALETTE[$COLOR[1]+1];
			}elseif ($BMP['bits_per_pixel'] == 4){
				$COLOR = unpack("n",$VIDE.substr($IMG,floor($P),1));
				if (($P*2)%2 == 0) $COLOR[1] = ($COLOR[1] >> 4) ; else $COLOR[1] = ($COLOR[1] & 0x0F);
				$COLOR[1] = $PALETTE[$COLOR[1]+1];
			}elseif ($BMP['bits_per_pixel'] == 1){
				$COLOR = unpack("n",$VIDE.substr($IMG,floor($P),1));
				if     (($P*8)%8 == 0) $COLOR[1] =  $COLOR[1]        >>7;
				elseif (($P*8)%8 == 1) $COLOR[1] = ($COLOR[1] & 0x40)>>6;
				elseif (($P*8)%8 == 2) $COLOR[1] = ($COLOR[1] & 0x20)>>5;
				elseif (($P*8)%8 == 3) $COLOR[1] = ($COLOR[1] & 0x10)>>4;
				elseif (($P*8)%8 == 4) $COLOR[1] = ($COLOR[1] & 0x8)>>3;
				elseif (($P*8)%8 == 5) $COLOR[1] = ($COLOR[1] & 0x4)>>2;
				elseif (($P*8)%8 == 6) $COLOR[1] = ($COLOR[1] & 0x2)>>1;
				elseif (($P*8)%8 == 7) $COLOR[1] = ($COLOR[1] & 0x1);
				$COLOR[1] = $PALETTE[$COLOR[1]+1];
			}else
				return FALSE;
			imagesetpixel($res,$X,$Y,$COLOR[1]);
			$X++;
			$P += $BMP['bytes_per_pixel'];
		}
	$Y--;
	$P+=$BMP['decal'];
	}

//Fermeture du fichier
	fclose($f1);

	return $res;
}

?>
