<?
//
//   CF Image Hosting Script v1.3.8
//   -------------------------------
//
//   Author:    codefuture.co.uk
//   Version:   1.3.8
//   Date:      14-Aug-10
//
//   download the latest version from - http://codefuture.co.uk/projects/imagehost1.3/
//
//   Copyright (c) 2010 codefuture.co.uk
//   This file is part of the CF Image Hosting Script.
//
//   CF Image Hosting Script is free software: you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation, either version 3 of the License, or
//   (at your option) any later version.
//
//   CF Image Hosting Script is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//   You should have received a copy of the GNU General Public License
//   along with CF Image Hosting Script.  If not, see http://www.gnu.org/licenses/.
//
////////////////////////////////////////////////////////////////////////////////////

	include_once('inc/config.php');

	$db = new array_db($ADD_DB_IMG);

	//remove reported images
		if($settings['SET_REMOVE_REPORT']){
			$db_report = new array_db($ADD_DB_REPORT);
			if($db_report->db_not_empty()){
				$db_report_full = $db_report->fetch_all();
				foreach ($db_report_full as $k => $v) {
					 $db->remove_row('id',$v['id']);
				}
			}
		}

	//remove private images
		if($settings['SET_PRIVATE_IMG_ON']){
			$db->remove_row('private',1,'rows');
		}

	header('Content-type: text/xml');
	echo '<?xml version="1.0" encoding="utf-8"?>';
?>
	<rss version="2.0">
		<channel>
			<title><?=$settings['SET_TITLE'];?></title>
			<link><?=$settings['SET_SITEURL'];?></link>
			<description>10 Newest images</description>
			<language>en-gb</language>
	<?php
		if ($db->db_not_empty()){
			$i = 0;
			$limit = $db->db_count() > 10 ? 10 : $db->db_count();
			$db->order_By('added',321);
			$db_img	= $db->fetch_all();
			foreach ($db_img as $k => $v){
				if ($i >= $limit) break;
				$i++;
				$date = date("D, d M Y H:i:s T", $v['added']);
				$url = get_thumb_mid_address($v['id'],"pm",$db_img);
				$thumb_url = get_thumb_address($v['id'],"dt",$db_img);
				echo '
				<item>
					<title>Image name '.$v['name'].'</title>
					<link>'.$url.'#post-'.$k.'</link>
					<pubDate>'.$date.'</pubDate>
					<description>
					&lt;p&gt;&lt;img style="float:left;margin-right:10px;margin-bottom: 10px;" src="'.$thumb_url.'" alt="'.$v['alt'].'" /&gt;&lt;/p&gt;</description>
				</item>';

			}
		}else{
			echo '
				<item>
					<title>No images upload</title>
					<link>'.$settings['SET_SITEURL'].'</link>
					<pubDate>'.date().'</pubDate>
					<description><![CDATA[ No Images ]]></description>
				</item>';
		
		}
	?>
			</channel>
		</rss>