<?php
//
//   CF Image Hosting Script v1.3.8
//   -------------------------------
//
//   Author:    codefuture.co.uk
//   Version:   1.3.8
//   Date:      14-Aug-10
//
//   download the latest version from - http://codefuture.co.uk/projects/imagehost1.3/
//
//   Copyright (c) 2010 codefuture.co.uk
//   This file is part of the CF Image Hosting Script.
//
//   CF Image Hosting Script is free software: you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation, either version 3 of the License, or
//   (at your option) any later version.
//
//   CF Image Hosting Script is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//   You should have received a copy of the GNU General Public License
//   along with CF Image Hosting Script.  If not, see http://www.gnu.org/licenses/.
//
////////////////////////////////////////////////////////////////////////////////////

	include_once('inc/config.php');

	if($settings['SET_HIDE_GALLERY']){
		header('Location: index.php');
		exit();
	}

	if(isset($_GET['report']) && $settings['SET_ALLOW_REPORT']){
		report_img(input($_GET['report']),$_SERVER['REMOTE_ADDR']);
	}

////////////////////////////////////////////////////////////////////////////////////
// gallery start

	// see what page we are on
		$page_number = (isset($_GET['p']) ? input($_GET['p'])-1:0);// 0=1st

		$db = new array_db($ADD_DB_IMG);
		if($db->db_not_empty()){

		//remove reported images
			if($settings['SET_REMOVE_REPORT']){
				$db_report = new array_db($ADD_DB_REPORT);
				if($db_report->db_not_empty()){
					$db_report_full = $db_report->fetch_all();
					foreach ($db_report_full as $k => $v) {
						 $db->remove_row('id',$v['id']);
					}
				}
			}

		//remove private images
			if($settings['SET_PRIVATE_IMG_ON']){
				$db->remove_row('private',1,'rows');
			}

		// workout start - stop
			$img_star_on	= $page_number*$settings['SET_IMG_ON_PAGE'];
			$img_end_on		= (($img_star_on+$settings['SET_IMG_ON_PAGE'])>$db->db_count() ? $db->db_count() : $img_star_on+$settings['SET_IMG_ON_PAGE']);

		// page pagination
			$pagination		= pagination($page_number, $settings['SET_IMG_ON_PAGE'], $db->db_count());

		//inline ad
			$inline_ad='';
			if($settings['SET_GOOGLE_ADS'] !=''){
				$inline_ad = '<div class="gallery_ad">'.$gallery_AdSense.'</div>';
			}

		// order image db by new to old
			$db->order_by('added',321);

			$new_row=1;
			$ad_row =0;

		// make gallery
			$img_gallery ='<ul class="gallery">';
			for ($i = $img_star_on; $i < $img_end_on; $i++) {

				$db_img = $db->fetch_key_value($i);

			// page var
				$thumb_mid_link	= get_thumb_mid_address($db_img['id'],"pm",$db_img); 
				$thumb_url		= get_thumb_address($db_img['id'],"dt",$db_img);

			//see if there is a alt(title) if not use the image name
				$alt_text = ($db_img['alt'] !="" ? $db_img['alt']:$db_img['name']);

			//image list for page
				$img_gallery .= '<li><a href="'.$thumb_mid_link.'" title="'.$alt_text.'" class="thumb" >
								<img src="'.$thumb_url.'" alt="'.$alt_text.'"/>
								</a><h2><a href="'.$thumb_mid_link.'" title="'.$alt_text.'">'.$alt_text.'</a></h2>';

				if($settings['SET_ALLOW_REPORT']){
					$img_gallery .='<div class="img_report"><a rel="nofollow" href="#" title="'.$LANGUAGE_PACK["site_gallery_report_title"].'" onclick="return doconfirm(\''.$LANGUAGE_PACK["site_gallery_report_this"].'\','.$db_img['id'].','.($page_number+1).');">'.$LANGUAGE_PACK["site_gallery_report"].'</a></div>';
				}

				$img_gallery .='</li>';

				if($new_row == 4 && $i != ($img_end_on-1)){
					$img_gallery .= '</ul>'.($ad_row ==0?$inline_ad:'').'<ul class="gallery">';
					$new_row = 1;
					$ad_row++;
				}else $new_row++;

			}//	endfor
			
			$img_gallery .= '</ul>'.$pagination;

		}//end db image count


// gallery end
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
// MAKE PAGE END

	$menu="gallery";
	$page_title = $page_number == 0 ? ' - '.$LANGUAGE_PACK["site_gallery_page_title"].' 1':' - '.$LANGUAGE_PACK["site_gallery_page_title"].' '.($page_number+1);
	include_once('header.php');
		error_note($Err);
		success_note($Suc);
		echo (isset($img_gallery) ? $img_gallery : error_note($LANGUAGE_PACK["site_gallery_err_no_image"]));
	include_once('footer.php');

// MAKE PAGE END
////////////////////////////////////////////////////////////////////////////////////
?>