<?php
//
//   CF Image Hosting Script v1.3.8
//   -------------------------------
//
//   Author:    codefuture.co.uk
//   Version:   1.3.8
//   Date:      14-Aug-10
//
//   download the latest version from - http://codefuture.co.uk/projects/imagehost1.3/
//
//   Copyright (c) 2010 codefuture.co.uk
//   This file is part of the CF Image Hosting Script.
//
//   CF Image Hosting Script is free software: you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation, either version 3 of the License, or
//   (at your option) any later version.
//
//   CF Image Hosting Script is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//   You should have received a copy of the GNU General Public License
//   along with CF Image Hosting Script.  If not, see http://www.gnu.org/licenses/.
//
////////////////////////////////////////////////////////////////////////////////////

//debug
	error_reporting(E_ERROR | E_WARNING | E_PARSE | E_NOTICE);
// Hide all error messages from the public
	//error_reporting(E_ALL^E_NOTICE);
	//ini_set('display_errors', 0);

	include_once('lib/arraydb.class.php');

// Upload directory 
	$DIR_UPLOAD		= 'upload/';
	$DIR_IMAGE		= $DIR_UPLOAD.'images/';
	$DIR_THUMB_MID	= $DIR_UPLOAD.'thumbs/';
	$DIR_THUMB		= $DIR_UPLOAD.'smallthumbs/';
	$DIR_DATA		= $DIR_UPLOAD.'data/';
	$DIR_TEMP		= $DIR_UPLOAD.'temp/';

// DB addresss
	$ADD_DB_IMG		= $DIR_DATA.'imgdb.ihdb';
	$ADD_DB_COUNT	= $DIR_DATA.'imgdbcount.ihdb';
	$ADD_DB_BAN		= $DIR_DATA.'ban.ihdb';
	$ADD_DB_REPORT	= $DIR_DATA.'report.ihdb';
	$ADD_DB_SET		= $DIR_DATA.'settings.cdb';

//load settings
	$setting_db = new array_db($ADD_DB_SET);
	$settings	= $setting_db->fetch_all();
// LANGUAGE PACK
	if(isset($_GET['lang'])){
		setcookie('lang', input($_GET['lang']), null);
		if (file_exists('languages/'.input($_GET['lang']).'.lang.php'))
			$settings['SET_LANGUAGE'] = input($_GET['lang']);
	}

	if(	isset($_COOKIE['lang']) && file_exists('languages/'.$_COOKIE['lang'].'.lang.php') && !isset($_GET['lang']))
		$settings['SET_LANGUAGE'] = $_COOKIE['lang'];

	if(isset($settings['SET_LANGUAGE']) && file_exists('languages/'.$settings['SET_LANGUAGE'].'.lang.php'))
		@require('languages/'.$settings['SET_LANGUAGE'].'.lang.php');
	else{
		@require('languages/english.lang.php');
		$settings['SET_LANGUAGE'] = 'english';
	}

// Make sure the install.php file is deleted for normal usage
	if (file_exists('install.php')){
		include_once('install.php');
		exit();
	}

	
// upload image size(pixels)
	$IMG_MIN_SIZE = '16';
	$IMG_MAX_SIZE = '1920';

//Small Thumb settins
	$THUMB_OPTION = 'auto';//crop, auto, exact
	$THUMB_MAX_WIDTH = 170;
	$THUMB_MAX_HEIGHT = 170;
	$THUMB_SAVE_EXT = 'png'; // jpg, png, gif
	$THUMB_QUALITY = 75; //1-100

//Thumb settins
	$THUMB_MID_OPTION = 'auto';//crop, auto, exact
	$THUMB_MID_MAX_WIDTH = 350;
	$THUMB_MID_MAX_HEIGHT = 350;
	$THUMB_MID_SAVE_EXT = 'png'; // jpg, png, gif
	$THUMB_MID_QUALITY = 75; //1-100 

// Image Formats
	$accepted = array('png', 'jpg', 'jpeg', 'gif', 'bmp');
	$acceptedtyp = array('image/png', 'image/x-png', 'image/pjpeg', 'image/jpg', 'image/jpeg', 'image/gif', 'image/bmp');
	$types = implode(", ",$accepted);

//other global var
	$Err = '';
	$Suc = '';

// AdSense Codes
	include_once('AdSense.php');

/////////////////////////////////////////////////////////////////////////////////////////////
//auto run

// see if we need to reset bandwidth
if($settings['SET_MAX_BANDWIDTH'] !=0){
	if(!file_exists($DIR_DATA.date($settings['SET_BANDWIDTH_RESET']))){
		if(bandwidth_reset()){
			if(savefile(array(),$DIR_DATA.date($settings['SET_BANDWIDTH_RESET']))){
				if(file_exists($DIR_DATA.(date($settings['SET_BANDWIDTH_RESET'])-1))){
					unlink ($DIR_DATA.(date($settings['SET_BANDWIDTH_RESET'])-1));
				}
			}
		}
	}
}

//run auto delete
	autoDeleted();

////////////////////////////////////////////////////////////////////////////////////
// functions
////////////////////////////////////////////////////////////////////////////////////

function watermarkImage ($SourceFile, $WaterMarkText,$position=1) {

	list($width, $height) = getimagesize($SourceFile);
	$extension = strtolower(strrchr($SourceFile, '.'));
	switch($extension){
		case '.jpg':
		case '.jpeg':
			$image  = @imagecreatefromjpeg($SourceFile);
			break;
		case '.gif':
			$image  = @imagecreatefromgif($SourceFile);
			break;
		case '.png':
			$image  = @imagecreatefrompng($SourceFile);
			break;
		default:
			$image  = false;
			break;
	}

// the location on the server that the font can be found
	$font = 'lib/font/arial.ttf';
// size of the font
	$font_size = 10;

// in this case, the color is white, but you can replace the numbers with the RGB values
// of any color you want
	$color = imagecolorallocate($image, 255,255,255);

// make our drop shadow color
	$black = imagecolorallocate($image, 0,0,0);

// $dest_x - pixels to the right from the leftmost part of the image
// $dest_y - pixels down from the top of the image
	$dest_x = 4;
	$watermark_height = $font_size + 2;
	if ($position) {
		$dest_y = $height - $watermark_height;
	}else{
		$dest_y = 15;
	}

// $image - the base image file we specified above
// 0 - the angle of the text
// $WaterMarkText - the text we're overlaying the image with
	ImageTTFText ($image, $font_size, 0, ($dest_x+1), ($dest_y+1), $black, $font,$WaterMarkText);
	ImageTTFText ($image, $font_size, 0, $dest_x, $dest_y, $color, $font,$WaterMarkText);

	header("Content-type: image/png");
	imagepng($image);
	imagedestroy($image);

}

function savefile($menu_array=array(),$fileaddress){
	if($fp = @fopen($fileaddress, 'w+')){
		fwrite($fp, serialize($menu_array));
		fclose($fp);
		return true;
	}else
		return false;
}

function report_img($id,$ip){
	global	$ADD_DB_IMG,$ADD_DB_REPORT,$settings,$Err,$Suc,$LANGUAGE_PACK;

	$id = input($id);
	$ip = input($ip);
	
	$db = new array_db($ADD_DB_IMG);
	if($db -> item_exists('id',$id)){
		$db_report = new array_db($ADD_DB_REPORT);

		if(!$db_report -> item_exists('id',$id)){
			$db_report -> add_row(array('id'=>$id,'date'=>time(),'ip'=> $ip,'count' => 1));
		}else{
			$add_one = $db_report -> fetch_value('id',$id,'count')+1;
			$db_report -> set_value('id',$id,'count',$add_one);
		}

		if($db_report -> save_db_now()){
			$Suc['image_report'] = $LANGUAGE_PACK["site_gallery_report_suc"];
			if ($settings['SET_EMAIL_REPORT'] && $settings['SET_CONTACT'] !='') {
				$subject = "Image Reported on ".$settings['SET_TITLE'];
				$message  = "image reported : ".$settings['SET_SITEURL']."/".get_image_address($id,'')." \r\n";
				$message .= "reported on : ".$settings['SET_TITLE']." \r\n";
				$message .= "reported IP : ".$ip." \r\n";
				$message .= "Admin Panel : ".$settings['SET_SITEURL']."/admin.php \r\n";
				$headers = "From:".$settings['SET_CONTACT']." <".$settings['SET_CONTACT'].">";
				mail($settings['SET_CONTACT'],$subject,$message,$headers);
			}
		}else
			$Err['error_reporting'] = $LANGUAGE_PACK["site_gallery_report_err_reporting"];
		return true;
	}
	$Err['cant_find_image'] = $LANGUAGE_PACK["site_gallery_report_err_find"];
}

function hotlink($ref=''){
	global $settings;
	$referrer		= $ref !='' ? $ref:getenv( "HTTP_REFERER" );
	$ref_address	= explode('/',str_replace('www.', '', str_replace('http://', '',$referrer)));
	$home_address	= explode('/',str_replace('www.', '', str_replace('http://', '',$settings['SET_SITEURL'])));
	if($ref_address[0] == $home_address[0])
		return false;
	return true;
}

function not_max_bandwidth($id){
	global	$settings,$ADD_DB_COUNT;

	if(!hotlink() || $settings['SET_MAX_BANDWIDTH'] == 0)return true;
	$img_var = array('size','thumbsize','sthumbsize');
	$db = new array_db($ADD_DB_COUNT);
	if (!$db->db_not_empty())return true;
	if (($settings['SET_MAX_BANDWIDTH']*1048576) > $db->fetch_value('id',$id,'bandwidth'))
		return true;
	else{
		header('Content-type: image/png');
		readfile('../img/bandwidth.png');
		exit();
	}
	return true; 
}

function bandwidth_reset($id=null){
	global $ADD_DB_COUNT;
	$db = new array_db($ADD_DB_COUNT);
	$done = 0;
	if(!$db->db_not_empty())return true;
	$db_count = $db->fetch_all();
	foreach ($db_count  as $k => $v){
		if($id == null || $id == $v['id']){
			$db_count[$k]['bandwidth'] = 0;
			$done = 1;
			break;
		}
	}
	if($done == 1)
		$db->set_db($db_count);
		if ($db->save_db_now())
			return true;
	return false;
}

function shorturl_url( $url, $api=null){
	global $settings;

	$shorturl = '';
	if($api==null){
		if($settings['SET_SHORT_URL_API'] == 'b54'){
			$api = 'yourls';
			$settings['SET_SHORT_URL_API_URL'] = 'http://www.b54.in/api/';
		}else
			$api = $settings['SET_SHORT_URL_API'];
	}

	switch( $api ) {

		case 'yourls':
			$api_url = sprintf( $settings['SET_SHORT_URL_API_URL'] . '?username=%s&password=%s&url=%s&format=text&action=shorturl&source=plugin',
				$settings['SET_SHORT_URL_USER'], $settings['SET_SHORT_URL_PASS'], urlencode($url) );
			$shorturl = shorturl_url_simple( $api_url );
			/*$shorturl = shorturl_url_xml( $api_url,'#<shorturl(?:\s+[^>]+)?>(.*?)'.'</shorturl>#s');*/
			break;

		case 'bitly':
			$api_url = sprintf( 'http://api.bit.ly/v3/shorten?longUrl=%s&login=%s&apiKey=%s&format=xml',
				urlencode($url), $settings['SET_SHORT_URL_USER'], $settings['SET_SHORT_URL_PASS'] );
			$shorturl = shorturl_url_xml( $api_url,'!<url>[^<]+</url>' );
			break;


		case 'tinyurl':
			$api_url = sprintf( 'http://tinyurl.com/api-create.php?url=%s', urlencode($url) );
			$shorturl = shorturl_url_simple( $api_url );
			break;

		case 'isgd':
			$api_url = sprintf( 'http://is.gd/api.php?longurl=%s', urlencode($url) );
			$shorturl = shorturl_url_simple( $api_url );
			break;

		default:
			$shorturl='';
	}
	return $shorturl;
}
function shorturl_url_xml($shorter_url,$preg_match){
	$ch = @curl_init();
	curl_setopt($ch, CURLOPT_URL, $shorter_url);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	$ShortURL = curl_exec($ch);
	curl_close($ch);
	preg_match($preg_match, $ShortURL, $elements);
	print_r($elements);
	return $elements[1];
}
function shorturl_url_simple($shorter_url){
	return @file_get_contents($shorter_url);
}

function error_note($myproblem) {
	global $LANGUAGE_PACK;
	$err = '';
	if(!empty($myproblem) && is_array($myproblem)){
		foreach($myproblem as $v){
			$err .='<div id="err" class="notification error"><div><b>'.$LANGUAGE_PACK["site_notification_error"].' :</b> '.$v.'</div></div>';
		}
	}elseif(!empty($myproblem) && !is_array($myproblem)){
		$err ='<div id="err" class="notification error"><div><b>'.$LANGUAGE_PACK["site_notification_error"].' :</b> '.$myproblem.'</div></div>';
	}
	echo $err;
}

function success_note($mysuccess) {
	global $LANGUAGE_PACK;
	$suc = '';
	if(!empty($mysuccess) && is_array($mysuccess)){
		foreach($mysuccess as $v){
			$suc .= '<div id="suc" class="notification success"><div><b>'.$LANGUAGE_PACK["site_notification_success"].' :</b> '.$v.'</div></div>';
		}
	}elseif(!empty($mysuccess) && !is_array($mysuccess)){
		$suc = '<div id="err" class="notification error"><div><b>'.$LANGUAGE_PACK["site_notification_success"].' :</b> '.$mysuccess.'</div></div>';
	}
	echo $suc;
}

function input($in){
	$in = trim($in);
	if (strlen($in) == 0)
		return;
	return htmlspecialchars(stripslashes($in));
}

function removeSymbols($string) {
	$symbols = array('/','\\','\'','"',',','.','<','>','?',';',':','[',']','{','}','|','=','+','-','_',')','(','*','&','^','%','$','#','@','!','~','`');
	for ($i = 0; $i < count($symbols); $i++) {
		$string = str_replace($symbols[$i],' ',$string);
	}
	return trim($string);
}

function bookmarking($document_url,$document_title){
	$social_sites = array(
		"Digg"				=> "http://digg.com/submit?phase=2&url={url}&title={title}",
		"del.icio.us"		=> "http://del.icio.us/post?url={url}&title={title}",
		"Google Bookmarks"	=> "http://www.google.com/bookmarks/mark?op=edit&bkmk={url}&title={title}",
		"Windows Live"		=> "https://favorites.live.com/quickadd.aspx?url={url}&title={title}",
		"Facebook"			=> "http://www.facebook.com/sharer.php?u={url}&t={title}",
		"StumbleUpon"		=> "http://www.stumbleupon.com/submit?url={url}&title={title}",
		"Twitter"			=> "http://twitter.com/home?status={title} - {url}",
		"Google buzz"		=> "http://www.google.com/reader/link?url={url}&title={title}",
		);

	krsort($social_sites);
	$text = '<div class="bookmarking">';

// write all the social bookmarking links to the page
	foreach($social_sites as $social_site=>$social_url){

	// strip special chars to make a valid icon filename
		$social_icon = strtolower(preg_replace('/[^a-zA-Z0-9]/', '', $social_site));

	// replace vars {title} and {url} in $social_url
		$url = str_replace("{title}",urlencode($document_title),str_replace('{url}',urlencode($document_url),$social_url));

		$text .= ' <a href="'.$url.'" title="'.$social_site.'" rel="nofollow"><img src="img/'.$social_icon.'.png" alt="Submit to '.$social_site.'" /></a>';
	}
	$text .= '</div>';
	return $text;
}


function get_thumb_address($id,$linktype=""){
	global $DIR_THUMB,$THUMB_SAVE_EXT,$settings;
	$fileaddress = $DIR_THUMB.$id.'.'.$THUMB_SAVE_EXT;

	$file_ext = '.html';
	if($linktype=='dt'){
		$file_ext = '.'.$THUMB_SAVE_EXT;
	}
	if (file_exists($fileaddress)){
		if (!empty($linktype)){
			if($settings['SET_MOD_REWRITE']){
				return $settings['SET_SITEURL'].'/'.$linktype.'-'.$id.$file_ext;//.$THUMB_SAVE_EXT;
			}else{
				return $settings['SET_SITEURL'].'/?'.$linktype.'='.$id;
			}
		}elseif (empty($linktype))
			return $fileaddress;
	}
}

function get_thumb_mid_address($id,$linktype=""){
	global $DIR_THUMB_MID,$THUMB_MID_SAVE_EXT,$settings;
	$fileaddress = $DIR_THUMB_MID.$id.'.'.$THUMB_MID_SAVE_EXT;
	$file_ext = '.html';
	if($linktype=='dm'){
		$file_ext = '.'.$THUMB_MID_SAVE_EXT;
	}
	if (file_exists($fileaddress)){
		if (!empty($linktype)){
			if($settings['SET_MOD_REWRITE']){
				return $settings['SET_SITEURL'].'/'.$linktype.'-'.$id.$file_ext;//.$THUMB_MID_SAVE_EXT;
			}else{
				return $settings['SET_SITEURL'].'/?'.$linktype.'='.$id;
			}
		}
		elseif (empty($linktype))
			return $fileaddress;
	}
	return false;
}

function get_image_address($id,$linktype=''){
	global	$DIR_IMAGE,
			$ADD_DB_IMG,
			$settings;
	$db = new array_db($ADD_DB_IMG);
	$ext = strtolower($db->fetch_value('id',$id,'ext'));

	if (isset($ext)){
		$fileaddress = $DIR_IMAGE.$id.'.'.$ext;
		if (file_exists($fileaddress)){
			if (!empty($linktype)){
				if($settings['SET_MOD_REWRITE']){
					return $settings['SET_SITEURL'].'/'.$linktype.'-'.$id.'.'.$ext;
				}else{
					return $settings['SET_SITEURL'].'/?'.$linktype.'='.$id;
				}
			}
			elseif (empty($linktype))
				return $fileaddress;
		}
	}
	return false;
}


function autoDeleted(){
	global	$ADD_DB_COUNT,$ADD_DB_IMG,$settings,$DIR_DATA;

	if(!$settings['SET_AUTO_DELETED'])return;
	if(file_exists($DIR_DATA.'ad'.date($settings['SET_AUTO_DELETED_JUMP'])))return;

//load img counter
	$db = new array_db($ADD_DB_IMG);
	$db_counter = new array_db($ADD_DB_COUNT);

	$db_img = $db -> fetch_all();
	$db_count = $db_counter -> fetch_all();
	foreach ($db_img as $k => $v){
	
		$done = 0;
		if (!empty($db_count)){
			foreach ($db_count as $k_c => $v_c){
			
				if ($v_c['id'] == $v['id']){
					if( round(((time() - $v_c['date']) / 86400),2) >= $settings['SET_AUTO_DELETED_TIME']){
						$done = 1;
						$delete_id[] = array('id' => $v['id'], 'k' => $k);
					}
					break;
				}
			}
		}
		if($done == 0){
			if( round(((time() - $v['added']) / 86400),2) >= $settings['SET_AUTO_DELETED_TIME'])
				$delete_id[] = array('id' => $v['id'], 'k' => $k);
		}
	}

//delete images
//reload img db
	if(!empty($delete_id)){
		foreach ($delete_id as $k => $v){
		//get image id
			$img_del_id = $v['id'];
		// Remove Image
			@unlink(get_image_address($img_del_id,'',$db_img));
		// Remove small thumb
			@unlink(get_thumb_address($img_del_id));
		// Remove thumb
			@unlink(get_thumb_mid_address($img_del_id));
		// Remove link from array
			unset($db_img[$v['k']]);
		}
		$db->set_db($db_img);
		$db->save_db_now();
	}

	if(savefile(array(),$DIR_DATA.'ad'.date($settings['SET_AUTO_DELETED_JUMP']))){
		if(file_exists($DIR_DATA.'ad'.(date($settings['SET_AUTO_DELETED_JUMP'])-1))){
			unlink ($DIR_DATA.'ad'.(date($settings['SET_AUTO_DELETED_JUMP'])-1));
		}
	}
}

function countSave($img_id,$img_typ){
	global $ADD_DB_COUNT,$ADD_DB_IMG;

	$db = new array_db($ADD_DB_COUNT);
	$db_img = new array_db($ADD_DB_IMG);
	$image_typ = ($img_typ == 1 ? 'image':($img_typ == 2 ? 'thumb_mid':($img_typ == 3 ? 'thumb':'gallery')));
	$image_bandwidth = $db_img->fetch_value('id',$img_id,($img_typ == 1 ? 'size':($img_typ == 2 ? 'thumbsize':'sthumbsize')));

	if ($db->item_exists('id',$img_id)){
		if ($img_typ == 1) $db -> set_value('id',$img_id,'date',time());
		$count = $db -> fetch_value('id',$img_id,$image_typ)+1;
		$db -> set_value('id',$img_id,$image_typ,$count);
		if($img_typ!=4){
			$new_bw = $db -> fetch_value('id',$img_id,'bandwidth') + $image_bandwidth;
			$db -> set_value('id',$img_id,'bandwidth',$new_bw);
		}
	}else{
		$newdb = array(	'id'		=> $img_id,
						'date'		=> time(),
						'image'		=> ($img_typ == 1 ? 1:0),
						'thumb_mid'	=> ($img_typ == 2 ? 1:0),
						'thumb'		=> ($img_typ == 3 ? 1:0),
						'gallery'	=> ($img_typ == 4 ? 1:0),
						'bandwidth'	=> $image_bandwidth,
					);
		$db->add_row($newdb);
	}
	if ($db->save_db_now())
		return true;
}

function format_size($size="",$file="") {
	if (empty($size) && !empty($file)) $size = @filesize($file);

	if (strlen($size) <= 9 && strlen($size) >= 7){
		$img_size = substr(number_format($size / 1048576,2), -2) == '00' 
					? number_format($size / 1048576,0):number_format($size / 1048576,2);
		$img_size .= " MB";
	}elseif (strlen($size) >= 10){
		$img_size = substr(number_format($size / 1073741824,2), -2) == '00' 
					? number_format($size / 1073741824,0):number_format($size / 1073741824,2);
		$img_size .= " GB";
	}else $img_size = number_format($size / 1024,0)." kb";

	return $img_size;
}

function checklogin() {
	global $settings;
	if(isset($_SESSION['loggedin'])){
		if ($_SESSION['set_name'] == md5($settings['SET_USERNAME'].$settings['SET_SALTING'])){
			return true;
		}else{
			session_unset();
			session_destroy();
		}
	}
	return false;
}

function pagination($page_number,$items_on_page,$item_count,$page_name="",$ex_var=""){
	global $settings;

	$link_mod	= (!$settings['SET_MOD_REWRITE'] ? '?p=':( $page_name =='' ? 'page':'?p='));
	$ex_var		= (!$settings['SET_MOD_REWRITE'] ? $ex_var:( $page_name =='' ? '.html':$ex_var));

	$number_of_pages = ceil($item_count/$items_on_page);
	if (($number_of_pages*$items_on_page) < $item_count) $number_of_pages++;

	$pagination ='<div class="pagination">';
	$pagination .=($page_number>0 ? '<a href="'.$page_name.$link_mod.($page_number).$ex_var.'">&lt;</a>':'<span class="disabled">&lt;</span>');

	for ($i = 1; $i <= $number_of_pages; $i++) {
		if($i>($page_number-4) && $i<($page_number+5)){
			$pagination .=($i==$page_number+1 ? '<span class="current">'.$i.'</span>':'<a href="'.$page_name.$link_mod.$i.$ex_var.'">'.$i.'</a>');
		}else if($i<($page_number-3)){
			$pagination .='<a href="'.$page_name.$link_mod.'1'.$ex_var.'">1</a>...';
			$i=$page_number-3;
		}else if($i>($page_number+4)){
			if ($i !=($number_of_pages)) $pagination .='...';
			$pagination .='<a href="'.$page_name.$link_mod.($number_of_pages).$ex_var.'">'.($number_of_pages).'</a>';
			$i=$number_of_pages;
		}
	}

	$pagination .=($page_number<($number_of_pages-1) ? '<a href="'.$page_name.$link_mod.($page_number+2).$ex_var.'">&gt;</a>':'<span class="disabled">&gt;</span>');
	$pagination .='</div>';
	return $pagination;
}

////////////////////////////////////////////////////////////////////////////////////
// Start session
	session_name();
	if (!session_start()) {
		$Err['session_error'] = $LANGUAGE_PACK["admin_session_error"];
	}
?>