<?php
//
//   CF Image Hosting Script v1.3.8
//   -------------------------------
//
//   Author:    codefuture.co.uk
//   Version:   1.3.8
//   Date:      14-Aug-10
//
//   download the latest version from - http://codefuture.co.uk/projects/imagehost1.3/
//
//   Copyright (c) 2010 codefuture.co.uk
//   This file is part of the CF Image Hosting Script.
//
//   CF Image Hosting Script is free software: you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation, either version 3 of the License, or
//   (at your option) any later version.
//
//   CF Image Hosting Script is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//   You should have received a copy of the GNU General Public License
//   along with CF Image Hosting Script.  If not, see http://www.gnu.org/licenses/.
//
////////////////////////////////////////////////////////////////////////////////////

	include_once('inc/config.php');

	if($settings['SET_HIDE_SEARCH']){
		header('Location: index.php');
		exit();
	}

////////////////////////////////////////////////////////////////////////////////////
// gallerie start

	// see what page we are on
		$page_number = (isset($_GET['p']) ? input($_GET['p'])-1:0);// 0=1st

		$db = new array_db($ADD_DB_IMG);
		$db_found = new array_db();

//////////////////////////////////////////////////

	$string = '';

	if( !empty ( $_GET['search'] ) ){
		$string = input($_GET['search']);
		$clean_string = new cleaner();
		$stemmed_string = $clean_string->parseString($string);

		if(!empty($stemmed_string)){

			$new_string = '';
			foreach ( array_unique ( split ( " ",$stemmed_string ) ) as $array => $value ){
				if(strlen($value) > 2)
					$new_string .= ''.$value.' ';
			}
			$new_string = substr ( $new_string,0, ( strLen ( $new_string ) -1 ) );
			if ( strlen ( $new_string ) > 2 ){
				$db_found->set_db($db->db_search($new_string,array('alt','name')));
			}else//strlen more them 3
				$Err['site_search'] = $LANGUAGE_PACK["site_search_err_short"];
		}
	}else//search is not empty
		$Err['site_search'] = $LANGUAGE_PACK["site_search_err_blank"];

///////////////////////////////////////////////////

	// count images in db to see if we need to make a page
		if($db_found->db_not_empty()){

		// workout start - stop
			$img_star_on	= $page_number*$settings['SET_IMG_ON_PAGE'];
			$img_end_on		= (($img_star_on+$settings['SET_IMG_ON_PAGE'])>$db_found->db_count() ? $db_found->db_count() : $img_star_on+$settings['SET_IMG_ON_PAGE']);

		// page pagination
			$pagination		= pagination($page_number, $settings['SET_IMG_ON_PAGE'], $db_found->db_count(),'search.php','&search='.$string);

		//inline ad
			$inline_ad='';
			if($settings['SET_GOOGLE_ADS'] !=''){
				$inline_ad = '<div class="gallery_ad">'.$gallery_AdSense.'</div>';
			}
			$new_row = 1;
			$ad_row = 0;
		// order image db by new to old
			$db_found->order_by('added',321);

		// make gallery
			$img_gallery ='<ul class="gallery">';
			for ($i = $img_star_on; $i < $img_end_on; $i++) {

				$db_img = $db_found->fetch_key_value($i);

			// page var
				$thumb_mid_link	= get_thumb_mid_address($db_img['id'],"pm",$db_img); 
				$thumb_url		= get_thumb_address($db_img['id'],"dt",$db_img);

			//see if there is a alt(title) if not use the image name
				$alt_text = ($db_img['alt'] !="" ? $db_img['alt']:$db_img['name']);

			//image list for page
				$img_gallery .= '<li><a href="'.$thumb_mid_link.'" title="'.$alt_text.'" class="thumb" >
								<img src="'.$thumb_url.'" alt="'.$alt_text.'"/>
								</a><h2><a href="'.$thumb_mid_link.'" title="'.$alt_text.'">'.$alt_text.'</a></h2>';

				if($settings['SET_ALLOW_REPORT']){
					$img_gallery .='<div class="img_report"><a rel="nofollow" href="#" title="'.$LANGUAGE_PACK["site_gallery_report_title"].'" onclick="return doconfirm(\''.$LANGUAGE_PACK["site_gallery_report_this"].'\','.$db_img['id'].','.($page_number+1).');">'.$LANGUAGE_PACK["site_gallery_report"].'</a></div>';
				}

				$img_gallery .='</li>';

				if($new_row == 4){
					$img_gallery .= '</ul>'.($ad_row ==0?$inline_ad:'').'<ul class="gallery">';
					$new_row = 1;
					$ad_row++;
				}else $new_row++;

			}//	endfor
			
			$img_gallery .= '</ul>'.$pagination;

		}//end db image count


// gallerie end
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
// MAKE PAGE END

	$menu = 'gallery';
	$page_title = $page_number == 0 ? ' - '.$LANGUAGE_PACK["site_search_page_title"].' '.$string.' Page 1':' - '.$LANGUAGE_PACK["site_search_page_title"].' '.$string.' Page '.($page_number+1);
	include_once('header.php');
		echo error_note($Err);
		
		if (isset($img_gallery)){
			echo '<h4>'.sprintf($LANGUAGE_PACK["site_search_results"],'<span class="search_for">'.$db_found->db_count().'</span>').' <span class="search_for">'.$string.'</span></h4>';
			echo $img_gallery;
		}else{
			echo '<h4>'.$LANGUAGE_PACK["site_search_no_results"].' <span class="search_for">'.$string.'</span></h4>';
			echo '<p>'.$LANGUAGE_PACK["site_search_suggestions"].'</p>';
		}

	include_once('footer.php');

// MAKE PAGE END
////////////////////////////////////////////////////////////////////////////////////

class Cleaner {

	var $stopwords = array(" find ", " about ", " me ", " ever ", " each ", " the ", " jpg ", " gif ", " png ", " bmp ");//you need to extend this big time.
	var $symbols = array('/','\\','\'','"',',','.','<','>','?',';',':','[',']','{','}','|','=','+','-','_',')','(','*','&','^','%','$','#','@','!','~','`'	);//this will remove punctuation

	function parseString($string) {
		$string = ' '.$string.' ';
		$string = $this->removeStopwords($string);
		$string = $this->removeSymbols($string);
		return $string;
	}
	
	function removeStopwords($string) {
		for ($i = 0; $i < sizeof($this->stopwords); $i++) {
			$string = str_replace($this->stopwords[$i],' ',$string);
		}

		return trim($string);
	}

	function removeSymbols($string) {
		for ($i = 0; $i < sizeof($this->symbols); $i++) {
			$string = str_replace($this->symbols[$i],' ',$string);
		}

		return trim($string);
	}
}


?>