<?php

/**
 * @package : PowerBBSystemFunctions
 * @author1 : MaaSTaaR <MaaSTaaR@hotmail.com>
 * @author2 : abuamal <abdullah@kuwaitphp.com>
 * @author3 : AbuRakan <pbboard@pbboard.com>
 * @start : 23/9/2006 -> The first day of Ramadan 1427 :)
 * @Update : 20/9/2010 -> Ramadan 1431 :)

 */

class PowerBBSystemFunctions
{
	var $Engine;

	function PowerBBSystemFunctions($Engine)
	{
		$this->Engine = $Engine;
	}

	function ListProc(&$rows,$x,$param)
	{
		if (empty($param['proc']))
		{
			trigger_error('ERROR::NEED_PARAMETER',E_USER_ERROR);
		}

		if (is_array($param['proc']))
		{
			foreach ($param['proc'] as $f => $p)
			{
				if (!is_array($p['method']))
				{
					if ($p['method'] == 'clean')
					{
						if ($f == '*')
						{
							$this->CleanVariable($rows[$x],$p['param']);
						}
						else
						{
							if (!empty($p['store']))
							{
								$rows[$x][$p['store']] = $this->CleanVariable($rows[$x][$f],$p['param']);
							}
							else
							{
								$rows[$x][$f] = $this->CleanVariable($rows[$x][$f],$p['param']);
							}
						}
					}
					elseif ($p['method'] == 'date')
					{
						if (is_numeric($rows[$x][$f]))
						{
							if (!empty($p['store']))
							{
								$rows[$x][$p['store']] = $this->date($rows[$x][$f],$p['type']);
							}
							else
							{
								$rows[$x][$f] = $this->date($rows[$x][$f],$p['type']);
							}
						}
						else
						{
							if (!empty($rows[$x][$p['store']]))
							{
								$rows[$x][$p['store']] = $rows[$x][$f];
							}
							else
							{
								$rows[$x][$f] = $rows[$x][$f]; // Very Power line :p
							}
						}
					}
					elseif ($p['method'] == 'time')
					{
						if (is_numeric($rows[$x][$f]))
						{
							if (!empty($p['store']))
							{
								$rows[$x][$p['store']] = $this->time($rows[$x][$f]);
							}
							else
							{
								$rows[$x][$f] = $this->time($rows[$x][$f]);
							}
						}
						else
						{
							if (!empty($p['store']))
							{
								$rows[$x][$p['store']] = $rows[$x][$f];
							}
							else
							{
								$rows[$x][$f] = $rows[$x][$f];
							}
						}
					}
					elseif ($p['method'] == 'list')
					{
						$rows[$p['store']][$rows[$x][$p['id']]] = $rows[$x][$f];
					}
					elseif ($p['method'] == 'replace')
					{
						if (strstr($p['replace'],'rows{'))
						{
							$text = str_replace('rows{','',$p['replace']);
							$text = str_replace('}','',$text);

							$replace = $rows[$x][$text];
						}
						else
						{
							$replace = $p['replace'];
						}

						$rows[$x][$p['store']] = str_replace($p['search'],$replace,$rows[$x][$f]);
					}
					else
					{
						trigger_error('ERROR::BAD_VALUE_OF_METHOD_VARIABLE',E_USER_ERROR);
					}
				}
				else
				{
					if (in_array('clean',$p['method']))
					{
						if ($f == '*')
						{
							$this->CleanVariable($rows[$x],$p['param']);
						}
						else
						{
							if (!empty($p['store']))
							{
								$rows[$x][$p['store']] = $this->CleanVariable($rows[$x][$f],$p['param']);
							}
							else
							{
								$rows[$x][$f] = $this->CleanVariable($rows[$x][$f],$p['param']);
							}
						}
					}

					if (in_array('date',$p['method']))
					{
						if (is_numeric($rows[$x][$f]))
						{
							if (!empty($p['store']))
							{
								$rows[$x][$p['store']] = $this->date($rows[$x][$f],$p['type']);
							}
							else
							{
								$rows[$x][$f] = $this->date($rows[$x][$f],$p['type']);
							}
						}
						else
						{
							if (!empty($p['store']))
							{
								$rows[$x][$p['store']] = $rows[$x][$f];
							}
							else
							{
								$rows[$x][$f] = $rows[$x][$f]; // Very Power line :p
							}
						}
					}

					if (in_array('time',$p['method']))
					{
						if (is_numeric($rows[$x][$f]))
						{
							if (!empty($p['store']))
							{
								$rows[$x][$p['store']] = $this->time($rows[$x][$f]);
							}
							else
							{
								$rows[$x][$f] = $this->time($rows[$x][$f]);
							}
						}
						else
						{
							if (!empty($p['store']))
							{
								$rows[$x][$p['store']] = $rows[$x][$f];
							}
							else
							{
								$rows[$x][$f] = $rows[$x][$f];
							}
						}
					}

					if (in_array('list',$p['method']))
					{
						$rows[$p['store']][$rows[$x][$p['id']]] = $rows[$x][$f];
					}

					if (in_array('replace',$p['method']))
					{
						if (strstr($p['replace'],'rows{'))
						{
							$text = str_replace('rows{','',$p['replace']);
							$text = str_replace('}','',$p['replace']);

							$replace = &$rows[$x][$text];
						}
						else
						{
							$replace = $p['replace'];
						}

						$rows[$x][$p['store']] = str_replace($p['search'],$replace,$rows[$x][$f]);
					}
				}
			}
		}
		else
		{
			trigger_error('ERROR::PROC_SHOULD_BE_ARRAY',E_USER_ERROR);
		}
	}

 	/**
 	 * Clean the variable from any dirty :) , we should be thankful for abuamal
 	 *
 	 * By : abuamal
 	 */
	function CleanVariable($variable, $type)
	{
		if (!is_array($variable))
		{
			return $this->SafeInput($variable,$type);
		}
		else
		{
			foreach ($variable as $key => $var)
			{
				if (is_array($var))
				{
					$this->CleanVariable($variable[$key], $type);
				}
				else
				{
					if (isset($variable[$key]))
					{
				    	$variable[$key] = $this->SafeInput($var, $type);
					}
				}
			}

			return true;
		}
	}

	/**
	 * Kill script kiddes and crackers!
	 */
	function SafeInput($var,$type)
	{
		switch ($type)
		{
			case 'sql':
				return ($var);
				break;

			case 'html':
				return htmlspecialchars($var);
				break;

			case 'intval':
				return intval($var);
				break;

			case 'trim':
				return trim($var);
				break;

			case 'unhtml':
				return $this->BackHTML($var);
				break;

			default:
				trigger_error('ERROR::BAD_VALUE_OF_TYPE_VARIABLE',E_USER_ERROR);
				break;
		}
	}

	/**
	 * Clean the local arrays (like _POST , _GET , _SERVER etc ...)
	 */
	function LocalArraySetup()
	{
		global $_GET,$_POST,$_COOKIE,$_FILES,$_SERVER;

 		// Array with names and values
 		$vars				=	array();
 		$vars['_POST'] 		= 	$_POST;
 		$vars['_GET'] 		= 	$_GET;
 		$vars['_COOKIE'] 	= 	$_COOKIE;
 		$vars['_FILES'] 	= 	$_FILES;
 		$vars['_SERVER'] 	= 	$_SERVER;

 		// Is magic quotes on or off?
  		$magic = get_magic_quotes_gpc();

		foreach ($vars as $name => $value)
		{
			$this->CleanVariable($value, 'html');

			if (!$magic
				and !empty($value))
			{
				$this->CleanVariable($value, 'sql');
			}

			$this->Engine->$name = $value;
		}

		// Sorry, but we _should_ do that!
 		unset($HTTP_POST_VARS,$HTTP_GET_VARS,$HTTP_COOKIE_VARS,$HTTP_POST_FILES,$HTTP_SERVER_VARS);
 		unset($_POST,$_GET,$_COOKIE,$_FILES,$_SERVER);
	}



	function date($input,$type = 'ty')
	{
		global $PowerBB;
        $format = $PowerBB->_CONF['info_row']['datesystem'].' '.$PowerBB->_CONF['info_row']['timesystem'];
		$input = @date($format,$input+$PowerBB->_CONF['info_row']['timestamp']);

		$this_date_today					    =	date($PowerBB->_CONF['info_row']['datesystem']);
		$this_date_yesterday					=	date($PowerBB->_CONF['info_row']['datesystem'],mktime(0, 0, 0, date("m"),date("d")-1,date("Y")));
		$this_date_before_yesterday				=	date($PowerBB->_CONF['info_row']['datesystem'],mktime(0, 0, 0, date("m"),date("d")-2,date("Y")));
		$this_date_last_week					=	date($PowerBB->_CONF['info_row']['datesystem'],mktime(0, 0, 0, date("m"),date("d")-7,date("Y")));
         /*
		$this_date_last_two_weeks				=	date($PowerBB->_CONF['info_row']['datesystem'],mktime(0, 0, 0, date("m"),date("w")-2,date("Y")));
		$this_date_last_three_weeks				=	date($PowerBB->_CONF['info_row']['datesystem'],mktime(0, 0, 0, date("m"),date("w")-3,date("Y")));
		$this_date_last_month					=	date($PowerBB->_CONF['info_row']['datesystem'],mktime(0, 0, 0, date("m"),date("w")-4,date("Y")));
		*/

		$input = str_ireplace('PM',$PowerBB->_CONF['template']['lang']['PM'],$input);
		$input = str_ireplace('AM',$PowerBB->_CONF['template']['lang']['AM'],$input);
		$input = str_replace($this_date_today,$PowerBB->_CONF['template']['lang']['Today'].' '.$this_date_today,$input);
        $input = str_replace($this_date_yesterday,$PowerBB->_CONF['template']['lang']['yesterday'].' '.$this_date_today,$input);
        $input = str_replace($this_date_before_yesterday,$PowerBB->_CONF['template']['lang']['before_yesterday'].' '.$this_date_today,$input);
        $input = str_replace($this_date_last_week,$PowerBB->_CONF['template']['lang']['last_week'].' '.$this_date_today,$input);
        $input = str_replace($this_date_last_two_weeks,$PowerBB->_CONF['template']['lang']['last_two_weeks'].' '.$this_date_today,$input);
        $input = str_replace($this_date_last_three_weeks,$PowerBB->_CONF['template']['lang']['last_three_weeks'].' '.$this_date_today,$input);
        $input = str_replace($this_date_last_month,$PowerBB->_CONF['template']['lang']['last_month'].' '.$this_date_today,$input);


		return $input;
	}

	function time($time)
	{
		global $PowerBB;
        $format = $PowerBB->_CONF['info_row']['timesystem'];
		$x = @date($format,$time);
		$x = strtolower($x);
		$x = str_ireplace('pm',$PowerBB->_CONF['template']['lang']['PM'],$x);
		$x = str_ireplace('am',$PowerBB->_CONF['template']['lang']['AM'],$x);

		return $x;
	}

	function BackHTML($text)
	{
		$text = str_replace('&amp;','&',$text);
		$text = str_replace('&lt;','<',$text);
		$text = str_replace('&quot;','"',$text);
		$text = str_replace('&gt;','>',$text);
		//$text = str_replace("\'","'",$text);
		$text = str_replace('document.cookie','',$text);
		$text = str_replace('document.location','',$text);
		$text = str_replace('javascript','',$text);



		return $text;
	}
}

?>
