<?php

/**
 * PowerBB Engine - The Engine Helps You To Create Bulletin Board System.
 */

/**
 * @package 	: 	PowerBBChat (Chat Message)
 * @author 		: 	MSHRAQ abu-rakan (xxx_abu_rakan_xxx@hotmail.com)
 * @start 		: 	17/10/2009 , 03:25 AM
 */


class PowerBBChat
{
	var $id;
	var $Engine;

	function PowerBBChat($Engine)
	{
		$this->Engine = $Engine;
	}

 	/**
 	 * Insert new Chat
 	 *
 	 * @param :
 	 *			Oh :O it's a long list
 	 */
 	function InsertChat($param)
 	{
 		if (!isset($param)
 			or !is_array($param))
 		{
 			$param = array();
 		}

		$query = $this->Engine->records->Insert($this->Engine->table['chat'],$param['field']);

		if ($param['get_id'])
		{
			$this->id = $this->Engine->DB->sql_insert_id();
		}

		return ($query) ? true : false;
 	}


	function DeleteChat($param)
	{
 		if (!isset($param)
 			or !is_array($param))
 		{
 			$param = array();
 		}

		$param['table'] = $this->Engine->table['chat'];

		$del = $this->Engine->records->Delete($param);

		return ($del) ? true : false;
	}

	/**
	 * Get the list of Chat
	 *
	 * $param =
	 *			array(	'sql_statment'	=>	'complete SQL statement',
	 *					'proc'			=>	true // When you want proccess the outputs
	 *					);
	 *
	 * @return :
	 *				array -> of information
	 *				false -> when found no information
	 */
	function GetChatList($param)
	{
 		if (!isset($param)
 			or !is_array($param))
 		{
 			$param = array();
 		}

		$param['select'] 	= 	'*';
 		$param['from'] 		= 	$this->Engine->table['chat'];

		$rows = $this->Engine->records->GetList($param);

		return $rows;
	}

	/**
	 * Get Chat info
	 *
	 * $param =
	 *			array(	'id'	=>	'the id of Supermemberlogs');
	 *
	 * @return :
	 *			array -> of information
	 *			false -> when found no information
	 */
	function GetChatInfo($param)
	{
 		if (!isset($param)
 			or !is_array($param))
 		{
 			$param = array();
 		}

		$param['select'] 	= 	'*';
		$param['from'] 		= 	$this->Engine->table['chat'];

		$rows = $this->Engine->records->GetInfo($param);

 	 	return $rows;
	}

	function GetChatNumber($param)
	{
		if (!isset($param))
		{
			$param 	= array();
		}

		$param['select'] 	= 	'*';
		$param['from'] 		= 	$this->Engine->table['chat'];

		$num = $this->Engine->records->GetNumber($param);

		return $num;
	}

	 function UpdateChat($param)
 	{
 		if (!isset($param)
 			or !is_array($param))
 		{
 			$param = array();
 		}

		$query = $this->Engine->records->Update($this->Engine->table['chat'],$param['field'],$param['where']);

		return ($query) ? true : false;
 	}
}

?>
