<?php

/**
 * PowerBB Engine - The Engine Helps You To Create Bulletin Board System.
 */

/**
 * @package 	: 	PowerBBFriends (Friendss)
 * @author 		: 	MSHRAQ abu-rakan (xxx_abu_rakan_xxx@hotmail.com)
 * @start 		: 	7/12/2009 , 03:25 AM
 */


class PowerBBFriends
{
	var $id;
	var $Engine;

	function PowerBBFriends($Engine)
	{
		$this->Engine = $Engine;
	}

 	/**
 	 * Insert new Friends
 	 *
 	 * @param :
 	 *			Oh :O it's a long list
 	 */
 	function InsertFriends($param)
 	{
 		if (!isset($param)
 			or !is_array($param))
 		{
 			$param = array();
 		}

		$query = $this->Engine->records->Insert($this->Engine->table['friends'],$param['field']);

		if ($param['get_id'])
		{
			$this->id = $this->Engine->DB->sql_insert_id();
		}

		return ($query) ? true : false;
 	}


	function DeleteFriends($param)
	{
 		if (!isset($param)
 			or !is_array($param))
 		{
 			$param = array();
 		}

		$param['table'] = $this->Engine->table['friends'];

		$del = $this->Engine->records->Delete($param);

		return ($del) ? true : false;
	}

	/**
	 * Get the list of Friends
	 *
	 * $param =
	 *			array(	'sql_statment'	=>	'complete SQL statement',
	 *					'proc'			=>	true // When you want proccess the outputs
	 *					);
	 *
	 * @return :
	 *				array -> of information
	 *				false -> when found no information
	 */
	function GetFriendsList($param)
	{
 		if (!isset($param)
 			or !is_array($param))
 		{
 			$param = array();
 		}

		$param['select'] 	= 	'*';
 		$param['from'] 		= 	$this->Engine->table['friends'];

		$rows = $this->Engine->records->GetList($param);

		return $rows;
	}

	/**
	 * Get Friends info
	 *
	 * $param =
	 *			array(	'id'	=>	'the id of Supermemberlogs');
	 *
	 * @return :
	 *			array -> of information
	 *			false -> when found no information
	 */
	function GetFriendsInfo($param)
	{
 		if (!isset($param)
 			or !is_array($param))
 		{
 			$param = array();
 		}

		$param['select'] 	= 	'*';
		$param['from'] 		= 	$this->Engine->table['friends'];

		$rows = $this->Engine->records->GetInfo($param);

 	 	return $rows;
	}

	function GetFriendsNumber($param)
	{
		if (!isset($param))
		{
			$param 	= array();
		}

		$param['select'] 	= 	'*';
		$param['from'] 		= 	$this->Engine->table['friends'];

		$num = $this->Engine->records->GetNumber($param);

		return $num;
	}

	 function UpdateFriends($param)
 	{
 		if (!isset($param)
 			or !is_array($param))
 		{
 			$param = array();
 		}

		$query = $this->Engine->records->Update($this->Engine->table['friends'],$param['field'],$param['where']);

		return ($query) ? true : false;
 	}

	function IsFriend($param)
	{
 		if (!isset($param)
 			or !is_array($param))
 		{
 			$param = array();
 		}

		$param['select'] 	= 	'*';
		$param['from'] 		= 	$this->Engine->table['friends'];

		$num = $this->Engine->records->GetNumber($param);

		return ($num <= 0) ? false : true;
	}


}

?>
